from typing import Any, List

PY3: Any
str_type = str
GRAPH_ATTRIBUTES: Any
EDGE_ATTRIBUTES: Any
NODE_ATTRIBUTES: Any
CLUSTER_ATTRIBUTES: Any
DEFAULT_PROGRAMS: Any

def is_windows() -> bool: ...
def is_anaconda() -> bool: ...
def get_executable_extension() -> str: ...
def call_graphviz(program, arguments, working_dir, **kwargs): ...

class frozendict(dict):
    __delitem__: Any
    __setitem__: Any
    clear: Any
    pop: Any
    popitem: Any
    setdefault: Any
    update: Any
    def __new__(cls, *args, **kw): ...
    def __init__(self, *args, **kw) -> None: ...
    def __hash__(self): ...

dot_keywords: Any
id_re_alpha_nums: Any
id_re_alpha_nums_with_ports: Any
id_re_num: Any
id_re_with_port: Any
id_re_dbl_quoted: Any
id_re_html: Any

def needs_quotes(s): ...
def quote_if_necessary(s): ...
def graph_from_dot_data(s) -> List['Dot']: ...
def graph_from_dot_file(path, encoding: Any | None = ...): ...
def graph_from_edges(edge_list, node_prefix: str = ..., directed: bool = ...): ...
def graph_from_adjacency_matrix(matrix, node_prefix: str = ..., directed: bool = ...): ...
def graph_from_incidence_matrix(matrix, node_prefix: str = ..., directed: bool = ...): ...

class Common:
    def __get_attribute__(self, attr): ...
    def set_parent_graph(self, parent_graph) -> None: ...
    def get_parent_graph(self): ...
    def set(self, name, value) -> None: ...
    def get(self, name): ...
    def get_attributes(self): ...
    def set_sequence(self, seq) -> None: ...
    def get_sequence(self): ...
    def create_attribute_methods(self, obj_attributes: List[str]): ...

class Error(Exception):
    value: Any
    def __init__(self, value) -> None: ...

class InvocationException(Exception):
    value: Any
    def __init__(self, value) -> None: ...

class Node(Common):
    obj_dict: Any
    def __init__(self, name: str = ..., obj_dict: Any | None = ..., **attrs) -> None: ...
    def set_name(self, node_name) -> None: ...
    def get_name(self): ...
    def get_port(self): ...
    def add_style(self, style) -> None: ...
    def to_string(self) -> str: ...

class Edge(Common):
    obj_dict: Any
    def __init__(self, src: str = ..., dst: str = ..., obj_dict: Any | None = ..., **attrs) -> None: ...
    def get_source(self): ...
    def get_destination(self): ...
    def __hash__(self): ...
    def __eq__(self, edge): ...
    def parse_node_ref(self, node_str): ...
    def to_string(self) -> str: ...

class Graph(Common):
    obj_dict: Any
    def __init__(self, graph_name: str = ..., obj_dict: Any | None = ..., graph_type: str = ..., strict: bool = ..., suppress_disconnected: bool = ..., simplify: bool = ..., **attrs) -> None: ...
    def get_graph_type(self): ...
    def get_top_graph_type(self): ...
    def set_graph_defaults(self, **attrs) -> None: ...
    def get_graph_defaults(self, **attrs): ...
    def set_node_defaults(self, **attrs) -> None: ...
    def get_node_defaults(self, **attrs): ...
    def set_edge_defaults(self, **attrs) -> None: ...
    def get_edge_defaults(self, **attrs): ...
    def set_simplify(self, simplify) -> None: ...
    def get_simplify(self): ...
    def set_type(self, graph_type) -> None: ...
    def get_type(self): ...
    def set_name(self, graph_name) -> None: ...
    def get_name(self): ...
    def set_strict(self, val) -> None: ...
    def get_strict(self, val): ...
    def set_suppress_disconnected(self, val) -> None: ...
    def get_suppress_disconnected(self, val): ...
    def get_next_sequence_number(self): ...
    def add_node(self, graph_node) -> None: ...
    def del_node(self, name, index: Any | None = ...): ...
    def get_node(self, name): ...
    def get_nodes(self): ...
    def get_node_list(self): ...
    def add_edge(self, graph_edge) -> None: ...
    def del_edge(self, src_or_list, dst: Any | None = ..., index: Any | None = ...): ...
    def get_edge(self, src_or_list, dst: Any | None = ...): ...
    def get_edges(self): ...
    def get_edge_list(self): ...
    def add_subgraph(self, sgraph) -> None: ...
    def get_subgraph(self, name): ...
    def get_subgraphs(self): ...
    def get_subgraph_list(self): ...
    def set_parent_graph(self, parent_graph) -> None: ...
    def to_string(self) -> str: ...

class Subgraph(Graph):
    def __init__(self, graph_name: str = ..., obj_dict: Any | None = ..., suppress_disconnected: bool = ..., simplify: bool = ..., **attrs) -> None: ...

class Cluster(Graph):
    def __init__(self, graph_name: str = ..., obj_dict: Any | None = ..., suppress_disconnected: bool = ..., simplify: bool = ..., **attrs) -> None: ...

class Dot(Graph):
    shape_files: Any
    formats: Any
    prog: str
    def __init__(self, *argsl, **argsd): ...
    def set_shape_files(self, file_paths) -> None: ...
    def set_prog(self, prog) -> None: ...
    def write(self, path, prog: Any | None = ..., format: str = ..., encoding: Any | None = ...): ...
    def create(self, prog: Any | None = ..., format: str = ..., encoding: Any | None = ...): ...
