DACSEXPR(1)                  DACS Commands Manual                  DACSEXPR(1)



[1mNAME[0m
       dacsexpr - [1mDACS [22mexpression language shell and interpreter

[1mSYNOPSIS[0m
       [1mdacsexpr [22m[[1m-x[22m] [[34m[1mdacsoptions[0m[1m[22m[1]] [[1m-dl[22m] [[1m-e [4m[22mexpr[24m] [[1m-n[22m] [[1m-p[22m] [[1m-s[22m] [[1m-h [22m|
                [1m-help[22m] [[1m-test[22m]
                [[1m--[22m] [[4mfilename[24m] [[4mscript-arg[24m...]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacsexpr [22mutility evaluates [1mDACS [22mexpressions (see [34m[1mdacs.exprs(5)[0m[1m[22m[2]).
       It is often a useful aid when composing or testing expressions to be
       used in access control rules, or when debugging ACLs and configuration
       directives. While they continue to be referred to as "expressions" for
       historical reasons, it has become possible to write small programs, and
       the language can also be useful as a simple scripting language
       independent of the rest of [1mDACS[22m.

       If an expression is provided, it is evaluated and the result is printed
       to the standard output. At most one expression can be specified. If the
       [1m-q [22mflag is given (one of the [34m[4mdacsoptions[0m[4m[24m[1]), nothing is printed,
       expression evaluation errors are suppressed, and the program terminates
       with an appropriate [34m[1mexit status[0m[1m[22m[3]; otherwise the result is written to
       the standard output. If neither a [1m-q [22mflag is given nor any flag that
       controls the logging level, then the logging level is set to warn
       overriding any configuration file logging level directive; this
       behaviour is usually convenient.

       If no expression is provided, the program reads its standard input. If
       the input is not coming from a terminal type device, the program runs
       in "batch mode" and prompting is suppressed; otherwise, the program
       runs in "interactive mode". When prompted in interactive mode, enter
       [1mhelp [22mfor assistance. If the [34m[1mreadline(3)[0m[1m[22m[4] functionality was configured
       when the program was built, command line editing and history are
       available in interactive mode.

       If the program is executed through the system's "#!" mechanism, one or
       more command line arguments can be given:

           #!/usr/local/dacs/bin/dacsexpr -test
           // expect-exact:17
           ${x} = 17;

       Such programs always use the script file as input, therefore no
       expression or other file can be specified on the "#!" line.

       The [4mEnv[24m namespace is initialized from the program's environment. For
       example, if the value of the environment variable [1mLOGNAME [22mis bobo, then
       [4m${Env::LOGNAME}[24m will be instantiated with that value. Syntactically
       invalid variable names are silently ignored.

           [1mNote[0m
           Configuration directives and the [4mConf[24m variable namespace are
           available only if a configuration file is processed (e.g., by
           giving the [1m-uj [22mcommand line flag). This is relevant, for example,
           if the [34m[1mhttp()[0m[1m[22m[5] function is called using the https scheme because
           proper operation will require the [34m[1mSSL_PROG[0m[1m[22m[6] directive to be
           configured. See [34m[1mdacs.conf(5)[0m[1m[22m[7].

[1mOPTIONS[0m
       If an expression or file has not already been specified, a filename may
       appear as the last argument. If [4mfilename[24m is "-", the standard input is
       read.

       [1m-dl[0m
           Print debugging information to stderr.

       [1m-e [4m[22mexpr[0m
           The given expression is evaluated.

       [1m-h[0m
       [1m-help[0m
           Display a help message and exit.

       [1m-n[0m
           Do not evaluate any expressions, only check for syntax errors.

       [1m-p[0m
           Print the final result to the standard output, unless it has been
           suppressed by [1m-q [22mor [1m-n[22m. Without this flag, the result would have to
           be output by the program.

       -s
           If a single expression is being evaluated from the command line or
           a file and the result of evaluation is a string or bstring, the
           output will be surrounded by quotes unless this flag is specified.

       [1m-test[0m
           The input is a test case. A test case consists of options followed
           by an expression. There can be zero or more options, one per line,
           embedded within a // style comment:

               { whitespace* "//" whitespace* [4moption-name[24m ":" [4moption-value[24m end-of-line }*

           No whitespace is allowed before or after the ":". As a special
           case, lines having the following format are ignored:

               whitespace* "///" .* end-of-line

           The first non-option line terminates the options and is the first
           line of the expression to be evaluated.

           Here is an example:

               /// Test bitwise shifts
               // expect-exact:1024
               1 << 10

           An option controls how the test is to be performed and gives the
           expected result:

           expect:[4mregex[0m
           expect-regex:[4mregex[0m
               The result string must match [4mregex[24m. These two option names are
               equivalent.

           expect-identical:[4mstring[0m
               The result string must match [4mstring[24m exactly.

           expect-exact:[4mstring[0m
               The result string must match [4mstring[24m exactly, except that
               C-style character constants (preceded by a backslash) in [4mstring[0m
               are interpolated.

           expect-code:[4mcode[0m
               The result code must match [4mcode[24m, which is 0 if the result is
               [1mTrue[22m, 1 if the result is [1mFalse[22m, and 2 if an error occurs. If
               this option is not given, a default code of 0 is assumed.

           expect-type:[4mtype[0m
               The type of the result must match [4mtype[24m, which can be integer,
               real, string, bstring, literal, or undef.

           expect-flags:[4mflags[0m
               Currently, the only recognized values for [4mflags[24m are
               rw_namespaces and ro_namespaces. The former allows the test to
               create or modify variables in the [4mDACS[24m, [4mArgs[24m, or [4mEnv[24m namespace;
               by default, these namespaces are read-only. This might be
               useful when testing [34m[1mfrom()[0m[1m[22m[8], for instance, because it allows
               the test to set a value for [4m${DACS::REMOTE_ADDR}[24m. The default
               behaviour can be explicitly selected by specifying
               ro_namespaces.

           show-result:{yes | no}
               The result is printed to the standard output only if the option
               value is yes.

           If the test fails, a descriptive message is printed to the standard
           error. The program's exit status will be 0 if the test was
           successful, 1 otherwise.

           This example should succeed without displaying the result:

               // expect-exact:2
               // expect-type:integer
               /// show-result:yes
               1 + 1


               [1mNote[0m
               The [1mDACS [22mdistribution includes a set of test cases in the
               src/tests directory that can be run for regression testing (do
               "make tests" from the src directory). Some of the functions
               provided by [34m[1mdacs.exprs(5)[0m[1m[22m[2] are also used internally by [1mDACS[22m,
               so it is critical that all tests are successful even for
               functions that are not used from the user level.

       -x
           If this is the very first flag it indicates that [1mdacsexpr [22mis being
           executed as a script via the system's "#!" mechanism. This might be
           useful if the program's heuristic for determining this is
           incorrect. The last argument must be a filename.

       --
           This argument explicitly marks the last flag argument. A filename
           argument might follow.

[1mEXAMPLES[0m
       The following command evaluates the expression argument (note that it
       is a single argument to the command) and outputs the result to stdout:

           % dacsexpr -e "1+1"
           2
           % dacsexpr -e '${Env::USER}'
           "bobo"
           % dacsexpr -u example.com -e '"FEDERATION_NAME=" . ${Conf::FEDERATION_NAME}'
           "FEDERATION_NAME=EXAMPLE"
           % dacsexpr - a b c <<HERE
           ? print("First arg is \"\${Argv::1}\"")
           ? HERE
           First arg is "a"
           % cat ex
           #!/usr/local/dacs/bin/dacsexpr

           print("Argv[2] is ${Argv::2}");
           % chmod 0755 ex
           % ./ex foo bar baz
           Argv[2] is bar


[1mDIAGNOSTICS[0m
       If an error occurs, a message may be written to stderr, depending on
       the logging level. In general, the program exits 0 if and only if
       everything was fine. If a command line expression is evaluated, the
       program exits 0 if the expression evaluates to [1mTrue[22m, 1 if it evaluates
       to [1mFalse[22m, and 2 if an error occurs. If an explicit call to [1mexit() [22mis
       made and no true error condition occurred, then the program will exit
       with the argument value.

[1mSEE ALSO[0m
       [34m[1mdacs.exprs(5)[0m[1m[22m[2]

[1mBUGS[0m
       New and little-used features should be used with care. This advice
       applies to all software.

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[9])

[1mCOPYING[0m
       Copyright (C) 2003-2013 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[10] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html

        3. exit status
           http://dacs.dss.ca/man/#diagnostics

        4. readline(3)
           http://www.freebsd.org/cgi/man.cgi?query=readline&apropos=0&sektion=3&manpath=FreeBSD+9.1-RELEASE&format=html

        5. http()
           http://dacs.dss.ca/man/dacs.exprs.5.html#http

        6. SSL_PROG
           http://dacs.dss.ca/man/dacs.conf.5.html#SSL_PROG

        7. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        8. from()
           http://dacs.dss.ca/man/dacs.exprs.5.html#from

        9. www.dss.ca
           http://www.dss.ca

       10. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.28b                      03/01/2013                       DACSEXPR(1)
