#ifndef xcontrol_dependency_h_
#define xcontrol_dependency_h_ 1

#include "version.hpp"

#include <string>

#include <ostream>

class dependency
{
public:
	std::string package;
	version_op op;
	version ver;

	explicit dependency(std::string const &);
	dependency(std::string const &, version_op, version const &);

	bool operator==(dependency const &rhs) const
	{
		if(package != rhs.package)
			return false;
		if(op != rhs.op)
			return false;
		if(ver != rhs.ver)
			return false;
		return true;
	}
	bool operator!=(dependency const &rhs) const
	{
		return !operator==(rhs);
	}
};

template<typename CharT_, typename Traits_>
std::basic_ostream<CharT_, Traits_> &operator<<(
		std::basic_ostream<CharT_, Traits_> &stream,
		dependency const &dep)
{
	typename std::basic_ostream<CharT_, Traits_>::sentry sentry(stream);
	if(!sentry)
		return stream;
	
	stream << dep.package;
	if(dep.op != dontcare)
		stream << " (" << dep.op << " " << dep.ver << ")";
	
	return stream;
}

#endif
