set f [open ~/.din/settings.tcl w]
set set_cmd {set-bpm set-style set-var set-delay}
set get_cmd {get-bpm get-style get-var get-delay}
set runs { {fm am gr os} {fm am gr} {am_depth fm_depth pitch_bend delta_bpm} {left right}}
set ncmds [llength $set_cmd]
for {set i 0} {$i < $ncmds} {incr i} {
  set run [lindex $runs $i]
  foreach j $run {
    set setj [lindex $set_cmd $i]
    set getj [lindex $get_cmd $i]
    set str "$setj $j [$getj $j]"
    puts $f $str
  }
}

proc check-scale {} {
  set scalelist [list-scales]
  set currentscale [get-var scale]
  if {$currentscale in $scalelist} {
    return $currentscale
  } else {
    return minor
  }
}

foreach i {
  {"tuning set" "tuning get"}
  {load-scale check-scale} {key {key value}} {notation notation}
  {set-font-size get-font-size}
  {"set taptarget" "format {{%s}} [set taptarget]"}
  {"set-var scroll" "get-var scroll"}
  {"set-var zoom" "get-var zoom"}
  {"set-var pan" "get-var pan"}
  {"set-var fps" "get-var fps"}
  {"set-var usleep" "get-var usleep"}
  {"set-var num_sine_samples" "get-var num_sine_samples"}
  {"set-var show_cursor_info" "get-var show_cursor_info"}
  {"set-var jog" "get-var jog"}
  {"set-var delta_bpm" "get-var delta_bpm"}
  {"set-var drone_handle_size" "get-var drone_handle_size"}
  {"set-var trail_length" "get-var trail_length"}
  {"set-var wave_volume" "get-var wave_volume"}
  {"set-var note_volume" "get-var note_volume"}
  {"set-var attack_time" "get-var attack_time"}
  {"set-var sustain" "get-var sustain"}
  {"set-var decay_time" "get-var decay_time"}
  {"set-var delta_time" "get-var delta_time"}
  {"set-var instrument" "get-var instrument"}
  {"set-var auto_connect_outputs" "get-var auto_connect_outputs"}
  {"set-scope left" "format {{%s}} [get-scope left]"}
  {"set-scope right" "format {{%s}} [get-scope right]"}
  } {
  set setc [lindex $i 0]
  set getc [lindex $i 1]
  puts $f "$setc [eval $getc]"
}

foreach i {microtonal_keyboard_editors keyboard_keyboard_editors} {
  puts $f "array set $i {[array get $i]}"
}

close $f
puts "+++ saved din variables +++"
