/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import org.adl.datamodels.Element;
import org.adl.datamodels.cmi.CMICategory;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.util.debug.DebugIndicator;

public class CMIStudentPreference
extends CMICategory
implements Serializable {
    public Element audio = new Element("", "checkSInteger", "NULL", true, true, true);
    public Element language = new Element("", "checkString255", "NULL", true, true, true);
    public Element speed = new Element("", "checkSInteger", "NULL", true, true, true);
    public Element text = new Element("", "checkSInteger", "NULL", true, true, true);
    static int CMISTPREF_MIN_NUM_TOKENS = 3;

    public CMIStudentPreference() {
        super(true);
    }

    public Element getAudio() {
        return this.audio;
    }

    public Element getLanguage() {
        return this.language;
    }

    public Element getSpeed() {
        return this.speed;
    }

    public Element getText() {
        return this.text;
    }

    public void setAudio(String inAudio) {
        this.audio.setValue(inAudio);
    }

    public void setLanguage(String inLanguage) {
        this.language.setValue(inLanguage);
    }

    public void setSpeed(String inSpeed) {
        this.speed.setValue(inSpeed);
    }

    public void setText(String inText) {
        this.text.setValue(inText);
    }

    public String performGet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        String result = new String("");
        if (this.isValidStPrefRequest(theRequest)) {
            String token = theRequest.getNextToken();
            if (theRequest.hasMoreTokensToProcess()) {
                if (DebugIndicator.ON) {
                    System.out.println("Error - Data Model Element not implemented");
                    System.out.println("Invalid data model element: " + theRequest.getRequest() + " passed to interface");
                }
                if (theRequest.isAKeywordRequest()) {
                    dmErrorMgr.recGetKeyWordError(theRequest.getElement());
                } else {
                    dmErrorMgr.recNotImplementedError(theRequest);
                }
            } else {
                result = theRequest.isAChildrenRequest() ? this.getChildren() : this.determineElementValue(this, token, dmErrorMgr);
            }
        } else {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Invalid data model element: " + theRequest.getRequest() + " passed to interface");
            }
            dmErrorMgr.recNotImplementedError(theRequest);
        }
        theRequest.done();
        return result;
    }

    public void performSet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        block14: {
            if (this.isValidStPrefRequest(theRequest)) {
                String token = theRequest.getNextToken();
                if (theRequest.hasMoreTokensToProcess()) {
                    if (DebugIndicator.ON) {
                        System.out.println("Error - Data Model Element not implemented");
                        System.out.println("Invalid data model element: " + theRequest.getRequest() + " passed to interface");
                    }
                    dmErrorMgr.recNotImplementedError(theRequest);
                } else if (theRequest.isAChildrenRequest()) {
                    if (DebugIndicator.ON) {
                        System.out.println("Error - trying to set a keyword");
                    }
                    dmErrorMgr.recKeyWordError(token);
                } else {
                    String value = theRequest.getValue();
                    if (token.equals("audio") || token.equals("speed") || token.equals("text")) {
                        try {
                            int ivalue = Integer.parseInt(value);
                            if (token.equals("audio") && ivalue >= -1 && ivalue <= 100 || token.equals("speed") && ivalue >= -100 && ivalue <= 100 || token.equals("text") && ivalue >= -1 && ivalue <= 1) {
                                this.doSet(this, token, value, dmErrorMgr);
                                break block14;
                            }
                            dmErrorMgr.SetCurrentErrorCode("405");
                        }
                        catch (NumberFormatException nfe) {
                            dmErrorMgr.SetCurrentErrorCode("405");
                            if (DebugIndicator.ON) {
                                System.out.println("Error - Number Format Exception");
                            }
                            break block14;
                        }
                    }
                    this.doSet(this, token, value, dmErrorMgr);
                }
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("Error - Data Model Element not implemented");
                    System.out.println("Invalid data model element: " + theRequest.getRequest() + " passed to interface");
                }
                dmErrorMgr.recNotImplementedError(theRequest);
            }
        }
        theRequest.done();
    }

    private boolean isValidStPrefRequest(CMIRequest theRequest) {
        boolean rtrnFlag = false;
        if (theRequest.getTotalNumTokens() >= CMISTPREF_MIN_NUM_TOKENS) {
            rtrnFlag = true;
        }
        return rtrnFlag;
    }

    private String getChildren() {
        String children = new String("audio,language,speed,text,");
        return children;
    }
}

