// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

//
// Description: Rtf control words enumeration.
//

namespace System.Windows.Documents
{
    /// <summary>
    /// Rtf control words that enumerate all Rtf control word.
    /// </summary>
    internal enum RtfControlWord
    {
        Ctrl_Unknown = -1,
        Ctrl_AB = 0,
        Ctrl_ABSH,
        Ctrl_ABSLOCK,
        Ctrl_ABSNOOVRLP,
        Ctrl_ABSW,
        Ctrl_ACAPS,
        Ctrl_ACCCOMMA,
        Ctrl_ACCDOT,
        Ctrl_ACCNONE,
        Ctrl_ACF,
        Ctrl_ADDITIVE,
        Ctrl_ADJUSTRIGHT,
        Ctrl_ADN,
        Ctrl_AENDDOC,
        Ctrl_AENDNOTES,
        Ctrl_AEXPND,
        Ctrl_AF,
        Ctrl_AFFIXED,
        Ctrl_AFS,
        Ctrl_AFTNBJ,
        Ctrl_AFTNCN,
        Ctrl_AFTNNALC,
        Ctrl_AFTNNAR,
        Ctrl_AFTNNAUC,
        Ctrl_AFTNNCHI,
        Ctrl_AFTNNCHOSUNG,
        Ctrl_AFTNNCNUM,
        Ctrl_AFTNNDBAR,
        Ctrl_AFTNNDBNUM,
        Ctrl_AFTNNDBNUMD,
        Ctrl_AFTNNDBNUMK,
        Ctrl_AFTNNDBNUMT,
        Ctrl_AFTNNGANADA,
        Ctrl_AFTNNGBNUM,
        Ctrl_AFTNNGBNUMD,
        Ctrl_AFTNNGBNUMK,
        Ctrl_AFTNNGBNUML,
        Ctrl_AFTNNRLC,
        Ctrl_AFTNNRUC,
        Ctrl_AFTNNZODIAC,
        Ctrl_AFTNNZODIACD,
        Ctrl_AFTNNZODIACL,
        Ctrl_AFTNRESTART,
        Ctrl_AFTNRSTCONT,
        Ctrl_AFTNSEP,
        Ctrl_AFTNSEPC,
        Ctrl_AFTNSTART,
        Ctrl_AFTNTJ,
        Ctrl_AI,
        Ctrl_ALANG,
        Ctrl_ALLPROT,
        Ctrl_ALNTBLIND,
        Ctrl_ALT,
        Ctrl_ANIMTEXT,
        Ctrl_ANNOTATION,
        Ctrl_ANNOTPROT,
        Ctrl_ANSI,
        Ctrl_ANSICPG,
        Ctrl_AOUTL,
        Ctrl_ASCAPS,
        Ctrl_ASHAD,
        Ctrl_ASPALPHA,
        Ctrl_ASPNUM,
        Ctrl_ASTRIKE,
        Ctrl_ATNAUTHOR,
        Ctrl_ATNICN,
        Ctrl_ATNID,
        Ctrl_ATNREF,
        Ctrl_ATNTIME,
        Ctrl_ATRFEND,
        Ctrl_ATRFSTART,
        Ctrl_AUL,
        Ctrl_AULD,
        Ctrl_AULDB,
        Ctrl_AULNONE,
        Ctrl_AULW,
        Ctrl_AUP,
        Ctrl_AUTHOR,
        Ctrl_B,
        Ctrl_BACKGROUND,
        Ctrl_BDBFHDR,
        Ctrl_BDRRLSWSIX,
        Ctrl_BGBDIAG,
        Ctrl_BGCROSS,
        Ctrl_BGDCROSS,
        Ctrl_BGDKBDIAG,
        Ctrl_BGDKCROSS,
        Ctrl_BGDKDCROSS,
        Ctrl_BGDKFDIAG,
        Ctrl_BGDKHORIZ,
        Ctrl_BGDKVERT,
        Ctrl_BGFDIAG,
        Ctrl_BGHORIZ,
        Ctrl_BGVERT,
        Ctrl_BIN,
        Ctrl_BINFSXN,
        Ctrl_BINSXN,
        Ctrl_BKMKCOLF,
        Ctrl_BKMKCOLL,
        Ctrl_BKMKEND,
        Ctrl_BKMKPUB,
        Ctrl_BKMKSTART,
        Ctrl_BLIPTAG,
        Ctrl_BLIPUID,
        Ctrl_BLIPUPI,
        Ctrl_BLUE,
        Ctrl_BOX,
        Ctrl_BRDRART,
        Ctrl_BRDRB,
        Ctrl_BRDRBAR,
        Ctrl_BRDRBTW,
        Ctrl_BRDRCF,
        Ctrl_BRDRDASH,
        Ctrl_BRDRDASHD,
        Ctrl_BRDRDASHDD,
        Ctrl_BRDRDASHDOTSTR,
        Ctrl_BRDRDASHSM,
        Ctrl_BRDRDB,
        Ctrl_BRDRDOT,
        Ctrl_BRDREMBOSS,
        Ctrl_BRDRENGRAVE,
        Ctrl_BRDRFRAME,
        Ctrl_BRDRHAIR,
        Ctrl_BRDRINSET,
        Ctrl_BRDRL,
        Ctrl_BRDROUTSET,
        Ctrl_BRDRNIL,       // BORDER: no border specified
        Ctrl_BRDRNONE,      // BORDER: no border 
        Ctrl_BRDRTBL,       // BORDER: no borders on table cells
        Ctrl_BRDRR,
        Ctrl_BRDRS,         // BORDER: single thickness border
        Ctrl_BRDRSH,
        Ctrl_BRDRT,
        Ctrl_BRDRTH,
        Ctrl_BRDRTHTNLG,
        Ctrl_BRDRTHTNMG,
        Ctrl_BRDRTHTNSG,
        Ctrl_BRDRTNTHLG,
        Ctrl_BRDRTNTHMG,
        Ctrl_BRDRTNTHSG,
        Ctrl_BRDRTNTHTNLG,
        Ctrl_BRDRTNTHTNMG,
        Ctrl_BRDRTNTHTNSG,
        Ctrl_BRDRTRIPLE,
        Ctrl_BRDRW,         // BORDER: width in twips of border line
        Ctrl_BRDRWAVY,      // BORDER: wavy border
        Ctrl_BRDRWAVYDB,    // BORDER: double wavy border
        Ctrl_BRKFRM,
        Ctrl_BRSP,
        Ctrl_BULLET,
        Ctrl_BUPTIM,
        Ctrl_BXE,
        Ctrl_CAPS,
        Ctrl_CATEGORY,
        Ctrl_CB,
        Ctrl_CBPAT,
        Ctrl_CCHS,
        Ctrl_CELL,
        Ctrl_CELLX,         // TABLE: CELL: defines right boundary of cell, including half spacing (twips)
        Ctrl_CF,
        Ctrl_CFPAT,
        Ctrl_CGRID,
        Ctrl_CHARSCALEX,
        Ctrl_CHATN,
        Ctrl_CHBGBDIAG,
        Ctrl_CHBGCROSS,
        Ctrl_CHBGDCROSS,
        Ctrl_CHBGDKBDIAG,
        Ctrl_CHBGDKCROSS,
        Ctrl_CHBGDKDCROSS,
        Ctrl_CHBGDKFDIAG,
        Ctrl_CHBGDKHORIZ,
        Ctrl_CHBGDKVERT,
        Ctrl_CHBGFDIAG,
        Ctrl_CHBGHORIZ,
        Ctrl_CHBGVERT,
        Ctrl_CHBRDR,
        Ctrl_CHCBPAT,
        Ctrl_CHCFPAT,
        Ctrl_CHDATE,
        Ctrl_CHDPA,
        Ctrl_CHDPL,
        Ctrl_CHFTN,
        Ctrl_CHFTNSEP,
        Ctrl_CHFTNSEPC,
        Ctrl_CHPGN,
        Ctrl_CHSHDNG,
        Ctrl_CHTIME,
        Ctrl_CLBGBDIAG,
        Ctrl_CLBGCROSS,
        Ctrl_CLBGDCROSS,
        Ctrl_CLBGDKBDIAG,
        Ctrl_CLBGDKCROSS,
        Ctrl_CLBGDKDCROSS,
        Ctrl_CLBGDKFDIAG,
        Ctrl_CLBGDKHOR,
        Ctrl_CLBGDKVERT,
        Ctrl_CLBGFDIAG,
        Ctrl_CLBGHORIZ,
        Ctrl_CLBGVERT,
        Ctrl_CLBRDRB,       // TABLE: CELL: table cell border bottom.
        Ctrl_CLBRDRL,       // TABLE: CELL: table cell border left.
        Ctrl_CLBRDRR,       // TABLE: CELL: table cell border right.
        Ctrl_CLBRDRT,       // TABLE: CELL: table cell border top.
        Ctrl_CLCBPAT,
        Ctrl_CLCFPAT,
        Ctrl_CLDGLL,
        Ctrl_CLDGLU,
        Ctrl_CLFITTEXT,
        Ctrl_CLFTSWIDTH,
        Ctrl_CLMGF,
        Ctrl_CLMRG,
        Ctrl_CLOWRAP,
        Ctrl_CLPADB,
        Ctrl_CLPADFB,
        Ctrl_CLPADFL,
        Ctrl_CLPADFR,
        Ctrl_CLPADFT,
        Ctrl_CLPADL,
        Ctrl_CLPADR,
        Ctrl_CLPADT,
        Ctrl_CLSHDNG,
        Ctrl_CLSHDRAWNIL,   // TABLE: no shading
        Ctrl_CLTXBTLR,
        Ctrl_CLTXLRTB,      // TABLE: CELL: text flows left-right-top-bottom
        Ctrl_CLTXLRTBV,
        Ctrl_CLTXTBRL,
        Ctrl_CLTXTBRLV,
        Ctrl_CLVERTALB,     // TABLE: CELL: cell contents vertically aligned bottom.
        Ctrl_CLVERTALC,     // TABLE: CELL: cell contents vertically aligned center.
        Ctrl_CLVERTALT,     // TABLE: CELL: cell contents vertically aligned top.
        Ctrl_CLVMGF,
        Ctrl_CLVMRG,
        Ctrl_CLWWIDTH,
        Ctrl_COLLAPSED,
        Ctrl_COLNO,
        Ctrl_COLORTBL,
        Ctrl_COLS,
        Ctrl_COLSR,
        Ctrl_COLSX,
        Ctrl_COLUMN,
        Ctrl_COLW,
        Ctrl_COMMENT,
        Ctrl_COMPANY,
        Ctrl_CPG,
        Ctrl_CRAUTH,
        Ctrl_CRDATE,
        Ctrl_CREATIM,
        Ctrl_CS,
        Ctrl_CTRL,
        Ctrl_CTS,
        Ctrl_CUFI,
        Ctrl_CULI,
        Ctrl_CURI,
        Ctrl_CVMME,
        Ctrl_DATAFIELD,
        Ctrl_DATE,
        Ctrl_DBCH,
        Ctrl_DEFF,
        Ctrl_DEFFORMAT,
        Ctrl_DEFLANG,
        Ctrl_DEFLANGA,
        Ctrl_DEFLANGFE,
        Ctrl_DEFSHP,
        Ctrl_DEFTAB,
        Ctrl_DELETED,
        Ctrl_DFRAUTH,
        Ctrl_DFRDATE,
        Ctrl_DFRMTXTX,
        Ctrl_DFRMTXTY,
        Ctrl_DFRSTART,
        Ctrl_DFRSTOP,
        Ctrl_DFRXST,
        Ctrl_DGHORIGIN,
        Ctrl_DGHSHOW,
        Ctrl_DGHSPACE,
        Ctrl_DGMARGIN,
        Ctrl_DGSNAP,
        Ctrl_DGVORIGIN,
        Ctrl_DGVSHOW,
        Ctrl_DGVSPACE,
        Ctrl_DIBITMAP,
        Ctrl_DN,
        Ctrl_DNTBLNSBDB,
        Ctrl_DO,
        Ctrl_DOBXCOLUMN,
        Ctrl_DOBXMARGIN,
        Ctrl_DOBXPAGE,
        Ctrl_DOBYMARGIN,
        Ctrl_DOBYPAGE,
        Ctrl_DOBYPARA,
        Ctrl_DOCCOMM,
        Ctrl_DOCTEMP,
        Ctrl_DOCTYPE,
        Ctrl_DOCVAR,
        Ctrl_DODHGT,
        Ctrl_DOLOCK,
        Ctrl_DPAENDHOL,
        Ctrl_DPAENDL,
        Ctrl_DPAENDSOL,
        Ctrl_DPAENDW,
        Ctrl_DPARC,
        Ctrl_DPARCFLIPX,
        Ctrl_DPARCFLIPY,
        Ctrl_DPASTARTHOL,
        Ctrl_DPASTARTL,
        Ctrl_DPASTARTSOL,
        Ctrl_DPASTARTW,
        Ctrl_DPCALLOUT,
        Ctrl_DPCOA,
        Ctrl_DPCOACCENT,
        Ctrl_DPCOBESTFIT,
        Ctrl_DPCOBORDER,
        Ctrl_DPCODABS,
        Ctrl_DPCODBOTTOM,
        Ctrl_DPCODCENTER,
        Ctrl_DPCODESCENT,
        Ctrl_DPCODTOP,
        Ctrl_DPCOLENGTH,
        Ctrl_DPCOMINUSX,
        Ctrl_DPCOMINUSY,
        Ctrl_DPCOOFFSET,
        Ctrl_DPCOSMARTA,
        Ctrl_DPCOTDOUBLE,
        Ctrl_DPCOTRIGHT,
        Ctrl_DPCOTSINGLE,
        Ctrl_DPCOTTRIPLE,
        Ctrl_DPCOUNT,
        Ctrl_DPELLIPSE,
        Ctrl_DPENDGROUP,
        Ctrl_DPFILLBGCB,
        Ctrl_DPFILLBGCG,
        Ctrl_DPFILLBGCR,
        Ctrl_DPFILLBGGRAY,
        Ctrl_DPFILLBGPAL,
        Ctrl_DPFILLFGCB,
        Ctrl_DPFILLFGCG,
        Ctrl_DPFILLFGCR,
        Ctrl_DPFILLFGGRAY,
        Ctrl_DPFILLFGPAL,
        Ctrl_DPFILLPAT,
        Ctrl_DPGROUP,
        Ctrl_DPLINE,
        Ctrl_DPLINECOB,
        Ctrl_DPLINECOG,
        Ctrl_DPLINECOR,
        Ctrl_DPLINEDADO,
        Ctrl_DPLINEDADODO,
        Ctrl_DPLINEDASH,
        Ctrl_DPLINEDOT,
        Ctrl_DPLINEGRAY,
        Ctrl_DPLINEHOLLOW,
        Ctrl_DPLINEPAL,
        Ctrl_DPLINESOLID,
        Ctrl_DPLINEW,
        Ctrl_DPPOLYCOUNT,
        Ctrl_DPPOLYGON,
        Ctrl_DPPOLYLINE,
        Ctrl_DPPTX,
        Ctrl_DPPTY,
        Ctrl_DPRECT,
        Ctrl_DPROUNDR,
        Ctrl_DPSHADOW,
        Ctrl_DPSHADX,
        Ctrl_DPSHADY,
        Ctrl_DPTXBTLR,
        Ctrl_DPTXBX,
        Ctrl_DPTXBXMAR,
        Ctrl_DPTXBXTEXT,
        Ctrl_DPTXLRTB,
        Ctrl_DPTXLRTBV,
        Ctrl_DPTXTBRL,
        Ctrl_DPTXTBRLV,
        Ctrl_DPX,
        Ctrl_DPXSIZE,
        Ctrl_DPY,
        Ctrl_DPYSIZE,
        Ctrl_DROPCAPLI,
        Ctrl_DROPCAPT,
        Ctrl_DS,
        Ctrl_DXFRTEXT,
        Ctrl_DY,
        Ctrl_EDMINS,
        Ctrl_EMBO,
        Ctrl_EMDASH,
        Ctrl_EMFBLIP,
        Ctrl_EMSPACE,
        Ctrl_ENDASH,
        Ctrl_ENDDOC,
        Ctrl_ENDNHERE,
        Ctrl_ENDNOTES,
        Ctrl_ENSPACE,
        Ctrl_EXPND,
        Ctrl_EXPNDTW,
        Ctrl_EXPSHRTN,
        Ctrl_F,
        Ctrl_FAAUTO,
        Ctrl_FACENTER,
        Ctrl_FACINGP,
        Ctrl_FAHANG,
        Ctrl_FALT,
        Ctrl_FAROMAN,
        Ctrl_FAVAR,
        Ctrl_FBIAS,
        Ctrl_FBIDI,
        Ctrl_FCHARS,
        Ctrl_FCHARSET,
        Ctrl_FDECOR,
        Ctrl_FET,
        Ctrl_FETCH,
        Ctrl_FFDEFRES,
        Ctrl_FFDEFTEXT,
        Ctrl_FFENTRYMCR,
        Ctrl_FFEXITMCR,
        Ctrl_FFFORMAT,
        Ctrl_FFHASLISTBOX,
        Ctrl_FFHELPTEXT,
        Ctrl_FFHPS,
        Ctrl_FFL,
        Ctrl_FFMAXLEN,
        Ctrl_FFNAME,
        Ctrl_FFOWNHELP,
        Ctrl_FFOWNSTAT,
        Ctrl_FFPROT,
        Ctrl_FFRECALC,
        Ctrl_FFRES,
        Ctrl_FFSIZE,
        Ctrl_FFSTATTEXT,
        Ctrl_FFTYPE,
        Ctrl_FFTYPETXT,
        Ctrl_FI,
        Ctrl_FID,
        Ctrl_FIELD,
        Ctrl_FILE,
        Ctrl_FILETBL,
        Ctrl_FITTEXT,
        Ctrl_FLDALT,
        Ctrl_FLDDIRTY,
        Ctrl_FLDEDIT,
        Ctrl_FLDINST,
        Ctrl_FLDLOCK,
        Ctrl_FLDPRIV,
        Ctrl_FLDRSLT,
        Ctrl_FLDTYPE,
        Ctrl_FMODERN,
        Ctrl_FN,
        Ctrl_FNAME,
        Ctrl_FNETWORK,
        Ctrl_FNIL,
        Ctrl_FONTEMB,
        Ctrl_FONTFILE,
        Ctrl_FONTTBL,
        Ctrl_FOOTER,
        Ctrl_FOOTERF,
        Ctrl_FOOTERL,
        Ctrl_FOOTERR,
        Ctrl_FOOTERY,
        Ctrl_FOOTNOTE,
        Ctrl_FORMDISP,
        Ctrl_FORMFIELD,
        Ctrl_FORMPROT,
        Ctrl_FORMSHADE,
        Ctrl_FOSNUM,
        Ctrl_FPRQ,
        Ctrl_FRACWIDTH,
        Ctrl_FRELATIVE,
        Ctrl_FRMTXBTLR,
        Ctrl_FRMTXLRTB,
        Ctrl_FRMTXLRTBV,
        Ctrl_FRMTXTBRL,
        Ctrl_FRMTXTBRLV,
        Ctrl_FROMAN,
        Ctrl_FROMHTML,
        Ctrl_FROMTEXT,
        Ctrl_FS,
        Ctrl_FSCRIPT,
        Ctrl_FSWISS,
        Ctrl_FTNALT,
        Ctrl_FTNBJ,
        Ctrl_FTNCN,
        Ctrl_FTNIL,
        Ctrl_FTNLYTWNINE,
        Ctrl_FTNNALC,
        Ctrl_FTNNAR,
        Ctrl_FTNNAUC,
        Ctrl_FTNNCHI,
        Ctrl_FTNNCHOSUNG,
        Ctrl_FTNNCNUM,
        Ctrl_FTNNDBAR,
        Ctrl_FTNNDBNUM,
        Ctrl_FTNNDBNUMD,
        Ctrl_FTNNDBNUMK,
        Ctrl_FTNNDBNUMT,
        Ctrl_FTNNGANADA,
        Ctrl_FTNNGBNUM,
        Ctrl_FTNNGBNUMD,
        Ctrl_FTNNGBNUMK,
        Ctrl_FTNNGBNUML,
        Ctrl_FTNNRLC,
        Ctrl_FTNNRUC,
        Ctrl_FTNNZODIAC,
        Ctrl_FTNNZODIACD,
        Ctrl_FTNNZODIACL,
        Ctrl_FTNRESTART,
        Ctrl_FTNRSTCONT,
        Ctrl_FTNRSTPG,
        Ctrl_FTNSEP,
        Ctrl_FTNSEPC,
        Ctrl_FTNSTART,
        Ctrl_FTNTJ,
        Ctrl_FTTRUETYPE,
        Ctrl_FVALIDDOS,
        Ctrl_FVALIDHPFS,
        Ctrl_FVALIDMAC,
        Ctrl_FVALIDNTFS,
        Ctrl_G,
        Ctrl_GCW,
        Ctrl_GREEN,
        Ctrl_GRIDTBL,
        Ctrl_GUTTER,
        Ctrl_GUTTERPRL,
        Ctrl_GUTTERSXN,
        Ctrl_HEADER,
        Ctrl_HEADERF,
        Ctrl_HEADERL,
        Ctrl_HEADERR,
        Ctrl_HEADERY,
        Ctrl_HICH,
        Ctrl_HIGHLIGHT,
        Ctrl_HLFR,
        Ctrl_HLINKBASE,
        Ctrl_HLLOC,
        Ctrl_HLSRC,
        Ctrl_HORZDOC,
        Ctrl_HORZSECT,
        Ctrl_HR,
        Ctrl_HTMAUTSP,
        Ctrl_HTMLBASE,
        Ctrl_HTMLRTF,
        Ctrl_HTMLTAG,
        Ctrl_HYPHAUTO,
        Ctrl_HYPHCAPS,
        Ctrl_HYPHCONSEC,
        Ctrl_HYPHHOTZ,
        Ctrl_HYPHPAR,
        Ctrl_I,
        Ctrl_ID,
        Ctrl_ILVL,
        Ctrl_IMPR,
        Ctrl_INFO,
        Ctrl_INTBL,
        Ctrl_ITAP,
        Ctrl_IXE,
        Ctrl_JCOMPRESS,
        Ctrl_JEXPAND,
        Ctrl_JPEGBLIP,
        Ctrl_JSKSU,
        Ctrl_KEEP,
        Ctrl_KEEPN,
        Ctrl_KERNING,
        Ctrl_KEYCODE,
        Ctrl_KEYWORDS,
        Ctrl_KSULANG,
        Ctrl_LANDSCAPE,
        Ctrl_LANG,
        Ctrl_LANGFE,
        Ctrl_LANGFENP,
        Ctrl_LANGNP,
        Ctrl_LBR,
        Ctrl_LCHARS,
        Ctrl_LDBLQUOTE,
        Ctrl_LEVEL,
        Ctrl_LEVELFOLLOW,
        Ctrl_LEVELINDENT,
        Ctrl_LEVELJC,
        Ctrl_LEVELJCN,
        Ctrl_LEVELLEGAL,
        Ctrl_LEVELNFC,
        Ctrl_LEVELNFCN,
        Ctrl_LEVELNORESTART,
        Ctrl_LEVELNUMBERS,
        Ctrl_LEVELOLD,
        Ctrl_LEVELPREV,
        Ctrl_LEVELPREVSPACE,
        Ctrl_LEVELSPACE,
        Ctrl_LEVELSTARTAT,
        Ctrl_LEVELTEMPLATEID,
        Ctrl_LEVELTEXT,
        Ctrl_LFOLEVEL,
        Ctrl_LI,
        Ctrl_LINE,
        Ctrl_LINEBETCOL,
        Ctrl_LINECONT,
        Ctrl_LINEMOD,
        Ctrl_LINEPPAGE,
        Ctrl_LINERESTART,
        Ctrl_LINESTART,
        Ctrl_LINESTARTS,
        Ctrl_LINEX,
        Ctrl_LINKSELF,
        Ctrl_LINKSTYLES,
        Ctrl_LINKVAL,
        Ctrl_LIN,
        Ctrl_LISA,
        Ctrl_LISB,
        Ctrl_LIST,
        Ctrl_LISTHYBRID,
        Ctrl_LISTID,
        Ctrl_LISTLEVEL,
        Ctrl_LISTNAME,
        Ctrl_LISTOVERRIDE,
        Ctrl_LISTOVERRIDECOUNT,
        Ctrl_LISTOVERRIDEFORMAT,
        Ctrl_LISTOVERRIDESTART,
        Ctrl_LISTPICTURE,
        Ctrl_LISTRESTARTHDN,
        Ctrl_LISTSIMPLE,
        Ctrl_LISTTABLE,
        Ctrl_LISTOVERRIDETABLE,
        Ctrl_LISTTEMPLATEID,
        Ctrl_LISTTEXT,
        Ctrl_LNBRKRULE,
        Ctrl_LNDSCPSXN,
        Ctrl_LNONGRID,
        Ctrl_LOCH,
        Ctrl_LQUOTE,
        Ctrl_LS,
        Ctrl_LTRCH,
        Ctrl_LTRDOC,
        Ctrl_LTRMARK,
        Ctrl_LTRPAR,
        Ctrl_LTRROW,
        Ctrl_LTRSECT,
        Ctrl_LYTCALCTBLWD,
        Ctrl_LYTEXCTTP,
        Ctrl_LYTPRTMET,
        Ctrl_LYTTBLRTGR,
        Ctrl_MAC,
        Ctrl_MACPICT,
        Ctrl_MAKEBACKUP,
        Ctrl_MANAGER,
        Ctrl_MARGB,
        Ctrl_MARGBSXN,
        Ctrl_MARGL,
        Ctrl_MARGLSXN,
        Ctrl_MARGMIRROR,
        Ctrl_MARGR,
        Ctrl_MARGRSXN,
        Ctrl_MARGT,
        Ctrl_MARGTSXN,
        Ctrl_MHTMLTAG,
        Ctrl_MIN,
        Ctrl_MO,
        Ctrl_MSMCAP,
        Ctrl_NESTCELL,
        Ctrl_NESTROW,
        Ctrl_NESTTABLEPROPS,
        Ctrl_NEXTFILE,
        Ctrl_NOCOLBAL,
        Ctrl_NOCWRAP,
        Ctrl_NOEXTRASPRL,
        Ctrl_NOFCHARS,
        Ctrl_NOFCHARSWS,
        Ctrl_NOFPAGES,
        Ctrl_NOFWORDS,
        Ctrl_NOLEAD,
        Ctrl_NOLINE,
        Ctrl_NOLNHTADJTBL,
        Ctrl_NONESTTABLES,
        Ctrl_NONSHPPICT,
        Ctrl_NOOVERFLOW,
        Ctrl_NOPROOF,
        Ctrl_NOSECTEXPAND,
        Ctrl_NOSNAPLINEGRID,
        Ctrl_NOSPACEFORUL,
        Ctrl_NOSUPERSUB,
        Ctrl_NOTABIND,
        Ctrl_NOULTRLSPC,
        Ctrl_NOWIDCTLPAR,
        Ctrl_NOWRAP,
        Ctrl_NOWWRAP,
        Ctrl_NOXLATTOYEN,
        Ctrl_OBJALIAS,
        Ctrl_OBJALIGN,
        Ctrl_OBJATTPH,
        Ctrl_OBJAUTLINK,
        Ctrl_OBJCLASS,
        Ctrl_OBJCROPB,
        Ctrl_OBJCROPL,
        Ctrl_OBJCROPR,
        Ctrl_OBJCROPT,
        Ctrl_OBJDATA,
        Ctrl_OBJECT,
        Ctrl_OBJEMB,
        Ctrl_OBJH,
        Ctrl_OBJHTML,
        Ctrl_OBJICEMB,
        Ctrl_OBJLINK,
        Ctrl_OBJLOCK,
        Ctrl_OBJNAME,
        Ctrl_OBJOCX,
        Ctrl_OBJPUB,
        Ctrl_OBJSCALEX,
        Ctrl_OBJSCALEY,
        Ctrl_OBJSECT,
        Ctrl_OBJSETSIZE,
        Ctrl_OBJSUB,
        Ctrl_OBJTIME,
        Ctrl_OBJTRANSY,
        Ctrl_OBJUPDATE,
        Ctrl_OBJW,
        Ctrl_OLDAS,
        Ctrl_OLDLINEWRAP,
        Ctrl_OPERATOR,
        Ctrl_OTBLRUL,
        Ctrl_OUTL,
        Ctrl_OUTLINELEVEL,
        Ctrl_OVERLAY,
        Ctrl_PAGE,
        Ctrl_PAGEBB,
        Ctrl_PANOSE,
        Ctrl_PAPERH,
        Ctrl_PAPERW,
        Ctrl_PAR,
        Ctrl_PARD,
        Ctrl_PC,
        Ctrl_PCA,
        Ctrl_PGBRDRB,
        Ctrl_PGBRDRFOOT,
        Ctrl_PGBRDRHEAD,
        Ctrl_PGBRDRL,
        Ctrl_PGBRDROPT,
        Ctrl_PGBRDRR,
        Ctrl_PGBRDRSNAP,
        Ctrl_PGBRDRT,
        Ctrl_PGHSXN,
        Ctrl_PGNBIDIA,
        Ctrl_PGNBIDIB,
        Ctrl_PGNCHOSUNG,
        Ctrl_PGNCNUM,
        Ctrl_PGNCONT,
        Ctrl_PGNDBNUM,
        Ctrl_PGNDBNUMD,
        Ctrl_PGNDBNUMK,
        Ctrl_PGNDBNUMT,
        Ctrl_PGNDEC,
        Ctrl_PGNDECD,
        Ctrl_PGNGANADA,
        Ctrl_PGNGBNUM,
        Ctrl_PGNGBNUMD,
        Ctrl_PGNGBNUMK,
        Ctrl_PGNGBNUML,
        Ctrl_PGNHN,
        Ctrl_PGNHNSC,
        Ctrl_PGNHNSH,
        Ctrl_PGNHNSM,
        Ctrl_PGNHNSN,
        Ctrl_PGNHNSP,
        Ctrl_PGNLCLTR,
        Ctrl_PGNLCRM,
        Ctrl_PGNRESTART,
        Ctrl_PGNSTART,
        Ctrl_PGNSTARTS,
        Ctrl_PGNUCLTR,
        Ctrl_PGNUCRM,
        Ctrl_PGNX,
        Ctrl_PGNY,
        Ctrl_PGNZODIAC,
        Ctrl_PGNZODIACD,
        Ctrl_PGNZODIACL,
        Ctrl_PGWSXN,
        Ctrl_PHCOL,
        Ctrl_PHMRG,
        Ctrl_PHPG,
        Ctrl_PICBMP,
        Ctrl_PICBPP,
        Ctrl_PICCROPB,
        Ctrl_PICCROPL,
        Ctrl_PICCROPR,
        Ctrl_PICCROPT,
        Ctrl_PICH,
        Ctrl_PICHGOAL,
        Ctrl_PICPROP,
        Ctrl_PICSCALED,
        Ctrl_PICSCALEX,
        Ctrl_PICSCALEY,
        Ctrl_PICT,
        Ctrl_PICW,
        Ctrl_PICWGOAL,
        Ctrl_PLAIN,
        Ctrl_PMMETAFILE,
        Ctrl_PN,
        Ctrl_PNACROSS,
        Ctrl_PNAIU,
        Ctrl_PNAIUD,
        Ctrl_PNAIUEO,
        Ctrl_PNAIUEOD,
        Ctrl_PNB,
        Ctrl_PNBIDIA,
        Ctrl_PNBIDIB,
        Ctrl_PNCAPS,
        Ctrl_PNCARD,
        Ctrl_PNCF,
        Ctrl_PNCHOSUNG,
        Ctrl_PNCNUM,
        Ctrl_PNDBNUM,
        Ctrl_PNDBNUMD,
        Ctrl_PNDBNUMK,
        Ctrl_PNDBNUML,
        Ctrl_PNDBNUMT,
        Ctrl_PNDEC,
        Ctrl_PNDECD,
        Ctrl_PNF,
        Ctrl_PNFS,
        Ctrl_PNGANADA,
        Ctrl_PNGBLIP,
        Ctrl_PNGBNUM,
        Ctrl_PNGBNUMD,
        Ctrl_PNGBNUMK,
        Ctrl_PNGBNUML,
        Ctrl_PNHANG,
        Ctrl_PNI,
        Ctrl_PNINDENT,
        Ctrl_PNIROHA,
        Ctrl_PNIROHAD,
        Ctrl_PNLCLTR,
        Ctrl_PNLCRM,
        Ctrl_PNLVL,
        Ctrl_PNLVLBLT,
        Ctrl_PNLVLBODY,
        Ctrl_PNLVLCONT,
        Ctrl_PNNUMONCE,
        Ctrl_PNORD,
        Ctrl_PNORDT,
        Ctrl_PNPREV,
        Ctrl_PNQC,
        Ctrl_PNQL,
        Ctrl_PNQR,
        Ctrl_PNRAUTH,
        Ctrl_PNRDATE,
        Ctrl_PNRESTART,
        Ctrl_PNRNFC,
        Ctrl_PNRNOT,
        Ctrl_PNRPNBR,
        Ctrl_PNRRGB,
        Ctrl_PNRSTART,
        Ctrl_PNRSTOP,
        Ctrl_PNRXST,
        Ctrl_PNSCAPS,
        Ctrl_PNSECLVL,
        Ctrl_PNSP,
        Ctrl_PNSTART,
        Ctrl_PNSTRIKE,
        Ctrl_PNTEXT,
        Ctrl_PNTXTA,
        Ctrl_PNTXTB,
        Ctrl_PNUCLTR,
        Ctrl_PNUCRM,
        Ctrl_PNUL,
        Ctrl_PNULD,
        Ctrl_PNULDASH,
        Ctrl_PNULDASHD,
        Ctrl_PNULDASHDD,
        Ctrl_PNULDB,
        Ctrl_PNULHAIR,
        Ctrl_PNULNONE,
        Ctrl_PNULTH,
        Ctrl_PNULW,
        Ctrl_PNULWAVE,
        Ctrl_PNZODIAC,
        Ctrl_PNZODIACD,
        Ctrl_PNZODIACL,
        Ctrl_POSNEGX,
        Ctrl_POSNEGY,
        Ctrl_POSX,
        Ctrl_POSXC,
        Ctrl_POSXI,
        Ctrl_POSXL,
        Ctrl_POSXO,
        Ctrl_POSXR,
        Ctrl_POSY,
        Ctrl_POSYB,
        Ctrl_POSYC,
        Ctrl_POSYIL,
        Ctrl_POSYIN,
        Ctrl_POSYOUT,
        Ctrl_POSYT,
        Ctrl_PRCOLBL,
        Ctrl_PRINTDATA,
        Ctrl_PRINTIM,
        Ctrl_PRIVATE,
        Ctrl_PROPNAME,
        Ctrl_PROPTYPE,
        Ctrl_PSOVER,
        Ctrl_PSZ,
        Ctrl_PUBAUTO,
        Ctrl_PVMRG,
        Ctrl_PVPARA,
        Ctrl_PVPG,
        Ctrl_PWD,
        Ctrl_PXE,
        Ctrl_QC,
        Ctrl_QD,
        Ctrl_QJ,
        Ctrl_QL,
        Ctrl_QMSPACE,
        Ctrl_QR,
        Ctrl_RDBLQUOTE,
        Ctrl_RED,
        Ctrl_RESULT,
        Ctrl_REVAUTH,
        Ctrl_REVAUTHDEL,
        Ctrl_REVBAR,
        Ctrl_REVDTTM,
        Ctrl_REVDTTMDEL,
        Ctrl_REVISED,
        Ctrl_REVISIONS,
        Ctrl_REVPROP,
        Ctrl_REVPROT,
        Ctrl_REVTBL,
        Ctrl_REVTIM,
        Ctrl_RI,
        Ctrl_RIN,
        Ctrl_ROW,
        Ctrl_RQUOTE,
        Ctrl_RSLTBMP,
        Ctrl_RSLTHTML,
        Ctrl_RSLTMERGE,
        Ctrl_RSLTPICT,
        Ctrl_RSLTRTF,
        Ctrl_RSLTTXT,
        Ctrl_RTF,
        Ctrl_RTLCH,
        Ctrl_RTLDOC,
        Ctrl_RTLGUTTER,
        Ctrl_RTLMARK,
        Ctrl_RTLPAR,
        Ctrl_RTLROW,
        Ctrl_RTLSECT,
        Ctrl_RXE,
        Ctrl_S,
        Ctrl_SA,
        Ctrl_SAAUTO,
        Ctrl_SAUTOUPD,
        Ctrl_SB,
        Ctrl_SBASEDON,
        Ctrl_SBAUTO,
        Ctrl_SBKCOL,
        Ctrl_SBKEVEN,
        Ctrl_SBKNONE,
        Ctrl_SBKODD,
        Ctrl_SBKPAGE,
        Ctrl_SBYS,
        Ctrl_SCAPS,
        Ctrl_SCOMPOSE,
        Ctrl_SEC,
        Ctrl_SECT,
        Ctrl_SECTD,
        Ctrl_SECTDEFAULTCL,
        Ctrl_SECTEXPAND,
        Ctrl_SECTLINEGRID,
        Ctrl_SECTNUM,
        Ctrl_SECTSPECIFYCL,
        Ctrl_SECTSPECIFYGEN,
        Ctrl_SECTSPECIFYL,
        Ctrl_SECTUNLOCKED,
        Ctrl_SHAD,
        Ctrl_SHADING,
        Ctrl_SHIDDEN,
        Ctrl_SHIFT,
        Ctrl_SHPBOTTOM,
        Ctrl_SHPBXCOLUMN,
        Ctrl_SHPBXIGNORE,
        Ctrl_SHPBXMARGIN,
        Ctrl_SHPBXPAGE,
        Ctrl_SHPBYIGNORE,
        Ctrl_SHPBYMARGIN,
        Ctrl_SHPBYPAGE,
        Ctrl_SHPBYPARA,
        Ctrl_SHPFBLWTXT,
        Ctrl_SHPFHDR,
        Ctrl_SHPGRP,
        Ctrl_SHPINST,
        Ctrl_SHPLEFT,
        Ctrl_SHPLID,
        Ctrl_SHPLOCKANCHOR,
        Ctrl_SHPPICT,
        Ctrl_SHPRIGHT,
        Ctrl_SHPRSLT,
        Ctrl_SHPTOP,
        Ctrl_SHPTXT,
        Ctrl_SHPWRK,
        Ctrl_SHPWR,
        Ctrl_SHPZ,
        Ctrl_SL,
        Ctrl_SLMULT,
        Ctrl_SNEXT,
        Ctrl_SOFTCOL,
        Ctrl_SOFTLHEIGHT,
        Ctrl_SOFTLINE,
        Ctrl_SOFTPAGE,
        Ctrl_SPERSONAL,
        Ctrl_SPLYTWNINE,
        Ctrl_SPRSBSP,
        Ctrl_SPRSLNSP,
        Ctrl_SPRSSPBF,
        Ctrl_SPRSTSM,
        Ctrl_SPRSTSP,
        Ctrl_SREPLY,
        Ctrl_STATICVAL,
        Ctrl_STEXTFLOW,
        Ctrl_STRIKE,
        Ctrl_STRIKED,
        Ctrl_STYLESHEET,
        Ctrl_SUB,
        Ctrl_SUBDOCUMENT,
        Ctrl_SUBFONTBYSIZE,
        Ctrl_SUBJECT,
        Ctrl_SUPER,
        Ctrl_SWPBDR,
        Ctrl_TAB,
        Ctrl_TABSNOOVRLP,
        Ctrl_TAPRTL,
        Ctrl_TB,
        Ctrl_TC,
        Ctrl_TCELLD,
        Ctrl_TCF,
        Ctrl_TCL,
        Ctrl_TCN,
        Ctrl_TDFRMTXTBOTTOM,
        Ctrl_TDFRMTXTLEFT,
        Ctrl_TDFRMTXTRIGHT,
        Ctrl_TDFRMTXTTOP,
        Ctrl_TEMPLATE,
        Ctrl_TIME,
        Ctrl_TITLE,
        Ctrl_TITLEPG,
        Ctrl_TLDOT,
        Ctrl_TLEQ,
        Ctrl_TLHYPH,
        Ctrl_TLMDOT,
        Ctrl_TLTH,
        Ctrl_TLUL,
        Ctrl_TPHCOL,
        Ctrl_TPHMRG,
        Ctrl_TPHPG,
        Ctrl_TPOSNEGX,
        Ctrl_TPOSNEGY,
        Ctrl_TPOSXC,
        Ctrl_TPOSXI,
        Ctrl_TPOSXL,
        Ctrl_TPOSX,
        Ctrl_TPOSXO,
        Ctrl_TPOSXR,
        Ctrl_TPOSY,
        Ctrl_TPOSYB,
        Ctrl_TPOSYC,
        Ctrl_TPOSYIL,
        Ctrl_TPOSYIN,
        Ctrl_TPOSYOUTV,
        Ctrl_TPOSYT,
        Ctrl_TPVMRG,
        Ctrl_TPVPARA,
        Ctrl_TPVPG,
        Ctrl_TQC,
        Ctrl_TQDEC,
        Ctrl_TQR,
        Ctrl_TRANSMF,
        Ctrl_TRAUTOFIT,     // TABLE: ROW: 
        Ctrl_TRBRDRB,       // TABLE: ROW: Table row border bottom
        Ctrl_TRBRDRH,       // TABLE: ROW: Table row border horizontal (inside)
        Ctrl_TRBRDRL,       // TABLE: ROW: Table row border left
        Ctrl_TRBRDRR,       // TABLE: ROW: Table row border right
        Ctrl_TRBRDRT,       // TABLE: ROW: Table row border top
        Ctrl_TRBRDRV,       // TABLE: ROW: Table row border vertical (inside)
        Ctrl_TRFTSWIDTHA,   // TABLE: ROW: units for trwWidthA (1 - auto, 2 - pct, 3 - twips
        Ctrl_TRFTSWIDTHB,   // TABLE: ROW: units for trwWidthB (1 - auto, 2 - pct, 3 - twips
        Ctrl_TRFTSWIDTH,    // TABLE: ROW: units for clwWidth (1 - auto, 2 - pct, 3 - twips
        Ctrl_TRGAPH,        // TABLE: ROW: Half the space between cells in a table in twips
        Ctrl_TRHDR,
        Ctrl_TRKEEP,
        Ctrl_TRLEFT,        // TABLE: ROW: Left offset of table in TWIPS, relative to column edge
        Ctrl_TROWD,         // TABLE: ROW: reset defaults
        Ctrl_TRPADDB,       // TABLE: ROW: default bottom cell padding for row (overridden by CLPADDB)
        Ctrl_TRPADDFB,      // TABLE: ROW: units for TRPADDB (0 - ignore, 3 - twips)
        Ctrl_TRPADDFL,      // TABLE: ROW: units for TRPADDL (0 - ignore, 3 - twips)
        Ctrl_TRPADDFR,      // TABLE: ROW: units for TRPADDR (0 - ignore, 3 - twips)
        Ctrl_TRPADDFT,      // TABLE: ROW: units for TRPADDT (0 - ignore, 3 - twips)
        Ctrl_TRPADDL,       // TABLE: ROW: default left cell padding for row (overridden by CLPADDL)
        Ctrl_TRPADDR,       // TABLE: ROW: default right cell padding for row (overridden by CLPADDR)
        Ctrl_TRPADDT,       // TABLE: ROW: default top cell padding for row (overridden by CLPADDT)
        Ctrl_TRQC,          // TABLE: ROW: default cell alignment is centered
        Ctrl_TRQL,          // TABLE: ROW: default cell alignment is left
        Ctrl_TRQR,          // TABLE: ROW: default cell alignment is right
        Ctrl_TRRH,
        Ctrl_TRSPDB,
        Ctrl_TRSPDFB,
        Ctrl_TRSPDFL,
        Ctrl_TRSPDFR,
        Ctrl_TRSPDFT,
        Ctrl_TRSPDL,
        Ctrl_TRSPDR,
        Ctrl_TRSPDT,
        Ctrl_TRUNCATEFONTHEIGHT,
        Ctrl_TRWWIDTHA,     // TABLE: ROW: width of invisible cell at end of row
        Ctrl_TRWWIDTHB,     // TABLE: ROW: width of invisible cell at beginning of row
        Ctrl_TRWWIDTH,      // TABLE: ROW: preferred row width (overrides trautofit)
        Ctrl_TWOONONE,
        Ctrl_TX,
        Ctrl_TXE,
        Ctrl_UC,
        Ctrl_UD,
        Ctrl_UL,
        Ctrl_ULC,
        Ctrl_ULD,
        Ctrl_ULDASH,
        Ctrl_ULDASHD,
        Ctrl_ULDASHDD,
        Ctrl_ULDB,
        Ctrl_ULHAIR,
        Ctrl_ULHWAVE,
        Ctrl_ULLDASH,
        Ctrl_ULNONE,
        Ctrl_ULTH,
        Ctrl_ULTHD,
        Ctrl_ULTHDASH,
        Ctrl_ULTHDASHD,
        Ctrl_ULTHDASHDD,
        Ctrl_ULTHLDASH,
        Ctrl_ULULDBWAVE,
        Ctrl_ULW,
        Ctrl_ULWAVE,
        Ctrl_U,
        Ctrl_UP,
        Ctrl_UPR,
        Ctrl_URTF,
        Ctrl_USELTBALN,
        Ctrl_USERPROPS,
        Ctrl_V,
        Ctrl_VERN,
        Ctrl_VERSION,
        Ctrl_VERTALB,
        Ctrl_VERTALC,
        Ctrl_VERTALJ,
        Ctrl_VERTALT,
        Ctrl_VERTDOC,
        Ctrl_VERTSECT,
        Ctrl_VIEWKIND,
        Ctrl_VIEWSCALE,
        Ctrl_VIEWZK,
        Ctrl_WBITMAP,
        Ctrl_WBMBITSPIXEL,
        Ctrl_WBMPLANES,
        Ctrl_WBMWIDTHBYTES,
        Ctrl_WEBHIDDEN,
        Ctrl_WIDCTLPAR,
        Ctrl_WIDOWCTRL,
        Ctrl_WINDOWCAPTION,
        Ctrl_WMETAFILE,
        Ctrl_WPEQN,
        Ctrl_WPJST,
        Ctrl_WPSP,
        Ctrl_WRAPTRSP,
        Ctrl_XE,
        Ctrl_XEF,
        Ctrl_YR,
        Ctrl_YXE,
        Ctrl_ZWBO,
        Ctrl_ZWJ,
        Ctrl_ZWNBO,
        Ctrl_ZWNJ
    };
}

