# Getting Started

* [Roslyn Overview](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Roslyn-Overview.md)
* [Samples and Walkthroughs](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Samples-and-Walkthroughs.md)
* [Roadmap](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Roadmap.md)
* [Labels used for issues](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Labels-used-for-issues.md)
* [Building, Testing, and Debugging](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Building-Testing-and-Debugging.md)
* [Contributing](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Contributing-Code.md)
* [FAQ](https://github.com/dotnet/roslyn/blob/main/docs/wiki/FAQ.md)
* [Documentation](https://github.com/dotnet/roslyn/blob/main/docs)

# Language Design

* [C# Language Design repo](https://github.com/dotnet/csharplang)
* [VB Language Design repo](https://github.com/dotnet/vblang)
* [Language Feature Status](https://github.com/dotnet/roslyn/blob/main/docs/Language%20Feature%20Status.md)
* [Language Feature Overview for C# 6 and Visual Basic 14](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Languages-features-in-C%23-6-and-VB-14.md)

# Tools

* [Performance considerations for large solutions](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Performance-considerations-for-large-solutions.md)
* [Syntax Visualizer](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Syntax-Visualizer.md)
* [Syntax Quoter](http://roslynquoter.azurewebsites.net), [Source](https://github.com/KirillOsenkov/RoslynQuoter)
* [Enhanced source view](http://sourceroslyn.io), powered by Roslyn

# API Changelist

* [VS 2015 CTP5 Changelist](https://github.com/dotnet/roslyn/blob/main/docs/wiki/VS-2015-CTP-5-API-Changes.md)
* [VS 2015 CTP6 Changelist](https://github.com/dotnet/roslyn/blob/main/docs/wiki/VS-2015-CTP-6-API-Changes.md)
* [VS 2015 RC Changelist](https://github.com/dotnet/roslyn/blob/main/docs/wiki/VS-2015-RC-API-Changes.md)

# Other Topics

* [Project Overview](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Roslyn-Overview.md)
* [Project Roadmap](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Roadmap.md)
* [Labels used for Issues](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Labels-used-for-issues.md)
* [Performance considerations for large solutions](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Performance-considerations-for-large-solutions.md)
* [Other documentation in the repo](https://github.com/dotnet/roslyn/blob/main/docs/)

## Contributors

* [Building, Testing, and Debugging](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Building-Testing-and-Debugging.md)
* [Contributing Code](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Contributing-Code.md)

## Tool Authors

* [Getting Started](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Getting-Started-on-Visual-Studio-2015.md)
* [Samples and Walkthroughs](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Samples-and-Walkthroughs.md)
* [FAQ](https://github.com/dotnet/roslyn/blob/main/docs/wiki/FAQ.md)
* [API Changelist](https://github.com/dotnet/roslyn/blob/main/docs/wiki/API-Changes.md)

## Status

* [Language feature status](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Languages-features-in-C%23-6-and-VB-14.md)
* [Edit-and-Continue Supported Edits](https://github.com/dotnet/roslyn/blob/main/docs/wiki/EnC-Supported-Edits.md)

## .NET Core

* [Runtime Code Generation](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Runtime-code-generation-using-Roslyn-compilations-in-.NET-Core-App.md)

## Interactive and Scripting

* [Interactive Window Documentation](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Interactive-Window.md)
* [Scripting API Samples](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Scripting-API-Samples.md)
* [C# Interactive Walkthrough](https://github.com/dotnet/roslyn/blob/main/docs/wiki/C%23-Interactive-Walkthrough.md)

## Testing

* [Manual Testing](https://github.com/dotnet/roslyn/blob/main/docs/wiki/Manual-Testing.md)  
* [How to Investigate CI Test Failures](https://github.com/dotnet/roslyn/blob/main/docs/wiki/How-To-Investigate-CI-Test-Failures.md)