/*
	Copyright (c) 2010 by Dennis Schridde

	This file is part of dovecot-metadata.

	dovecot-metadata is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	dovecot-metadata is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with dovecot-metadata.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef DOVECOT_METADATA_BACKEND_H
#define DOVECOT_METADATA_BACKEND_H

#include "metadata-global.h"

#include <stdbool.h>

#include "metadata-entry.h"

enum metadata_error {
	METADATA_ERROR_NONE = 0,
	METADATA_ERROR_UNKNOWN,
	METADATA_ERROR_INVALID,
	METADATA_ERROR_TOOLARGE,
	METADATA_ERROR_TOOMANY
};

const char *
metadata_error_tostring(enum metadata_error error);

int
metadata_get_entry(struct metadata_entry *entry, struct mail_user *user)
	ATTR_NONNULL(1,2);
int
metadata_set_entry(struct metadata_entry *entry, struct mail_user *user)
	ATTR_NONNULL(1,2);

const int METADATA_ITERATE_DEPTH_INF = INT_MAX;

struct metadata_iterate_context;

struct metadata_iterate_context *
metadata_iterate_init(struct mailbox *mailbox, struct metadata_entry *entry, unsigned int depth)
	ATTR_NONNULL(1,2);
bool
metadata_iterate(struct metadata_iterate_context *ctx, struct metadata_entry *entry)
	ATTR_NONNULL(1,2);
int
metadata_iterate_deinit(struct metadata_iterate_context **ctx)
	ATTR_NONNULL(1);

#endif
