/*
// $Id: //open/dev/farrago/src/net/sf/farrago/test/FarragoMockPrincipal.java#6 $
// Farrago is an extensible data management system.
// Copyright (C) 2005-2009 The Eigenbase Project
// Copyright (C) 2005-2009 SQLstream, Inc.
// Copyright (C) 2005-2009 LucidEra, Inc.
// Portions Copyright (C) 2004-2009 John V. Sichi
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or (at your option)
// any later version approved by The Eigenbase Project.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package net.sf.farrago.test;

import java.io.*;

import java.security.*;


/**
 * Mock JAAS principal class
 *
 * @author Oscar Gothberg
 * @version $Id: //open/dev/farrago/src/net/sf/farrago/test/FarragoMockPrincipal.java#6 $
 */

public class FarragoMockPrincipal
    implements Serializable,
        Principal
{
    //~ Instance fields --------------------------------------------------------

    private String name;

    //~ Constructors -----------------------------------------------------------

    public FarragoMockPrincipal()
    {
        name = "";
    }

    public FarragoMockPrincipal(String newName)
    {
        name = newName;
    }

    //~ Methods ----------------------------------------------------------------

    public boolean equals(Object o)
    {
        if (o == null) {
            return false;
        }

        if (this == o) {
            return true;
        }

        if (o instanceof FarragoMockPrincipal) {
            if (((FarragoMockPrincipal) o).getName().equals(name)) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public int hashCode()
    {
        return name.hashCode();
    }

    public String toString()
    {
        return name;
    }

    public String getName()
    {
        return name;
    }
}

// End FarragoMockPrincipal.java
