/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import MCview.AppletPDBViewer;
import jalview.appletgui.AlignFrame;
import jalview.appletgui.AppletJmol;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.Sequence;
import jalview.io.AnnotationFile;
import jalview.io.AppletFormatAdapter;
import jalview.io.IdentifyFile;
import jalview.io.NewickFile;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;

public class CutAndPasteTransfer
extends Panel
implements ActionListener,
MouseListener {
    boolean pdbImport = false;
    boolean treeImport = false;
    boolean annotationImport = false;
    Sequence seq;
    AlignFrame alignFrame;
    protected TextArea textarea = new TextArea();
    Button accept = new Button("New Window");
    Button addSequences = new Button("Add to Current Alignment");
    Button cancel = new Button("Close");
    protected Panel buttonPanel = new Panel();
    BorderLayout borderLayout1 = new BorderLayout();

    public CutAndPasteTransfer(boolean forImport, AlignFrame alignFrame) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.alignFrame = alignFrame;
        if (!forImport) {
            this.buttonPanel.setVisible(false);
        }
    }

    public String getText() {
        return this.textarea.getText();
    }

    public void setText(String text) {
        this.textarea.setText(text);
    }

    public void setPDBImport(Sequence seq) {
        this.seq = seq;
        this.accept.setLabel("Accept");
        this.addSequences.setVisible(false);
        this.pdbImport = true;
    }

    public void setTreeImport() {
        this.treeImport = true;
        this.accept.setLabel("Accept");
        this.addSequences.setVisible(false);
    }

    public void setAnnotationImport() {
        this.annotationImport = true;
        this.accept.setLabel("Accept");
        this.addSequences.setVisible(false);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.accept) {
            this.ok(true);
        } else if (evt.getSource() == this.addSequences) {
            this.ok(false);
        } else if (evt.getSource() == this.cancel) {
            this.cancel();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void ok(boolean newWindow) {
        text = this.getText();
        length = text.length();
        this.textarea.append("\n");
        if (this.textarea.getText().length() == length) {
            warning = "\n\n#################################################\nWARNING!! THIS IS THE MAXIMUM SIZE OF TEXTAREA!!\n\nCAN'T INPUT FULL ALIGNMENT\n\nYOU MUST DELETE THIS WARNING TO CONTINUE\n\nMAKE SURE LAST SEQUENCE PASTED IS COMPLETE\n#################################################\n";
            this.textarea.setText(text.substring(0, text.length() - warning.length()) + warning);
            this.textarea.setCaretPosition(text.length());
        }
        if (this.pdbImport) {
            pdb = new PDBEntry();
            pdb.setFile(text);
            if (this.alignFrame.alignPanel.av.applet.jmolAvailable) {
                new AppletJmol(pdb, new Sequence[]{this.seq}, null, this.alignFrame.alignPanel, AppletFormatAdapter.PASTE);
            } else {
                new AppletPDBViewer(pdb, new Sequence[]{this.seq}, null, this.alignFrame.alignPanel, AppletFormatAdapter.PASTE);
            }
        } else if (this.treeImport) {
            try {
                fin = new NewickFile(this.textarea.getText(), "Paste");
                fin.parse();
                if (fin.getTree() == null) ** GOTO lbl49
                this.alignFrame.loadTree(fin, "Pasted tree file");
            }
            catch (Exception ex) {
                this.textarea.setText("Could not parse Newick file!\n" + ex);
                return;
            }
        } else if (this.annotationImport) {
            if (new AnnotationFile().readAnnotationFile(this.alignFrame.viewport.alignment, this.textarea.getText(), AppletFormatAdapter.PASTE)) {
                this.alignFrame.alignPanel.fontChanged();
                this.alignFrame.alignPanel.setScrollValues(0, 0);
            } else {
                this.alignFrame.parseFeaturesFile(this.textarea.getText(), AppletFormatAdapter.PASTE);
            }
        } else if (this.alignFrame != null) {
            al = null;
            format = new IdentifyFile().Identify(text, AppletFormatAdapter.PASTE);
            try {
                al = new AppletFormatAdapter().readFile(text, AppletFormatAdapter.PASTE, format);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (al != null) {
                if (newWindow) {
                    af = new AlignFrame(al, this.alignFrame.viewport.applet, "Cut & Paste input - " + format, false);
                    af.statusBar.setText("Successfully pasted alignment file");
                } else {
                    this.alignFrame.addSequences(al.getSequencesArray());
                }
            }
        }
lbl49:
        // 12 sources

        if (this.getParent() instanceof Frame) {
            ((Frame)this.getParent()).setVisible(false);
        } else {
            ((Dialog)this.getParent()).setVisible(false);
        }
    }

    protected void cancel() {
        this.textarea.setText("");
        if (this.getParent() instanceof Frame) {
            ((Frame)this.getParent()).setVisible(false);
        } else {
            ((Dialog)this.getParent()).setVisible(false);
        }
    }

    private void jbInit() throws Exception {
        this.textarea.setFont(new Font("Monospaced", 0, 10));
        this.textarea.setText("Paste your alignment file here");
        this.textarea.addMouseListener(this);
        this.setLayout(this.borderLayout1);
        this.accept.addActionListener(this);
        this.addSequences.addActionListener(this);
        this.cancel.addActionListener(this);
        this.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.accept, null);
        this.buttonPanel.add(this.addSequences);
        this.buttonPanel.add((Component)this.cancel, null);
        this.add((Component)this.textarea, "Center");
    }

    public void mousePressed(MouseEvent evt) {
        if (this.textarea.getText().startsWith("Paste your")) {
            this.textarea.setText("");
        }
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }
}

