/* $Id: AssociationElement.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __ASSOCIATION_ELEMENT_HPP_INCLUDED
#define __ASSOCIATION_ELEMENT_HPP_INCLUDED

#include <list>
#include "frontend/ast/Expression.hpp"
#include "frontend/ast/SimpleName.hpp"

namespace ast {
	
/** one VHDL AssociationElement */
class AssociationElement : public AstNode {
public:
	//! c'tor
	/** @param formalPart formal part
          * @param actualPart actual part (or NULL, if open)
	  * @param loc location of the AssociationElement.
          */
	AssociationElement(
		Name *formalPart,
		Expression *actualPart,
		Location loc
		) : 	AstNode(loc),
			formal(formalPart),
			actual(actualPart),
			pos(-1),
			hiddenFormal(NULL) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		if (this->formal != NULL) {
			stream << *this->formal << " => ";
		}

		if (this->actual != NULL) {
			stream << *this->actual;
		} else {
			stream << "(open)";
		}
	}

	/** formal part (name) */
	Name *formal;
	/** actual part or NULL if it's open. */
	Expression *actual;
	/** position of the associaton, -1 means unset, 0 is first position */
	int pos;
	/** optional name of the formal, in case storage space is needed
	 *  for an association */
	SimpleName *hiddenFormal;

protected:
	/** Destructor */
	virtual ~AssociationElement() {
		util::MiscUtil::terminate(this->formal);
		util::MiscUtil::terminate(this->actual);
	}
};
	
}; /* namespace ast */

#endif /* __ASSOCIATION_ELEMENT_HPP_INCLUDED */
