#!/usr/bin/env python3

import configparser
import os
import sys
from inspect import isfunction
from os import listdir
from os.path import isfile
from os.path import join

from xdg import BaseDirectory

# Get configuration directory
if len(sys.argv) > 1:
    config_path = sys.argv[1]
elif os.geteuid() == 0:
    # Save settings system wide
    config_path = "/etc/fenrir.conf"
else:
    # Use local settings
    config_path = BaseDirectory.xdg_data_home + "/fenrir"
    if not os.path.exists(config_path):
        os.makedirs(config_path)
    config_path = config_path + "/fenrir.conf"
