/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;
import thredds.ui.ProgressMonitorTask;
import thredds.ui.TextHistoryPane;
import thredds.ui.UrlAuthenticatorDialog;
import ucar.nc2.util.IO;
import ucar.nc2.util.URLnaming;
import ucar.nc2.util.net.HttpClientManager;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.XMLStore;
import ucar.util.prefs.ui.ComboBox;

public class URLDumpPane
extends TextHistoryPane {
    private static final int GET = 0;
    private static final int PUT = 1;
    private static final int HEAD = 2;
    private static final int OPTIONS = 3;
    private ComboBox cb;
    private HttpURLConnection currentConnection = null;
    private static XMLStore xstore;
    private static URLDumpPane main;

    public URLDumpPane(PreferencesExt prefs) {
        super(true);
        this.cb = new ComboBox(prefs);
        JButton headButton2 = new JButton("Head");
        headButton2.setToolTipText("Open URL connection, Headers only using HttpClient");
        headButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String urlString = (String)URLDumpPane.this.cb.getSelectedItem();
                URLDumpPane.this.openURL2(urlString, 2);
                URLDumpPane.this.gotoTop();
                URLDumpPane.this.cb.addItem(urlString);
            }
        });
        JButton read2Button = new JButton("Get");
        read2Button.setToolTipText("Open URL connection, Get content using HttpClient");
        read2Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String urlString = (String)URLDumpPane.this.cb.getSelectedItem();
                URLDumpPane.this.openURL2(urlString, 0);
                URLDumpPane.this.gotoTop();
                URLDumpPane.this.cb.addItem(urlString);
            }
        });
        JButton opt2Button = new JButton("Options");
        opt2Button.setToolTipText("Server options using HttpClient");
        opt2Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String urlString = (String)URLDumpPane.this.cb.getSelectedItem();
                URLDumpPane.this.openURL2(urlString, 3);
                URLDumpPane.this.gotoTop();
                URLDumpPane.this.cb.addItem(urlString);
            }
        });
        JButton put2Button = new JButton("Put");
        put2Button.setToolTipText("Put using HttpClient");
        put2Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String urlString = (String)URLDumpPane.this.cb.getSelectedItem();
                URLDumpPane.this.openURL2(urlString, 1);
                URLDumpPane.this.gotoTop();
                URLDumpPane.this.cb.addItem(urlString);
            }
        });
        JButton headButton = new JButton("HEAD");
        headButton.setToolTipText("Open URL connection, HEADERS only using HttpURLConnection");
        headButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String urlString = (String)URLDumpPane.this.cb.getSelectedItem();
                URLDumpPane.this.openURL(urlString, "HEAD");
                URLDumpPane.this.gotoTop();
                URLDumpPane.this.cb.addItem(urlString);
            }
        });
        JButton readButton = new JButton("GET");
        readButton.setToolTipText("Open URL connection, show content using HttpURLConnection");
        readButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String urlString = (String)URLDumpPane.this.cb.getSelectedItem();
                URLDumpPane.this.readURL(urlString);
                URLDumpPane.this.gotoTop();
                URLDumpPane.this.cb.addItem(urlString);
            }
        });
        JButton optButton = new JButton("OPTIONS");
        optButton.setToolTipText("Get server options using HttpURLConnection");
        optButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String urlString = (String)URLDumpPane.this.cb.getSelectedItem();
                URLDumpPane.this.openURL(urlString, "OPTIONS");
                URLDumpPane.this.gotoTop();
                URLDumpPane.this.cb.addItem(urlString);
            }
        });
        JButton putButton = new JButton("PUT");
        putButton.setToolTipText("Send PUT command using HttpURLConnection");
        putButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String urlString = (String)URLDumpPane.this.cb.getSelectedItem();
                URLDumpPane.this.openURL(urlString, "PUT");
                URLDumpPane.this.gotoTop();
                URLDumpPane.this.cb.addItem(urlString);
            }
        });
        JPanel buttPanel = new JPanel(new FlowLayout(0, 5, 0));
        buttPanel.add(headButton2);
        buttPanel.add(read2Button);
        buttPanel.add(opt2Button);
        buttPanel.add(putButton);
        buttPanel.add(put2Button);
        buttPanel.add(headButton);
        buttPanel.add(readButton);
        buttPanel.add(optButton);
        buttPanel.add(putButton);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new JLabel("URL:"), "West");
        topPanel.add((Component)this.cb, "Center");
        topPanel.add((Component)buttPanel, "East");
        this.add((Component)topPanel, "North");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openURL2(String urlString, int cmd) {
        this.clear();
        HttpClient httpclient = HttpClientManager.getHttpClient();
        HttpMethodBase m = null;
        try {
            Object p;
            urlString = URLnaming.escapeQuery(urlString);
            if (cmd == 0) {
                m = new GetMethod(urlString);
            } else if (cmd == 2) {
                m = new HeadMethod(urlString);
            } else if (cmd == 3) {
                m = new OptionsMethod(urlString);
            } else if (cmd == 1) {
                p = new PutMethod(urlString);
                try {
                    ((EntityEnclosingMethod)p).setRequestEntity(new StringRequestEntity(this.ta.getText(), "application/text", "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(5000);
                    e.printStackTrace(new PrintStream(bos));
                    this.appendLine(bos.toString());
                    if (m != null) {
                        m.releaseConnection();
                    }
                    return;
                }
                m = p;
            }
            m.setRequestHeader("Accept-Encoding", "gzip,deflate");
            this.appendLine("HttpClient " + m.getName() + " " + urlString);
            this.appendLine("   do Authentication= " + m.getDoAuthentication());
            this.appendLine("   follow Redirects= " + m.getFollowRedirects());
            p = m.getParams();
            this.appendLine("   cookie policy= " + ((HttpMethodParams)p).getCookiePolicy());
            this.appendLine("   http version= " + ((HttpMethodParams)p).getVersion().toString());
            this.appendLine("   timeout (msecs)= " + ((HttpMethodParams)p).getSoTimeout());
            this.appendLine("   virtual host= " + ((HttpMethodParams)p).getVirtualHost());
            this.printHeaders("Request Headers = ", m.getRequestHeaders());
            this.appendLine(" ");
            httpclient.executeMethod(m);
            this.printHeaders("Request Headers2 = ", m.getRequestHeaders());
            this.appendLine(" ");
            this.appendLine("Status = " + m.getStatusCode() + " " + m.getStatusText());
            this.appendLine("Status Line = " + m.getStatusLine());
            this.printHeaders("Response Headers = ", m.getResponseHeaders());
            if (cmd == 0) {
                String encoding;
                this.appendLine("\nResponseBody---------------");
                String charset = m.getResponseCharSet();
                if (charset == null) {
                    charset = "UTF-8";
                }
                String contents = null;
                Header h = m.getResponseHeader("content-encoding");
                String string = encoding = h == null ? null : h.getValue();
                if (encoding != null && encoding.equals("deflate")) {
                    byte[] body = m.getResponseBody();
                    BufferedInputStream is = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(body)), 10000);
                    contents = IO.readContents(is, charset);
                    double ratio = (double)contents.length() / (double)body.length;
                    this.appendLine("  deflate encoded=" + body.length + " decoded=" + contents.length() + " ratio= " + ratio);
                } else if (encoding != null && encoding.equals("gzip")) {
                    byte[] body = m.getResponseBody();
                    BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(body)), 10000);
                    contents = IO.readContents(is, charset);
                    double ratio = (double)contents.length() / (double)body.length;
                    this.appendLine("  gzip encoded=" + body.length + " decoded=" + contents.length() + " ratio= " + ratio);
                } else {
                    byte[] body = m.getResponseBody(50000);
                    contents = new String(body, charset);
                }
                if (contents.length() > 50000) {
                    contents = contents.substring(0, 50000);
                }
                this.appendLine(contents);
            } else if (cmd == 3) {
                this.printEnum("AllowedMethods = ", ((OptionsMethod)m).getAllowedMethods());
            }
            this.printHeaders("Response Footers = ", m.getResponseFooters());
        }
        catch (Exception e) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(5000);
            e.printStackTrace(new PrintStream(bos));
            this.appendLine(bos.toString());
        }
        finally {
            if (m != null) {
                m.releaseConnection();
            }
        }
    }

    String readContents(InputStream is, String charset, int maxKbytes) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1000 * maxKbytes);
        IO.copy(is, bout, 1000 * maxKbytes);
        return bout.toString(charset);
    }

    private void printHeaders(String title, Header[] heads) {
        this.appendLine(title);
        for (int i = 0; i < heads.length; ++i) {
            Header head = heads[i];
            this.append("  " + head.toString());
        }
    }

    private void printEnum(String title, Enumeration en) {
        this.appendLine(title);
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            this.append("  " + o.toString());
        }
        this.appendLine("");
    }

    private void openURL(String urlString, String command) {
        try {
            URL u = new URL(urlString);
            this.currentConnection = (HttpURLConnection)u.openConnection();
            this.currentConnection.setRequestMethod(command);
            this.currentConnection.setAllowUserInteraction(true);
            this.clear();
            this.appendLine(command + " request for " + urlString);
            Map<String, List<String>> reqs = this.currentConnection.getRequestProperties();
            for (String key : reqs.keySet()) {
                this.append(" " + key + ": ");
                for (String v : reqs.get(key)) {
                    this.append(v + " ");
                }
                this.appendLine("");
            }
            this.appendLine("");
            this.appendLine("getFollowRedirects=" + HttpURLConnection.getFollowRedirects());
            this.appendLine("getInstanceFollowRedirects=" + this.currentConnection.getInstanceFollowRedirects());
            this.appendLine("AllowUserInteraction=" + this.currentConnection.getAllowUserInteraction());
            this.appendLine("");
            int code = this.currentConnection.getResponseCode();
            String response = this.currentConnection.getResponseMessage();
            this.appendLine(" HTTP/1.x " + code + " " + response);
            this.appendLine(" content-length: " + this.currentConnection.getContentLength());
            this.appendLine(" content-encoding: " + this.currentConnection.getContentEncoding());
            this.appendLine(" content-type: " + this.currentConnection.getContentType());
            this.appendLine("\nHeaders: ");
            int j = 1;
            while (true) {
                String header = this.currentConnection.getHeaderField(j);
                String key = this.currentConnection.getHeaderFieldKey(j);
                if (header == null || key == null) break;
                this.appendLine(" " + key + ": " + header);
                ++j;
            }
            this.appendLine("");
            this.appendLine("contents:");
            InputStream is = this.currentConnection.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(200000);
            IO.copy(is, bout);
            is.close();
            this.append(new String(bout.toByteArray()));
            this.appendLine("end contents");
        }
        catch (MalformedURLException e) {
            this.append(urlString + " is not a parseable URL");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println(e);
        }
    }

    private void readURL(String urlString) {
        try {
            URL u = new URL(urlString);
            this.currentConnection = (HttpURLConnection)u.openConnection();
            this.clear();
            this.appendLine("GET request for " + urlString);
            Map<String, List<String>> reqs = this.currentConnection.getRequestProperties();
            for (String key : reqs.keySet()) {
                this.append(" " + key + ": ");
                for (String v : reqs.get(key)) {
                    this.append(v + " ");
                }
                this.appendLine("");
            }
            this.appendLine("");
            int code = this.currentConnection.getResponseCode();
            String response = this.currentConnection.getResponseMessage();
            this.appendLine(" HTTP/1.x " + code + " " + response);
            int j = 1;
            while (true) {
                String header = this.currentConnection.getHeaderField(j);
                String key = this.currentConnection.getHeaderFieldKey(j);
                if (header == null || key == null) break;
                this.appendLine(" " + key + ": " + header);
                ++j;
            }
            this.appendLine("");
            InputStream is = this.currentConnection.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(200000);
            IO.copy(is, bout);
            is.close();
            this.append(new String(bout.toByteArray()));
        }
        catch (MalformedURLException e) {
            this.append(urlString + " is not a parseable URL");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println(e);
            this.appendLine(e.getMessage());
        }
    }

    public void setURL(String urlString) {
        if (urlString == null) {
            return;
        }
        this.cb.addItem(urlString);
        this.clear();
    }

    void putURL(String urlString) {
        if (urlString == null) {
            return;
        }
        String contents = this.ta.getText();
        IO.HttpResult result = IO.putToURL(urlString, contents);
        JOptionPane.showMessageDialog(this, "Status code= " + result.statusCode + "\n" + result.message);
    }

    public void save() {
        this.cb.save();
    }

    public void clear() {
        this.ta.setText(null);
    }

    public void gotoTop() {
        this.ta.setCaretPosition(0);
    }

    public void setText(String text) {
        this.ta.setText(text);
    }

    public void append(String text) {
        this.ta.append(text);
    }

    public void appendLine(String text) {
        this.ta.append(text);
        this.ta.append("\n");
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame("URL Dump Pane");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                try {
                    main.save();
                    xstore.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                System.exit(0);
            }
        });
        Authenticator.setDefault(new UrlAuthenticatorDialog(frame));
        try {
            String storeFilename = XMLStore.makeStandardFilename(".unidata", "URLDumpPane.xml");
            xstore = XMLStore.createFromFile(storeFilename, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PreferencesExt store = xstore.getPreferences();
        main = new URLDumpPane(store);
        frame.getContentPane().add(main);
        frame.pack();
        frame.setLocation(200, 200);
        frame.setSize(900, 700);
        frame.setVisible(true);
    }

    private class GetContentsTask
    extends ProgressMonitorTask {
        String urlString;
        String contents;

        GetContentsTask(String urlString) {
            this.urlString = urlString;
        }

        public void run() {
            try {
                this.contents = IO.readURLcontentsWithException(this.urlString);
            }
            catch (IOException e) {
                this.setError(e.getMessage());
                this.done = true;
                return;
            }
            this.success = !this.cancel;
            this.done = true;
        }
    }
}

