/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import visad.Data;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadRepositoryException;
import visad.data.FormNode;

public abstract class Repository {
    private final String name;
    private final String location;
    protected FormNode forms;

    public Repository(String name, String location) {
        this.name = name;
        this.location = location;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public FormNode getForms() {
        return this.forms;
    }

    public FormNode getForms(Data data) throws VisADException, IOException, RemoteException {
        return this.forms.getForms(data);
    }

    public abstract Enumeration getEnumeration() throws BadRepositoryException, SecurityException;

    public void save(String id, Data data, boolean replace) throws VisADException, IOException, RemoteException {
        this.forms.save(this.fullName(id), data, replace);
    }

    public void save(String id, Data data, FormNode form, boolean replace) throws VisADException, RemoteException, IOException {
        form.save(this.fullName(id), data, replace);
    }

    public void add(String id, Data data, boolean replace) throws VisADException {
        this.forms.add(this.fullName(id), data, replace);
    }

    public DataImpl open(String id) throws VisADException, IOException {
        return this.forms.open(this.fullName(id));
    }

    public DataImpl open(URL url) throws VisADException, IOException {
        return this.forms.open(url);
    }

    protected abstract String fullName(String var1);
}

