/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.out;

import java.io.IOException;
import ucar.netcdf.Attribute;
import visad.DoubleSet;
import visad.FloatSet;
import visad.Real;
import visad.RealType;
import visad.ScalarType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.netcdf.out.DependentVar;
import visad.data.netcdf.out.VisADAccessor;

class DependentRealVar
extends DependentVar {
    private final Number fillValue;

    protected DependentRealVar(Real real, VisADAccessor accessor) throws VisADException, BadFormException {
        super(((ScalarType)real.getType()).getName(), DependentRealVar.getJavaClass(((RealType)real.getType()).getDefaultSet()), accessor.getDimensions(), DependentRealVar.myAttributes(real), accessor);
        this.fillValue = DependentRealVar.getFillValue(DependentRealVar.getJavaClass(((RealType)real.getType()).getDefaultSet()));
    }

    protected static Attribute[] myAttributes(Real real) throws VisADException, BadFormException {
        RealType realType = (RealType)real.getType();
        Number fillNumber = DependentRealVar.getFillValue(DependentRealVar.getJavaClass(realType.getDefaultSet()));
        Unit unit = real.getUnit();
        Attribute[] attrs = unit == null ? new Attribute[]{new Attribute("_FillValue", fillNumber)} : new Attribute[]{new Attribute("_FillValue", fillNumber), new Attribute("units", unit.toString())};
        return attrs;
    }

    protected static Class getJavaClass(Set set) throws VisADException {
        if (set == null || set instanceof DoubleSet) {
            return Double.TYPE;
        }
        if (set instanceof FloatSet) {
            return Float.TYPE;
        }
        int nelts = set.getLength();
        return nelts >= 65536 ? Integer.TYPE : (nelts >= 256 ? Short.TYPE : Byte.TYPE);
    }

    protected static Number getFillValue(Class type) throws BadFormException {
        Number number;
        if (type.equals(Byte.TYPE)) {
            number = new Byte(-128);
        } else if (type.equals(Short.TYPE)) {
            number = new Short(-32767);
        } else if (type.equals(Integer.TYPE)) {
            number = new Integer(-2147483647);
        } else if (type.equals(Float.TYPE)) {
            number = new Float((double)9.96921E36f);
        } else if (type.equals(Double.TYPE)) {
            number = new Double(9.96921E36f);
        } else {
            throw new BadFormException("Unknown netCDF type: " + type);
        }
        return number;
    }

    public Object get(int[] indexes) throws IOException {
        Double value = (Double)this.getAccessor().get(indexes);
        return value.isNaN() ? (Number)this.fillValue : (Number)value;
    }
}

