/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.Delaunay;
import visad.DelaunayClarkson;
import visad.DelaunayCustom;
import visad.DelaunayFast;
import visad.DelaunayOverlap;
import visad.DelaunayWatson;
import visad.VisADException;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryIntegerMatrix;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySerializedObject;

public class BinaryDelaunay
implements BinaryObject {
    public static final int computeBytes(Delaunay d) {
        if (!BinaryDelaunay.isKnownClass(d)) {
            return BinarySerializedObject.computeBytes(d);
        }
        return 2 + BinaryIntegerMatrix.computeBytes(d.Tri) + 1 + BinaryIntegerMatrix.computeBytes(d.Vertices) + 1 + BinaryIntegerMatrix.computeBytes(d.Walk) + 1 + BinaryIntegerMatrix.computeBytes(d.Edges) + 6;
    }

    public static final Delaunay read(DataInput file) throws IOException, VisADException {
        int[][] tri = null;
        int[][] verts = null;
        int[][] walk = null;
        int[][] edges = null;
        int numEdges = -1;
        boolean reading = true;
        block10: while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 61: {
                    tri = BinaryIntegerMatrix.read(file);
                    continue block10;
                }
                case 62: {
                    verts = BinaryIntegerMatrix.read(file);
                    continue block10;
                }
                case 63: {
                    walk = BinaryIntegerMatrix.read(file);
                    continue block10;
                }
                case 64: {
                    edges = BinaryIntegerMatrix.read(file);
                    continue block10;
                }
                case 65: {
                    numEdges = file.readInt();
                    continue block10;
                }
                case 80: {
                    reading = false;
                    continue block10;
                }
            }
            throw new IOException("Unknown Delaunay directive " + directive);
        }
        return new DelaunayCustom(null, tri, verts, walk, edges, numEdges);
    }

    private static final boolean isKnownClass(Delaunay delaunay) {
        Class<?> dClass = delaunay.getClass();
        return dClass.equals(DelaunayClarkson.class) || dClass.equals(DelaunayCustom.class) || dClass.equals(DelaunayFast.class) || dClass.equals(DelaunayOverlap.class) || dClass.equals(DelaunayWatson.class);
    }

    public static final void write(BinaryWriter writer, Delaunay delaunay, Object token) throws IOException {
        if (!BinaryDelaunay.isKnownClass(delaunay)) {
            BinarySerializedObject.write(writer, (byte)21, delaunay, token);
            return;
        }
        DataOutput file = writer.getOutput();
        file.writeByte(60);
        file.writeByte(61);
        BinaryIntegerMatrix.write(file, delaunay.Tri);
        file.writeByte(62);
        BinaryIntegerMatrix.write(file, delaunay.Vertices);
        file.writeByte(63);
        BinaryIntegerMatrix.write(file, delaunay.Walk);
        file.writeByte(64);
        BinaryIntegerMatrix.write(file, delaunay.Edges);
        file.writeByte(65);
        file.writeInt(delaunay.NumEdges);
        file.writeByte(80);
    }
}

