#include <pygoom.h>
#include <stdio.h>

// module init function
PyMODINIT_FUNC initpygoom(void) {
	import_pygame_surface();
   (void) Py_InitModule("pygoom", pygoomMethods);
}

/* ***** Methods *************************************************************/

// Set the export file for mplayer
static PyObject* pygoom_set_exportfile(PyObject *self, PyObject *args) {
	if (!PyArg_ParseTuple(args, "s", &sharedfile))
		return (PyObject*) NULL;
	RETURN_NONE;
}

// Get the export file for mplayer
static PyObject* pygoom_get_exportfile(PyObject *self, PyObject *args) {
	if(!sharedfile) {
		RETURN_NONE;
	}
	return Py_BuildValue("s", sharedfile);
}

// Set screenresolution
static PyObject* pygoom_set_resolution(PyObject *self, PyObject *args) {

	if (!PyArg_ParseTuple(args, "iii", &width, &height, &cinema))
		return NULL;

	if(init == 1) {
		goom_set_resolution(width, height, cinema);
		surf = SDL_CreateRGBSurface(0, width, height, 32, 0, 0, 0, 0);
		if(!surf) {
			return RAISE(PyExc_ValueError,"Surface error");
		}
	}
	RETURN_NONE;
}

// Change visualization
static PyObject* pygoom_set_visual(PyObject *self, PyObject *args) {
	/* from goom/filters.h:
	#define NORMAL_MODE 0
	#define WAVE_MODE 1
	#define CRYSTAL_BALL_MODE 2
	#define SCRUNCH_MODE 3
	#define AMULETTE_MODE 4
	#define WATER_MODE 5
	#define HYPERCOS1_MODE 6
	#define HYPERCOS2_MODE 7
	*/
	int val;
	if (!PyArg_ParseTuple(args, "i", &val))
		return NULL;

	// not sure about these, should perhaps 
	// take -1 as well
	if(val>8 || val<1) {
		PyErr_SetString(PyExc_ValueError, "Use values between 1 and 8");
		return NULL;
	}
	else {
		FXMODE = val;
	}

	RETURN_NONE;
}

static PyObject* pygoom_set_title(PyObject *self, PyObject *args) {
	if (!PyArg_ParseTuple(args, "s", &songtitle))
		return NULL;

	RETURN_NONE;
}

static PyObject* pygoom_set_message(PyObject *self, PyObject *args) {
	if (!PyArg_ParseTuple(args, "s", &message))
		return NULL;

	RETURN_NONE;
}


// our main method for processing images
// should  return a surface no matter what in the future
static PyObject* pygoom_process(PyObject *self, PyObject *args) {
	FILE *fh = fopen("/tmp/djw", "a");

	if (init == 0) {
		fprintf(fh, "data_import_init()\n"); fflush(fh);
		if (data_import_init() == 0) {
			goom_init(width, height, cinema);
			goom_setAsmUse(1);
			init = 1;
		}
		else {
			data_import_clean();
			return RAISE(PyExc_ValueError, "Error initializing mmap" );
		}
	}

	if(mmap_area->count > counter || mmap_area->count < counter) {
		counter = mmap_area->count;

		fprintf(fh, "memcpy(%p, %p, %d)\n",data, ((char *)mmap_area)+sizeof(data_t), 2048); fflush(fh);
		memcpy(data, ((char *)mmap_area) + sizeof(data_t), 2048 );
		fprintf(fh, "render_data = goom_update(data, 0, FXMODE, NULL, NULL)\n");
		render_data = goom_update(data, 0, FXMODE, NULL, NULL);
		fprintf(fh, "render_data = %p\n", render_data);
		
		if(!render_data) {
			data_import_clean();
			return RAISE(PyExc_ValueError, "Goom didn't give any result!");
		}
		
		if(!surf) {
			return RAISE(PyExc_ValueError, "Resolution not set");
		}

		fprintf(fh, "memcpy(%p, %p, %ld)\n", surf->pixels, render_data, width*height*sizeof(uint32_t)); fflush(fh);
		memcpy( surf->pixels, render_data, width * height * sizeof(uint32_t));
	}
	fclose(fh);
	return Py_BuildValue("O", PySurface_New(surf));
}


// cleanups
static PyObject* pygoom_cleanup(PyObject *self, PyObject *args) {
	data_import_clean();
	RETURN_NONE;
}


void data_import_clean(void) {
	if (init == 1) {
		goom_close();
		counter = 0;
		init = 0;
	}
}

// imports the datafile
int data_import_init(void) {
	fd = open(sharedfile, O_RDONLY);

	if (fd < 0)
		return -1;

	mmap_area = mmap(0, sizeof(data_t), PROT_READ, MAP_SHARED, fd, 0);
	if (!mmap_area)
		return -2;
	mmap_area = mremap( mmap_area, sizeof(data_t), sizeof(data_t) + mmap_area->bs, 0 );
	surf = SDL_CreateRGBSurface(0, width, height, 32, 0, 0, 0, 0);
	
	if(surf)
		return(0);

	return -3;
}
