/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import Ubuntu.Components 0.1
import Ubuntu.Components.ListItems 0.1 as ListItem
import Ubuntu.Components.Popups 0.1
import Ubuntu.OnlineAccounts 0.1
import Friends 0.2

Item {
    id: post
    anchors {
        fill: parent
    }

    EntryField {
        id: entry

        anchors {
            top: parent.top
            left: parent.left
            right: parent.right
            topMargin: units.gu(1)
        }

        height: units.gu(8)
        hideable: false

        accountIds: {
            var result = []

            for (var i=0; i<accountsModel.count; i++) {
                if (accountsModel.get(i).sendEnabled) {
                    result.push(accountsModel.get(i).id)
                }
            }

            return result
        }

        replyToId: null

        onSendDone: {
            pageStack.pop();
        }
    }

    Component {
        id: accountServiceComponent
        AccountService {
            autoSync: false
        }
    }

    AccountServiceModel {
        id: accounts
        serviceType: "microblogging"

        Component.onCompleted: {
            for (var i=0; i<accounts.count; i++) {
                var accountServiceHandle = accounts.get(i, "accountServiceHandle");
                var accountService = accountServiceComponent.createObject(null,
                                                                          { "objectHandle": accountServiceHandle })

                var displayName = accountService.displayName;
                var accountId = accountService.accountId;
                var iconName = accountService.provider.iconName;
                var serviceName = accountService.service.displayName;
                var features = friends.featuresForProtocol(serviceName.toLowerCase().replace(".",""));
                if (features.indexOf("send") > -1) {
                    console.log (serviceName + " Supports send");
                    /* FIXME: we should get the iconName and serviceName from the accountService
                       but I am not sure we can access that from JS */
                    accountsModel.append({
                                             "displayName": displayName,
                                             "id": accountId,
                                             "provider": serviceName,
                                             "accountIcon": iconName,
                                             "sendEnabled": true
                                         });
                }
            }
        }
    }

    ListModel {
        id: accountsModel
    }

    Item {
        id: accountsArea
        width: parent.width
        anchors {
            top: entry.bottom
            topMargin: units.gu(5)
        }

        Column {
            id: accountsView
            width: parent.width
            spacing: units.gu(1)
            Repeater {
                width: parent.width
                model: accountsModel
                delegate: accountDelegate
            }
        }

        Component {
            id: accountDelegate

            ListItem.Standard {
                text: displayName
                opacity: sw.checked ? 1.0 : 0.3
                iconName: accountIcon

                width: parent.width
                height: childrenRect.height

                Component.onCompleted: {
                    //this fixes height if no icon can be found
                    if(icon) {
                        height = icon.height
                    }
                }

                control: CheckBox {
                    id: sw
                    checked: sendEnabled
                    onCheckedChanged: {
                        accountsModel.setProperty(index, "sendEnabled", sw.checked);
                    }
                }

                showDivider: false
            }
        }
    }

    Component {
        id: errorPopover
        Popover {
            Column {
                anchors {
                    left: parent.left
                    top: parent.top
                    right: parent.right
                }
                ListItem.Standard {
                    text: i18n.tr("An error occured")
                }
            }
            onVisibleChanged: {
                if (visible == false) {
                    failed = false;
                }
            }
        }
    }
}
