/*
 * Decompiled with CFR 0.152.
 */
package gfront;

import gfront.ChangeLookAndFeel;
import gfront.DirectoryTreeNode;
import gfront.FileTableModel;
import gfront.FragmentEditor;
import gfront.GFAppConst;
import gfront.GFLSParser;
import gfront.GFrontCommon;
import gfront.GFrontConst;
import gfront.GfhostList;
import gfront.RightClickDirTree;
import gfront.RightClickTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.JTableHeader;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class GFront
extends JFrame
implements GFAppConst,
GFrontConst,
ListSelectionListener,
TreeSelectionListener,
TreeWillExpandListener {
    DirectoryTreeNode root_dir;
    DefaultTreeModel dirs;
    FileTableModel files;
    FragmentEditor property;
    JTree tre_dirs;
    JTable tbl_files;
    JMenuBar menubar;
    JMenu[] menus;
    JMenuItem[] menuItems;
    ChangeLookAndFeel clf;
    TreePath selected_path;
    DirectoryTreeNode selected_dir;
    String ldap_hostname;
    String ldap_base;
    int ldap_port;
    JScrollPane jsp_files;
    HashMap dir_node_map;
    private JProgressBar progressBar;
    private int save_row = -1;
    public String savedSelectedDirname;
    public String savedSelectedFilename;

    public GFront() {
        this.setSize(600, 600);
        this.selected_path = null;
        this.selected_dir = null;
        this._node_is_not_selected_now();
        this.setDefaultCloseOperation(3);
        this.ldap_hostname = "GFront";
        this.ldap_base = "";
        this.ldap_port = 9000;
        this.root_dir = new DirectoryTreeNode();
        this.root_dir.setUserObject("/");
        this.dirs = new DefaultTreeModel(this.root_dir);
        this.files = new FileTableModel();
        this.clf = new ChangeLookAndFeel(this);
        this.tre_dirs = new JTree(this.dirs);
        this.tre_dirs.addTreeWillExpandListener(this);
        this.tre_dirs.addTreeSelectionListener(this);
        RightClickDirTree rightClickDirTree = new RightClickDirTree(this.tre_dirs, this);
        this.tre_dirs.addMouseListener(rightClickDirTree);
        this.clf.addComponent(rightClickDirTree.jpop);
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        this.tre_dirs.setSelectionModel(defaultTreeSelectionModel);
        this.tbl_files = new JTable(this.files);
        this.tbl_files.setShowGrid(false);
        this.tbl_files.setShowHorizontalLines(false);
        this.tbl_files.setShowVerticalLines(true);
        this.tbl_files.setSelectionMode(0);
        this.tbl_files.getSelectionModel().addListSelectionListener(this);
        RightClickTable rightClickTable = new RightClickTable(this.tbl_files, this);
        this.tbl_files.addMouseListener(rightClickTable);
        this.clf.addComponent(rightClickTable.jpop);
        this.property = new FragmentEditor();
        this.property.setEnabled(false);
        this.progressBar = new JProgressBar(0, 1000);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        Dimension dimension = new Dimension();
        dimension.setSize(5, 30);
        this.progressBar.setMinimumSize(dimension);
        this.progressBar.setMaximumSize(dimension);
        this.jsp_files = new JScrollPane(this.tbl_files);
        this.jsp_files.getViewport().setBackground(this.tbl_files.getBackground());
        JTableHeader jTableHeader = this.tbl_files.getTableHeader();
        this.jsp_files.setColumnHeaderView(jTableHeader);
        JSplitPane jSplitPane = new JSplitPane(0, this.jsp_files, this.property);
        jSplitPane.setDividerLocation(this.getHeight() / 2);
        jSplitPane.setDividerSize(5);
        JSplitPane jSplitPane2 = new JSplitPane(0, new JScrollPane(this.tre_dirs), this.progressBar);
        JSplitPane jSplitPane3 = new JSplitPane(1, true, new JScrollPane(this.tre_dirs), jSplitPane);
        jSplitPane3.setDividerLocation(this.getWidth() / 4);
        jSplitPane3.setDividerSize(5);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jSplitPane3, "Center");
        this.init_all_menus();
        this.setJMenuBar(this.menubar);
        this.setTitle(this.ldap_hostname);
    }

    public boolean initial_setup() {
        this.root_dir.removeAllChildren();
        boolean bl = this._update_node(this.root_dir, (String)this.root_dir.getUserObject());
        if (!bl) {
            return false;
        }
        if (this.selected_path == null) {
            String string;
            int n = this.root_dir.getChildCount();
            GFrontCommon gFrontCommon = new GFrontCommon();
            String string2 = gFrontCommon.runNomalCommandToString(this, "gfsetdir", "gfsetdir");
            try {
                string = string2.substring(string2.indexOf("gfarm:/") + 7, string2.indexOf(";"));
            }
            catch (Exception exception) {
                string = System.getProperty("user.name");
            }
            System.out.println("gfpwd: gfarm:/" + string);
            for (int i = 0; i < n; ++i) {
                String string3 = (String)((DirectoryTreeNode)this.root_dir.getChildAt(i)).getUserObject();
                if (!string.equals(string3)) continue;
                this.tre_dirs.setSelectionRow(i + 1);
                break;
            }
        }
        return true;
    }

    protected boolean _update_node(DirectoryTreeNode directoryTreeNode, String string) {
        GFLSParser gFLSParser = new GFLSParser(this);
        gFLSParser.setPATH(string);
        boolean bl = gFLSParser.parse();
        if (!bl) {
            return false;
        }
        int n = gFLSParser.getSize();
        for (int i = 0; i < n; ++i) {
            String string2 = gFLSParser.getAttr(i, "ATTRIB_ATTR");
            String string3 = gFLSParser.getAttr(i, "ATTRIB_NAME");
            if (string2.charAt(0) != 'd') continue;
            DirectoryTreeNode directoryTreeNode2 = new DirectoryTreeNode();
            directoryTreeNode2.setUserObject(string3);
            directoryTreeNode.add(directoryTreeNode2);
        }
        directoryTreeNode.setExplored(true);
        this.dirs.nodeStructureChanged(directoryTreeNode);
        return true;
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        DirectoryTreeNode directoryTreeNode = (DirectoryTreeNode)treePath.getLastPathComponent();
        if (directoryTreeNode.isExplored()) {
            return;
        }
        this._update_node(directoryTreeNode, this._get_fullpath_dirname(treePath.getPath()));
    }

    public synchronized void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath;
        this.progressBar.setIndeterminate(true);
        this.selected_path = treePath = treeSelectionEvent.getPath();
        Object[] objectArray = treePath.getPath();
        DirectoryTreeNode directoryTreeNode = (DirectoryTreeNode)objectArray[objectArray.length - 1];
        Object[] objectArray2 = directoryTreeNode.getPath();
        String string = this._get_fullpath_dirname(objectArray2);
        if (string == null) {
            return;
        }
        this.selected_dir = directoryTreeNode;
        if (!string.equals(this.savedSelectedDirname)) {
            this.savedSelectedFilename = null;
            this.savedSelectedDirname = string;
            this.property.setNullFragmentTable();
        }
        this._update_table(string);
        System.out.println("Tree Selected");
    }

    protected String _get_fullpath_dirname(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("gfarm:/");
        DirectoryTreeNode directoryTreeNode = (DirectoryTreeNode)objectArray[0];
        String string = (String)directoryTreeNode.getUserObject();
        if (!string.equals("/")) {
            stringBuffer.append(string);
            stringBuffer.append("/");
        }
        for (int i = 1; i < objectArray.length; ++i) {
            directoryTreeNode = (DirectoryTreeNode)objectArray[i];
            string = (String)directoryTreeNode.getUserObject();
            stringBuffer.append(string);
            if (string.equals("/")) continue;
            stringBuffer.append("/");
        }
        return stringBuffer.toString();
    }

    protected boolean _update_table(String string) {
        GFLSParser gFLSParser = new GFLSParser(this);
        gFLSParser.setPATH(string);
        this.setTitle("GFront - " + string);
        FileTableModel fileTableModel = this._create_new_table_model();
        if (!gFLSParser.parse()) {
            Object[] objectArray = new Object[]{"*** gfls parsing error ***", "", ""};
            fileTableModel.addRow(objectArray);
        } else {
            String string2;
            String string3;
            int n;
            int n2 = gFLSParser.getSize();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm:ss yyyy", Locale.US);
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            for (n = 0; n < n2; ++n) {
                string3 = gFLSParser.getAttr(n, "ATTRIB_ATTR");
                string2 = gFLSParser.getAttr(n, "ATTRIB_NAME");
            }
            for (n = 0; n < n2; ++n) {
                Object[] objectArray;
                string3 = gFLSParser.getAttr(n, "ATTRIB_ATTR");
                string2 = gFLSParser.getAttr(n, "ATTRIB_NAME");
                int n3 = -1;
                if (string3.charAt(0) == 'd') continue;
                String string4 = gFLSParser.getAttr(n, "ATTRIB_DATE");
                try {
                    objectArray = simpleDateFormat.parse(string4);
                    string4 = dateFormat.format((Date)objectArray);
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
                objectArray = new Object[4];
                objectArray[0] = string2;
                objectArray[1] = gFLSParser.getAttr(n, "ATTRIB_SIZE");
                objectArray[2] = string4;
                fileTableModel.addRow(objectArray);
            }
        }
        this.files = fileTableModel;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GFront.this.tbl_files.setModel(GFront.this.files);
            }
        });
        this.jsp_files.getViewport().setBackground(this.tbl_files.getBackground());
        return true;
    }

    public synchronized void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.tbl_files.getSelectedRow();
        if (this.save_row == n) {
            return;
        }
        this.save_row = n;
        if (n < 0) {
            return;
        }
        DirectoryTreeNode directoryTreeNode = this.selected_dir;
        String string = this._get_fullpath_dirname(directoryTreeNode.getPath());
        String string2 = (String)this.tbl_files.getValueAt(n, 0);
        this.savedSelectedFilename = string + string2;
        this.property.update(this.savedSelectedFilename);
        this.setTitle("GFront - " + this.savedSelectedFilename);
        System.out.println("Table Selected " + listSelectionEvent.getFirstIndex() + " " + listSelectionEvent.getLastIndex() + ": " + this.savedSelectedFilename);
    }

    protected FileTableModel _create_new_table_model() {
        FileTableModel fileTableModel = new FileTableModel();
        fileTableModel.setColumnIdentifiers(new String[]{"Filename", "Size", "Date"});
        return fileTableModel;
    }

    private synchronized void _node_is_not_selected_now() {
    }

    private synchronized void _node_is_selected_now() {
    }

    protected void init_all_menus() {
        this._init_menubar_menus();
        this._init_popup_menus();
    }

    protected void _init_popup_menus() {
    }

    protected void _init_menubar_menus() {
        this.menubar = new JMenuBar();
        this.menus = new JMenu[3];
        this.menus[0] = new JMenu("File");
        this.menus[1] = new JMenu("Edit");
        this.menus[2] = new JMenu("L&F");
        int n = 0;
        JMenuItem jMenuItem = new JMenuItem("gfhost");
        GfhostList gfhostList = new GfhostList(this);
        jMenuItem.addActionListener(gfhostList);
        this.menus[n].add(jMenuItem);
        this.menus[n].addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Exit");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.menus[n].add(jMenuItem2);
        n = 1;
        JMenuItem jMenuItem3 = new JMenuItem("Refresh");
        jMenuItem3.addActionListener(new AllRefresh());
        this.menus[n].add(jMenuItem3);
        n = 2;
        this.clf.addMenuItem(this.menus[n]);
        this._node_is_not_selected_now();
        for (int i = 0; i < this.menus.length; ++i) {
            this.menubar.add(this.menus[i]);
        }
    }

    public class AllRefresh
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            GFront.this.initial_setup();
            GFront.this._update_table(GFront.this.savedSelectedDirname);
            GFront.this.property.update(GFront.this.savedSelectedFilename);
            if (GFront.this.savedSelectedFilename != null) {
                GFront.this.setTitle("GFront - " + GFront.this.savedSelectedFilename);
            }
        }
    }
}

