-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_logging.adb,v $
--  Description     : GUI for the data base client
--  Author          : Michael Erdmann
--  Created         : 8.8.2001
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/09/25 19:57:39 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------

with Ada.Strings.Unbounded;    use Ada.Strings.Unbounded;
with Ada.Text_Io;              use Ada.Text_IO;
with Ada.Exceptions;           use Ada.Exceptions;
with Ada.Strings;              use Ada.Strings;
with Ada.Strings.Fixed;        use Ada.Strings.Fixed;

with Glib;                     use Glib;
-- Gdk
with Gdk;
with Gdk.Drawable;             use Gdk.Drawable;
with Gdk.Bitmap;               use Gdk.Bitmap;
with Gdk.Event;                use Gdk.Event;
with Gdk.Font;                 use Gdk.Font;
with Gdk.Color;                use Gdk.Color;
with Gdk.GC;                   use Gdk.GC;
with Gdk.Pixmap;               use Gdk.Pixmap;
with Gdk.Rectangle;            use Gdk.Rectangle;
with Gdk.Types;                use Gdk.Types;
with Gdk.Window;               use Gdk.Window;
-- Gtk
with Gtk.Rc;
with Gtk;                      use Gtk;
with Gtk.Arguments;            use Gtk.Arguments;
with Gtk.Box;                  use Gtk.Box;
with Gtk.Button;               use Gtk.Button;
with Gtk.Enums;                use Gtk.Enums;
with Gtk.Frame;                use Gtk.Frame;
with Gtk.Handlers;             use Gtk.Handlers;
with Gtk.Label;                use Gtk.Label;

with Gtk.Pixmap;               use Gtk.Pixmap;
with Gtkada.Handlers;          use Gtkada.Handlers;
with Gtk.Status_Bar;           use Gtk.Status_Bar;
with Gtk.Style;                use Gtk.Style;
with Gtk.Text;                 use Gtk.Text;
with Gtk.Window;               use Gtk.Window;
with Gtk.Widget;               use Gtk.Widget;

package body GUI_Logging is

   Version : constant String := "$Id: gui_logging.adb,v 1.3 2001/09/25 19:57:39 me Exp $";

   -----------------
   -- GTK Objects --
   -----------------

   Logging        : Gtk_Text;
   Logging_Font   : Gdk_Font;
   Status         : Gtk_Status_Bar;
   DB_Status      : Gtk_Status_Bar;

   Error_Color    : Gdk_Color;
   Warning_Color  : Gdk_Color;

   ----------------
   -- Initialize --
   ----------------
   procedure Initialize is
   begin
      null;
   end Initialize;

   --------------
   -- Finalize --
   --------------
   procedure Finalize is
   begin
      null;
   end Finalize;

   ---------
   -- Log --
   ---------
   procedure Log(
      Text : in String ) is
   begin
      Insert ( Logging,
         Logging_Font,
         Warning_Color,
         Null_Color,
         Text  & Ascii.LF, -1);
   end Log;

   -----------
   -- Error --
   -----------
   procedure Error(
      Text : in String ) is
   begin
      Insert ( Logging,
         Logging_Font,
         Error_Color,
         Null_Color,
         Text  & Ascii.LF, -1);
   end Error;

   -----------------
   -- Add_logging --
   -----------------
   procedure Add_Logging(
      Vbox : in out Gtk_Box )  is
   begin
      Load (Logging_Font, "-adobe-courier-medium-r-normal--*-120-*-*-*-*-*-*");
      Gtk_New(Logging);
      Pack_Start(Vbox, Logging, Expand=>False, Fill=>False);
   end Add_Logging;

   ----------------
   -- Add_Status --
   ----------------
   procedure Add_Status(
      Wbox     : in out Gtk_Box ) is
      St_Frame : Gtk_Frame;
      Hbox     : Gtk_Box;
   begin
      Set_Rgb (Error_Color,   16#FFFF#, 16#0#, 16#0#);
      Set_Rgb (Warning_Color, 16#0#   , 16#0#, 16#FFFF#);

      Gtk_New ( Status );
      Gtk_New ( DB_Status );
      Gtk_New ( St_Frame );

      Gtk_New_Hbox( Hbox );
      Add( St_Frame, Hbox );

      Pack_Start( Hbox, Child => Status, Expand => True  );
      Pack_End( Hbox, Child => DB_Status, Expand => True );
      Show_All( Hbox );

      Pack_End (Wbox , Child => St_Frame, Expand => False);
      Show_All( St_Frame );
   end Add_Status;

   ----------------
   -- Set_Status --
   ----------------
   procedure Set_Status(
      S  : in String ) is
      Id : Message_Id;
   begin
      Id := Push (Status, 1, S);
   end Set_Status;

   ------------------
   -- Clear_Status --
   ------------------
   procedure Clear_Status is
   begin
      Pop( Status, 1 );
   end Clear_Status;

   ---------------------
   -- Active_Database --
   ---------------------
   procedure Active_Database(
      Name : in String ) is
      Id   : Message_Id;
   begin
      Pop( DB_Status, 1);
      Id := Push (DB_Status, 1, Name);
   end Active_Database;

end GUI_Logging;

