package automanage

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ReportsClient is the automanage Client
type ReportsClient struct {
	BaseClient
}

// NewReportsClient creates an instance of the ReportsClient client.
func NewReportsClient(subscriptionID string) ReportsClient {
	return NewReportsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewReportsClientWithBaseURI creates an instance of the ReportsClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewReportsClientWithBaseURI(baseURI string, subscriptionID string) ReportsClient {
	return ReportsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get get information about a report associated with a configuration profile assignment run
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// configurationProfileAssignmentName - the configuration profile assignment name.
// reportName - the report name.
// VMName - the name of the virtual machine.
func (client ReportsClient) Get(ctx context.Context, resourceGroupName string, configurationProfileAssignmentName string, reportName string, VMName string) (result Report, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("automanage.ReportsClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, configurationProfileAssignmentName, reportName, VMName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "automanage.ReportsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "automanage.ReportsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "automanage.ReportsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client ReportsClient) GetPreparer(ctx context.Context, resourceGroupName string, configurationProfileAssignmentName string, reportName string, VMName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"configurationProfileAssignmentName": autorest.Encode("path", configurationProfileAssignmentName),
		"reportName":                         autorest.Encode("path", reportName),
		"resourceGroupName":                  autorest.Encode("path", resourceGroupName),
		"subscriptionId":                     autorest.Encode("path", client.SubscriptionID),
		"vmName":                             autorest.Encode("path", VMName),
	}

	const APIVersion = "2021-04-30-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}/reports/{reportName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ReportsClient) GetResponder(resp *http.Response) (result Report, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByConfigurationProfileAssignments retrieve a list of reports within a given configuration profile assignment
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// configurationProfileAssignmentName - the configuration profile assignment name.
// VMName - the name of the virtual machine.
func (client ReportsClient) ListByConfigurationProfileAssignments(ctx context.Context, resourceGroupName string, configurationProfileAssignmentName string, VMName string) (result ReportList, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.ListByConfigurationProfileAssignments")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("automanage.ReportsClient", "ListByConfigurationProfileAssignments", err.Error())
	}

	req, err := client.ListByConfigurationProfileAssignmentsPreparer(ctx, resourceGroupName, configurationProfileAssignmentName, VMName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "automanage.ReportsClient", "ListByConfigurationProfileAssignments", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByConfigurationProfileAssignmentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "automanage.ReportsClient", "ListByConfigurationProfileAssignments", resp, "Failure sending request")
		return
	}

	result, err = client.ListByConfigurationProfileAssignmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "automanage.ReportsClient", "ListByConfigurationProfileAssignments", resp, "Failure responding to request")
		return
	}

	return
}

// ListByConfigurationProfileAssignmentsPreparer prepares the ListByConfigurationProfileAssignments request.
func (client ReportsClient) ListByConfigurationProfileAssignmentsPreparer(ctx context.Context, resourceGroupName string, configurationProfileAssignmentName string, VMName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"configurationProfileAssignmentName": autorest.Encode("path", configurationProfileAssignmentName),
		"resourceGroupName":                  autorest.Encode("path", resourceGroupName),
		"subscriptionId":                     autorest.Encode("path", client.SubscriptionID),
		"vmName":                             autorest.Encode("path", VMName),
	}

	const APIVersion = "2021-04-30-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}/reports", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByConfigurationProfileAssignmentsSender sends the ListByConfigurationProfileAssignments request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) ListByConfigurationProfileAssignmentsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByConfigurationProfileAssignmentsResponder handles the response to the ListByConfigurationProfileAssignments request. The method always
// closes the http.Response Body.
func (client ReportsClient) ListByConfigurationProfileAssignmentsResponder(resp *http.Response) (result ReportList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
