# $Id: gwyddion.spec.in 20681 2017-12-18 18:37:24Z yeti-dn $
Name:          gwyddion
Version:       2.50
Release:       1%{?dist}
Summary:       An SPM data visualization and analysis tool

Group:         Applications/Engineering
License:       GPLv2+
URL:           http://gwyddion.net/
Source0:       http://gwyddion.net/download/%{version}/%{name}-%{version}.tar.xz
BuildRoot:     %{_tmppath}/%{name}-%{version}-%{release}-root-%(id -un)
Requires(pre):    /sbin/ldconfig
Requires(postun): /sbin/ldconfig

BuildRequires: gcc-c++
BuildRequires: pkgconfig(gtk+-2.0) >= 2.14
BuildRequires: pkgconfig(glib-2.0) >= 2.14
BuildRequires: pkgconfig(pango) >= 1.12
BuildRequires: pkgconfig(cairo) >= 1.6
BuildRequires: pkgconfig(fftw3) >= 3.1
BuildRequires: pkgconfig(gtkglext-1.0)
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: zlib-devel
BuildRequires: pkgconfig(libwebp)
BuildRequires: pkgconfig(OpenEXR)
BuildRequires: pkgconfig(cfitsio)
BuildRequires: pkgconfig(libpng)
BuildRequires: pkgconfig(unique-1.0)
BuildRequires: ruby(release) >= 1.8
BuildRequires: gettext
BuildRequires: desktop-file-utils >= 0.9
BuildRequires: findutils
BuildRequires: pkgconfig(xmu)
BuildRequires: pkgconfig(gtksourceview-2.0)
BuildRequires: pkgconfig(minizip)
BuildRequires: sed

%if 0%{?suse_version}
BuildRequires: pkg-config
%else
BuildRequires: pkgconfig
%endif

BuildRequires: perl >= 5.005
%if 0%{?fedora}
BuildRequires: perl-podlators
BuildRequires: rubypick
%endif
%if 0%{?rhel}
BuildRequires: perl-podlators
BuildRequires: rubypick
%endif

# Obsolete?  Keep for now...
%if 0%{?suse_version}
%define gconf2 gconf2
%else
%define gconf2 GConf2
%endif
BuildRequires: %{gconf2}

%if 0%{?fedora} >= 26
%define python2 python2
%else
%define python2 python
%endif
BuildRequires: %{python2}
BuildRequires: %{python2}-devel >= 2.7

%if 0%{?fedora}
BuildRequires: pygtk2-devel >= 2.10
%endif
%if 0%{?rhel}
BuildRequires: pygtk2-devel >= 2.10
%endif
%if 0%{?suse_version}
BuildRequires: python-gtk-devel >= 2.10
%endif
# otherwise...?

%define configureopts %{nil}

# The only packaged perl module is private, don't expose it.
%define __perl_provides %{nil}

%define pkglibdir %{_libdir}/%{name}
%define pkglibexecdir %{_libexecdir}/%{name}
%define pkgdatadir %{_datadir}/%{name}
%define pkgincludedir %{_includedir}/%{name}
%define gtkdocdir %{_datadir}/gtk-doc/html
%define gconfdir %{_sysconfdir}/gconf/schemas

# gconftool-2 is executed in a silly manner, make macros for that.
%define gconftool GCONF_CONFIG_SOURCE=$(gconftool-2 --get-default-source) gconftool-2
%define schemas %{gconfdir}/gwyddion-thumbnailer.schemas


%package devel
Summary:       Headers, libraries and tools for Gwyddion module development
Group:         Development/Libraries
Requires:      %{name}%{?_isa} = %{version}
# This pulls everything else
Requires:      gtk2-devel%{?_isa} >= 2.8
Requires:      gtkglext-devel%{?_isa}
Requires:      perl(:MODULE_COMPAT_%(eval "`%{__perl} -V:version`"; echo $version))
Requires:      python-abi = 2.7


%package thumbnailer-gconf
Summary:         GConf schemas for gwyddion-thumbnailer integration
Group:           System Environment/Libraries
Requires:        %{name} = %{version}
Requires(pre):   %{gconf2}
Requires(post):  %{gconf2}
Requires(preun): %{gconf2}


%description
Gwyddion is a modular SPM (Scanning Probe Microsopy) data visualization and
analysis tool written with Gtk+.

It can be used for all most frequently used data processing operations
including: leveling, false color plotting, shading, filtering, denoising, data
editing, integral transforms, grain analysis, profile extraction, fractal
analysis, and many more.  The program is primarily focused on SPM data analysis
(e.g. data obtained from AFM, STM, NSOM, and similar microscopes).  However, it
can also be used for analysis of SEM (Scanning Electron Microscopy) data or any
other 2D data.


%description devel
Header files, libraries and tools for Gwyddion module and plug-in development.
This package also contains the API docmentation and sample plug-ins in various
programming languages.


%description thumbnailer-gconf
GConf schemas that register gwyddion-thumbnailer as thumbnailer for SPM files
in GNOME and XFce.


%prep
%setup -q
# Don't install .la files.
sed -i -e '/# Install the pseudo-library/,/^$/d' ltmain.sh
# Replace universal /usr/bin/env shbang with the real thing.
sed -i -e '1s/env *//' plugins/process/*.{py,rb,pl}


%build
%configure %configureopts --without-pascal --disable-rpath \
           --without-kde4-thumbnailer
make %{?_smp_mflags}


%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
# Install the icon to the hicolor theme *and* to /usr/share/pixmaps because
# some distros expect it in one place, some in another.
mkdir -p $RPM_BUILD_ROOT%{_datadir}/pixmaps
install pixmaps/%{name}.png $RPM_BUILD_ROOT%{_datadir}/pixmaps
%find_lang %{name}

# Get rid of .la files if some silly distros (hello Mandriva) overwrote our
# fixed libtool with some crap.
find $RPM_BUILD_ROOT -name \*.la -print0 | xargs -0 rm -f

# I cannot express this as %%files in a sensible manner, especially not when
# python byte-compilation kicks in.  Set permissions in the filesystem.
find $RPM_BUILD_ROOT%{pkglibexecdir} -type f -print0 | xargs -0 chmod 755
find $RPM_BUILD_ROOT%{pkglibexecdir} -type f -name \*.rgi -print0 | xargs -0 chmod 644

# Perl, Python, and Ruby modules are private, remove the Perl man page.
rm -f $RPM_BUILD_ROOT%{_mandir}/man3/Gwyddion::dump.*


%clean
rm -rf $RPM_BUILD_ROOT


%post
/sbin/ldconfig
update-mime-database %{_datadir}/mime &>/dev/null || :
update-desktop-database &>/dev/null || :


%postun
/sbin/ldconfig
update-mime-database %{_datadir}/mime &>/dev/null || :
update-desktop-database &>/dev/null || :


%pre thumbnailer-gconf
if [ "$1" -gt 1 ]; then
    %{gconftool} --makefile-uninstall-rule %{schemas} >/dev/null || :
fi


%post thumbnailer-gconf
%{gconftool} --makefile-install-rule %{schemas} >/dev/null || :


%preun thumbnailer-gconf
if [ "$1" -eq 0 ]; then
    %{gconftool} --makefile-uninstall-rule %{schemas} >/dev/null || :
fi


%files -f %{name}.lang
%defattr(755,root,root)
%{_bindir}/%{name}
%{_bindir}/%{name}-thumbnailer
%defattr(-,root,root)
%doc AUTHORS COPYING NEWS README THANKS
%{pkgdatadir}/pixmaps/*.png
%{pkgdatadir}/pixmaps/*.ico
%{pkgdatadir}/gradients/*
%{pkgdatadir}/glmaterials/*
%{pkgdatadir}/pygwy/*
%{pkgdatadir}/ui/*
%{pkgdatadir}/user-guide-modules
%dir %{pkgdatadir}/pixmaps
%dir %{pkgdatadir}/gradients
%dir %{pkgdatadir}/glmaterials
%dir %{pkgdatadir}/pygwy
%dir %{pkgdatadir}/ui
%dir %{pkgdatadir}
%{_mandir}/man1/%{name}.1*
%{_mandir}/man1/%{name}-thumbnailer.1*
%{_datadir}/icons/hicolor/48x48/apps/%{name}.png
%{_datadir}/pixmaps/%{name}.png
%{pkglibdir}/modules/file/*.so
%{pkglibdir}/modules/graph/*.so
%{pkglibdir}/modules/layer/*.so
%{pkglibdir}/modules/process/*.so
%{pkglibdir}/modules/tool/*.so
%{pkglibdir}/modules/volume/*.so
%{pkglibdir}/modules/xyz/*.so
%{pkglibdir}/modules/*.so
%dir %{pkglibdir}/modules/file
%dir %{pkglibdir}/modules/graph
%dir %{pkglibdir}/modules/layer
%dir %{pkglibdir}/modules/process
%dir %{pkglibdir}/modules/tool
%dir %{pkglibdir}/modules/volume
%dir %{pkglibdir}/modules/xyz
%dir %{pkglibdir}/modules
%dir %{pkglibdir}
%{_libdir}/*.so.*
%{_datadir}/applications/%{name}.desktop
%{_datadir}/mime/packages/%{name}.xml
%{_datadir}/thumbnailers/%{name}.thumbnailer
%{_datadir}/gtksourceview-2.0/language-specs/pygwy.lang

%files devel
%defattr(-,root,root)
%doc devel-docs/CODING-STANDARDS
%doc data/%{name}.vim
%{pkgincludedir}/app/*.h
%{pkgincludedir}/libdraw/*.h
%{pkgincludedir}/libprocess/*.h
%{pkgincludedir}/libgwyddion/*.h
%{pkgincludedir}/libgwydgets/*.h
%{pkgincludedir}/libgwymodule/*.h
%dir %{pkgincludedir}/app
%dir %{pkgincludedir}/libdraw
%dir %{pkgincludedir}/libprocess
%dir %{pkgincludedir}/libgwyddion
%dir %{pkgincludedir}/libgwydgets
%dir %{pkgincludedir}/libgwymodule
%dir %{pkgincludedir}
%{_libdir}/*.so
%{python_sitearch}/gwy.so
%{_libdir}/pkgconfig/gwyddion.pc
%dir %{_libdir}/pkgconfig
# Documentation
%doc %{gtkdocdir}/libgwyapp/*
%doc %{gtkdocdir}/libgwydraw/*
%doc %{gtkdocdir}/libgwyprocess/*
%doc %{gtkdocdir}/libgwyddion/*
%doc %{gtkdocdir}/libgwydgets/*
%doc %{gtkdocdir}/libgwymodule/*
%doc %dir %{gtkdocdir}/libgwyapp
%doc %dir %{gtkdocdir}/libgwydraw
%doc %dir %{gtkdocdir}/libgwyprocess
%doc %dir %{gtkdocdir}/libgwyddion
%doc %dir %{gtkdocdir}/libgwydgets
%doc %dir %{gtkdocdir}/libgwymodule
%doc %dir %{gtkdocdir}
%doc %dir %{_datadir}/gtk-doc
%{pkglibdir}/include/gwyconfig.h
%dir %{pkglibdir}/include
# Plug-ins and plug-in devel stuff
%{pkglibdir}/perl/Gwyddion/*
%dir %{pkglibdir}/perl/Gwyddion
%dir %{pkglibdir}/perl
%{pkglibdir}/python/Gwyddion/*
%dir %{pkglibdir}/python/Gwyddion
%dir %{pkglibdir}/python
%{pkglibdir}/ruby/gwyddion/*
%dir %{pkglibdir}/ruby/gwyddion
%dir %{pkglibdir}/ruby
# Use filesystem permissions here.
%defattr(-,root,root,755)
%{pkglibexecdir}/plugins/file/*
%{pkglibexecdir}/plugins/process/*
%dir %{pkglibexecdir}/plugins/file
%dir %{pkglibexecdir}/plugins/process
%dir %{pkglibexecdir}/plugins
%dir %{pkglibexecdir}

%files thumbnailer-gconf
%{gconfdir}/*.schemas

%changelog
* Tue Aug  8 2017 Yeti <yeti@gwyddion.net> - 2.50-1
- hello rpmlint, this package is partially generated
