# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
CENTOS_RELEASES += 10

.PHONY: all
all:: centos-cloud-10.$(GARDEN_ARCH).qcow2 centos-cloud-10.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/centos/CentOS-Stream-GenericCloud-10-latest.$(GARDEN_ARCH).qcow2

$(GARDEN_DL_DIR)/centos/CentOS-Stream-GenericCloud-10-latest.aarch64.qcow2 $(GARDEN_DL_DIR)/centos/CentOS-Stream-GenericCloud-10-latest.x86_64.qcow2: $(GARDEN_DL_DIR)/centos/CentOS-Stream-GenericCloud-10-latest.%.qcow2: | $(GARDEN_DL_DIR)/centos
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://cloud.centos.org/centos/10-stream/$*/images/CentOS-Stream-GenericCloud-10-latest.$*.qcow2)

$(GARDEN_DL_DIR)/centos/centos-cloud-10.x86_64.qcow2: | $(GARDEN_DL_DIR)/centos/ $(GARDEN_DL_DIR)/centos/CentOS-Stream-GenericCloud-10-latest.x86_64.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/centos/centos-cloud-10.aarch64.qcow2: | $(GARDEN_DL_DIR)/centos/ $(GARDEN_DL_DIR)/centos/CentOS-Stream-GenericCloud-10-latest.aarch64.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/centos/centos-cloud-10.*.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/centos/CentOS-Stream-GenericCloud-10-latest.*.qcow2
