#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2008-2009 Alessio Treglia
# Copyright (C) 2008 Andrea Gasparini <gaspa@yattaweb.it>
#
# This file is part of installation-report-generator.
#
# installation-report-generator is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# installation-report-generator is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with installation-report-generator.  If not, see <http://www.gnu.org/licenses/>.

import thread, threading, time

import irgenerator, irgenerator.util, irgenerator.globals
from irgenerator.util.sysinfo import SystemInfo
import template

class WikiPage(threading.Thread):
    def __init__(self, obj,template_type='it'):
        threading.Thread.__init__(self)
        self.obj = obj
        self.hwconfig = obj.model
        self.template = self.choice_template(template_type)
        self.page = '\n'.join(["## Generated by Installation Report Generator %s" % irgenerator.globals.get_version(), self.template ])

    def __get_the_page(self):
        peripherals = SystemInfo.get_lspci()
        cpuinfo = SystemInfo.get_cpuinfo()
        if self.hwconfig.release.strip() == '':
            self.hwconfig.release = SystemInfo.get_release()
        if self.hwconfig.cpu.strip() == '':
            self.hwconfig.cpu = SystemInfo.get_cpu()
        if self.hwconfig.memory.strip() == '':
            self.hwconfig.memory = SystemInfo.get_memory()
        codename = template.releases[self.hwconfig.release]
        self.page = self.page % {'vendor':self.hwconfig.vendor, 'model':self.hwconfig.model,
                                 'memory':self.hwconfig.memory, 'cpu':self.hwconfig.cpu,
                                 'release':self.hwconfig.release,'codename':codename, 'vga':self.hwconfig.vga,
                                 'peripherals':peripherals,'cpuinfo':cpuinfo, 'website':self.hwconfig.website}
        time.sleep(0.5)
    def run(self):
        self.obj.activity_check = 1
        self.__get_the_page()
        self.obj.activity_check = -1
        self.obj.report_is_ready()
        #self.obj.update_buttons(button_forward='show')
        #self.obj.view['progressbar_wait'].set_text(_("Press «Forward»"))
        thread.exit()

    def choice_template(self,type):
        if 'it' in type :
            return template.notebook_it
        else:
            return template.notebook_en
