#!/bin/sh
#
# Jakarta Bean Validation API
#
# License: Apache License, Version 2.0
# See the license.txt file in the root directory or <http://www.apache.org/licenses/LICENSE-2.0>.
#
# gencopyright.sh
#
# Generates the copyright.txt file mentioned in the license header
# @author Kevin Pollet
# @author Emmanuel Bernard

SCRIPT_PATH=$(dirname $0)
ROOT_PATH="$SCRIPT_PATH/../../../"
COPYRIGHT_FILE_NAME="copyright.txt"
CONTRIBUTOR_OF_THIS_FILE="Kevin Pollet\nEmmanuel Bernard"
GENERAL_CONTRIBUTORS="Red Hat Inc."

# exclude this file as it matches with a weird name [^
# add back Kevin and Emmanuel to the list to match this file
JAVADOC_AUTHORS=$(grep '@author [^<]*' -ho -r --include="*.java" --include="*.sh" --include="*.xml" --exclude="gencopyright.sh" --include="*.xsd" $ROOT_PATH | sed 's/@author//;s/^[[:space:]]*//;s/[[:space:]]*$//;s/"\r"//')

GIT_AUTHORS=$(git log --pretty=format:"%an")

echo -e "# List of contributors\n\n$GENERAL_CONTRIBUTORS" > $ROOT_PATH$COPYRIGHT_FILE_NAME
echo -e "$JAVADOC_AUTHORS\n$GIT_AUTHORS\n$CONTRIBUTOR_OF_THIS_FILE" | sort -f | uniq -i >> $ROOT_PATH$COPYRIGHT_FILE_NAME
echo -e "\nGenerated by src/main/scripts/gencopyright.sh" >> $ROOT_PATH$COPYRIGHT_FILE_NAME
