/*
 * File    : ArithEditorPanel.java
 * Created : 10-jun-2002 09:59
 * By      : fbusquets
 *
 * JClic - Authoring and playing system for educational activities
 *
 * Copyright (C) 2000 - 2005 Francesc Busquets & Departament
 * d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 */

package edu.xtec.jclic.automation.arith;

import edu.xtec.jclic.automation.AutoContentProviderEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.util.Options;
import javax.swing.JComboBox;

/**
 *
 * @author Francesc Busquets (fbusquets@xtec.cat)
 * @version 13.08.29
 */
public class ArithEditorPanel extends EditorPanel {

    private String[] ORD_LIST;    
    private OperatorEditorPanel firstOpPanel;
    private OperatorEditorPanel secondOpPanel;
    
    /** Creates new form MenuEditorPanel */
    public ArithEditorPanel(Options options) {
        super(options);
        ORD_LIST=new String[3];
        ORD_LIST[0]=options.getMsg("edit_arith_result_random");
        ORD_LIST[1]=options.getMsg("edit_arith_result_asc");
        ORD_LIST[2]=options.getMsg("edit_arith_result_desc");
        initComponents();
        firstOpPanel=(OperatorEditorPanel)firstOpPanelX;
        secondOpPanel=(OperatorEditorPanel)secondOpPanelX;
        postInit(250, false, false);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        javax.swing.JLabel fromLb;
        java.awt.GridBagConstraints gridBagConstraints;
        javax.swing.JPanel leftPanel;
        javax.swing.JLabel orderLb;
        javax.swing.JSeparator sep;
        javax.swing.JLabel sepleft;
        javax.swing.JLabel toLb;

        condGrp = new javax.swing.ButtonGroup();
        leftPanel = new javax.swing.JPanel();
        operationsPanel = new javax.swing.JPanel();
        chkPlus = new javax.swing.JCheckBox();
        chkMinus = new javax.swing.JCheckBox();
        chkMultiply = new javax.swing.JCheckBox();
        chkDivide = new javax.swing.JCheckBox();
        unknownPanel = new javax.swing.JPanel();
        chk_aobx = new javax.swing.JCheckBox();
        chk_aoxr = new javax.swing.JCheckBox();
        chk_xobr = new javax.swing.JCheckBox();
        chk_axbr = new javax.swing.JCheckBox();
        sep = new javax.swing.JSeparator();
        chk_invert = new javax.swing.JCheckBox();
        sepleft = new javax.swing.JLabel();
        rightPanel = new javax.swing.JPanel();
        firstOpPanelX = new OperatorEditorPanel(options);
        secondOpPanelX = new OperatorEditorPanel(options);
        resultPanel = new javax.swing.JPanel();
        fromLb = new javax.swing.JLabel();
        fromCombo = new JComboBox(OperatorEditorPanel.LIST_OF_VALUES);
        toLb = new javax.swing.JLabel();
        toCombo = new JComboBox(OperatorEditorPanel.LIST_OF_VALUES);
        notCarryChk = new javax.swing.JCheckBox();
        orderLb = new javax.swing.JLabel();
        orderCombo = new JComboBox(ORD_LIST);
        avoidDupChk = new javax.swing.JCheckBox();
        condPanel = new javax.swing.JPanel();
        indOpt = new javax.swing.JRadioButton();
        agbOpt = new javax.swing.JRadioButton();
        albOpt = new javax.swing.JRadioButton();
        sepright1 = new javax.swing.JLabel();
        sepright = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        setToolTipText(options.getMsg("edit_act_descriptionTab_tooltip"));
        leftPanel.setLayout(new java.awt.GridBagLayout());

        operationsPanel.setLayout(new java.awt.GridBagLayout());

        operationsPanel.setBorder(new javax.swing.border.TitledBorder(options.getMsg("edit_arith_operations")));
        operationsPanel.setToolTipText(options.getMsg("edit_arith_operations_tooltip"));
        chkPlus.setText(options.getMsg("edit_arith_operations_plus"));
        chkPlus.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        operationsPanel.add(chkPlus, gridBagConstraints);

        chkMinus.setText(options.getMsg("edit_arith_operations_minus"));
        chkMinus.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        operationsPanel.add(chkMinus, gridBagConstraints);

        chkMultiply.setText(options.getMsg("edit_arith_operations_multiply"));
        chkMultiply.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        operationsPanel.add(chkMultiply, gridBagConstraints);

        chkDivide.setText(options.getMsg("edit_arith_operations_divide"));
        chkDivide.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        operationsPanel.add(chkDivide, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        leftPanel.add(operationsPanel, gridBagConstraints);

        unknownPanel.setLayout(new java.awt.GridBagLayout());

        unknownPanel.setBorder(new javax.swing.border.TitledBorder(options.getMsg("edit_arith_unknown")));
        unknownPanel.setToolTipText(options.getMsg("edit_arith_unknown_tooltip"));
        chk_aobx.setToolTipText(options.getMsg("edit_arith_unknown_aobx"));
        chk_aobx.setText("A @ B = ?");
        chk_aobx.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        unknownPanel.add(chk_aobx, gridBagConstraints);

        chk_aoxr.setToolTipText(options.getMsg("edit_arith_unknown_aoxr"));
        chk_aoxr.setText("A @ ? = C");
        chk_aoxr.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        unknownPanel.add(chk_aoxr, gridBagConstraints);

        chk_xobr.setToolTipText(options.getMsg("edit_arith_unknown_xobr"));
        chk_xobr.setText("? @ B = C");
        chk_xobr.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        unknownPanel.add(chk_xobr, gridBagConstraints);

        chk_axbr.setToolTipText(options.getMsg("edit_arith_unknown_axbr"));
        chk_axbr.setText("A ? B = C");
        chk_axbr.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        unknownPanel.add(chk_axbr, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        unknownPanel.add(sep, gridBagConstraints);

        chk_invert.setToolTipText(options.getMsg("edit_arith_unknown_invert"));
        chk_invert.setText("C = A @ B");
        chk_invert.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        unknownPanel.add(chk_invert, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        leftPanel.add(unknownPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 1.0;
        leftPanel.add(sepleft, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(leftPanel, gridBagConstraints);

        rightPanel.setLayout(new java.awt.GridBagLayout());

        firstOpPanelX.setBorder(new javax.swing.border.TitledBorder(options.getMsg("edit_arith_firstOp")));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        rightPanel.add(firstOpPanelX, gridBagConstraints);

        secondOpPanelX.setBorder(new javax.swing.border.TitledBorder(options.getMsg("edit_arith_secondOp")));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        rightPanel.add(secondOpPanelX, gridBagConstraints);

        resultPanel.setLayout(new java.awt.GridBagLayout());

        resultPanel.setBorder(new javax.swing.border.TitledBorder(options.getMsg("edit_arith_result")));
        fromLb.setLabelFor(fromCombo);
        fromLb.setText(options.getMsg("edit_arith_op_from"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        resultPanel.add(fromLb, gridBagConstraints);

        fromCombo.setToolTipText(options.getMsg("edit_arith_op_from_tooltip"));
        fromCombo.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        resultPanel.add(fromCombo, gridBagConstraints);

        toLb.setLabelFor(toCombo);
        toLb.setText(options.getMsg("edit_arith_op_to"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        resultPanel.add(toLb, gridBagConstraints);

        toCombo.setToolTipText(options.getMsg("edit_arith_op_to_tooltip"));
        toCombo.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        resultPanel.add(toCombo, gridBagConstraints);

        notCarryChk.setText(options.getMsg("edit_arith_result_notCarry"));
        notCarryChk.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        resultPanel.add(notCarryChk, gridBagConstraints);

        orderLb.setText(options.getMsg("edit_arith_result_order"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        resultPanel.add(orderLb, gridBagConstraints);

        orderCombo.setToolTipText(options.getMsg("edit_arith_op_to_tooltip"));
        orderCombo.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        resultPanel.add(orderCombo, gridBagConstraints);

        avoidDupChk.setText(options.getMsg("edit_arith_result_avoidDup"));
        avoidDupChk.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        resultPanel.add(avoidDupChk, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        rightPanel.add(resultPanel, gridBagConstraints);

        condPanel.setLayout(new java.awt.GridBagLayout());

        condPanel.setBorder(new javax.swing.border.TitledBorder(options.getMsg("edit_arith_cond")));
        condPanel.setToolTipText(options.getMsg("edit_arith_cond_tooltip"));
        indOpt.setText(options.getMsg("edit_arith_cond_ind"));
        condGrp.add(indOpt);
        indOpt.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        condPanel.add(indOpt, gridBagConstraints);

        agbOpt.setToolTipText(options.getMsg("edit_arith_cond_agb"));
        agbOpt.setText("A > B");
        condGrp.add(agbOpt);
        agbOpt.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        condPanel.add(agbOpt, gridBagConstraints);

        albOpt.setToolTipText(options.getMsg("edit_arith_cond_alb"));
        albOpt.setText("A < B");
        condGrp.add(albOpt);
        albOpt.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        condPanel.add(albOpt, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        rightPanel.add(condPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        rightPanel.add(sepright1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 1.0;
        rightPanel.add(sepright, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(rightPanel, gridBagConstraints);

    }//GEN-END:initComponents
    
    public boolean checkIfEditorValid(Editor e) {
        return e instanceof ArithEditor;
    }
    
    public ArithEditor getArithEditor(){
        return (ArithEditor)getEditor();
    }
    
    public Arith getArith(){
        ArithEditor aed=getArithEditor();
        return aed==null ? null : (Arith)aed.getAutoContentProvider();
    }
    
    public void fillData(){
        Arith a=getArith();
        chkPlus.setSelected(a==null ? true : a.use_add);
        chkMinus.setSelected(a==null ? false : a.use_subst);
        chkMultiply.setSelected(a==null ? false : a.use_mult);
        chkDivide.setSelected(a==null ? false : a.use_div);
        chk_aobx.setSelected(a==null ? true : a.exp_abx);
        chk_aoxr.setSelected(a==null ? false : a.exp_axc);
        chk_xobr.setSelected(a==null ? false : a.exp_xbc);
        chk_axbr.setSelected(a==null ? false : a.exp_axbc);
        chk_invert.setSelected(a==null ? false : a.exp_caxb);
        firstOpPanel.setOperator(a==null ? new Operator() : a.opA);
        secondOpPanel.setOperator(a==null ? new Operator() : a.opB);
        fromCombo.setSelectedIndex(a==null ? 1 : a.resultLimInf);
        toCombo.setSelectedIndex(a==null ? Operator.LIMITS.length-1 : a.resultLimSup);
        notCarryChk.setSelected(a==null ? false : a.resultCarry);
        avoidDupChk.setSelected(a==null ? false : a.resultNoDup);
        orderCombo.setSelectedIndex(a==null ? 0 : a.resultOrder);
        int cond=(a==null ? 0 : a.opCond);
        indOpt.setSelected(cond==0);
        agbOpt.setSelected(cond==1);
        albOpt.setSelected(cond==2);
        setModified(false);
    }
    
    public void saveData(){
        Arith a=getArith();
        if(a!=null){
            a.use_add=chkPlus.isSelected();
            a.use_subst=chkMinus.isSelected();
            a.use_mult=chkMultiply.isSelected();
            a.use_div=chkDivide.isSelected();
            a.exp_abx=chk_aobx.isSelected();
            a.exp_axc=chk_aoxr.isSelected();
            a.exp_xbc=chk_xobr.isSelected();
            a.exp_axbc=chk_axbr.isSelected();
            a.exp_caxb=chk_invert.isSelected();
            a.opA=firstOpPanel.getOperator();
            a.opB=secondOpPanel.getOperator();
            a.resultLimInf=fromCombo.getSelectedIndex();
            a.resultLimSup=toCombo.getSelectedIndex();
            a.resultCarry=notCarryChk.isSelected();
            a.resultNoDup=avoidDupChk.isSelected();
            a.resultOrder=orderCombo.getSelectedIndex();
            a.opCond=agbOpt.isSelected() ? 1 : albOpt.isSelected() ? 2 : 0;
        }
    }
    
    @Override
    protected javax.swing.Icon getIcon(){
        return AutoContentProviderEditor.getIcon();
    }
    
    @Override
    protected String getTitle(){
        return options.getMsg("edit_arith_title");
    }
    
        
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton agbOpt;
    private javax.swing.JRadioButton albOpt;
    private javax.swing.JCheckBox avoidDupChk;
    private javax.swing.JCheckBox chkDivide;
    private javax.swing.JCheckBox chkMinus;
    private javax.swing.JCheckBox chkMultiply;
    private javax.swing.JCheckBox chkPlus;
    private javax.swing.JCheckBox chk_aobx;
    private javax.swing.JCheckBox chk_aoxr;
    private javax.swing.JCheckBox chk_axbr;
    private javax.swing.JCheckBox chk_invert;
    private javax.swing.JCheckBox chk_xobr;
    private javax.swing.ButtonGroup condGrp;
    private javax.swing.JPanel condPanel;
    private javax.swing.JPanel firstOpPanelX;
    private javax.swing.JComboBox fromCombo;
    private javax.swing.JRadioButton indOpt;
    private javax.swing.JCheckBox notCarryChk;
    private javax.swing.JPanel operationsPanel;
    private javax.swing.JComboBox orderCombo;
    private javax.swing.JPanel resultPanel;
    private javax.swing.JPanel rightPanel;
    private javax.swing.JPanel secondOpPanelX;
    private javax.swing.JLabel sepright;
    private javax.swing.JLabel sepright1;
    private javax.swing.JComboBox toCombo;
    private javax.swing.JPanel unknownPanel;
    // End of variables declaration//GEN-END:variables
    
}
