/* Unicode facts */

#include "types.h"

/* Unicode blocks */

struct interval uniblocks[] = {
	{ 0x0, 0x7f } /* Basic Latin */,
	{ 0x80, 0xff } /* Latin-1 Supplement */,
	{ 0x100, 0x17f } /* Latin Extended-A */,
	{ 0x180, 0x24f } /* Latin Extended-B */,
	{ 0x250, 0x2af } /* IPA Extensions */,
	{ 0x2b0, 0x2ff } /* Spacing Modifier Letters */,
	{ 0x300, 0x36f } /* Combining Diacritical Marks */,
	{ 0x370, 0x3ff } /* Greek and Coptic */,
	{ 0x400, 0x4ff } /* Cyrillic */,
	{ 0x500, 0x52f } /* Cyrillic Supplement */,
	{ 0x530, 0x58f } /* Armenian */,
	{ 0x590, 0x5ff } /* Hebrew */,
	{ 0x600, 0x6ff } /* Arabic */,
	{ 0x700, 0x74f } /* Syriac */,
	{ 0x750, 0x77f } /* Arabic Supplement */,
	{ 0x780, 0x7bf } /* Thaana */,
	{ 0x7c0, 0x7ff } /* NKo */,
	{ 0x800, 0x83f } /* Samaritan */,
	{ 0x840, 0x85f } /* Mandaic */,
	{ 0x8a0, 0x8ff } /* Arabic Extended-A */,
	{ 0x900, 0x97f } /* Devanagari */,
	{ 0x980, 0x9ff } /* Bengali */,
	{ 0xa00, 0xa7f } /* Gurmukhi */,
	{ 0xa80, 0xaff } /* Gujarati */,
	{ 0xb00, 0xb7f } /* Oriya */,
	{ 0xb80, 0xbff } /* Tamil */,
	{ 0xc00, 0xc7f } /* Telugu */,
	{ 0xc80, 0xcff } /* Kannada */,
	{ 0xd00, 0xd7f } /* Malayalam */,
	{ 0xd80, 0xdff } /* Sinhala */,
	{ 0xe00, 0xe7f } /* Thai */,
	{ 0xe80, 0xeff } /* Lao */,
	{ 0xf00, 0xfff } /* Tibetan */,
	{ 0x1000, 0x109f } /* Myanmar */,
	{ 0x10a0, 0x10ff } /* Georgian */,
	{ 0x1100, 0x11ff } /* Hangul Jamo */,
	{ 0x1200, 0x137f } /* Ethiopic */,
	{ 0x1380, 0x139f } /* Ethiopic Supplement */,
	{ 0x13a0, 0x13ff } /* Cherokee */,
	{ 0x1400, 0x167f } /* Unified Canadian Aboriginal Syllabics */,
	{ 0x1680, 0x169f } /* Ogham */,
	{ 0x16a0, 0x16ff } /* Runic */,
	{ 0x1700, 0x171f } /* Tagalog */,
	{ 0x1720, 0x173f } /* Hanunoo */,
	{ 0x1740, 0x175f } /* Buhid */,
	{ 0x1760, 0x177f } /* Tagbanwa */,
	{ 0x1780, 0x17ff } /* Khmer */,
	{ 0x1800, 0x18af } /* Mongolian */,
	{ 0x18b0, 0x18ff } /* Unified Canadian Aboriginal Syllabics Extended */,
	{ 0x1900, 0x194f } /* Limbu */,
	{ 0x1950, 0x197f } /* Tai Le */,
	{ 0x1980, 0x19df } /* New Tai Lue */,
	{ 0x19e0, 0x19ff } /* Khmer Symbols */,
	{ 0x1a00, 0x1a1f } /* Buginese */,
	{ 0x1a20, 0x1aaf } /* Tai Tham */,
	{ 0x1ab0, 0x1aff } /* Combining Diacritical Marks Extended */,
	{ 0x1b00, 0x1b7f } /* Balinese */,
	{ 0x1b80, 0x1bbf } /* Sundanese */,
	{ 0x1bc0, 0x1bff } /* Batak */,
	{ 0x1c00, 0x1c4f } /* Lepcha */,
	{ 0x1c50, 0x1c7f } /* Ol Chiki */,
	{ 0x1c80, 0x1c8f } /* Cyrillic Extended-C */,
	{ 0x1cc0, 0x1ccf } /* Sundanese Supplement */,
	{ 0x1cd0, 0x1cff } /* Vedic Extensions */,
	{ 0x1d00, 0x1d7f } /* Phonetic Extensions */,
	{ 0x1d80, 0x1dbf } /* Phonetic Extensions Supplement */,
	{ 0x1dc0, 0x1dff } /* Combining Diacritical Marks Supplement */,
	{ 0x1e00, 0x1eff } /* Latin Extended Additional */,
	{ 0x1f00, 0x1fff } /* Greek Extended */,
	{ 0x2000, 0x206f } /* General Punctuation */,
	{ 0x2070, 0x209f } /* Superscripts and Subscripts */,
	{ 0x20a0, 0x20cf } /* Currency Symbols */,
	{ 0x20d0, 0x20ff } /* Combining Diacritical Marks for Symbols */,
	{ 0x2100, 0x214f } /* Letterlike Symbols */,
	{ 0x2150, 0x218f } /* Number Forms */,
	{ 0x2190, 0x21ff } /* Arrows */,
	{ 0x2200, 0x22ff } /* Mathematical Operators */,
	{ 0x2300, 0x23ff } /* Miscellaneous Technical */,
	{ 0x2400, 0x243f } /* Control Pictures */,
	{ 0x2440, 0x245f } /* Optical Character Recognition */,
	{ 0x2460, 0x24ff } /* Enclosed Alphanumerics */,
	{ 0x2500, 0x257f } /* Box Drawing */,
	{ 0x2580, 0x259f } /* Block Elements */,
	{ 0x25a0, 0x25ff } /* Geometric Shapes */,
	{ 0x2600, 0x26ff } /* Miscellaneous Symbols */,
	{ 0x2700, 0x27bf } /* Dingbats */,
	{ 0x27c0, 0x27ef } /* Miscellaneous Mathematical Symbols-A */,
	{ 0x27f0, 0x27ff } /* Supplemental Arrows-A */,
	{ 0x2800, 0x28ff } /* Braille Patterns */,
	{ 0x2900, 0x297f } /* Supplemental Arrows-B */,
	{ 0x2980, 0x29ff } /* Miscellaneous Mathematical Symbols-B */,
	{ 0x2a00, 0x2aff } /* Supplemental Mathematical Operators */,
	{ 0x2b00, 0x2bff } /* Miscellaneous Symbols and Arrows */,
	{ 0x2c00, 0x2c5f } /* Glagolitic */,
	{ 0x2c60, 0x2c7f } /* Latin Extended-C */,
	{ 0x2c80, 0x2cff } /* Coptic */,
	{ 0x2d00, 0x2d2f } /* Georgian Supplement */,
	{ 0x2d30, 0x2d7f } /* Tifinagh */,
	{ 0x2d80, 0x2ddf } /* Ethiopic Extended */,
	{ 0x2de0, 0x2dff } /* Cyrillic Extended-A */,
	{ 0x2e00, 0x2e7f } /* Supplemental Punctuation */,
	{ 0x2e80, 0x2eff } /* CJK Radicals Supplement */,
	{ 0x2f00, 0x2fdf } /* Kangxi Radicals */,
	{ 0x2ff0, 0x2fff } /* Ideographic Description Characters */,
	{ 0x3000, 0x303f } /* CJK Symbols and Punctuation */,
	{ 0x3040, 0x309f } /* Hiragana */,
	{ 0x30a0, 0x30ff } /* Katakana */,
	{ 0x3100, 0x312f } /* Bopomofo */,
	{ 0x3130, 0x318f } /* Hangul Compatibility Jamo */,
	{ 0x3190, 0x319f } /* Kanbun */,
	{ 0x31a0, 0x31bf } /* Bopomofo Extended */,
	{ 0x31c0, 0x31ef } /* CJK Strokes */,
	{ 0x31f0, 0x31ff } /* Katakana Phonetic Extensions */,
	{ 0x3200, 0x32ff } /* Enclosed CJK Letters and Months */,
	{ 0x3300, 0x33ff } /* CJK Compatibility */,
	{ 0x3400, 0x4dbf } /* CJK Unified Ideographs Extension A */,
	{ 0x4dc0, 0x4dff } /* Yijing Hexagram Symbols */,
	{ 0x4e00, 0x9fff } /* CJK Unified Ideographs */,
	{ 0xa000, 0xa48f } /* Yi Syllables */,
	{ 0xa490, 0xa4cf } /* Yi Radicals */,
	{ 0xa4d0, 0xa4ff } /* Lisu */,
	{ 0xa500, 0xa63f } /* Vai */,
	{ 0xa640, 0xa69f } /* Cyrillic Extended-B */,
	{ 0xa6a0, 0xa6ff } /* Bamum */,
	{ 0xa700, 0xa71f } /* Modifier Tone Letters */,
	{ 0xa720, 0xa7ff } /* Latin Extended-D */,
	{ 0xa800, 0xa82f } /* Syloti Nagri */,
	{ 0xa830, 0xa83f } /* Common Indic Number Forms */,
	{ 0xa840, 0xa87f } /* Phags-pa */,
	{ 0xa880, 0xa8df } /* Saurashtra */,
	{ 0xa8e0, 0xa8ff } /* Devanagari Extended */,
	{ 0xa900, 0xa92f } /* Kayah Li */,
	{ 0xa930, 0xa95f } /* Rejang */,
	{ 0xa960, 0xa97f } /* Hangul Jamo Extended-A */,
	{ 0xa980, 0xa9df } /* Javanese */,
	{ 0xa9e0, 0xa9ff } /* Myanmar Extended-B */,
	{ 0xaa00, 0xaa5f } /* Cham */,
	{ 0xaa60, 0xaa7f } /* Myanmar Extended-A */,
	{ 0xaa80, 0xaadf } /* Tai Viet */,
	{ 0xaae0, 0xaaff } /* Meetei Mayek Extensions */,
	{ 0xab00, 0xab2f } /* Ethiopic Extended-A */,
	{ 0xab30, 0xab6f } /* Latin Extended-E */,
	{ 0xab70, 0xabbf } /* Cherokee Supplement */,
	{ 0xabc0, 0xabff } /* Meetei Mayek */,
	{ 0xac00, 0xd7af } /* Hangul Syllables */,
	{ 0xd7b0, 0xd7ff } /* Hangul Jamo Extended-B */,
	{ 0xd800, 0xdb7f } /* High Surrogates */,
	{ 0xdb80, 0xdbff } /* High Private Use Surrogates */,
	{ 0xdc00, 0xdfff } /* Low Surrogates */,
	{ 0xe000, 0xf8ff } /* Private Use Area */,
	{ 0xf900, 0xfaff } /* CJK Compatibility Ideographs */,
	{ 0xfb00, 0xfb4f } /* Alphabetic Presentation Forms */,
	{ 0xfb50, 0xfdff } /* Arabic Presentation Forms-A */,
	{ 0xfe00, 0xfe0f } /* Variation Selectors */,
	{ 0xfe10, 0xfe1f } /* Vertical Forms */,
	{ 0xfe20, 0xfe2f } /* Combining Half Marks */,
	{ 0xfe30, 0xfe4f } /* CJK Compatibility Forms */,
	{ 0xfe50, 0xfe6f } /* Small Form Variants */,
	{ 0xfe70, 0xfeff } /* Arabic Presentation Forms-B */,
	{ 0xff00, 0xffef } /* Halfwidth and Fullwidth Forms */,
	{ 0xfff0, 0xffff } /* Specials */,
	{ 0x10000, 0x1007f } /* Linear B Syllabary */,
	{ 0x10080, 0x100ff } /* Linear B Ideograms */,
	{ 0x10100, 0x1013f } /* Aegean Numbers */,
	{ 0x10140, 0x1018f } /* Ancient Greek Numbers */,
	{ 0x10190, 0x101cf } /* Ancient Symbols */,
	{ 0x101d0, 0x101ff } /* Phaistos Disc */,
	{ 0x10280, 0x1029f } /* Lycian */,
	{ 0x102a0, 0x102df } /* Carian */,
	{ 0x102e0, 0x102ff } /* Coptic Epact Numbers */,
	{ 0x10300, 0x1032f } /* Old Italic */,
	{ 0x10330, 0x1034f } /* Gothic */,
	{ 0x10350, 0x1037f } /* Old Permic */,
	{ 0x10380, 0x1039f } /* Ugaritic */,
	{ 0x103a0, 0x103df } /* Old Persian */,
	{ 0x10400, 0x1044f } /* Deseret */,
	{ 0x10450, 0x1047f } /* Shavian */,
	{ 0x10480, 0x104af } /* Osmanya */,
	{ 0x104b0, 0x104ff } /* Osage */,
	{ 0x10500, 0x1052f } /* Elbasan */,
	{ 0x10530, 0x1056f } /* Caucasian Albanian */,
	{ 0x10600, 0x1077f } /* Linear A */,
	{ 0x10800, 0x1083f } /* Cypriot Syllabary */,
	{ 0x10840, 0x1085f } /* Imperial Aramaic */,
	{ 0x10860, 0x1087f } /* Palmyrene */,
	{ 0x10880, 0x108af } /* Nabataean */,
	{ 0x108e0, 0x108ff } /* Hatran */,
	{ 0x10900, 0x1091f } /* Phoenician */,
	{ 0x10920, 0x1093f } /* Lydian */,
	{ 0x10980, 0x1099f } /* Meroitic Hieroglyphs */,
	{ 0x109a0, 0x109ff } /* Meroitic Cursive */,
	{ 0x10a00, 0x10a5f } /* Kharoshthi */,
	{ 0x10a60, 0x10a7f } /* Old South Arabian */,
	{ 0x10a80, 0x10a9f } /* Old North Arabian */,
	{ 0x10ac0, 0x10aff } /* Manichaean */,
	{ 0x10b00, 0x10b3f } /* Avestan */,
	{ 0x10b40, 0x10b5f } /* Inscriptional Parthian */,
	{ 0x10b60, 0x10b7f } /* Inscriptional Pahlavi */,
	{ 0x10b80, 0x10baf } /* Psalter Pahlavi */,
	{ 0x10c00, 0x10c4f } /* Old Turkic */,
	{ 0x10c80, 0x10cff } /* Old Hungarian */,
	{ 0x10e60, 0x10e7f } /* Rumi Numeral Symbols */,
	{ 0x11000, 0x1107f } /* Brahmi */,
	{ 0x11080, 0x110cf } /* Kaithi */,
	{ 0x110d0, 0x110ff } /* Sora Sompeng */,
	{ 0x11100, 0x1114f } /* Chakma */,
	{ 0x11150, 0x1117f } /* Mahajani */,
	{ 0x11180, 0x111df } /* Sharada */,
	{ 0x111e0, 0x111ff } /* Sinhala Archaic Numbers */,
	{ 0x11200, 0x1124f } /* Khojki */,
	{ 0x11280, 0x112af } /* Multani */,
	{ 0x112b0, 0x112ff } /* Khudawadi */,
	{ 0x11300, 0x1137f } /* Grantha */,
	{ 0x11400, 0x1147f } /* Newa */,
	{ 0x11480, 0x114df } /* Tirhuta */,
	{ 0x11580, 0x115ff } /* Siddham */,
	{ 0x11600, 0x1165f } /* Modi */,
	{ 0x11660, 0x1167f } /* Mongolian Supplement */,
	{ 0x11680, 0x116cf } /* Takri */,
	{ 0x11700, 0x1173f } /* Ahom */,
	{ 0x118a0, 0x118ff } /* Warang Citi */,
	{ 0x11ac0, 0x11aff } /* Pau Cin Hau */,
	{ 0x11c00, 0x11c6f } /* Bhaiksuki */,
	{ 0x11c70, 0x11cbf } /* Marchen */,
	{ 0x12000, 0x123ff } /* Cuneiform */,
	{ 0x12400, 0x1247f } /* Cuneiform Numbers and Punctuation */,
	{ 0x12480, 0x1254f } /* Early Dynastic Cuneiform */,
	{ 0x13000, 0x1342f } /* Egyptian Hieroglyphs */,
	{ 0x14400, 0x1467f } /* Anatolian Hieroglyphs */,
	{ 0x16800, 0x16a3f } /* Bamum Supplement */,
	{ 0x16a40, 0x16a6f } /* Mro */,
	{ 0x16ad0, 0x16aff } /* Bassa Vah */,
	{ 0x16b00, 0x16b8f } /* Pahawh Hmong */,
	{ 0x16f00, 0x16f9f } /* Miao */,
	{ 0x16fe0, 0x16fff } /* Ideographic Symbols and Punctuation */,
	{ 0x17000, 0x187ff } /* Tangut */,
	{ 0x18800, 0x18aff } /* Tangut Components */,
	{ 0x1b000, 0x1b0ff } /* Kana Supplement */,
	{ 0x1bc00, 0x1bc9f } /* Duployan */,
	{ 0x1bca0, 0x1bcaf } /* Shorthand Format Controls */,
	{ 0x1d000, 0x1d0ff } /* Byzantine Musical Symbols */,
	{ 0x1d100, 0x1d1ff } /* Musical Symbols */,
	{ 0x1d200, 0x1d24f } /* Ancient Greek Musical Notation */,
	{ 0x1d300, 0x1d35f } /* Tai Xuan Jing Symbols */,
	{ 0x1d360, 0x1d37f } /* Counting Rod Numerals */,
	{ 0x1d400, 0x1d7ff } /* Mathematical Alphanumeric Symbols */,
	{ 0x1d800, 0x1daaf } /* Sutton SignWriting */,
	{ 0x1e000, 0x1e02f } /* Glagolitic Supplement */,
	{ 0x1e800, 0x1e8df } /* Mende Kikakui */,
	{ 0x1e900, 0x1e95f } /* Adlam */,
	{ 0x1ee00, 0x1eeff } /* Arabic Mathematical Alphabetic Symbols */,
	{ 0x1f000, 0x1f02f } /* Mahjong Tiles */,
	{ 0x1f030, 0x1f09f } /* Domino Tiles */,
	{ 0x1f0a0, 0x1f0ff } /* Playing Cards */,
	{ 0x1f100, 0x1f1ff } /* Enclosed Alphanumeric Supplement */,
	{ 0x1f200, 0x1f2ff } /* Enclosed Ideographic Supplement */,
	{ 0x1f300, 0x1f5ff } /* Miscellaneous Symbols and Pictographs */,
	{ 0x1f600, 0x1f64f } /* Emoticons */,
	{ 0x1f650, 0x1f67f } /* Ornamental Dingbats */,
	{ 0x1f680, 0x1f6ff } /* Transport and Map Symbols */,
	{ 0x1f700, 0x1f77f } /* Alchemical Symbols */,
	{ 0x1f780, 0x1f7ff } /* Geometric Shapes Extended */,
	{ 0x1f800, 0x1f8ff } /* Supplemental Arrows-C */,
	{ 0x1f900, 0x1f9ff } /* Supplemental Symbols and Pictographs */,
	{ 0x20000, 0x2a6df } /* CJK Unified Ideographs Extension B */,
	{ 0x2a700, 0x2b73f } /* CJK Unified Ideographs Extension C */,
	{ 0x2b740, 0x2b81f } /* CJK Unified Ideographs Extension D */,
	{ 0x2b820, 0x2ceaf } /* CJK Unified Ideographs Extension E */,
	{ 0x2f800, 0x2fa1f } /* CJK Compatibility Ideographs Supplement */,
	{ 0xe0000, 0xe007f } /* Tags */,
	{ 0xe0100, 0xe01ef } /* Variation Selectors Supplement */,
	{ 0xf0000, 0xfffff } /* Supplementary Private Use Area-A */,
	{ 0x100000, 0x10ffff } /* Supplementary Private Use Area-B */
};

struct interval Co_table[] = {
	{ 0xe000, 0xf8ff },
	{ 0xf0000, 0xffffd },
	{ 0x100000, 0x10fffd }
};

struct interval Cs_table[] = {
	{ 0xd800, 0xdfff }
};

struct interval Zp_table[] = {
	{ 0x2029, 0x2029 }
};

struct interval Zl_table[] = {
	{ 0x2028, 0x2028 }
};

struct interval Nl_table[] = {
	{ 0x16ee, 0x16f0 },
	{ 0x2160, 0x2182 },
	{ 0x2185, 0x2188 },
	{ 0x3007, 0x3007 },
	{ 0x3021, 0x3029 },
	{ 0x3038, 0x303a },
	{ 0xa6e6, 0xa6ef },
	{ 0x10140, 0x10174 },
	{ 0x10341, 0x10341 },
	{ 0x1034a, 0x1034a },
	{ 0x103d1, 0x103d5 },
	{ 0x12400, 0x1246e }
};

struct interval Mc_table[] = {
	{ 0x903, 0x903 },
	{ 0x93b, 0x93b },
	{ 0x93e, 0x940 },
	{ 0x949, 0x94c },
	{ 0x94e, 0x94f },
	{ 0x982, 0x983 },
	{ 0x9be, 0x9c0 },
	{ 0x9c7, 0x9c8 },
	{ 0x9cb, 0x9cc },
	{ 0x9d7, 0x9d7 },
	{ 0xa03, 0xa03 },
	{ 0xa3e, 0xa40 },
	{ 0xa83, 0xa83 },
	{ 0xabe, 0xac0 },
	{ 0xac9, 0xac9 },
	{ 0xacb, 0xacc },
	{ 0xb02, 0xb03 },
	{ 0xb3e, 0xb3e },
	{ 0xb40, 0xb40 },
	{ 0xb47, 0xb48 },
	{ 0xb4b, 0xb4c },
	{ 0xb57, 0xb57 },
	{ 0xbbe, 0xbbf },
	{ 0xbc1, 0xbc2 },
	{ 0xbc6, 0xbc8 },
	{ 0xbca, 0xbcc },
	{ 0xbd7, 0xbd7 },
	{ 0xc01, 0xc03 },
	{ 0xc41, 0xc44 },
	{ 0xc82, 0xc83 },
	{ 0xcbe, 0xcbe },
	{ 0xcc0, 0xcc4 },
	{ 0xcc7, 0xcc8 },
	{ 0xcca, 0xccb },
	{ 0xcd5, 0xcd6 },
	{ 0xd02, 0xd03 },
	{ 0xd3e, 0xd40 },
	{ 0xd46, 0xd48 },
	{ 0xd4a, 0xd4c },
	{ 0xd57, 0xd57 },
	{ 0xd82, 0xd83 },
	{ 0xdcf, 0xdd1 },
	{ 0xdd8, 0xddf },
	{ 0xdf2, 0xdf3 },
	{ 0xf3e, 0xf3f },
	{ 0xf7f, 0xf7f },
	{ 0x102b, 0x102c },
	{ 0x1031, 0x1031 },
	{ 0x1038, 0x1038 },
	{ 0x103b, 0x103c },
	{ 0x1056, 0x1057 },
	{ 0x1062, 0x1064 },
	{ 0x1067, 0x106d },
	{ 0x1083, 0x1084 },
	{ 0x1087, 0x108c },
	{ 0x108f, 0x108f },
	{ 0x109a, 0x109c },
	{ 0x17b6, 0x17b6 },
	{ 0x17be, 0x17c5 },
	{ 0x17c7, 0x17c8 },
	{ 0x1923, 0x1926 },
	{ 0x1929, 0x192b },
	{ 0x1930, 0x1931 },
	{ 0x1933, 0x1938 },
	{ 0x1a19, 0x1a1a },
	{ 0x1a55, 0x1a55 },
	{ 0x1a57, 0x1a57 },
	{ 0x1a61, 0x1a61 },
	{ 0x1a63, 0x1a64 },
	{ 0x1a6d, 0x1a72 },
	{ 0x1b04, 0x1b04 },
	{ 0x1b35, 0x1b35 },
	{ 0x1b3b, 0x1b3b },
	{ 0x1b3d, 0x1b41 },
	{ 0x1b43, 0x1b44 },
	{ 0x1b82, 0x1b82 },
	{ 0x1ba1, 0x1ba1 },
	{ 0x1ba6, 0x1ba7 },
	{ 0x1baa, 0x1baa },
	{ 0x1be7, 0x1be7 },
	{ 0x1bea, 0x1bec },
	{ 0x1bee, 0x1bee },
	{ 0x1bf2, 0x1bf3 },
	{ 0x1c24, 0x1c2b },
	{ 0x1c34, 0x1c35 },
	{ 0x1ce1, 0x1ce1 },
	{ 0x1cf2, 0x1cf3 },
	{ 0x302e, 0x302f },
	{ 0xa823, 0xa824 },
	{ 0xa827, 0xa827 },
	{ 0xa880, 0xa881 },
	{ 0xa8b4, 0xa8c3 },
	{ 0xa952, 0xa953 },
	{ 0xa983, 0xa983 },
	{ 0xa9b4, 0xa9b5 },
	{ 0xa9ba, 0xa9bb },
	{ 0xa9bd, 0xa9c0 },
	{ 0xaa2f, 0xaa30 },
	{ 0xaa33, 0xaa34 },
	{ 0xaa4d, 0xaa4d },
	{ 0xaa7b, 0xaa7b },
	{ 0xaa7d, 0xaa7d },
	{ 0xaaeb, 0xaaeb },
	{ 0xaaee, 0xaaef },
	{ 0xaaf5, 0xaaf5 },
	{ 0xabe3, 0xabe4 },
	{ 0xabe6, 0xabe7 },
	{ 0xabe9, 0xabea },
	{ 0xabec, 0xabec },
	{ 0x11000, 0x11000 },
	{ 0x11002, 0x11002 },
	{ 0x11082, 0x11082 },
	{ 0x110b0, 0x110b2 },
	{ 0x110b7, 0x110b8 },
	{ 0x1112c, 0x1112c },
	{ 0x11182, 0x11182 },
	{ 0x111b3, 0x111b5 },
	{ 0x111bf, 0x111c0 },
	{ 0x1122c, 0x1122e },
	{ 0x11232, 0x11233 },
	{ 0x11235, 0x11235 },
	{ 0x112e0, 0x112e2 },
	{ 0x11302, 0x11303 },
	{ 0x1133e, 0x1133f },
	{ 0x11341, 0x11344 },
	{ 0x11347, 0x11348 },
	{ 0x1134b, 0x1134d },
	{ 0x11357, 0x11357 },
	{ 0x11362, 0x11363 },
	{ 0x11435, 0x11437 },
	{ 0x11440, 0x11441 },
	{ 0x11445, 0x11445 },
	{ 0x114b0, 0x114b2 },
	{ 0x114b9, 0x114b9 },
	{ 0x114bb, 0x114be },
	{ 0x114c1, 0x114c1 },
	{ 0x115af, 0x115b1 },
	{ 0x115b8, 0x115bb },
	{ 0x115be, 0x115be },
	{ 0x11630, 0x11632 },
	{ 0x1163b, 0x1163c },
	{ 0x1163e, 0x1163e },
	{ 0x116ac, 0x116ac },
	{ 0x116ae, 0x116af },
	{ 0x116b6, 0x116b6 },
	{ 0x11720, 0x11721 },
	{ 0x11726, 0x11726 },
	{ 0x11c2f, 0x11c2f },
	{ 0x11c3e, 0x11c3e },
	{ 0x11ca9, 0x11ca9 },
	{ 0x11cb1, 0x11cb1 },
	{ 0x11cb4, 0x11cb4 },
	{ 0x16f51, 0x16f7e },
	{ 0x1d165, 0x1d166 },
	{ 0x1d16d, 0x1d172 }
};

struct interval Me_table[] = {
	{ 0x488, 0x489 },
	{ 0x1abe, 0x1abe },
	{ 0x20dd, 0x20e0 },
	{ 0x20e2, 0x20e4 },
	{ 0xa670, 0xa672 }
};

struct interval Mn_table[] = {
	{ 0x300, 0x36f },
	{ 0x483, 0x487 },
	{ 0x591, 0x5bd },
	{ 0x5bf, 0x5bf },
	{ 0x5c1, 0x5c2 },
	{ 0x5c4, 0x5c5 },
	{ 0x5c7, 0x5c7 },
	{ 0x610, 0x61a },
	{ 0x64b, 0x65f },
	{ 0x670, 0x670 },
	{ 0x6d6, 0x6dc },
	{ 0x6df, 0x6e4 },
	{ 0x6e7, 0x6e8 },
	{ 0x6ea, 0x6ed },
	{ 0x711, 0x711 },
	{ 0x730, 0x74a },
	{ 0x7a6, 0x7b0 },
	{ 0x7eb, 0x7f3 },
	{ 0x816, 0x819 },
	{ 0x81b, 0x823 },
	{ 0x825, 0x827 },
	{ 0x829, 0x82d },
	{ 0x859, 0x85b },
	{ 0x8d4, 0x8e1 },
	{ 0x8e3, 0x902 },
	{ 0x93a, 0x93a },
	{ 0x93c, 0x93c },
	{ 0x941, 0x948 },
	{ 0x94d, 0x94d },
	{ 0x951, 0x957 },
	{ 0x962, 0x963 },
	{ 0x981, 0x981 },
	{ 0x9bc, 0x9bc },
	{ 0x9c1, 0x9c4 },
	{ 0x9cd, 0x9cd },
	{ 0x9e2, 0x9e3 },
	{ 0xa01, 0xa02 },
	{ 0xa3c, 0xa3c },
	{ 0xa41, 0xa42 },
	{ 0xa47, 0xa48 },
	{ 0xa4b, 0xa4d },
	{ 0xa51, 0xa51 },
	{ 0xa70, 0xa71 },
	{ 0xa75, 0xa75 },
	{ 0xa81, 0xa82 },
	{ 0xabc, 0xabc },
	{ 0xac1, 0xac5 },
	{ 0xac7, 0xac8 },
	{ 0xacd, 0xacd },
	{ 0xae2, 0xae3 },
	{ 0xb01, 0xb01 },
	{ 0xb3c, 0xb3c },
	{ 0xb3f, 0xb3f },
	{ 0xb41, 0xb44 },
	{ 0xb4d, 0xb4d },
	{ 0xb56, 0xb56 },
	{ 0xb62, 0xb63 },
	{ 0xb82, 0xb82 },
	{ 0xbc0, 0xbc0 },
	{ 0xbcd, 0xbcd },
	{ 0xc00, 0xc00 },
	{ 0xc3e, 0xc40 },
	{ 0xc46, 0xc48 },
	{ 0xc4a, 0xc4d },
	{ 0xc55, 0xc56 },
	{ 0xc62, 0xc63 },
	{ 0xc81, 0xc81 },
	{ 0xcbc, 0xcbc },
	{ 0xcbf, 0xcbf },
	{ 0xcc6, 0xcc6 },
	{ 0xccc, 0xccd },
	{ 0xce2, 0xce3 },
	{ 0xd01, 0xd01 },
	{ 0xd41, 0xd44 },
	{ 0xd4d, 0xd4d },
	{ 0xd62, 0xd63 },
	{ 0xdca, 0xdca },
	{ 0xdd2, 0xdd4 },
	{ 0xdd6, 0xdd6 },
	{ 0xe31, 0xe31 },
	{ 0xe34, 0xe3a },
	{ 0xe47, 0xe4e },
	{ 0xeb1, 0xeb1 },
	{ 0xeb4, 0xeb9 },
	{ 0xebb, 0xebc },
	{ 0xec8, 0xecd },
	{ 0xf18, 0xf19 },
	{ 0xf35, 0xf35 },
	{ 0xf37, 0xf37 },
	{ 0xf39, 0xf39 },
	{ 0xf71, 0xf7e },
	{ 0xf80, 0xf84 },
	{ 0xf86, 0xf87 },
	{ 0xf8d, 0xf97 },
	{ 0xf99, 0xfbc },
	{ 0xfc6, 0xfc6 },
	{ 0x102d, 0x1030 },
	{ 0x1032, 0x1037 },
	{ 0x1039, 0x103a },
	{ 0x103d, 0x103e },
	{ 0x1058, 0x1059 },
	{ 0x105e, 0x1060 },
	{ 0x1071, 0x1074 },
	{ 0x1082, 0x1082 },
	{ 0x1085, 0x1086 },
	{ 0x108d, 0x108d },
	{ 0x109d, 0x109d },
	{ 0x135d, 0x135f },
	{ 0x1712, 0x1714 },
	{ 0x1732, 0x1734 },
	{ 0x1752, 0x1753 },
	{ 0x1772, 0x1773 },
	{ 0x17b4, 0x17b5 },
	{ 0x17b7, 0x17bd },
	{ 0x17c6, 0x17c6 },
	{ 0x17c9, 0x17d3 },
	{ 0x17dd, 0x17dd },
	{ 0x180b, 0x180d },
	{ 0x1885, 0x1886 },
	{ 0x18a9, 0x18a9 },
	{ 0x1920, 0x1922 },
	{ 0x1927, 0x1928 },
	{ 0x1932, 0x1932 },
	{ 0x1939, 0x193b },
	{ 0x1a17, 0x1a18 },
	{ 0x1a1b, 0x1a1b },
	{ 0x1a56, 0x1a56 },
	{ 0x1a58, 0x1a5e },
	{ 0x1a60, 0x1a60 },
	{ 0x1a62, 0x1a62 },
	{ 0x1a65, 0x1a6c },
	{ 0x1a73, 0x1a7c },
	{ 0x1a7f, 0x1a7f },
	{ 0x1ab0, 0x1abd },
	{ 0x1b00, 0x1b03 },
	{ 0x1b34, 0x1b34 },
	{ 0x1b36, 0x1b3a },
	{ 0x1b3c, 0x1b3c },
	{ 0x1b42, 0x1b42 },
	{ 0x1b6b, 0x1b73 },
	{ 0x1b80, 0x1b81 },
	{ 0x1ba2, 0x1ba5 },
	{ 0x1ba8, 0x1ba9 },
	{ 0x1bab, 0x1bad },
	{ 0x1be6, 0x1be6 },
	{ 0x1be8, 0x1be9 },
	{ 0x1bed, 0x1bed },
	{ 0x1bef, 0x1bf1 },
	{ 0x1c2c, 0x1c33 },
	{ 0x1c36, 0x1c37 },
	{ 0x1cd0, 0x1cd2 },
	{ 0x1cd4, 0x1ce0 },
	{ 0x1ce2, 0x1ce8 },
	{ 0x1ced, 0x1ced },
	{ 0x1cf4, 0x1cf4 },
	{ 0x1cf8, 0x1cf9 },
	{ 0x1dc0, 0x1df5 },
	{ 0x1dfb, 0x1dff },
	{ 0x20d0, 0x20dc },
	{ 0x20e1, 0x20e1 },
	{ 0x20e5, 0x20f0 },
	{ 0x2cef, 0x2cf1 },
	{ 0x2d7f, 0x2d7f },
	{ 0x2de0, 0x2dff },
	{ 0x302a, 0x302d },
	{ 0x3099, 0x309a },
	{ 0xa66f, 0xa66f },
	{ 0xa674, 0xa67d },
	{ 0xa69e, 0xa69f },
	{ 0xa6f0, 0xa6f1 },
	{ 0xa802, 0xa802 },
	{ 0xa806, 0xa806 },
	{ 0xa80b, 0xa80b },
	{ 0xa825, 0xa826 },
	{ 0xa8c4, 0xa8c5 },
	{ 0xa8e0, 0xa8f1 },
	{ 0xa926, 0xa92d },
	{ 0xa947, 0xa951 },
	{ 0xa980, 0xa982 },
	{ 0xa9b3, 0xa9b3 },
	{ 0xa9b6, 0xa9b9 },
	{ 0xa9bc, 0xa9bc },
	{ 0xa9e5, 0xa9e5 },
	{ 0xaa29, 0xaa2e },
	{ 0xaa31, 0xaa32 },
	{ 0xaa35, 0xaa36 },
	{ 0xaa43, 0xaa43 },
	{ 0xaa4c, 0xaa4c },
	{ 0xaa7c, 0xaa7c },
	{ 0xaab0, 0xaab0 },
	{ 0xaab2, 0xaab4 },
	{ 0xaab7, 0xaab8 },
	{ 0xaabe, 0xaabf },
	{ 0xaac1, 0xaac1 },
	{ 0xaaec, 0xaaed },
	{ 0xaaf6, 0xaaf6 },
	{ 0xabe5, 0xabe5 },
	{ 0xabe8, 0xabe8 },
	{ 0xabed, 0xabed },
	{ 0xfb1e, 0xfb1e },
	{ 0xfe00, 0xfe0f },
	{ 0xfe20, 0xfe2f },
	{ 0x101fd, 0x101fd },
	{ 0x102e0, 0x102e0 },
	{ 0x10376, 0x1037a },
	{ 0x10a01, 0x10a03 },
	{ 0x10a05, 0x10a06 },
	{ 0x10a0c, 0x10a0f },
	{ 0x10a38, 0x10a3a },
	{ 0x10a3f, 0x10a3f },
	{ 0x10ae5, 0x10ae6 },
	{ 0x11001, 0x11001 },
	{ 0x11038, 0x11046 },
	{ 0x1107f, 0x11081 },
	{ 0x110b3, 0x110b6 },
	{ 0x110b9, 0x110ba },
	{ 0x11100, 0x11102 },
	{ 0x11127, 0x1112b },
	{ 0x1112d, 0x11134 },
	{ 0x11173, 0x11173 },
	{ 0x11180, 0x11181 },
	{ 0x111b6, 0x111be },
	{ 0x111ca, 0x111cc },
	{ 0x1122f, 0x11231 },
	{ 0x11234, 0x11234 },
	{ 0x11236, 0x11237 },
	{ 0x1123e, 0x1123e },
	{ 0x112df, 0x112df },
	{ 0x112e3, 0x112ea },
	{ 0x11300, 0x11301 },
	{ 0x1133c, 0x1133c },
	{ 0x11340, 0x11340 },
	{ 0x11366, 0x1136c },
	{ 0x11370, 0x11374 },
	{ 0x11438, 0x1143f },
	{ 0x11442, 0x11444 },
	{ 0x11446, 0x11446 },
	{ 0x114b3, 0x114b8 },
	{ 0x114ba, 0x114ba },
	{ 0x114bf, 0x114c0 },
	{ 0x114c2, 0x114c3 },
	{ 0x115b2, 0x115b5 },
	{ 0x115bc, 0x115bd },
	{ 0x115bf, 0x115c0 },
	{ 0x115dc, 0x115dd },
	{ 0x11633, 0x1163a },
	{ 0x1163d, 0x1163d },
	{ 0x1163f, 0x11640 },
	{ 0x116ab, 0x116ab },
	{ 0x116ad, 0x116ad },
	{ 0x116b0, 0x116b5 },
	{ 0x116b7, 0x116b7 },
	{ 0x1171d, 0x1171f },
	{ 0x11722, 0x11725 },
	{ 0x11727, 0x1172b },
	{ 0x11c30, 0x11c36 },
	{ 0x11c38, 0x11c3d },
	{ 0x11c3f, 0x11c3f },
	{ 0x11c92, 0x11ca7 },
	{ 0x11caa, 0x11cb0 },
	{ 0x11cb2, 0x11cb3 },
	{ 0x11cb5, 0x11cb6 },
	{ 0x16af0, 0x16af4 },
	{ 0x16b30, 0x16b36 },
	{ 0x16f8f, 0x16f92 },
	{ 0x1bc9d, 0x1bc9e },
	{ 0x1d167, 0x1d169 },
	{ 0x1d17b, 0x1d182 },
	{ 0x1d185, 0x1d18b },
	{ 0x1d1aa, 0x1d1ad },
	{ 0x1d242, 0x1d244 },
	{ 0x1da00, 0x1da36 },
	{ 0x1da3b, 0x1da6c },
	{ 0x1da75, 0x1da75 },
	{ 0x1da84, 0x1da84 },
	{ 0x1da9b, 0x1da9f },
	{ 0x1daa1, 0x1daaf },
	{ 0x1e000, 0x1e006 },
	{ 0x1e008, 0x1e018 },
	{ 0x1e01b, 0x1e021 },
	{ 0x1e023, 0x1e024 },
	{ 0x1e026, 0x1e02a },
	{ 0x1e8d0, 0x1e8d6 },
	{ 0x1e944, 0x1e94a },
	{ 0xe0100, 0xe01ef }
};

struct interval Lm_table[] = {
	{ 0x2b0, 0x2c1 },
	{ 0x2c6, 0x2d1 },
	{ 0x2e0, 0x2e4 },
	{ 0x2ec, 0x2ec },
	{ 0x2ee, 0x2ee },
	{ 0x374, 0x374 },
	{ 0x37a, 0x37a },
	{ 0x559, 0x559 },
	{ 0x640, 0x640 },
	{ 0x6e5, 0x6e6 },
	{ 0x7f4, 0x7f5 },
	{ 0x7fa, 0x7fa },
	{ 0x81a, 0x81a },
	{ 0x824, 0x824 },
	{ 0x828, 0x828 },
	{ 0x971, 0x971 },
	{ 0xe46, 0xe46 },
	{ 0xec6, 0xec6 },
	{ 0x10fc, 0x10fc },
	{ 0x17d7, 0x17d7 },
	{ 0x1843, 0x1843 },
	{ 0x1aa7, 0x1aa7 },
	{ 0x1c78, 0x1c7d },
	{ 0x1d2c, 0x1d6a },
	{ 0x1d78, 0x1d78 },
	{ 0x1d9b, 0x1dbf },
	{ 0x2071, 0x2071 },
	{ 0x207f, 0x207f },
	{ 0x2090, 0x209c },
	{ 0x2c7c, 0x2c7d },
	{ 0x2d6f, 0x2d6f },
	{ 0x2e2f, 0x2e2f },
	{ 0x3005, 0x3005 },
	{ 0x3031, 0x3035 },
	{ 0x303b, 0x303b },
	{ 0x309d, 0x309e },
	{ 0x30fc, 0x30fe },
	{ 0xa015, 0xa015 },
	{ 0xa4f8, 0xa4fd },
	{ 0xa60c, 0xa60c },
	{ 0xa67f, 0xa67f },
	{ 0xa69c, 0xa69d },
	{ 0xa717, 0xa71f },
	{ 0xa770, 0xa770 },
	{ 0xa788, 0xa788 },
	{ 0xa7f8, 0xa7f9 },
	{ 0xa9cf, 0xa9cf },
	{ 0xa9e6, 0xa9e6 },
	{ 0xaa70, 0xaa70 },
	{ 0xaadd, 0xaadd },
	{ 0xaaf3, 0xaaf4 },
	{ 0xab5c, 0xab5f },
	{ 0xff70, 0xff70 },
	{ 0xff9e, 0xff9f },
	{ 0x16b40, 0x16b43 },
	{ 0x16f93, 0x16f9f },
	{ 0x16fe0, 0x16fe0 }
};

struct interval Lt_table[] = {
	{ 0x1c5, 0x1c5 },
	{ 0x1c8, 0x1c8 },
	{ 0x1cb, 0x1cb },
	{ 0x1f2, 0x1f2 },
	{ 0x1f88, 0x1f8f },
	{ 0x1f98, 0x1f9f },
	{ 0x1fa8, 0x1faf },
	{ 0x1fbc, 0x1fbc },
	{ 0x1fcc, 0x1fcc },
	{ 0x1ffc, 0x1ffc }
};

struct interval Pf_table[] = {
	{ 0xbb, 0xbb },
	{ 0x2019, 0x2019 },
	{ 0x201d, 0x201d },
	{ 0x203a, 0x203a },
	{ 0x2e03, 0x2e03 },
	{ 0x2e05, 0x2e05 },
	{ 0x2e0a, 0x2e0a },
	{ 0x2e0d, 0x2e0d },
	{ 0x2e1d, 0x2e1d },
	{ 0x2e21, 0x2e21 }
};

struct interval No_table[] = {
	{ 0xb2, 0xb3 },
	{ 0xb9, 0xb9 },
	{ 0xbc, 0xbe },
	{ 0x9f4, 0x9f9 },
	{ 0xb72, 0xb77 },
	{ 0xbf0, 0xbf2 },
	{ 0xc78, 0xc7e },
	{ 0xd58, 0xd5e },
	{ 0xd70, 0xd78 },
	{ 0xf2a, 0xf33 },
	{ 0x1369, 0x137c },
	{ 0x17f0, 0x17f9 },
	{ 0x19da, 0x19da },
	{ 0x2070, 0x2070 },
	{ 0x2074, 0x2079 },
	{ 0x2080, 0x2089 },
	{ 0x2150, 0x215f },
	{ 0x2189, 0x2189 },
	{ 0x2460, 0x249b },
	{ 0x24ea, 0x24ff },
	{ 0x2776, 0x2793 },
	{ 0x2cfd, 0x2cfd },
	{ 0x3192, 0x3195 },
	{ 0x3220, 0x3229 },
	{ 0x3248, 0x324f },
	{ 0x3251, 0x325f },
	{ 0x3280, 0x3289 },
	{ 0x32b1, 0x32bf },
	{ 0xa830, 0xa835 },
	{ 0x10107, 0x10133 },
	{ 0x10175, 0x10178 },
	{ 0x1018a, 0x1018b },
	{ 0x102e1, 0x102fb },
	{ 0x10320, 0x10323 },
	{ 0x10858, 0x1085f },
	{ 0x10879, 0x1087f },
	{ 0x108a7, 0x108af },
	{ 0x108fb, 0x108ff },
	{ 0x10916, 0x1091b },
	{ 0x109bc, 0x109bd },
	{ 0x109c0, 0x109cf },
	{ 0x109d2, 0x109ff },
	{ 0x10a40, 0x10a47 },
	{ 0x10a7d, 0x10a7e },
	{ 0x10a9d, 0x10a9f },
	{ 0x10aeb, 0x10aef },
	{ 0x10b58, 0x10b5f },
	{ 0x10b78, 0x10b7f },
	{ 0x10ba9, 0x10baf },
	{ 0x10cfa, 0x10cff },
	{ 0x10e60, 0x10e7e },
	{ 0x11052, 0x11065 },
	{ 0x111e1, 0x111f4 },
	{ 0x1173a, 0x1173b },
	{ 0x118ea, 0x118f2 },
	{ 0x11c5a, 0x11c6c },
	{ 0x16b5b, 0x16b61 },
	{ 0x1d360, 0x1d371 },
	{ 0x1e8c7, 0x1e8cf },
	{ 0x1f100, 0x1f10c }
};

struct interval Cf_table[] = {
	{ 0xad, 0xad },
	{ 0x600, 0x605 },
	{ 0x61c, 0x61c },
	{ 0x6dd, 0x6dd },
	{ 0x70f, 0x70f },
	{ 0x8e2, 0x8e2 },
	{ 0x180e, 0x180e },
	{ 0x200b, 0x200f },
	{ 0x202a, 0x202e },
	{ 0x2060, 0x2064 },
	{ 0x2066, 0x206f },
	{ 0xfeff, 0xfeff },
	{ 0xfff9, 0xfffb },
	{ 0x110bd, 0x110bd },
	{ 0x1bca0, 0x1bca3 },
	{ 0x1d173, 0x1d17a },
	{ 0xe0001, 0xe0001 },
	{ 0xe0020, 0xe007f }
};

struct interval Pi_table[] = {
	{ 0xab, 0xab },
	{ 0x2018, 0x2018 },
	{ 0x201b, 0x201c },
	{ 0x201f, 0x201f },
	{ 0x2039, 0x2039 },
	{ 0x2e02, 0x2e02 },
	{ 0x2e04, 0x2e04 },
	{ 0x2e09, 0x2e09 },
	{ 0x2e0c, 0x2e0c },
	{ 0x2e1c, 0x2e1c },
	{ 0x2e20, 0x2e20 }
};

struct interval Lo_table[] = {
	{ 0xaa, 0xaa },
	{ 0xba, 0xba },
	{ 0x1bb, 0x1bb },
	{ 0x1c0, 0x1c3 },
	{ 0x294, 0x294 },
	{ 0x5d0, 0x5ea },
	{ 0x5f0, 0x5f2 },
	{ 0x620, 0x63f },
	{ 0x641, 0x64a },
	{ 0x66e, 0x66f },
	{ 0x671, 0x6d3 },
	{ 0x6d5, 0x6d5 },
	{ 0x6ee, 0x6ef },
	{ 0x6fa, 0x6fc },
	{ 0x6ff, 0x6ff },
	{ 0x710, 0x710 },
	{ 0x712, 0x72f },
	{ 0x74d, 0x7a5 },
	{ 0x7b1, 0x7b1 },
	{ 0x7ca, 0x7ea },
	{ 0x800, 0x815 },
	{ 0x840, 0x858 },
	{ 0x8a0, 0x8b4 },
	{ 0x8b6, 0x8bd },
	{ 0x904, 0x939 },
	{ 0x93d, 0x93d },
	{ 0x950, 0x950 },
	{ 0x958, 0x961 },
	{ 0x972, 0x980 },
	{ 0x985, 0x98c },
	{ 0x98f, 0x990 },
	{ 0x993, 0x9a8 },
	{ 0x9aa, 0x9b0 },
	{ 0x9b2, 0x9b2 },
	{ 0x9b6, 0x9b9 },
	{ 0x9bd, 0x9bd },
	{ 0x9ce, 0x9ce },
	{ 0x9dc, 0x9dd },
	{ 0x9df, 0x9e1 },
	{ 0x9f0, 0x9f1 },
	{ 0xa05, 0xa0a },
	{ 0xa0f, 0xa10 },
	{ 0xa13, 0xa28 },
	{ 0xa2a, 0xa30 },
	{ 0xa32, 0xa33 },
	{ 0xa35, 0xa36 },
	{ 0xa38, 0xa39 },
	{ 0xa59, 0xa5c },
	{ 0xa5e, 0xa5e },
	{ 0xa72, 0xa74 },
	{ 0xa85, 0xa8d },
	{ 0xa8f, 0xa91 },
	{ 0xa93, 0xaa8 },
	{ 0xaaa, 0xab0 },
	{ 0xab2, 0xab3 },
	{ 0xab5, 0xab9 },
	{ 0xabd, 0xabd },
	{ 0xad0, 0xad0 },
	{ 0xae0, 0xae1 },
	{ 0xaf9, 0xaf9 },
	{ 0xb05, 0xb0c },
	{ 0xb0f, 0xb10 },
	{ 0xb13, 0xb28 },
	{ 0xb2a, 0xb30 },
	{ 0xb32, 0xb33 },
	{ 0xb35, 0xb39 },
	{ 0xb3d, 0xb3d },
	{ 0xb5c, 0xb5d },
	{ 0xb5f, 0xb61 },
	{ 0xb71, 0xb71 },
	{ 0xb83, 0xb83 },
	{ 0xb85, 0xb8a },
	{ 0xb8e, 0xb90 },
	{ 0xb92, 0xb95 },
	{ 0xb99, 0xb9a },
	{ 0xb9c, 0xb9c },
	{ 0xb9e, 0xb9f },
	{ 0xba3, 0xba4 },
	{ 0xba8, 0xbaa },
	{ 0xbae, 0xbb9 },
	{ 0xbd0, 0xbd0 },
	{ 0xc05, 0xc0c },
	{ 0xc0e, 0xc10 },
	{ 0xc12, 0xc28 },
	{ 0xc2a, 0xc39 },
	{ 0xc3d, 0xc3d },
	{ 0xc58, 0xc5a },
	{ 0xc60, 0xc61 },
	{ 0xc80, 0xc80 },
	{ 0xc85, 0xc8c },
	{ 0xc8e, 0xc90 },
	{ 0xc92, 0xca8 },
	{ 0xcaa, 0xcb3 },
	{ 0xcb5, 0xcb9 },
	{ 0xcbd, 0xcbd },
	{ 0xcde, 0xcde },
	{ 0xce0, 0xce1 },
	{ 0xcf1, 0xcf2 },
	{ 0xd05, 0xd0c },
	{ 0xd0e, 0xd10 },
	{ 0xd12, 0xd3a },
	{ 0xd3d, 0xd3d },
	{ 0xd4e, 0xd4e },
	{ 0xd54, 0xd56 },
	{ 0xd5f, 0xd61 },
	{ 0xd7a, 0xd7f },
	{ 0xd85, 0xd96 },
	{ 0xd9a, 0xdb1 },
	{ 0xdb3, 0xdbb },
	{ 0xdbd, 0xdbd },
	{ 0xdc0, 0xdc6 },
	{ 0xe01, 0xe30 },
	{ 0xe32, 0xe33 },
	{ 0xe40, 0xe45 },
	{ 0xe81, 0xe82 },
	{ 0xe84, 0xe84 },
	{ 0xe87, 0xe88 },
	{ 0xe8a, 0xe8a },
	{ 0xe8d, 0xe8d },
	{ 0xe94, 0xe97 },
	{ 0xe99, 0xe9f },
	{ 0xea1, 0xea3 },
	{ 0xea5, 0xea5 },
	{ 0xea7, 0xea7 },
	{ 0xeaa, 0xeab },
	{ 0xead, 0xeb0 },
	{ 0xeb2, 0xeb3 },
	{ 0xebd, 0xebd },
	{ 0xec0, 0xec4 },
	{ 0xedc, 0xedf },
	{ 0xf00, 0xf00 },
	{ 0xf40, 0xf47 },
	{ 0xf49, 0xf6c },
	{ 0xf88, 0xf8c },
	{ 0x1000, 0x102a },
	{ 0x103f, 0x103f },
	{ 0x1050, 0x1055 },
	{ 0x105a, 0x105d },
	{ 0x1061, 0x1061 },
	{ 0x1065, 0x1066 },
	{ 0x106e, 0x1070 },
	{ 0x1075, 0x1081 },
	{ 0x108e, 0x108e },
	{ 0x10d0, 0x10fa },
	{ 0x10fd, 0x1248 },
	{ 0x124a, 0x124d },
	{ 0x1250, 0x1256 },
	{ 0x1258, 0x1258 },
	{ 0x125a, 0x125d },
	{ 0x1260, 0x1288 },
	{ 0x128a, 0x128d },
	{ 0x1290, 0x12b0 },
	{ 0x12b2, 0x12b5 },
	{ 0x12b8, 0x12be },
	{ 0x12c0, 0x12c0 },
	{ 0x12c2, 0x12c5 },
	{ 0x12c8, 0x12d6 },
	{ 0x12d8, 0x1310 },
	{ 0x1312, 0x1315 },
	{ 0x1318, 0x135a },
	{ 0x1380, 0x138f },
	{ 0x1401, 0x166c },
	{ 0x166f, 0x167f },
	{ 0x1681, 0x169a },
	{ 0x16a0, 0x16ea },
	{ 0x16f1, 0x16f8 },
	{ 0x1700, 0x170c },
	{ 0x170e, 0x1711 },
	{ 0x1720, 0x1731 },
	{ 0x1740, 0x1751 },
	{ 0x1760, 0x176c },
	{ 0x176e, 0x1770 },
	{ 0x1780, 0x17b3 },
	{ 0x17dc, 0x17dc },
	{ 0x1820, 0x1842 },
	{ 0x1844, 0x1877 },
	{ 0x1880, 0x1884 },
	{ 0x1887, 0x18a8 },
	{ 0x18aa, 0x18aa },
	{ 0x18b0, 0x18f5 },
	{ 0x1900, 0x191e },
	{ 0x1950, 0x196d },
	{ 0x1970, 0x1974 },
	{ 0x1980, 0x19ab },
	{ 0x19b0, 0x19c9 },
	{ 0x1a00, 0x1a16 },
	{ 0x1a20, 0x1a54 },
	{ 0x1b05, 0x1b33 },
	{ 0x1b45, 0x1b4b },
	{ 0x1b83, 0x1ba0 },
	{ 0x1bae, 0x1baf },
	{ 0x1bba, 0x1be5 },
	{ 0x1c00, 0x1c23 },
	{ 0x1c4d, 0x1c4f },
	{ 0x1c5a, 0x1c77 },
	{ 0x1ce9, 0x1cec },
	{ 0x1cee, 0x1cf1 },
	{ 0x1cf5, 0x1cf6 },
	{ 0x2135, 0x2138 },
	{ 0x2d30, 0x2d67 },
	{ 0x2d80, 0x2d96 },
	{ 0x2da0, 0x2da6 },
	{ 0x2da8, 0x2dae },
	{ 0x2db0, 0x2db6 },
	{ 0x2db8, 0x2dbe },
	{ 0x2dc0, 0x2dc6 },
	{ 0x2dc8, 0x2dce },
	{ 0x2dd0, 0x2dd6 },
	{ 0x2dd8, 0x2dde },
	{ 0x3006, 0x3006 },
	{ 0x303c, 0x303c },
	{ 0x3041, 0x3096 },
	{ 0x309f, 0x309f },
	{ 0x30a1, 0x30fa },
	{ 0x30ff, 0x30ff },
	{ 0x3105, 0x312d },
	{ 0x3131, 0x318e },
	{ 0x31a0, 0x31ba },
	{ 0x31f0, 0x31ff },
	{ 0x3400, 0x4db5 },
	{ 0x4e00, 0x9fd5 },
	{ 0xa000, 0xa014 },
	{ 0xa016, 0xa48c },
	{ 0xa4d0, 0xa4f7 },
	{ 0xa500, 0xa60b },
	{ 0xa610, 0xa61f },
	{ 0xa62a, 0xa62b },
	{ 0xa66e, 0xa66e },
	{ 0xa6a0, 0xa6e5 },
	{ 0xa78f, 0xa78f },
	{ 0xa7f7, 0xa7f7 },
	{ 0xa7fb, 0xa801 },
	{ 0xa803, 0xa805 },
	{ 0xa807, 0xa80a },
	{ 0xa80c, 0xa822 },
	{ 0xa840, 0xa873 },
	{ 0xa882, 0xa8b3 },
	{ 0xa8f2, 0xa8f7 },
	{ 0xa8fb, 0xa8fb },
	{ 0xa8fd, 0xa8fd },
	{ 0xa90a, 0xa925 },
	{ 0xa930, 0xa946 },
	{ 0xa960, 0xa97c },
	{ 0xa984, 0xa9b2 },
	{ 0xa9e0, 0xa9e4 },
	{ 0xa9e7, 0xa9ef },
	{ 0xa9fa, 0xa9fe },
	{ 0xaa00, 0xaa28 },
	{ 0xaa40, 0xaa42 },
	{ 0xaa44, 0xaa4b },
	{ 0xaa60, 0xaa6f },
	{ 0xaa71, 0xaa76 },
	{ 0xaa7a, 0xaa7a },
	{ 0xaa7e, 0xaaaf },
	{ 0xaab1, 0xaab1 },
	{ 0xaab5, 0xaab6 },
	{ 0xaab9, 0xaabd },
	{ 0xaac0, 0xaac0 },
	{ 0xaac2, 0xaac2 },
	{ 0xaadb, 0xaadc },
	{ 0xaae0, 0xaaea },
	{ 0xaaf2, 0xaaf2 },
	{ 0xab01, 0xab06 },
	{ 0xab09, 0xab0e },
	{ 0xab11, 0xab16 },
	{ 0xab20, 0xab26 },
	{ 0xab28, 0xab2e },
	{ 0xabc0, 0xabe2 },
	{ 0xac00, 0xd7a3 },
	{ 0xd7b0, 0xd7c6 },
	{ 0xd7cb, 0xd7fb },
	{ 0xf900, 0xfa6d },
	{ 0xfa70, 0xfad9 },
	{ 0xfb1d, 0xfb1d },
	{ 0xfb1f, 0xfb28 },
	{ 0xfb2a, 0xfb36 },
	{ 0xfb38, 0xfb3c },
	{ 0xfb3e, 0xfb3e },
	{ 0xfb40, 0xfb41 },
	{ 0xfb43, 0xfb44 },
	{ 0xfb46, 0xfbb1 },
	{ 0xfbd3, 0xfd3d },
	{ 0xfd50, 0xfd8f },
	{ 0xfd92, 0xfdc7 },
	{ 0xfdf0, 0xfdfb },
	{ 0xfe70, 0xfe74 },
	{ 0xfe76, 0xfefc },
	{ 0xff66, 0xff6f },
	{ 0xff71, 0xff9d },
	{ 0xffa0, 0xffbe },
	{ 0xffc2, 0xffc7 },
	{ 0xffca, 0xffcf },
	{ 0xffd2, 0xffd7 },
	{ 0xffda, 0xffdc },
	{ 0x10000, 0x1000b },
	{ 0x1000d, 0x10026 },
	{ 0x10028, 0x1003a },
	{ 0x1003c, 0x1003d },
	{ 0x1003f, 0x1004d },
	{ 0x10050, 0x1005d },
	{ 0x10080, 0x100fa },
	{ 0x10280, 0x1029c },
	{ 0x102a0, 0x102d0 },
	{ 0x10300, 0x1031f },
	{ 0x10330, 0x10340 },
	{ 0x10342, 0x10349 },
	{ 0x10350, 0x10375 },
	{ 0x10380, 0x1039d },
	{ 0x103a0, 0x103c3 },
	{ 0x103c8, 0x103cf },
	{ 0x10450, 0x1049d },
	{ 0x10500, 0x10527 },
	{ 0x10530, 0x10563 },
	{ 0x10600, 0x10736 },
	{ 0x10740, 0x10755 },
	{ 0x10760, 0x10767 },
	{ 0x10800, 0x10805 },
	{ 0x10808, 0x10808 },
	{ 0x1080a, 0x10835 },
	{ 0x10837, 0x10838 },
	{ 0x1083c, 0x1083c },
	{ 0x1083f, 0x10855 },
	{ 0x10860, 0x10876 },
	{ 0x10880, 0x1089e },
	{ 0x108e0, 0x108f2 },
	{ 0x108f4, 0x108f5 },
	{ 0x10900, 0x10915 },
	{ 0x10920, 0x10939 },
	{ 0x10980, 0x109b7 },
	{ 0x109be, 0x109bf },
	{ 0x10a00, 0x10a00 },
	{ 0x10a10, 0x10a13 },
	{ 0x10a15, 0x10a17 },
	{ 0x10a19, 0x10a33 },
	{ 0x10a60, 0x10a7c },
	{ 0x10a80, 0x10a9c },
	{ 0x10ac0, 0x10ac7 },
	{ 0x10ac9, 0x10ae4 },
	{ 0x10b00, 0x10b35 },
	{ 0x10b40, 0x10b55 },
	{ 0x10b60, 0x10b72 },
	{ 0x10b80, 0x10b91 },
	{ 0x10c00, 0x10c48 },
	{ 0x11003, 0x11037 },
	{ 0x11083, 0x110af },
	{ 0x110d0, 0x110e8 },
	{ 0x11103, 0x11126 },
	{ 0x11150, 0x11172 },
	{ 0x11176, 0x11176 },
	{ 0x11183, 0x111b2 },
	{ 0x111c1, 0x111c4 },
	{ 0x111da, 0x111da },
	{ 0x111dc, 0x111dc },
	{ 0x11200, 0x11211 },
	{ 0x11213, 0x1122b },
	{ 0x11280, 0x11286 },
	{ 0x11288, 0x11288 },
	{ 0x1128a, 0x1128d },
	{ 0x1128f, 0x1129d },
	{ 0x1129f, 0x112a8 },
	{ 0x112b0, 0x112de },
	{ 0x11305, 0x1130c },
	{ 0x1130f, 0x11310 },
	{ 0x11313, 0x11328 },
	{ 0x1132a, 0x11330 },
	{ 0x11332, 0x11333 },
	{ 0x11335, 0x11339 },
	{ 0x1133d, 0x1133d },
	{ 0x11350, 0x11350 },
	{ 0x1135d, 0x11361 },
	{ 0x11400, 0x11434 },
	{ 0x11447, 0x1144a },
	{ 0x11480, 0x114af },
	{ 0x114c4, 0x114c5 },
	{ 0x114c7, 0x114c7 },
	{ 0x11580, 0x115ae },
	{ 0x115d8, 0x115db },
	{ 0x11600, 0x1162f },
	{ 0x11644, 0x11644 },
	{ 0x11680, 0x116aa },
	{ 0x11700, 0x11719 },
	{ 0x118ff, 0x118ff },
	{ 0x11ac0, 0x11af8 },
	{ 0x11c00, 0x11c08 },
	{ 0x11c0a, 0x11c2e },
	{ 0x11c40, 0x11c40 },
	{ 0x11c72, 0x11c8f },
	{ 0x12000, 0x12399 },
	{ 0x12480, 0x12543 },
	{ 0x13000, 0x1342e },
	{ 0x14400, 0x14646 },
	{ 0x16800, 0x16a38 },
	{ 0x16a40, 0x16a5e },
	{ 0x16ad0, 0x16aed },
	{ 0x16b00, 0x16b2f },
	{ 0x16b63, 0x16b77 },
	{ 0x16b7d, 0x16b8f },
	{ 0x16f00, 0x16f44 },
	{ 0x16f50, 0x16f50 },
	{ 0x17000, 0x187ec },
	{ 0x18800, 0x18af2 },
	{ 0x1b000, 0x1b001 },
	{ 0x1bc00, 0x1bc6a },
	{ 0x1bc70, 0x1bc7c },
	{ 0x1bc80, 0x1bc88 },
	{ 0x1bc90, 0x1bc99 },
	{ 0x1e800, 0x1e8c4 },
	{ 0x1ee00, 0x1ee03 },
	{ 0x1ee05, 0x1ee1f },
	{ 0x1ee21, 0x1ee22 },
	{ 0x1ee24, 0x1ee24 },
	{ 0x1ee27, 0x1ee27 },
	{ 0x1ee29, 0x1ee32 },
	{ 0x1ee34, 0x1ee37 },
	{ 0x1ee39, 0x1ee39 },
	{ 0x1ee3b, 0x1ee3b },
	{ 0x1ee42, 0x1ee42 },
	{ 0x1ee47, 0x1ee47 },
	{ 0x1ee49, 0x1ee49 },
	{ 0x1ee4b, 0x1ee4b },
	{ 0x1ee4d, 0x1ee4f },
	{ 0x1ee51, 0x1ee52 },
	{ 0x1ee54, 0x1ee54 },
	{ 0x1ee57, 0x1ee57 },
	{ 0x1ee59, 0x1ee59 },
	{ 0x1ee5b, 0x1ee5b },
	{ 0x1ee5d, 0x1ee5d },
	{ 0x1ee5f, 0x1ee5f },
	{ 0x1ee61, 0x1ee62 },
	{ 0x1ee64, 0x1ee64 },
	{ 0x1ee67, 0x1ee6a },
	{ 0x1ee6c, 0x1ee72 },
	{ 0x1ee74, 0x1ee77 },
	{ 0x1ee79, 0x1ee7c },
	{ 0x1ee7e, 0x1ee7e },
	{ 0x1ee80, 0x1ee89 },
	{ 0x1ee8b, 0x1ee9b },
	{ 0x1eea1, 0x1eea3 },
	{ 0x1eea5, 0x1eea9 },
	{ 0x1eeab, 0x1eebb },
	{ 0x20000, 0x2a6d6 },
	{ 0x2a700, 0x2b734 },
	{ 0x2b740, 0x2b81d },
	{ 0x2b820, 0x2cea1 },
	{ 0x2f800, 0x2fa1d }
};

struct interval So_table[] = {
	{ 0xa6, 0xa6 },
	{ 0xa9, 0xa9 },
	{ 0xae, 0xae },
	{ 0xb0, 0xb0 },
	{ 0x482, 0x482 },
	{ 0x58d, 0x58e },
	{ 0x60e, 0x60f },
	{ 0x6de, 0x6de },
	{ 0x6e9, 0x6e9 },
	{ 0x6fd, 0x6fe },
	{ 0x7f6, 0x7f6 },
	{ 0x9fa, 0x9fa },
	{ 0xb70, 0xb70 },
	{ 0xbf3, 0xbf8 },
	{ 0xbfa, 0xbfa },
	{ 0xc7f, 0xc7f },
	{ 0xd4f, 0xd4f },
	{ 0xd79, 0xd79 },
	{ 0xf01, 0xf03 },
	{ 0xf13, 0xf13 },
	{ 0xf15, 0xf17 },
	{ 0xf1a, 0xf1f },
	{ 0xf34, 0xf34 },
	{ 0xf36, 0xf36 },
	{ 0xf38, 0xf38 },
	{ 0xfbe, 0xfc5 },
	{ 0xfc7, 0xfcc },
	{ 0xfce, 0xfcf },
	{ 0xfd5, 0xfd8 },
	{ 0x109e, 0x109f },
	{ 0x1390, 0x1399 },
	{ 0x1940, 0x1940 },
	{ 0x19de, 0x19ff },
	{ 0x1b61, 0x1b6a },
	{ 0x1b74, 0x1b7c },
	{ 0x2100, 0x2101 },
	{ 0x2103, 0x2106 },
	{ 0x2108, 0x2109 },
	{ 0x2114, 0x2114 },
	{ 0x2116, 0x2117 },
	{ 0x211e, 0x2123 },
	{ 0x2125, 0x2125 },
	{ 0x2127, 0x2127 },
	{ 0x2129, 0x2129 },
	{ 0x212e, 0x212e },
	{ 0x213a, 0x213b },
	{ 0x214a, 0x214a },
	{ 0x214c, 0x214d },
	{ 0x214f, 0x214f },
	{ 0x218a, 0x218b },
	{ 0x2195, 0x2199 },
	{ 0x219c, 0x219f },
	{ 0x21a1, 0x21a2 },
	{ 0x21a4, 0x21a5 },
	{ 0x21a7, 0x21ad },
	{ 0x21af, 0x21cd },
	{ 0x21d0, 0x21d1 },
	{ 0x21d3, 0x21d3 },
	{ 0x21d5, 0x21f3 },
	{ 0x2300, 0x2307 },
	{ 0x230c, 0x231f },
	{ 0x2322, 0x2328 },
	{ 0x232b, 0x237b },
	{ 0x237d, 0x239a },
	{ 0x23b4, 0x23db },
	{ 0x23e2, 0x23fe },
	{ 0x2400, 0x2426 },
	{ 0x2440, 0x244a },
	{ 0x249c, 0x24e9 },
	{ 0x2500, 0x25b6 },
	{ 0x25b8, 0x25c0 },
	{ 0x25c2, 0x25f7 },
	{ 0x2600, 0x266e },
	{ 0x2670, 0x2767 },
	{ 0x2794, 0x27bf },
	{ 0x2800, 0x28ff },
	{ 0x2b00, 0x2b2f },
	{ 0x2b45, 0x2b46 },
	{ 0x2b4d, 0x2b73 },
	{ 0x2b76, 0x2b95 },
	{ 0x2b98, 0x2bb9 },
	{ 0x2bbd, 0x2bc8 },
	{ 0x2bca, 0x2bd1 },
	{ 0x2bec, 0x2bef },
	{ 0x2ce5, 0x2cea },
	{ 0x2e80, 0x2e99 },
	{ 0x2e9b, 0x2ef3 },
	{ 0x2f00, 0x2fd5 },
	{ 0x2ff0, 0x2ffb },
	{ 0x3004, 0x3004 },
	{ 0x3012, 0x3013 },
	{ 0x3020, 0x3020 },
	{ 0x3036, 0x3037 },
	{ 0x303e, 0x303f },
	{ 0x3190, 0x3191 },
	{ 0x3196, 0x319f },
	{ 0x31c0, 0x31e3 },
	{ 0x3200, 0x321e },
	{ 0x322a, 0x3247 },
	{ 0x3250, 0x3250 },
	{ 0x3260, 0x327f },
	{ 0x328a, 0x32b0 },
	{ 0x32c0, 0x32fe },
	{ 0x3300, 0x33ff },
	{ 0x4dc0, 0x4dff },
	{ 0xa490, 0xa4c6 },
	{ 0xa828, 0xa82b },
	{ 0xa836, 0xa837 },
	{ 0xa839, 0xa839 },
	{ 0xaa77, 0xaa79 },
	{ 0xfdfd, 0xfdfd },
	{ 0xffe4, 0xffe4 },
	{ 0xffe8, 0xffe8 },
	{ 0xffed, 0xffee },
	{ 0xfffc, 0xfffd },
	{ 0x10137, 0x1013f },
	{ 0x10179, 0x10189 },
	{ 0x1018c, 0x1018e },
	{ 0x10190, 0x1019b },
	{ 0x101a0, 0x101a0 },
	{ 0x101d0, 0x101fc },
	{ 0x10877, 0x10878 },
	{ 0x10ac8, 0x10ac8 },
	{ 0x1173f, 0x1173f },
	{ 0x16b3c, 0x16b3f },
	{ 0x16b45, 0x16b45 },
	{ 0x1bc9c, 0x1bc9c },
	{ 0x1d000, 0x1d0f5 },
	{ 0x1d100, 0x1d126 },
	{ 0x1d129, 0x1d164 },
	{ 0x1d16a, 0x1d16c },
	{ 0x1d183, 0x1d184 },
	{ 0x1d18c, 0x1d1a9 },
	{ 0x1d1ae, 0x1d1e8 },
	{ 0x1d200, 0x1d241 },
	{ 0x1d245, 0x1d245 },
	{ 0x1d300, 0x1d356 },
	{ 0x1d800, 0x1d9ff },
	{ 0x1da37, 0x1da3a },
	{ 0x1da6d, 0x1da74 },
	{ 0x1da76, 0x1da83 },
	{ 0x1da85, 0x1da86 },
	{ 0x1f000, 0x1f02b },
	{ 0x1f030, 0x1f093 },
	{ 0x1f0a0, 0x1f0ae },
	{ 0x1f0b1, 0x1f0bf },
	{ 0x1f0c1, 0x1f0cf },
	{ 0x1f0d1, 0x1f0f5 },
	{ 0x1f110, 0x1f12e },
	{ 0x1f130, 0x1f16b },
	{ 0x1f170, 0x1f1ac },
	{ 0x1f1e6, 0x1f202 },
	{ 0x1f210, 0x1f23b },
	{ 0x1f240, 0x1f248 },
	{ 0x1f250, 0x1f251 },
	{ 0x1f300, 0x1f3fa },
	{ 0x1f400, 0x1f6d2 },
	{ 0x1f6e0, 0x1f6ec },
	{ 0x1f6f0, 0x1f6f6 },
	{ 0x1f700, 0x1f773 },
	{ 0x1f780, 0x1f7d4 },
	{ 0x1f800, 0x1f80b },
	{ 0x1f810, 0x1f847 },
	{ 0x1f850, 0x1f859 },
	{ 0x1f860, 0x1f887 },
	{ 0x1f890, 0x1f8ad },
	{ 0x1f910, 0x1f91e },
	{ 0x1f920, 0x1f927 },
	{ 0x1f930, 0x1f930 },
	{ 0x1f933, 0x1f93e },
	{ 0x1f940, 0x1f94b },
	{ 0x1f950, 0x1f95e },
	{ 0x1f980, 0x1f991 },
	{ 0x1f9c0, 0x1f9c0 }
};

struct interval Ll_table[] = {
	{ 0x61, 0x7a },
	{ 0xb5, 0xb5 },
	{ 0xdf, 0xf6 },
	{ 0xf8, 0xff },
	{ 0x101, 0x101 },
	{ 0x103, 0x103 },
	{ 0x105, 0x105 },
	{ 0x107, 0x107 },
	{ 0x109, 0x109 },
	{ 0x10b, 0x10b },
	{ 0x10d, 0x10d },
	{ 0x10f, 0x10f },
	{ 0x111, 0x111 },
	{ 0x113, 0x113 },
	{ 0x115, 0x115 },
	{ 0x117, 0x117 },
	{ 0x119, 0x119 },
	{ 0x11b, 0x11b },
	{ 0x11d, 0x11d },
	{ 0x11f, 0x11f },
	{ 0x121, 0x121 },
	{ 0x123, 0x123 },
	{ 0x125, 0x125 },
	{ 0x127, 0x127 },
	{ 0x129, 0x129 },
	{ 0x12b, 0x12b },
	{ 0x12d, 0x12d },
	{ 0x12f, 0x12f },
	{ 0x131, 0x131 },
	{ 0x133, 0x133 },
	{ 0x135, 0x135 },
	{ 0x137, 0x138 },
	{ 0x13a, 0x13a },
	{ 0x13c, 0x13c },
	{ 0x13e, 0x13e },
	{ 0x140, 0x140 },
	{ 0x142, 0x142 },
	{ 0x144, 0x144 },
	{ 0x146, 0x146 },
	{ 0x148, 0x149 },
	{ 0x14b, 0x14b },
	{ 0x14d, 0x14d },
	{ 0x14f, 0x14f },
	{ 0x151, 0x151 },
	{ 0x153, 0x153 },
	{ 0x155, 0x155 },
	{ 0x157, 0x157 },
	{ 0x159, 0x159 },
	{ 0x15b, 0x15b },
	{ 0x15d, 0x15d },
	{ 0x15f, 0x15f },
	{ 0x161, 0x161 },
	{ 0x163, 0x163 },
	{ 0x165, 0x165 },
	{ 0x167, 0x167 },
	{ 0x169, 0x169 },
	{ 0x16b, 0x16b },
	{ 0x16d, 0x16d },
	{ 0x16f, 0x16f },
	{ 0x171, 0x171 },
	{ 0x173, 0x173 },
	{ 0x175, 0x175 },
	{ 0x177, 0x177 },
	{ 0x17a, 0x17a },
	{ 0x17c, 0x17c },
	{ 0x17e, 0x180 },
	{ 0x183, 0x183 },
	{ 0x185, 0x185 },
	{ 0x188, 0x188 },
	{ 0x18c, 0x18d },
	{ 0x192, 0x192 },
	{ 0x195, 0x195 },
	{ 0x199, 0x19b },
	{ 0x19e, 0x19e },
	{ 0x1a1, 0x1a1 },
	{ 0x1a3, 0x1a3 },
	{ 0x1a5, 0x1a5 },
	{ 0x1a8, 0x1a8 },
	{ 0x1aa, 0x1ab },
	{ 0x1ad, 0x1ad },
	{ 0x1b0, 0x1b0 },
	{ 0x1b4, 0x1b4 },
	{ 0x1b6, 0x1b6 },
	{ 0x1b9, 0x1ba },
	{ 0x1bd, 0x1bf },
	{ 0x1c6, 0x1c6 },
	{ 0x1c9, 0x1c9 },
	{ 0x1cc, 0x1cc },
	{ 0x1ce, 0x1ce },
	{ 0x1d0, 0x1d0 },
	{ 0x1d2, 0x1d2 },
	{ 0x1d4, 0x1d4 },
	{ 0x1d6, 0x1d6 },
	{ 0x1d8, 0x1d8 },
	{ 0x1da, 0x1da },
	{ 0x1dc, 0x1dd },
	{ 0x1df, 0x1df },
	{ 0x1e1, 0x1e1 },
	{ 0x1e3, 0x1e3 },
	{ 0x1e5, 0x1e5 },
	{ 0x1e7, 0x1e7 },
	{ 0x1e9, 0x1e9 },
	{ 0x1eb, 0x1eb },
	{ 0x1ed, 0x1ed },
	{ 0x1ef, 0x1f0 },
	{ 0x1f3, 0x1f3 },
	{ 0x1f5, 0x1f5 },
	{ 0x1f9, 0x1f9 },
	{ 0x1fb, 0x1fb },
	{ 0x1fd, 0x1fd },
	{ 0x1ff, 0x1ff },
	{ 0x201, 0x201 },
	{ 0x203, 0x203 },
	{ 0x205, 0x205 },
	{ 0x207, 0x207 },
	{ 0x209, 0x209 },
	{ 0x20b, 0x20b },
	{ 0x20d, 0x20d },
	{ 0x20f, 0x20f },
	{ 0x211, 0x211 },
	{ 0x213, 0x213 },
	{ 0x215, 0x215 },
	{ 0x217, 0x217 },
	{ 0x219, 0x219 },
	{ 0x21b, 0x21b },
	{ 0x21d, 0x21d },
	{ 0x21f, 0x21f },
	{ 0x221, 0x221 },
	{ 0x223, 0x223 },
	{ 0x225, 0x225 },
	{ 0x227, 0x227 },
	{ 0x229, 0x229 },
	{ 0x22b, 0x22b },
	{ 0x22d, 0x22d },
	{ 0x22f, 0x22f },
	{ 0x231, 0x231 },
	{ 0x233, 0x239 },
	{ 0x23c, 0x23c },
	{ 0x23f, 0x240 },
	{ 0x242, 0x242 },
	{ 0x247, 0x247 },
	{ 0x249, 0x249 },
	{ 0x24b, 0x24b },
	{ 0x24d, 0x24d },
	{ 0x24f, 0x293 },
	{ 0x295, 0x2af },
	{ 0x371, 0x371 },
	{ 0x373, 0x373 },
	{ 0x377, 0x377 },
	{ 0x37b, 0x37d },
	{ 0x390, 0x390 },
	{ 0x3ac, 0x3ce },
	{ 0x3d0, 0x3d1 },
	{ 0x3d5, 0x3d7 },
	{ 0x3d9, 0x3d9 },
	{ 0x3db, 0x3db },
	{ 0x3dd, 0x3dd },
	{ 0x3df, 0x3df },
	{ 0x3e1, 0x3e1 },
	{ 0x3e3, 0x3e3 },
	{ 0x3e5, 0x3e5 },
	{ 0x3e7, 0x3e7 },
	{ 0x3e9, 0x3e9 },
	{ 0x3eb, 0x3eb },
	{ 0x3ed, 0x3ed },
	{ 0x3ef, 0x3f3 },
	{ 0x3f5, 0x3f5 },
	{ 0x3f8, 0x3f8 },
	{ 0x3fb, 0x3fc },
	{ 0x430, 0x45f },
	{ 0x461, 0x461 },
	{ 0x463, 0x463 },
	{ 0x465, 0x465 },
	{ 0x467, 0x467 },
	{ 0x469, 0x469 },
	{ 0x46b, 0x46b },
	{ 0x46d, 0x46d },
	{ 0x46f, 0x46f },
	{ 0x471, 0x471 },
	{ 0x473, 0x473 },
	{ 0x475, 0x475 },
	{ 0x477, 0x477 },
	{ 0x479, 0x479 },
	{ 0x47b, 0x47b },
	{ 0x47d, 0x47d },
	{ 0x47f, 0x47f },
	{ 0x481, 0x481 },
	{ 0x48b, 0x48b },
	{ 0x48d, 0x48d },
	{ 0x48f, 0x48f },
	{ 0x491, 0x491 },
	{ 0x493, 0x493 },
	{ 0x495, 0x495 },
	{ 0x497, 0x497 },
	{ 0x499, 0x499 },
	{ 0x49b, 0x49b },
	{ 0x49d, 0x49d },
	{ 0x49f, 0x49f },
	{ 0x4a1, 0x4a1 },
	{ 0x4a3, 0x4a3 },
	{ 0x4a5, 0x4a5 },
	{ 0x4a7, 0x4a7 },
	{ 0x4a9, 0x4a9 },
	{ 0x4ab, 0x4ab },
	{ 0x4ad, 0x4ad },
	{ 0x4af, 0x4af },
	{ 0x4b1, 0x4b1 },
	{ 0x4b3, 0x4b3 },
	{ 0x4b5, 0x4b5 },
	{ 0x4b7, 0x4b7 },
	{ 0x4b9, 0x4b9 },
	{ 0x4bb, 0x4bb },
	{ 0x4bd, 0x4bd },
	{ 0x4bf, 0x4bf },
	{ 0x4c2, 0x4c2 },
	{ 0x4c4, 0x4c4 },
	{ 0x4c6, 0x4c6 },
	{ 0x4c8, 0x4c8 },
	{ 0x4ca, 0x4ca },
	{ 0x4cc, 0x4cc },
	{ 0x4ce, 0x4cf },
	{ 0x4d1, 0x4d1 },
	{ 0x4d3, 0x4d3 },
	{ 0x4d5, 0x4d5 },
	{ 0x4d7, 0x4d7 },
	{ 0x4d9, 0x4d9 },
	{ 0x4db, 0x4db },
	{ 0x4dd, 0x4dd },
	{ 0x4df, 0x4df },
	{ 0x4e1, 0x4e1 },
	{ 0x4e3, 0x4e3 },
	{ 0x4e5, 0x4e5 },
	{ 0x4e7, 0x4e7 },
	{ 0x4e9, 0x4e9 },
	{ 0x4eb, 0x4eb },
	{ 0x4ed, 0x4ed },
	{ 0x4ef, 0x4ef },
	{ 0x4f1, 0x4f1 },
	{ 0x4f3, 0x4f3 },
	{ 0x4f5, 0x4f5 },
	{ 0x4f7, 0x4f7 },
	{ 0x4f9, 0x4f9 },
	{ 0x4fb, 0x4fb },
	{ 0x4fd, 0x4fd },
	{ 0x4ff, 0x4ff },
	{ 0x501, 0x501 },
	{ 0x503, 0x503 },
	{ 0x505, 0x505 },
	{ 0x507, 0x507 },
	{ 0x509, 0x509 },
	{ 0x50b, 0x50b },
	{ 0x50d, 0x50d },
	{ 0x50f, 0x50f },
	{ 0x511, 0x511 },
	{ 0x513, 0x513 },
	{ 0x515, 0x515 },
	{ 0x517, 0x517 },
	{ 0x519, 0x519 },
	{ 0x51b, 0x51b },
	{ 0x51d, 0x51d },
	{ 0x51f, 0x51f },
	{ 0x521, 0x521 },
	{ 0x523, 0x523 },
	{ 0x525, 0x525 },
	{ 0x527, 0x527 },
	{ 0x529, 0x529 },
	{ 0x52b, 0x52b },
	{ 0x52d, 0x52d },
	{ 0x52f, 0x52f },
	{ 0x561, 0x587 },
	{ 0x13f8, 0x13fd },
	{ 0x1c80, 0x1c88 },
	{ 0x1d00, 0x1d2b },
	{ 0x1d6b, 0x1d77 },
	{ 0x1d79, 0x1d9a },
	{ 0x1e01, 0x1e01 },
	{ 0x1e03, 0x1e03 },
	{ 0x1e05, 0x1e05 },
	{ 0x1e07, 0x1e07 },
	{ 0x1e09, 0x1e09 },
	{ 0x1e0b, 0x1e0b },
	{ 0x1e0d, 0x1e0d },
	{ 0x1e0f, 0x1e0f },
	{ 0x1e11, 0x1e11 },
	{ 0x1e13, 0x1e13 },
	{ 0x1e15, 0x1e15 },
	{ 0x1e17, 0x1e17 },
	{ 0x1e19, 0x1e19 },
	{ 0x1e1b, 0x1e1b },
	{ 0x1e1d, 0x1e1d },
	{ 0x1e1f, 0x1e1f },
	{ 0x1e21, 0x1e21 },
	{ 0x1e23, 0x1e23 },
	{ 0x1e25, 0x1e25 },
	{ 0x1e27, 0x1e27 },
	{ 0x1e29, 0x1e29 },
	{ 0x1e2b, 0x1e2b },
	{ 0x1e2d, 0x1e2d },
	{ 0x1e2f, 0x1e2f },
	{ 0x1e31, 0x1e31 },
	{ 0x1e33, 0x1e33 },
	{ 0x1e35, 0x1e35 },
	{ 0x1e37, 0x1e37 },
	{ 0x1e39, 0x1e39 },
	{ 0x1e3b, 0x1e3b },
	{ 0x1e3d, 0x1e3d },
	{ 0x1e3f, 0x1e3f },
	{ 0x1e41, 0x1e41 },
	{ 0x1e43, 0x1e43 },
	{ 0x1e45, 0x1e45 },
	{ 0x1e47, 0x1e47 },
	{ 0x1e49, 0x1e49 },
	{ 0x1e4b, 0x1e4b },
	{ 0x1e4d, 0x1e4d },
	{ 0x1e4f, 0x1e4f },
	{ 0x1e51, 0x1e51 },
	{ 0x1e53, 0x1e53 },
	{ 0x1e55, 0x1e55 },
	{ 0x1e57, 0x1e57 },
	{ 0x1e59, 0x1e59 },
	{ 0x1e5b, 0x1e5b },
	{ 0x1e5d, 0x1e5d },
	{ 0x1e5f, 0x1e5f },
	{ 0x1e61, 0x1e61 },
	{ 0x1e63, 0x1e63 },
	{ 0x1e65, 0x1e65 },
	{ 0x1e67, 0x1e67 },
	{ 0x1e69, 0x1e69 },
	{ 0x1e6b, 0x1e6b },
	{ 0x1e6d, 0x1e6d },
	{ 0x1e6f, 0x1e6f },
	{ 0x1e71, 0x1e71 },
	{ 0x1e73, 0x1e73 },
	{ 0x1e75, 0x1e75 },
	{ 0x1e77, 0x1e77 },
	{ 0x1e79, 0x1e79 },
	{ 0x1e7b, 0x1e7b },
	{ 0x1e7d, 0x1e7d },
	{ 0x1e7f, 0x1e7f },
	{ 0x1e81, 0x1e81 },
	{ 0x1e83, 0x1e83 },
	{ 0x1e85, 0x1e85 },
	{ 0x1e87, 0x1e87 },
	{ 0x1e89, 0x1e89 },
	{ 0x1e8b, 0x1e8b },
	{ 0x1e8d, 0x1e8d },
	{ 0x1e8f, 0x1e8f },
	{ 0x1e91, 0x1e91 },
	{ 0x1e93, 0x1e93 },
	{ 0x1e95, 0x1e9d },
	{ 0x1e9f, 0x1e9f },
	{ 0x1ea1, 0x1ea1 },
	{ 0x1ea3, 0x1ea3 },
	{ 0x1ea5, 0x1ea5 },
	{ 0x1ea7, 0x1ea7 },
	{ 0x1ea9, 0x1ea9 },
	{ 0x1eab, 0x1eab },
	{ 0x1ead, 0x1ead },
	{ 0x1eaf, 0x1eaf },
	{ 0x1eb1, 0x1eb1 },
	{ 0x1eb3, 0x1eb3 },
	{ 0x1eb5, 0x1eb5 },
	{ 0x1eb7, 0x1eb7 },
	{ 0x1eb9, 0x1eb9 },
	{ 0x1ebb, 0x1ebb },
	{ 0x1ebd, 0x1ebd },
	{ 0x1ebf, 0x1ebf },
	{ 0x1ec1, 0x1ec1 },
	{ 0x1ec3, 0x1ec3 },
	{ 0x1ec5, 0x1ec5 },
	{ 0x1ec7, 0x1ec7 },
	{ 0x1ec9, 0x1ec9 },
	{ 0x1ecb, 0x1ecb },
	{ 0x1ecd, 0x1ecd },
	{ 0x1ecf, 0x1ecf },
	{ 0x1ed1, 0x1ed1 },
	{ 0x1ed3, 0x1ed3 },
	{ 0x1ed5, 0x1ed5 },
	{ 0x1ed7, 0x1ed7 },
	{ 0x1ed9, 0x1ed9 },
	{ 0x1edb, 0x1edb },
	{ 0x1edd, 0x1edd },
	{ 0x1edf, 0x1edf },
	{ 0x1ee1, 0x1ee1 },
	{ 0x1ee3, 0x1ee3 },
	{ 0x1ee5, 0x1ee5 },
	{ 0x1ee7, 0x1ee7 },
	{ 0x1ee9, 0x1ee9 },
	{ 0x1eeb, 0x1eeb },
	{ 0x1eed, 0x1eed },
	{ 0x1eef, 0x1eef },
	{ 0x1ef1, 0x1ef1 },
	{ 0x1ef3, 0x1ef3 },
	{ 0x1ef5, 0x1ef5 },
	{ 0x1ef7, 0x1ef7 },
	{ 0x1ef9, 0x1ef9 },
	{ 0x1efb, 0x1efb },
	{ 0x1efd, 0x1efd },
	{ 0x1eff, 0x1f07 },
	{ 0x1f10, 0x1f15 },
	{ 0x1f20, 0x1f27 },
	{ 0x1f30, 0x1f37 },
	{ 0x1f40, 0x1f45 },
	{ 0x1f50, 0x1f57 },
	{ 0x1f60, 0x1f67 },
	{ 0x1f70, 0x1f7d },
	{ 0x1f80, 0x1f87 },
	{ 0x1f90, 0x1f97 },
	{ 0x1fa0, 0x1fa7 },
	{ 0x1fb0, 0x1fb4 },
	{ 0x1fb6, 0x1fb7 },
	{ 0x1fbe, 0x1fbe },
	{ 0x1fc2, 0x1fc4 },
	{ 0x1fc6, 0x1fc7 },
	{ 0x1fd0, 0x1fd3 },
	{ 0x1fd6, 0x1fd7 },
	{ 0x1fe0, 0x1fe7 },
	{ 0x1ff2, 0x1ff4 },
	{ 0x1ff6, 0x1ff7 },
	{ 0x210a, 0x210a },
	{ 0x210e, 0x210f },
	{ 0x2113, 0x2113 },
	{ 0x212f, 0x212f },
	{ 0x2134, 0x2134 },
	{ 0x2139, 0x2139 },
	{ 0x213c, 0x213d },
	{ 0x2146, 0x2149 },
	{ 0x214e, 0x214e },
	{ 0x2184, 0x2184 },
	{ 0x2c30, 0x2c5e },
	{ 0x2c61, 0x2c61 },
	{ 0x2c65, 0x2c66 },
	{ 0x2c68, 0x2c68 },
	{ 0x2c6a, 0x2c6a },
	{ 0x2c6c, 0x2c6c },
	{ 0x2c71, 0x2c71 },
	{ 0x2c73, 0x2c74 },
	{ 0x2c76, 0x2c7b },
	{ 0x2c81, 0x2c81 },
	{ 0x2c83, 0x2c83 },
	{ 0x2c85, 0x2c85 },
	{ 0x2c87, 0x2c87 },
	{ 0x2c89, 0x2c89 },
	{ 0x2c8b, 0x2c8b },
	{ 0x2c8d, 0x2c8d },
	{ 0x2c8f, 0x2c8f },
	{ 0x2c91, 0x2c91 },
	{ 0x2c93, 0x2c93 },
	{ 0x2c95, 0x2c95 },
	{ 0x2c97, 0x2c97 },
	{ 0x2c99, 0x2c99 },
	{ 0x2c9b, 0x2c9b },
	{ 0x2c9d, 0x2c9d },
	{ 0x2c9f, 0x2c9f },
	{ 0x2ca1, 0x2ca1 },
	{ 0x2ca3, 0x2ca3 },
	{ 0x2ca5, 0x2ca5 },
	{ 0x2ca7, 0x2ca7 },
	{ 0x2ca9, 0x2ca9 },
	{ 0x2cab, 0x2cab },
	{ 0x2cad, 0x2cad },
	{ 0x2caf, 0x2caf },
	{ 0x2cb1, 0x2cb1 },
	{ 0x2cb3, 0x2cb3 },
	{ 0x2cb5, 0x2cb5 },
	{ 0x2cb7, 0x2cb7 },
	{ 0x2cb9, 0x2cb9 },
	{ 0x2cbb, 0x2cbb },
	{ 0x2cbd, 0x2cbd },
	{ 0x2cbf, 0x2cbf },
	{ 0x2cc1, 0x2cc1 },
	{ 0x2cc3, 0x2cc3 },
	{ 0x2cc5, 0x2cc5 },
	{ 0x2cc7, 0x2cc7 },
	{ 0x2cc9, 0x2cc9 },
	{ 0x2ccb, 0x2ccb },
	{ 0x2ccd, 0x2ccd },
	{ 0x2ccf, 0x2ccf },
	{ 0x2cd1, 0x2cd1 },
	{ 0x2cd3, 0x2cd3 },
	{ 0x2cd5, 0x2cd5 },
	{ 0x2cd7, 0x2cd7 },
	{ 0x2cd9, 0x2cd9 },
	{ 0x2cdb, 0x2cdb },
	{ 0x2cdd, 0x2cdd },
	{ 0x2cdf, 0x2cdf },
	{ 0x2ce1, 0x2ce1 },
	{ 0x2ce3, 0x2ce4 },
	{ 0x2cec, 0x2cec },
	{ 0x2cee, 0x2cee },
	{ 0x2cf3, 0x2cf3 },
	{ 0x2d00, 0x2d25 },
	{ 0x2d27, 0x2d27 },
	{ 0x2d2d, 0x2d2d },
	{ 0xa641, 0xa641 },
	{ 0xa643, 0xa643 },
	{ 0xa645, 0xa645 },
	{ 0xa647, 0xa647 },
	{ 0xa649, 0xa649 },
	{ 0xa64b, 0xa64b },
	{ 0xa64d, 0xa64d },
	{ 0xa64f, 0xa64f },
	{ 0xa651, 0xa651 },
	{ 0xa653, 0xa653 },
	{ 0xa655, 0xa655 },
	{ 0xa657, 0xa657 },
	{ 0xa659, 0xa659 },
	{ 0xa65b, 0xa65b },
	{ 0xa65d, 0xa65d },
	{ 0xa65f, 0xa65f },
	{ 0xa661, 0xa661 },
	{ 0xa663, 0xa663 },
	{ 0xa665, 0xa665 },
	{ 0xa667, 0xa667 },
	{ 0xa669, 0xa669 },
	{ 0xa66b, 0xa66b },
	{ 0xa66d, 0xa66d },
	{ 0xa681, 0xa681 },
	{ 0xa683, 0xa683 },
	{ 0xa685, 0xa685 },
	{ 0xa687, 0xa687 },
	{ 0xa689, 0xa689 },
	{ 0xa68b, 0xa68b },
	{ 0xa68d, 0xa68d },
	{ 0xa68f, 0xa68f },
	{ 0xa691, 0xa691 },
	{ 0xa693, 0xa693 },
	{ 0xa695, 0xa695 },
	{ 0xa697, 0xa697 },
	{ 0xa699, 0xa699 },
	{ 0xa69b, 0xa69b },
	{ 0xa723, 0xa723 },
	{ 0xa725, 0xa725 },
	{ 0xa727, 0xa727 },
	{ 0xa729, 0xa729 },
	{ 0xa72b, 0xa72b },
	{ 0xa72d, 0xa72d },
	{ 0xa72f, 0xa731 },
	{ 0xa733, 0xa733 },
	{ 0xa735, 0xa735 },
	{ 0xa737, 0xa737 },
	{ 0xa739, 0xa739 },
	{ 0xa73b, 0xa73b },
	{ 0xa73d, 0xa73d },
	{ 0xa73f, 0xa73f },
	{ 0xa741, 0xa741 },
	{ 0xa743, 0xa743 },
	{ 0xa745, 0xa745 },
	{ 0xa747, 0xa747 },
	{ 0xa749, 0xa749 },
	{ 0xa74b, 0xa74b },
	{ 0xa74d, 0xa74d },
	{ 0xa74f, 0xa74f },
	{ 0xa751, 0xa751 },
	{ 0xa753, 0xa753 },
	{ 0xa755, 0xa755 },
	{ 0xa757, 0xa757 },
	{ 0xa759, 0xa759 },
	{ 0xa75b, 0xa75b },
	{ 0xa75d, 0xa75d },
	{ 0xa75f, 0xa75f },
	{ 0xa761, 0xa761 },
	{ 0xa763, 0xa763 },
	{ 0xa765, 0xa765 },
	{ 0xa767, 0xa767 },
	{ 0xa769, 0xa769 },
	{ 0xa76b, 0xa76b },
	{ 0xa76d, 0xa76d },
	{ 0xa76f, 0xa76f },
	{ 0xa771, 0xa778 },
	{ 0xa77a, 0xa77a },
	{ 0xa77c, 0xa77c },
	{ 0xa77f, 0xa77f },
	{ 0xa781, 0xa781 },
	{ 0xa783, 0xa783 },
	{ 0xa785, 0xa785 },
	{ 0xa787, 0xa787 },
	{ 0xa78c, 0xa78c },
	{ 0xa78e, 0xa78e },
	{ 0xa791, 0xa791 },
	{ 0xa793, 0xa795 },
	{ 0xa797, 0xa797 },
	{ 0xa799, 0xa799 },
	{ 0xa79b, 0xa79b },
	{ 0xa79d, 0xa79d },
	{ 0xa79f, 0xa79f },
	{ 0xa7a1, 0xa7a1 },
	{ 0xa7a3, 0xa7a3 },
	{ 0xa7a5, 0xa7a5 },
	{ 0xa7a7, 0xa7a7 },
	{ 0xa7a9, 0xa7a9 },
	{ 0xa7b5, 0xa7b5 },
	{ 0xa7b7, 0xa7b7 },
	{ 0xa7fa, 0xa7fa },
	{ 0xab30, 0xab5a },
	{ 0xab60, 0xab65 },
	{ 0xab70, 0xabbf },
	{ 0xfb00, 0xfb06 },
	{ 0xfb13, 0xfb17 },
	{ 0xff41, 0xff5a },
	{ 0x10428, 0x1044f },
	{ 0x104d8, 0x104fb },
	{ 0x10cc0, 0x10cf2 },
	{ 0x118c0, 0x118df },
	{ 0x1d41a, 0x1d433 },
	{ 0x1d44e, 0x1d454 },
	{ 0x1d456, 0x1d467 },
	{ 0x1d482, 0x1d49b },
	{ 0x1d4b6, 0x1d4b9 },
	{ 0x1d4bb, 0x1d4bb },
	{ 0x1d4bd, 0x1d4c3 },
	{ 0x1d4c5, 0x1d4cf },
	{ 0x1d4ea, 0x1d503 },
	{ 0x1d51e, 0x1d537 },
	{ 0x1d552, 0x1d56b },
	{ 0x1d586, 0x1d59f },
	{ 0x1d5ba, 0x1d5d3 },
	{ 0x1d5ee, 0x1d607 },
	{ 0x1d622, 0x1d63b },
	{ 0x1d656, 0x1d66f },
	{ 0x1d68a, 0x1d6a5 },
	{ 0x1d6c2, 0x1d6da },
	{ 0x1d6dc, 0x1d6e1 },
	{ 0x1d6fc, 0x1d714 },
	{ 0x1d716, 0x1d71b },
	{ 0x1d736, 0x1d74e },
	{ 0x1d750, 0x1d755 },
	{ 0x1d770, 0x1d788 },
	{ 0x1d78a, 0x1d78f },
	{ 0x1d7aa, 0x1d7c2 },
	{ 0x1d7c4, 0x1d7c9 },
	{ 0x1d7cb, 0x1d7cb },
	{ 0x1e922, 0x1e943 }
};

struct interval Pc_table[] = {
	{ 0x5f, 0x5f },
	{ 0x203f, 0x2040 },
	{ 0x2054, 0x2054 },
	{ 0xfe33, 0xfe34 },
	{ 0xfe4d, 0xfe4f },
	{ 0xff3f, 0xff3f }
};

struct interval Sk_table[] = {
	{ 0x5e, 0x5e },
	{ 0x60, 0x60 },
	{ 0xa8, 0xa8 },
	{ 0xaf, 0xaf },
	{ 0xb4, 0xb4 },
	{ 0xb8, 0xb8 },
	{ 0x2c2, 0x2c5 },
	{ 0x2d2, 0x2df },
	{ 0x2e5, 0x2eb },
	{ 0x2ed, 0x2ed },
	{ 0x2ef, 0x2ff },
	{ 0x375, 0x375 },
	{ 0x384, 0x385 },
	{ 0x1fbd, 0x1fbd },
	{ 0x1fbf, 0x1fc1 },
	{ 0x1fcd, 0x1fcf },
	{ 0x1fdd, 0x1fdf },
	{ 0x1fed, 0x1fef },
	{ 0x1ffd, 0x1ffe },
	{ 0x309b, 0x309c },
	{ 0xa700, 0xa716 },
	{ 0xa720, 0xa721 },
	{ 0xa789, 0xa78a },
	{ 0xab5b, 0xab5b },
	{ 0xfbb2, 0xfbc1 },
	{ 0xff3e, 0xff3e },
	{ 0xff40, 0xff40 },
	{ 0xffe3, 0xffe3 },
	{ 0x1f3fb, 0x1f3ff }
};

struct interval Lu_table[] = {
	{ 0x41, 0x5a },
	{ 0xc0, 0xd6 },
	{ 0xd8, 0xde },
	{ 0x100, 0x100 },
	{ 0x102, 0x102 },
	{ 0x104, 0x104 },
	{ 0x106, 0x106 },
	{ 0x108, 0x108 },
	{ 0x10a, 0x10a },
	{ 0x10c, 0x10c },
	{ 0x10e, 0x10e },
	{ 0x110, 0x110 },
	{ 0x112, 0x112 },
	{ 0x114, 0x114 },
	{ 0x116, 0x116 },
	{ 0x118, 0x118 },
	{ 0x11a, 0x11a },
	{ 0x11c, 0x11c },
	{ 0x11e, 0x11e },
	{ 0x120, 0x120 },
	{ 0x122, 0x122 },
	{ 0x124, 0x124 },
	{ 0x126, 0x126 },
	{ 0x128, 0x128 },
	{ 0x12a, 0x12a },
	{ 0x12c, 0x12c },
	{ 0x12e, 0x12e },
	{ 0x130, 0x130 },
	{ 0x132, 0x132 },
	{ 0x134, 0x134 },
	{ 0x136, 0x136 },
	{ 0x139, 0x139 },
	{ 0x13b, 0x13b },
	{ 0x13d, 0x13d },
	{ 0x13f, 0x13f },
	{ 0x141, 0x141 },
	{ 0x143, 0x143 },
	{ 0x145, 0x145 },
	{ 0x147, 0x147 },
	{ 0x14a, 0x14a },
	{ 0x14c, 0x14c },
	{ 0x14e, 0x14e },
	{ 0x150, 0x150 },
	{ 0x152, 0x152 },
	{ 0x154, 0x154 },
	{ 0x156, 0x156 },
	{ 0x158, 0x158 },
	{ 0x15a, 0x15a },
	{ 0x15c, 0x15c },
	{ 0x15e, 0x15e },
	{ 0x160, 0x160 },
	{ 0x162, 0x162 },
	{ 0x164, 0x164 },
	{ 0x166, 0x166 },
	{ 0x168, 0x168 },
	{ 0x16a, 0x16a },
	{ 0x16c, 0x16c },
	{ 0x16e, 0x16e },
	{ 0x170, 0x170 },
	{ 0x172, 0x172 },
	{ 0x174, 0x174 },
	{ 0x176, 0x176 },
	{ 0x178, 0x179 },
	{ 0x17b, 0x17b },
	{ 0x17d, 0x17d },
	{ 0x181, 0x182 },
	{ 0x184, 0x184 },
	{ 0x186, 0x187 },
	{ 0x189, 0x18b },
	{ 0x18e, 0x191 },
	{ 0x193, 0x194 },
	{ 0x196, 0x198 },
	{ 0x19c, 0x19d },
	{ 0x19f, 0x1a0 },
	{ 0x1a2, 0x1a2 },
	{ 0x1a4, 0x1a4 },
	{ 0x1a6, 0x1a7 },
	{ 0x1a9, 0x1a9 },
	{ 0x1ac, 0x1ac },
	{ 0x1ae, 0x1af },
	{ 0x1b1, 0x1b3 },
	{ 0x1b5, 0x1b5 },
	{ 0x1b7, 0x1b8 },
	{ 0x1bc, 0x1bc },
	{ 0x1c4, 0x1c4 },
	{ 0x1c7, 0x1c7 },
	{ 0x1ca, 0x1ca },
	{ 0x1cd, 0x1cd },
	{ 0x1cf, 0x1cf },
	{ 0x1d1, 0x1d1 },
	{ 0x1d3, 0x1d3 },
	{ 0x1d5, 0x1d5 },
	{ 0x1d7, 0x1d7 },
	{ 0x1d9, 0x1d9 },
	{ 0x1db, 0x1db },
	{ 0x1de, 0x1de },
	{ 0x1e0, 0x1e0 },
	{ 0x1e2, 0x1e2 },
	{ 0x1e4, 0x1e4 },
	{ 0x1e6, 0x1e6 },
	{ 0x1e8, 0x1e8 },
	{ 0x1ea, 0x1ea },
	{ 0x1ec, 0x1ec },
	{ 0x1ee, 0x1ee },
	{ 0x1f1, 0x1f1 },
	{ 0x1f4, 0x1f4 },
	{ 0x1f6, 0x1f8 },
	{ 0x1fa, 0x1fa },
	{ 0x1fc, 0x1fc },
	{ 0x1fe, 0x1fe },
	{ 0x200, 0x200 },
	{ 0x202, 0x202 },
	{ 0x204, 0x204 },
	{ 0x206, 0x206 },
	{ 0x208, 0x208 },
	{ 0x20a, 0x20a },
	{ 0x20c, 0x20c },
	{ 0x20e, 0x20e },
	{ 0x210, 0x210 },
	{ 0x212, 0x212 },
	{ 0x214, 0x214 },
	{ 0x216, 0x216 },
	{ 0x218, 0x218 },
	{ 0x21a, 0x21a },
	{ 0x21c, 0x21c },
	{ 0x21e, 0x21e },
	{ 0x220, 0x220 },
	{ 0x222, 0x222 },
	{ 0x224, 0x224 },
	{ 0x226, 0x226 },
	{ 0x228, 0x228 },
	{ 0x22a, 0x22a },
	{ 0x22c, 0x22c },
	{ 0x22e, 0x22e },
	{ 0x230, 0x230 },
	{ 0x232, 0x232 },
	{ 0x23a, 0x23b },
	{ 0x23d, 0x23e },
	{ 0x241, 0x241 },
	{ 0x243, 0x246 },
	{ 0x248, 0x248 },
	{ 0x24a, 0x24a },
	{ 0x24c, 0x24c },
	{ 0x24e, 0x24e },
	{ 0x370, 0x370 },
	{ 0x372, 0x372 },
	{ 0x376, 0x376 },
	{ 0x37f, 0x37f },
	{ 0x386, 0x386 },
	{ 0x388, 0x38a },
	{ 0x38c, 0x38c },
	{ 0x38e, 0x38f },
	{ 0x391, 0x3a1 },
	{ 0x3a3, 0x3ab },
	{ 0x3cf, 0x3cf },
	{ 0x3d2, 0x3d4 },
	{ 0x3d8, 0x3d8 },
	{ 0x3da, 0x3da },
	{ 0x3dc, 0x3dc },
	{ 0x3de, 0x3de },
	{ 0x3e0, 0x3e0 },
	{ 0x3e2, 0x3e2 },
	{ 0x3e4, 0x3e4 },
	{ 0x3e6, 0x3e6 },
	{ 0x3e8, 0x3e8 },
	{ 0x3ea, 0x3ea },
	{ 0x3ec, 0x3ec },
	{ 0x3ee, 0x3ee },
	{ 0x3f4, 0x3f4 },
	{ 0x3f7, 0x3f7 },
	{ 0x3f9, 0x3fa },
	{ 0x3fd, 0x42f },
	{ 0x460, 0x460 },
	{ 0x462, 0x462 },
	{ 0x464, 0x464 },
	{ 0x466, 0x466 },
	{ 0x468, 0x468 },
	{ 0x46a, 0x46a },
	{ 0x46c, 0x46c },
	{ 0x46e, 0x46e },
	{ 0x470, 0x470 },
	{ 0x472, 0x472 },
	{ 0x474, 0x474 },
	{ 0x476, 0x476 },
	{ 0x478, 0x478 },
	{ 0x47a, 0x47a },
	{ 0x47c, 0x47c },
	{ 0x47e, 0x47e },
	{ 0x480, 0x480 },
	{ 0x48a, 0x48a },
	{ 0x48c, 0x48c },
	{ 0x48e, 0x48e },
	{ 0x490, 0x490 },
	{ 0x492, 0x492 },
	{ 0x494, 0x494 },
	{ 0x496, 0x496 },
	{ 0x498, 0x498 },
	{ 0x49a, 0x49a },
	{ 0x49c, 0x49c },
	{ 0x49e, 0x49e },
	{ 0x4a0, 0x4a0 },
	{ 0x4a2, 0x4a2 },
	{ 0x4a4, 0x4a4 },
	{ 0x4a6, 0x4a6 },
	{ 0x4a8, 0x4a8 },
	{ 0x4aa, 0x4aa },
	{ 0x4ac, 0x4ac },
	{ 0x4ae, 0x4ae },
	{ 0x4b0, 0x4b0 },
	{ 0x4b2, 0x4b2 },
	{ 0x4b4, 0x4b4 },
	{ 0x4b6, 0x4b6 },
	{ 0x4b8, 0x4b8 },
	{ 0x4ba, 0x4ba },
	{ 0x4bc, 0x4bc },
	{ 0x4be, 0x4be },
	{ 0x4c0, 0x4c1 },
	{ 0x4c3, 0x4c3 },
	{ 0x4c5, 0x4c5 },
	{ 0x4c7, 0x4c7 },
	{ 0x4c9, 0x4c9 },
	{ 0x4cb, 0x4cb },
	{ 0x4cd, 0x4cd },
	{ 0x4d0, 0x4d0 },
	{ 0x4d2, 0x4d2 },
	{ 0x4d4, 0x4d4 },
	{ 0x4d6, 0x4d6 },
	{ 0x4d8, 0x4d8 },
	{ 0x4da, 0x4da },
	{ 0x4dc, 0x4dc },
	{ 0x4de, 0x4de },
	{ 0x4e0, 0x4e0 },
	{ 0x4e2, 0x4e2 },
	{ 0x4e4, 0x4e4 },
	{ 0x4e6, 0x4e6 },
	{ 0x4e8, 0x4e8 },
	{ 0x4ea, 0x4ea },
	{ 0x4ec, 0x4ec },
	{ 0x4ee, 0x4ee },
	{ 0x4f0, 0x4f0 },
	{ 0x4f2, 0x4f2 },
	{ 0x4f4, 0x4f4 },
	{ 0x4f6, 0x4f6 },
	{ 0x4f8, 0x4f8 },
	{ 0x4fa, 0x4fa },
	{ 0x4fc, 0x4fc },
	{ 0x4fe, 0x4fe },
	{ 0x500, 0x500 },
	{ 0x502, 0x502 },
	{ 0x504, 0x504 },
	{ 0x506, 0x506 },
	{ 0x508, 0x508 },
	{ 0x50a, 0x50a },
	{ 0x50c, 0x50c },
	{ 0x50e, 0x50e },
	{ 0x510, 0x510 },
	{ 0x512, 0x512 },
	{ 0x514, 0x514 },
	{ 0x516, 0x516 },
	{ 0x518, 0x518 },
	{ 0x51a, 0x51a },
	{ 0x51c, 0x51c },
	{ 0x51e, 0x51e },
	{ 0x520, 0x520 },
	{ 0x522, 0x522 },
	{ 0x524, 0x524 },
	{ 0x526, 0x526 },
	{ 0x528, 0x528 },
	{ 0x52a, 0x52a },
	{ 0x52c, 0x52c },
	{ 0x52e, 0x52e },
	{ 0x531, 0x556 },
	{ 0x10a0, 0x10c5 },
	{ 0x10c7, 0x10c7 },
	{ 0x10cd, 0x10cd },
	{ 0x13a0, 0x13f5 },
	{ 0x1e00, 0x1e00 },
	{ 0x1e02, 0x1e02 },
	{ 0x1e04, 0x1e04 },
	{ 0x1e06, 0x1e06 },
	{ 0x1e08, 0x1e08 },
	{ 0x1e0a, 0x1e0a },
	{ 0x1e0c, 0x1e0c },
	{ 0x1e0e, 0x1e0e },
	{ 0x1e10, 0x1e10 },
	{ 0x1e12, 0x1e12 },
	{ 0x1e14, 0x1e14 },
	{ 0x1e16, 0x1e16 },
	{ 0x1e18, 0x1e18 },
	{ 0x1e1a, 0x1e1a },
	{ 0x1e1c, 0x1e1c },
	{ 0x1e1e, 0x1e1e },
	{ 0x1e20, 0x1e20 },
	{ 0x1e22, 0x1e22 },
	{ 0x1e24, 0x1e24 },
	{ 0x1e26, 0x1e26 },
	{ 0x1e28, 0x1e28 },
	{ 0x1e2a, 0x1e2a },
	{ 0x1e2c, 0x1e2c },
	{ 0x1e2e, 0x1e2e },
	{ 0x1e30, 0x1e30 },
	{ 0x1e32, 0x1e32 },
	{ 0x1e34, 0x1e34 },
	{ 0x1e36, 0x1e36 },
	{ 0x1e38, 0x1e38 },
	{ 0x1e3a, 0x1e3a },
	{ 0x1e3c, 0x1e3c },
	{ 0x1e3e, 0x1e3e },
	{ 0x1e40, 0x1e40 },
	{ 0x1e42, 0x1e42 },
	{ 0x1e44, 0x1e44 },
	{ 0x1e46, 0x1e46 },
	{ 0x1e48, 0x1e48 },
	{ 0x1e4a, 0x1e4a },
	{ 0x1e4c, 0x1e4c },
	{ 0x1e4e, 0x1e4e },
	{ 0x1e50, 0x1e50 },
	{ 0x1e52, 0x1e52 },
	{ 0x1e54, 0x1e54 },
	{ 0x1e56, 0x1e56 },
	{ 0x1e58, 0x1e58 },
	{ 0x1e5a, 0x1e5a },
	{ 0x1e5c, 0x1e5c },
	{ 0x1e5e, 0x1e5e },
	{ 0x1e60, 0x1e60 },
	{ 0x1e62, 0x1e62 },
	{ 0x1e64, 0x1e64 },
	{ 0x1e66, 0x1e66 },
	{ 0x1e68, 0x1e68 },
	{ 0x1e6a, 0x1e6a },
	{ 0x1e6c, 0x1e6c },
	{ 0x1e6e, 0x1e6e },
	{ 0x1e70, 0x1e70 },
	{ 0x1e72, 0x1e72 },
	{ 0x1e74, 0x1e74 },
	{ 0x1e76, 0x1e76 },
	{ 0x1e78, 0x1e78 },
	{ 0x1e7a, 0x1e7a },
	{ 0x1e7c, 0x1e7c },
	{ 0x1e7e, 0x1e7e },
	{ 0x1e80, 0x1e80 },
	{ 0x1e82, 0x1e82 },
	{ 0x1e84, 0x1e84 },
	{ 0x1e86, 0x1e86 },
	{ 0x1e88, 0x1e88 },
	{ 0x1e8a, 0x1e8a },
	{ 0x1e8c, 0x1e8c },
	{ 0x1e8e, 0x1e8e },
	{ 0x1e90, 0x1e90 },
	{ 0x1e92, 0x1e92 },
	{ 0x1e94, 0x1e94 },
	{ 0x1e9e, 0x1e9e },
	{ 0x1ea0, 0x1ea0 },
	{ 0x1ea2, 0x1ea2 },
	{ 0x1ea4, 0x1ea4 },
	{ 0x1ea6, 0x1ea6 },
	{ 0x1ea8, 0x1ea8 },
	{ 0x1eaa, 0x1eaa },
	{ 0x1eac, 0x1eac },
	{ 0x1eae, 0x1eae },
	{ 0x1eb0, 0x1eb0 },
	{ 0x1eb2, 0x1eb2 },
	{ 0x1eb4, 0x1eb4 },
	{ 0x1eb6, 0x1eb6 },
	{ 0x1eb8, 0x1eb8 },
	{ 0x1eba, 0x1eba },
	{ 0x1ebc, 0x1ebc },
	{ 0x1ebe, 0x1ebe },
	{ 0x1ec0, 0x1ec0 },
	{ 0x1ec2, 0x1ec2 },
	{ 0x1ec4, 0x1ec4 },
	{ 0x1ec6, 0x1ec6 },
	{ 0x1ec8, 0x1ec8 },
	{ 0x1eca, 0x1eca },
	{ 0x1ecc, 0x1ecc },
	{ 0x1ece, 0x1ece },
	{ 0x1ed0, 0x1ed0 },
	{ 0x1ed2, 0x1ed2 },
	{ 0x1ed4, 0x1ed4 },
	{ 0x1ed6, 0x1ed6 },
	{ 0x1ed8, 0x1ed8 },
	{ 0x1eda, 0x1eda },
	{ 0x1edc, 0x1edc },
	{ 0x1ede, 0x1ede },
	{ 0x1ee0, 0x1ee0 },
	{ 0x1ee2, 0x1ee2 },
	{ 0x1ee4, 0x1ee4 },
	{ 0x1ee6, 0x1ee6 },
	{ 0x1ee8, 0x1ee8 },
	{ 0x1eea, 0x1eea },
	{ 0x1eec, 0x1eec },
	{ 0x1eee, 0x1eee },
	{ 0x1ef0, 0x1ef0 },
	{ 0x1ef2, 0x1ef2 },
	{ 0x1ef4, 0x1ef4 },
	{ 0x1ef6, 0x1ef6 },
	{ 0x1ef8, 0x1ef8 },
	{ 0x1efa, 0x1efa },
	{ 0x1efc, 0x1efc },
	{ 0x1efe, 0x1efe },
	{ 0x1f08, 0x1f0f },
	{ 0x1f18, 0x1f1d },
	{ 0x1f28, 0x1f2f },
	{ 0x1f38, 0x1f3f },
	{ 0x1f48, 0x1f4d },
	{ 0x1f59, 0x1f59 },
	{ 0x1f5b, 0x1f5b },
	{ 0x1f5d, 0x1f5d },
	{ 0x1f5f, 0x1f5f },
	{ 0x1f68, 0x1f6f },
	{ 0x1fb8, 0x1fbb },
	{ 0x1fc8, 0x1fcb },
	{ 0x1fd8, 0x1fdb },
	{ 0x1fe8, 0x1fec },
	{ 0x1ff8, 0x1ffb },
	{ 0x2102, 0x2102 },
	{ 0x2107, 0x2107 },
	{ 0x210b, 0x210d },
	{ 0x2110, 0x2112 },
	{ 0x2115, 0x2115 },
	{ 0x2119, 0x211d },
	{ 0x2124, 0x2124 },
	{ 0x2126, 0x2126 },
	{ 0x2128, 0x2128 },
	{ 0x212a, 0x212d },
	{ 0x2130, 0x2133 },
	{ 0x213e, 0x213f },
	{ 0x2145, 0x2145 },
	{ 0x2183, 0x2183 },
	{ 0x2c00, 0x2c2e },
	{ 0x2c60, 0x2c60 },
	{ 0x2c62, 0x2c64 },
	{ 0x2c67, 0x2c67 },
	{ 0x2c69, 0x2c69 },
	{ 0x2c6b, 0x2c6b },
	{ 0x2c6d, 0x2c70 },
	{ 0x2c72, 0x2c72 },
	{ 0x2c75, 0x2c75 },
	{ 0x2c7e, 0x2c80 },
	{ 0x2c82, 0x2c82 },
	{ 0x2c84, 0x2c84 },
	{ 0x2c86, 0x2c86 },
	{ 0x2c88, 0x2c88 },
	{ 0x2c8a, 0x2c8a },
	{ 0x2c8c, 0x2c8c },
	{ 0x2c8e, 0x2c8e },
	{ 0x2c90, 0x2c90 },
	{ 0x2c92, 0x2c92 },
	{ 0x2c94, 0x2c94 },
	{ 0x2c96, 0x2c96 },
	{ 0x2c98, 0x2c98 },
	{ 0x2c9a, 0x2c9a },
	{ 0x2c9c, 0x2c9c },
	{ 0x2c9e, 0x2c9e },
	{ 0x2ca0, 0x2ca0 },
	{ 0x2ca2, 0x2ca2 },
	{ 0x2ca4, 0x2ca4 },
	{ 0x2ca6, 0x2ca6 },
	{ 0x2ca8, 0x2ca8 },
	{ 0x2caa, 0x2caa },
	{ 0x2cac, 0x2cac },
	{ 0x2cae, 0x2cae },
	{ 0x2cb0, 0x2cb0 },
	{ 0x2cb2, 0x2cb2 },
	{ 0x2cb4, 0x2cb4 },
	{ 0x2cb6, 0x2cb6 },
	{ 0x2cb8, 0x2cb8 },
	{ 0x2cba, 0x2cba },
	{ 0x2cbc, 0x2cbc },
	{ 0x2cbe, 0x2cbe },
	{ 0x2cc0, 0x2cc0 },
	{ 0x2cc2, 0x2cc2 },
	{ 0x2cc4, 0x2cc4 },
	{ 0x2cc6, 0x2cc6 },
	{ 0x2cc8, 0x2cc8 },
	{ 0x2cca, 0x2cca },
	{ 0x2ccc, 0x2ccc },
	{ 0x2cce, 0x2cce },
	{ 0x2cd0, 0x2cd0 },
	{ 0x2cd2, 0x2cd2 },
	{ 0x2cd4, 0x2cd4 },
	{ 0x2cd6, 0x2cd6 },
	{ 0x2cd8, 0x2cd8 },
	{ 0x2cda, 0x2cda },
	{ 0x2cdc, 0x2cdc },
	{ 0x2cde, 0x2cde },
	{ 0x2ce0, 0x2ce0 },
	{ 0x2ce2, 0x2ce2 },
	{ 0x2ceb, 0x2ceb },
	{ 0x2ced, 0x2ced },
	{ 0x2cf2, 0x2cf2 },
	{ 0xa640, 0xa640 },
	{ 0xa642, 0xa642 },
	{ 0xa644, 0xa644 },
	{ 0xa646, 0xa646 },
	{ 0xa648, 0xa648 },
	{ 0xa64a, 0xa64a },
	{ 0xa64c, 0xa64c },
	{ 0xa64e, 0xa64e },
	{ 0xa650, 0xa650 },
	{ 0xa652, 0xa652 },
	{ 0xa654, 0xa654 },
	{ 0xa656, 0xa656 },
	{ 0xa658, 0xa658 },
	{ 0xa65a, 0xa65a },
	{ 0xa65c, 0xa65c },
	{ 0xa65e, 0xa65e },
	{ 0xa660, 0xa660 },
	{ 0xa662, 0xa662 },
	{ 0xa664, 0xa664 },
	{ 0xa666, 0xa666 },
	{ 0xa668, 0xa668 },
	{ 0xa66a, 0xa66a },
	{ 0xa66c, 0xa66c },
	{ 0xa680, 0xa680 },
	{ 0xa682, 0xa682 },
	{ 0xa684, 0xa684 },
	{ 0xa686, 0xa686 },
	{ 0xa688, 0xa688 },
	{ 0xa68a, 0xa68a },
	{ 0xa68c, 0xa68c },
	{ 0xa68e, 0xa68e },
	{ 0xa690, 0xa690 },
	{ 0xa692, 0xa692 },
	{ 0xa694, 0xa694 },
	{ 0xa696, 0xa696 },
	{ 0xa698, 0xa698 },
	{ 0xa69a, 0xa69a },
	{ 0xa722, 0xa722 },
	{ 0xa724, 0xa724 },
	{ 0xa726, 0xa726 },
	{ 0xa728, 0xa728 },
	{ 0xa72a, 0xa72a },
	{ 0xa72c, 0xa72c },
	{ 0xa72e, 0xa72e },
	{ 0xa732, 0xa732 },
	{ 0xa734, 0xa734 },
	{ 0xa736, 0xa736 },
	{ 0xa738, 0xa738 },
	{ 0xa73a, 0xa73a },
	{ 0xa73c, 0xa73c },
	{ 0xa73e, 0xa73e },
	{ 0xa740, 0xa740 },
	{ 0xa742, 0xa742 },
	{ 0xa744, 0xa744 },
	{ 0xa746, 0xa746 },
	{ 0xa748, 0xa748 },
	{ 0xa74a, 0xa74a },
	{ 0xa74c, 0xa74c },
	{ 0xa74e, 0xa74e },
	{ 0xa750, 0xa750 },
	{ 0xa752, 0xa752 },
	{ 0xa754, 0xa754 },
	{ 0xa756, 0xa756 },
	{ 0xa758, 0xa758 },
	{ 0xa75a, 0xa75a },
	{ 0xa75c, 0xa75c },
	{ 0xa75e, 0xa75e },
	{ 0xa760, 0xa760 },
	{ 0xa762, 0xa762 },
	{ 0xa764, 0xa764 },
	{ 0xa766, 0xa766 },
	{ 0xa768, 0xa768 },
	{ 0xa76a, 0xa76a },
	{ 0xa76c, 0xa76c },
	{ 0xa76e, 0xa76e },
	{ 0xa779, 0xa779 },
	{ 0xa77b, 0xa77b },
	{ 0xa77d, 0xa77e },
	{ 0xa780, 0xa780 },
	{ 0xa782, 0xa782 },
	{ 0xa784, 0xa784 },
	{ 0xa786, 0xa786 },
	{ 0xa78b, 0xa78b },
	{ 0xa78d, 0xa78d },
	{ 0xa790, 0xa790 },
	{ 0xa792, 0xa792 },
	{ 0xa796, 0xa796 },
	{ 0xa798, 0xa798 },
	{ 0xa79a, 0xa79a },
	{ 0xa79c, 0xa79c },
	{ 0xa79e, 0xa79e },
	{ 0xa7a0, 0xa7a0 },
	{ 0xa7a2, 0xa7a2 },
	{ 0xa7a4, 0xa7a4 },
	{ 0xa7a6, 0xa7a6 },
	{ 0xa7a8, 0xa7a8 },
	{ 0xa7aa, 0xa7ae },
	{ 0xa7b0, 0xa7b4 },
	{ 0xa7b6, 0xa7b6 },
	{ 0xff21, 0xff3a },
	{ 0x10400, 0x10427 },
	{ 0x104b0, 0x104d3 },
	{ 0x10c80, 0x10cb2 },
	{ 0x118a0, 0x118bf },
	{ 0x1d400, 0x1d419 },
	{ 0x1d434, 0x1d44d },
	{ 0x1d468, 0x1d481 },
	{ 0x1d49c, 0x1d49c },
	{ 0x1d49e, 0x1d49f },
	{ 0x1d4a2, 0x1d4a2 },
	{ 0x1d4a5, 0x1d4a6 },
	{ 0x1d4a9, 0x1d4ac },
	{ 0x1d4ae, 0x1d4b5 },
	{ 0x1d4d0, 0x1d4e9 },
	{ 0x1d504, 0x1d505 },
	{ 0x1d507, 0x1d50a },
	{ 0x1d50d, 0x1d514 },
	{ 0x1d516, 0x1d51c },
	{ 0x1d538, 0x1d539 },
	{ 0x1d53b, 0x1d53e },
	{ 0x1d540, 0x1d544 },
	{ 0x1d546, 0x1d546 },
	{ 0x1d54a, 0x1d550 },
	{ 0x1d56c, 0x1d585 },
	{ 0x1d5a0, 0x1d5b9 },
	{ 0x1d5d4, 0x1d5ed },
	{ 0x1d608, 0x1d621 },
	{ 0x1d63c, 0x1d655 },
	{ 0x1d670, 0x1d689 },
	{ 0x1d6a8, 0x1d6c0 },
	{ 0x1d6e2, 0x1d6fa },
	{ 0x1d71c, 0x1d734 },
	{ 0x1d756, 0x1d76e },
	{ 0x1d790, 0x1d7a8 },
	{ 0x1d7ca, 0x1d7ca },
	{ 0x1e900, 0x1e921 }
};

struct interval Nd_table[] = {
	{ 0x30, 0x39 },
	{ 0x660, 0x669 },
	{ 0x6f0, 0x6f9 },
	{ 0x7c0, 0x7c9 },
	{ 0x966, 0x96f },
	{ 0x9e6, 0x9ef },
	{ 0xa66, 0xa6f },
	{ 0xae6, 0xaef },
	{ 0xb66, 0xb6f },
	{ 0xbe6, 0xbef },
	{ 0xc66, 0xc6f },
	{ 0xce6, 0xcef },
	{ 0xd66, 0xd6f },
	{ 0xde6, 0xdef },
	{ 0xe50, 0xe59 },
	{ 0xed0, 0xed9 },
	{ 0xf20, 0xf29 },
	{ 0x1040, 0x1049 },
	{ 0x1090, 0x1099 },
	{ 0x17e0, 0x17e9 },
	{ 0x1810, 0x1819 },
	{ 0x1946, 0x194f },
	{ 0x19d0, 0x19d9 },
	{ 0x1a80, 0x1a89 },
	{ 0x1a90, 0x1a99 },
	{ 0x1b50, 0x1b59 },
	{ 0x1bb0, 0x1bb9 },
	{ 0x1c40, 0x1c49 },
	{ 0x1c50, 0x1c59 },
	{ 0xa620, 0xa629 },
	{ 0xa8d0, 0xa8d9 },
	{ 0xa900, 0xa909 },
	{ 0xa9d0, 0xa9d9 },
	{ 0xa9f0, 0xa9f9 },
	{ 0xaa50, 0xaa59 },
	{ 0xabf0, 0xabf9 },
	{ 0xff10, 0xff19 },
	{ 0x104a0, 0x104a9 },
	{ 0x11066, 0x1106f },
	{ 0x110f0, 0x110f9 },
	{ 0x11136, 0x1113f },
	{ 0x111d0, 0x111d9 },
	{ 0x112f0, 0x112f9 },
	{ 0x11450, 0x11459 },
	{ 0x114d0, 0x114d9 },
	{ 0x11650, 0x11659 },
	{ 0x116c0, 0x116c9 },
	{ 0x11730, 0x11739 },
	{ 0x118e0, 0x118e9 },
	{ 0x11c50, 0x11c59 },
	{ 0x16a60, 0x16a69 },
	{ 0x16b50, 0x16b59 },
	{ 0x1d7ce, 0x1d7d7 },
	{ 0x1d7d8, 0x1d7e1 },
	{ 0x1d7e2, 0x1d7eb },
	{ 0x1d7ec, 0x1d7f5 },
	{ 0x1d7f6, 0x1d7ff },
	{ 0x1e950, 0x1e959 }
};

struct interval Pd_table[] = {
	{ 0x2d, 0x2d },
	{ 0x58a, 0x58a },
	{ 0x5be, 0x5be },
	{ 0x1400, 0x1400 },
	{ 0x1806, 0x1806 },
	{ 0x2010, 0x2015 },
	{ 0x2e17, 0x2e17 },
	{ 0x2e1a, 0x2e1a },
	{ 0x2e3a, 0x2e3b },
	{ 0x2e40, 0x2e40 },
	{ 0x301c, 0x301c },
	{ 0x3030, 0x3030 },
	{ 0x30a0, 0x30a0 },
	{ 0xfe31, 0xfe32 },
	{ 0xfe58, 0xfe58 },
	{ 0xfe63, 0xfe63 },
	{ 0xff0d, 0xff0d }
};

struct interval Sm_table[] = {
	{ 0x2b, 0x2b },
	{ 0x3c, 0x3e },
	{ 0x7c, 0x7c },
	{ 0x7e, 0x7e },
	{ 0xac, 0xac },
	{ 0xb1, 0xb1 },
	{ 0xd7, 0xd7 },
	{ 0xf7, 0xf7 },
	{ 0x3f6, 0x3f6 },
	{ 0x606, 0x608 },
	{ 0x2044, 0x2044 },
	{ 0x2052, 0x2052 },
	{ 0x207a, 0x207c },
	{ 0x208a, 0x208c },
	{ 0x2118, 0x2118 },
	{ 0x2140, 0x2144 },
	{ 0x214b, 0x214b },
	{ 0x2190, 0x2194 },
	{ 0x219a, 0x219b },
	{ 0x21a0, 0x21a0 },
	{ 0x21a3, 0x21a3 },
	{ 0x21a6, 0x21a6 },
	{ 0x21ae, 0x21ae },
	{ 0x21ce, 0x21cf },
	{ 0x21d2, 0x21d2 },
	{ 0x21d4, 0x21d4 },
	{ 0x21f4, 0x22ff },
	{ 0x2320, 0x2321 },
	{ 0x237c, 0x237c },
	{ 0x239b, 0x23b3 },
	{ 0x23dc, 0x23e1 },
	{ 0x25b7, 0x25b7 },
	{ 0x25c1, 0x25c1 },
	{ 0x25f8, 0x25ff },
	{ 0x266f, 0x266f },
	{ 0x27c0, 0x27c4 },
	{ 0x27c7, 0x27e5 },
	{ 0x27f0, 0x27ff },
	{ 0x2900, 0x2982 },
	{ 0x2999, 0x29d7 },
	{ 0x29dc, 0x29fb },
	{ 0x29fe, 0x2aff },
	{ 0x2b30, 0x2b44 },
	{ 0x2b47, 0x2b4c },
	{ 0xfb29, 0xfb29 },
	{ 0xfe62, 0xfe62 },
	{ 0xfe64, 0xfe66 },
	{ 0xff0b, 0xff0b },
	{ 0xff1c, 0xff1e },
	{ 0xff5c, 0xff5c },
	{ 0xff5e, 0xff5e },
	{ 0xffe2, 0xffe2 },
	{ 0xffe9, 0xffec },
	{ 0x1d6c1, 0x1d6c1 },
	{ 0x1d6db, 0x1d6db },
	{ 0x1d6fb, 0x1d6fb },
	{ 0x1d715, 0x1d715 },
	{ 0x1d735, 0x1d735 },
	{ 0x1d74f, 0x1d74f },
	{ 0x1d76f, 0x1d76f },
	{ 0x1d789, 0x1d789 },
	{ 0x1d7a9, 0x1d7a9 },
	{ 0x1d7c3, 0x1d7c3 },
	{ 0x1eef0, 0x1eef1 }
};

struct interval Pe_table[] = {
	{ 0x29, 0x29 },
	{ 0x5d, 0x5d },
	{ 0x7d, 0x7d },
	{ 0xf3b, 0xf3b },
	{ 0xf3d, 0xf3d },
	{ 0x169c, 0x169c },
	{ 0x2046, 0x2046 },
	{ 0x207e, 0x207e },
	{ 0x208e, 0x208e },
	{ 0x2309, 0x2309 },
	{ 0x230b, 0x230b },
	{ 0x232a, 0x232a },
	{ 0x2769, 0x2769 },
	{ 0x276b, 0x276b },
	{ 0x276d, 0x276d },
	{ 0x276f, 0x276f },
	{ 0x2771, 0x2771 },
	{ 0x2773, 0x2773 },
	{ 0x2775, 0x2775 },
	{ 0x27c6, 0x27c6 },
	{ 0x27e7, 0x27e7 },
	{ 0x27e9, 0x27e9 },
	{ 0x27eb, 0x27eb },
	{ 0x27ed, 0x27ed },
	{ 0x27ef, 0x27ef },
	{ 0x2984, 0x2984 },
	{ 0x2986, 0x2986 },
	{ 0x2988, 0x2988 },
	{ 0x298a, 0x298a },
	{ 0x298c, 0x298c },
	{ 0x298e, 0x298e },
	{ 0x2990, 0x2990 },
	{ 0x2992, 0x2992 },
	{ 0x2994, 0x2994 },
	{ 0x2996, 0x2996 },
	{ 0x2998, 0x2998 },
	{ 0x29d9, 0x29d9 },
	{ 0x29db, 0x29db },
	{ 0x29fd, 0x29fd },
	{ 0x2e23, 0x2e23 },
	{ 0x2e25, 0x2e25 },
	{ 0x2e27, 0x2e27 },
	{ 0x2e29, 0x2e29 },
	{ 0x3009, 0x3009 },
	{ 0x300b, 0x300b },
	{ 0x300d, 0x300d },
	{ 0x300f, 0x300f },
	{ 0x3011, 0x3011 },
	{ 0x3015, 0x3015 },
	{ 0x3017, 0x3017 },
	{ 0x3019, 0x3019 },
	{ 0x301b, 0x301b },
	{ 0x301e, 0x301f },
	{ 0xfd3e, 0xfd3e },
	{ 0xfe18, 0xfe18 },
	{ 0xfe36, 0xfe36 },
	{ 0xfe38, 0xfe38 },
	{ 0xfe3a, 0xfe3a },
	{ 0xfe3c, 0xfe3c },
	{ 0xfe3e, 0xfe3e },
	{ 0xfe40, 0xfe40 },
	{ 0xfe42, 0xfe42 },
	{ 0xfe44, 0xfe44 },
	{ 0xfe48, 0xfe48 },
	{ 0xfe5a, 0xfe5a },
	{ 0xfe5c, 0xfe5c },
	{ 0xfe5e, 0xfe5e },
	{ 0xff09, 0xff09 },
	{ 0xff3d, 0xff3d },
	{ 0xff5d, 0xff5d },
	{ 0xff60, 0xff60 },
	{ 0xff63, 0xff63 }
};

struct interval Ps_table[] = {
	{ 0x28, 0x28 },
	{ 0x5b, 0x5b },
	{ 0x7b, 0x7b },
	{ 0xf3a, 0xf3a },
	{ 0xf3c, 0xf3c },
	{ 0x169b, 0x169b },
	{ 0x201a, 0x201a },
	{ 0x201e, 0x201e },
	{ 0x2045, 0x2045 },
	{ 0x207d, 0x207d },
	{ 0x208d, 0x208d },
	{ 0x2308, 0x2308 },
	{ 0x230a, 0x230a },
	{ 0x2329, 0x2329 },
	{ 0x2768, 0x2768 },
	{ 0x276a, 0x276a },
	{ 0x276c, 0x276c },
	{ 0x276e, 0x276e },
	{ 0x2770, 0x2770 },
	{ 0x2772, 0x2772 },
	{ 0x2774, 0x2774 },
	{ 0x27c5, 0x27c5 },
	{ 0x27e6, 0x27e6 },
	{ 0x27e8, 0x27e8 },
	{ 0x27ea, 0x27ea },
	{ 0x27ec, 0x27ec },
	{ 0x27ee, 0x27ee },
	{ 0x2983, 0x2983 },
	{ 0x2985, 0x2985 },
	{ 0x2987, 0x2987 },
	{ 0x2989, 0x2989 },
	{ 0x298b, 0x298b },
	{ 0x298d, 0x298d },
	{ 0x298f, 0x298f },
	{ 0x2991, 0x2991 },
	{ 0x2993, 0x2993 },
	{ 0x2995, 0x2995 },
	{ 0x2997, 0x2997 },
	{ 0x29d8, 0x29d8 },
	{ 0x29da, 0x29da },
	{ 0x29fc, 0x29fc },
	{ 0x2e22, 0x2e22 },
	{ 0x2e24, 0x2e24 },
	{ 0x2e26, 0x2e26 },
	{ 0x2e28, 0x2e28 },
	{ 0x2e42, 0x2e42 },
	{ 0x3008, 0x3008 },
	{ 0x300a, 0x300a },
	{ 0x300c, 0x300c },
	{ 0x300e, 0x300e },
	{ 0x3010, 0x3010 },
	{ 0x3014, 0x3014 },
	{ 0x3016, 0x3016 },
	{ 0x3018, 0x3018 },
	{ 0x301a, 0x301a },
	{ 0x301d, 0x301d },
	{ 0xfd3f, 0xfd3f },
	{ 0xfe17, 0xfe17 },
	{ 0xfe35, 0xfe35 },
	{ 0xfe37, 0xfe37 },
	{ 0xfe39, 0xfe39 },
	{ 0xfe3b, 0xfe3b },
	{ 0xfe3d, 0xfe3d },
	{ 0xfe3f, 0xfe3f },
	{ 0xfe41, 0xfe41 },
	{ 0xfe43, 0xfe43 },
	{ 0xfe47, 0xfe47 },
	{ 0xfe59, 0xfe59 },
	{ 0xfe5b, 0xfe5b },
	{ 0xfe5d, 0xfe5d },
	{ 0xff08, 0xff08 },
	{ 0xff3b, 0xff3b },
	{ 0xff5b, 0xff5b },
	{ 0xff5f, 0xff5f },
	{ 0xff62, 0xff62 }
};

struct interval Sc_table[] = {
	{ 0x24, 0x24 },
	{ 0xa2, 0xa5 },
	{ 0x58f, 0x58f },
	{ 0x60b, 0x60b },
	{ 0x9f2, 0x9f3 },
	{ 0x9fb, 0x9fb },
	{ 0xaf1, 0xaf1 },
	{ 0xbf9, 0xbf9 },
	{ 0xe3f, 0xe3f },
	{ 0x17db, 0x17db },
	{ 0x20a0, 0x20be },
	{ 0xa838, 0xa838 },
	{ 0xfdfc, 0xfdfc },
	{ 0xfe69, 0xfe69 },
	{ 0xff04, 0xff04 },
	{ 0xffe0, 0xffe1 },
	{ 0xffe5, 0xffe6 }
};

struct interval Po_table[] = {
	{ 0x21, 0x23 },
	{ 0x25, 0x27 },
	{ 0x2a, 0x2a },
	{ 0x2c, 0x2c },
	{ 0x2e, 0x2f },
	{ 0x3a, 0x3b },
	{ 0x3f, 0x40 },
	{ 0x5c, 0x5c },
	{ 0xa1, 0xa1 },
	{ 0xa7, 0xa7 },
	{ 0xb6, 0xb7 },
	{ 0xbf, 0xbf },
	{ 0x37e, 0x37e },
	{ 0x387, 0x387 },
	{ 0x55a, 0x55f },
	{ 0x589, 0x589 },
	{ 0x5c0, 0x5c0 },
	{ 0x5c3, 0x5c3 },
	{ 0x5c6, 0x5c6 },
	{ 0x5f3, 0x5f4 },
	{ 0x609, 0x60a },
	{ 0x60c, 0x60d },
	{ 0x61b, 0x61b },
	{ 0x61e, 0x61f },
	{ 0x66a, 0x66d },
	{ 0x6d4, 0x6d4 },
	{ 0x700, 0x70d },
	{ 0x7f7, 0x7f9 },
	{ 0x830, 0x83e },
	{ 0x85e, 0x85e },
	{ 0x964, 0x965 },
	{ 0x970, 0x970 },
	{ 0xaf0, 0xaf0 },
	{ 0xdf4, 0xdf4 },
	{ 0xe4f, 0xe4f },
	{ 0xe5a, 0xe5b },
	{ 0xf04, 0xf12 },
	{ 0xf14, 0xf14 },
	{ 0xf85, 0xf85 },
	{ 0xfd0, 0xfd4 },
	{ 0xfd9, 0xfda },
	{ 0x104a, 0x104f },
	{ 0x10fb, 0x10fb },
	{ 0x1360, 0x1368 },
	{ 0x166d, 0x166e },
	{ 0x16eb, 0x16ed },
	{ 0x1735, 0x1736 },
	{ 0x17d4, 0x17d6 },
	{ 0x17d8, 0x17da },
	{ 0x1800, 0x1805 },
	{ 0x1807, 0x180a },
	{ 0x1944, 0x1945 },
	{ 0x1a1e, 0x1a1f },
	{ 0x1aa0, 0x1aa6 },
	{ 0x1aa8, 0x1aad },
	{ 0x1b5a, 0x1b60 },
	{ 0x1bfc, 0x1bff },
	{ 0x1c3b, 0x1c3f },
	{ 0x1c7e, 0x1c7f },
	{ 0x1cc0, 0x1cc7 },
	{ 0x1cd3, 0x1cd3 },
	{ 0x2016, 0x2017 },
	{ 0x2020, 0x2027 },
	{ 0x2030, 0x2038 },
	{ 0x203b, 0x203e },
	{ 0x2041, 0x2043 },
	{ 0x2047, 0x2051 },
	{ 0x2053, 0x2053 },
	{ 0x2055, 0x205e },
	{ 0x2cf9, 0x2cfc },
	{ 0x2cfe, 0x2cff },
	{ 0x2d70, 0x2d70 },
	{ 0x2e00, 0x2e01 },
	{ 0x2e06, 0x2e08 },
	{ 0x2e0b, 0x2e0b },
	{ 0x2e0e, 0x2e16 },
	{ 0x2e18, 0x2e19 },
	{ 0x2e1b, 0x2e1b },
	{ 0x2e1e, 0x2e1f },
	{ 0x2e2a, 0x2e2e },
	{ 0x2e30, 0x2e39 },
	{ 0x2e3c, 0x2e3f },
	{ 0x2e41, 0x2e41 },
	{ 0x2e43, 0x2e44 },
	{ 0x3001, 0x3003 },
	{ 0x303d, 0x303d },
	{ 0x30fb, 0x30fb },
	{ 0xa4fe, 0xa4ff },
	{ 0xa60d, 0xa60f },
	{ 0xa673, 0xa673 },
	{ 0xa67e, 0xa67e },
	{ 0xa6f2, 0xa6f7 },
	{ 0xa874, 0xa877 },
	{ 0xa8ce, 0xa8cf },
	{ 0xa8f8, 0xa8fa },
	{ 0xa8fc, 0xa8fc },
	{ 0xa92e, 0xa92f },
	{ 0xa95f, 0xa95f },
	{ 0xa9c1, 0xa9cd },
	{ 0xa9de, 0xa9df },
	{ 0xaa5c, 0xaa5f },
	{ 0xaade, 0xaadf },
	{ 0xaaf0, 0xaaf1 },
	{ 0xabeb, 0xabeb },
	{ 0xfe10, 0xfe16 },
	{ 0xfe19, 0xfe19 },
	{ 0xfe30, 0xfe30 },
	{ 0xfe45, 0xfe46 },
	{ 0xfe49, 0xfe4c },
	{ 0xfe50, 0xfe52 },
	{ 0xfe54, 0xfe57 },
	{ 0xfe5f, 0xfe61 },
	{ 0xfe68, 0xfe68 },
	{ 0xfe6a, 0xfe6b },
	{ 0xff01, 0xff03 },
	{ 0xff05, 0xff07 },
	{ 0xff0a, 0xff0a },
	{ 0xff0c, 0xff0c },
	{ 0xff0e, 0xff0f },
	{ 0xff1a, 0xff1b },
	{ 0xff1f, 0xff20 },
	{ 0xff3c, 0xff3c },
	{ 0xff61, 0xff61 },
	{ 0xff64, 0xff65 },
	{ 0x10100, 0x10102 },
	{ 0x1039f, 0x1039f },
	{ 0x103d0, 0x103d0 },
	{ 0x1056f, 0x1056f },
	{ 0x10857, 0x10857 },
	{ 0x1091f, 0x1091f },
	{ 0x1093f, 0x1093f },
	{ 0x10a50, 0x10a58 },
	{ 0x10a7f, 0x10a7f },
	{ 0x10af0, 0x10af6 },
	{ 0x10b39, 0x10b3f },
	{ 0x10b99, 0x10b9c },
	{ 0x11047, 0x1104d },
	{ 0x110bb, 0x110bc },
	{ 0x110be, 0x110c1 },
	{ 0x11140, 0x11143 },
	{ 0x11174, 0x11175 },
	{ 0x111c5, 0x111c9 },
	{ 0x111cd, 0x111cd },
	{ 0x111db, 0x111db },
	{ 0x111dd, 0x111df },
	{ 0x11238, 0x1123d },
	{ 0x112a9, 0x112a9 },
	{ 0x1144b, 0x1144f },
	{ 0x1145b, 0x1145b },
	{ 0x1145d, 0x1145d },
	{ 0x114c6, 0x114c6 },
	{ 0x115c1, 0x115d7 },
	{ 0x11641, 0x11643 },
	{ 0x11660, 0x1166c },
	{ 0x1173c, 0x1173e },
	{ 0x11c41, 0x11c45 },
	{ 0x11c70, 0x11c71 },
	{ 0x12470, 0x12474 },
	{ 0x16a6e, 0x16a6f },
	{ 0x16af5, 0x16af5 },
	{ 0x16b37, 0x16b3b },
	{ 0x16b44, 0x16b44 },
	{ 0x1bc9f, 0x1bc9f },
	{ 0x1da87, 0x1da8b },
	{ 0x1e95e, 0x1e95f }
};

struct interval Zs_table[] = {
	{ 0x20, 0x20 },
	{ 0xa0, 0xa0 },
	{ 0x1680, 0x1680 },
	{ 0x2000, 0x200a },
	{ 0x202f, 0x202f },
	{ 0x205f, 0x205f },
	{ 0x3000, 0x3000 }
};

struct interval Cc_table[] = {
	{ 0x0, 0x1f },
	{ 0x7f, 0x9f }
};

struct interval toupper_table[] = {
	{ 0x61, 0x7a }, /* 0x41 */
	{ 0xb5, 0xb5 }, /* 0x39c */
	{ 0xe0, 0xf6 }, /* 0xc0 */
	{ 0xf8, 0xfe }, /* 0xd8 */
	{ 0xff, 0xff }, /* 0x178 */
	{ 0x101, 0x101 }, /* 0x100 */
	{ 0x103, 0x103 }, /* 0x102 */
	{ 0x105, 0x105 }, /* 0x104 */
	{ 0x107, 0x107 }, /* 0x106 */
	{ 0x109, 0x109 }, /* 0x108 */
	{ 0x10b, 0x10b }, /* 0x10a */
	{ 0x10d, 0x10d }, /* 0x10c */
	{ 0x10f, 0x10f }, /* 0x10e */
	{ 0x111, 0x111 }, /* 0x110 */
	{ 0x113, 0x113 }, /* 0x112 */
	{ 0x115, 0x115 }, /* 0x114 */
	{ 0x117, 0x117 }, /* 0x116 */
	{ 0x119, 0x119 }, /* 0x118 */
	{ 0x11b, 0x11b }, /* 0x11a */
	{ 0x11d, 0x11d }, /* 0x11c */
	{ 0x11f, 0x11f }, /* 0x11e */
	{ 0x121, 0x121 }, /* 0x120 */
	{ 0x123, 0x123 }, /* 0x122 */
	{ 0x125, 0x125 }, /* 0x124 */
	{ 0x127, 0x127 }, /* 0x126 */
	{ 0x129, 0x129 }, /* 0x128 */
	{ 0x12b, 0x12b }, /* 0x12a */
	{ 0x12d, 0x12d }, /* 0x12c */
	{ 0x12f, 0x12f }, /* 0x12e */
	{ 0x131, 0x131 }, /* 0x49 */
	{ 0x133, 0x133 }, /* 0x132 */
	{ 0x135, 0x135 }, /* 0x134 */
	{ 0x137, 0x137 }, /* 0x136 */
	{ 0x13a, 0x13a }, /* 0x139 */
	{ 0x13c, 0x13c }, /* 0x13b */
	{ 0x13e, 0x13e }, /* 0x13d */
	{ 0x140, 0x140 }, /* 0x13f */
	{ 0x142, 0x142 }, /* 0x141 */
	{ 0x144, 0x144 }, /* 0x143 */
	{ 0x146, 0x146 }, /* 0x145 */
	{ 0x148, 0x148 }, /* 0x147 */
	{ 0x14b, 0x14b }, /* 0x14a */
	{ 0x14d, 0x14d }, /* 0x14c */
	{ 0x14f, 0x14f }, /* 0x14e */
	{ 0x151, 0x151 }, /* 0x150 */
	{ 0x153, 0x153 }, /* 0x152 */
	{ 0x155, 0x155 }, /* 0x154 */
	{ 0x157, 0x157 }, /* 0x156 */
	{ 0x159, 0x159 }, /* 0x158 */
	{ 0x15b, 0x15b }, /* 0x15a */
	{ 0x15d, 0x15d }, /* 0x15c */
	{ 0x15f, 0x15f }, /* 0x15e */
	{ 0x161, 0x161 }, /* 0x160 */
	{ 0x163, 0x163 }, /* 0x162 */
	{ 0x165, 0x165 }, /* 0x164 */
	{ 0x167, 0x167 }, /* 0x166 */
	{ 0x169, 0x169 }, /* 0x168 */
	{ 0x16b, 0x16b }, /* 0x16a */
	{ 0x16d, 0x16d }, /* 0x16c */
	{ 0x16f, 0x16f }, /* 0x16e */
	{ 0x171, 0x171 }, /* 0x170 */
	{ 0x173, 0x173 }, /* 0x172 */
	{ 0x175, 0x175 }, /* 0x174 */
	{ 0x177, 0x177 }, /* 0x176 */
	{ 0x17a, 0x17a }, /* 0x179 */
	{ 0x17c, 0x17c }, /* 0x17b */
	{ 0x17e, 0x17e }, /* 0x17d */
	{ 0x17f, 0x17f }, /* 0x53 */
	{ 0x180, 0x180 }, /* 0x243 */
	{ 0x183, 0x183 }, /* 0x182 */
	{ 0x185, 0x185 }, /* 0x184 */
	{ 0x188, 0x188 }, /* 0x187 */
	{ 0x18c, 0x18c }, /* 0x18b */
	{ 0x192, 0x192 }, /* 0x191 */
	{ 0x195, 0x195 }, /* 0x1f6 */
	{ 0x199, 0x199 }, /* 0x198 */
	{ 0x19a, 0x19a }, /* 0x23d */
	{ 0x19e, 0x19e }, /* 0x220 */
	{ 0x1a1, 0x1a1 }, /* 0x1a0 */
	{ 0x1a3, 0x1a3 }, /* 0x1a2 */
	{ 0x1a5, 0x1a5 }, /* 0x1a4 */
	{ 0x1a8, 0x1a8 }, /* 0x1a7 */
	{ 0x1ad, 0x1ad }, /* 0x1ac */
	{ 0x1b0, 0x1b0 }, /* 0x1af */
	{ 0x1b4, 0x1b4 }, /* 0x1b3 */
	{ 0x1b6, 0x1b6 }, /* 0x1b5 */
	{ 0x1b9, 0x1b9 }, /* 0x1b8 */
	{ 0x1bd, 0x1bd }, /* 0x1bc */
	{ 0x1bf, 0x1bf }, /* 0x1f7 */
	{ 0x1c5, 0x1c5 }, /* 0x1c4 */
	{ 0x1c6, 0x1c6 }, /* 0x1c4 */
	{ 0x1c8, 0x1c8 }, /* 0x1c7 */
	{ 0x1c9, 0x1c9 }, /* 0x1c7 */
	{ 0x1cb, 0x1cb }, /* 0x1ca */
	{ 0x1cc, 0x1cc }, /* 0x1ca */
	{ 0x1ce, 0x1ce }, /* 0x1cd */
	{ 0x1d0, 0x1d0 }, /* 0x1cf */
	{ 0x1d2, 0x1d2 }, /* 0x1d1 */
	{ 0x1d4, 0x1d4 }, /* 0x1d3 */
	{ 0x1d6, 0x1d6 }, /* 0x1d5 */
	{ 0x1d8, 0x1d8 }, /* 0x1d7 */
	{ 0x1da, 0x1da }, /* 0x1d9 */
	{ 0x1dc, 0x1dc }, /* 0x1db */
	{ 0x1dd, 0x1dd }, /* 0x18e */
	{ 0x1df, 0x1df }, /* 0x1de */
	{ 0x1e1, 0x1e1 }, /* 0x1e0 */
	{ 0x1e3, 0x1e3 }, /* 0x1e2 */
	{ 0x1e5, 0x1e5 }, /* 0x1e4 */
	{ 0x1e7, 0x1e7 }, /* 0x1e6 */
	{ 0x1e9, 0x1e9 }, /* 0x1e8 */
	{ 0x1eb, 0x1eb }, /* 0x1ea */
	{ 0x1ed, 0x1ed }, /* 0x1ec */
	{ 0x1ef, 0x1ef }, /* 0x1ee */
	{ 0x1f2, 0x1f2 }, /* 0x1f1 */
	{ 0x1f3, 0x1f3 }, /* 0x1f1 */
	{ 0x1f5, 0x1f5 }, /* 0x1f4 */
	{ 0x1f9, 0x1f9 }, /* 0x1f8 */
	{ 0x1fb, 0x1fb }, /* 0x1fa */
	{ 0x1fd, 0x1fd }, /* 0x1fc */
	{ 0x1ff, 0x1ff }, /* 0x1fe */
	{ 0x201, 0x201 }, /* 0x200 */
	{ 0x203, 0x203 }, /* 0x202 */
	{ 0x205, 0x205 }, /* 0x204 */
	{ 0x207, 0x207 }, /* 0x206 */
	{ 0x209, 0x209 }, /* 0x208 */
	{ 0x20b, 0x20b }, /* 0x20a */
	{ 0x20d, 0x20d }, /* 0x20c */
	{ 0x20f, 0x20f }, /* 0x20e */
	{ 0x211, 0x211 }, /* 0x210 */
	{ 0x213, 0x213 }, /* 0x212 */
	{ 0x215, 0x215 }, /* 0x214 */
	{ 0x217, 0x217 }, /* 0x216 */
	{ 0x219, 0x219 }, /* 0x218 */
	{ 0x21b, 0x21b }, /* 0x21a */
	{ 0x21d, 0x21d }, /* 0x21c */
	{ 0x21f, 0x21f }, /* 0x21e */
	{ 0x223, 0x223 }, /* 0x222 */
	{ 0x225, 0x225 }, /* 0x224 */
	{ 0x227, 0x227 }, /* 0x226 */
	{ 0x229, 0x229 }, /* 0x228 */
	{ 0x22b, 0x22b }, /* 0x22a */
	{ 0x22d, 0x22d }, /* 0x22c */
	{ 0x22f, 0x22f }, /* 0x22e */
	{ 0x231, 0x231 }, /* 0x230 */
	{ 0x233, 0x233 }, /* 0x232 */
	{ 0x23c, 0x23c }, /* 0x23b */
	{ 0x23f, 0x240 }, /* 0x2c7e */
	{ 0x242, 0x242 }, /* 0x241 */
	{ 0x247, 0x247 }, /* 0x246 */
	{ 0x249, 0x249 }, /* 0x248 */
	{ 0x24b, 0x24b }, /* 0x24a */
	{ 0x24d, 0x24d }, /* 0x24c */
	{ 0x24f, 0x24f }, /* 0x24e */
	{ 0x250, 0x250 }, /* 0x2c6f */
	{ 0x251, 0x251 }, /* 0x2c6d */
	{ 0x252, 0x252 }, /* 0x2c70 */
	{ 0x253, 0x253 }, /* 0x181 */
	{ 0x254, 0x254 }, /* 0x186 */
	{ 0x256, 0x257 }, /* 0x189 */
	{ 0x259, 0x259 }, /* 0x18f */
	{ 0x25b, 0x25b }, /* 0x190 */
	{ 0x25c, 0x25c }, /* 0xa7ab */
	{ 0x260, 0x260 }, /* 0x193 */
	{ 0x261, 0x261 }, /* 0xa7ac */
	{ 0x263, 0x263 }, /* 0x194 */
	{ 0x265, 0x265 }, /* 0xa78d */
	{ 0x266, 0x266 }, /* 0xa7aa */
	{ 0x268, 0x268 }, /* 0x197 */
	{ 0x269, 0x269 }, /* 0x196 */
	{ 0x26a, 0x26a }, /* 0xa7ae */
	{ 0x26b, 0x26b }, /* 0x2c62 */
	{ 0x26c, 0x26c }, /* 0xa7ad */
	{ 0x26f, 0x26f }, /* 0x19c */
	{ 0x271, 0x271 }, /* 0x2c6e */
	{ 0x272, 0x272 }, /* 0x19d */
	{ 0x275, 0x275 }, /* 0x19f */
	{ 0x27d, 0x27d }, /* 0x2c64 */
	{ 0x280, 0x280 }, /* 0x1a6 */
	{ 0x283, 0x283 }, /* 0x1a9 */
	{ 0x287, 0x287 }, /* 0xa7b1 */
	{ 0x288, 0x288 }, /* 0x1ae */
	{ 0x289, 0x289 }, /* 0x244 */
	{ 0x28a, 0x28b }, /* 0x1b1 */
	{ 0x28c, 0x28c }, /* 0x245 */
	{ 0x292, 0x292 }, /* 0x1b7 */
	{ 0x29d, 0x29d }, /* 0xa7b2 */
	{ 0x29e, 0x29e }, /* 0xa7b0 */
	{ 0x345, 0x345 }, /* 0x399 */
	{ 0x371, 0x371 }, /* 0x370 */
	{ 0x373, 0x373 }, /* 0x372 */
	{ 0x377, 0x377 }, /* 0x376 */
	{ 0x37b, 0x37d }, /* 0x3fd */
	{ 0x3ac, 0x3ac }, /* 0x386 */
	{ 0x3ad, 0x3af }, /* 0x388 */
	{ 0x3b1, 0x3c1 }, /* 0x391 */
	{ 0x3c2, 0x3c2 }, /* 0x3a3 */
	{ 0x3c3, 0x3cb }, /* 0x3a3 */
	{ 0x3cc, 0x3cc }, /* 0x38c */
	{ 0x3cd, 0x3ce }, /* 0x38e */
	{ 0x3d0, 0x3d0 }, /* 0x392 */
	{ 0x3d1, 0x3d1 }, /* 0x398 */
	{ 0x3d5, 0x3d5 }, /* 0x3a6 */
	{ 0x3d6, 0x3d6 }, /* 0x3a0 */
	{ 0x3d7, 0x3d7 }, /* 0x3cf */
	{ 0x3d9, 0x3d9 }, /* 0x3d8 */
	{ 0x3db, 0x3db }, /* 0x3da */
	{ 0x3dd, 0x3dd }, /* 0x3dc */
	{ 0x3df, 0x3df }, /* 0x3de */
	{ 0x3e1, 0x3e1 }, /* 0x3e0 */
	{ 0x3e3, 0x3e3 }, /* 0x3e2 */
	{ 0x3e5, 0x3e5 }, /* 0x3e4 */
	{ 0x3e7, 0x3e7 }, /* 0x3e6 */
	{ 0x3e9, 0x3e9 }, /* 0x3e8 */
	{ 0x3eb, 0x3eb }, /* 0x3ea */
	{ 0x3ed, 0x3ed }, /* 0x3ec */
	{ 0x3ef, 0x3ef }, /* 0x3ee */
	{ 0x3f0, 0x3f0 }, /* 0x39a */
	{ 0x3f1, 0x3f1 }, /* 0x3a1 */
	{ 0x3f2, 0x3f2 }, /* 0x3f9 */
	{ 0x3f3, 0x3f3 }, /* 0x37f */
	{ 0x3f5, 0x3f5 }, /* 0x395 */
	{ 0x3f8, 0x3f8 }, /* 0x3f7 */
	{ 0x3fb, 0x3fb }, /* 0x3fa */
	{ 0x430, 0x44f }, /* 0x410 */
	{ 0x450, 0x45f }, /* 0x400 */
	{ 0x461, 0x461 }, /* 0x460 */
	{ 0x463, 0x463 }, /* 0x462 */
	{ 0x465, 0x465 }, /* 0x464 */
	{ 0x467, 0x467 }, /* 0x466 */
	{ 0x469, 0x469 }, /* 0x468 */
	{ 0x46b, 0x46b }, /* 0x46a */
	{ 0x46d, 0x46d }, /* 0x46c */
	{ 0x46f, 0x46f }, /* 0x46e */
	{ 0x471, 0x471 }, /* 0x470 */
	{ 0x473, 0x473 }, /* 0x472 */
	{ 0x475, 0x475 }, /* 0x474 */
	{ 0x477, 0x477 }, /* 0x476 */
	{ 0x479, 0x479 }, /* 0x478 */
	{ 0x47b, 0x47b }, /* 0x47a */
	{ 0x47d, 0x47d }, /* 0x47c */
	{ 0x47f, 0x47f }, /* 0x47e */
	{ 0x481, 0x481 }, /* 0x480 */
	{ 0x48b, 0x48b }, /* 0x48a */
	{ 0x48d, 0x48d }, /* 0x48c */
	{ 0x48f, 0x48f }, /* 0x48e */
	{ 0x491, 0x491 }, /* 0x490 */
	{ 0x493, 0x493 }, /* 0x492 */
	{ 0x495, 0x495 }, /* 0x494 */
	{ 0x497, 0x497 }, /* 0x496 */
	{ 0x499, 0x499 }, /* 0x498 */
	{ 0x49b, 0x49b }, /* 0x49a */
	{ 0x49d, 0x49d }, /* 0x49c */
	{ 0x49f, 0x49f }, /* 0x49e */
	{ 0x4a1, 0x4a1 }, /* 0x4a0 */
	{ 0x4a3, 0x4a3 }, /* 0x4a2 */
	{ 0x4a5, 0x4a5 }, /* 0x4a4 */
	{ 0x4a7, 0x4a7 }, /* 0x4a6 */
	{ 0x4a9, 0x4a9 }, /* 0x4a8 */
	{ 0x4ab, 0x4ab }, /* 0x4aa */
	{ 0x4ad, 0x4ad }, /* 0x4ac */
	{ 0x4af, 0x4af }, /* 0x4ae */
	{ 0x4b1, 0x4b1 }, /* 0x4b0 */
	{ 0x4b3, 0x4b3 }, /* 0x4b2 */
	{ 0x4b5, 0x4b5 }, /* 0x4b4 */
	{ 0x4b7, 0x4b7 }, /* 0x4b6 */
	{ 0x4b9, 0x4b9 }, /* 0x4b8 */
	{ 0x4bb, 0x4bb }, /* 0x4ba */
	{ 0x4bd, 0x4bd }, /* 0x4bc */
	{ 0x4bf, 0x4bf }, /* 0x4be */
	{ 0x4c2, 0x4c2 }, /* 0x4c1 */
	{ 0x4c4, 0x4c4 }, /* 0x4c3 */
	{ 0x4c6, 0x4c6 }, /* 0x4c5 */
	{ 0x4c8, 0x4c8 }, /* 0x4c7 */
	{ 0x4ca, 0x4ca }, /* 0x4c9 */
	{ 0x4cc, 0x4cc }, /* 0x4cb */
	{ 0x4ce, 0x4ce }, /* 0x4cd */
	{ 0x4cf, 0x4cf }, /* 0x4c0 */
	{ 0x4d1, 0x4d1 }, /* 0x4d0 */
	{ 0x4d3, 0x4d3 }, /* 0x4d2 */
	{ 0x4d5, 0x4d5 }, /* 0x4d4 */
	{ 0x4d7, 0x4d7 }, /* 0x4d6 */
	{ 0x4d9, 0x4d9 }, /* 0x4d8 */
	{ 0x4db, 0x4db }, /* 0x4da */
	{ 0x4dd, 0x4dd }, /* 0x4dc */
	{ 0x4df, 0x4df }, /* 0x4de */
	{ 0x4e1, 0x4e1 }, /* 0x4e0 */
	{ 0x4e3, 0x4e3 }, /* 0x4e2 */
	{ 0x4e5, 0x4e5 }, /* 0x4e4 */
	{ 0x4e7, 0x4e7 }, /* 0x4e6 */
	{ 0x4e9, 0x4e9 }, /* 0x4e8 */
	{ 0x4eb, 0x4eb }, /* 0x4ea */
	{ 0x4ed, 0x4ed }, /* 0x4ec */
	{ 0x4ef, 0x4ef }, /* 0x4ee */
	{ 0x4f1, 0x4f1 }, /* 0x4f0 */
	{ 0x4f3, 0x4f3 }, /* 0x4f2 */
	{ 0x4f5, 0x4f5 }, /* 0x4f4 */
	{ 0x4f7, 0x4f7 }, /* 0x4f6 */
	{ 0x4f9, 0x4f9 }, /* 0x4f8 */
	{ 0x4fb, 0x4fb }, /* 0x4fa */
	{ 0x4fd, 0x4fd }, /* 0x4fc */
	{ 0x4ff, 0x4ff }, /* 0x4fe */
	{ 0x501, 0x501 }, /* 0x500 */
	{ 0x503, 0x503 }, /* 0x502 */
	{ 0x505, 0x505 }, /* 0x504 */
	{ 0x507, 0x507 }, /* 0x506 */
	{ 0x509, 0x509 }, /* 0x508 */
	{ 0x50b, 0x50b }, /* 0x50a */
	{ 0x50d, 0x50d }, /* 0x50c */
	{ 0x50f, 0x50f }, /* 0x50e */
	{ 0x511, 0x511 }, /* 0x510 */
	{ 0x513, 0x513 }, /* 0x512 */
	{ 0x515, 0x515 }, /* 0x514 */
	{ 0x517, 0x517 }, /* 0x516 */
	{ 0x519, 0x519 }, /* 0x518 */
	{ 0x51b, 0x51b }, /* 0x51a */
	{ 0x51d, 0x51d }, /* 0x51c */
	{ 0x51f, 0x51f }, /* 0x51e */
	{ 0x521, 0x521 }, /* 0x520 */
	{ 0x523, 0x523 }, /* 0x522 */
	{ 0x525, 0x525 }, /* 0x524 */
	{ 0x527, 0x527 }, /* 0x526 */
	{ 0x529, 0x529 }, /* 0x528 */
	{ 0x52b, 0x52b }, /* 0x52a */
	{ 0x52d, 0x52d }, /* 0x52c */
	{ 0x52f, 0x52f }, /* 0x52e */
	{ 0x561, 0x586 }, /* 0x531 */
	{ 0x13f8, 0x13fd }, /* 0x13f0 */
	{ 0x1c80, 0x1c80 }, /* 0x412 */
	{ 0x1c81, 0x1c81 }, /* 0x414 */
	{ 0x1c82, 0x1c82 }, /* 0x41e */
	{ 0x1c83, 0x1c84 }, /* 0x421 */
	{ 0x1c85, 0x1c85 }, /* 0x422 */
	{ 0x1c86, 0x1c86 }, /* 0x42a */
	{ 0x1c87, 0x1c87 }, /* 0x462 */
	{ 0x1c88, 0x1c88 }, /* 0xa64a */
	{ 0x1d79, 0x1d79 }, /* 0xa77d */
	{ 0x1d7d, 0x1d7d }, /* 0x2c63 */
	{ 0x1e01, 0x1e01 }, /* 0x1e00 */
	{ 0x1e03, 0x1e03 }, /* 0x1e02 */
	{ 0x1e05, 0x1e05 }, /* 0x1e04 */
	{ 0x1e07, 0x1e07 }, /* 0x1e06 */
	{ 0x1e09, 0x1e09 }, /* 0x1e08 */
	{ 0x1e0b, 0x1e0b }, /* 0x1e0a */
	{ 0x1e0d, 0x1e0d }, /* 0x1e0c */
	{ 0x1e0f, 0x1e0f }, /* 0x1e0e */
	{ 0x1e11, 0x1e11 }, /* 0x1e10 */
	{ 0x1e13, 0x1e13 }, /* 0x1e12 */
	{ 0x1e15, 0x1e15 }, /* 0x1e14 */
	{ 0x1e17, 0x1e17 }, /* 0x1e16 */
	{ 0x1e19, 0x1e19 }, /* 0x1e18 */
	{ 0x1e1b, 0x1e1b }, /* 0x1e1a */
	{ 0x1e1d, 0x1e1d }, /* 0x1e1c */
	{ 0x1e1f, 0x1e1f }, /* 0x1e1e */
	{ 0x1e21, 0x1e21 }, /* 0x1e20 */
	{ 0x1e23, 0x1e23 }, /* 0x1e22 */
	{ 0x1e25, 0x1e25 }, /* 0x1e24 */
	{ 0x1e27, 0x1e27 }, /* 0x1e26 */
	{ 0x1e29, 0x1e29 }, /* 0x1e28 */
	{ 0x1e2b, 0x1e2b }, /* 0x1e2a */
	{ 0x1e2d, 0x1e2d }, /* 0x1e2c */
	{ 0x1e2f, 0x1e2f }, /* 0x1e2e */
	{ 0x1e31, 0x1e31 }, /* 0x1e30 */
	{ 0x1e33, 0x1e33 }, /* 0x1e32 */
	{ 0x1e35, 0x1e35 }, /* 0x1e34 */
	{ 0x1e37, 0x1e37 }, /* 0x1e36 */
	{ 0x1e39, 0x1e39 }, /* 0x1e38 */
	{ 0x1e3b, 0x1e3b }, /* 0x1e3a */
	{ 0x1e3d, 0x1e3d }, /* 0x1e3c */
	{ 0x1e3f, 0x1e3f }, /* 0x1e3e */
	{ 0x1e41, 0x1e41 }, /* 0x1e40 */
	{ 0x1e43, 0x1e43 }, /* 0x1e42 */
	{ 0x1e45, 0x1e45 }, /* 0x1e44 */
	{ 0x1e47, 0x1e47 }, /* 0x1e46 */
	{ 0x1e49, 0x1e49 }, /* 0x1e48 */
	{ 0x1e4b, 0x1e4b }, /* 0x1e4a */
	{ 0x1e4d, 0x1e4d }, /* 0x1e4c */
	{ 0x1e4f, 0x1e4f }, /* 0x1e4e */
	{ 0x1e51, 0x1e51 }, /* 0x1e50 */
	{ 0x1e53, 0x1e53 }, /* 0x1e52 */
	{ 0x1e55, 0x1e55 }, /* 0x1e54 */
	{ 0x1e57, 0x1e57 }, /* 0x1e56 */
	{ 0x1e59, 0x1e59 }, /* 0x1e58 */
	{ 0x1e5b, 0x1e5b }, /* 0x1e5a */
	{ 0x1e5d, 0x1e5d }, /* 0x1e5c */
	{ 0x1e5f, 0x1e5f }, /* 0x1e5e */
	{ 0x1e61, 0x1e61 }, /* 0x1e60 */
	{ 0x1e63, 0x1e63 }, /* 0x1e62 */
	{ 0x1e65, 0x1e65 }, /* 0x1e64 */
	{ 0x1e67, 0x1e67 }, /* 0x1e66 */
	{ 0x1e69, 0x1e69 }, /* 0x1e68 */
	{ 0x1e6b, 0x1e6b }, /* 0x1e6a */
	{ 0x1e6d, 0x1e6d }, /* 0x1e6c */
	{ 0x1e6f, 0x1e6f }, /* 0x1e6e */
	{ 0x1e71, 0x1e71 }, /* 0x1e70 */
	{ 0x1e73, 0x1e73 }, /* 0x1e72 */
	{ 0x1e75, 0x1e75 }, /* 0x1e74 */
	{ 0x1e77, 0x1e77 }, /* 0x1e76 */
	{ 0x1e79, 0x1e79 }, /* 0x1e78 */
	{ 0x1e7b, 0x1e7b }, /* 0x1e7a */
	{ 0x1e7d, 0x1e7d }, /* 0x1e7c */
	{ 0x1e7f, 0x1e7f }, /* 0x1e7e */
	{ 0x1e81, 0x1e81 }, /* 0x1e80 */
	{ 0x1e83, 0x1e83 }, /* 0x1e82 */
	{ 0x1e85, 0x1e85 }, /* 0x1e84 */
	{ 0x1e87, 0x1e87 }, /* 0x1e86 */
	{ 0x1e89, 0x1e89 }, /* 0x1e88 */
	{ 0x1e8b, 0x1e8b }, /* 0x1e8a */
	{ 0x1e8d, 0x1e8d }, /* 0x1e8c */
	{ 0x1e8f, 0x1e8f }, /* 0x1e8e */
	{ 0x1e91, 0x1e91 }, /* 0x1e90 */
	{ 0x1e93, 0x1e93 }, /* 0x1e92 */
	{ 0x1e95, 0x1e95 }, /* 0x1e94 */
	{ 0x1e9b, 0x1e9b }, /* 0x1e60 */
	{ 0x1ea1, 0x1ea1 }, /* 0x1ea0 */
	{ 0x1ea3, 0x1ea3 }, /* 0x1ea2 */
	{ 0x1ea5, 0x1ea5 }, /* 0x1ea4 */
	{ 0x1ea7, 0x1ea7 }, /* 0x1ea6 */
	{ 0x1ea9, 0x1ea9 }, /* 0x1ea8 */
	{ 0x1eab, 0x1eab }, /* 0x1eaa */
	{ 0x1ead, 0x1ead }, /* 0x1eac */
	{ 0x1eaf, 0x1eaf }, /* 0x1eae */
	{ 0x1eb1, 0x1eb1 }, /* 0x1eb0 */
	{ 0x1eb3, 0x1eb3 }, /* 0x1eb2 */
	{ 0x1eb5, 0x1eb5 }, /* 0x1eb4 */
	{ 0x1eb7, 0x1eb7 }, /* 0x1eb6 */
	{ 0x1eb9, 0x1eb9 }, /* 0x1eb8 */
	{ 0x1ebb, 0x1ebb }, /* 0x1eba */
	{ 0x1ebd, 0x1ebd }, /* 0x1ebc */
	{ 0x1ebf, 0x1ebf }, /* 0x1ebe */
	{ 0x1ec1, 0x1ec1 }, /* 0x1ec0 */
	{ 0x1ec3, 0x1ec3 }, /* 0x1ec2 */
	{ 0x1ec5, 0x1ec5 }, /* 0x1ec4 */
	{ 0x1ec7, 0x1ec7 }, /* 0x1ec6 */
	{ 0x1ec9, 0x1ec9 }, /* 0x1ec8 */
	{ 0x1ecb, 0x1ecb }, /* 0x1eca */
	{ 0x1ecd, 0x1ecd }, /* 0x1ecc */
	{ 0x1ecf, 0x1ecf }, /* 0x1ece */
	{ 0x1ed1, 0x1ed1 }, /* 0x1ed0 */
	{ 0x1ed3, 0x1ed3 }, /* 0x1ed2 */
	{ 0x1ed5, 0x1ed5 }, /* 0x1ed4 */
	{ 0x1ed7, 0x1ed7 }, /* 0x1ed6 */
	{ 0x1ed9, 0x1ed9 }, /* 0x1ed8 */
	{ 0x1edb, 0x1edb }, /* 0x1eda */
	{ 0x1edd, 0x1edd }, /* 0x1edc */
	{ 0x1edf, 0x1edf }, /* 0x1ede */
	{ 0x1ee1, 0x1ee1 }, /* 0x1ee0 */
	{ 0x1ee3, 0x1ee3 }, /* 0x1ee2 */
	{ 0x1ee5, 0x1ee5 }, /* 0x1ee4 */
	{ 0x1ee7, 0x1ee7 }, /* 0x1ee6 */
	{ 0x1ee9, 0x1ee9 }, /* 0x1ee8 */
	{ 0x1eeb, 0x1eeb }, /* 0x1eea */
	{ 0x1eed, 0x1eed }, /* 0x1eec */
	{ 0x1eef, 0x1eef }, /* 0x1eee */
	{ 0x1ef1, 0x1ef1 }, /* 0x1ef0 */
	{ 0x1ef3, 0x1ef3 }, /* 0x1ef2 */
	{ 0x1ef5, 0x1ef5 }, /* 0x1ef4 */
	{ 0x1ef7, 0x1ef7 }, /* 0x1ef6 */
	{ 0x1ef9, 0x1ef9 }, /* 0x1ef8 */
	{ 0x1efb, 0x1efb }, /* 0x1efa */
	{ 0x1efd, 0x1efd }, /* 0x1efc */
	{ 0x1eff, 0x1eff }, /* 0x1efe */
	{ 0x1f00, 0x1f07 }, /* 0x1f08 */
	{ 0x1f10, 0x1f15 }, /* 0x1f18 */
	{ 0x1f20, 0x1f27 }, /* 0x1f28 */
	{ 0x1f30, 0x1f37 }, /* 0x1f38 */
	{ 0x1f40, 0x1f45 }, /* 0x1f48 */
	{ 0x1f51, 0x1f51 }, /* 0x1f59 */
	{ 0x1f53, 0x1f53 }, /* 0x1f5b */
	{ 0x1f55, 0x1f55 }, /* 0x1f5d */
	{ 0x1f57, 0x1f57 }, /* 0x1f5f */
	{ 0x1f60, 0x1f67 }, /* 0x1f68 */
	{ 0x1f70, 0x1f71 }, /* 0x1fba */
	{ 0x1f72, 0x1f75 }, /* 0x1fc8 */
	{ 0x1f76, 0x1f77 }, /* 0x1fda */
	{ 0x1f78, 0x1f79 }, /* 0x1ff8 */
	{ 0x1f7a, 0x1f7b }, /* 0x1fea */
	{ 0x1f7c, 0x1f7d }, /* 0x1ffa */
	{ 0x1f80, 0x1f87 }, /* 0x1f88 */
	{ 0x1f90, 0x1f97 }, /* 0x1f98 */
	{ 0x1fa0, 0x1fa7 }, /* 0x1fa8 */
	{ 0x1fb0, 0x1fb1 }, /* 0x1fb8 */
	{ 0x1fb3, 0x1fb3 }, /* 0x1fbc */
	{ 0x1fbe, 0x1fbe }, /* 0x399 */
	{ 0x1fc3, 0x1fc3 }, /* 0x1fcc */
	{ 0x1fd0, 0x1fd1 }, /* 0x1fd8 */
	{ 0x1fe0, 0x1fe1 }, /* 0x1fe8 */
	{ 0x1fe5, 0x1fe5 }, /* 0x1fec */
	{ 0x1ff3, 0x1ff3 }, /* 0x1ffc */
	{ 0x214e, 0x214e }, /* 0x2132 */
	{ 0x2170, 0x217f }, /* 0x2160 */
	{ 0x2184, 0x2184 }, /* 0x2183 */
	{ 0x24d0, 0x24e9 }, /* 0x24b6 */
	{ 0x2c30, 0x2c5e }, /* 0x2c00 */
	{ 0x2c61, 0x2c61 }, /* 0x2c60 */
	{ 0x2c65, 0x2c65 }, /* 0x23a */
	{ 0x2c66, 0x2c66 }, /* 0x23e */
	{ 0x2c68, 0x2c68 }, /* 0x2c67 */
	{ 0x2c6a, 0x2c6a }, /* 0x2c69 */
	{ 0x2c6c, 0x2c6c }, /* 0x2c6b */
	{ 0x2c73, 0x2c73 }, /* 0x2c72 */
	{ 0x2c76, 0x2c76 }, /* 0x2c75 */
	{ 0x2c81, 0x2c81 }, /* 0x2c80 */
	{ 0x2c83, 0x2c83 }, /* 0x2c82 */
	{ 0x2c85, 0x2c85 }, /* 0x2c84 */
	{ 0x2c87, 0x2c87 }, /* 0x2c86 */
	{ 0x2c89, 0x2c89 }, /* 0x2c88 */
	{ 0x2c8b, 0x2c8b }, /* 0x2c8a */
	{ 0x2c8d, 0x2c8d }, /* 0x2c8c */
	{ 0x2c8f, 0x2c8f }, /* 0x2c8e */
	{ 0x2c91, 0x2c91 }, /* 0x2c90 */
	{ 0x2c93, 0x2c93 }, /* 0x2c92 */
	{ 0x2c95, 0x2c95 }, /* 0x2c94 */
	{ 0x2c97, 0x2c97 }, /* 0x2c96 */
	{ 0x2c99, 0x2c99 }, /* 0x2c98 */
	{ 0x2c9b, 0x2c9b }, /* 0x2c9a */
	{ 0x2c9d, 0x2c9d }, /* 0x2c9c */
	{ 0x2c9f, 0x2c9f }, /* 0x2c9e */
	{ 0x2ca1, 0x2ca1 }, /* 0x2ca0 */
	{ 0x2ca3, 0x2ca3 }, /* 0x2ca2 */
	{ 0x2ca5, 0x2ca5 }, /* 0x2ca4 */
	{ 0x2ca7, 0x2ca7 }, /* 0x2ca6 */
	{ 0x2ca9, 0x2ca9 }, /* 0x2ca8 */
	{ 0x2cab, 0x2cab }, /* 0x2caa */
	{ 0x2cad, 0x2cad }, /* 0x2cac */
	{ 0x2caf, 0x2caf }, /* 0x2cae */
	{ 0x2cb1, 0x2cb1 }, /* 0x2cb0 */
	{ 0x2cb3, 0x2cb3 }, /* 0x2cb2 */
	{ 0x2cb5, 0x2cb5 }, /* 0x2cb4 */
	{ 0x2cb7, 0x2cb7 }, /* 0x2cb6 */
	{ 0x2cb9, 0x2cb9 }, /* 0x2cb8 */
	{ 0x2cbb, 0x2cbb }, /* 0x2cba */
	{ 0x2cbd, 0x2cbd }, /* 0x2cbc */
	{ 0x2cbf, 0x2cbf }, /* 0x2cbe */
	{ 0x2cc1, 0x2cc1 }, /* 0x2cc0 */
	{ 0x2cc3, 0x2cc3 }, /* 0x2cc2 */
	{ 0x2cc5, 0x2cc5 }, /* 0x2cc4 */
	{ 0x2cc7, 0x2cc7 }, /* 0x2cc6 */
	{ 0x2cc9, 0x2cc9 }, /* 0x2cc8 */
	{ 0x2ccb, 0x2ccb }, /* 0x2cca */
	{ 0x2ccd, 0x2ccd }, /* 0x2ccc */
	{ 0x2ccf, 0x2ccf }, /* 0x2cce */
	{ 0x2cd1, 0x2cd1 }, /* 0x2cd0 */
	{ 0x2cd3, 0x2cd3 }, /* 0x2cd2 */
	{ 0x2cd5, 0x2cd5 }, /* 0x2cd4 */
	{ 0x2cd7, 0x2cd7 }, /* 0x2cd6 */
	{ 0x2cd9, 0x2cd9 }, /* 0x2cd8 */
	{ 0x2cdb, 0x2cdb }, /* 0x2cda */
	{ 0x2cdd, 0x2cdd }, /* 0x2cdc */
	{ 0x2cdf, 0x2cdf }, /* 0x2cde */
	{ 0x2ce1, 0x2ce1 }, /* 0x2ce0 */
	{ 0x2ce3, 0x2ce3 }, /* 0x2ce2 */
	{ 0x2cec, 0x2cec }, /* 0x2ceb */
	{ 0x2cee, 0x2cee }, /* 0x2ced */
	{ 0x2cf3, 0x2cf3 }, /* 0x2cf2 */
	{ 0x2d00, 0x2d25 }, /* 0x10a0 */
	{ 0x2d27, 0x2d27 }, /* 0x10c7 */
	{ 0x2d2d, 0x2d2d }, /* 0x10cd */
	{ 0xa641, 0xa641 }, /* 0xa640 */
	{ 0xa643, 0xa643 }, /* 0xa642 */
	{ 0xa645, 0xa645 }, /* 0xa644 */
	{ 0xa647, 0xa647 }, /* 0xa646 */
	{ 0xa649, 0xa649 }, /* 0xa648 */
	{ 0xa64b, 0xa64b }, /* 0xa64a */
	{ 0xa64d, 0xa64d }, /* 0xa64c */
	{ 0xa64f, 0xa64f }, /* 0xa64e */
	{ 0xa651, 0xa651 }, /* 0xa650 */
	{ 0xa653, 0xa653 }, /* 0xa652 */
	{ 0xa655, 0xa655 }, /* 0xa654 */
	{ 0xa657, 0xa657 }, /* 0xa656 */
	{ 0xa659, 0xa659 }, /* 0xa658 */
	{ 0xa65b, 0xa65b }, /* 0xa65a */
	{ 0xa65d, 0xa65d }, /* 0xa65c */
	{ 0xa65f, 0xa65f }, /* 0xa65e */
	{ 0xa661, 0xa661 }, /* 0xa660 */
	{ 0xa663, 0xa663 }, /* 0xa662 */
	{ 0xa665, 0xa665 }, /* 0xa664 */
	{ 0xa667, 0xa667 }, /* 0xa666 */
	{ 0xa669, 0xa669 }, /* 0xa668 */
	{ 0xa66b, 0xa66b }, /* 0xa66a */
	{ 0xa66d, 0xa66d }, /* 0xa66c */
	{ 0xa681, 0xa681 }, /* 0xa680 */
	{ 0xa683, 0xa683 }, /* 0xa682 */
	{ 0xa685, 0xa685 }, /* 0xa684 */
	{ 0xa687, 0xa687 }, /* 0xa686 */
	{ 0xa689, 0xa689 }, /* 0xa688 */
	{ 0xa68b, 0xa68b }, /* 0xa68a */
	{ 0xa68d, 0xa68d }, /* 0xa68c */
	{ 0xa68f, 0xa68f }, /* 0xa68e */
	{ 0xa691, 0xa691 }, /* 0xa690 */
	{ 0xa693, 0xa693 }, /* 0xa692 */
	{ 0xa695, 0xa695 }, /* 0xa694 */
	{ 0xa697, 0xa697 }, /* 0xa696 */
	{ 0xa699, 0xa699 }, /* 0xa698 */
	{ 0xa69b, 0xa69b }, /* 0xa69a */
	{ 0xa723, 0xa723 }, /* 0xa722 */
	{ 0xa725, 0xa725 }, /* 0xa724 */
	{ 0xa727, 0xa727 }, /* 0xa726 */
	{ 0xa729, 0xa729 }, /* 0xa728 */
	{ 0xa72b, 0xa72b }, /* 0xa72a */
	{ 0xa72d, 0xa72d }, /* 0xa72c */
	{ 0xa72f, 0xa72f }, /* 0xa72e */
	{ 0xa733, 0xa733 }, /* 0xa732 */
	{ 0xa735, 0xa735 }, /* 0xa734 */
	{ 0xa737, 0xa737 }, /* 0xa736 */
	{ 0xa739, 0xa739 }, /* 0xa738 */
	{ 0xa73b, 0xa73b }, /* 0xa73a */
	{ 0xa73d, 0xa73d }, /* 0xa73c */
	{ 0xa73f, 0xa73f }, /* 0xa73e */
	{ 0xa741, 0xa741 }, /* 0xa740 */
	{ 0xa743, 0xa743 }, /* 0xa742 */
	{ 0xa745, 0xa745 }, /* 0xa744 */
	{ 0xa747, 0xa747 }, /* 0xa746 */
	{ 0xa749, 0xa749 }, /* 0xa748 */
	{ 0xa74b, 0xa74b }, /* 0xa74a */
	{ 0xa74d, 0xa74d }, /* 0xa74c */
	{ 0xa74f, 0xa74f }, /* 0xa74e */
	{ 0xa751, 0xa751 }, /* 0xa750 */
	{ 0xa753, 0xa753 }, /* 0xa752 */
	{ 0xa755, 0xa755 }, /* 0xa754 */
	{ 0xa757, 0xa757 }, /* 0xa756 */
	{ 0xa759, 0xa759 }, /* 0xa758 */
	{ 0xa75b, 0xa75b }, /* 0xa75a */
	{ 0xa75d, 0xa75d }, /* 0xa75c */
	{ 0xa75f, 0xa75f }, /* 0xa75e */
	{ 0xa761, 0xa761 }, /* 0xa760 */
	{ 0xa763, 0xa763 }, /* 0xa762 */
	{ 0xa765, 0xa765 }, /* 0xa764 */
	{ 0xa767, 0xa767 }, /* 0xa766 */
	{ 0xa769, 0xa769 }, /* 0xa768 */
	{ 0xa76b, 0xa76b }, /* 0xa76a */
	{ 0xa76d, 0xa76d }, /* 0xa76c */
	{ 0xa76f, 0xa76f }, /* 0xa76e */
	{ 0xa77a, 0xa77a }, /* 0xa779 */
	{ 0xa77c, 0xa77c }, /* 0xa77b */
	{ 0xa77f, 0xa77f }, /* 0xa77e */
	{ 0xa781, 0xa781 }, /* 0xa780 */
	{ 0xa783, 0xa783 }, /* 0xa782 */
	{ 0xa785, 0xa785 }, /* 0xa784 */
	{ 0xa787, 0xa787 }, /* 0xa786 */
	{ 0xa78c, 0xa78c }, /* 0xa78b */
	{ 0xa791, 0xa791 }, /* 0xa790 */
	{ 0xa793, 0xa793 }, /* 0xa792 */
	{ 0xa797, 0xa797 }, /* 0xa796 */
	{ 0xa799, 0xa799 }, /* 0xa798 */
	{ 0xa79b, 0xa79b }, /* 0xa79a */
	{ 0xa79d, 0xa79d }, /* 0xa79c */
	{ 0xa79f, 0xa79f }, /* 0xa79e */
	{ 0xa7a1, 0xa7a1 }, /* 0xa7a0 */
	{ 0xa7a3, 0xa7a3 }, /* 0xa7a2 */
	{ 0xa7a5, 0xa7a5 }, /* 0xa7a4 */
	{ 0xa7a7, 0xa7a7 }, /* 0xa7a6 */
	{ 0xa7a9, 0xa7a9 }, /* 0xa7a8 */
	{ 0xa7b5, 0xa7b5 }, /* 0xa7b4 */
	{ 0xa7b7, 0xa7b7 }, /* 0xa7b6 */
	{ 0xab53, 0xab53 }, /* 0xa7b3 */
	{ 0xab70, 0xabbf }, /* 0x13a0 */
	{ 0xff41, 0xff5a }, /* 0xff21 */
	{ 0x10428, 0x1044f }, /* 0x10400 */
	{ 0x104d8, 0x104fb }, /* 0x104b0 */
	{ 0x10cc0, 0x10cf2 }, /* 0x10c80 */
	{ 0x118c0, 0x118df }, /* 0x118a0 */
	{ 0x1e922, 0x1e943 }, /* 0x1e900 */
	{ 0x0, 0x0 }
};
int toupper_cvt[] = {
	0x41, /* 0x61..0x7a */
	0x39c, /* 0xb5..0xb5 */
	0xc0, /* 0xe0..0xf6 */
	0xd8, /* 0xf8..0xfe */
	0x178, /* 0xff..0xff */
	0x100, /* 0x101..0x101 */
	0x102, /* 0x103..0x103 */
	0x104, /* 0x105..0x105 */
	0x106, /* 0x107..0x107 */
	0x108, /* 0x109..0x109 */
	0x10a, /* 0x10b..0x10b */
	0x10c, /* 0x10d..0x10d */
	0x10e, /* 0x10f..0x10f */
	0x110, /* 0x111..0x111 */
	0x112, /* 0x113..0x113 */
	0x114, /* 0x115..0x115 */
	0x116, /* 0x117..0x117 */
	0x118, /* 0x119..0x119 */
	0x11a, /* 0x11b..0x11b */
	0x11c, /* 0x11d..0x11d */
	0x11e, /* 0x11f..0x11f */
	0x120, /* 0x121..0x121 */
	0x122, /* 0x123..0x123 */
	0x124, /* 0x125..0x125 */
	0x126, /* 0x127..0x127 */
	0x128, /* 0x129..0x129 */
	0x12a, /* 0x12b..0x12b */
	0x12c, /* 0x12d..0x12d */
	0x12e, /* 0x12f..0x12f */
	0x49, /* 0x131..0x131 */
	0x132, /* 0x133..0x133 */
	0x134, /* 0x135..0x135 */
	0x136, /* 0x137..0x137 */
	0x139, /* 0x13a..0x13a */
	0x13b, /* 0x13c..0x13c */
	0x13d, /* 0x13e..0x13e */
	0x13f, /* 0x140..0x140 */
	0x141, /* 0x142..0x142 */
	0x143, /* 0x144..0x144 */
	0x145, /* 0x146..0x146 */
	0x147, /* 0x148..0x148 */
	0x14a, /* 0x14b..0x14b */
	0x14c, /* 0x14d..0x14d */
	0x14e, /* 0x14f..0x14f */
	0x150, /* 0x151..0x151 */
	0x152, /* 0x153..0x153 */
	0x154, /* 0x155..0x155 */
	0x156, /* 0x157..0x157 */
	0x158, /* 0x159..0x159 */
	0x15a, /* 0x15b..0x15b */
	0x15c, /* 0x15d..0x15d */
	0x15e, /* 0x15f..0x15f */
	0x160, /* 0x161..0x161 */
	0x162, /* 0x163..0x163 */
	0x164, /* 0x165..0x165 */
	0x166, /* 0x167..0x167 */
	0x168, /* 0x169..0x169 */
	0x16a, /* 0x16b..0x16b */
	0x16c, /* 0x16d..0x16d */
	0x16e, /* 0x16f..0x16f */
	0x170, /* 0x171..0x171 */
	0x172, /* 0x173..0x173 */
	0x174, /* 0x175..0x175 */
	0x176, /* 0x177..0x177 */
	0x179, /* 0x17a..0x17a */
	0x17b, /* 0x17c..0x17c */
	0x17d, /* 0x17e..0x17e */
	0x53, /* 0x17f..0x17f */
	0x243, /* 0x180..0x180 */
	0x182, /* 0x183..0x183 */
	0x184, /* 0x185..0x185 */
	0x187, /* 0x188..0x188 */
	0x18b, /* 0x18c..0x18c */
	0x191, /* 0x192..0x192 */
	0x1f6, /* 0x195..0x195 */
	0x198, /* 0x199..0x199 */
	0x23d, /* 0x19a..0x19a */
	0x220, /* 0x19e..0x19e */
	0x1a0, /* 0x1a1..0x1a1 */
	0x1a2, /* 0x1a3..0x1a3 */
	0x1a4, /* 0x1a5..0x1a5 */
	0x1a7, /* 0x1a8..0x1a8 */
	0x1ac, /* 0x1ad..0x1ad */
	0x1af, /* 0x1b0..0x1b0 */
	0x1b3, /* 0x1b4..0x1b4 */
	0x1b5, /* 0x1b6..0x1b6 */
	0x1b8, /* 0x1b9..0x1b9 */
	0x1bc, /* 0x1bd..0x1bd */
	0x1f7, /* 0x1bf..0x1bf */
	0x1c4, /* 0x1c5..0x1c5 */
	0x1c4, /* 0x1c6..0x1c6 */
	0x1c7, /* 0x1c8..0x1c8 */
	0x1c7, /* 0x1c9..0x1c9 */
	0x1ca, /* 0x1cb..0x1cb */
	0x1ca, /* 0x1cc..0x1cc */
	0x1cd, /* 0x1ce..0x1ce */
	0x1cf, /* 0x1d0..0x1d0 */
	0x1d1, /* 0x1d2..0x1d2 */
	0x1d3, /* 0x1d4..0x1d4 */
	0x1d5, /* 0x1d6..0x1d6 */
	0x1d7, /* 0x1d8..0x1d8 */
	0x1d9, /* 0x1da..0x1da */
	0x1db, /* 0x1dc..0x1dc */
	0x18e, /* 0x1dd..0x1dd */
	0x1de, /* 0x1df..0x1df */
	0x1e0, /* 0x1e1..0x1e1 */
	0x1e2, /* 0x1e3..0x1e3 */
	0x1e4, /* 0x1e5..0x1e5 */
	0x1e6, /* 0x1e7..0x1e7 */
	0x1e8, /* 0x1e9..0x1e9 */
	0x1ea, /* 0x1eb..0x1eb */
	0x1ec, /* 0x1ed..0x1ed */
	0x1ee, /* 0x1ef..0x1ef */
	0x1f1, /* 0x1f2..0x1f2 */
	0x1f1, /* 0x1f3..0x1f3 */
	0x1f4, /* 0x1f5..0x1f5 */
	0x1f8, /* 0x1f9..0x1f9 */
	0x1fa, /* 0x1fb..0x1fb */
	0x1fc, /* 0x1fd..0x1fd */
	0x1fe, /* 0x1ff..0x1ff */
	0x200, /* 0x201..0x201 */
	0x202, /* 0x203..0x203 */
	0x204, /* 0x205..0x205 */
	0x206, /* 0x207..0x207 */
	0x208, /* 0x209..0x209 */
	0x20a, /* 0x20b..0x20b */
	0x20c, /* 0x20d..0x20d */
	0x20e, /* 0x20f..0x20f */
	0x210, /* 0x211..0x211 */
	0x212, /* 0x213..0x213 */
	0x214, /* 0x215..0x215 */
	0x216, /* 0x217..0x217 */
	0x218, /* 0x219..0x219 */
	0x21a, /* 0x21b..0x21b */
	0x21c, /* 0x21d..0x21d */
	0x21e, /* 0x21f..0x21f */
	0x222, /* 0x223..0x223 */
	0x224, /* 0x225..0x225 */
	0x226, /* 0x227..0x227 */
	0x228, /* 0x229..0x229 */
	0x22a, /* 0x22b..0x22b */
	0x22c, /* 0x22d..0x22d */
	0x22e, /* 0x22f..0x22f */
	0x230, /* 0x231..0x231 */
	0x232, /* 0x233..0x233 */
	0x23b, /* 0x23c..0x23c */
	0x2c7e, /* 0x23f..0x240 */
	0x241, /* 0x242..0x242 */
	0x246, /* 0x247..0x247 */
	0x248, /* 0x249..0x249 */
	0x24a, /* 0x24b..0x24b */
	0x24c, /* 0x24d..0x24d */
	0x24e, /* 0x24f..0x24f */
	0x2c6f, /* 0x250..0x250 */
	0x2c6d, /* 0x251..0x251 */
	0x2c70, /* 0x252..0x252 */
	0x181, /* 0x253..0x253 */
	0x186, /* 0x254..0x254 */
	0x189, /* 0x256..0x257 */
	0x18f, /* 0x259..0x259 */
	0x190, /* 0x25b..0x25b */
	0xa7ab, /* 0x25c..0x25c */
	0x193, /* 0x260..0x260 */
	0xa7ac, /* 0x261..0x261 */
	0x194, /* 0x263..0x263 */
	0xa78d, /* 0x265..0x265 */
	0xa7aa, /* 0x266..0x266 */
	0x197, /* 0x268..0x268 */
	0x196, /* 0x269..0x269 */
	0xa7ae, /* 0x26a..0x26a */
	0x2c62, /* 0x26b..0x26b */
	0xa7ad, /* 0x26c..0x26c */
	0x19c, /* 0x26f..0x26f */
	0x2c6e, /* 0x271..0x271 */
	0x19d, /* 0x272..0x272 */
	0x19f, /* 0x275..0x275 */
	0x2c64, /* 0x27d..0x27d */
	0x1a6, /* 0x280..0x280 */
	0x1a9, /* 0x283..0x283 */
	0xa7b1, /* 0x287..0x287 */
	0x1ae, /* 0x288..0x288 */
	0x244, /* 0x289..0x289 */
	0x1b1, /* 0x28a..0x28b */
	0x245, /* 0x28c..0x28c */
	0x1b7, /* 0x292..0x292 */
	0xa7b2, /* 0x29d..0x29d */
	0xa7b0, /* 0x29e..0x29e */
	0x399, /* 0x345..0x345 */
	0x370, /* 0x371..0x371 */
	0x372, /* 0x373..0x373 */
	0x376, /* 0x377..0x377 */
	0x3fd, /* 0x37b..0x37d */
	0x386, /* 0x3ac..0x3ac */
	0x388, /* 0x3ad..0x3af */
	0x391, /* 0x3b1..0x3c1 */
	0x3a3, /* 0x3c2..0x3c2 */
	0x3a3, /* 0x3c3..0x3cb */
	0x38c, /* 0x3cc..0x3cc */
	0x38e, /* 0x3cd..0x3ce */
	0x392, /* 0x3d0..0x3d0 */
	0x398, /* 0x3d1..0x3d1 */
	0x3a6, /* 0x3d5..0x3d5 */
	0x3a0, /* 0x3d6..0x3d6 */
	0x3cf, /* 0x3d7..0x3d7 */
	0x3d8, /* 0x3d9..0x3d9 */
	0x3da, /* 0x3db..0x3db */
	0x3dc, /* 0x3dd..0x3dd */
	0x3de, /* 0x3df..0x3df */
	0x3e0, /* 0x3e1..0x3e1 */
	0x3e2, /* 0x3e3..0x3e3 */
	0x3e4, /* 0x3e5..0x3e5 */
	0x3e6, /* 0x3e7..0x3e7 */
	0x3e8, /* 0x3e9..0x3e9 */
	0x3ea, /* 0x3eb..0x3eb */
	0x3ec, /* 0x3ed..0x3ed */
	0x3ee, /* 0x3ef..0x3ef */
	0x39a, /* 0x3f0..0x3f0 */
	0x3a1, /* 0x3f1..0x3f1 */
	0x3f9, /* 0x3f2..0x3f2 */
	0x37f, /* 0x3f3..0x3f3 */
	0x395, /* 0x3f5..0x3f5 */
	0x3f7, /* 0x3f8..0x3f8 */
	0x3fa, /* 0x3fb..0x3fb */
	0x410, /* 0x430..0x44f */
	0x400, /* 0x450..0x45f */
	0x460, /* 0x461..0x461 */
	0x462, /* 0x463..0x463 */
	0x464, /* 0x465..0x465 */
	0x466, /* 0x467..0x467 */
	0x468, /* 0x469..0x469 */
	0x46a, /* 0x46b..0x46b */
	0x46c, /* 0x46d..0x46d */
	0x46e, /* 0x46f..0x46f */
	0x470, /* 0x471..0x471 */
	0x472, /* 0x473..0x473 */
	0x474, /* 0x475..0x475 */
	0x476, /* 0x477..0x477 */
	0x478, /* 0x479..0x479 */
	0x47a, /* 0x47b..0x47b */
	0x47c, /* 0x47d..0x47d */
	0x47e, /* 0x47f..0x47f */
	0x480, /* 0x481..0x481 */
	0x48a, /* 0x48b..0x48b */
	0x48c, /* 0x48d..0x48d */
	0x48e, /* 0x48f..0x48f */
	0x490, /* 0x491..0x491 */
	0x492, /* 0x493..0x493 */
	0x494, /* 0x495..0x495 */
	0x496, /* 0x497..0x497 */
	0x498, /* 0x499..0x499 */
	0x49a, /* 0x49b..0x49b */
	0x49c, /* 0x49d..0x49d */
	0x49e, /* 0x49f..0x49f */
	0x4a0, /* 0x4a1..0x4a1 */
	0x4a2, /* 0x4a3..0x4a3 */
	0x4a4, /* 0x4a5..0x4a5 */
	0x4a6, /* 0x4a7..0x4a7 */
	0x4a8, /* 0x4a9..0x4a9 */
	0x4aa, /* 0x4ab..0x4ab */
	0x4ac, /* 0x4ad..0x4ad */
	0x4ae, /* 0x4af..0x4af */
	0x4b0, /* 0x4b1..0x4b1 */
	0x4b2, /* 0x4b3..0x4b3 */
	0x4b4, /* 0x4b5..0x4b5 */
	0x4b6, /* 0x4b7..0x4b7 */
	0x4b8, /* 0x4b9..0x4b9 */
	0x4ba, /* 0x4bb..0x4bb */
	0x4bc, /* 0x4bd..0x4bd */
	0x4be, /* 0x4bf..0x4bf */
	0x4c1, /* 0x4c2..0x4c2 */
	0x4c3, /* 0x4c4..0x4c4 */
	0x4c5, /* 0x4c6..0x4c6 */
	0x4c7, /* 0x4c8..0x4c8 */
	0x4c9, /* 0x4ca..0x4ca */
	0x4cb, /* 0x4cc..0x4cc */
	0x4cd, /* 0x4ce..0x4ce */
	0x4c0, /* 0x4cf..0x4cf */
	0x4d0, /* 0x4d1..0x4d1 */
	0x4d2, /* 0x4d3..0x4d3 */
	0x4d4, /* 0x4d5..0x4d5 */
	0x4d6, /* 0x4d7..0x4d7 */
	0x4d8, /* 0x4d9..0x4d9 */
	0x4da, /* 0x4db..0x4db */
	0x4dc, /* 0x4dd..0x4dd */
	0x4de, /* 0x4df..0x4df */
	0x4e0, /* 0x4e1..0x4e1 */
	0x4e2, /* 0x4e3..0x4e3 */
	0x4e4, /* 0x4e5..0x4e5 */
	0x4e6, /* 0x4e7..0x4e7 */
	0x4e8, /* 0x4e9..0x4e9 */
	0x4ea, /* 0x4eb..0x4eb */
	0x4ec, /* 0x4ed..0x4ed */
	0x4ee, /* 0x4ef..0x4ef */
	0x4f0, /* 0x4f1..0x4f1 */
	0x4f2, /* 0x4f3..0x4f3 */
	0x4f4, /* 0x4f5..0x4f5 */
	0x4f6, /* 0x4f7..0x4f7 */
	0x4f8, /* 0x4f9..0x4f9 */
	0x4fa, /* 0x4fb..0x4fb */
	0x4fc, /* 0x4fd..0x4fd */
	0x4fe, /* 0x4ff..0x4ff */
	0x500, /* 0x501..0x501 */
	0x502, /* 0x503..0x503 */
	0x504, /* 0x505..0x505 */
	0x506, /* 0x507..0x507 */
	0x508, /* 0x509..0x509 */
	0x50a, /* 0x50b..0x50b */
	0x50c, /* 0x50d..0x50d */
	0x50e, /* 0x50f..0x50f */
	0x510, /* 0x511..0x511 */
	0x512, /* 0x513..0x513 */
	0x514, /* 0x515..0x515 */
	0x516, /* 0x517..0x517 */
	0x518, /* 0x519..0x519 */
	0x51a, /* 0x51b..0x51b */
	0x51c, /* 0x51d..0x51d */
	0x51e, /* 0x51f..0x51f */
	0x520, /* 0x521..0x521 */
	0x522, /* 0x523..0x523 */
	0x524, /* 0x525..0x525 */
	0x526, /* 0x527..0x527 */
	0x528, /* 0x529..0x529 */
	0x52a, /* 0x52b..0x52b */
	0x52c, /* 0x52d..0x52d */
	0x52e, /* 0x52f..0x52f */
	0x531, /* 0x561..0x586 */
	0x13f0, /* 0x13f8..0x13fd */
	0x412, /* 0x1c80..0x1c80 */
	0x414, /* 0x1c81..0x1c81 */
	0x41e, /* 0x1c82..0x1c82 */
	0x421, /* 0x1c83..0x1c84 */
	0x422, /* 0x1c85..0x1c85 */
	0x42a, /* 0x1c86..0x1c86 */
	0x462, /* 0x1c87..0x1c87 */
	0xa64a, /* 0x1c88..0x1c88 */
	0xa77d, /* 0x1d79..0x1d79 */
	0x2c63, /* 0x1d7d..0x1d7d */
	0x1e00, /* 0x1e01..0x1e01 */
	0x1e02, /* 0x1e03..0x1e03 */
	0x1e04, /* 0x1e05..0x1e05 */
	0x1e06, /* 0x1e07..0x1e07 */
	0x1e08, /* 0x1e09..0x1e09 */
	0x1e0a, /* 0x1e0b..0x1e0b */
	0x1e0c, /* 0x1e0d..0x1e0d */
	0x1e0e, /* 0x1e0f..0x1e0f */
	0x1e10, /* 0x1e11..0x1e11 */
	0x1e12, /* 0x1e13..0x1e13 */
	0x1e14, /* 0x1e15..0x1e15 */
	0x1e16, /* 0x1e17..0x1e17 */
	0x1e18, /* 0x1e19..0x1e19 */
	0x1e1a, /* 0x1e1b..0x1e1b */
	0x1e1c, /* 0x1e1d..0x1e1d */
	0x1e1e, /* 0x1e1f..0x1e1f */
	0x1e20, /* 0x1e21..0x1e21 */
	0x1e22, /* 0x1e23..0x1e23 */
	0x1e24, /* 0x1e25..0x1e25 */
	0x1e26, /* 0x1e27..0x1e27 */
	0x1e28, /* 0x1e29..0x1e29 */
	0x1e2a, /* 0x1e2b..0x1e2b */
	0x1e2c, /* 0x1e2d..0x1e2d */
	0x1e2e, /* 0x1e2f..0x1e2f */
	0x1e30, /* 0x1e31..0x1e31 */
	0x1e32, /* 0x1e33..0x1e33 */
	0x1e34, /* 0x1e35..0x1e35 */
	0x1e36, /* 0x1e37..0x1e37 */
	0x1e38, /* 0x1e39..0x1e39 */
	0x1e3a, /* 0x1e3b..0x1e3b */
	0x1e3c, /* 0x1e3d..0x1e3d */
	0x1e3e, /* 0x1e3f..0x1e3f */
	0x1e40, /* 0x1e41..0x1e41 */
	0x1e42, /* 0x1e43..0x1e43 */
	0x1e44, /* 0x1e45..0x1e45 */
	0x1e46, /* 0x1e47..0x1e47 */
	0x1e48, /* 0x1e49..0x1e49 */
	0x1e4a, /* 0x1e4b..0x1e4b */
	0x1e4c, /* 0x1e4d..0x1e4d */
	0x1e4e, /* 0x1e4f..0x1e4f */
	0x1e50, /* 0x1e51..0x1e51 */
	0x1e52, /* 0x1e53..0x1e53 */
	0x1e54, /* 0x1e55..0x1e55 */
	0x1e56, /* 0x1e57..0x1e57 */
	0x1e58, /* 0x1e59..0x1e59 */
	0x1e5a, /* 0x1e5b..0x1e5b */
	0x1e5c, /* 0x1e5d..0x1e5d */
	0x1e5e, /* 0x1e5f..0x1e5f */
	0x1e60, /* 0x1e61..0x1e61 */
	0x1e62, /* 0x1e63..0x1e63 */
	0x1e64, /* 0x1e65..0x1e65 */
	0x1e66, /* 0x1e67..0x1e67 */
	0x1e68, /* 0x1e69..0x1e69 */
	0x1e6a, /* 0x1e6b..0x1e6b */
	0x1e6c, /* 0x1e6d..0x1e6d */
	0x1e6e, /* 0x1e6f..0x1e6f */
	0x1e70, /* 0x1e71..0x1e71 */
	0x1e72, /* 0x1e73..0x1e73 */
	0x1e74, /* 0x1e75..0x1e75 */
	0x1e76, /* 0x1e77..0x1e77 */
	0x1e78, /* 0x1e79..0x1e79 */
	0x1e7a, /* 0x1e7b..0x1e7b */
	0x1e7c, /* 0x1e7d..0x1e7d */
	0x1e7e, /* 0x1e7f..0x1e7f */
	0x1e80, /* 0x1e81..0x1e81 */
	0x1e82, /* 0x1e83..0x1e83 */
	0x1e84, /* 0x1e85..0x1e85 */
	0x1e86, /* 0x1e87..0x1e87 */
	0x1e88, /* 0x1e89..0x1e89 */
	0x1e8a, /* 0x1e8b..0x1e8b */
	0x1e8c, /* 0x1e8d..0x1e8d */
	0x1e8e, /* 0x1e8f..0x1e8f */
	0x1e90, /* 0x1e91..0x1e91 */
	0x1e92, /* 0x1e93..0x1e93 */
	0x1e94, /* 0x1e95..0x1e95 */
	0x1e60, /* 0x1e9b..0x1e9b */
	0x1ea0, /* 0x1ea1..0x1ea1 */
	0x1ea2, /* 0x1ea3..0x1ea3 */
	0x1ea4, /* 0x1ea5..0x1ea5 */
	0x1ea6, /* 0x1ea7..0x1ea7 */
	0x1ea8, /* 0x1ea9..0x1ea9 */
	0x1eaa, /* 0x1eab..0x1eab */
	0x1eac, /* 0x1ead..0x1ead */
	0x1eae, /* 0x1eaf..0x1eaf */
	0x1eb0, /* 0x1eb1..0x1eb1 */
	0x1eb2, /* 0x1eb3..0x1eb3 */
	0x1eb4, /* 0x1eb5..0x1eb5 */
	0x1eb6, /* 0x1eb7..0x1eb7 */
	0x1eb8, /* 0x1eb9..0x1eb9 */
	0x1eba, /* 0x1ebb..0x1ebb */
	0x1ebc, /* 0x1ebd..0x1ebd */
	0x1ebe, /* 0x1ebf..0x1ebf */
	0x1ec0, /* 0x1ec1..0x1ec1 */
	0x1ec2, /* 0x1ec3..0x1ec3 */
	0x1ec4, /* 0x1ec5..0x1ec5 */
	0x1ec6, /* 0x1ec7..0x1ec7 */
	0x1ec8, /* 0x1ec9..0x1ec9 */
	0x1eca, /* 0x1ecb..0x1ecb */
	0x1ecc, /* 0x1ecd..0x1ecd */
	0x1ece, /* 0x1ecf..0x1ecf */
	0x1ed0, /* 0x1ed1..0x1ed1 */
	0x1ed2, /* 0x1ed3..0x1ed3 */
	0x1ed4, /* 0x1ed5..0x1ed5 */
	0x1ed6, /* 0x1ed7..0x1ed7 */
	0x1ed8, /* 0x1ed9..0x1ed9 */
	0x1eda, /* 0x1edb..0x1edb */
	0x1edc, /* 0x1edd..0x1edd */
	0x1ede, /* 0x1edf..0x1edf */
	0x1ee0, /* 0x1ee1..0x1ee1 */
	0x1ee2, /* 0x1ee3..0x1ee3 */
	0x1ee4, /* 0x1ee5..0x1ee5 */
	0x1ee6, /* 0x1ee7..0x1ee7 */
	0x1ee8, /* 0x1ee9..0x1ee9 */
	0x1eea, /* 0x1eeb..0x1eeb */
	0x1eec, /* 0x1eed..0x1eed */
	0x1eee, /* 0x1eef..0x1eef */
	0x1ef0, /* 0x1ef1..0x1ef1 */
	0x1ef2, /* 0x1ef3..0x1ef3 */
	0x1ef4, /* 0x1ef5..0x1ef5 */
	0x1ef6, /* 0x1ef7..0x1ef7 */
	0x1ef8, /* 0x1ef9..0x1ef9 */
	0x1efa, /* 0x1efb..0x1efb */
	0x1efc, /* 0x1efd..0x1efd */
	0x1efe, /* 0x1eff..0x1eff */
	0x1f08, /* 0x1f00..0x1f07 */
	0x1f18, /* 0x1f10..0x1f15 */
	0x1f28, /* 0x1f20..0x1f27 */
	0x1f38, /* 0x1f30..0x1f37 */
	0x1f48, /* 0x1f40..0x1f45 */
	0x1f59, /* 0x1f51..0x1f51 */
	0x1f5b, /* 0x1f53..0x1f53 */
	0x1f5d, /* 0x1f55..0x1f55 */
	0x1f5f, /* 0x1f57..0x1f57 */
	0x1f68, /* 0x1f60..0x1f67 */
	0x1fba, /* 0x1f70..0x1f71 */
	0x1fc8, /* 0x1f72..0x1f75 */
	0x1fda, /* 0x1f76..0x1f77 */
	0x1ff8, /* 0x1f78..0x1f79 */
	0x1fea, /* 0x1f7a..0x1f7b */
	0x1ffa, /* 0x1f7c..0x1f7d */
	0x1f88, /* 0x1f80..0x1f87 */
	0x1f98, /* 0x1f90..0x1f97 */
	0x1fa8, /* 0x1fa0..0x1fa7 */
	0x1fb8, /* 0x1fb0..0x1fb1 */
	0x1fbc, /* 0x1fb3..0x1fb3 */
	0x399, /* 0x1fbe..0x1fbe */
	0x1fcc, /* 0x1fc3..0x1fc3 */
	0x1fd8, /* 0x1fd0..0x1fd1 */
	0x1fe8, /* 0x1fe0..0x1fe1 */
	0x1fec, /* 0x1fe5..0x1fe5 */
	0x1ffc, /* 0x1ff3..0x1ff3 */
	0x2132, /* 0x214e..0x214e */
	0x2160, /* 0x2170..0x217f */
	0x2183, /* 0x2184..0x2184 */
	0x24b6, /* 0x24d0..0x24e9 */
	0x2c00, /* 0x2c30..0x2c5e */
	0x2c60, /* 0x2c61..0x2c61 */
	0x23a, /* 0x2c65..0x2c65 */
	0x23e, /* 0x2c66..0x2c66 */
	0x2c67, /* 0x2c68..0x2c68 */
	0x2c69, /* 0x2c6a..0x2c6a */
	0x2c6b, /* 0x2c6c..0x2c6c */
	0x2c72, /* 0x2c73..0x2c73 */
	0x2c75, /* 0x2c76..0x2c76 */
	0x2c80, /* 0x2c81..0x2c81 */
	0x2c82, /* 0x2c83..0x2c83 */
	0x2c84, /* 0x2c85..0x2c85 */
	0x2c86, /* 0x2c87..0x2c87 */
	0x2c88, /* 0x2c89..0x2c89 */
	0x2c8a, /* 0x2c8b..0x2c8b */
	0x2c8c, /* 0x2c8d..0x2c8d */
	0x2c8e, /* 0x2c8f..0x2c8f */
	0x2c90, /* 0x2c91..0x2c91 */
	0x2c92, /* 0x2c93..0x2c93 */
	0x2c94, /* 0x2c95..0x2c95 */
	0x2c96, /* 0x2c97..0x2c97 */
	0x2c98, /* 0x2c99..0x2c99 */
	0x2c9a, /* 0x2c9b..0x2c9b */
	0x2c9c, /* 0x2c9d..0x2c9d */
	0x2c9e, /* 0x2c9f..0x2c9f */
	0x2ca0, /* 0x2ca1..0x2ca1 */
	0x2ca2, /* 0x2ca3..0x2ca3 */
	0x2ca4, /* 0x2ca5..0x2ca5 */
	0x2ca6, /* 0x2ca7..0x2ca7 */
	0x2ca8, /* 0x2ca9..0x2ca9 */
	0x2caa, /* 0x2cab..0x2cab */
	0x2cac, /* 0x2cad..0x2cad */
	0x2cae, /* 0x2caf..0x2caf */
	0x2cb0, /* 0x2cb1..0x2cb1 */
	0x2cb2, /* 0x2cb3..0x2cb3 */
	0x2cb4, /* 0x2cb5..0x2cb5 */
	0x2cb6, /* 0x2cb7..0x2cb7 */
	0x2cb8, /* 0x2cb9..0x2cb9 */
	0x2cba, /* 0x2cbb..0x2cbb */
	0x2cbc, /* 0x2cbd..0x2cbd */
	0x2cbe, /* 0x2cbf..0x2cbf */
	0x2cc0, /* 0x2cc1..0x2cc1 */
	0x2cc2, /* 0x2cc3..0x2cc3 */
	0x2cc4, /* 0x2cc5..0x2cc5 */
	0x2cc6, /* 0x2cc7..0x2cc7 */
	0x2cc8, /* 0x2cc9..0x2cc9 */
	0x2cca, /* 0x2ccb..0x2ccb */
	0x2ccc, /* 0x2ccd..0x2ccd */
	0x2cce, /* 0x2ccf..0x2ccf */
	0x2cd0, /* 0x2cd1..0x2cd1 */
	0x2cd2, /* 0x2cd3..0x2cd3 */
	0x2cd4, /* 0x2cd5..0x2cd5 */
	0x2cd6, /* 0x2cd7..0x2cd7 */
	0x2cd8, /* 0x2cd9..0x2cd9 */
	0x2cda, /* 0x2cdb..0x2cdb */
	0x2cdc, /* 0x2cdd..0x2cdd */
	0x2cde, /* 0x2cdf..0x2cdf */
	0x2ce0, /* 0x2ce1..0x2ce1 */
	0x2ce2, /* 0x2ce3..0x2ce3 */
	0x2ceb, /* 0x2cec..0x2cec */
	0x2ced, /* 0x2cee..0x2cee */
	0x2cf2, /* 0x2cf3..0x2cf3 */
	0x10a0, /* 0x2d00..0x2d25 */
	0x10c7, /* 0x2d27..0x2d27 */
	0x10cd, /* 0x2d2d..0x2d2d */
	0xa640, /* 0xa641..0xa641 */
	0xa642, /* 0xa643..0xa643 */
	0xa644, /* 0xa645..0xa645 */
	0xa646, /* 0xa647..0xa647 */
	0xa648, /* 0xa649..0xa649 */
	0xa64a, /* 0xa64b..0xa64b */
	0xa64c, /* 0xa64d..0xa64d */
	0xa64e, /* 0xa64f..0xa64f */
	0xa650, /* 0xa651..0xa651 */
	0xa652, /* 0xa653..0xa653 */
	0xa654, /* 0xa655..0xa655 */
	0xa656, /* 0xa657..0xa657 */
	0xa658, /* 0xa659..0xa659 */
	0xa65a, /* 0xa65b..0xa65b */
	0xa65c, /* 0xa65d..0xa65d */
	0xa65e, /* 0xa65f..0xa65f */
	0xa660, /* 0xa661..0xa661 */
	0xa662, /* 0xa663..0xa663 */
	0xa664, /* 0xa665..0xa665 */
	0xa666, /* 0xa667..0xa667 */
	0xa668, /* 0xa669..0xa669 */
	0xa66a, /* 0xa66b..0xa66b */
	0xa66c, /* 0xa66d..0xa66d */
	0xa680, /* 0xa681..0xa681 */
	0xa682, /* 0xa683..0xa683 */
	0xa684, /* 0xa685..0xa685 */
	0xa686, /* 0xa687..0xa687 */
	0xa688, /* 0xa689..0xa689 */
	0xa68a, /* 0xa68b..0xa68b */
	0xa68c, /* 0xa68d..0xa68d */
	0xa68e, /* 0xa68f..0xa68f */
	0xa690, /* 0xa691..0xa691 */
	0xa692, /* 0xa693..0xa693 */
	0xa694, /* 0xa695..0xa695 */
	0xa696, /* 0xa697..0xa697 */
	0xa698, /* 0xa699..0xa699 */
	0xa69a, /* 0xa69b..0xa69b */
	0xa722, /* 0xa723..0xa723 */
	0xa724, /* 0xa725..0xa725 */
	0xa726, /* 0xa727..0xa727 */
	0xa728, /* 0xa729..0xa729 */
	0xa72a, /* 0xa72b..0xa72b */
	0xa72c, /* 0xa72d..0xa72d */
	0xa72e, /* 0xa72f..0xa72f */
	0xa732, /* 0xa733..0xa733 */
	0xa734, /* 0xa735..0xa735 */
	0xa736, /* 0xa737..0xa737 */
	0xa738, /* 0xa739..0xa739 */
	0xa73a, /* 0xa73b..0xa73b */
	0xa73c, /* 0xa73d..0xa73d */
	0xa73e, /* 0xa73f..0xa73f */
	0xa740, /* 0xa741..0xa741 */
	0xa742, /* 0xa743..0xa743 */
	0xa744, /* 0xa745..0xa745 */
	0xa746, /* 0xa747..0xa747 */
	0xa748, /* 0xa749..0xa749 */
	0xa74a, /* 0xa74b..0xa74b */
	0xa74c, /* 0xa74d..0xa74d */
	0xa74e, /* 0xa74f..0xa74f */
	0xa750, /* 0xa751..0xa751 */
	0xa752, /* 0xa753..0xa753 */
	0xa754, /* 0xa755..0xa755 */
	0xa756, /* 0xa757..0xa757 */
	0xa758, /* 0xa759..0xa759 */
	0xa75a, /* 0xa75b..0xa75b */
	0xa75c, /* 0xa75d..0xa75d */
	0xa75e, /* 0xa75f..0xa75f */
	0xa760, /* 0xa761..0xa761 */
	0xa762, /* 0xa763..0xa763 */
	0xa764, /* 0xa765..0xa765 */
	0xa766, /* 0xa767..0xa767 */
	0xa768, /* 0xa769..0xa769 */
	0xa76a, /* 0xa76b..0xa76b */
	0xa76c, /* 0xa76d..0xa76d */
	0xa76e, /* 0xa76f..0xa76f */
	0xa779, /* 0xa77a..0xa77a */
	0xa77b, /* 0xa77c..0xa77c */
	0xa77e, /* 0xa77f..0xa77f */
	0xa780, /* 0xa781..0xa781 */
	0xa782, /* 0xa783..0xa783 */
	0xa784, /* 0xa785..0xa785 */
	0xa786, /* 0xa787..0xa787 */
	0xa78b, /* 0xa78c..0xa78c */
	0xa790, /* 0xa791..0xa791 */
	0xa792, /* 0xa793..0xa793 */
	0xa796, /* 0xa797..0xa797 */
	0xa798, /* 0xa799..0xa799 */
	0xa79a, /* 0xa79b..0xa79b */
	0xa79c, /* 0xa79d..0xa79d */
	0xa79e, /* 0xa79f..0xa79f */
	0xa7a0, /* 0xa7a1..0xa7a1 */
	0xa7a2, /* 0xa7a3..0xa7a3 */
	0xa7a4, /* 0xa7a5..0xa7a5 */
	0xa7a6, /* 0xa7a7..0xa7a7 */
	0xa7a8, /* 0xa7a9..0xa7a9 */
	0xa7b4, /* 0xa7b5..0xa7b5 */
	0xa7b6, /* 0xa7b7..0xa7b7 */
	0xa7b3, /* 0xab53..0xab53 */
	0x13a0, /* 0xab70..0xabbf */
	0xff21, /* 0xff41..0xff5a */
	0x10400, /* 0x10428..0x1044f */
	0x104b0, /* 0x104d8..0x104fb */
	0x10c80, /* 0x10cc0..0x10cf2 */
	0x118a0, /* 0x118c0..0x118df */
	0x1e900, /* 0x1e922..0x1e943 */
	0x0
};

struct interval tolower_table[] = {
	{ 0x41, 0x5a }, /* 0x61 */
	{ 0xc0, 0xd6 }, /* 0xe0 */
	{ 0xd8, 0xde }, /* 0xf8 */
	{ 0x100, 0x100 }, /* 0x101 */
	{ 0x102, 0x102 }, /* 0x103 */
	{ 0x104, 0x104 }, /* 0x105 */
	{ 0x106, 0x106 }, /* 0x107 */
	{ 0x108, 0x108 }, /* 0x109 */
	{ 0x10a, 0x10a }, /* 0x10b */
	{ 0x10c, 0x10c }, /* 0x10d */
	{ 0x10e, 0x10e }, /* 0x10f */
	{ 0x110, 0x110 }, /* 0x111 */
	{ 0x112, 0x112 }, /* 0x113 */
	{ 0x114, 0x114 }, /* 0x115 */
	{ 0x116, 0x116 }, /* 0x117 */
	{ 0x118, 0x118 }, /* 0x119 */
	{ 0x11a, 0x11a }, /* 0x11b */
	{ 0x11c, 0x11c }, /* 0x11d */
	{ 0x11e, 0x11e }, /* 0x11f */
	{ 0x120, 0x120 }, /* 0x121 */
	{ 0x122, 0x122 }, /* 0x123 */
	{ 0x124, 0x124 }, /* 0x125 */
	{ 0x126, 0x126 }, /* 0x127 */
	{ 0x128, 0x128 }, /* 0x129 */
	{ 0x12a, 0x12a }, /* 0x12b */
	{ 0x12c, 0x12c }, /* 0x12d */
	{ 0x12e, 0x12e }, /* 0x12f */
	{ 0x130, 0x130 }, /* 0x69 */
	{ 0x132, 0x132 }, /* 0x133 */
	{ 0x134, 0x134 }, /* 0x135 */
	{ 0x136, 0x136 }, /* 0x137 */
	{ 0x139, 0x139 }, /* 0x13a */
	{ 0x13b, 0x13b }, /* 0x13c */
	{ 0x13d, 0x13d }, /* 0x13e */
	{ 0x13f, 0x13f }, /* 0x140 */
	{ 0x141, 0x141 }, /* 0x142 */
	{ 0x143, 0x143 }, /* 0x144 */
	{ 0x145, 0x145 }, /* 0x146 */
	{ 0x147, 0x147 }, /* 0x148 */
	{ 0x14a, 0x14a }, /* 0x14b */
	{ 0x14c, 0x14c }, /* 0x14d */
	{ 0x14e, 0x14e }, /* 0x14f */
	{ 0x150, 0x150 }, /* 0x151 */
	{ 0x152, 0x152 }, /* 0x153 */
	{ 0x154, 0x154 }, /* 0x155 */
	{ 0x156, 0x156 }, /* 0x157 */
	{ 0x158, 0x158 }, /* 0x159 */
	{ 0x15a, 0x15a }, /* 0x15b */
	{ 0x15c, 0x15c }, /* 0x15d */
	{ 0x15e, 0x15e }, /* 0x15f */
	{ 0x160, 0x160 }, /* 0x161 */
	{ 0x162, 0x162 }, /* 0x163 */
	{ 0x164, 0x164 }, /* 0x165 */
	{ 0x166, 0x166 }, /* 0x167 */
	{ 0x168, 0x168 }, /* 0x169 */
	{ 0x16a, 0x16a }, /* 0x16b */
	{ 0x16c, 0x16c }, /* 0x16d */
	{ 0x16e, 0x16e }, /* 0x16f */
	{ 0x170, 0x170 }, /* 0x171 */
	{ 0x172, 0x172 }, /* 0x173 */
	{ 0x174, 0x174 }, /* 0x175 */
	{ 0x176, 0x176 }, /* 0x177 */
	{ 0x178, 0x178 }, /* 0xff */
	{ 0x179, 0x179 }, /* 0x17a */
	{ 0x17b, 0x17b }, /* 0x17c */
	{ 0x17d, 0x17d }, /* 0x17e */
	{ 0x181, 0x181 }, /* 0x253 */
	{ 0x182, 0x182 }, /* 0x183 */
	{ 0x184, 0x184 }, /* 0x185 */
	{ 0x186, 0x186 }, /* 0x254 */
	{ 0x187, 0x187 }, /* 0x188 */
	{ 0x189, 0x18a }, /* 0x256 */
	{ 0x18b, 0x18b }, /* 0x18c */
	{ 0x18e, 0x18e }, /* 0x1dd */
	{ 0x18f, 0x18f }, /* 0x259 */
	{ 0x190, 0x190 }, /* 0x25b */
	{ 0x191, 0x191 }, /* 0x192 */
	{ 0x193, 0x193 }, /* 0x260 */
	{ 0x194, 0x194 }, /* 0x263 */
	{ 0x196, 0x196 }, /* 0x269 */
	{ 0x197, 0x197 }, /* 0x268 */
	{ 0x198, 0x198 }, /* 0x199 */
	{ 0x19c, 0x19c }, /* 0x26f */
	{ 0x19d, 0x19d }, /* 0x272 */
	{ 0x19f, 0x19f }, /* 0x275 */
	{ 0x1a0, 0x1a0 }, /* 0x1a1 */
	{ 0x1a2, 0x1a2 }, /* 0x1a3 */
	{ 0x1a4, 0x1a4 }, /* 0x1a5 */
	{ 0x1a6, 0x1a6 }, /* 0x280 */
	{ 0x1a7, 0x1a7 }, /* 0x1a8 */
	{ 0x1a9, 0x1a9 }, /* 0x283 */
	{ 0x1ac, 0x1ac }, /* 0x1ad */
	{ 0x1ae, 0x1ae }, /* 0x288 */
	{ 0x1af, 0x1af }, /* 0x1b0 */
	{ 0x1b1, 0x1b2 }, /* 0x28a */
	{ 0x1b3, 0x1b3 }, /* 0x1b4 */
	{ 0x1b5, 0x1b5 }, /* 0x1b6 */
	{ 0x1b7, 0x1b7 }, /* 0x292 */
	{ 0x1b8, 0x1b8 }, /* 0x1b9 */
	{ 0x1bc, 0x1bc }, /* 0x1bd */
	{ 0x1c4, 0x1c4 }, /* 0x1c6 */
	{ 0x1c5, 0x1c5 }, /* 0x1c6 */
	{ 0x1c7, 0x1c7 }, /* 0x1c9 */
	{ 0x1c8, 0x1c8 }, /* 0x1c9 */
	{ 0x1ca, 0x1ca }, /* 0x1cc */
	{ 0x1cb, 0x1cb }, /* 0x1cc */
	{ 0x1cd, 0x1cd }, /* 0x1ce */
	{ 0x1cf, 0x1cf }, /* 0x1d0 */
	{ 0x1d1, 0x1d1 }, /* 0x1d2 */
	{ 0x1d3, 0x1d3 }, /* 0x1d4 */
	{ 0x1d5, 0x1d5 }, /* 0x1d6 */
	{ 0x1d7, 0x1d7 }, /* 0x1d8 */
	{ 0x1d9, 0x1d9 }, /* 0x1da */
	{ 0x1db, 0x1db }, /* 0x1dc */
	{ 0x1de, 0x1de }, /* 0x1df */
	{ 0x1e0, 0x1e0 }, /* 0x1e1 */
	{ 0x1e2, 0x1e2 }, /* 0x1e3 */
	{ 0x1e4, 0x1e4 }, /* 0x1e5 */
	{ 0x1e6, 0x1e6 }, /* 0x1e7 */
	{ 0x1e8, 0x1e8 }, /* 0x1e9 */
	{ 0x1ea, 0x1ea }, /* 0x1eb */
	{ 0x1ec, 0x1ec }, /* 0x1ed */
	{ 0x1ee, 0x1ee }, /* 0x1ef */
	{ 0x1f1, 0x1f1 }, /* 0x1f3 */
	{ 0x1f2, 0x1f2 }, /* 0x1f3 */
	{ 0x1f4, 0x1f4 }, /* 0x1f5 */
	{ 0x1f6, 0x1f6 }, /* 0x195 */
	{ 0x1f7, 0x1f7 }, /* 0x1bf */
	{ 0x1f8, 0x1f8 }, /* 0x1f9 */
	{ 0x1fa, 0x1fa }, /* 0x1fb */
	{ 0x1fc, 0x1fc }, /* 0x1fd */
	{ 0x1fe, 0x1fe }, /* 0x1ff */
	{ 0x200, 0x200 }, /* 0x201 */
	{ 0x202, 0x202 }, /* 0x203 */
	{ 0x204, 0x204 }, /* 0x205 */
	{ 0x206, 0x206 }, /* 0x207 */
	{ 0x208, 0x208 }, /* 0x209 */
	{ 0x20a, 0x20a }, /* 0x20b */
	{ 0x20c, 0x20c }, /* 0x20d */
	{ 0x20e, 0x20e }, /* 0x20f */
	{ 0x210, 0x210 }, /* 0x211 */
	{ 0x212, 0x212 }, /* 0x213 */
	{ 0x214, 0x214 }, /* 0x215 */
	{ 0x216, 0x216 }, /* 0x217 */
	{ 0x218, 0x218 }, /* 0x219 */
	{ 0x21a, 0x21a }, /* 0x21b */
	{ 0x21c, 0x21c }, /* 0x21d */
	{ 0x21e, 0x21e }, /* 0x21f */
	{ 0x220, 0x220 }, /* 0x19e */
	{ 0x222, 0x222 }, /* 0x223 */
	{ 0x224, 0x224 }, /* 0x225 */
	{ 0x226, 0x226 }, /* 0x227 */
	{ 0x228, 0x228 }, /* 0x229 */
	{ 0x22a, 0x22a }, /* 0x22b */
	{ 0x22c, 0x22c }, /* 0x22d */
	{ 0x22e, 0x22e }, /* 0x22f */
	{ 0x230, 0x230 }, /* 0x231 */
	{ 0x232, 0x232 }, /* 0x233 */
	{ 0x23a, 0x23a }, /* 0x2c65 */
	{ 0x23b, 0x23b }, /* 0x23c */
	{ 0x23d, 0x23d }, /* 0x19a */
	{ 0x23e, 0x23e }, /* 0x2c66 */
	{ 0x241, 0x241 }, /* 0x242 */
	{ 0x243, 0x243 }, /* 0x180 */
	{ 0x244, 0x244 }, /* 0x289 */
	{ 0x245, 0x245 }, /* 0x28c */
	{ 0x246, 0x246 }, /* 0x247 */
	{ 0x248, 0x248 }, /* 0x249 */
	{ 0x24a, 0x24a }, /* 0x24b */
	{ 0x24c, 0x24c }, /* 0x24d */
	{ 0x24e, 0x24e }, /* 0x24f */
	{ 0x370, 0x370 }, /* 0x371 */
	{ 0x372, 0x372 }, /* 0x373 */
	{ 0x376, 0x376 }, /* 0x377 */
	{ 0x37f, 0x37f }, /* 0x3f3 */
	{ 0x386, 0x386 }, /* 0x3ac */
	{ 0x388, 0x38a }, /* 0x3ad */
	{ 0x38c, 0x38c }, /* 0x3cc */
	{ 0x38e, 0x38f }, /* 0x3cd */
	{ 0x391, 0x3a1 }, /* 0x3b1 */
	{ 0x3a3, 0x3ab }, /* 0x3c3 */
	{ 0x3cf, 0x3cf }, /* 0x3d7 */
	{ 0x3d8, 0x3d8 }, /* 0x3d9 */
	{ 0x3da, 0x3da }, /* 0x3db */
	{ 0x3dc, 0x3dc }, /* 0x3dd */
	{ 0x3de, 0x3de }, /* 0x3df */
	{ 0x3e0, 0x3e0 }, /* 0x3e1 */
	{ 0x3e2, 0x3e2 }, /* 0x3e3 */
	{ 0x3e4, 0x3e4 }, /* 0x3e5 */
	{ 0x3e6, 0x3e6 }, /* 0x3e7 */
	{ 0x3e8, 0x3e8 }, /* 0x3e9 */
	{ 0x3ea, 0x3ea }, /* 0x3eb */
	{ 0x3ec, 0x3ec }, /* 0x3ed */
	{ 0x3ee, 0x3ee }, /* 0x3ef */
	{ 0x3f4, 0x3f4 }, /* 0x3b8 */
	{ 0x3f7, 0x3f7 }, /* 0x3f8 */
	{ 0x3f9, 0x3f9 }, /* 0x3f2 */
	{ 0x3fa, 0x3fa }, /* 0x3fb */
	{ 0x3fd, 0x3ff }, /* 0x37b */
	{ 0x400, 0x40f }, /* 0x450 */
	{ 0x410, 0x42f }, /* 0x430 */
	{ 0x460, 0x460 }, /* 0x461 */
	{ 0x462, 0x462 }, /* 0x463 */
	{ 0x464, 0x464 }, /* 0x465 */
	{ 0x466, 0x466 }, /* 0x467 */
	{ 0x468, 0x468 }, /* 0x469 */
	{ 0x46a, 0x46a }, /* 0x46b */
	{ 0x46c, 0x46c }, /* 0x46d */
	{ 0x46e, 0x46e }, /* 0x46f */
	{ 0x470, 0x470 }, /* 0x471 */
	{ 0x472, 0x472 }, /* 0x473 */
	{ 0x474, 0x474 }, /* 0x475 */
	{ 0x476, 0x476 }, /* 0x477 */
	{ 0x478, 0x478 }, /* 0x479 */
	{ 0x47a, 0x47a }, /* 0x47b */
	{ 0x47c, 0x47c }, /* 0x47d */
	{ 0x47e, 0x47e }, /* 0x47f */
	{ 0x480, 0x480 }, /* 0x481 */
	{ 0x48a, 0x48a }, /* 0x48b */
	{ 0x48c, 0x48c }, /* 0x48d */
	{ 0x48e, 0x48e }, /* 0x48f */
	{ 0x490, 0x490 }, /* 0x491 */
	{ 0x492, 0x492 }, /* 0x493 */
	{ 0x494, 0x494 }, /* 0x495 */
	{ 0x496, 0x496 }, /* 0x497 */
	{ 0x498, 0x498 }, /* 0x499 */
	{ 0x49a, 0x49a }, /* 0x49b */
	{ 0x49c, 0x49c }, /* 0x49d */
	{ 0x49e, 0x49e }, /* 0x49f */
	{ 0x4a0, 0x4a0 }, /* 0x4a1 */
	{ 0x4a2, 0x4a2 }, /* 0x4a3 */
	{ 0x4a4, 0x4a4 }, /* 0x4a5 */
	{ 0x4a6, 0x4a6 }, /* 0x4a7 */
	{ 0x4a8, 0x4a8 }, /* 0x4a9 */
	{ 0x4aa, 0x4aa }, /* 0x4ab */
	{ 0x4ac, 0x4ac }, /* 0x4ad */
	{ 0x4ae, 0x4ae }, /* 0x4af */
	{ 0x4b0, 0x4b0 }, /* 0x4b1 */
	{ 0x4b2, 0x4b2 }, /* 0x4b3 */
	{ 0x4b4, 0x4b4 }, /* 0x4b5 */
	{ 0x4b6, 0x4b6 }, /* 0x4b7 */
	{ 0x4b8, 0x4b8 }, /* 0x4b9 */
	{ 0x4ba, 0x4ba }, /* 0x4bb */
	{ 0x4bc, 0x4bc }, /* 0x4bd */
	{ 0x4be, 0x4be }, /* 0x4bf */
	{ 0x4c0, 0x4c0 }, /* 0x4cf */
	{ 0x4c1, 0x4c1 }, /* 0x4c2 */
	{ 0x4c3, 0x4c3 }, /* 0x4c4 */
	{ 0x4c5, 0x4c5 }, /* 0x4c6 */
	{ 0x4c7, 0x4c7 }, /* 0x4c8 */
	{ 0x4c9, 0x4c9 }, /* 0x4ca */
	{ 0x4cb, 0x4cb }, /* 0x4cc */
	{ 0x4cd, 0x4cd }, /* 0x4ce */
	{ 0x4d0, 0x4d0 }, /* 0x4d1 */
	{ 0x4d2, 0x4d2 }, /* 0x4d3 */
	{ 0x4d4, 0x4d4 }, /* 0x4d5 */
	{ 0x4d6, 0x4d6 }, /* 0x4d7 */
	{ 0x4d8, 0x4d8 }, /* 0x4d9 */
	{ 0x4da, 0x4da }, /* 0x4db */
	{ 0x4dc, 0x4dc }, /* 0x4dd */
	{ 0x4de, 0x4de }, /* 0x4df */
	{ 0x4e0, 0x4e0 }, /* 0x4e1 */
	{ 0x4e2, 0x4e2 }, /* 0x4e3 */
	{ 0x4e4, 0x4e4 }, /* 0x4e5 */
	{ 0x4e6, 0x4e6 }, /* 0x4e7 */
	{ 0x4e8, 0x4e8 }, /* 0x4e9 */
	{ 0x4ea, 0x4ea }, /* 0x4eb */
	{ 0x4ec, 0x4ec }, /* 0x4ed */
	{ 0x4ee, 0x4ee }, /* 0x4ef */
	{ 0x4f0, 0x4f0 }, /* 0x4f1 */
	{ 0x4f2, 0x4f2 }, /* 0x4f3 */
	{ 0x4f4, 0x4f4 }, /* 0x4f5 */
	{ 0x4f6, 0x4f6 }, /* 0x4f7 */
	{ 0x4f8, 0x4f8 }, /* 0x4f9 */
	{ 0x4fa, 0x4fa }, /* 0x4fb */
	{ 0x4fc, 0x4fc }, /* 0x4fd */
	{ 0x4fe, 0x4fe }, /* 0x4ff */
	{ 0x500, 0x500 }, /* 0x501 */
	{ 0x502, 0x502 }, /* 0x503 */
	{ 0x504, 0x504 }, /* 0x505 */
	{ 0x506, 0x506 }, /* 0x507 */
	{ 0x508, 0x508 }, /* 0x509 */
	{ 0x50a, 0x50a }, /* 0x50b */
	{ 0x50c, 0x50c }, /* 0x50d */
	{ 0x50e, 0x50e }, /* 0x50f */
	{ 0x510, 0x510 }, /* 0x511 */
	{ 0x512, 0x512 }, /* 0x513 */
	{ 0x514, 0x514 }, /* 0x515 */
	{ 0x516, 0x516 }, /* 0x517 */
	{ 0x518, 0x518 }, /* 0x519 */
	{ 0x51a, 0x51a }, /* 0x51b */
	{ 0x51c, 0x51c }, /* 0x51d */
	{ 0x51e, 0x51e }, /* 0x51f */
	{ 0x520, 0x520 }, /* 0x521 */
	{ 0x522, 0x522 }, /* 0x523 */
	{ 0x524, 0x524 }, /* 0x525 */
	{ 0x526, 0x526 }, /* 0x527 */
	{ 0x528, 0x528 }, /* 0x529 */
	{ 0x52a, 0x52a }, /* 0x52b */
	{ 0x52c, 0x52c }, /* 0x52d */
	{ 0x52e, 0x52e }, /* 0x52f */
	{ 0x531, 0x556 }, /* 0x561 */
	{ 0x10a0, 0x10c5 }, /* 0x2d00 */
	{ 0x10c7, 0x10c7 }, /* 0x2d27 */
	{ 0x10cd, 0x10cd }, /* 0x2d2d */
	{ 0x13a0, 0x13ef }, /* 0xab70 */
	{ 0x13f0, 0x13f5 }, /* 0x13f8 */
	{ 0x1e00, 0x1e00 }, /* 0x1e01 */
	{ 0x1e02, 0x1e02 }, /* 0x1e03 */
	{ 0x1e04, 0x1e04 }, /* 0x1e05 */
	{ 0x1e06, 0x1e06 }, /* 0x1e07 */
	{ 0x1e08, 0x1e08 }, /* 0x1e09 */
	{ 0x1e0a, 0x1e0a }, /* 0x1e0b */
	{ 0x1e0c, 0x1e0c }, /* 0x1e0d */
	{ 0x1e0e, 0x1e0e }, /* 0x1e0f */
	{ 0x1e10, 0x1e10 }, /* 0x1e11 */
	{ 0x1e12, 0x1e12 }, /* 0x1e13 */
	{ 0x1e14, 0x1e14 }, /* 0x1e15 */
	{ 0x1e16, 0x1e16 }, /* 0x1e17 */
	{ 0x1e18, 0x1e18 }, /* 0x1e19 */
	{ 0x1e1a, 0x1e1a }, /* 0x1e1b */
	{ 0x1e1c, 0x1e1c }, /* 0x1e1d */
	{ 0x1e1e, 0x1e1e }, /* 0x1e1f */
	{ 0x1e20, 0x1e20 }, /* 0x1e21 */
	{ 0x1e22, 0x1e22 }, /* 0x1e23 */
	{ 0x1e24, 0x1e24 }, /* 0x1e25 */
	{ 0x1e26, 0x1e26 }, /* 0x1e27 */
	{ 0x1e28, 0x1e28 }, /* 0x1e29 */
	{ 0x1e2a, 0x1e2a }, /* 0x1e2b */
	{ 0x1e2c, 0x1e2c }, /* 0x1e2d */
	{ 0x1e2e, 0x1e2e }, /* 0x1e2f */
	{ 0x1e30, 0x1e30 }, /* 0x1e31 */
	{ 0x1e32, 0x1e32 }, /* 0x1e33 */
	{ 0x1e34, 0x1e34 }, /* 0x1e35 */
	{ 0x1e36, 0x1e36 }, /* 0x1e37 */
	{ 0x1e38, 0x1e38 }, /* 0x1e39 */
	{ 0x1e3a, 0x1e3a }, /* 0x1e3b */
	{ 0x1e3c, 0x1e3c }, /* 0x1e3d */
	{ 0x1e3e, 0x1e3e }, /* 0x1e3f */
	{ 0x1e40, 0x1e40 }, /* 0x1e41 */
	{ 0x1e42, 0x1e42 }, /* 0x1e43 */
	{ 0x1e44, 0x1e44 }, /* 0x1e45 */
	{ 0x1e46, 0x1e46 }, /* 0x1e47 */
	{ 0x1e48, 0x1e48 }, /* 0x1e49 */
	{ 0x1e4a, 0x1e4a }, /* 0x1e4b */
	{ 0x1e4c, 0x1e4c }, /* 0x1e4d */
	{ 0x1e4e, 0x1e4e }, /* 0x1e4f */
	{ 0x1e50, 0x1e50 }, /* 0x1e51 */
	{ 0x1e52, 0x1e52 }, /* 0x1e53 */
	{ 0x1e54, 0x1e54 }, /* 0x1e55 */
	{ 0x1e56, 0x1e56 }, /* 0x1e57 */
	{ 0x1e58, 0x1e58 }, /* 0x1e59 */
	{ 0x1e5a, 0x1e5a }, /* 0x1e5b */
	{ 0x1e5c, 0x1e5c }, /* 0x1e5d */
	{ 0x1e5e, 0x1e5e }, /* 0x1e5f */
	{ 0x1e60, 0x1e60 }, /* 0x1e61 */
	{ 0x1e62, 0x1e62 }, /* 0x1e63 */
	{ 0x1e64, 0x1e64 }, /* 0x1e65 */
	{ 0x1e66, 0x1e66 }, /* 0x1e67 */
	{ 0x1e68, 0x1e68 }, /* 0x1e69 */
	{ 0x1e6a, 0x1e6a }, /* 0x1e6b */
	{ 0x1e6c, 0x1e6c }, /* 0x1e6d */
	{ 0x1e6e, 0x1e6e }, /* 0x1e6f */
	{ 0x1e70, 0x1e70 }, /* 0x1e71 */
	{ 0x1e72, 0x1e72 }, /* 0x1e73 */
	{ 0x1e74, 0x1e74 }, /* 0x1e75 */
	{ 0x1e76, 0x1e76 }, /* 0x1e77 */
	{ 0x1e78, 0x1e78 }, /* 0x1e79 */
	{ 0x1e7a, 0x1e7a }, /* 0x1e7b */
	{ 0x1e7c, 0x1e7c }, /* 0x1e7d */
	{ 0x1e7e, 0x1e7e }, /* 0x1e7f */
	{ 0x1e80, 0x1e80 }, /* 0x1e81 */
	{ 0x1e82, 0x1e82 }, /* 0x1e83 */
	{ 0x1e84, 0x1e84 }, /* 0x1e85 */
	{ 0x1e86, 0x1e86 }, /* 0x1e87 */
	{ 0x1e88, 0x1e88 }, /* 0x1e89 */
	{ 0x1e8a, 0x1e8a }, /* 0x1e8b */
	{ 0x1e8c, 0x1e8c }, /* 0x1e8d */
	{ 0x1e8e, 0x1e8e }, /* 0x1e8f */
	{ 0x1e90, 0x1e90 }, /* 0x1e91 */
	{ 0x1e92, 0x1e92 }, /* 0x1e93 */
	{ 0x1e94, 0x1e94 }, /* 0x1e95 */
	{ 0x1e9e, 0x1e9e }, /* 0xdf */
	{ 0x1ea0, 0x1ea0 }, /* 0x1ea1 */
	{ 0x1ea2, 0x1ea2 }, /* 0x1ea3 */
	{ 0x1ea4, 0x1ea4 }, /* 0x1ea5 */
	{ 0x1ea6, 0x1ea6 }, /* 0x1ea7 */
	{ 0x1ea8, 0x1ea8 }, /* 0x1ea9 */
	{ 0x1eaa, 0x1eaa }, /* 0x1eab */
	{ 0x1eac, 0x1eac }, /* 0x1ead */
	{ 0x1eae, 0x1eae }, /* 0x1eaf */
	{ 0x1eb0, 0x1eb0 }, /* 0x1eb1 */
	{ 0x1eb2, 0x1eb2 }, /* 0x1eb3 */
	{ 0x1eb4, 0x1eb4 }, /* 0x1eb5 */
	{ 0x1eb6, 0x1eb6 }, /* 0x1eb7 */
	{ 0x1eb8, 0x1eb8 }, /* 0x1eb9 */
	{ 0x1eba, 0x1eba }, /* 0x1ebb */
	{ 0x1ebc, 0x1ebc }, /* 0x1ebd */
	{ 0x1ebe, 0x1ebe }, /* 0x1ebf */
	{ 0x1ec0, 0x1ec0 }, /* 0x1ec1 */
	{ 0x1ec2, 0x1ec2 }, /* 0x1ec3 */
	{ 0x1ec4, 0x1ec4 }, /* 0x1ec5 */
	{ 0x1ec6, 0x1ec6 }, /* 0x1ec7 */
	{ 0x1ec8, 0x1ec8 }, /* 0x1ec9 */
	{ 0x1eca, 0x1eca }, /* 0x1ecb */
	{ 0x1ecc, 0x1ecc }, /* 0x1ecd */
	{ 0x1ece, 0x1ece }, /* 0x1ecf */
	{ 0x1ed0, 0x1ed0 }, /* 0x1ed1 */
	{ 0x1ed2, 0x1ed2 }, /* 0x1ed3 */
	{ 0x1ed4, 0x1ed4 }, /* 0x1ed5 */
	{ 0x1ed6, 0x1ed6 }, /* 0x1ed7 */
	{ 0x1ed8, 0x1ed8 }, /* 0x1ed9 */
	{ 0x1eda, 0x1eda }, /* 0x1edb */
	{ 0x1edc, 0x1edc }, /* 0x1edd */
	{ 0x1ede, 0x1ede }, /* 0x1edf */
	{ 0x1ee0, 0x1ee0 }, /* 0x1ee1 */
	{ 0x1ee2, 0x1ee2 }, /* 0x1ee3 */
	{ 0x1ee4, 0x1ee4 }, /* 0x1ee5 */
	{ 0x1ee6, 0x1ee6 }, /* 0x1ee7 */
	{ 0x1ee8, 0x1ee8 }, /* 0x1ee9 */
	{ 0x1eea, 0x1eea }, /* 0x1eeb */
	{ 0x1eec, 0x1eec }, /* 0x1eed */
	{ 0x1eee, 0x1eee }, /* 0x1eef */
	{ 0x1ef0, 0x1ef0 }, /* 0x1ef1 */
	{ 0x1ef2, 0x1ef2 }, /* 0x1ef3 */
	{ 0x1ef4, 0x1ef4 }, /* 0x1ef5 */
	{ 0x1ef6, 0x1ef6 }, /* 0x1ef7 */
	{ 0x1ef8, 0x1ef8 }, /* 0x1ef9 */
	{ 0x1efa, 0x1efa }, /* 0x1efb */
	{ 0x1efc, 0x1efc }, /* 0x1efd */
	{ 0x1efe, 0x1efe }, /* 0x1eff */
	{ 0x1f08, 0x1f0f }, /* 0x1f00 */
	{ 0x1f18, 0x1f1d }, /* 0x1f10 */
	{ 0x1f28, 0x1f2f }, /* 0x1f20 */
	{ 0x1f38, 0x1f3f }, /* 0x1f30 */
	{ 0x1f48, 0x1f4d }, /* 0x1f40 */
	{ 0x1f59, 0x1f59 }, /* 0x1f51 */
	{ 0x1f5b, 0x1f5b }, /* 0x1f53 */
	{ 0x1f5d, 0x1f5d }, /* 0x1f55 */
	{ 0x1f5f, 0x1f5f }, /* 0x1f57 */
	{ 0x1f68, 0x1f6f }, /* 0x1f60 */
	{ 0x1f88, 0x1f8f }, /* 0x1f80 */
	{ 0x1f98, 0x1f9f }, /* 0x1f90 */
	{ 0x1fa8, 0x1faf }, /* 0x1fa0 */
	{ 0x1fb8, 0x1fb9 }, /* 0x1fb0 */
	{ 0x1fba, 0x1fbb }, /* 0x1f70 */
	{ 0x1fbc, 0x1fbc }, /* 0x1fb3 */
	{ 0x1fc8, 0x1fcb }, /* 0x1f72 */
	{ 0x1fcc, 0x1fcc }, /* 0x1fc3 */
	{ 0x1fd8, 0x1fd9 }, /* 0x1fd0 */
	{ 0x1fda, 0x1fdb }, /* 0x1f76 */
	{ 0x1fe8, 0x1fe9 }, /* 0x1fe0 */
	{ 0x1fea, 0x1feb }, /* 0x1f7a */
	{ 0x1fec, 0x1fec }, /* 0x1fe5 */
	{ 0x1ff8, 0x1ff9 }, /* 0x1f78 */
	{ 0x1ffa, 0x1ffb }, /* 0x1f7c */
	{ 0x1ffc, 0x1ffc }, /* 0x1ff3 */
	{ 0x2126, 0x2126 }, /* 0x3c9 */
	{ 0x212a, 0x212a }, /* 0x6b */
	{ 0x212b, 0x212b }, /* 0xe5 */
	{ 0x2132, 0x2132 }, /* 0x214e */
	{ 0x2160, 0x216f }, /* 0x2170 */
	{ 0x2183, 0x2183 }, /* 0x2184 */
	{ 0x24b6, 0x24cf }, /* 0x24d0 */
	{ 0x2c00, 0x2c2e }, /* 0x2c30 */
	{ 0x2c60, 0x2c60 }, /* 0x2c61 */
	{ 0x2c62, 0x2c62 }, /* 0x26b */
	{ 0x2c63, 0x2c63 }, /* 0x1d7d */
	{ 0x2c64, 0x2c64 }, /* 0x27d */
	{ 0x2c67, 0x2c67 }, /* 0x2c68 */
	{ 0x2c69, 0x2c69 }, /* 0x2c6a */
	{ 0x2c6b, 0x2c6b }, /* 0x2c6c */
	{ 0x2c6d, 0x2c6d }, /* 0x251 */
	{ 0x2c6e, 0x2c6e }, /* 0x271 */
	{ 0x2c6f, 0x2c6f }, /* 0x250 */
	{ 0x2c70, 0x2c70 }, /* 0x252 */
	{ 0x2c72, 0x2c72 }, /* 0x2c73 */
	{ 0x2c75, 0x2c75 }, /* 0x2c76 */
	{ 0x2c7e, 0x2c7f }, /* 0x23f */
	{ 0x2c80, 0x2c80 }, /* 0x2c81 */
	{ 0x2c82, 0x2c82 }, /* 0x2c83 */
	{ 0x2c84, 0x2c84 }, /* 0x2c85 */
	{ 0x2c86, 0x2c86 }, /* 0x2c87 */
	{ 0x2c88, 0x2c88 }, /* 0x2c89 */
	{ 0x2c8a, 0x2c8a }, /* 0x2c8b */
	{ 0x2c8c, 0x2c8c }, /* 0x2c8d */
	{ 0x2c8e, 0x2c8e }, /* 0x2c8f */
	{ 0x2c90, 0x2c90 }, /* 0x2c91 */
	{ 0x2c92, 0x2c92 }, /* 0x2c93 */
	{ 0x2c94, 0x2c94 }, /* 0x2c95 */
	{ 0x2c96, 0x2c96 }, /* 0x2c97 */
	{ 0x2c98, 0x2c98 }, /* 0x2c99 */
	{ 0x2c9a, 0x2c9a }, /* 0x2c9b */
	{ 0x2c9c, 0x2c9c }, /* 0x2c9d */
	{ 0x2c9e, 0x2c9e }, /* 0x2c9f */
	{ 0x2ca0, 0x2ca0 }, /* 0x2ca1 */
	{ 0x2ca2, 0x2ca2 }, /* 0x2ca3 */
	{ 0x2ca4, 0x2ca4 }, /* 0x2ca5 */
	{ 0x2ca6, 0x2ca6 }, /* 0x2ca7 */
	{ 0x2ca8, 0x2ca8 }, /* 0x2ca9 */
	{ 0x2caa, 0x2caa }, /* 0x2cab */
	{ 0x2cac, 0x2cac }, /* 0x2cad */
	{ 0x2cae, 0x2cae }, /* 0x2caf */
	{ 0x2cb0, 0x2cb0 }, /* 0x2cb1 */
	{ 0x2cb2, 0x2cb2 }, /* 0x2cb3 */
	{ 0x2cb4, 0x2cb4 }, /* 0x2cb5 */
	{ 0x2cb6, 0x2cb6 }, /* 0x2cb7 */
	{ 0x2cb8, 0x2cb8 }, /* 0x2cb9 */
	{ 0x2cba, 0x2cba }, /* 0x2cbb */
	{ 0x2cbc, 0x2cbc }, /* 0x2cbd */
	{ 0x2cbe, 0x2cbe }, /* 0x2cbf */
	{ 0x2cc0, 0x2cc0 }, /* 0x2cc1 */
	{ 0x2cc2, 0x2cc2 }, /* 0x2cc3 */
	{ 0x2cc4, 0x2cc4 }, /* 0x2cc5 */
	{ 0x2cc6, 0x2cc6 }, /* 0x2cc7 */
	{ 0x2cc8, 0x2cc8 }, /* 0x2cc9 */
	{ 0x2cca, 0x2cca }, /* 0x2ccb */
	{ 0x2ccc, 0x2ccc }, /* 0x2ccd */
	{ 0x2cce, 0x2cce }, /* 0x2ccf */
	{ 0x2cd0, 0x2cd0 }, /* 0x2cd1 */
	{ 0x2cd2, 0x2cd2 }, /* 0x2cd3 */
	{ 0x2cd4, 0x2cd4 }, /* 0x2cd5 */
	{ 0x2cd6, 0x2cd6 }, /* 0x2cd7 */
	{ 0x2cd8, 0x2cd8 }, /* 0x2cd9 */
	{ 0x2cda, 0x2cda }, /* 0x2cdb */
	{ 0x2cdc, 0x2cdc }, /* 0x2cdd */
	{ 0x2cde, 0x2cde }, /* 0x2cdf */
	{ 0x2ce0, 0x2ce0 }, /* 0x2ce1 */
	{ 0x2ce2, 0x2ce2 }, /* 0x2ce3 */
	{ 0x2ceb, 0x2ceb }, /* 0x2cec */
	{ 0x2ced, 0x2ced }, /* 0x2cee */
	{ 0x2cf2, 0x2cf2 }, /* 0x2cf3 */
	{ 0xa640, 0xa640 }, /* 0xa641 */
	{ 0xa642, 0xa642 }, /* 0xa643 */
	{ 0xa644, 0xa644 }, /* 0xa645 */
	{ 0xa646, 0xa646 }, /* 0xa647 */
	{ 0xa648, 0xa648 }, /* 0xa649 */
	{ 0xa64a, 0xa64a }, /* 0xa64b */
	{ 0xa64c, 0xa64c }, /* 0xa64d */
	{ 0xa64e, 0xa64e }, /* 0xa64f */
	{ 0xa650, 0xa650 }, /* 0xa651 */
	{ 0xa652, 0xa652 }, /* 0xa653 */
	{ 0xa654, 0xa654 }, /* 0xa655 */
	{ 0xa656, 0xa656 }, /* 0xa657 */
	{ 0xa658, 0xa658 }, /* 0xa659 */
	{ 0xa65a, 0xa65a }, /* 0xa65b */
	{ 0xa65c, 0xa65c }, /* 0xa65d */
	{ 0xa65e, 0xa65e }, /* 0xa65f */
	{ 0xa660, 0xa660 }, /* 0xa661 */
	{ 0xa662, 0xa662 }, /* 0xa663 */
	{ 0xa664, 0xa664 }, /* 0xa665 */
	{ 0xa666, 0xa666 }, /* 0xa667 */
	{ 0xa668, 0xa668 }, /* 0xa669 */
	{ 0xa66a, 0xa66a }, /* 0xa66b */
	{ 0xa66c, 0xa66c }, /* 0xa66d */
	{ 0xa680, 0xa680 }, /* 0xa681 */
	{ 0xa682, 0xa682 }, /* 0xa683 */
	{ 0xa684, 0xa684 }, /* 0xa685 */
	{ 0xa686, 0xa686 }, /* 0xa687 */
	{ 0xa688, 0xa688 }, /* 0xa689 */
	{ 0xa68a, 0xa68a }, /* 0xa68b */
	{ 0xa68c, 0xa68c }, /* 0xa68d */
	{ 0xa68e, 0xa68e }, /* 0xa68f */
	{ 0xa690, 0xa690 }, /* 0xa691 */
	{ 0xa692, 0xa692 }, /* 0xa693 */
	{ 0xa694, 0xa694 }, /* 0xa695 */
	{ 0xa696, 0xa696 }, /* 0xa697 */
	{ 0xa698, 0xa698 }, /* 0xa699 */
	{ 0xa69a, 0xa69a }, /* 0xa69b */
	{ 0xa722, 0xa722 }, /* 0xa723 */
	{ 0xa724, 0xa724 }, /* 0xa725 */
	{ 0xa726, 0xa726 }, /* 0xa727 */
	{ 0xa728, 0xa728 }, /* 0xa729 */
	{ 0xa72a, 0xa72a }, /* 0xa72b */
	{ 0xa72c, 0xa72c }, /* 0xa72d */
	{ 0xa72e, 0xa72e }, /* 0xa72f */
	{ 0xa732, 0xa732 }, /* 0xa733 */
	{ 0xa734, 0xa734 }, /* 0xa735 */
	{ 0xa736, 0xa736 }, /* 0xa737 */
	{ 0xa738, 0xa738 }, /* 0xa739 */
	{ 0xa73a, 0xa73a }, /* 0xa73b */
	{ 0xa73c, 0xa73c }, /* 0xa73d */
	{ 0xa73e, 0xa73e }, /* 0xa73f */
	{ 0xa740, 0xa740 }, /* 0xa741 */
	{ 0xa742, 0xa742 }, /* 0xa743 */
	{ 0xa744, 0xa744 }, /* 0xa745 */
	{ 0xa746, 0xa746 }, /* 0xa747 */
	{ 0xa748, 0xa748 }, /* 0xa749 */
	{ 0xa74a, 0xa74a }, /* 0xa74b */
	{ 0xa74c, 0xa74c }, /* 0xa74d */
	{ 0xa74e, 0xa74e }, /* 0xa74f */
	{ 0xa750, 0xa750 }, /* 0xa751 */
	{ 0xa752, 0xa752 }, /* 0xa753 */
	{ 0xa754, 0xa754 }, /* 0xa755 */
	{ 0xa756, 0xa756 }, /* 0xa757 */
	{ 0xa758, 0xa758 }, /* 0xa759 */
	{ 0xa75a, 0xa75a }, /* 0xa75b */
	{ 0xa75c, 0xa75c }, /* 0xa75d */
	{ 0xa75e, 0xa75e }, /* 0xa75f */
	{ 0xa760, 0xa760 }, /* 0xa761 */
	{ 0xa762, 0xa762 }, /* 0xa763 */
	{ 0xa764, 0xa764 }, /* 0xa765 */
	{ 0xa766, 0xa766 }, /* 0xa767 */
	{ 0xa768, 0xa768 }, /* 0xa769 */
	{ 0xa76a, 0xa76a }, /* 0xa76b */
	{ 0xa76c, 0xa76c }, /* 0xa76d */
	{ 0xa76e, 0xa76e }, /* 0xa76f */
	{ 0xa779, 0xa779 }, /* 0xa77a */
	{ 0xa77b, 0xa77b }, /* 0xa77c */
	{ 0xa77d, 0xa77d }, /* 0x1d79 */
	{ 0xa77e, 0xa77e }, /* 0xa77f */
	{ 0xa780, 0xa780 }, /* 0xa781 */
	{ 0xa782, 0xa782 }, /* 0xa783 */
	{ 0xa784, 0xa784 }, /* 0xa785 */
	{ 0xa786, 0xa786 }, /* 0xa787 */
	{ 0xa78b, 0xa78b }, /* 0xa78c */
	{ 0xa78d, 0xa78d }, /* 0x265 */
	{ 0xa790, 0xa790 }, /* 0xa791 */
	{ 0xa792, 0xa792 }, /* 0xa793 */
	{ 0xa796, 0xa796 }, /* 0xa797 */
	{ 0xa798, 0xa798 }, /* 0xa799 */
	{ 0xa79a, 0xa79a }, /* 0xa79b */
	{ 0xa79c, 0xa79c }, /* 0xa79d */
	{ 0xa79e, 0xa79e }, /* 0xa79f */
	{ 0xa7a0, 0xa7a0 }, /* 0xa7a1 */
	{ 0xa7a2, 0xa7a2 }, /* 0xa7a3 */
	{ 0xa7a4, 0xa7a4 }, /* 0xa7a5 */
	{ 0xa7a6, 0xa7a6 }, /* 0xa7a7 */
	{ 0xa7a8, 0xa7a8 }, /* 0xa7a9 */
	{ 0xa7aa, 0xa7aa }, /* 0x266 */
	{ 0xa7ab, 0xa7ab }, /* 0x25c */
	{ 0xa7ac, 0xa7ac }, /* 0x261 */
	{ 0xa7ad, 0xa7ad }, /* 0x26c */
	{ 0xa7ae, 0xa7ae }, /* 0x26a */
	{ 0xa7b0, 0xa7b0 }, /* 0x29e */
	{ 0xa7b1, 0xa7b1 }, /* 0x287 */
	{ 0xa7b2, 0xa7b2 }, /* 0x29d */
	{ 0xa7b3, 0xa7b3 }, /* 0xab53 */
	{ 0xa7b4, 0xa7b4 }, /* 0xa7b5 */
	{ 0xa7b6, 0xa7b6 }, /* 0xa7b7 */
	{ 0xff21, 0xff3a }, /* 0xff41 */
	{ 0x10400, 0x10427 }, /* 0x10428 */
	{ 0x104b0, 0x104d3 }, /* 0x104d8 */
	{ 0x10c80, 0x10cb2 }, /* 0x10cc0 */
	{ 0x118a0, 0x118bf }, /* 0x118c0 */
	{ 0x1e900, 0x1e921 }, /* 0x1e922 */
	{ 0x0, 0x0 }
};
int tolower_cvt[] = {
	0x61, /* 0x41..0x5a */
	0xe0, /* 0xc0..0xd6 */
	0xf8, /* 0xd8..0xde */
	0x101, /* 0x100..0x100 */
	0x103, /* 0x102..0x102 */
	0x105, /* 0x104..0x104 */
	0x107, /* 0x106..0x106 */
	0x109, /* 0x108..0x108 */
	0x10b, /* 0x10a..0x10a */
	0x10d, /* 0x10c..0x10c */
	0x10f, /* 0x10e..0x10e */
	0x111, /* 0x110..0x110 */
	0x113, /* 0x112..0x112 */
	0x115, /* 0x114..0x114 */
	0x117, /* 0x116..0x116 */
	0x119, /* 0x118..0x118 */
	0x11b, /* 0x11a..0x11a */
	0x11d, /* 0x11c..0x11c */
	0x11f, /* 0x11e..0x11e */
	0x121, /* 0x120..0x120 */
	0x123, /* 0x122..0x122 */
	0x125, /* 0x124..0x124 */
	0x127, /* 0x126..0x126 */
	0x129, /* 0x128..0x128 */
	0x12b, /* 0x12a..0x12a */
	0x12d, /* 0x12c..0x12c */
	0x12f, /* 0x12e..0x12e */
	0x69, /* 0x130..0x130 */
	0x133, /* 0x132..0x132 */
	0x135, /* 0x134..0x134 */
	0x137, /* 0x136..0x136 */
	0x13a, /* 0x139..0x139 */
	0x13c, /* 0x13b..0x13b */
	0x13e, /* 0x13d..0x13d */
	0x140, /* 0x13f..0x13f */
	0x142, /* 0x141..0x141 */
	0x144, /* 0x143..0x143 */
	0x146, /* 0x145..0x145 */
	0x148, /* 0x147..0x147 */
	0x14b, /* 0x14a..0x14a */
	0x14d, /* 0x14c..0x14c */
	0x14f, /* 0x14e..0x14e */
	0x151, /* 0x150..0x150 */
	0x153, /* 0x152..0x152 */
	0x155, /* 0x154..0x154 */
	0x157, /* 0x156..0x156 */
	0x159, /* 0x158..0x158 */
	0x15b, /* 0x15a..0x15a */
	0x15d, /* 0x15c..0x15c */
	0x15f, /* 0x15e..0x15e */
	0x161, /* 0x160..0x160 */
	0x163, /* 0x162..0x162 */
	0x165, /* 0x164..0x164 */
	0x167, /* 0x166..0x166 */
	0x169, /* 0x168..0x168 */
	0x16b, /* 0x16a..0x16a */
	0x16d, /* 0x16c..0x16c */
	0x16f, /* 0x16e..0x16e */
	0x171, /* 0x170..0x170 */
	0x173, /* 0x172..0x172 */
	0x175, /* 0x174..0x174 */
	0x177, /* 0x176..0x176 */
	0xff, /* 0x178..0x178 */
	0x17a, /* 0x179..0x179 */
	0x17c, /* 0x17b..0x17b */
	0x17e, /* 0x17d..0x17d */
	0x253, /* 0x181..0x181 */
	0x183, /* 0x182..0x182 */
	0x185, /* 0x184..0x184 */
	0x254, /* 0x186..0x186 */
	0x188, /* 0x187..0x187 */
	0x256, /* 0x189..0x18a */
	0x18c, /* 0x18b..0x18b */
	0x1dd, /* 0x18e..0x18e */
	0x259, /* 0x18f..0x18f */
	0x25b, /* 0x190..0x190 */
	0x192, /* 0x191..0x191 */
	0x260, /* 0x193..0x193 */
	0x263, /* 0x194..0x194 */
	0x269, /* 0x196..0x196 */
	0x268, /* 0x197..0x197 */
	0x199, /* 0x198..0x198 */
	0x26f, /* 0x19c..0x19c */
	0x272, /* 0x19d..0x19d */
	0x275, /* 0x19f..0x19f */
	0x1a1, /* 0x1a0..0x1a0 */
	0x1a3, /* 0x1a2..0x1a2 */
	0x1a5, /* 0x1a4..0x1a4 */
	0x280, /* 0x1a6..0x1a6 */
	0x1a8, /* 0x1a7..0x1a7 */
	0x283, /* 0x1a9..0x1a9 */
	0x1ad, /* 0x1ac..0x1ac */
	0x288, /* 0x1ae..0x1ae */
	0x1b0, /* 0x1af..0x1af */
	0x28a, /* 0x1b1..0x1b2 */
	0x1b4, /* 0x1b3..0x1b3 */
	0x1b6, /* 0x1b5..0x1b5 */
	0x292, /* 0x1b7..0x1b7 */
	0x1b9, /* 0x1b8..0x1b8 */
	0x1bd, /* 0x1bc..0x1bc */
	0x1c6, /* 0x1c4..0x1c4 */
	0x1c6, /* 0x1c5..0x1c5 */
	0x1c9, /* 0x1c7..0x1c7 */
	0x1c9, /* 0x1c8..0x1c8 */
	0x1cc, /* 0x1ca..0x1ca */
	0x1cc, /* 0x1cb..0x1cb */
	0x1ce, /* 0x1cd..0x1cd */
	0x1d0, /* 0x1cf..0x1cf */
	0x1d2, /* 0x1d1..0x1d1 */
	0x1d4, /* 0x1d3..0x1d3 */
	0x1d6, /* 0x1d5..0x1d5 */
	0x1d8, /* 0x1d7..0x1d7 */
	0x1da, /* 0x1d9..0x1d9 */
	0x1dc, /* 0x1db..0x1db */
	0x1df, /* 0x1de..0x1de */
	0x1e1, /* 0x1e0..0x1e0 */
	0x1e3, /* 0x1e2..0x1e2 */
	0x1e5, /* 0x1e4..0x1e4 */
	0x1e7, /* 0x1e6..0x1e6 */
	0x1e9, /* 0x1e8..0x1e8 */
	0x1eb, /* 0x1ea..0x1ea */
	0x1ed, /* 0x1ec..0x1ec */
	0x1ef, /* 0x1ee..0x1ee */
	0x1f3, /* 0x1f1..0x1f1 */
	0x1f3, /* 0x1f2..0x1f2 */
	0x1f5, /* 0x1f4..0x1f4 */
	0x195, /* 0x1f6..0x1f6 */
	0x1bf, /* 0x1f7..0x1f7 */
	0x1f9, /* 0x1f8..0x1f8 */
	0x1fb, /* 0x1fa..0x1fa */
	0x1fd, /* 0x1fc..0x1fc */
	0x1ff, /* 0x1fe..0x1fe */
	0x201, /* 0x200..0x200 */
	0x203, /* 0x202..0x202 */
	0x205, /* 0x204..0x204 */
	0x207, /* 0x206..0x206 */
	0x209, /* 0x208..0x208 */
	0x20b, /* 0x20a..0x20a */
	0x20d, /* 0x20c..0x20c */
	0x20f, /* 0x20e..0x20e */
	0x211, /* 0x210..0x210 */
	0x213, /* 0x212..0x212 */
	0x215, /* 0x214..0x214 */
	0x217, /* 0x216..0x216 */
	0x219, /* 0x218..0x218 */
	0x21b, /* 0x21a..0x21a */
	0x21d, /* 0x21c..0x21c */
	0x21f, /* 0x21e..0x21e */
	0x19e, /* 0x220..0x220 */
	0x223, /* 0x222..0x222 */
	0x225, /* 0x224..0x224 */
	0x227, /* 0x226..0x226 */
	0x229, /* 0x228..0x228 */
	0x22b, /* 0x22a..0x22a */
	0x22d, /* 0x22c..0x22c */
	0x22f, /* 0x22e..0x22e */
	0x231, /* 0x230..0x230 */
	0x233, /* 0x232..0x232 */
	0x2c65, /* 0x23a..0x23a */
	0x23c, /* 0x23b..0x23b */
	0x19a, /* 0x23d..0x23d */
	0x2c66, /* 0x23e..0x23e */
	0x242, /* 0x241..0x241 */
	0x180, /* 0x243..0x243 */
	0x289, /* 0x244..0x244 */
	0x28c, /* 0x245..0x245 */
	0x247, /* 0x246..0x246 */
	0x249, /* 0x248..0x248 */
	0x24b, /* 0x24a..0x24a */
	0x24d, /* 0x24c..0x24c */
	0x24f, /* 0x24e..0x24e */
	0x371, /* 0x370..0x370 */
	0x373, /* 0x372..0x372 */
	0x377, /* 0x376..0x376 */
	0x3f3, /* 0x37f..0x37f */
	0x3ac, /* 0x386..0x386 */
	0x3ad, /* 0x388..0x38a */
	0x3cc, /* 0x38c..0x38c */
	0x3cd, /* 0x38e..0x38f */
	0x3b1, /* 0x391..0x3a1 */
	0x3c3, /* 0x3a3..0x3ab */
	0x3d7, /* 0x3cf..0x3cf */
	0x3d9, /* 0x3d8..0x3d8 */
	0x3db, /* 0x3da..0x3da */
	0x3dd, /* 0x3dc..0x3dc */
	0x3df, /* 0x3de..0x3de */
	0x3e1, /* 0x3e0..0x3e0 */
	0x3e3, /* 0x3e2..0x3e2 */
	0x3e5, /* 0x3e4..0x3e4 */
	0x3e7, /* 0x3e6..0x3e6 */
	0x3e9, /* 0x3e8..0x3e8 */
	0x3eb, /* 0x3ea..0x3ea */
	0x3ed, /* 0x3ec..0x3ec */
	0x3ef, /* 0x3ee..0x3ee */
	0x3b8, /* 0x3f4..0x3f4 */
	0x3f8, /* 0x3f7..0x3f7 */
	0x3f2, /* 0x3f9..0x3f9 */
	0x3fb, /* 0x3fa..0x3fa */
	0x37b, /* 0x3fd..0x3ff */
	0x450, /* 0x400..0x40f */
	0x430, /* 0x410..0x42f */
	0x461, /* 0x460..0x460 */
	0x463, /* 0x462..0x462 */
	0x465, /* 0x464..0x464 */
	0x467, /* 0x466..0x466 */
	0x469, /* 0x468..0x468 */
	0x46b, /* 0x46a..0x46a */
	0x46d, /* 0x46c..0x46c */
	0x46f, /* 0x46e..0x46e */
	0x471, /* 0x470..0x470 */
	0x473, /* 0x472..0x472 */
	0x475, /* 0x474..0x474 */
	0x477, /* 0x476..0x476 */
	0x479, /* 0x478..0x478 */
	0x47b, /* 0x47a..0x47a */
	0x47d, /* 0x47c..0x47c */
	0x47f, /* 0x47e..0x47e */
	0x481, /* 0x480..0x480 */
	0x48b, /* 0x48a..0x48a */
	0x48d, /* 0x48c..0x48c */
	0x48f, /* 0x48e..0x48e */
	0x491, /* 0x490..0x490 */
	0x493, /* 0x492..0x492 */
	0x495, /* 0x494..0x494 */
	0x497, /* 0x496..0x496 */
	0x499, /* 0x498..0x498 */
	0x49b, /* 0x49a..0x49a */
	0x49d, /* 0x49c..0x49c */
	0x49f, /* 0x49e..0x49e */
	0x4a1, /* 0x4a0..0x4a0 */
	0x4a3, /* 0x4a2..0x4a2 */
	0x4a5, /* 0x4a4..0x4a4 */
	0x4a7, /* 0x4a6..0x4a6 */
	0x4a9, /* 0x4a8..0x4a8 */
	0x4ab, /* 0x4aa..0x4aa */
	0x4ad, /* 0x4ac..0x4ac */
	0x4af, /* 0x4ae..0x4ae */
	0x4b1, /* 0x4b0..0x4b0 */
	0x4b3, /* 0x4b2..0x4b2 */
	0x4b5, /* 0x4b4..0x4b4 */
	0x4b7, /* 0x4b6..0x4b6 */
	0x4b9, /* 0x4b8..0x4b8 */
	0x4bb, /* 0x4ba..0x4ba */
	0x4bd, /* 0x4bc..0x4bc */
	0x4bf, /* 0x4be..0x4be */
	0x4cf, /* 0x4c0..0x4c0 */
	0x4c2, /* 0x4c1..0x4c1 */
	0x4c4, /* 0x4c3..0x4c3 */
	0x4c6, /* 0x4c5..0x4c5 */
	0x4c8, /* 0x4c7..0x4c7 */
	0x4ca, /* 0x4c9..0x4c9 */
	0x4cc, /* 0x4cb..0x4cb */
	0x4ce, /* 0x4cd..0x4cd */
	0x4d1, /* 0x4d0..0x4d0 */
	0x4d3, /* 0x4d2..0x4d2 */
	0x4d5, /* 0x4d4..0x4d4 */
	0x4d7, /* 0x4d6..0x4d6 */
	0x4d9, /* 0x4d8..0x4d8 */
	0x4db, /* 0x4da..0x4da */
	0x4dd, /* 0x4dc..0x4dc */
	0x4df, /* 0x4de..0x4de */
	0x4e1, /* 0x4e0..0x4e0 */
	0x4e3, /* 0x4e2..0x4e2 */
	0x4e5, /* 0x4e4..0x4e4 */
	0x4e7, /* 0x4e6..0x4e6 */
	0x4e9, /* 0x4e8..0x4e8 */
	0x4eb, /* 0x4ea..0x4ea */
	0x4ed, /* 0x4ec..0x4ec */
	0x4ef, /* 0x4ee..0x4ee */
	0x4f1, /* 0x4f0..0x4f0 */
	0x4f3, /* 0x4f2..0x4f2 */
	0x4f5, /* 0x4f4..0x4f4 */
	0x4f7, /* 0x4f6..0x4f6 */
	0x4f9, /* 0x4f8..0x4f8 */
	0x4fb, /* 0x4fa..0x4fa */
	0x4fd, /* 0x4fc..0x4fc */
	0x4ff, /* 0x4fe..0x4fe */
	0x501, /* 0x500..0x500 */
	0x503, /* 0x502..0x502 */
	0x505, /* 0x504..0x504 */
	0x507, /* 0x506..0x506 */
	0x509, /* 0x508..0x508 */
	0x50b, /* 0x50a..0x50a */
	0x50d, /* 0x50c..0x50c */
	0x50f, /* 0x50e..0x50e */
	0x511, /* 0x510..0x510 */
	0x513, /* 0x512..0x512 */
	0x515, /* 0x514..0x514 */
	0x517, /* 0x516..0x516 */
	0x519, /* 0x518..0x518 */
	0x51b, /* 0x51a..0x51a */
	0x51d, /* 0x51c..0x51c */
	0x51f, /* 0x51e..0x51e */
	0x521, /* 0x520..0x520 */
	0x523, /* 0x522..0x522 */
	0x525, /* 0x524..0x524 */
	0x527, /* 0x526..0x526 */
	0x529, /* 0x528..0x528 */
	0x52b, /* 0x52a..0x52a */
	0x52d, /* 0x52c..0x52c */
	0x52f, /* 0x52e..0x52e */
	0x561, /* 0x531..0x556 */
	0x2d00, /* 0x10a0..0x10c5 */
	0x2d27, /* 0x10c7..0x10c7 */
	0x2d2d, /* 0x10cd..0x10cd */
	0xab70, /* 0x13a0..0x13ef */
	0x13f8, /* 0x13f0..0x13f5 */
	0x1e01, /* 0x1e00..0x1e00 */
	0x1e03, /* 0x1e02..0x1e02 */
	0x1e05, /* 0x1e04..0x1e04 */
	0x1e07, /* 0x1e06..0x1e06 */
	0x1e09, /* 0x1e08..0x1e08 */
	0x1e0b, /* 0x1e0a..0x1e0a */
	0x1e0d, /* 0x1e0c..0x1e0c */
	0x1e0f, /* 0x1e0e..0x1e0e */
	0x1e11, /* 0x1e10..0x1e10 */
	0x1e13, /* 0x1e12..0x1e12 */
	0x1e15, /* 0x1e14..0x1e14 */
	0x1e17, /* 0x1e16..0x1e16 */
	0x1e19, /* 0x1e18..0x1e18 */
	0x1e1b, /* 0x1e1a..0x1e1a */
	0x1e1d, /* 0x1e1c..0x1e1c */
	0x1e1f, /* 0x1e1e..0x1e1e */
	0x1e21, /* 0x1e20..0x1e20 */
	0x1e23, /* 0x1e22..0x1e22 */
	0x1e25, /* 0x1e24..0x1e24 */
	0x1e27, /* 0x1e26..0x1e26 */
	0x1e29, /* 0x1e28..0x1e28 */
	0x1e2b, /* 0x1e2a..0x1e2a */
	0x1e2d, /* 0x1e2c..0x1e2c */
	0x1e2f, /* 0x1e2e..0x1e2e */
	0x1e31, /* 0x1e30..0x1e30 */
	0x1e33, /* 0x1e32..0x1e32 */
	0x1e35, /* 0x1e34..0x1e34 */
	0x1e37, /* 0x1e36..0x1e36 */
	0x1e39, /* 0x1e38..0x1e38 */
	0x1e3b, /* 0x1e3a..0x1e3a */
	0x1e3d, /* 0x1e3c..0x1e3c */
	0x1e3f, /* 0x1e3e..0x1e3e */
	0x1e41, /* 0x1e40..0x1e40 */
	0x1e43, /* 0x1e42..0x1e42 */
	0x1e45, /* 0x1e44..0x1e44 */
	0x1e47, /* 0x1e46..0x1e46 */
	0x1e49, /* 0x1e48..0x1e48 */
	0x1e4b, /* 0x1e4a..0x1e4a */
	0x1e4d, /* 0x1e4c..0x1e4c */
	0x1e4f, /* 0x1e4e..0x1e4e */
	0x1e51, /* 0x1e50..0x1e50 */
	0x1e53, /* 0x1e52..0x1e52 */
	0x1e55, /* 0x1e54..0x1e54 */
	0x1e57, /* 0x1e56..0x1e56 */
	0x1e59, /* 0x1e58..0x1e58 */
	0x1e5b, /* 0x1e5a..0x1e5a */
	0x1e5d, /* 0x1e5c..0x1e5c */
	0x1e5f, /* 0x1e5e..0x1e5e */
	0x1e61, /* 0x1e60..0x1e60 */
	0x1e63, /* 0x1e62..0x1e62 */
	0x1e65, /* 0x1e64..0x1e64 */
	0x1e67, /* 0x1e66..0x1e66 */
	0x1e69, /* 0x1e68..0x1e68 */
	0x1e6b, /* 0x1e6a..0x1e6a */
	0x1e6d, /* 0x1e6c..0x1e6c */
	0x1e6f, /* 0x1e6e..0x1e6e */
	0x1e71, /* 0x1e70..0x1e70 */
	0x1e73, /* 0x1e72..0x1e72 */
	0x1e75, /* 0x1e74..0x1e74 */
	0x1e77, /* 0x1e76..0x1e76 */
	0x1e79, /* 0x1e78..0x1e78 */
	0x1e7b, /* 0x1e7a..0x1e7a */
	0x1e7d, /* 0x1e7c..0x1e7c */
	0x1e7f, /* 0x1e7e..0x1e7e */
	0x1e81, /* 0x1e80..0x1e80 */
	0x1e83, /* 0x1e82..0x1e82 */
	0x1e85, /* 0x1e84..0x1e84 */
	0x1e87, /* 0x1e86..0x1e86 */
	0x1e89, /* 0x1e88..0x1e88 */
	0x1e8b, /* 0x1e8a..0x1e8a */
	0x1e8d, /* 0x1e8c..0x1e8c */
	0x1e8f, /* 0x1e8e..0x1e8e */
	0x1e91, /* 0x1e90..0x1e90 */
	0x1e93, /* 0x1e92..0x1e92 */
	0x1e95, /* 0x1e94..0x1e94 */
	0xdf, /* 0x1e9e..0x1e9e */
	0x1ea1, /* 0x1ea0..0x1ea0 */
	0x1ea3, /* 0x1ea2..0x1ea2 */
	0x1ea5, /* 0x1ea4..0x1ea4 */
	0x1ea7, /* 0x1ea6..0x1ea6 */
	0x1ea9, /* 0x1ea8..0x1ea8 */
	0x1eab, /* 0x1eaa..0x1eaa */
	0x1ead, /* 0x1eac..0x1eac */
	0x1eaf, /* 0x1eae..0x1eae */
	0x1eb1, /* 0x1eb0..0x1eb0 */
	0x1eb3, /* 0x1eb2..0x1eb2 */
	0x1eb5, /* 0x1eb4..0x1eb4 */
	0x1eb7, /* 0x1eb6..0x1eb6 */
	0x1eb9, /* 0x1eb8..0x1eb8 */
	0x1ebb, /* 0x1eba..0x1eba */
	0x1ebd, /* 0x1ebc..0x1ebc */
	0x1ebf, /* 0x1ebe..0x1ebe */
	0x1ec1, /* 0x1ec0..0x1ec0 */
	0x1ec3, /* 0x1ec2..0x1ec2 */
	0x1ec5, /* 0x1ec4..0x1ec4 */
	0x1ec7, /* 0x1ec6..0x1ec6 */
	0x1ec9, /* 0x1ec8..0x1ec8 */
	0x1ecb, /* 0x1eca..0x1eca */
	0x1ecd, /* 0x1ecc..0x1ecc */
	0x1ecf, /* 0x1ece..0x1ece */
	0x1ed1, /* 0x1ed0..0x1ed0 */
	0x1ed3, /* 0x1ed2..0x1ed2 */
	0x1ed5, /* 0x1ed4..0x1ed4 */
	0x1ed7, /* 0x1ed6..0x1ed6 */
	0x1ed9, /* 0x1ed8..0x1ed8 */
	0x1edb, /* 0x1eda..0x1eda */
	0x1edd, /* 0x1edc..0x1edc */
	0x1edf, /* 0x1ede..0x1ede */
	0x1ee1, /* 0x1ee0..0x1ee0 */
	0x1ee3, /* 0x1ee2..0x1ee2 */
	0x1ee5, /* 0x1ee4..0x1ee4 */
	0x1ee7, /* 0x1ee6..0x1ee6 */
	0x1ee9, /* 0x1ee8..0x1ee8 */
	0x1eeb, /* 0x1eea..0x1eea */
	0x1eed, /* 0x1eec..0x1eec */
	0x1eef, /* 0x1eee..0x1eee */
	0x1ef1, /* 0x1ef0..0x1ef0 */
	0x1ef3, /* 0x1ef2..0x1ef2 */
	0x1ef5, /* 0x1ef4..0x1ef4 */
	0x1ef7, /* 0x1ef6..0x1ef6 */
	0x1ef9, /* 0x1ef8..0x1ef8 */
	0x1efb, /* 0x1efa..0x1efa */
	0x1efd, /* 0x1efc..0x1efc */
	0x1eff, /* 0x1efe..0x1efe */
	0x1f00, /* 0x1f08..0x1f0f */
	0x1f10, /* 0x1f18..0x1f1d */
	0x1f20, /* 0x1f28..0x1f2f */
	0x1f30, /* 0x1f38..0x1f3f */
	0x1f40, /* 0x1f48..0x1f4d */
	0x1f51, /* 0x1f59..0x1f59 */
	0x1f53, /* 0x1f5b..0x1f5b */
	0x1f55, /* 0x1f5d..0x1f5d */
	0x1f57, /* 0x1f5f..0x1f5f */
	0x1f60, /* 0x1f68..0x1f6f */
	0x1f80, /* 0x1f88..0x1f8f */
	0x1f90, /* 0x1f98..0x1f9f */
	0x1fa0, /* 0x1fa8..0x1faf */
	0x1fb0, /* 0x1fb8..0x1fb9 */
	0x1f70, /* 0x1fba..0x1fbb */
	0x1fb3, /* 0x1fbc..0x1fbc */
	0x1f72, /* 0x1fc8..0x1fcb */
	0x1fc3, /* 0x1fcc..0x1fcc */
	0x1fd0, /* 0x1fd8..0x1fd9 */
	0x1f76, /* 0x1fda..0x1fdb */
	0x1fe0, /* 0x1fe8..0x1fe9 */
	0x1f7a, /* 0x1fea..0x1feb */
	0x1fe5, /* 0x1fec..0x1fec */
	0x1f78, /* 0x1ff8..0x1ff9 */
	0x1f7c, /* 0x1ffa..0x1ffb */
	0x1ff3, /* 0x1ffc..0x1ffc */
	0x3c9, /* 0x2126..0x2126 */
	0x6b, /* 0x212a..0x212a */
	0xe5, /* 0x212b..0x212b */
	0x214e, /* 0x2132..0x2132 */
	0x2170, /* 0x2160..0x216f */
	0x2184, /* 0x2183..0x2183 */
	0x24d0, /* 0x24b6..0x24cf */
	0x2c30, /* 0x2c00..0x2c2e */
	0x2c61, /* 0x2c60..0x2c60 */
	0x26b, /* 0x2c62..0x2c62 */
	0x1d7d, /* 0x2c63..0x2c63 */
	0x27d, /* 0x2c64..0x2c64 */
	0x2c68, /* 0x2c67..0x2c67 */
	0x2c6a, /* 0x2c69..0x2c69 */
	0x2c6c, /* 0x2c6b..0x2c6b */
	0x251, /* 0x2c6d..0x2c6d */
	0x271, /* 0x2c6e..0x2c6e */
	0x250, /* 0x2c6f..0x2c6f */
	0x252, /* 0x2c70..0x2c70 */
	0x2c73, /* 0x2c72..0x2c72 */
	0x2c76, /* 0x2c75..0x2c75 */
	0x23f, /* 0x2c7e..0x2c7f */
	0x2c81, /* 0x2c80..0x2c80 */
	0x2c83, /* 0x2c82..0x2c82 */
	0x2c85, /* 0x2c84..0x2c84 */
	0x2c87, /* 0x2c86..0x2c86 */
	0x2c89, /* 0x2c88..0x2c88 */
	0x2c8b, /* 0x2c8a..0x2c8a */
	0x2c8d, /* 0x2c8c..0x2c8c */
	0x2c8f, /* 0x2c8e..0x2c8e */
	0x2c91, /* 0x2c90..0x2c90 */
	0x2c93, /* 0x2c92..0x2c92 */
	0x2c95, /* 0x2c94..0x2c94 */
	0x2c97, /* 0x2c96..0x2c96 */
	0x2c99, /* 0x2c98..0x2c98 */
	0x2c9b, /* 0x2c9a..0x2c9a */
	0x2c9d, /* 0x2c9c..0x2c9c */
	0x2c9f, /* 0x2c9e..0x2c9e */
	0x2ca1, /* 0x2ca0..0x2ca0 */
	0x2ca3, /* 0x2ca2..0x2ca2 */
	0x2ca5, /* 0x2ca4..0x2ca4 */
	0x2ca7, /* 0x2ca6..0x2ca6 */
	0x2ca9, /* 0x2ca8..0x2ca8 */
	0x2cab, /* 0x2caa..0x2caa */
	0x2cad, /* 0x2cac..0x2cac */
	0x2caf, /* 0x2cae..0x2cae */
	0x2cb1, /* 0x2cb0..0x2cb0 */
	0x2cb3, /* 0x2cb2..0x2cb2 */
	0x2cb5, /* 0x2cb4..0x2cb4 */
	0x2cb7, /* 0x2cb6..0x2cb6 */
	0x2cb9, /* 0x2cb8..0x2cb8 */
	0x2cbb, /* 0x2cba..0x2cba */
	0x2cbd, /* 0x2cbc..0x2cbc */
	0x2cbf, /* 0x2cbe..0x2cbe */
	0x2cc1, /* 0x2cc0..0x2cc0 */
	0x2cc3, /* 0x2cc2..0x2cc2 */
	0x2cc5, /* 0x2cc4..0x2cc4 */
	0x2cc7, /* 0x2cc6..0x2cc6 */
	0x2cc9, /* 0x2cc8..0x2cc8 */
	0x2ccb, /* 0x2cca..0x2cca */
	0x2ccd, /* 0x2ccc..0x2ccc */
	0x2ccf, /* 0x2cce..0x2cce */
	0x2cd1, /* 0x2cd0..0x2cd0 */
	0x2cd3, /* 0x2cd2..0x2cd2 */
	0x2cd5, /* 0x2cd4..0x2cd4 */
	0x2cd7, /* 0x2cd6..0x2cd6 */
	0x2cd9, /* 0x2cd8..0x2cd8 */
	0x2cdb, /* 0x2cda..0x2cda */
	0x2cdd, /* 0x2cdc..0x2cdc */
	0x2cdf, /* 0x2cde..0x2cde */
	0x2ce1, /* 0x2ce0..0x2ce0 */
	0x2ce3, /* 0x2ce2..0x2ce2 */
	0x2cec, /* 0x2ceb..0x2ceb */
	0x2cee, /* 0x2ced..0x2ced */
	0x2cf3, /* 0x2cf2..0x2cf2 */
	0xa641, /* 0xa640..0xa640 */
	0xa643, /* 0xa642..0xa642 */
	0xa645, /* 0xa644..0xa644 */
	0xa647, /* 0xa646..0xa646 */
	0xa649, /* 0xa648..0xa648 */
	0xa64b, /* 0xa64a..0xa64a */
	0xa64d, /* 0xa64c..0xa64c */
	0xa64f, /* 0xa64e..0xa64e */
	0xa651, /* 0xa650..0xa650 */
	0xa653, /* 0xa652..0xa652 */
	0xa655, /* 0xa654..0xa654 */
	0xa657, /* 0xa656..0xa656 */
	0xa659, /* 0xa658..0xa658 */
	0xa65b, /* 0xa65a..0xa65a */
	0xa65d, /* 0xa65c..0xa65c */
	0xa65f, /* 0xa65e..0xa65e */
	0xa661, /* 0xa660..0xa660 */
	0xa663, /* 0xa662..0xa662 */
	0xa665, /* 0xa664..0xa664 */
	0xa667, /* 0xa666..0xa666 */
	0xa669, /* 0xa668..0xa668 */
	0xa66b, /* 0xa66a..0xa66a */
	0xa66d, /* 0xa66c..0xa66c */
	0xa681, /* 0xa680..0xa680 */
	0xa683, /* 0xa682..0xa682 */
	0xa685, /* 0xa684..0xa684 */
	0xa687, /* 0xa686..0xa686 */
	0xa689, /* 0xa688..0xa688 */
	0xa68b, /* 0xa68a..0xa68a */
	0xa68d, /* 0xa68c..0xa68c */
	0xa68f, /* 0xa68e..0xa68e */
	0xa691, /* 0xa690..0xa690 */
	0xa693, /* 0xa692..0xa692 */
	0xa695, /* 0xa694..0xa694 */
	0xa697, /* 0xa696..0xa696 */
	0xa699, /* 0xa698..0xa698 */
	0xa69b, /* 0xa69a..0xa69a */
	0xa723, /* 0xa722..0xa722 */
	0xa725, /* 0xa724..0xa724 */
	0xa727, /* 0xa726..0xa726 */
	0xa729, /* 0xa728..0xa728 */
	0xa72b, /* 0xa72a..0xa72a */
	0xa72d, /* 0xa72c..0xa72c */
	0xa72f, /* 0xa72e..0xa72e */
	0xa733, /* 0xa732..0xa732 */
	0xa735, /* 0xa734..0xa734 */
	0xa737, /* 0xa736..0xa736 */
	0xa739, /* 0xa738..0xa738 */
	0xa73b, /* 0xa73a..0xa73a */
	0xa73d, /* 0xa73c..0xa73c */
	0xa73f, /* 0xa73e..0xa73e */
	0xa741, /* 0xa740..0xa740 */
	0xa743, /* 0xa742..0xa742 */
	0xa745, /* 0xa744..0xa744 */
	0xa747, /* 0xa746..0xa746 */
	0xa749, /* 0xa748..0xa748 */
	0xa74b, /* 0xa74a..0xa74a */
	0xa74d, /* 0xa74c..0xa74c */
	0xa74f, /* 0xa74e..0xa74e */
	0xa751, /* 0xa750..0xa750 */
	0xa753, /* 0xa752..0xa752 */
	0xa755, /* 0xa754..0xa754 */
	0xa757, /* 0xa756..0xa756 */
	0xa759, /* 0xa758..0xa758 */
	0xa75b, /* 0xa75a..0xa75a */
	0xa75d, /* 0xa75c..0xa75c */
	0xa75f, /* 0xa75e..0xa75e */
	0xa761, /* 0xa760..0xa760 */
	0xa763, /* 0xa762..0xa762 */
	0xa765, /* 0xa764..0xa764 */
	0xa767, /* 0xa766..0xa766 */
	0xa769, /* 0xa768..0xa768 */
	0xa76b, /* 0xa76a..0xa76a */
	0xa76d, /* 0xa76c..0xa76c */
	0xa76f, /* 0xa76e..0xa76e */
	0xa77a, /* 0xa779..0xa779 */
	0xa77c, /* 0xa77b..0xa77b */
	0x1d79, /* 0xa77d..0xa77d */
	0xa77f, /* 0xa77e..0xa77e */
	0xa781, /* 0xa780..0xa780 */
	0xa783, /* 0xa782..0xa782 */
	0xa785, /* 0xa784..0xa784 */
	0xa787, /* 0xa786..0xa786 */
	0xa78c, /* 0xa78b..0xa78b */
	0x265, /* 0xa78d..0xa78d */
	0xa791, /* 0xa790..0xa790 */
	0xa793, /* 0xa792..0xa792 */
	0xa797, /* 0xa796..0xa796 */
	0xa799, /* 0xa798..0xa798 */
	0xa79b, /* 0xa79a..0xa79a */
	0xa79d, /* 0xa79c..0xa79c */
	0xa79f, /* 0xa79e..0xa79e */
	0xa7a1, /* 0xa7a0..0xa7a0 */
	0xa7a3, /* 0xa7a2..0xa7a2 */
	0xa7a5, /* 0xa7a4..0xa7a4 */
	0xa7a7, /* 0xa7a6..0xa7a6 */
	0xa7a9, /* 0xa7a8..0xa7a8 */
	0x266, /* 0xa7aa..0xa7aa */
	0x25c, /* 0xa7ab..0xa7ab */
	0x261, /* 0xa7ac..0xa7ac */
	0x26c, /* 0xa7ad..0xa7ad */
	0x26a, /* 0xa7ae..0xa7ae */
	0x29e, /* 0xa7b0..0xa7b0 */
	0x287, /* 0xa7b1..0xa7b1 */
	0x29d, /* 0xa7b2..0xa7b2 */
	0xab53, /* 0xa7b3..0xa7b3 */
	0xa7b5, /* 0xa7b4..0xa7b4 */
	0xa7b7, /* 0xa7b6..0xa7b6 */
	0xff41, /* 0xff21..0xff3a */
	0x10428, /* 0x10400..0x10427 */
	0x104d8, /* 0x104b0..0x104d3 */
	0x10cc0, /* 0x10c80..0x10cb2 */
	0x118c0, /* 0x118a0..0x118bf */
	0x1e922, /* 0x1e900..0x1e921 */
	0x0
};

struct interval totitle_table[] = {
	{ 0x61, 0x7a }, /* 0x41 */
	{ 0xb5, 0xb5 }, /* 0x39c */
	{ 0xe0, 0xf6 }, /* 0xc0 */
	{ 0xf8, 0xfe }, /* 0xd8 */
	{ 0xff, 0xff }, /* 0x178 */
	{ 0x101, 0x101 }, /* 0x100 */
	{ 0x103, 0x103 }, /* 0x102 */
	{ 0x105, 0x105 }, /* 0x104 */
	{ 0x107, 0x107 }, /* 0x106 */
	{ 0x109, 0x109 }, /* 0x108 */
	{ 0x10b, 0x10b }, /* 0x10a */
	{ 0x10d, 0x10d }, /* 0x10c */
	{ 0x10f, 0x10f }, /* 0x10e */
	{ 0x111, 0x111 }, /* 0x110 */
	{ 0x113, 0x113 }, /* 0x112 */
	{ 0x115, 0x115 }, /* 0x114 */
	{ 0x117, 0x117 }, /* 0x116 */
	{ 0x119, 0x119 }, /* 0x118 */
	{ 0x11b, 0x11b }, /* 0x11a */
	{ 0x11d, 0x11d }, /* 0x11c */
	{ 0x11f, 0x11f }, /* 0x11e */
	{ 0x121, 0x121 }, /* 0x120 */
	{ 0x123, 0x123 }, /* 0x122 */
	{ 0x125, 0x125 }, /* 0x124 */
	{ 0x127, 0x127 }, /* 0x126 */
	{ 0x129, 0x129 }, /* 0x128 */
	{ 0x12b, 0x12b }, /* 0x12a */
	{ 0x12d, 0x12d }, /* 0x12c */
	{ 0x12f, 0x12f }, /* 0x12e */
	{ 0x131, 0x131 }, /* 0x49 */
	{ 0x133, 0x133 }, /* 0x132 */
	{ 0x135, 0x135 }, /* 0x134 */
	{ 0x137, 0x137 }, /* 0x136 */
	{ 0x13a, 0x13a }, /* 0x139 */
	{ 0x13c, 0x13c }, /* 0x13b */
	{ 0x13e, 0x13e }, /* 0x13d */
	{ 0x140, 0x140 }, /* 0x13f */
	{ 0x142, 0x142 }, /* 0x141 */
	{ 0x144, 0x144 }, /* 0x143 */
	{ 0x146, 0x146 }, /* 0x145 */
	{ 0x148, 0x148 }, /* 0x147 */
	{ 0x14b, 0x14b }, /* 0x14a */
	{ 0x14d, 0x14d }, /* 0x14c */
	{ 0x14f, 0x14f }, /* 0x14e */
	{ 0x151, 0x151 }, /* 0x150 */
	{ 0x153, 0x153 }, /* 0x152 */
	{ 0x155, 0x155 }, /* 0x154 */
	{ 0x157, 0x157 }, /* 0x156 */
	{ 0x159, 0x159 }, /* 0x158 */
	{ 0x15b, 0x15b }, /* 0x15a */
	{ 0x15d, 0x15d }, /* 0x15c */
	{ 0x15f, 0x15f }, /* 0x15e */
	{ 0x161, 0x161 }, /* 0x160 */
	{ 0x163, 0x163 }, /* 0x162 */
	{ 0x165, 0x165 }, /* 0x164 */
	{ 0x167, 0x167 }, /* 0x166 */
	{ 0x169, 0x169 }, /* 0x168 */
	{ 0x16b, 0x16b }, /* 0x16a */
	{ 0x16d, 0x16d }, /* 0x16c */
	{ 0x16f, 0x16f }, /* 0x16e */
	{ 0x171, 0x171 }, /* 0x170 */
	{ 0x173, 0x173 }, /* 0x172 */
	{ 0x175, 0x175 }, /* 0x174 */
	{ 0x177, 0x177 }, /* 0x176 */
	{ 0x17a, 0x17a }, /* 0x179 */
	{ 0x17c, 0x17c }, /* 0x17b */
	{ 0x17e, 0x17e }, /* 0x17d */
	{ 0x17f, 0x17f }, /* 0x53 */
	{ 0x180, 0x180 }, /* 0x243 */
	{ 0x183, 0x183 }, /* 0x182 */
	{ 0x185, 0x185 }, /* 0x184 */
	{ 0x188, 0x188 }, /* 0x187 */
	{ 0x18c, 0x18c }, /* 0x18b */
	{ 0x192, 0x192 }, /* 0x191 */
	{ 0x195, 0x195 }, /* 0x1f6 */
	{ 0x199, 0x199 }, /* 0x198 */
	{ 0x19a, 0x19a }, /* 0x23d */
	{ 0x19e, 0x19e }, /* 0x220 */
	{ 0x1a1, 0x1a1 }, /* 0x1a0 */
	{ 0x1a3, 0x1a3 }, /* 0x1a2 */
	{ 0x1a5, 0x1a5 }, /* 0x1a4 */
	{ 0x1a8, 0x1a8 }, /* 0x1a7 */
	{ 0x1ad, 0x1ad }, /* 0x1ac */
	{ 0x1b0, 0x1b0 }, /* 0x1af */
	{ 0x1b4, 0x1b4 }, /* 0x1b3 */
	{ 0x1b6, 0x1b6 }, /* 0x1b5 */
	{ 0x1b9, 0x1b9 }, /* 0x1b8 */
	{ 0x1bd, 0x1bd }, /* 0x1bc */
	{ 0x1bf, 0x1bf }, /* 0x1f7 */
	{ 0x1c4, 0x1c4 }, /* 0x1c5 */
	{ 0x1c6, 0x1c6 }, /* 0x1c5 */
	{ 0x1c7, 0x1c7 }, /* 0x1c8 */
	{ 0x1c9, 0x1c9 }, /* 0x1c8 */
	{ 0x1ca, 0x1ca }, /* 0x1cb */
	{ 0x1cc, 0x1cc }, /* 0x1cb */
	{ 0x1ce, 0x1ce }, /* 0x1cd */
	{ 0x1d0, 0x1d0 }, /* 0x1cf */
	{ 0x1d2, 0x1d2 }, /* 0x1d1 */
	{ 0x1d4, 0x1d4 }, /* 0x1d3 */
	{ 0x1d6, 0x1d6 }, /* 0x1d5 */
	{ 0x1d8, 0x1d8 }, /* 0x1d7 */
	{ 0x1da, 0x1da }, /* 0x1d9 */
	{ 0x1dc, 0x1dc }, /* 0x1db */
	{ 0x1dd, 0x1dd }, /* 0x18e */
	{ 0x1df, 0x1df }, /* 0x1de */
	{ 0x1e1, 0x1e1 }, /* 0x1e0 */
	{ 0x1e3, 0x1e3 }, /* 0x1e2 */
	{ 0x1e5, 0x1e5 }, /* 0x1e4 */
	{ 0x1e7, 0x1e7 }, /* 0x1e6 */
	{ 0x1e9, 0x1e9 }, /* 0x1e8 */
	{ 0x1eb, 0x1eb }, /* 0x1ea */
	{ 0x1ed, 0x1ed }, /* 0x1ec */
	{ 0x1ef, 0x1ef }, /* 0x1ee */
	{ 0x1f1, 0x1f1 }, /* 0x1f2 */
	{ 0x1f3, 0x1f3 }, /* 0x1f2 */
	{ 0x1f5, 0x1f5 }, /* 0x1f4 */
	{ 0x1f9, 0x1f9 }, /* 0x1f8 */
	{ 0x1fb, 0x1fb }, /* 0x1fa */
	{ 0x1fd, 0x1fd }, /* 0x1fc */
	{ 0x1ff, 0x1ff }, /* 0x1fe */
	{ 0x201, 0x201 }, /* 0x200 */
	{ 0x203, 0x203 }, /* 0x202 */
	{ 0x205, 0x205 }, /* 0x204 */
	{ 0x207, 0x207 }, /* 0x206 */
	{ 0x209, 0x209 }, /* 0x208 */
	{ 0x20b, 0x20b }, /* 0x20a */
	{ 0x20d, 0x20d }, /* 0x20c */
	{ 0x20f, 0x20f }, /* 0x20e */
	{ 0x211, 0x211 }, /* 0x210 */
	{ 0x213, 0x213 }, /* 0x212 */
	{ 0x215, 0x215 }, /* 0x214 */
	{ 0x217, 0x217 }, /* 0x216 */
	{ 0x219, 0x219 }, /* 0x218 */
	{ 0x21b, 0x21b }, /* 0x21a */
	{ 0x21d, 0x21d }, /* 0x21c */
	{ 0x21f, 0x21f }, /* 0x21e */
	{ 0x223, 0x223 }, /* 0x222 */
	{ 0x225, 0x225 }, /* 0x224 */
	{ 0x227, 0x227 }, /* 0x226 */
	{ 0x229, 0x229 }, /* 0x228 */
	{ 0x22b, 0x22b }, /* 0x22a */
	{ 0x22d, 0x22d }, /* 0x22c */
	{ 0x22f, 0x22f }, /* 0x22e */
	{ 0x231, 0x231 }, /* 0x230 */
	{ 0x233, 0x233 }, /* 0x232 */
	{ 0x23c, 0x23c }, /* 0x23b */
	{ 0x23f, 0x240 }, /* 0x2c7e */
	{ 0x242, 0x242 }, /* 0x241 */
	{ 0x247, 0x247 }, /* 0x246 */
	{ 0x249, 0x249 }, /* 0x248 */
	{ 0x24b, 0x24b }, /* 0x24a */
	{ 0x24d, 0x24d }, /* 0x24c */
	{ 0x24f, 0x24f }, /* 0x24e */
	{ 0x250, 0x250 }, /* 0x2c6f */
	{ 0x251, 0x251 }, /* 0x2c6d */
	{ 0x252, 0x252 }, /* 0x2c70 */
	{ 0x253, 0x253 }, /* 0x181 */
	{ 0x254, 0x254 }, /* 0x186 */
	{ 0x256, 0x257 }, /* 0x189 */
	{ 0x259, 0x259 }, /* 0x18f */
	{ 0x25b, 0x25b }, /* 0x190 */
	{ 0x25c, 0x25c }, /* 0xa7ab */
	{ 0x260, 0x260 }, /* 0x193 */
	{ 0x261, 0x261 }, /* 0xa7ac */
	{ 0x263, 0x263 }, /* 0x194 */
	{ 0x265, 0x265 }, /* 0xa78d */
	{ 0x266, 0x266 }, /* 0xa7aa */
	{ 0x268, 0x268 }, /* 0x197 */
	{ 0x269, 0x269 }, /* 0x196 */
	{ 0x26a, 0x26a }, /* 0xa7ae */
	{ 0x26b, 0x26b }, /* 0x2c62 */
	{ 0x26c, 0x26c }, /* 0xa7ad */
	{ 0x26f, 0x26f }, /* 0x19c */
	{ 0x271, 0x271 }, /* 0x2c6e */
	{ 0x272, 0x272 }, /* 0x19d */
	{ 0x275, 0x275 }, /* 0x19f */
	{ 0x27d, 0x27d }, /* 0x2c64 */
	{ 0x280, 0x280 }, /* 0x1a6 */
	{ 0x283, 0x283 }, /* 0x1a9 */
	{ 0x287, 0x287 }, /* 0xa7b1 */
	{ 0x288, 0x288 }, /* 0x1ae */
	{ 0x289, 0x289 }, /* 0x244 */
	{ 0x28a, 0x28b }, /* 0x1b1 */
	{ 0x28c, 0x28c }, /* 0x245 */
	{ 0x292, 0x292 }, /* 0x1b7 */
	{ 0x29d, 0x29d }, /* 0xa7b2 */
	{ 0x29e, 0x29e }, /* 0xa7b0 */
	{ 0x345, 0x345 }, /* 0x399 */
	{ 0x371, 0x371 }, /* 0x370 */
	{ 0x373, 0x373 }, /* 0x372 */
	{ 0x377, 0x377 }, /* 0x376 */
	{ 0x37b, 0x37d }, /* 0x3fd */
	{ 0x3ac, 0x3ac }, /* 0x386 */
	{ 0x3ad, 0x3af }, /* 0x388 */
	{ 0x3b1, 0x3c1 }, /* 0x391 */
	{ 0x3c2, 0x3c2 }, /* 0x3a3 */
	{ 0x3c3, 0x3cb }, /* 0x3a3 */
	{ 0x3cc, 0x3cc }, /* 0x38c */
	{ 0x3cd, 0x3ce }, /* 0x38e */
	{ 0x3d0, 0x3d0 }, /* 0x392 */
	{ 0x3d1, 0x3d1 }, /* 0x398 */
	{ 0x3d5, 0x3d5 }, /* 0x3a6 */
	{ 0x3d6, 0x3d6 }, /* 0x3a0 */
	{ 0x3d7, 0x3d7 }, /* 0x3cf */
	{ 0x3d9, 0x3d9 }, /* 0x3d8 */
	{ 0x3db, 0x3db }, /* 0x3da */
	{ 0x3dd, 0x3dd }, /* 0x3dc */
	{ 0x3df, 0x3df }, /* 0x3de */
	{ 0x3e1, 0x3e1 }, /* 0x3e0 */
	{ 0x3e3, 0x3e3 }, /* 0x3e2 */
	{ 0x3e5, 0x3e5 }, /* 0x3e4 */
	{ 0x3e7, 0x3e7 }, /* 0x3e6 */
	{ 0x3e9, 0x3e9 }, /* 0x3e8 */
	{ 0x3eb, 0x3eb }, /* 0x3ea */
	{ 0x3ed, 0x3ed }, /* 0x3ec */
	{ 0x3ef, 0x3ef }, /* 0x3ee */
	{ 0x3f0, 0x3f0 }, /* 0x39a */
	{ 0x3f1, 0x3f1 }, /* 0x3a1 */
	{ 0x3f2, 0x3f2 }, /* 0x3f9 */
	{ 0x3f3, 0x3f3 }, /* 0x37f */
	{ 0x3f5, 0x3f5 }, /* 0x395 */
	{ 0x3f8, 0x3f8 }, /* 0x3f7 */
	{ 0x3fb, 0x3fb }, /* 0x3fa */
	{ 0x430, 0x44f }, /* 0x410 */
	{ 0x450, 0x45f }, /* 0x400 */
	{ 0x461, 0x461 }, /* 0x460 */
	{ 0x463, 0x463 }, /* 0x462 */
	{ 0x465, 0x465 }, /* 0x464 */
	{ 0x467, 0x467 }, /* 0x466 */
	{ 0x469, 0x469 }, /* 0x468 */
	{ 0x46b, 0x46b }, /* 0x46a */
	{ 0x46d, 0x46d }, /* 0x46c */
	{ 0x46f, 0x46f }, /* 0x46e */
	{ 0x471, 0x471 }, /* 0x470 */
	{ 0x473, 0x473 }, /* 0x472 */
	{ 0x475, 0x475 }, /* 0x474 */
	{ 0x477, 0x477 }, /* 0x476 */
	{ 0x479, 0x479 }, /* 0x478 */
	{ 0x47b, 0x47b }, /* 0x47a */
	{ 0x47d, 0x47d }, /* 0x47c */
	{ 0x47f, 0x47f }, /* 0x47e */
	{ 0x481, 0x481 }, /* 0x480 */
	{ 0x48b, 0x48b }, /* 0x48a */
	{ 0x48d, 0x48d }, /* 0x48c */
	{ 0x48f, 0x48f }, /* 0x48e */
	{ 0x491, 0x491 }, /* 0x490 */
	{ 0x493, 0x493 }, /* 0x492 */
	{ 0x495, 0x495 }, /* 0x494 */
	{ 0x497, 0x497 }, /* 0x496 */
	{ 0x499, 0x499 }, /* 0x498 */
	{ 0x49b, 0x49b }, /* 0x49a */
	{ 0x49d, 0x49d }, /* 0x49c */
	{ 0x49f, 0x49f }, /* 0x49e */
	{ 0x4a1, 0x4a1 }, /* 0x4a0 */
	{ 0x4a3, 0x4a3 }, /* 0x4a2 */
	{ 0x4a5, 0x4a5 }, /* 0x4a4 */
	{ 0x4a7, 0x4a7 }, /* 0x4a6 */
	{ 0x4a9, 0x4a9 }, /* 0x4a8 */
	{ 0x4ab, 0x4ab }, /* 0x4aa */
	{ 0x4ad, 0x4ad }, /* 0x4ac */
	{ 0x4af, 0x4af }, /* 0x4ae */
	{ 0x4b1, 0x4b1 }, /* 0x4b0 */
	{ 0x4b3, 0x4b3 }, /* 0x4b2 */
	{ 0x4b5, 0x4b5 }, /* 0x4b4 */
	{ 0x4b7, 0x4b7 }, /* 0x4b6 */
	{ 0x4b9, 0x4b9 }, /* 0x4b8 */
	{ 0x4bb, 0x4bb }, /* 0x4ba */
	{ 0x4bd, 0x4bd }, /* 0x4bc */
	{ 0x4bf, 0x4bf }, /* 0x4be */
	{ 0x4c2, 0x4c2 }, /* 0x4c1 */
	{ 0x4c4, 0x4c4 }, /* 0x4c3 */
	{ 0x4c6, 0x4c6 }, /* 0x4c5 */
	{ 0x4c8, 0x4c8 }, /* 0x4c7 */
	{ 0x4ca, 0x4ca }, /* 0x4c9 */
	{ 0x4cc, 0x4cc }, /* 0x4cb */
	{ 0x4ce, 0x4ce }, /* 0x4cd */
	{ 0x4cf, 0x4cf }, /* 0x4c0 */
	{ 0x4d1, 0x4d1 }, /* 0x4d0 */
	{ 0x4d3, 0x4d3 }, /* 0x4d2 */
	{ 0x4d5, 0x4d5 }, /* 0x4d4 */
	{ 0x4d7, 0x4d7 }, /* 0x4d6 */
	{ 0x4d9, 0x4d9 }, /* 0x4d8 */
	{ 0x4db, 0x4db }, /* 0x4da */
	{ 0x4dd, 0x4dd }, /* 0x4dc */
	{ 0x4df, 0x4df }, /* 0x4de */
	{ 0x4e1, 0x4e1 }, /* 0x4e0 */
	{ 0x4e3, 0x4e3 }, /* 0x4e2 */
	{ 0x4e5, 0x4e5 }, /* 0x4e4 */
	{ 0x4e7, 0x4e7 }, /* 0x4e6 */
	{ 0x4e9, 0x4e9 }, /* 0x4e8 */
	{ 0x4eb, 0x4eb }, /* 0x4ea */
	{ 0x4ed, 0x4ed }, /* 0x4ec */
	{ 0x4ef, 0x4ef }, /* 0x4ee */
	{ 0x4f1, 0x4f1 }, /* 0x4f0 */
	{ 0x4f3, 0x4f3 }, /* 0x4f2 */
	{ 0x4f5, 0x4f5 }, /* 0x4f4 */
	{ 0x4f7, 0x4f7 }, /* 0x4f6 */
	{ 0x4f9, 0x4f9 }, /* 0x4f8 */
	{ 0x4fb, 0x4fb }, /* 0x4fa */
	{ 0x4fd, 0x4fd }, /* 0x4fc */
	{ 0x4ff, 0x4ff }, /* 0x4fe */
	{ 0x501, 0x501 }, /* 0x500 */
	{ 0x503, 0x503 }, /* 0x502 */
	{ 0x505, 0x505 }, /* 0x504 */
	{ 0x507, 0x507 }, /* 0x506 */
	{ 0x509, 0x509 }, /* 0x508 */
	{ 0x50b, 0x50b }, /* 0x50a */
	{ 0x50d, 0x50d }, /* 0x50c */
	{ 0x50f, 0x50f }, /* 0x50e */
	{ 0x511, 0x511 }, /* 0x510 */
	{ 0x513, 0x513 }, /* 0x512 */
	{ 0x515, 0x515 }, /* 0x514 */
	{ 0x517, 0x517 }, /* 0x516 */
	{ 0x519, 0x519 }, /* 0x518 */
	{ 0x51b, 0x51b }, /* 0x51a */
	{ 0x51d, 0x51d }, /* 0x51c */
	{ 0x51f, 0x51f }, /* 0x51e */
	{ 0x521, 0x521 }, /* 0x520 */
	{ 0x523, 0x523 }, /* 0x522 */
	{ 0x525, 0x525 }, /* 0x524 */
	{ 0x527, 0x527 }, /* 0x526 */
	{ 0x529, 0x529 }, /* 0x528 */
	{ 0x52b, 0x52b }, /* 0x52a */
	{ 0x52d, 0x52d }, /* 0x52c */
	{ 0x52f, 0x52f }, /* 0x52e */
	{ 0x561, 0x586 }, /* 0x531 */
	{ 0x13f8, 0x13fd }, /* 0x13f0 */
	{ 0x1c80, 0x1c80 }, /* 0x412 */
	{ 0x1c81, 0x1c81 }, /* 0x414 */
	{ 0x1c82, 0x1c82 }, /* 0x41e */
	{ 0x1c83, 0x1c84 }, /* 0x421 */
	{ 0x1c85, 0x1c85 }, /* 0x422 */
	{ 0x1c86, 0x1c86 }, /* 0x42a */
	{ 0x1c87, 0x1c87 }, /* 0x462 */
	{ 0x1c88, 0x1c88 }, /* 0xa64a */
	{ 0x1d79, 0x1d79 }, /* 0xa77d */
	{ 0x1d7d, 0x1d7d }, /* 0x2c63 */
	{ 0x1e01, 0x1e01 }, /* 0x1e00 */
	{ 0x1e03, 0x1e03 }, /* 0x1e02 */
	{ 0x1e05, 0x1e05 }, /* 0x1e04 */
	{ 0x1e07, 0x1e07 }, /* 0x1e06 */
	{ 0x1e09, 0x1e09 }, /* 0x1e08 */
	{ 0x1e0b, 0x1e0b }, /* 0x1e0a */
	{ 0x1e0d, 0x1e0d }, /* 0x1e0c */
	{ 0x1e0f, 0x1e0f }, /* 0x1e0e */
	{ 0x1e11, 0x1e11 }, /* 0x1e10 */
	{ 0x1e13, 0x1e13 }, /* 0x1e12 */
	{ 0x1e15, 0x1e15 }, /* 0x1e14 */
	{ 0x1e17, 0x1e17 }, /* 0x1e16 */
	{ 0x1e19, 0x1e19 }, /* 0x1e18 */
	{ 0x1e1b, 0x1e1b }, /* 0x1e1a */
	{ 0x1e1d, 0x1e1d }, /* 0x1e1c */
	{ 0x1e1f, 0x1e1f }, /* 0x1e1e */
	{ 0x1e21, 0x1e21 }, /* 0x1e20 */
	{ 0x1e23, 0x1e23 }, /* 0x1e22 */
	{ 0x1e25, 0x1e25 }, /* 0x1e24 */
	{ 0x1e27, 0x1e27 }, /* 0x1e26 */
	{ 0x1e29, 0x1e29 }, /* 0x1e28 */
	{ 0x1e2b, 0x1e2b }, /* 0x1e2a */
	{ 0x1e2d, 0x1e2d }, /* 0x1e2c */
	{ 0x1e2f, 0x1e2f }, /* 0x1e2e */
	{ 0x1e31, 0x1e31 }, /* 0x1e30 */
	{ 0x1e33, 0x1e33 }, /* 0x1e32 */
	{ 0x1e35, 0x1e35 }, /* 0x1e34 */
	{ 0x1e37, 0x1e37 }, /* 0x1e36 */
	{ 0x1e39, 0x1e39 }, /* 0x1e38 */
	{ 0x1e3b, 0x1e3b }, /* 0x1e3a */
	{ 0x1e3d, 0x1e3d }, /* 0x1e3c */
	{ 0x1e3f, 0x1e3f }, /* 0x1e3e */
	{ 0x1e41, 0x1e41 }, /* 0x1e40 */
	{ 0x1e43, 0x1e43 }, /* 0x1e42 */
	{ 0x1e45, 0x1e45 }, /* 0x1e44 */
	{ 0x1e47, 0x1e47 }, /* 0x1e46 */
	{ 0x1e49, 0x1e49 }, /* 0x1e48 */
	{ 0x1e4b, 0x1e4b }, /* 0x1e4a */
	{ 0x1e4d, 0x1e4d }, /* 0x1e4c */
	{ 0x1e4f, 0x1e4f }, /* 0x1e4e */
	{ 0x1e51, 0x1e51 }, /* 0x1e50 */
	{ 0x1e53, 0x1e53 }, /* 0x1e52 */
	{ 0x1e55, 0x1e55 }, /* 0x1e54 */
	{ 0x1e57, 0x1e57 }, /* 0x1e56 */
	{ 0x1e59, 0x1e59 }, /* 0x1e58 */
	{ 0x1e5b, 0x1e5b }, /* 0x1e5a */
	{ 0x1e5d, 0x1e5d }, /* 0x1e5c */
	{ 0x1e5f, 0x1e5f }, /* 0x1e5e */
	{ 0x1e61, 0x1e61 }, /* 0x1e60 */
	{ 0x1e63, 0x1e63 }, /* 0x1e62 */
	{ 0x1e65, 0x1e65 }, /* 0x1e64 */
	{ 0x1e67, 0x1e67 }, /* 0x1e66 */
	{ 0x1e69, 0x1e69 }, /* 0x1e68 */
	{ 0x1e6b, 0x1e6b }, /* 0x1e6a */
	{ 0x1e6d, 0x1e6d }, /* 0x1e6c */
	{ 0x1e6f, 0x1e6f }, /* 0x1e6e */
	{ 0x1e71, 0x1e71 }, /* 0x1e70 */
	{ 0x1e73, 0x1e73 }, /* 0x1e72 */
	{ 0x1e75, 0x1e75 }, /* 0x1e74 */
	{ 0x1e77, 0x1e77 }, /* 0x1e76 */
	{ 0x1e79, 0x1e79 }, /* 0x1e78 */
	{ 0x1e7b, 0x1e7b }, /* 0x1e7a */
	{ 0x1e7d, 0x1e7d }, /* 0x1e7c */
	{ 0x1e7f, 0x1e7f }, /* 0x1e7e */
	{ 0x1e81, 0x1e81 }, /* 0x1e80 */
	{ 0x1e83, 0x1e83 }, /* 0x1e82 */
	{ 0x1e85, 0x1e85 }, /* 0x1e84 */
	{ 0x1e87, 0x1e87 }, /* 0x1e86 */
	{ 0x1e89, 0x1e89 }, /* 0x1e88 */
	{ 0x1e8b, 0x1e8b }, /* 0x1e8a */
	{ 0x1e8d, 0x1e8d }, /* 0x1e8c */
	{ 0x1e8f, 0x1e8f }, /* 0x1e8e */
	{ 0x1e91, 0x1e91 }, /* 0x1e90 */
	{ 0x1e93, 0x1e93 }, /* 0x1e92 */
	{ 0x1e95, 0x1e95 }, /* 0x1e94 */
	{ 0x1e9b, 0x1e9b }, /* 0x1e60 */
	{ 0x1ea1, 0x1ea1 }, /* 0x1ea0 */
	{ 0x1ea3, 0x1ea3 }, /* 0x1ea2 */
	{ 0x1ea5, 0x1ea5 }, /* 0x1ea4 */
	{ 0x1ea7, 0x1ea7 }, /* 0x1ea6 */
	{ 0x1ea9, 0x1ea9 }, /* 0x1ea8 */
	{ 0x1eab, 0x1eab }, /* 0x1eaa */
	{ 0x1ead, 0x1ead }, /* 0x1eac */
	{ 0x1eaf, 0x1eaf }, /* 0x1eae */
	{ 0x1eb1, 0x1eb1 }, /* 0x1eb0 */
	{ 0x1eb3, 0x1eb3 }, /* 0x1eb2 */
	{ 0x1eb5, 0x1eb5 }, /* 0x1eb4 */
	{ 0x1eb7, 0x1eb7 }, /* 0x1eb6 */
	{ 0x1eb9, 0x1eb9 }, /* 0x1eb8 */
	{ 0x1ebb, 0x1ebb }, /* 0x1eba */
	{ 0x1ebd, 0x1ebd }, /* 0x1ebc */
	{ 0x1ebf, 0x1ebf }, /* 0x1ebe */
	{ 0x1ec1, 0x1ec1 }, /* 0x1ec0 */
	{ 0x1ec3, 0x1ec3 }, /* 0x1ec2 */
	{ 0x1ec5, 0x1ec5 }, /* 0x1ec4 */
	{ 0x1ec7, 0x1ec7 }, /* 0x1ec6 */
	{ 0x1ec9, 0x1ec9 }, /* 0x1ec8 */
	{ 0x1ecb, 0x1ecb }, /* 0x1eca */
	{ 0x1ecd, 0x1ecd }, /* 0x1ecc */
	{ 0x1ecf, 0x1ecf }, /* 0x1ece */
	{ 0x1ed1, 0x1ed1 }, /* 0x1ed0 */
	{ 0x1ed3, 0x1ed3 }, /* 0x1ed2 */
	{ 0x1ed5, 0x1ed5 }, /* 0x1ed4 */
	{ 0x1ed7, 0x1ed7 }, /* 0x1ed6 */
	{ 0x1ed9, 0x1ed9 }, /* 0x1ed8 */
	{ 0x1edb, 0x1edb }, /* 0x1eda */
	{ 0x1edd, 0x1edd }, /* 0x1edc */
	{ 0x1edf, 0x1edf }, /* 0x1ede */
	{ 0x1ee1, 0x1ee1 }, /* 0x1ee0 */
	{ 0x1ee3, 0x1ee3 }, /* 0x1ee2 */
	{ 0x1ee5, 0x1ee5 }, /* 0x1ee4 */
	{ 0x1ee7, 0x1ee7 }, /* 0x1ee6 */
	{ 0x1ee9, 0x1ee9 }, /* 0x1ee8 */
	{ 0x1eeb, 0x1eeb }, /* 0x1eea */
	{ 0x1eed, 0x1eed }, /* 0x1eec */
	{ 0x1eef, 0x1eef }, /* 0x1eee */
	{ 0x1ef1, 0x1ef1 }, /* 0x1ef0 */
	{ 0x1ef3, 0x1ef3 }, /* 0x1ef2 */
	{ 0x1ef5, 0x1ef5 }, /* 0x1ef4 */
	{ 0x1ef7, 0x1ef7 }, /* 0x1ef6 */
	{ 0x1ef9, 0x1ef9 }, /* 0x1ef8 */
	{ 0x1efb, 0x1efb }, /* 0x1efa */
	{ 0x1efd, 0x1efd }, /* 0x1efc */
	{ 0x1eff, 0x1eff }, /* 0x1efe */
	{ 0x1f00, 0x1f07 }, /* 0x1f08 */
	{ 0x1f10, 0x1f15 }, /* 0x1f18 */
	{ 0x1f20, 0x1f27 }, /* 0x1f28 */
	{ 0x1f30, 0x1f37 }, /* 0x1f38 */
	{ 0x1f40, 0x1f45 }, /* 0x1f48 */
	{ 0x1f51, 0x1f51 }, /* 0x1f59 */
	{ 0x1f53, 0x1f53 }, /* 0x1f5b */
	{ 0x1f55, 0x1f55 }, /* 0x1f5d */
	{ 0x1f57, 0x1f57 }, /* 0x1f5f */
	{ 0x1f60, 0x1f67 }, /* 0x1f68 */
	{ 0x1f70, 0x1f71 }, /* 0x1fba */
	{ 0x1f72, 0x1f75 }, /* 0x1fc8 */
	{ 0x1f76, 0x1f77 }, /* 0x1fda */
	{ 0x1f78, 0x1f79 }, /* 0x1ff8 */
	{ 0x1f7a, 0x1f7b }, /* 0x1fea */
	{ 0x1f7c, 0x1f7d }, /* 0x1ffa */
	{ 0x1f80, 0x1f87 }, /* 0x1f88 */
	{ 0x1f90, 0x1f97 }, /* 0x1f98 */
	{ 0x1fa0, 0x1fa7 }, /* 0x1fa8 */
	{ 0x1fb0, 0x1fb1 }, /* 0x1fb8 */
	{ 0x1fb3, 0x1fb3 }, /* 0x1fbc */
	{ 0x1fbe, 0x1fbe }, /* 0x399 */
	{ 0x1fc3, 0x1fc3 }, /* 0x1fcc */
	{ 0x1fd0, 0x1fd1 }, /* 0x1fd8 */
	{ 0x1fe0, 0x1fe1 }, /* 0x1fe8 */
	{ 0x1fe5, 0x1fe5 }, /* 0x1fec */
	{ 0x1ff3, 0x1ff3 }, /* 0x1ffc */
	{ 0x214e, 0x214e }, /* 0x2132 */
	{ 0x2170, 0x217f }, /* 0x2160 */
	{ 0x2184, 0x2184 }, /* 0x2183 */
	{ 0x24d0, 0x24e9 }, /* 0x24b6 */
	{ 0x2c30, 0x2c5e }, /* 0x2c00 */
	{ 0x2c61, 0x2c61 }, /* 0x2c60 */
	{ 0x2c65, 0x2c65 }, /* 0x23a */
	{ 0x2c66, 0x2c66 }, /* 0x23e */
	{ 0x2c68, 0x2c68 }, /* 0x2c67 */
	{ 0x2c6a, 0x2c6a }, /* 0x2c69 */
	{ 0x2c6c, 0x2c6c }, /* 0x2c6b */
	{ 0x2c73, 0x2c73 }, /* 0x2c72 */
	{ 0x2c76, 0x2c76 }, /* 0x2c75 */
	{ 0x2c81, 0x2c81 }, /* 0x2c80 */
	{ 0x2c83, 0x2c83 }, /* 0x2c82 */
	{ 0x2c85, 0x2c85 }, /* 0x2c84 */
	{ 0x2c87, 0x2c87 }, /* 0x2c86 */
	{ 0x2c89, 0x2c89 }, /* 0x2c88 */
	{ 0x2c8b, 0x2c8b }, /* 0x2c8a */
	{ 0x2c8d, 0x2c8d }, /* 0x2c8c */
	{ 0x2c8f, 0x2c8f }, /* 0x2c8e */
	{ 0x2c91, 0x2c91 }, /* 0x2c90 */
	{ 0x2c93, 0x2c93 }, /* 0x2c92 */
	{ 0x2c95, 0x2c95 }, /* 0x2c94 */
	{ 0x2c97, 0x2c97 }, /* 0x2c96 */
	{ 0x2c99, 0x2c99 }, /* 0x2c98 */
	{ 0x2c9b, 0x2c9b }, /* 0x2c9a */
	{ 0x2c9d, 0x2c9d }, /* 0x2c9c */
	{ 0x2c9f, 0x2c9f }, /* 0x2c9e */
	{ 0x2ca1, 0x2ca1 }, /* 0x2ca0 */
	{ 0x2ca3, 0x2ca3 }, /* 0x2ca2 */
	{ 0x2ca5, 0x2ca5 }, /* 0x2ca4 */
	{ 0x2ca7, 0x2ca7 }, /* 0x2ca6 */
	{ 0x2ca9, 0x2ca9 }, /* 0x2ca8 */
	{ 0x2cab, 0x2cab }, /* 0x2caa */
	{ 0x2cad, 0x2cad }, /* 0x2cac */
	{ 0x2caf, 0x2caf }, /* 0x2cae */
	{ 0x2cb1, 0x2cb1 }, /* 0x2cb0 */
	{ 0x2cb3, 0x2cb3 }, /* 0x2cb2 */
	{ 0x2cb5, 0x2cb5 }, /* 0x2cb4 */
	{ 0x2cb7, 0x2cb7 }, /* 0x2cb6 */
	{ 0x2cb9, 0x2cb9 }, /* 0x2cb8 */
	{ 0x2cbb, 0x2cbb }, /* 0x2cba */
	{ 0x2cbd, 0x2cbd }, /* 0x2cbc */
	{ 0x2cbf, 0x2cbf }, /* 0x2cbe */
	{ 0x2cc1, 0x2cc1 }, /* 0x2cc0 */
	{ 0x2cc3, 0x2cc3 }, /* 0x2cc2 */
	{ 0x2cc5, 0x2cc5 }, /* 0x2cc4 */
	{ 0x2cc7, 0x2cc7 }, /* 0x2cc6 */
	{ 0x2cc9, 0x2cc9 }, /* 0x2cc8 */
	{ 0x2ccb, 0x2ccb }, /* 0x2cca */
	{ 0x2ccd, 0x2ccd }, /* 0x2ccc */
	{ 0x2ccf, 0x2ccf }, /* 0x2cce */
	{ 0x2cd1, 0x2cd1 }, /* 0x2cd0 */
	{ 0x2cd3, 0x2cd3 }, /* 0x2cd2 */
	{ 0x2cd5, 0x2cd5 }, /* 0x2cd4 */
	{ 0x2cd7, 0x2cd7 }, /* 0x2cd6 */
	{ 0x2cd9, 0x2cd9 }, /* 0x2cd8 */
	{ 0x2cdb, 0x2cdb }, /* 0x2cda */
	{ 0x2cdd, 0x2cdd }, /* 0x2cdc */
	{ 0x2cdf, 0x2cdf }, /* 0x2cde */
	{ 0x2ce1, 0x2ce1 }, /* 0x2ce0 */
	{ 0x2ce3, 0x2ce3 }, /* 0x2ce2 */
	{ 0x2cec, 0x2cec }, /* 0x2ceb */
	{ 0x2cee, 0x2cee }, /* 0x2ced */
	{ 0x2cf3, 0x2cf3 }, /* 0x2cf2 */
	{ 0x2d00, 0x2d25 }, /* 0x10a0 */
	{ 0x2d27, 0x2d27 }, /* 0x10c7 */
	{ 0x2d2d, 0x2d2d }, /* 0x10cd */
	{ 0xa641, 0xa641 }, /* 0xa640 */
	{ 0xa643, 0xa643 }, /* 0xa642 */
	{ 0xa645, 0xa645 }, /* 0xa644 */
	{ 0xa647, 0xa647 }, /* 0xa646 */
	{ 0xa649, 0xa649 }, /* 0xa648 */
	{ 0xa64b, 0xa64b }, /* 0xa64a */
	{ 0xa64d, 0xa64d }, /* 0xa64c */
	{ 0xa64f, 0xa64f }, /* 0xa64e */
	{ 0xa651, 0xa651 }, /* 0xa650 */
	{ 0xa653, 0xa653 }, /* 0xa652 */
	{ 0xa655, 0xa655 }, /* 0xa654 */
	{ 0xa657, 0xa657 }, /* 0xa656 */
	{ 0xa659, 0xa659 }, /* 0xa658 */
	{ 0xa65b, 0xa65b }, /* 0xa65a */
	{ 0xa65d, 0xa65d }, /* 0xa65c */
	{ 0xa65f, 0xa65f }, /* 0xa65e */
	{ 0xa661, 0xa661 }, /* 0xa660 */
	{ 0xa663, 0xa663 }, /* 0xa662 */
	{ 0xa665, 0xa665 }, /* 0xa664 */
	{ 0xa667, 0xa667 }, /* 0xa666 */
	{ 0xa669, 0xa669 }, /* 0xa668 */
	{ 0xa66b, 0xa66b }, /* 0xa66a */
	{ 0xa66d, 0xa66d }, /* 0xa66c */
	{ 0xa681, 0xa681 }, /* 0xa680 */
	{ 0xa683, 0xa683 }, /* 0xa682 */
	{ 0xa685, 0xa685 }, /* 0xa684 */
	{ 0xa687, 0xa687 }, /* 0xa686 */
	{ 0xa689, 0xa689 }, /* 0xa688 */
	{ 0xa68b, 0xa68b }, /* 0xa68a */
	{ 0xa68d, 0xa68d }, /* 0xa68c */
	{ 0xa68f, 0xa68f }, /* 0xa68e */
	{ 0xa691, 0xa691 }, /* 0xa690 */
	{ 0xa693, 0xa693 }, /* 0xa692 */
	{ 0xa695, 0xa695 }, /* 0xa694 */
	{ 0xa697, 0xa697 }, /* 0xa696 */
	{ 0xa699, 0xa699 }, /* 0xa698 */
	{ 0xa69b, 0xa69b }, /* 0xa69a */
	{ 0xa723, 0xa723 }, /* 0xa722 */
	{ 0xa725, 0xa725 }, /* 0xa724 */
	{ 0xa727, 0xa727 }, /* 0xa726 */
	{ 0xa729, 0xa729 }, /* 0xa728 */
	{ 0xa72b, 0xa72b }, /* 0xa72a */
	{ 0xa72d, 0xa72d }, /* 0xa72c */
	{ 0xa72f, 0xa72f }, /* 0xa72e */
	{ 0xa733, 0xa733 }, /* 0xa732 */
	{ 0xa735, 0xa735 }, /* 0xa734 */
	{ 0xa737, 0xa737 }, /* 0xa736 */
	{ 0xa739, 0xa739 }, /* 0xa738 */
	{ 0xa73b, 0xa73b }, /* 0xa73a */
	{ 0xa73d, 0xa73d }, /* 0xa73c */
	{ 0xa73f, 0xa73f }, /* 0xa73e */
	{ 0xa741, 0xa741 }, /* 0xa740 */
	{ 0xa743, 0xa743 }, /* 0xa742 */
	{ 0xa745, 0xa745 }, /* 0xa744 */
	{ 0xa747, 0xa747 }, /* 0xa746 */
	{ 0xa749, 0xa749 }, /* 0xa748 */
	{ 0xa74b, 0xa74b }, /* 0xa74a */
	{ 0xa74d, 0xa74d }, /* 0xa74c */
	{ 0xa74f, 0xa74f }, /* 0xa74e */
	{ 0xa751, 0xa751 }, /* 0xa750 */
	{ 0xa753, 0xa753 }, /* 0xa752 */
	{ 0xa755, 0xa755 }, /* 0xa754 */
	{ 0xa757, 0xa757 }, /* 0xa756 */
	{ 0xa759, 0xa759 }, /* 0xa758 */
	{ 0xa75b, 0xa75b }, /* 0xa75a */
	{ 0xa75d, 0xa75d }, /* 0xa75c */
	{ 0xa75f, 0xa75f }, /* 0xa75e */
	{ 0xa761, 0xa761 }, /* 0xa760 */
	{ 0xa763, 0xa763 }, /* 0xa762 */
	{ 0xa765, 0xa765 }, /* 0xa764 */
	{ 0xa767, 0xa767 }, /* 0xa766 */
	{ 0xa769, 0xa769 }, /* 0xa768 */
	{ 0xa76b, 0xa76b }, /* 0xa76a */
	{ 0xa76d, 0xa76d }, /* 0xa76c */
	{ 0xa76f, 0xa76f }, /* 0xa76e */
	{ 0xa77a, 0xa77a }, /* 0xa779 */
	{ 0xa77c, 0xa77c }, /* 0xa77b */
	{ 0xa77f, 0xa77f }, /* 0xa77e */
	{ 0xa781, 0xa781 }, /* 0xa780 */
	{ 0xa783, 0xa783 }, /* 0xa782 */
	{ 0xa785, 0xa785 }, /* 0xa784 */
	{ 0xa787, 0xa787 }, /* 0xa786 */
	{ 0xa78c, 0xa78c }, /* 0xa78b */
	{ 0xa791, 0xa791 }, /* 0xa790 */
	{ 0xa793, 0xa793 }, /* 0xa792 */
	{ 0xa797, 0xa797 }, /* 0xa796 */
	{ 0xa799, 0xa799 }, /* 0xa798 */
	{ 0xa79b, 0xa79b }, /* 0xa79a */
	{ 0xa79d, 0xa79d }, /* 0xa79c */
	{ 0xa79f, 0xa79f }, /* 0xa79e */
	{ 0xa7a1, 0xa7a1 }, /* 0xa7a0 */
	{ 0xa7a3, 0xa7a3 }, /* 0xa7a2 */
	{ 0xa7a5, 0xa7a5 }, /* 0xa7a4 */
	{ 0xa7a7, 0xa7a7 }, /* 0xa7a6 */
	{ 0xa7a9, 0xa7a9 }, /* 0xa7a8 */
	{ 0xa7b5, 0xa7b5 }, /* 0xa7b4 */
	{ 0xa7b7, 0xa7b7 }, /* 0xa7b6 */
	{ 0xab53, 0xab53 }, /* 0xa7b3 */
	{ 0xab70, 0xabbf }, /* 0x13a0 */
	{ 0xff41, 0xff5a }, /* 0xff21 */
	{ 0x10428, 0x1044f }, /* 0x10400 */
	{ 0x104d8, 0x104fb }, /* 0x104b0 */
	{ 0x10cc0, 0x10cf2 }, /* 0x10c80 */
	{ 0x118c0, 0x118df }, /* 0x118a0 */
	{ 0x1e922, 0x1e943 }, /* 0x1e900 */
	{ 0x0, 0x0 }
};
int totitle_cvt[] = {
	0x41, /* 0x61..0x7a */
	0x39c, /* 0xb5..0xb5 */
	0xc0, /* 0xe0..0xf6 */
	0xd8, /* 0xf8..0xfe */
	0x178, /* 0xff..0xff */
	0x100, /* 0x101..0x101 */
	0x102, /* 0x103..0x103 */
	0x104, /* 0x105..0x105 */
	0x106, /* 0x107..0x107 */
	0x108, /* 0x109..0x109 */
	0x10a, /* 0x10b..0x10b */
	0x10c, /* 0x10d..0x10d */
	0x10e, /* 0x10f..0x10f */
	0x110, /* 0x111..0x111 */
	0x112, /* 0x113..0x113 */
	0x114, /* 0x115..0x115 */
	0x116, /* 0x117..0x117 */
	0x118, /* 0x119..0x119 */
	0x11a, /* 0x11b..0x11b */
	0x11c, /* 0x11d..0x11d */
	0x11e, /* 0x11f..0x11f */
	0x120, /* 0x121..0x121 */
	0x122, /* 0x123..0x123 */
	0x124, /* 0x125..0x125 */
	0x126, /* 0x127..0x127 */
	0x128, /* 0x129..0x129 */
	0x12a, /* 0x12b..0x12b */
	0x12c, /* 0x12d..0x12d */
	0x12e, /* 0x12f..0x12f */
	0x49, /* 0x131..0x131 */
	0x132, /* 0x133..0x133 */
	0x134, /* 0x135..0x135 */
	0x136, /* 0x137..0x137 */
	0x139, /* 0x13a..0x13a */
	0x13b, /* 0x13c..0x13c */
	0x13d, /* 0x13e..0x13e */
	0x13f, /* 0x140..0x140 */
	0x141, /* 0x142..0x142 */
	0x143, /* 0x144..0x144 */
	0x145, /* 0x146..0x146 */
	0x147, /* 0x148..0x148 */
	0x14a, /* 0x14b..0x14b */
	0x14c, /* 0x14d..0x14d */
	0x14e, /* 0x14f..0x14f */
	0x150, /* 0x151..0x151 */
	0x152, /* 0x153..0x153 */
	0x154, /* 0x155..0x155 */
	0x156, /* 0x157..0x157 */
	0x158, /* 0x159..0x159 */
	0x15a, /* 0x15b..0x15b */
	0x15c, /* 0x15d..0x15d */
	0x15e, /* 0x15f..0x15f */
	0x160, /* 0x161..0x161 */
	0x162, /* 0x163..0x163 */
	0x164, /* 0x165..0x165 */
	0x166, /* 0x167..0x167 */
	0x168, /* 0x169..0x169 */
	0x16a, /* 0x16b..0x16b */
	0x16c, /* 0x16d..0x16d */
	0x16e, /* 0x16f..0x16f */
	0x170, /* 0x171..0x171 */
	0x172, /* 0x173..0x173 */
	0x174, /* 0x175..0x175 */
	0x176, /* 0x177..0x177 */
	0x179, /* 0x17a..0x17a */
	0x17b, /* 0x17c..0x17c */
	0x17d, /* 0x17e..0x17e */
	0x53, /* 0x17f..0x17f */
	0x243, /* 0x180..0x180 */
	0x182, /* 0x183..0x183 */
	0x184, /* 0x185..0x185 */
	0x187, /* 0x188..0x188 */
	0x18b, /* 0x18c..0x18c */
	0x191, /* 0x192..0x192 */
	0x1f6, /* 0x195..0x195 */
	0x198, /* 0x199..0x199 */
	0x23d, /* 0x19a..0x19a */
	0x220, /* 0x19e..0x19e */
	0x1a0, /* 0x1a1..0x1a1 */
	0x1a2, /* 0x1a3..0x1a3 */
	0x1a4, /* 0x1a5..0x1a5 */
	0x1a7, /* 0x1a8..0x1a8 */
	0x1ac, /* 0x1ad..0x1ad */
	0x1af, /* 0x1b0..0x1b0 */
	0x1b3, /* 0x1b4..0x1b4 */
	0x1b5, /* 0x1b6..0x1b6 */
	0x1b8, /* 0x1b9..0x1b9 */
	0x1bc, /* 0x1bd..0x1bd */
	0x1f7, /* 0x1bf..0x1bf */
	0x1c5, /* 0x1c4..0x1c4 */
	0x1c5, /* 0x1c6..0x1c6 */
	0x1c8, /* 0x1c7..0x1c7 */
	0x1c8, /* 0x1c9..0x1c9 */
	0x1cb, /* 0x1ca..0x1ca */
	0x1cb, /* 0x1cc..0x1cc */
	0x1cd, /* 0x1ce..0x1ce */
	0x1cf, /* 0x1d0..0x1d0 */
	0x1d1, /* 0x1d2..0x1d2 */
	0x1d3, /* 0x1d4..0x1d4 */
	0x1d5, /* 0x1d6..0x1d6 */
	0x1d7, /* 0x1d8..0x1d8 */
	0x1d9, /* 0x1da..0x1da */
	0x1db, /* 0x1dc..0x1dc */
	0x18e, /* 0x1dd..0x1dd */
	0x1de, /* 0x1df..0x1df */
	0x1e0, /* 0x1e1..0x1e1 */
	0x1e2, /* 0x1e3..0x1e3 */
	0x1e4, /* 0x1e5..0x1e5 */
	0x1e6, /* 0x1e7..0x1e7 */
	0x1e8, /* 0x1e9..0x1e9 */
	0x1ea, /* 0x1eb..0x1eb */
	0x1ec, /* 0x1ed..0x1ed */
	0x1ee, /* 0x1ef..0x1ef */
	0x1f2, /* 0x1f1..0x1f1 */
	0x1f2, /* 0x1f3..0x1f3 */
	0x1f4, /* 0x1f5..0x1f5 */
	0x1f8, /* 0x1f9..0x1f9 */
	0x1fa, /* 0x1fb..0x1fb */
	0x1fc, /* 0x1fd..0x1fd */
	0x1fe, /* 0x1ff..0x1ff */
	0x200, /* 0x201..0x201 */
	0x202, /* 0x203..0x203 */
	0x204, /* 0x205..0x205 */
	0x206, /* 0x207..0x207 */
	0x208, /* 0x209..0x209 */
	0x20a, /* 0x20b..0x20b */
	0x20c, /* 0x20d..0x20d */
	0x20e, /* 0x20f..0x20f */
	0x210, /* 0x211..0x211 */
	0x212, /* 0x213..0x213 */
	0x214, /* 0x215..0x215 */
	0x216, /* 0x217..0x217 */
	0x218, /* 0x219..0x219 */
	0x21a, /* 0x21b..0x21b */
	0x21c, /* 0x21d..0x21d */
	0x21e, /* 0x21f..0x21f */
	0x222, /* 0x223..0x223 */
	0x224, /* 0x225..0x225 */
	0x226, /* 0x227..0x227 */
	0x228, /* 0x229..0x229 */
	0x22a, /* 0x22b..0x22b */
	0x22c, /* 0x22d..0x22d */
	0x22e, /* 0x22f..0x22f */
	0x230, /* 0x231..0x231 */
	0x232, /* 0x233..0x233 */
	0x23b, /* 0x23c..0x23c */
	0x2c7e, /* 0x23f..0x240 */
	0x241, /* 0x242..0x242 */
	0x246, /* 0x247..0x247 */
	0x248, /* 0x249..0x249 */
	0x24a, /* 0x24b..0x24b */
	0x24c, /* 0x24d..0x24d */
	0x24e, /* 0x24f..0x24f */
	0x2c6f, /* 0x250..0x250 */
	0x2c6d, /* 0x251..0x251 */
	0x2c70, /* 0x252..0x252 */
	0x181, /* 0x253..0x253 */
	0x186, /* 0x254..0x254 */
	0x189, /* 0x256..0x257 */
	0x18f, /* 0x259..0x259 */
	0x190, /* 0x25b..0x25b */
	0xa7ab, /* 0x25c..0x25c */
	0x193, /* 0x260..0x260 */
	0xa7ac, /* 0x261..0x261 */
	0x194, /* 0x263..0x263 */
	0xa78d, /* 0x265..0x265 */
	0xa7aa, /* 0x266..0x266 */
	0x197, /* 0x268..0x268 */
	0x196, /* 0x269..0x269 */
	0xa7ae, /* 0x26a..0x26a */
	0x2c62, /* 0x26b..0x26b */
	0xa7ad, /* 0x26c..0x26c */
	0x19c, /* 0x26f..0x26f */
	0x2c6e, /* 0x271..0x271 */
	0x19d, /* 0x272..0x272 */
	0x19f, /* 0x275..0x275 */
	0x2c64, /* 0x27d..0x27d */
	0x1a6, /* 0x280..0x280 */
	0x1a9, /* 0x283..0x283 */
	0xa7b1, /* 0x287..0x287 */
	0x1ae, /* 0x288..0x288 */
	0x244, /* 0x289..0x289 */
	0x1b1, /* 0x28a..0x28b */
	0x245, /* 0x28c..0x28c */
	0x1b7, /* 0x292..0x292 */
	0xa7b2, /* 0x29d..0x29d */
	0xa7b0, /* 0x29e..0x29e */
	0x399, /* 0x345..0x345 */
	0x370, /* 0x371..0x371 */
	0x372, /* 0x373..0x373 */
	0x376, /* 0x377..0x377 */
	0x3fd, /* 0x37b..0x37d */
	0x386, /* 0x3ac..0x3ac */
	0x388, /* 0x3ad..0x3af */
	0x391, /* 0x3b1..0x3c1 */
	0x3a3, /* 0x3c2..0x3c2 */
	0x3a3, /* 0x3c3..0x3cb */
	0x38c, /* 0x3cc..0x3cc */
	0x38e, /* 0x3cd..0x3ce */
	0x392, /* 0x3d0..0x3d0 */
	0x398, /* 0x3d1..0x3d1 */
	0x3a6, /* 0x3d5..0x3d5 */
	0x3a0, /* 0x3d6..0x3d6 */
	0x3cf, /* 0x3d7..0x3d7 */
	0x3d8, /* 0x3d9..0x3d9 */
	0x3da, /* 0x3db..0x3db */
	0x3dc, /* 0x3dd..0x3dd */
	0x3de, /* 0x3df..0x3df */
	0x3e0, /* 0x3e1..0x3e1 */
	0x3e2, /* 0x3e3..0x3e3 */
	0x3e4, /* 0x3e5..0x3e5 */
	0x3e6, /* 0x3e7..0x3e7 */
	0x3e8, /* 0x3e9..0x3e9 */
	0x3ea, /* 0x3eb..0x3eb */
	0x3ec, /* 0x3ed..0x3ed */
	0x3ee, /* 0x3ef..0x3ef */
	0x39a, /* 0x3f0..0x3f0 */
	0x3a1, /* 0x3f1..0x3f1 */
	0x3f9, /* 0x3f2..0x3f2 */
	0x37f, /* 0x3f3..0x3f3 */
	0x395, /* 0x3f5..0x3f5 */
	0x3f7, /* 0x3f8..0x3f8 */
	0x3fa, /* 0x3fb..0x3fb */
	0x410, /* 0x430..0x44f */
	0x400, /* 0x450..0x45f */
	0x460, /* 0x461..0x461 */
	0x462, /* 0x463..0x463 */
	0x464, /* 0x465..0x465 */
	0x466, /* 0x467..0x467 */
	0x468, /* 0x469..0x469 */
	0x46a, /* 0x46b..0x46b */
	0x46c, /* 0x46d..0x46d */
	0x46e, /* 0x46f..0x46f */
	0x470, /* 0x471..0x471 */
	0x472, /* 0x473..0x473 */
	0x474, /* 0x475..0x475 */
	0x476, /* 0x477..0x477 */
	0x478, /* 0x479..0x479 */
	0x47a, /* 0x47b..0x47b */
	0x47c, /* 0x47d..0x47d */
	0x47e, /* 0x47f..0x47f */
	0x480, /* 0x481..0x481 */
	0x48a, /* 0x48b..0x48b */
	0x48c, /* 0x48d..0x48d */
	0x48e, /* 0x48f..0x48f */
	0x490, /* 0x491..0x491 */
	0x492, /* 0x493..0x493 */
	0x494, /* 0x495..0x495 */
	0x496, /* 0x497..0x497 */
	0x498, /* 0x499..0x499 */
	0x49a, /* 0x49b..0x49b */
	0x49c, /* 0x49d..0x49d */
	0x49e, /* 0x49f..0x49f */
	0x4a0, /* 0x4a1..0x4a1 */
	0x4a2, /* 0x4a3..0x4a3 */
	0x4a4, /* 0x4a5..0x4a5 */
	0x4a6, /* 0x4a7..0x4a7 */
	0x4a8, /* 0x4a9..0x4a9 */
	0x4aa, /* 0x4ab..0x4ab */
	0x4ac, /* 0x4ad..0x4ad */
	0x4ae, /* 0x4af..0x4af */
	0x4b0, /* 0x4b1..0x4b1 */
	0x4b2, /* 0x4b3..0x4b3 */
	0x4b4, /* 0x4b5..0x4b5 */
	0x4b6, /* 0x4b7..0x4b7 */
	0x4b8, /* 0x4b9..0x4b9 */
	0x4ba, /* 0x4bb..0x4bb */
	0x4bc, /* 0x4bd..0x4bd */
	0x4be, /* 0x4bf..0x4bf */
	0x4c1, /* 0x4c2..0x4c2 */
	0x4c3, /* 0x4c4..0x4c4 */
	0x4c5, /* 0x4c6..0x4c6 */
	0x4c7, /* 0x4c8..0x4c8 */
	0x4c9, /* 0x4ca..0x4ca */
	0x4cb, /* 0x4cc..0x4cc */
	0x4cd, /* 0x4ce..0x4ce */
	0x4c0, /* 0x4cf..0x4cf */
	0x4d0, /* 0x4d1..0x4d1 */
	0x4d2, /* 0x4d3..0x4d3 */
	0x4d4, /* 0x4d5..0x4d5 */
	0x4d6, /* 0x4d7..0x4d7 */
	0x4d8, /* 0x4d9..0x4d9 */
	0x4da, /* 0x4db..0x4db */
	0x4dc, /* 0x4dd..0x4dd */
	0x4de, /* 0x4df..0x4df */
	0x4e0, /* 0x4e1..0x4e1 */
	0x4e2, /* 0x4e3..0x4e3 */
	0x4e4, /* 0x4e5..0x4e5 */
	0x4e6, /* 0x4e7..0x4e7 */
	0x4e8, /* 0x4e9..0x4e9 */
	0x4ea, /* 0x4eb..0x4eb */
	0x4ec, /* 0x4ed..0x4ed */
	0x4ee, /* 0x4ef..0x4ef */
	0x4f0, /* 0x4f1..0x4f1 */
	0x4f2, /* 0x4f3..0x4f3 */
	0x4f4, /* 0x4f5..0x4f5 */
	0x4f6, /* 0x4f7..0x4f7 */
	0x4f8, /* 0x4f9..0x4f9 */
	0x4fa, /* 0x4fb..0x4fb */
	0x4fc, /* 0x4fd..0x4fd */
	0x4fe, /* 0x4ff..0x4ff */
	0x500, /* 0x501..0x501 */
	0x502, /* 0x503..0x503 */
	0x504, /* 0x505..0x505 */
	0x506, /* 0x507..0x507 */
	0x508, /* 0x509..0x509 */
	0x50a, /* 0x50b..0x50b */
	0x50c, /* 0x50d..0x50d */
	0x50e, /* 0x50f..0x50f */
	0x510, /* 0x511..0x511 */
	0x512, /* 0x513..0x513 */
	0x514, /* 0x515..0x515 */
	0x516, /* 0x517..0x517 */
	0x518, /* 0x519..0x519 */
	0x51a, /* 0x51b..0x51b */
	0x51c, /* 0x51d..0x51d */
	0x51e, /* 0x51f..0x51f */
	0x520, /* 0x521..0x521 */
	0x522, /* 0x523..0x523 */
	0x524, /* 0x525..0x525 */
	0x526, /* 0x527..0x527 */
	0x528, /* 0x529..0x529 */
	0x52a, /* 0x52b..0x52b */
	0x52c, /* 0x52d..0x52d */
	0x52e, /* 0x52f..0x52f */
	0x531, /* 0x561..0x586 */
	0x13f0, /* 0x13f8..0x13fd */
	0x412, /* 0x1c80..0x1c80 */
	0x414, /* 0x1c81..0x1c81 */
	0x41e, /* 0x1c82..0x1c82 */
	0x421, /* 0x1c83..0x1c84 */
	0x422, /* 0x1c85..0x1c85 */
	0x42a, /* 0x1c86..0x1c86 */
	0x462, /* 0x1c87..0x1c87 */
	0xa64a, /* 0x1c88..0x1c88 */
	0xa77d, /* 0x1d79..0x1d79 */
	0x2c63, /* 0x1d7d..0x1d7d */
	0x1e00, /* 0x1e01..0x1e01 */
	0x1e02, /* 0x1e03..0x1e03 */
	0x1e04, /* 0x1e05..0x1e05 */
	0x1e06, /* 0x1e07..0x1e07 */
	0x1e08, /* 0x1e09..0x1e09 */
	0x1e0a, /* 0x1e0b..0x1e0b */
	0x1e0c, /* 0x1e0d..0x1e0d */
	0x1e0e, /* 0x1e0f..0x1e0f */
	0x1e10, /* 0x1e11..0x1e11 */
	0x1e12, /* 0x1e13..0x1e13 */
	0x1e14, /* 0x1e15..0x1e15 */
	0x1e16, /* 0x1e17..0x1e17 */
	0x1e18, /* 0x1e19..0x1e19 */
	0x1e1a, /* 0x1e1b..0x1e1b */
	0x1e1c, /* 0x1e1d..0x1e1d */
	0x1e1e, /* 0x1e1f..0x1e1f */
	0x1e20, /* 0x1e21..0x1e21 */
	0x1e22, /* 0x1e23..0x1e23 */
	0x1e24, /* 0x1e25..0x1e25 */
	0x1e26, /* 0x1e27..0x1e27 */
	0x1e28, /* 0x1e29..0x1e29 */
	0x1e2a, /* 0x1e2b..0x1e2b */
	0x1e2c, /* 0x1e2d..0x1e2d */
	0x1e2e, /* 0x1e2f..0x1e2f */
	0x1e30, /* 0x1e31..0x1e31 */
	0x1e32, /* 0x1e33..0x1e33 */
	0x1e34, /* 0x1e35..0x1e35 */
	0x1e36, /* 0x1e37..0x1e37 */
	0x1e38, /* 0x1e39..0x1e39 */
	0x1e3a, /* 0x1e3b..0x1e3b */
	0x1e3c, /* 0x1e3d..0x1e3d */
	0x1e3e, /* 0x1e3f..0x1e3f */
	0x1e40, /* 0x1e41..0x1e41 */
	0x1e42, /* 0x1e43..0x1e43 */
	0x1e44, /* 0x1e45..0x1e45 */
	0x1e46, /* 0x1e47..0x1e47 */
	0x1e48, /* 0x1e49..0x1e49 */
	0x1e4a, /* 0x1e4b..0x1e4b */
	0x1e4c, /* 0x1e4d..0x1e4d */
	0x1e4e, /* 0x1e4f..0x1e4f */
	0x1e50, /* 0x1e51..0x1e51 */
	0x1e52, /* 0x1e53..0x1e53 */
	0x1e54, /* 0x1e55..0x1e55 */
	0x1e56, /* 0x1e57..0x1e57 */
	0x1e58, /* 0x1e59..0x1e59 */
	0x1e5a, /* 0x1e5b..0x1e5b */
	0x1e5c, /* 0x1e5d..0x1e5d */
	0x1e5e, /* 0x1e5f..0x1e5f */
	0x1e60, /* 0x1e61..0x1e61 */
	0x1e62, /* 0x1e63..0x1e63 */
	0x1e64, /* 0x1e65..0x1e65 */
	0x1e66, /* 0x1e67..0x1e67 */
	0x1e68, /* 0x1e69..0x1e69 */
	0x1e6a, /* 0x1e6b..0x1e6b */
	0x1e6c, /* 0x1e6d..0x1e6d */
	0x1e6e, /* 0x1e6f..0x1e6f */
	0x1e70, /* 0x1e71..0x1e71 */
	0x1e72, /* 0x1e73..0x1e73 */
	0x1e74, /* 0x1e75..0x1e75 */
	0x1e76, /* 0x1e77..0x1e77 */
	0x1e78, /* 0x1e79..0x1e79 */
	0x1e7a, /* 0x1e7b..0x1e7b */
	0x1e7c, /* 0x1e7d..0x1e7d */
	0x1e7e, /* 0x1e7f..0x1e7f */
	0x1e80, /* 0x1e81..0x1e81 */
	0x1e82, /* 0x1e83..0x1e83 */
	0x1e84, /* 0x1e85..0x1e85 */
	0x1e86, /* 0x1e87..0x1e87 */
	0x1e88, /* 0x1e89..0x1e89 */
	0x1e8a, /* 0x1e8b..0x1e8b */
	0x1e8c, /* 0x1e8d..0x1e8d */
	0x1e8e, /* 0x1e8f..0x1e8f */
	0x1e90, /* 0x1e91..0x1e91 */
	0x1e92, /* 0x1e93..0x1e93 */
	0x1e94, /* 0x1e95..0x1e95 */
	0x1e60, /* 0x1e9b..0x1e9b */
	0x1ea0, /* 0x1ea1..0x1ea1 */
	0x1ea2, /* 0x1ea3..0x1ea3 */
	0x1ea4, /* 0x1ea5..0x1ea5 */
	0x1ea6, /* 0x1ea7..0x1ea7 */
	0x1ea8, /* 0x1ea9..0x1ea9 */
	0x1eaa, /* 0x1eab..0x1eab */
	0x1eac, /* 0x1ead..0x1ead */
	0x1eae, /* 0x1eaf..0x1eaf */
	0x1eb0, /* 0x1eb1..0x1eb1 */
	0x1eb2, /* 0x1eb3..0x1eb3 */
	0x1eb4, /* 0x1eb5..0x1eb5 */
	0x1eb6, /* 0x1eb7..0x1eb7 */
	0x1eb8, /* 0x1eb9..0x1eb9 */
	0x1eba, /* 0x1ebb..0x1ebb */
	0x1ebc, /* 0x1ebd..0x1ebd */
	0x1ebe, /* 0x1ebf..0x1ebf */
	0x1ec0, /* 0x1ec1..0x1ec1 */
	0x1ec2, /* 0x1ec3..0x1ec3 */
	0x1ec4, /* 0x1ec5..0x1ec5 */
	0x1ec6, /* 0x1ec7..0x1ec7 */
	0x1ec8, /* 0x1ec9..0x1ec9 */
	0x1eca, /* 0x1ecb..0x1ecb */
	0x1ecc, /* 0x1ecd..0x1ecd */
	0x1ece, /* 0x1ecf..0x1ecf */
	0x1ed0, /* 0x1ed1..0x1ed1 */
	0x1ed2, /* 0x1ed3..0x1ed3 */
	0x1ed4, /* 0x1ed5..0x1ed5 */
	0x1ed6, /* 0x1ed7..0x1ed7 */
	0x1ed8, /* 0x1ed9..0x1ed9 */
	0x1eda, /* 0x1edb..0x1edb */
	0x1edc, /* 0x1edd..0x1edd */
	0x1ede, /* 0x1edf..0x1edf */
	0x1ee0, /* 0x1ee1..0x1ee1 */
	0x1ee2, /* 0x1ee3..0x1ee3 */
	0x1ee4, /* 0x1ee5..0x1ee5 */
	0x1ee6, /* 0x1ee7..0x1ee7 */
	0x1ee8, /* 0x1ee9..0x1ee9 */
	0x1eea, /* 0x1eeb..0x1eeb */
	0x1eec, /* 0x1eed..0x1eed */
	0x1eee, /* 0x1eef..0x1eef */
	0x1ef0, /* 0x1ef1..0x1ef1 */
	0x1ef2, /* 0x1ef3..0x1ef3 */
	0x1ef4, /* 0x1ef5..0x1ef5 */
	0x1ef6, /* 0x1ef7..0x1ef7 */
	0x1ef8, /* 0x1ef9..0x1ef9 */
	0x1efa, /* 0x1efb..0x1efb */
	0x1efc, /* 0x1efd..0x1efd */
	0x1efe, /* 0x1eff..0x1eff */
	0x1f08, /* 0x1f00..0x1f07 */
	0x1f18, /* 0x1f10..0x1f15 */
	0x1f28, /* 0x1f20..0x1f27 */
	0x1f38, /* 0x1f30..0x1f37 */
	0x1f48, /* 0x1f40..0x1f45 */
	0x1f59, /* 0x1f51..0x1f51 */
	0x1f5b, /* 0x1f53..0x1f53 */
	0x1f5d, /* 0x1f55..0x1f55 */
	0x1f5f, /* 0x1f57..0x1f57 */
	0x1f68, /* 0x1f60..0x1f67 */
	0x1fba, /* 0x1f70..0x1f71 */
	0x1fc8, /* 0x1f72..0x1f75 */
	0x1fda, /* 0x1f76..0x1f77 */
	0x1ff8, /* 0x1f78..0x1f79 */
	0x1fea, /* 0x1f7a..0x1f7b */
	0x1ffa, /* 0x1f7c..0x1f7d */
	0x1f88, /* 0x1f80..0x1f87 */
	0x1f98, /* 0x1f90..0x1f97 */
	0x1fa8, /* 0x1fa0..0x1fa7 */
	0x1fb8, /* 0x1fb0..0x1fb1 */
	0x1fbc, /* 0x1fb3..0x1fb3 */
	0x399, /* 0x1fbe..0x1fbe */
	0x1fcc, /* 0x1fc3..0x1fc3 */
	0x1fd8, /* 0x1fd0..0x1fd1 */
	0x1fe8, /* 0x1fe0..0x1fe1 */
	0x1fec, /* 0x1fe5..0x1fe5 */
	0x1ffc, /* 0x1ff3..0x1ff3 */
	0x2132, /* 0x214e..0x214e */
	0x2160, /* 0x2170..0x217f */
	0x2183, /* 0x2184..0x2184 */
	0x24b6, /* 0x24d0..0x24e9 */
	0x2c00, /* 0x2c30..0x2c5e */
	0x2c60, /* 0x2c61..0x2c61 */
	0x23a, /* 0x2c65..0x2c65 */
	0x23e, /* 0x2c66..0x2c66 */
	0x2c67, /* 0x2c68..0x2c68 */
	0x2c69, /* 0x2c6a..0x2c6a */
	0x2c6b, /* 0x2c6c..0x2c6c */
	0x2c72, /* 0x2c73..0x2c73 */
	0x2c75, /* 0x2c76..0x2c76 */
	0x2c80, /* 0x2c81..0x2c81 */
	0x2c82, /* 0x2c83..0x2c83 */
	0x2c84, /* 0x2c85..0x2c85 */
	0x2c86, /* 0x2c87..0x2c87 */
	0x2c88, /* 0x2c89..0x2c89 */
	0x2c8a, /* 0x2c8b..0x2c8b */
	0x2c8c, /* 0x2c8d..0x2c8d */
	0x2c8e, /* 0x2c8f..0x2c8f */
	0x2c90, /* 0x2c91..0x2c91 */
	0x2c92, /* 0x2c93..0x2c93 */
	0x2c94, /* 0x2c95..0x2c95 */
	0x2c96, /* 0x2c97..0x2c97 */
	0x2c98, /* 0x2c99..0x2c99 */
	0x2c9a, /* 0x2c9b..0x2c9b */
	0x2c9c, /* 0x2c9d..0x2c9d */
	0x2c9e, /* 0x2c9f..0x2c9f */
	0x2ca0, /* 0x2ca1..0x2ca1 */
	0x2ca2, /* 0x2ca3..0x2ca3 */
	0x2ca4, /* 0x2ca5..0x2ca5 */
	0x2ca6, /* 0x2ca7..0x2ca7 */
	0x2ca8, /* 0x2ca9..0x2ca9 */
	0x2caa, /* 0x2cab..0x2cab */
	0x2cac, /* 0x2cad..0x2cad */
	0x2cae, /* 0x2caf..0x2caf */
	0x2cb0, /* 0x2cb1..0x2cb1 */
	0x2cb2, /* 0x2cb3..0x2cb3 */
	0x2cb4, /* 0x2cb5..0x2cb5 */
	0x2cb6, /* 0x2cb7..0x2cb7 */
	0x2cb8, /* 0x2cb9..0x2cb9 */
	0x2cba, /* 0x2cbb..0x2cbb */
	0x2cbc, /* 0x2cbd..0x2cbd */
	0x2cbe, /* 0x2cbf..0x2cbf */
	0x2cc0, /* 0x2cc1..0x2cc1 */
	0x2cc2, /* 0x2cc3..0x2cc3 */
	0x2cc4, /* 0x2cc5..0x2cc5 */
	0x2cc6, /* 0x2cc7..0x2cc7 */
	0x2cc8, /* 0x2cc9..0x2cc9 */
	0x2cca, /* 0x2ccb..0x2ccb */
	0x2ccc, /* 0x2ccd..0x2ccd */
	0x2cce, /* 0x2ccf..0x2ccf */
	0x2cd0, /* 0x2cd1..0x2cd1 */
	0x2cd2, /* 0x2cd3..0x2cd3 */
	0x2cd4, /* 0x2cd5..0x2cd5 */
	0x2cd6, /* 0x2cd7..0x2cd7 */
	0x2cd8, /* 0x2cd9..0x2cd9 */
	0x2cda, /* 0x2cdb..0x2cdb */
	0x2cdc, /* 0x2cdd..0x2cdd */
	0x2cde, /* 0x2cdf..0x2cdf */
	0x2ce0, /* 0x2ce1..0x2ce1 */
	0x2ce2, /* 0x2ce3..0x2ce3 */
	0x2ceb, /* 0x2cec..0x2cec */
	0x2ced, /* 0x2cee..0x2cee */
	0x2cf2, /* 0x2cf3..0x2cf3 */
	0x10a0, /* 0x2d00..0x2d25 */
	0x10c7, /* 0x2d27..0x2d27 */
	0x10cd, /* 0x2d2d..0x2d2d */
	0xa640, /* 0xa641..0xa641 */
	0xa642, /* 0xa643..0xa643 */
	0xa644, /* 0xa645..0xa645 */
	0xa646, /* 0xa647..0xa647 */
	0xa648, /* 0xa649..0xa649 */
	0xa64a, /* 0xa64b..0xa64b */
	0xa64c, /* 0xa64d..0xa64d */
	0xa64e, /* 0xa64f..0xa64f */
	0xa650, /* 0xa651..0xa651 */
	0xa652, /* 0xa653..0xa653 */
	0xa654, /* 0xa655..0xa655 */
	0xa656, /* 0xa657..0xa657 */
	0xa658, /* 0xa659..0xa659 */
	0xa65a, /* 0xa65b..0xa65b */
	0xa65c, /* 0xa65d..0xa65d */
	0xa65e, /* 0xa65f..0xa65f */
	0xa660, /* 0xa661..0xa661 */
	0xa662, /* 0xa663..0xa663 */
	0xa664, /* 0xa665..0xa665 */
	0xa666, /* 0xa667..0xa667 */
	0xa668, /* 0xa669..0xa669 */
	0xa66a, /* 0xa66b..0xa66b */
	0xa66c, /* 0xa66d..0xa66d */
	0xa680, /* 0xa681..0xa681 */
	0xa682, /* 0xa683..0xa683 */
	0xa684, /* 0xa685..0xa685 */
	0xa686, /* 0xa687..0xa687 */
	0xa688, /* 0xa689..0xa689 */
	0xa68a, /* 0xa68b..0xa68b */
	0xa68c, /* 0xa68d..0xa68d */
	0xa68e, /* 0xa68f..0xa68f */
	0xa690, /* 0xa691..0xa691 */
	0xa692, /* 0xa693..0xa693 */
	0xa694, /* 0xa695..0xa695 */
	0xa696, /* 0xa697..0xa697 */
	0xa698, /* 0xa699..0xa699 */
	0xa69a, /* 0xa69b..0xa69b */
	0xa722, /* 0xa723..0xa723 */
	0xa724, /* 0xa725..0xa725 */
	0xa726, /* 0xa727..0xa727 */
	0xa728, /* 0xa729..0xa729 */
	0xa72a, /* 0xa72b..0xa72b */
	0xa72c, /* 0xa72d..0xa72d */
	0xa72e, /* 0xa72f..0xa72f */
	0xa732, /* 0xa733..0xa733 */
	0xa734, /* 0xa735..0xa735 */
	0xa736, /* 0xa737..0xa737 */
	0xa738, /* 0xa739..0xa739 */
	0xa73a, /* 0xa73b..0xa73b */
	0xa73c, /* 0xa73d..0xa73d */
	0xa73e, /* 0xa73f..0xa73f */
	0xa740, /* 0xa741..0xa741 */
	0xa742, /* 0xa743..0xa743 */
	0xa744, /* 0xa745..0xa745 */
	0xa746, /* 0xa747..0xa747 */
	0xa748, /* 0xa749..0xa749 */
	0xa74a, /* 0xa74b..0xa74b */
	0xa74c, /* 0xa74d..0xa74d */
	0xa74e, /* 0xa74f..0xa74f */
	0xa750, /* 0xa751..0xa751 */
	0xa752, /* 0xa753..0xa753 */
	0xa754, /* 0xa755..0xa755 */
	0xa756, /* 0xa757..0xa757 */
	0xa758, /* 0xa759..0xa759 */
	0xa75a, /* 0xa75b..0xa75b */
	0xa75c, /* 0xa75d..0xa75d */
	0xa75e, /* 0xa75f..0xa75f */
	0xa760, /* 0xa761..0xa761 */
	0xa762, /* 0xa763..0xa763 */
	0xa764, /* 0xa765..0xa765 */
	0xa766, /* 0xa767..0xa767 */
	0xa768, /* 0xa769..0xa769 */
	0xa76a, /* 0xa76b..0xa76b */
	0xa76c, /* 0xa76d..0xa76d */
	0xa76e, /* 0xa76f..0xa76f */
	0xa779, /* 0xa77a..0xa77a */
	0xa77b, /* 0xa77c..0xa77c */
	0xa77e, /* 0xa77f..0xa77f */
	0xa780, /* 0xa781..0xa781 */
	0xa782, /* 0xa783..0xa783 */
	0xa784, /* 0xa785..0xa785 */
	0xa786, /* 0xa787..0xa787 */
	0xa78b, /* 0xa78c..0xa78c */
	0xa790, /* 0xa791..0xa791 */
	0xa792, /* 0xa793..0xa793 */
	0xa796, /* 0xa797..0xa797 */
	0xa798, /* 0xa799..0xa799 */
	0xa79a, /* 0xa79b..0xa79b */
	0xa79c, /* 0xa79d..0xa79d */
	0xa79e, /* 0xa79f..0xa79f */
	0xa7a0, /* 0xa7a1..0xa7a1 */
	0xa7a2, /* 0xa7a3..0xa7a3 */
	0xa7a4, /* 0xa7a5..0xa7a5 */
	0xa7a6, /* 0xa7a7..0xa7a7 */
	0xa7a8, /* 0xa7a9..0xa7a9 */
	0xa7b4, /* 0xa7b5..0xa7b5 */
	0xa7b6, /* 0xa7b7..0xa7b7 */
	0xa7b3, /* 0xab53..0xab53 */
	0x13a0, /* 0xab70..0xabbf */
	0xff21, /* 0xff41..0xff5a */
	0x10400, /* 0x10428..0x1044f */
	0x104b0, /* 0x104d8..0x104fb */
	0x10c80, /* 0x10cc0..0x10cf2 */
	0x118a0, /* 0x118c0..0x118df */
	0x1e900, /* 0x1e922..0x1e943 */
	0x0
};

struct unicat unicat[] = {
	{ "Co", 3, Co_table, 0 },
	{ "Cs", 1, Cs_table, 0 },
	{ "Zp", 1, Zp_table, 0 },
	{ "Zl", 1, Zl_table, 0 },
	{ "Nl", 12, Nl_table, 0 },
	{ "Mc", 155, Mc_table, 0 },
	{ "Me", 5, Me_table, 0 },
	{ "Mn", 285, Mn_table, 0 },
	{ "Lm", 57, Lm_table, 0 },
	{ "Lt", 10, Lt_table, 0 },
	{ "Pf", 10, Pf_table, 0 },
	{ "No", 60, No_table, 0 },
	{ "Cf", 18, Cf_table, 0 },
	{ "Pi", 11, Pi_table, 0 },
	{ "Lo", 445, Lo_table, 0 },
	{ "So", 174, So_table, 0 },
	{ "Ll", 633, Ll_table, 0 },
	{ "Pc", 6, Pc_table, 0 },
	{ "Sk", 29, Sk_table, 0 },
	{ "Lu", 627, Lu_table, 0 },
	{ "Nd", 58, Nd_table, 0 },
	{ "Pd", 17, Pd_table, 0 },
	{ "Sm", 64, Sm_table, 0 },
	{ "Pe", 72, Pe_table, 0 },
	{ "Ps", 75, Ps_table, 0 },
	{ "Sc", 17, Sc_table, 0 },
	{ "Po", 165, Po_table, 0 },
	{ "Zs", 7, Zs_table, 0 },
	{ "Cc", 2, Cc_table, 0 },
	{ "Supplementary Private Use Area-B", 1, uniblocks + 272, 0 },
	{ "Supplementary Private Use Area-A", 1, uniblocks + 271, 0 },
	{ "Variation Selectors Supplement", 1, uniblocks + 270, 0 },
	{ "Tags", 1, uniblocks + 269, 0 },
	{ "CJK Compatibility Ideographs Supplement", 1, uniblocks + 268, 0 },
	{ "CJK Unified Ideographs Extension E", 1, uniblocks + 267, 0 },
	{ "CJK Unified Ideographs Extension D", 1, uniblocks + 266, 0 },
	{ "CJK Unified Ideographs Extension C", 1, uniblocks + 265, 0 },
	{ "CJK Unified Ideographs Extension B", 1, uniblocks + 264, 0 },
	{ "Supplemental Symbols and Pictographs", 1, uniblocks + 263, 0 },
	{ "Supplemental Arrows-C", 1, uniblocks + 262, 0 },
	{ "Geometric Shapes Extended", 1, uniblocks + 261, 0 },
	{ "Alchemical Symbols", 1, uniblocks + 260, 0 },
	{ "Transport and Map Symbols", 1, uniblocks + 259, 0 },
	{ "Ornamental Dingbats", 1, uniblocks + 258, 0 },
	{ "Emoticons", 1, uniblocks + 257, 0 },
	{ "Miscellaneous Symbols and Pictographs", 1, uniblocks + 256, 0 },
	{ "Enclosed Ideographic Supplement", 1, uniblocks + 255, 0 },
	{ "Enclosed Alphanumeric Supplement", 1, uniblocks + 254, 0 },
	{ "Playing Cards", 1, uniblocks + 253, 0 },
	{ "Domino Tiles", 1, uniblocks + 252, 0 },
	{ "Mahjong Tiles", 1, uniblocks + 251, 0 },
	{ "Arabic Mathematical Alphabetic Symbols", 1, uniblocks + 250, 0 },
	{ "Adlam", 1, uniblocks + 249, 0 },
	{ "Mende Kikakui", 1, uniblocks + 248, 0 },
	{ "Glagolitic Supplement", 1, uniblocks + 247, 0 },
	{ "Sutton SignWriting", 1, uniblocks + 246, 0 },
	{ "Mathematical Alphanumeric Symbols", 1, uniblocks + 245, 0 },
	{ "Counting Rod Numerals", 1, uniblocks + 244, 0 },
	{ "Tai Xuan Jing Symbols", 1, uniblocks + 243, 0 },
	{ "Ancient Greek Musical Notation", 1, uniblocks + 242, 0 },
	{ "Musical Symbols", 1, uniblocks + 241, 0 },
	{ "Byzantine Musical Symbols", 1, uniblocks + 240, 0 },
	{ "Shorthand Format Controls", 1, uniblocks + 239, 0 },
	{ "Duployan", 1, uniblocks + 238, 0 },
	{ "Kana Supplement", 1, uniblocks + 237, 0 },
	{ "Tangut Components", 1, uniblocks + 236, 0 },
	{ "Tangut", 1, uniblocks + 235, 0 },
	{ "Ideographic Symbols and Punctuation", 1, uniblocks + 234, 0 },
	{ "Miao", 1, uniblocks + 233, 0 },
	{ "Pahawh Hmong", 1, uniblocks + 232, 0 },
	{ "Bassa Vah", 1, uniblocks + 231, 0 },
	{ "Mro", 1, uniblocks + 230, 0 },
	{ "Bamum Supplement", 1, uniblocks + 229, 0 },
	{ "Anatolian Hieroglyphs", 1, uniblocks + 228, 0 },
	{ "Egyptian Hieroglyphs", 1, uniblocks + 227, 0 },
	{ "Early Dynastic Cuneiform", 1, uniblocks + 226, 0 },
	{ "Cuneiform Numbers and Punctuation", 1, uniblocks + 225, 0 },
	{ "Cuneiform", 1, uniblocks + 224, 0 },
	{ "Marchen", 1, uniblocks + 223, 0 },
	{ "Bhaiksuki", 1, uniblocks + 222, 0 },
	{ "Pau Cin Hau", 1, uniblocks + 221, 0 },
	{ "Warang Citi", 1, uniblocks + 220, 0 },
	{ "Ahom", 1, uniblocks + 219, 0 },
	{ "Takri", 1, uniblocks + 218, 0 },
	{ "Mongolian Supplement", 1, uniblocks + 217, 0 },
	{ "Modi", 1, uniblocks + 216, 0 },
	{ "Siddham", 1, uniblocks + 215, 0 },
	{ "Tirhuta", 1, uniblocks + 214, 0 },
	{ "Newa", 1, uniblocks + 213, 0 },
	{ "Grantha", 1, uniblocks + 212, 0 },
	{ "Khudawadi", 1, uniblocks + 211, 0 },
	{ "Multani", 1, uniblocks + 210, 0 },
	{ "Khojki", 1, uniblocks + 209, 0 },
	{ "Sinhala Archaic Numbers", 1, uniblocks + 208, 0 },
	{ "Sharada", 1, uniblocks + 207, 0 },
	{ "Mahajani", 1, uniblocks + 206, 0 },
	{ "Chakma", 1, uniblocks + 205, 0 },
	{ "Sora Sompeng", 1, uniblocks + 204, 0 },
	{ "Kaithi", 1, uniblocks + 203, 0 },
	{ "Brahmi", 1, uniblocks + 202, 0 },
	{ "Rumi Numeral Symbols", 1, uniblocks + 201, 0 },
	{ "Old Hungarian", 1, uniblocks + 200, 0 },
	{ "Old Turkic", 1, uniblocks + 199, 0 },
	{ "Psalter Pahlavi", 1, uniblocks + 198, 0 },
	{ "Inscriptional Pahlavi", 1, uniblocks + 197, 0 },
	{ "Inscriptional Parthian", 1, uniblocks + 196, 0 },
	{ "Avestan", 1, uniblocks + 195, 0 },
	{ "Manichaean", 1, uniblocks + 194, 0 },
	{ "Old North Arabian", 1, uniblocks + 193, 0 },
	{ "Old South Arabian", 1, uniblocks + 192, 0 },
	{ "Kharoshthi", 1, uniblocks + 191, 0 },
	{ "Meroitic Cursive", 1, uniblocks + 190, 0 },
	{ "Meroitic Hieroglyphs", 1, uniblocks + 189, 0 },
	{ "Lydian", 1, uniblocks + 188, 0 },
	{ "Phoenician", 1, uniblocks + 187, 0 },
	{ "Hatran", 1, uniblocks + 186, 0 },
	{ "Nabataean", 1, uniblocks + 185, 0 },
	{ "Palmyrene", 1, uniblocks + 184, 0 },
	{ "Imperial Aramaic", 1, uniblocks + 183, 0 },
	{ "Cypriot Syllabary", 1, uniblocks + 182, 0 },
	{ "Linear A", 1, uniblocks + 181, 0 },
	{ "Caucasian Albanian", 1, uniblocks + 180, 0 },
	{ "Elbasan", 1, uniblocks + 179, 0 },
	{ "Osage", 1, uniblocks + 178, 0 },
	{ "Osmanya", 1, uniblocks + 177, 0 },
	{ "Shavian", 1, uniblocks + 176, 0 },
	{ "Deseret", 1, uniblocks + 175, 0 },
	{ "Old Persian", 1, uniblocks + 174, 0 },
	{ "Ugaritic", 1, uniblocks + 173, 0 },
	{ "Old Permic", 1, uniblocks + 172, 0 },
	{ "Gothic", 1, uniblocks + 171, 0 },
	{ "Old Italic", 1, uniblocks + 170, 0 },
	{ "Coptic Epact Numbers", 1, uniblocks + 169, 0 },
	{ "Carian", 1, uniblocks + 168, 0 },
	{ "Lycian", 1, uniblocks + 167, 0 },
	{ "Phaistos Disc", 1, uniblocks + 166, 0 },
	{ "Ancient Symbols", 1, uniblocks + 165, 0 },
	{ "Ancient Greek Numbers", 1, uniblocks + 164, 0 },
	{ "Aegean Numbers", 1, uniblocks + 163, 0 },
	{ "Linear B Ideograms", 1, uniblocks + 162, 0 },
	{ "Linear B Syllabary", 1, uniblocks + 161, 0 },
	{ "Specials", 1, uniblocks + 160, 0 },
	{ "Halfwidth and Fullwidth Forms", 1, uniblocks + 159, 0 },
	{ "Arabic Presentation Forms-B", 1, uniblocks + 158, 0 },
	{ "Small Form Variants", 1, uniblocks + 157, 0 },
	{ "CJK Compatibility Forms", 1, uniblocks + 156, 0 },
	{ "Combining Half Marks", 1, uniblocks + 155, 0 },
	{ "Vertical Forms", 1, uniblocks + 154, 0 },
	{ "Variation Selectors", 1, uniblocks + 153, 0 },
	{ "Arabic Presentation Forms-A", 1, uniblocks + 152, 0 },
	{ "Alphabetic Presentation Forms", 1, uniblocks + 151, 0 },
	{ "CJK Compatibility Ideographs", 1, uniblocks + 150, 0 },
	{ "Private Use Area", 1, uniblocks + 149, 0 },
	{ "Low Surrogates", 1, uniblocks + 148, 0 },
	{ "High Private Use Surrogates", 1, uniblocks + 147, 0 },
	{ "High Surrogates", 1, uniblocks + 146, 0 },
	{ "Hangul Jamo Extended-B", 1, uniblocks + 145, 0 },
	{ "Hangul Syllables", 1, uniblocks + 144, 0 },
	{ "Meetei Mayek", 1, uniblocks + 143, 0 },
	{ "Cherokee Supplement", 1, uniblocks + 142, 0 },
	{ "Latin Extended-E", 1, uniblocks + 141, 0 },
	{ "Ethiopic Extended-A", 1, uniblocks + 140, 0 },
	{ "Meetei Mayek Extensions", 1, uniblocks + 139, 0 },
	{ "Tai Viet", 1, uniblocks + 138, 0 },
	{ "Myanmar Extended-A", 1, uniblocks + 137, 0 },
	{ "Cham", 1, uniblocks + 136, 0 },
	{ "Myanmar Extended-B", 1, uniblocks + 135, 0 },
	{ "Javanese", 1, uniblocks + 134, 0 },
	{ "Hangul Jamo Extended-A", 1, uniblocks + 133, 0 },
	{ "Rejang", 1, uniblocks + 132, 0 },
	{ "Kayah Li", 1, uniblocks + 131, 0 },
	{ "Devanagari Extended", 1, uniblocks + 130, 0 },
	{ "Saurashtra", 1, uniblocks + 129, 0 },
	{ "Phags-pa", 1, uniblocks + 128, 0 },
	{ "Common Indic Number Forms", 1, uniblocks + 127, 0 },
	{ "Syloti Nagri", 1, uniblocks + 126, 0 },
	{ "Latin Extended-D", 1, uniblocks + 125, 0 },
	{ "Modifier Tone Letters", 1, uniblocks + 124, 0 },
	{ "Bamum", 1, uniblocks + 123, 0 },
	{ "Cyrillic Extended-B", 1, uniblocks + 122, 0 },
	{ "Vai", 1, uniblocks + 121, 0 },
	{ "Lisu", 1, uniblocks + 120, 0 },
	{ "Yi Radicals", 1, uniblocks + 119, 0 },
	{ "Yi Syllables", 1, uniblocks + 118, 0 },
	{ "CJK Unified Ideographs", 1, uniblocks + 117, 0 },
	{ "Yijing Hexagram Symbols", 1, uniblocks + 116, 0 },
	{ "CJK Unified Ideographs Extension A", 1, uniblocks + 115, 0 },
	{ "CJK Compatibility", 1, uniblocks + 114, 0 },
	{ "Enclosed CJK Letters and Months", 1, uniblocks + 113, 0 },
	{ "Katakana Phonetic Extensions", 1, uniblocks + 112, 0 },
	{ "CJK Strokes", 1, uniblocks + 111, 0 },
	{ "Bopomofo Extended", 1, uniblocks + 110, 0 },
	{ "Kanbun", 1, uniblocks + 109, 0 },
	{ "Hangul Compatibility Jamo", 1, uniblocks + 108, 0 },
	{ "Bopomofo", 1, uniblocks + 107, 0 },
	{ "Katakana", 1, uniblocks + 106, 0 },
	{ "Hiragana", 1, uniblocks + 105, 0 },
	{ "CJK Symbols and Punctuation", 1, uniblocks + 104, 0 },
	{ "Ideographic Description Characters", 1, uniblocks + 103, 0 },
	{ "Kangxi Radicals", 1, uniblocks + 102, 0 },
	{ "CJK Radicals Supplement", 1, uniblocks + 101, 0 },
	{ "Supplemental Punctuation", 1, uniblocks + 100, 0 },
	{ "Cyrillic Extended-A", 1, uniblocks + 99, 0 },
	{ "Ethiopic Extended", 1, uniblocks + 98, 0 },
	{ "Tifinagh", 1, uniblocks + 97, 0 },
	{ "Georgian Supplement", 1, uniblocks + 96, 0 },
	{ "Coptic", 1, uniblocks + 95, 0 },
	{ "Latin Extended-C", 1, uniblocks + 94, 0 },
	{ "Glagolitic", 1, uniblocks + 93, 0 },
	{ "Miscellaneous Symbols and Arrows", 1, uniblocks + 92, 0 },
	{ "Supplemental Mathematical Operators", 1, uniblocks + 91, 0 },
	{ "Miscellaneous Mathematical Symbols-B", 1, uniblocks + 90, 0 },
	{ "Supplemental Arrows-B", 1, uniblocks + 89, 0 },
	{ "Braille Patterns", 1, uniblocks + 88, 0 },
	{ "Supplemental Arrows-A", 1, uniblocks + 87, 0 },
	{ "Miscellaneous Mathematical Symbols-A", 1, uniblocks + 86, 0 },
	{ "Dingbats", 1, uniblocks + 85, 0 },
	{ "Miscellaneous Symbols", 1, uniblocks + 84, 0 },
	{ "Geometric Shapes", 1, uniblocks + 83, 0 },
	{ "Block Elements", 1, uniblocks + 82, 0 },
	{ "Box Drawing", 1, uniblocks + 81, 0 },
	{ "Enclosed Alphanumerics", 1, uniblocks + 80, 0 },
	{ "Optical Character Recognition", 1, uniblocks + 79, 0 },
	{ "Control Pictures", 1, uniblocks + 78, 0 },
	{ "Miscellaneous Technical", 1, uniblocks + 77, 0 },
	{ "Mathematical Operators", 1, uniblocks + 76, 0 },
	{ "Arrows", 1, uniblocks + 75, 0 },
	{ "Number Forms", 1, uniblocks + 74, 0 },
	{ "Letterlike Symbols", 1, uniblocks + 73, 0 },
	{ "Combining Diacritical Marks for Symbols", 1, uniblocks + 72, 0 },
	{ "Currency Symbols", 1, uniblocks + 71, 0 },
	{ "Superscripts and Subscripts", 1, uniblocks + 70, 0 },
	{ "General Punctuation", 1, uniblocks + 69, 0 },
	{ "Greek Extended", 1, uniblocks + 68, 0 },
	{ "Latin Extended Additional", 1, uniblocks + 67, 0 },
	{ "Combining Diacritical Marks Supplement", 1, uniblocks + 66, 0 },
	{ "Phonetic Extensions Supplement", 1, uniblocks + 65, 0 },
	{ "Phonetic Extensions", 1, uniblocks + 64, 0 },
	{ "Vedic Extensions", 1, uniblocks + 63, 0 },
	{ "Sundanese Supplement", 1, uniblocks + 62, 0 },
	{ "Cyrillic Extended-C", 1, uniblocks + 61, 0 },
	{ "Ol Chiki", 1, uniblocks + 60, 0 },
	{ "Lepcha", 1, uniblocks + 59, 0 },
	{ "Batak", 1, uniblocks + 58, 0 },
	{ "Sundanese", 1, uniblocks + 57, 0 },
	{ "Balinese", 1, uniblocks + 56, 0 },
	{ "Combining Diacritical Marks Extended", 1, uniblocks + 55, 0 },
	{ "Tai Tham", 1, uniblocks + 54, 0 },
	{ "Buginese", 1, uniblocks + 53, 0 },
	{ "Khmer Symbols", 1, uniblocks + 52, 0 },
	{ "New Tai Lue", 1, uniblocks + 51, 0 },
	{ "Tai Le", 1, uniblocks + 50, 0 },
	{ "Limbu", 1, uniblocks + 49, 0 },
	{ "Unified Canadian Aboriginal Syllabics Extended", 1, uniblocks + 48, 0 },
	{ "Mongolian", 1, uniblocks + 47, 0 },
	{ "Khmer", 1, uniblocks + 46, 0 },
	{ "Tagbanwa", 1, uniblocks + 45, 0 },
	{ "Buhid", 1, uniblocks + 44, 0 },
	{ "Hanunoo", 1, uniblocks + 43, 0 },
	{ "Tagalog", 1, uniblocks + 42, 0 },
	{ "Runic", 1, uniblocks + 41, 0 },
	{ "Ogham", 1, uniblocks + 40, 0 },
	{ "Unified Canadian Aboriginal Syllabics", 1, uniblocks + 39, 0 },
	{ "Cherokee", 1, uniblocks + 38, 0 },
	{ "Ethiopic Supplement", 1, uniblocks + 37, 0 },
	{ "Ethiopic", 1, uniblocks + 36, 0 },
	{ "Hangul Jamo", 1, uniblocks + 35, 0 },
	{ "Georgian", 1, uniblocks + 34, 0 },
	{ "Myanmar", 1, uniblocks + 33, 0 },
	{ "Tibetan", 1, uniblocks + 32, 0 },
	{ "Lao", 1, uniblocks + 31, 0 },
	{ "Thai", 1, uniblocks + 30, 0 },
	{ "Sinhala", 1, uniblocks + 29, 0 },
	{ "Malayalam", 1, uniblocks + 28, 0 },
	{ "Kannada", 1, uniblocks + 27, 0 },
	{ "Telugu", 1, uniblocks + 26, 0 },
	{ "Tamil", 1, uniblocks + 25, 0 },
	{ "Oriya", 1, uniblocks + 24, 0 },
	{ "Gujarati", 1, uniblocks + 23, 0 },
	{ "Gurmukhi", 1, uniblocks + 22, 0 },
	{ "Bengali", 1, uniblocks + 21, 0 },
	{ "Devanagari", 1, uniblocks + 20, 0 },
	{ "Arabic Extended-A", 1, uniblocks + 19, 0 },
	{ "Mandaic", 1, uniblocks + 18, 0 },
	{ "Samaritan", 1, uniblocks + 17, 0 },
	{ "NKo", 1, uniblocks + 16, 0 },
	{ "Thaana", 1, uniblocks + 15, 0 },
	{ "Arabic Supplement", 1, uniblocks + 14, 0 },
	{ "Syriac", 1, uniblocks + 13, 0 },
	{ "Arabic", 1, uniblocks + 12, 0 },
	{ "Hebrew", 1, uniblocks + 11, 0 },
	{ "Armenian", 1, uniblocks + 10, 0 },
	{ "Cyrillic Supplement", 1, uniblocks + 9, 0 },
	{ "Cyrillic", 1, uniblocks + 8, 0 },
	{ "Greek and Coptic", 1, uniblocks + 7, 0 },
	{ "Combining Diacritical Marks", 1, uniblocks + 6, 0 },
	{ "Spacing Modifier Letters", 1, uniblocks + 5, 0 },
	{ "IPA Extensions", 1, uniblocks + 4, 0 },
	{ "Latin Extended-B", 1, uniblocks + 3, 0 },
	{ "Latin Extended-A", 1, uniblocks + 2, 0 },
	{ "Latin-1 Supplement", 1, uniblocks + 1, 0 },
	{ "Basic Latin", 1, uniblocks + 0, 0 },
	{ 0, 0, 0, 0 }
};

struct interval fold_table[] = {
	{ 0x41, 0x5a },
	{ 0xb5, 0xb5 },
	{ 0xc0, 0xd6 },
	{ 0xd8, 0xde },
	{ 0xdf, 0xdf },
	{ 0x100, 0x100 },
	{ 0x102, 0x102 },
	{ 0x104, 0x104 },
	{ 0x106, 0x106 },
	{ 0x108, 0x108 },
	{ 0x10a, 0x10a },
	{ 0x10c, 0x10c },
	{ 0x10e, 0x10e },
	{ 0x110, 0x110 },
	{ 0x112, 0x112 },
	{ 0x114, 0x114 },
	{ 0x116, 0x116 },
	{ 0x118, 0x118 },
	{ 0x11a, 0x11a },
	{ 0x11c, 0x11c },
	{ 0x11e, 0x11e },
	{ 0x120, 0x120 },
	{ 0x122, 0x122 },
	{ 0x124, 0x124 },
	{ 0x126, 0x126 },
	{ 0x128, 0x128 },
	{ 0x12a, 0x12a },
	{ 0x12c, 0x12c },
	{ 0x12e, 0x12e },
	{ 0x130, 0x130 },
	{ 0x132, 0x132 },
	{ 0x134, 0x134 },
	{ 0x136, 0x136 },
	{ 0x139, 0x139 },
	{ 0x13b, 0x13b },
	{ 0x13d, 0x13d },
	{ 0x13f, 0x13f },
	{ 0x141, 0x141 },
	{ 0x143, 0x143 },
	{ 0x145, 0x145 },
	{ 0x147, 0x147 },
	{ 0x149, 0x149 },
	{ 0x14a, 0x14a },
	{ 0x14c, 0x14c },
	{ 0x14e, 0x14e },
	{ 0x150, 0x150 },
	{ 0x152, 0x152 },
	{ 0x154, 0x154 },
	{ 0x156, 0x156 },
	{ 0x158, 0x158 },
	{ 0x15a, 0x15a },
	{ 0x15c, 0x15c },
	{ 0x15e, 0x15e },
	{ 0x160, 0x160 },
	{ 0x162, 0x162 },
	{ 0x164, 0x164 },
	{ 0x166, 0x166 },
	{ 0x168, 0x168 },
	{ 0x16a, 0x16a },
	{ 0x16c, 0x16c },
	{ 0x16e, 0x16e },
	{ 0x170, 0x170 },
	{ 0x172, 0x172 },
	{ 0x174, 0x174 },
	{ 0x176, 0x176 },
	{ 0x178, 0x178 },
	{ 0x179, 0x179 },
	{ 0x17b, 0x17b },
	{ 0x17d, 0x17d },
	{ 0x17f, 0x17f },
	{ 0x181, 0x181 },
	{ 0x182, 0x182 },
	{ 0x184, 0x184 },
	{ 0x186, 0x186 },
	{ 0x187, 0x187 },
	{ 0x189, 0x18a },
	{ 0x18b, 0x18b },
	{ 0x18e, 0x18e },
	{ 0x18f, 0x18f },
	{ 0x190, 0x190 },
	{ 0x191, 0x191 },
	{ 0x193, 0x193 },
	{ 0x194, 0x194 },
	{ 0x196, 0x196 },
	{ 0x197, 0x197 },
	{ 0x198, 0x198 },
	{ 0x19c, 0x19c },
	{ 0x19d, 0x19d },
	{ 0x19f, 0x19f },
	{ 0x1a0, 0x1a0 },
	{ 0x1a2, 0x1a2 },
	{ 0x1a4, 0x1a4 },
	{ 0x1a6, 0x1a6 },
	{ 0x1a7, 0x1a7 },
	{ 0x1a9, 0x1a9 },
	{ 0x1ac, 0x1ac },
	{ 0x1ae, 0x1ae },
	{ 0x1af, 0x1af },
	{ 0x1b1, 0x1b2 },
	{ 0x1b3, 0x1b3 },
	{ 0x1b5, 0x1b5 },
	{ 0x1b7, 0x1b7 },
	{ 0x1b8, 0x1b8 },
	{ 0x1bc, 0x1bc },
	{ 0x1c4, 0x1c4 },
	{ 0x1c5, 0x1c5 },
	{ 0x1c7, 0x1c7 },
	{ 0x1c8, 0x1c8 },
	{ 0x1ca, 0x1ca },
	{ 0x1cb, 0x1cb },
	{ 0x1cd, 0x1cd },
	{ 0x1cf, 0x1cf },
	{ 0x1d1, 0x1d1 },
	{ 0x1d3, 0x1d3 },
	{ 0x1d5, 0x1d5 },
	{ 0x1d7, 0x1d7 },
	{ 0x1d9, 0x1d9 },
	{ 0x1db, 0x1db },
	{ 0x1de, 0x1de },
	{ 0x1e0, 0x1e0 },
	{ 0x1e2, 0x1e2 },
	{ 0x1e4, 0x1e4 },
	{ 0x1e6, 0x1e6 },
	{ 0x1e8, 0x1e8 },
	{ 0x1ea, 0x1ea },
	{ 0x1ec, 0x1ec },
	{ 0x1ee, 0x1ee },
	{ 0x1f0, 0x1f0 },
	{ 0x1f1, 0x1f1 },
	{ 0x1f2, 0x1f2 },
	{ 0x1f4, 0x1f4 },
	{ 0x1f6, 0x1f6 },
	{ 0x1f7, 0x1f7 },
	{ 0x1f8, 0x1f8 },
	{ 0x1fa, 0x1fa },
	{ 0x1fc, 0x1fc },
	{ 0x1fe, 0x1fe },
	{ 0x200, 0x200 },
	{ 0x202, 0x202 },
	{ 0x204, 0x204 },
	{ 0x206, 0x206 },
	{ 0x208, 0x208 },
	{ 0x20a, 0x20a },
	{ 0x20c, 0x20c },
	{ 0x20e, 0x20e },
	{ 0x210, 0x210 },
	{ 0x212, 0x212 },
	{ 0x214, 0x214 },
	{ 0x216, 0x216 },
	{ 0x218, 0x218 },
	{ 0x21a, 0x21a },
	{ 0x21c, 0x21c },
	{ 0x21e, 0x21e },
	{ 0x220, 0x220 },
	{ 0x222, 0x222 },
	{ 0x224, 0x224 },
	{ 0x226, 0x226 },
	{ 0x228, 0x228 },
	{ 0x22a, 0x22a },
	{ 0x22c, 0x22c },
	{ 0x22e, 0x22e },
	{ 0x230, 0x230 },
	{ 0x232, 0x232 },
	{ 0x23a, 0x23a },
	{ 0x23b, 0x23b },
	{ 0x23d, 0x23d },
	{ 0x23e, 0x23e },
	{ 0x241, 0x241 },
	{ 0x243, 0x243 },
	{ 0x244, 0x244 },
	{ 0x245, 0x245 },
	{ 0x246, 0x246 },
	{ 0x248, 0x248 },
	{ 0x24a, 0x24a },
	{ 0x24c, 0x24c },
	{ 0x24e, 0x24e },
	{ 0x345, 0x345 },
	{ 0x370, 0x370 },
	{ 0x372, 0x372 },
	{ 0x376, 0x376 },
	{ 0x37f, 0x37f },
	{ 0x386, 0x386 },
	{ 0x388, 0x38a },
	{ 0x38c, 0x38c },
	{ 0x38e, 0x38f },
	{ 0x390, 0x390 },
	{ 0x391, 0x3a1 },
	{ 0x3a3, 0x3ab },
	{ 0x3b0, 0x3b0 },
	{ 0x3c2, 0x3c2 },
	{ 0x3cf, 0x3cf },
	{ 0x3d0, 0x3d0 },
	{ 0x3d1, 0x3d1 },
	{ 0x3d5, 0x3d5 },
	{ 0x3d6, 0x3d6 },
	{ 0x3d8, 0x3d8 },
	{ 0x3da, 0x3da },
	{ 0x3dc, 0x3dc },
	{ 0x3de, 0x3de },
	{ 0x3e0, 0x3e0 },
	{ 0x3e2, 0x3e2 },
	{ 0x3e4, 0x3e4 },
	{ 0x3e6, 0x3e6 },
	{ 0x3e8, 0x3e8 },
	{ 0x3ea, 0x3ea },
	{ 0x3ec, 0x3ec },
	{ 0x3ee, 0x3ee },
	{ 0x3f0, 0x3f0 },
	{ 0x3f1, 0x3f1 },
	{ 0x3f4, 0x3f4 },
	{ 0x3f5, 0x3f5 },
	{ 0x3f7, 0x3f7 },
	{ 0x3f9, 0x3f9 },
	{ 0x3fa, 0x3fa },
	{ 0x3fd, 0x3ff },
	{ 0x400, 0x40f },
	{ 0x410, 0x42f },
	{ 0x460, 0x460 },
	{ 0x462, 0x462 },
	{ 0x464, 0x464 },
	{ 0x466, 0x466 },
	{ 0x468, 0x468 },
	{ 0x46a, 0x46a },
	{ 0x46c, 0x46c },
	{ 0x46e, 0x46e },
	{ 0x470, 0x470 },
	{ 0x472, 0x472 },
	{ 0x474, 0x474 },
	{ 0x476, 0x476 },
	{ 0x478, 0x478 },
	{ 0x47a, 0x47a },
	{ 0x47c, 0x47c },
	{ 0x47e, 0x47e },
	{ 0x480, 0x480 },
	{ 0x48a, 0x48a },
	{ 0x48c, 0x48c },
	{ 0x48e, 0x48e },
	{ 0x490, 0x490 },
	{ 0x492, 0x492 },
	{ 0x494, 0x494 },
	{ 0x496, 0x496 },
	{ 0x498, 0x498 },
	{ 0x49a, 0x49a },
	{ 0x49c, 0x49c },
	{ 0x49e, 0x49e },
	{ 0x4a0, 0x4a0 },
	{ 0x4a2, 0x4a2 },
	{ 0x4a4, 0x4a4 },
	{ 0x4a6, 0x4a6 },
	{ 0x4a8, 0x4a8 },
	{ 0x4aa, 0x4aa },
	{ 0x4ac, 0x4ac },
	{ 0x4ae, 0x4ae },
	{ 0x4b0, 0x4b0 },
	{ 0x4b2, 0x4b2 },
	{ 0x4b4, 0x4b4 },
	{ 0x4b6, 0x4b6 },
	{ 0x4b8, 0x4b8 },
	{ 0x4ba, 0x4ba },
	{ 0x4bc, 0x4bc },
	{ 0x4be, 0x4be },
	{ 0x4c0, 0x4c0 },
	{ 0x4c1, 0x4c1 },
	{ 0x4c3, 0x4c3 },
	{ 0x4c5, 0x4c5 },
	{ 0x4c7, 0x4c7 },
	{ 0x4c9, 0x4c9 },
	{ 0x4cb, 0x4cb },
	{ 0x4cd, 0x4cd },
	{ 0x4d0, 0x4d0 },
	{ 0x4d2, 0x4d2 },
	{ 0x4d4, 0x4d4 },
	{ 0x4d6, 0x4d6 },
	{ 0x4d8, 0x4d8 },
	{ 0x4da, 0x4da },
	{ 0x4dc, 0x4dc },
	{ 0x4de, 0x4de },
	{ 0x4e0, 0x4e0 },
	{ 0x4e2, 0x4e2 },
	{ 0x4e4, 0x4e4 },
	{ 0x4e6, 0x4e6 },
	{ 0x4e8, 0x4e8 },
	{ 0x4ea, 0x4ea },
	{ 0x4ec, 0x4ec },
	{ 0x4ee, 0x4ee },
	{ 0x4f0, 0x4f0 },
	{ 0x4f2, 0x4f2 },
	{ 0x4f4, 0x4f4 },
	{ 0x4f6, 0x4f6 },
	{ 0x4f8, 0x4f8 },
	{ 0x4fa, 0x4fa },
	{ 0x4fc, 0x4fc },
	{ 0x4fe, 0x4fe },
	{ 0x500, 0x500 },
	{ 0x502, 0x502 },
	{ 0x504, 0x504 },
	{ 0x506, 0x506 },
	{ 0x508, 0x508 },
	{ 0x50a, 0x50a },
	{ 0x50c, 0x50c },
	{ 0x50e, 0x50e },
	{ 0x510, 0x510 },
	{ 0x512, 0x512 },
	{ 0x514, 0x514 },
	{ 0x516, 0x516 },
	{ 0x518, 0x518 },
	{ 0x51a, 0x51a },
	{ 0x51c, 0x51c },
	{ 0x51e, 0x51e },
	{ 0x520, 0x520 },
	{ 0x522, 0x522 },
	{ 0x524, 0x524 },
	{ 0x526, 0x526 },
	{ 0x528, 0x528 },
	{ 0x52a, 0x52a },
	{ 0x52c, 0x52c },
	{ 0x52e, 0x52e },
	{ 0x531, 0x556 },
	{ 0x587, 0x587 },
	{ 0x10a0, 0x10c5 },
	{ 0x10c7, 0x10c7 },
	{ 0x10cd, 0x10cd },
	{ 0x13f8, 0x13fd },
	{ 0x1c80, 0x1c80 },
	{ 0x1c81, 0x1c81 },
	{ 0x1c82, 0x1c82 },
	{ 0x1c83, 0x1c84 },
	{ 0x1c85, 0x1c85 },
	{ 0x1c86, 0x1c86 },
	{ 0x1c87, 0x1c87 },
	{ 0x1c88, 0x1c88 },
	{ 0x1e00, 0x1e00 },
	{ 0x1e02, 0x1e02 },
	{ 0x1e04, 0x1e04 },
	{ 0x1e06, 0x1e06 },
	{ 0x1e08, 0x1e08 },
	{ 0x1e0a, 0x1e0a },
	{ 0x1e0c, 0x1e0c },
	{ 0x1e0e, 0x1e0e },
	{ 0x1e10, 0x1e10 },
	{ 0x1e12, 0x1e12 },
	{ 0x1e14, 0x1e14 },
	{ 0x1e16, 0x1e16 },
	{ 0x1e18, 0x1e18 },
	{ 0x1e1a, 0x1e1a },
	{ 0x1e1c, 0x1e1c },
	{ 0x1e1e, 0x1e1e },
	{ 0x1e20, 0x1e20 },
	{ 0x1e22, 0x1e22 },
	{ 0x1e24, 0x1e24 },
	{ 0x1e26, 0x1e26 },
	{ 0x1e28, 0x1e28 },
	{ 0x1e2a, 0x1e2a },
	{ 0x1e2c, 0x1e2c },
	{ 0x1e2e, 0x1e2e },
	{ 0x1e30, 0x1e30 },
	{ 0x1e32, 0x1e32 },
	{ 0x1e34, 0x1e34 },
	{ 0x1e36, 0x1e36 },
	{ 0x1e38, 0x1e38 },
	{ 0x1e3a, 0x1e3a },
	{ 0x1e3c, 0x1e3c },
	{ 0x1e3e, 0x1e3e },
	{ 0x1e40, 0x1e40 },
	{ 0x1e42, 0x1e42 },
	{ 0x1e44, 0x1e44 },
	{ 0x1e46, 0x1e46 },
	{ 0x1e48, 0x1e48 },
	{ 0x1e4a, 0x1e4a },
	{ 0x1e4c, 0x1e4c },
	{ 0x1e4e, 0x1e4e },
	{ 0x1e50, 0x1e50 },
	{ 0x1e52, 0x1e52 },
	{ 0x1e54, 0x1e54 },
	{ 0x1e56, 0x1e56 },
	{ 0x1e58, 0x1e58 },
	{ 0x1e5a, 0x1e5a },
	{ 0x1e5c, 0x1e5c },
	{ 0x1e5e, 0x1e5e },
	{ 0x1e60, 0x1e60 },
	{ 0x1e62, 0x1e62 },
	{ 0x1e64, 0x1e64 },
	{ 0x1e66, 0x1e66 },
	{ 0x1e68, 0x1e68 },
	{ 0x1e6a, 0x1e6a },
	{ 0x1e6c, 0x1e6c },
	{ 0x1e6e, 0x1e6e },
	{ 0x1e70, 0x1e70 },
	{ 0x1e72, 0x1e72 },
	{ 0x1e74, 0x1e74 },
	{ 0x1e76, 0x1e76 },
	{ 0x1e78, 0x1e78 },
	{ 0x1e7a, 0x1e7a },
	{ 0x1e7c, 0x1e7c },
	{ 0x1e7e, 0x1e7e },
	{ 0x1e80, 0x1e80 },
	{ 0x1e82, 0x1e82 },
	{ 0x1e84, 0x1e84 },
	{ 0x1e86, 0x1e86 },
	{ 0x1e88, 0x1e88 },
	{ 0x1e8a, 0x1e8a },
	{ 0x1e8c, 0x1e8c },
	{ 0x1e8e, 0x1e8e },
	{ 0x1e90, 0x1e90 },
	{ 0x1e92, 0x1e92 },
	{ 0x1e94, 0x1e94 },
	{ 0x1e96, 0x1e96 },
	{ 0x1e97, 0x1e97 },
	{ 0x1e98, 0x1e98 },
	{ 0x1e99, 0x1e99 },
	{ 0x1e9a, 0x1e9a },
	{ 0x1e9b, 0x1e9b },
	{ 0x1e9e, 0x1e9e },
	{ 0x1ea0, 0x1ea0 },
	{ 0x1ea2, 0x1ea2 },
	{ 0x1ea4, 0x1ea4 },
	{ 0x1ea6, 0x1ea6 },
	{ 0x1ea8, 0x1ea8 },
	{ 0x1eaa, 0x1eaa },
	{ 0x1eac, 0x1eac },
	{ 0x1eae, 0x1eae },
	{ 0x1eb0, 0x1eb0 },
	{ 0x1eb2, 0x1eb2 },
	{ 0x1eb4, 0x1eb4 },
	{ 0x1eb6, 0x1eb6 },
	{ 0x1eb8, 0x1eb8 },
	{ 0x1eba, 0x1eba },
	{ 0x1ebc, 0x1ebc },
	{ 0x1ebe, 0x1ebe },
	{ 0x1ec0, 0x1ec0 },
	{ 0x1ec2, 0x1ec2 },
	{ 0x1ec4, 0x1ec4 },
	{ 0x1ec6, 0x1ec6 },
	{ 0x1ec8, 0x1ec8 },
	{ 0x1eca, 0x1eca },
	{ 0x1ecc, 0x1ecc },
	{ 0x1ece, 0x1ece },
	{ 0x1ed0, 0x1ed0 },
	{ 0x1ed2, 0x1ed2 },
	{ 0x1ed4, 0x1ed4 },
	{ 0x1ed6, 0x1ed6 },
	{ 0x1ed8, 0x1ed8 },
	{ 0x1eda, 0x1eda },
	{ 0x1edc, 0x1edc },
	{ 0x1ede, 0x1ede },
	{ 0x1ee0, 0x1ee0 },
	{ 0x1ee2, 0x1ee2 },
	{ 0x1ee4, 0x1ee4 },
	{ 0x1ee6, 0x1ee6 },
	{ 0x1ee8, 0x1ee8 },
	{ 0x1eea, 0x1eea },
	{ 0x1eec, 0x1eec },
	{ 0x1eee, 0x1eee },
	{ 0x1ef0, 0x1ef0 },
	{ 0x1ef2, 0x1ef2 },
	{ 0x1ef4, 0x1ef4 },
	{ 0x1ef6, 0x1ef6 },
	{ 0x1ef8, 0x1ef8 },
	{ 0x1efa, 0x1efa },
	{ 0x1efc, 0x1efc },
	{ 0x1efe, 0x1efe },
	{ 0x1f08, 0x1f0f },
	{ 0x1f18, 0x1f1d },
	{ 0x1f28, 0x1f2f },
	{ 0x1f38, 0x1f3f },
	{ 0x1f48, 0x1f4d },
	{ 0x1f50, 0x1f50 },
	{ 0x1f52, 0x1f52 },
	{ 0x1f54, 0x1f54 },
	{ 0x1f56, 0x1f56 },
	{ 0x1f59, 0x1f59 },
	{ 0x1f5b, 0x1f5b },
	{ 0x1f5d, 0x1f5d },
	{ 0x1f5f, 0x1f5f },
	{ 0x1f68, 0x1f6f },
	{ 0x1f80, 0x1f80 },
	{ 0x1f81, 0x1f81 },
	{ 0x1f82, 0x1f82 },
	{ 0x1f83, 0x1f83 },
	{ 0x1f84, 0x1f84 },
	{ 0x1f85, 0x1f85 },
	{ 0x1f86, 0x1f86 },
	{ 0x1f87, 0x1f87 },
	{ 0x1f88, 0x1f88 },
	{ 0x1f89, 0x1f89 },
	{ 0x1f8a, 0x1f8a },
	{ 0x1f8b, 0x1f8b },
	{ 0x1f8c, 0x1f8c },
	{ 0x1f8d, 0x1f8d },
	{ 0x1f8e, 0x1f8e },
	{ 0x1f8f, 0x1f8f },
	{ 0x1f90, 0x1f90 },
	{ 0x1f91, 0x1f91 },
	{ 0x1f92, 0x1f92 },
	{ 0x1f93, 0x1f93 },
	{ 0x1f94, 0x1f94 },
	{ 0x1f95, 0x1f95 },
	{ 0x1f96, 0x1f96 },
	{ 0x1f97, 0x1f97 },
	{ 0x1f98, 0x1f98 },
	{ 0x1f99, 0x1f99 },
	{ 0x1f9a, 0x1f9a },
	{ 0x1f9b, 0x1f9b },
	{ 0x1f9c, 0x1f9c },
	{ 0x1f9d, 0x1f9d },
	{ 0x1f9e, 0x1f9e },
	{ 0x1f9f, 0x1f9f },
	{ 0x1fa0, 0x1fa0 },
	{ 0x1fa1, 0x1fa1 },
	{ 0x1fa2, 0x1fa2 },
	{ 0x1fa3, 0x1fa3 },
	{ 0x1fa4, 0x1fa4 },
	{ 0x1fa5, 0x1fa5 },
	{ 0x1fa6, 0x1fa6 },
	{ 0x1fa7, 0x1fa7 },
	{ 0x1fa8, 0x1fa8 },
	{ 0x1fa9, 0x1fa9 },
	{ 0x1faa, 0x1faa },
	{ 0x1fab, 0x1fab },
	{ 0x1fac, 0x1fac },
	{ 0x1fad, 0x1fad },
	{ 0x1fae, 0x1fae },
	{ 0x1faf, 0x1faf },
	{ 0x1fb2, 0x1fb2 },
	{ 0x1fb3, 0x1fb3 },
	{ 0x1fb4, 0x1fb4 },
	{ 0x1fb6, 0x1fb6 },
	{ 0x1fb7, 0x1fb7 },
	{ 0x1fb8, 0x1fb9 },
	{ 0x1fba, 0x1fbb },
	{ 0x1fbc, 0x1fbc },
	{ 0x1fbe, 0x1fbe },
	{ 0x1fc2, 0x1fc2 },
	{ 0x1fc3, 0x1fc3 },
	{ 0x1fc4, 0x1fc4 },
	{ 0x1fc6, 0x1fc6 },
	{ 0x1fc7, 0x1fc7 },
	{ 0x1fc8, 0x1fcb },
	{ 0x1fcc, 0x1fcc },
	{ 0x1fd2, 0x1fd2 },
	{ 0x1fd3, 0x1fd3 },
	{ 0x1fd6, 0x1fd6 },
	{ 0x1fd7, 0x1fd7 },
	{ 0x1fd8, 0x1fd9 },
	{ 0x1fda, 0x1fdb },
	{ 0x1fe2, 0x1fe2 },
	{ 0x1fe3, 0x1fe3 },
	{ 0x1fe4, 0x1fe4 },
	{ 0x1fe6, 0x1fe6 },
	{ 0x1fe7, 0x1fe7 },
	{ 0x1fe8, 0x1fe9 },
	{ 0x1fea, 0x1feb },
	{ 0x1fec, 0x1fec },
	{ 0x1ff2, 0x1ff2 },
	{ 0x1ff3, 0x1ff3 },
	{ 0x1ff4, 0x1ff4 },
	{ 0x1ff6, 0x1ff6 },
	{ 0x1ff7, 0x1ff7 },
	{ 0x1ff8, 0x1ff9 },
	{ 0x1ffa, 0x1ffb },
	{ 0x1ffc, 0x1ffc },
	{ 0x2126, 0x2126 },
	{ 0x212a, 0x212a },
	{ 0x212b, 0x212b },
	{ 0x2132, 0x2132 },
	{ 0x2160, 0x216f },
	{ 0x2183, 0x2183 },
	{ 0x24b6, 0x24cf },
	{ 0x2c00, 0x2c2e },
	{ 0x2c60, 0x2c60 },
	{ 0x2c62, 0x2c62 },
	{ 0x2c63, 0x2c63 },
	{ 0x2c64, 0x2c64 },
	{ 0x2c67, 0x2c67 },
	{ 0x2c69, 0x2c69 },
	{ 0x2c6b, 0x2c6b },
	{ 0x2c6d, 0x2c6d },
	{ 0x2c6e, 0x2c6e },
	{ 0x2c6f, 0x2c6f },
	{ 0x2c70, 0x2c70 },
	{ 0x2c72, 0x2c72 },
	{ 0x2c75, 0x2c75 },
	{ 0x2c7e, 0x2c7f },
	{ 0x2c80, 0x2c80 },
	{ 0x2c82, 0x2c82 },
	{ 0x2c84, 0x2c84 },
	{ 0x2c86, 0x2c86 },
	{ 0x2c88, 0x2c88 },
	{ 0x2c8a, 0x2c8a },
	{ 0x2c8c, 0x2c8c },
	{ 0x2c8e, 0x2c8e },
	{ 0x2c90, 0x2c90 },
	{ 0x2c92, 0x2c92 },
	{ 0x2c94, 0x2c94 },
	{ 0x2c96, 0x2c96 },
	{ 0x2c98, 0x2c98 },
	{ 0x2c9a, 0x2c9a },
	{ 0x2c9c, 0x2c9c },
	{ 0x2c9e, 0x2c9e },
	{ 0x2ca0, 0x2ca0 },
	{ 0x2ca2, 0x2ca2 },
	{ 0x2ca4, 0x2ca4 },
	{ 0x2ca6, 0x2ca6 },
	{ 0x2ca8, 0x2ca8 },
	{ 0x2caa, 0x2caa },
	{ 0x2cac, 0x2cac },
	{ 0x2cae, 0x2cae },
	{ 0x2cb0, 0x2cb0 },
	{ 0x2cb2, 0x2cb2 },
	{ 0x2cb4, 0x2cb4 },
	{ 0x2cb6, 0x2cb6 },
	{ 0x2cb8, 0x2cb8 },
	{ 0x2cba, 0x2cba },
	{ 0x2cbc, 0x2cbc },
	{ 0x2cbe, 0x2cbe },
	{ 0x2cc0, 0x2cc0 },
	{ 0x2cc2, 0x2cc2 },
	{ 0x2cc4, 0x2cc4 },
	{ 0x2cc6, 0x2cc6 },
	{ 0x2cc8, 0x2cc8 },
	{ 0x2cca, 0x2cca },
	{ 0x2ccc, 0x2ccc },
	{ 0x2cce, 0x2cce },
	{ 0x2cd0, 0x2cd0 },
	{ 0x2cd2, 0x2cd2 },
	{ 0x2cd4, 0x2cd4 },
	{ 0x2cd6, 0x2cd6 },
	{ 0x2cd8, 0x2cd8 },
	{ 0x2cda, 0x2cda },
	{ 0x2cdc, 0x2cdc },
	{ 0x2cde, 0x2cde },
	{ 0x2ce0, 0x2ce0 },
	{ 0x2ce2, 0x2ce2 },
	{ 0x2ceb, 0x2ceb },
	{ 0x2ced, 0x2ced },
	{ 0x2cf2, 0x2cf2 },
	{ 0xa640, 0xa640 },
	{ 0xa642, 0xa642 },
	{ 0xa644, 0xa644 },
	{ 0xa646, 0xa646 },
	{ 0xa648, 0xa648 },
	{ 0xa64a, 0xa64a },
	{ 0xa64c, 0xa64c },
	{ 0xa64e, 0xa64e },
	{ 0xa650, 0xa650 },
	{ 0xa652, 0xa652 },
	{ 0xa654, 0xa654 },
	{ 0xa656, 0xa656 },
	{ 0xa658, 0xa658 },
	{ 0xa65a, 0xa65a },
	{ 0xa65c, 0xa65c },
	{ 0xa65e, 0xa65e },
	{ 0xa660, 0xa660 },
	{ 0xa662, 0xa662 },
	{ 0xa664, 0xa664 },
	{ 0xa666, 0xa666 },
	{ 0xa668, 0xa668 },
	{ 0xa66a, 0xa66a },
	{ 0xa66c, 0xa66c },
	{ 0xa680, 0xa680 },
	{ 0xa682, 0xa682 },
	{ 0xa684, 0xa684 },
	{ 0xa686, 0xa686 },
	{ 0xa688, 0xa688 },
	{ 0xa68a, 0xa68a },
	{ 0xa68c, 0xa68c },
	{ 0xa68e, 0xa68e },
	{ 0xa690, 0xa690 },
	{ 0xa692, 0xa692 },
	{ 0xa694, 0xa694 },
	{ 0xa696, 0xa696 },
	{ 0xa698, 0xa698 },
	{ 0xa69a, 0xa69a },
	{ 0xa722, 0xa722 },
	{ 0xa724, 0xa724 },
	{ 0xa726, 0xa726 },
	{ 0xa728, 0xa728 },
	{ 0xa72a, 0xa72a },
	{ 0xa72c, 0xa72c },
	{ 0xa72e, 0xa72e },
	{ 0xa732, 0xa732 },
	{ 0xa734, 0xa734 },
	{ 0xa736, 0xa736 },
	{ 0xa738, 0xa738 },
	{ 0xa73a, 0xa73a },
	{ 0xa73c, 0xa73c },
	{ 0xa73e, 0xa73e },
	{ 0xa740, 0xa740 },
	{ 0xa742, 0xa742 },
	{ 0xa744, 0xa744 },
	{ 0xa746, 0xa746 },
	{ 0xa748, 0xa748 },
	{ 0xa74a, 0xa74a },
	{ 0xa74c, 0xa74c },
	{ 0xa74e, 0xa74e },
	{ 0xa750, 0xa750 },
	{ 0xa752, 0xa752 },
	{ 0xa754, 0xa754 },
	{ 0xa756, 0xa756 },
	{ 0xa758, 0xa758 },
	{ 0xa75a, 0xa75a },
	{ 0xa75c, 0xa75c },
	{ 0xa75e, 0xa75e },
	{ 0xa760, 0xa760 },
	{ 0xa762, 0xa762 },
	{ 0xa764, 0xa764 },
	{ 0xa766, 0xa766 },
	{ 0xa768, 0xa768 },
	{ 0xa76a, 0xa76a },
	{ 0xa76c, 0xa76c },
	{ 0xa76e, 0xa76e },
	{ 0xa779, 0xa779 },
	{ 0xa77b, 0xa77b },
	{ 0xa77d, 0xa77d },
	{ 0xa77e, 0xa77e },
	{ 0xa780, 0xa780 },
	{ 0xa782, 0xa782 },
	{ 0xa784, 0xa784 },
	{ 0xa786, 0xa786 },
	{ 0xa78b, 0xa78b },
	{ 0xa78d, 0xa78d },
	{ 0xa790, 0xa790 },
	{ 0xa792, 0xa792 },
	{ 0xa796, 0xa796 },
	{ 0xa798, 0xa798 },
	{ 0xa79a, 0xa79a },
	{ 0xa79c, 0xa79c },
	{ 0xa79e, 0xa79e },
	{ 0xa7a0, 0xa7a0 },
	{ 0xa7a2, 0xa7a2 },
	{ 0xa7a4, 0xa7a4 },
	{ 0xa7a6, 0xa7a6 },
	{ 0xa7a8, 0xa7a8 },
	{ 0xa7aa, 0xa7aa },
	{ 0xa7ab, 0xa7ab },
	{ 0xa7ac, 0xa7ac },
	{ 0xa7ad, 0xa7ad },
	{ 0xa7ae, 0xa7ae },
	{ 0xa7b0, 0xa7b0 },
	{ 0xa7b1, 0xa7b1 },
	{ 0xa7b2, 0xa7b2 },
	{ 0xa7b3, 0xa7b3 },
	{ 0xa7b4, 0xa7b4 },
	{ 0xa7b6, 0xa7b6 },
	{ 0xab70, 0xabbf },
	{ 0xfb00, 0xfb00 },
	{ 0xfb01, 0xfb01 },
	{ 0xfb02, 0xfb02 },
	{ 0xfb03, 0xfb03 },
	{ 0xfb04, 0xfb04 },
	{ 0xfb05, 0xfb05 },
	{ 0xfb06, 0xfb06 },
	{ 0xfb13, 0xfb13 },
	{ 0xfb14, 0xfb14 },
	{ 0xfb15, 0xfb15 },
	{ 0xfb16, 0xfb16 },
	{ 0xfb17, 0xfb17 },
	{ 0xff21, 0xff3a },
	{ 0x10400, 0x10427 },
	{ 0x104b0, 0x104d3 },
	{ 0x10c80, 0x10cb2 },
	{ 0x118a0, 0x118bf },
	{ 0x1e900, 0x1e921 },
	{ 0x0, 0x0 }
};

int fold_repl[][REPLLEN] = {
	{ 0x61, 0x0, 0x0 },
	{ 0x3bc, 0x0, 0x0 },
	{ 0xe0, 0x0, 0x0 },
	{ 0xf8, 0x0, 0x0 },
	{ 0x73, 0x73, 0x0 },
	{ 0x101, 0x0, 0x0 },
	{ 0x103, 0x0, 0x0 },
	{ 0x105, 0x0, 0x0 },
	{ 0x107, 0x0, 0x0 },
	{ 0x109, 0x0, 0x0 },
	{ 0x10b, 0x0, 0x0 },
	{ 0x10d, 0x0, 0x0 },
	{ 0x10f, 0x0, 0x0 },
	{ 0x111, 0x0, 0x0 },
	{ 0x113, 0x0, 0x0 },
	{ 0x115, 0x0, 0x0 },
	{ 0x117, 0x0, 0x0 },
	{ 0x119, 0x0, 0x0 },
	{ 0x11b, 0x0, 0x0 },
	{ 0x11d, 0x0, 0x0 },
	{ 0x11f, 0x0, 0x0 },
	{ 0x121, 0x0, 0x0 },
	{ 0x123, 0x0, 0x0 },
	{ 0x125, 0x0, 0x0 },
	{ 0x127, 0x0, 0x0 },
	{ 0x129, 0x0, 0x0 },
	{ 0x12b, 0x0, 0x0 },
	{ 0x12d, 0x0, 0x0 },
	{ 0x12f, 0x0, 0x0 },
	{ 0x69, 0x307, 0x0 },
	{ 0x133, 0x0, 0x0 },
	{ 0x135, 0x0, 0x0 },
	{ 0x137, 0x0, 0x0 },
	{ 0x13a, 0x0, 0x0 },
	{ 0x13c, 0x0, 0x0 },
	{ 0x13e, 0x0, 0x0 },
	{ 0x140, 0x0, 0x0 },
	{ 0x142, 0x0, 0x0 },
	{ 0x144, 0x0, 0x0 },
	{ 0x146, 0x0, 0x0 },
	{ 0x148, 0x0, 0x0 },
	{ 0x2bc, 0x6e, 0x0 },
	{ 0x14b, 0x0, 0x0 },
	{ 0x14d, 0x0, 0x0 },
	{ 0x14f, 0x0, 0x0 },
	{ 0x151, 0x0, 0x0 },
	{ 0x153, 0x0, 0x0 },
	{ 0x155, 0x0, 0x0 },
	{ 0x157, 0x0, 0x0 },
	{ 0x159, 0x0, 0x0 },
	{ 0x15b, 0x0, 0x0 },
	{ 0x15d, 0x0, 0x0 },
	{ 0x15f, 0x0, 0x0 },
	{ 0x161, 0x0, 0x0 },
	{ 0x163, 0x0, 0x0 },
	{ 0x165, 0x0, 0x0 },
	{ 0x167, 0x0, 0x0 },
	{ 0x169, 0x0, 0x0 },
	{ 0x16b, 0x0, 0x0 },
	{ 0x16d, 0x0, 0x0 },
	{ 0x16f, 0x0, 0x0 },
	{ 0x171, 0x0, 0x0 },
	{ 0x173, 0x0, 0x0 },
	{ 0x175, 0x0, 0x0 },
	{ 0x177, 0x0, 0x0 },
	{ 0xff, 0x0, 0x0 },
	{ 0x17a, 0x0, 0x0 },
	{ 0x17c, 0x0, 0x0 },
	{ 0x17e, 0x0, 0x0 },
	{ 0x73, 0x0, 0x0 },
	{ 0x253, 0x0, 0x0 },
	{ 0x183, 0x0, 0x0 },
	{ 0x185, 0x0, 0x0 },
	{ 0x254, 0x0, 0x0 },
	{ 0x188, 0x0, 0x0 },
	{ 0x256, 0x0, 0x0 },
	{ 0x18c, 0x0, 0x0 },
	{ 0x1dd, 0x0, 0x0 },
	{ 0x259, 0x0, 0x0 },
	{ 0x25b, 0x0, 0x0 },
	{ 0x192, 0x0, 0x0 },
	{ 0x260, 0x0, 0x0 },
	{ 0x263, 0x0, 0x0 },
	{ 0x269, 0x0, 0x0 },
	{ 0x268, 0x0, 0x0 },
	{ 0x199, 0x0, 0x0 },
	{ 0x26f, 0x0, 0x0 },
	{ 0x272, 0x0, 0x0 },
	{ 0x275, 0x0, 0x0 },
	{ 0x1a1, 0x0, 0x0 },
	{ 0x1a3, 0x0, 0x0 },
	{ 0x1a5, 0x0, 0x0 },
	{ 0x280, 0x0, 0x0 },
	{ 0x1a8, 0x0, 0x0 },
	{ 0x283, 0x0, 0x0 },
	{ 0x1ad, 0x0, 0x0 },
	{ 0x288, 0x0, 0x0 },
	{ 0x1b0, 0x0, 0x0 },
	{ 0x28a, 0x0, 0x0 },
	{ 0x1b4, 0x0, 0x0 },
	{ 0x1b6, 0x0, 0x0 },
	{ 0x292, 0x0, 0x0 },
	{ 0x1b9, 0x0, 0x0 },
	{ 0x1bd, 0x0, 0x0 },
	{ 0x1c6, 0x0, 0x0 },
	{ 0x1c6, 0x0, 0x0 },
	{ 0x1c9, 0x0, 0x0 },
	{ 0x1c9, 0x0, 0x0 },
	{ 0x1cc, 0x0, 0x0 },
	{ 0x1cc, 0x0, 0x0 },
	{ 0x1ce, 0x0, 0x0 },
	{ 0x1d0, 0x0, 0x0 },
	{ 0x1d2, 0x0, 0x0 },
	{ 0x1d4, 0x0, 0x0 },
	{ 0x1d6, 0x0, 0x0 },
	{ 0x1d8, 0x0, 0x0 },
	{ 0x1da, 0x0, 0x0 },
	{ 0x1dc, 0x0, 0x0 },
	{ 0x1df, 0x0, 0x0 },
	{ 0x1e1, 0x0, 0x0 },
	{ 0x1e3, 0x0, 0x0 },
	{ 0x1e5, 0x0, 0x0 },
	{ 0x1e7, 0x0, 0x0 },
	{ 0x1e9, 0x0, 0x0 },
	{ 0x1eb, 0x0, 0x0 },
	{ 0x1ed, 0x0, 0x0 },
	{ 0x1ef, 0x0, 0x0 },
	{ 0x6a, 0x30c, 0x0 },
	{ 0x1f3, 0x0, 0x0 },
	{ 0x1f3, 0x0, 0x0 },
	{ 0x1f5, 0x0, 0x0 },
	{ 0x195, 0x0, 0x0 },
	{ 0x1bf, 0x0, 0x0 },
	{ 0x1f9, 0x0, 0x0 },
	{ 0x1fb, 0x0, 0x0 },
	{ 0x1fd, 0x0, 0x0 },
	{ 0x1ff, 0x0, 0x0 },
	{ 0x201, 0x0, 0x0 },
	{ 0x203, 0x0, 0x0 },
	{ 0x205, 0x0, 0x0 },
	{ 0x207, 0x0, 0x0 },
	{ 0x209, 0x0, 0x0 },
	{ 0x20b, 0x0, 0x0 },
	{ 0x20d, 0x0, 0x0 },
	{ 0x20f, 0x0, 0x0 },
	{ 0x211, 0x0, 0x0 },
	{ 0x213, 0x0, 0x0 },
	{ 0x215, 0x0, 0x0 },
	{ 0x217, 0x0, 0x0 },
	{ 0x219, 0x0, 0x0 },
	{ 0x21b, 0x0, 0x0 },
	{ 0x21d, 0x0, 0x0 },
	{ 0x21f, 0x0, 0x0 },
	{ 0x19e, 0x0, 0x0 },
	{ 0x223, 0x0, 0x0 },
	{ 0x225, 0x0, 0x0 },
	{ 0x227, 0x0, 0x0 },
	{ 0x229, 0x0, 0x0 },
	{ 0x22b, 0x0, 0x0 },
	{ 0x22d, 0x0, 0x0 },
	{ 0x22f, 0x0, 0x0 },
	{ 0x231, 0x0, 0x0 },
	{ 0x233, 0x0, 0x0 },
	{ 0x2c65, 0x0, 0x0 },
	{ 0x23c, 0x0, 0x0 },
	{ 0x19a, 0x0, 0x0 },
	{ 0x2c66, 0x0, 0x0 },
	{ 0x242, 0x0, 0x0 },
	{ 0x180, 0x0, 0x0 },
	{ 0x289, 0x0, 0x0 },
	{ 0x28c, 0x0, 0x0 },
	{ 0x247, 0x0, 0x0 },
	{ 0x249, 0x0, 0x0 },
	{ 0x24b, 0x0, 0x0 },
	{ 0x24d, 0x0, 0x0 },
	{ 0x24f, 0x0, 0x0 },
	{ 0x3b9, 0x0, 0x0 },
	{ 0x371, 0x0, 0x0 },
	{ 0x373, 0x0, 0x0 },
	{ 0x377, 0x0, 0x0 },
	{ 0x3f3, 0x0, 0x0 },
	{ 0x3ac, 0x0, 0x0 },
	{ 0x3ad, 0x0, 0x0 },
	{ 0x3cc, 0x0, 0x0 },
	{ 0x3cd, 0x0, 0x0 },
	{ 0x3b9, 0x308, 0x301 },
	{ 0x3b1, 0x0, 0x0 },
	{ 0x3c3, 0x0, 0x0 },
	{ 0x3c5, 0x308, 0x301 },
	{ 0x3c3, 0x0, 0x0 },
	{ 0x3d7, 0x0, 0x0 },
	{ 0x3b2, 0x0, 0x0 },
	{ 0x3b8, 0x0, 0x0 },
	{ 0x3c6, 0x0, 0x0 },
	{ 0x3c0, 0x0, 0x0 },
	{ 0x3d9, 0x0, 0x0 },
	{ 0x3db, 0x0, 0x0 },
	{ 0x3dd, 0x0, 0x0 },
	{ 0x3df, 0x0, 0x0 },
	{ 0x3e1, 0x0, 0x0 },
	{ 0x3e3, 0x0, 0x0 },
	{ 0x3e5, 0x0, 0x0 },
	{ 0x3e7, 0x0, 0x0 },
	{ 0x3e9, 0x0, 0x0 },
	{ 0x3eb, 0x0, 0x0 },
	{ 0x3ed, 0x0, 0x0 },
	{ 0x3ef, 0x0, 0x0 },
	{ 0x3ba, 0x0, 0x0 },
	{ 0x3c1, 0x0, 0x0 },
	{ 0x3b8, 0x0, 0x0 },
	{ 0x3b5, 0x0, 0x0 },
	{ 0x3f8, 0x0, 0x0 },
	{ 0x3f2, 0x0, 0x0 },
	{ 0x3fb, 0x0, 0x0 },
	{ 0x37b, 0x0, 0x0 },
	{ 0x450, 0x0, 0x0 },
	{ 0x430, 0x0, 0x0 },
	{ 0x461, 0x0, 0x0 },
	{ 0x463, 0x0, 0x0 },
	{ 0x465, 0x0, 0x0 },
	{ 0x467, 0x0, 0x0 },
	{ 0x469, 0x0, 0x0 },
	{ 0x46b, 0x0, 0x0 },
	{ 0x46d, 0x0, 0x0 },
	{ 0x46f, 0x0, 0x0 },
	{ 0x471, 0x0, 0x0 },
	{ 0x473, 0x0, 0x0 },
	{ 0x475, 0x0, 0x0 },
	{ 0x477, 0x0, 0x0 },
	{ 0x479, 0x0, 0x0 },
	{ 0x47b, 0x0, 0x0 },
	{ 0x47d, 0x0, 0x0 },
	{ 0x47f, 0x0, 0x0 },
	{ 0x481, 0x0, 0x0 },
	{ 0x48b, 0x0, 0x0 },
	{ 0x48d, 0x0, 0x0 },
	{ 0x48f, 0x0, 0x0 },
	{ 0x491, 0x0, 0x0 },
	{ 0x493, 0x0, 0x0 },
	{ 0x495, 0x0, 0x0 },
	{ 0x497, 0x0, 0x0 },
	{ 0x499, 0x0, 0x0 },
	{ 0x49b, 0x0, 0x0 },
	{ 0x49d, 0x0, 0x0 },
	{ 0x49f, 0x0, 0x0 },
	{ 0x4a1, 0x0, 0x0 },
	{ 0x4a3, 0x0, 0x0 },
	{ 0x4a5, 0x0, 0x0 },
	{ 0x4a7, 0x0, 0x0 },
	{ 0x4a9, 0x0, 0x0 },
	{ 0x4ab, 0x0, 0x0 },
	{ 0x4ad, 0x0, 0x0 },
	{ 0x4af, 0x0, 0x0 },
	{ 0x4b1, 0x0, 0x0 },
	{ 0x4b3, 0x0, 0x0 },
	{ 0x4b5, 0x0, 0x0 },
	{ 0x4b7, 0x0, 0x0 },
	{ 0x4b9, 0x0, 0x0 },
	{ 0x4bb, 0x0, 0x0 },
	{ 0x4bd, 0x0, 0x0 },
	{ 0x4bf, 0x0, 0x0 },
	{ 0x4cf, 0x0, 0x0 },
	{ 0x4c2, 0x0, 0x0 },
	{ 0x4c4, 0x0, 0x0 },
	{ 0x4c6, 0x0, 0x0 },
	{ 0x4c8, 0x0, 0x0 },
	{ 0x4ca, 0x0, 0x0 },
	{ 0x4cc, 0x0, 0x0 },
	{ 0x4ce, 0x0, 0x0 },
	{ 0x4d1, 0x0, 0x0 },
	{ 0x4d3, 0x0, 0x0 },
	{ 0x4d5, 0x0, 0x0 },
	{ 0x4d7, 0x0, 0x0 },
	{ 0x4d9, 0x0, 0x0 },
	{ 0x4db, 0x0, 0x0 },
	{ 0x4dd, 0x0, 0x0 },
	{ 0x4df, 0x0, 0x0 },
	{ 0x4e1, 0x0, 0x0 },
	{ 0x4e3, 0x0, 0x0 },
	{ 0x4e5, 0x0, 0x0 },
	{ 0x4e7, 0x0, 0x0 },
	{ 0x4e9, 0x0, 0x0 },
	{ 0x4eb, 0x0, 0x0 },
	{ 0x4ed, 0x0, 0x0 },
	{ 0x4ef, 0x0, 0x0 },
	{ 0x4f1, 0x0, 0x0 },
	{ 0x4f3, 0x0, 0x0 },
	{ 0x4f5, 0x0, 0x0 },
	{ 0x4f7, 0x0, 0x0 },
	{ 0x4f9, 0x0, 0x0 },
	{ 0x4fb, 0x0, 0x0 },
	{ 0x4fd, 0x0, 0x0 },
	{ 0x4ff, 0x0, 0x0 },
	{ 0x501, 0x0, 0x0 },
	{ 0x503, 0x0, 0x0 },
	{ 0x505, 0x0, 0x0 },
	{ 0x507, 0x0, 0x0 },
	{ 0x509, 0x0, 0x0 },
	{ 0x50b, 0x0, 0x0 },
	{ 0x50d, 0x0, 0x0 },
	{ 0x50f, 0x0, 0x0 },
	{ 0x511, 0x0, 0x0 },
	{ 0x513, 0x0, 0x0 },
	{ 0x515, 0x0, 0x0 },
	{ 0x517, 0x0, 0x0 },
	{ 0x519, 0x0, 0x0 },
	{ 0x51b, 0x0, 0x0 },
	{ 0x51d, 0x0, 0x0 },
	{ 0x51f, 0x0, 0x0 },
	{ 0x521, 0x0, 0x0 },
	{ 0x523, 0x0, 0x0 },
	{ 0x525, 0x0, 0x0 },
	{ 0x527, 0x0, 0x0 },
	{ 0x529, 0x0, 0x0 },
	{ 0x52b, 0x0, 0x0 },
	{ 0x52d, 0x0, 0x0 },
	{ 0x52f, 0x0, 0x0 },
	{ 0x561, 0x0, 0x0 },
	{ 0x565, 0x582, 0x0 },
	{ 0x2d00, 0x0, 0x0 },
	{ 0x2d27, 0x0, 0x0 },
	{ 0x2d2d, 0x0, 0x0 },
	{ 0x13f0, 0x0, 0x0 },
	{ 0x432, 0x0, 0x0 },
	{ 0x434, 0x0, 0x0 },
	{ 0x43e, 0x0, 0x0 },
	{ 0x441, 0x0, 0x0 },
	{ 0x442, 0x0, 0x0 },
	{ 0x44a, 0x0, 0x0 },
	{ 0x463, 0x0, 0x0 },
	{ 0xa64b, 0x0, 0x0 },
	{ 0x1e01, 0x0, 0x0 },
	{ 0x1e03, 0x0, 0x0 },
	{ 0x1e05, 0x0, 0x0 },
	{ 0x1e07, 0x0, 0x0 },
	{ 0x1e09, 0x0, 0x0 },
	{ 0x1e0b, 0x0, 0x0 },
	{ 0x1e0d, 0x0, 0x0 },
	{ 0x1e0f, 0x0, 0x0 },
	{ 0x1e11, 0x0, 0x0 },
	{ 0x1e13, 0x0, 0x0 },
	{ 0x1e15, 0x0, 0x0 },
	{ 0x1e17, 0x0, 0x0 },
	{ 0x1e19, 0x0, 0x0 },
	{ 0x1e1b, 0x0, 0x0 },
	{ 0x1e1d, 0x0, 0x0 },
	{ 0x1e1f, 0x0, 0x0 },
	{ 0x1e21, 0x0, 0x0 },
	{ 0x1e23, 0x0, 0x0 },
	{ 0x1e25, 0x0, 0x0 },
	{ 0x1e27, 0x0, 0x0 },
	{ 0x1e29, 0x0, 0x0 },
	{ 0x1e2b, 0x0, 0x0 },
	{ 0x1e2d, 0x0, 0x0 },
	{ 0x1e2f, 0x0, 0x0 },
	{ 0x1e31, 0x0, 0x0 },
	{ 0x1e33, 0x0, 0x0 },
	{ 0x1e35, 0x0, 0x0 },
	{ 0x1e37, 0x0, 0x0 },
	{ 0x1e39, 0x0, 0x0 },
	{ 0x1e3b, 0x0, 0x0 },
	{ 0x1e3d, 0x0, 0x0 },
	{ 0x1e3f, 0x0, 0x0 },
	{ 0x1e41, 0x0, 0x0 },
	{ 0x1e43, 0x0, 0x0 },
	{ 0x1e45, 0x0, 0x0 },
	{ 0x1e47, 0x0, 0x0 },
	{ 0x1e49, 0x0, 0x0 },
	{ 0x1e4b, 0x0, 0x0 },
	{ 0x1e4d, 0x0, 0x0 },
	{ 0x1e4f, 0x0, 0x0 },
	{ 0x1e51, 0x0, 0x0 },
	{ 0x1e53, 0x0, 0x0 },
	{ 0x1e55, 0x0, 0x0 },
	{ 0x1e57, 0x0, 0x0 },
	{ 0x1e59, 0x0, 0x0 },
	{ 0x1e5b, 0x0, 0x0 },
	{ 0x1e5d, 0x0, 0x0 },
	{ 0x1e5f, 0x0, 0x0 },
	{ 0x1e61, 0x0, 0x0 },
	{ 0x1e63, 0x0, 0x0 },
	{ 0x1e65, 0x0, 0x0 },
	{ 0x1e67, 0x0, 0x0 },
	{ 0x1e69, 0x0, 0x0 },
	{ 0x1e6b, 0x0, 0x0 },
	{ 0x1e6d, 0x0, 0x0 },
	{ 0x1e6f, 0x0, 0x0 },
	{ 0x1e71, 0x0, 0x0 },
	{ 0x1e73, 0x0, 0x0 },
	{ 0x1e75, 0x0, 0x0 },
	{ 0x1e77, 0x0, 0x0 },
	{ 0x1e79, 0x0, 0x0 },
	{ 0x1e7b, 0x0, 0x0 },
	{ 0x1e7d, 0x0, 0x0 },
	{ 0x1e7f, 0x0, 0x0 },
	{ 0x1e81, 0x0, 0x0 },
	{ 0x1e83, 0x0, 0x0 },
	{ 0x1e85, 0x0, 0x0 },
	{ 0x1e87, 0x0, 0x0 },
	{ 0x1e89, 0x0, 0x0 },
	{ 0x1e8b, 0x0, 0x0 },
	{ 0x1e8d, 0x0, 0x0 },
	{ 0x1e8f, 0x0, 0x0 },
	{ 0x1e91, 0x0, 0x0 },
	{ 0x1e93, 0x0, 0x0 },
	{ 0x1e95, 0x0, 0x0 },
	{ 0x68, 0x331, 0x0 },
	{ 0x74, 0x308, 0x0 },
	{ 0x77, 0x30a, 0x0 },
	{ 0x79, 0x30a, 0x0 },
	{ 0x61, 0x2be, 0x0 },
	{ 0x1e61, 0x0, 0x0 },
	{ 0x73, 0x73, 0x0 },
	{ 0x1ea1, 0x0, 0x0 },
	{ 0x1ea3, 0x0, 0x0 },
	{ 0x1ea5, 0x0, 0x0 },
	{ 0x1ea7, 0x0, 0x0 },
	{ 0x1ea9, 0x0, 0x0 },
	{ 0x1eab, 0x0, 0x0 },
	{ 0x1ead, 0x0, 0x0 },
	{ 0x1eaf, 0x0, 0x0 },
	{ 0x1eb1, 0x0, 0x0 },
	{ 0x1eb3, 0x0, 0x0 },
	{ 0x1eb5, 0x0, 0x0 },
	{ 0x1eb7, 0x0, 0x0 },
	{ 0x1eb9, 0x0, 0x0 },
	{ 0x1ebb, 0x0, 0x0 },
	{ 0x1ebd, 0x0, 0x0 },
	{ 0x1ebf, 0x0, 0x0 },
	{ 0x1ec1, 0x0, 0x0 },
	{ 0x1ec3, 0x0, 0x0 },
	{ 0x1ec5, 0x0, 0x0 },
	{ 0x1ec7, 0x0, 0x0 },
	{ 0x1ec9, 0x0, 0x0 },
	{ 0x1ecb, 0x0, 0x0 },
	{ 0x1ecd, 0x0, 0x0 },
	{ 0x1ecf, 0x0, 0x0 },
	{ 0x1ed1, 0x0, 0x0 },
	{ 0x1ed3, 0x0, 0x0 },
	{ 0x1ed5, 0x0, 0x0 },
	{ 0x1ed7, 0x0, 0x0 },
	{ 0x1ed9, 0x0, 0x0 },
	{ 0x1edb, 0x0, 0x0 },
	{ 0x1edd, 0x0, 0x0 },
	{ 0x1edf, 0x0, 0x0 },
	{ 0x1ee1, 0x0, 0x0 },
	{ 0x1ee3, 0x0, 0x0 },
	{ 0x1ee5, 0x0, 0x0 },
	{ 0x1ee7, 0x0, 0x0 },
	{ 0x1ee9, 0x0, 0x0 },
	{ 0x1eeb, 0x0, 0x0 },
	{ 0x1eed, 0x0, 0x0 },
	{ 0x1eef, 0x0, 0x0 },
	{ 0x1ef1, 0x0, 0x0 },
	{ 0x1ef3, 0x0, 0x0 },
	{ 0x1ef5, 0x0, 0x0 },
	{ 0x1ef7, 0x0, 0x0 },
	{ 0x1ef9, 0x0, 0x0 },
	{ 0x1efb, 0x0, 0x0 },
	{ 0x1efd, 0x0, 0x0 },
	{ 0x1eff, 0x0, 0x0 },
	{ 0x1f00, 0x0, 0x0 },
	{ 0x1f10, 0x0, 0x0 },
	{ 0x1f20, 0x0, 0x0 },
	{ 0x1f30, 0x0, 0x0 },
	{ 0x1f40, 0x0, 0x0 },
	{ 0x3c5, 0x313, 0x0 },
	{ 0x3c5, 0x313, 0x300 },
	{ 0x3c5, 0x313, 0x301 },
	{ 0x3c5, 0x313, 0x342 },
	{ 0x1f51, 0x0, 0x0 },
	{ 0x1f53, 0x0, 0x0 },
	{ 0x1f55, 0x0, 0x0 },
	{ 0x1f57, 0x0, 0x0 },
	{ 0x1f60, 0x0, 0x0 },
	{ 0x1f00, 0x3b9, 0x0 },
	{ 0x1f01, 0x3b9, 0x0 },
	{ 0x1f02, 0x3b9, 0x0 },
	{ 0x1f03, 0x3b9, 0x0 },
	{ 0x1f04, 0x3b9, 0x0 },
	{ 0x1f05, 0x3b9, 0x0 },
	{ 0x1f06, 0x3b9, 0x0 },
	{ 0x1f07, 0x3b9, 0x0 },
	{ 0x1f00, 0x3b9, 0x0 },
	{ 0x1f01, 0x3b9, 0x0 },
	{ 0x1f02, 0x3b9, 0x0 },
	{ 0x1f03, 0x3b9, 0x0 },
	{ 0x1f04, 0x3b9, 0x0 },
	{ 0x1f05, 0x3b9, 0x0 },
	{ 0x1f06, 0x3b9, 0x0 },
	{ 0x1f07, 0x3b9, 0x0 },
	{ 0x1f20, 0x3b9, 0x0 },
	{ 0x1f21, 0x3b9, 0x0 },
	{ 0x1f22, 0x3b9, 0x0 },
	{ 0x1f23, 0x3b9, 0x0 },
	{ 0x1f24, 0x3b9, 0x0 },
	{ 0x1f25, 0x3b9, 0x0 },
	{ 0x1f26, 0x3b9, 0x0 },
	{ 0x1f27, 0x3b9, 0x0 },
	{ 0x1f20, 0x3b9, 0x0 },
	{ 0x1f21, 0x3b9, 0x0 },
	{ 0x1f22, 0x3b9, 0x0 },
	{ 0x1f23, 0x3b9, 0x0 },
	{ 0x1f24, 0x3b9, 0x0 },
	{ 0x1f25, 0x3b9, 0x0 },
	{ 0x1f26, 0x3b9, 0x0 },
	{ 0x1f27, 0x3b9, 0x0 },
	{ 0x1f60, 0x3b9, 0x0 },
	{ 0x1f61, 0x3b9, 0x0 },
	{ 0x1f62, 0x3b9, 0x0 },
	{ 0x1f63, 0x3b9, 0x0 },
	{ 0x1f64, 0x3b9, 0x0 },
	{ 0x1f65, 0x3b9, 0x0 },
	{ 0x1f66, 0x3b9, 0x0 },
	{ 0x1f67, 0x3b9, 0x0 },
	{ 0x1f60, 0x3b9, 0x0 },
	{ 0x1f61, 0x3b9, 0x0 },
	{ 0x1f62, 0x3b9, 0x0 },
	{ 0x1f63, 0x3b9, 0x0 },
	{ 0x1f64, 0x3b9, 0x0 },
	{ 0x1f65, 0x3b9, 0x0 },
	{ 0x1f66, 0x3b9, 0x0 },
	{ 0x1f67, 0x3b9, 0x0 },
	{ 0x1f70, 0x3b9, 0x0 },
	{ 0x3b1, 0x3b9, 0x0 },
	{ 0x3ac, 0x3b9, 0x0 },
	{ 0x3b1, 0x342, 0x0 },
	{ 0x3b1, 0x342, 0x3b9 },
	{ 0x1fb0, 0x0, 0x0 },
	{ 0x1f70, 0x0, 0x0 },
	{ 0x3b1, 0x3b9, 0x0 },
	{ 0x3b9, 0x0, 0x0 },
	{ 0x1f74, 0x3b9, 0x0 },
	{ 0x3b7, 0x3b9, 0x0 },
	{ 0x3ae, 0x3b9, 0x0 },
	{ 0x3b7, 0x342, 0x0 },
	{ 0x3b7, 0x342, 0x3b9 },
	{ 0x1f72, 0x0, 0x0 },
	{ 0x3b7, 0x3b9, 0x0 },
	{ 0x3b9, 0x308, 0x300 },
	{ 0x3b9, 0x308, 0x301 },
	{ 0x3b9, 0x342, 0x0 },
	{ 0x3b9, 0x308, 0x342 },
	{ 0x1fd0, 0x0, 0x0 },
	{ 0x1f76, 0x0, 0x0 },
	{ 0x3c5, 0x308, 0x300 },
	{ 0x3c5, 0x308, 0x301 },
	{ 0x3c1, 0x313, 0x0 },
	{ 0x3c5, 0x342, 0x0 },
	{ 0x3c5, 0x308, 0x342 },
	{ 0x1fe0, 0x0, 0x0 },
	{ 0x1f7a, 0x0, 0x0 },
	{ 0x1fe5, 0x0, 0x0 },
	{ 0x1f7c, 0x3b9, 0x0 },
	{ 0x3c9, 0x3b9, 0x0 },
	{ 0x3ce, 0x3b9, 0x0 },
	{ 0x3c9, 0x342, 0x0 },
	{ 0x3c9, 0x342, 0x3b9 },
	{ 0x1f78, 0x0, 0x0 },
	{ 0x1f7c, 0x0, 0x0 },
	{ 0x3c9, 0x3b9, 0x0 },
	{ 0x3c9, 0x0, 0x0 },
	{ 0x6b, 0x0, 0x0 },
	{ 0xe5, 0x0, 0x0 },
	{ 0x214e, 0x0, 0x0 },
	{ 0x2170, 0x0, 0x0 },
	{ 0x2184, 0x0, 0x0 },
	{ 0x24d0, 0x0, 0x0 },
	{ 0x2c30, 0x0, 0x0 },
	{ 0x2c61, 0x0, 0x0 },
	{ 0x26b, 0x0, 0x0 },
	{ 0x1d7d, 0x0, 0x0 },
	{ 0x27d, 0x0, 0x0 },
	{ 0x2c68, 0x0, 0x0 },
	{ 0x2c6a, 0x0, 0x0 },
	{ 0x2c6c, 0x0, 0x0 },
	{ 0x251, 0x0, 0x0 },
	{ 0x271, 0x0, 0x0 },
	{ 0x250, 0x0, 0x0 },
	{ 0x252, 0x0, 0x0 },
	{ 0x2c73, 0x0, 0x0 },
	{ 0x2c76, 0x0, 0x0 },
	{ 0x23f, 0x0, 0x0 },
	{ 0x2c81, 0x0, 0x0 },
	{ 0x2c83, 0x0, 0x0 },
	{ 0x2c85, 0x0, 0x0 },
	{ 0x2c87, 0x0, 0x0 },
	{ 0x2c89, 0x0, 0x0 },
	{ 0x2c8b, 0x0, 0x0 },
	{ 0x2c8d, 0x0, 0x0 },
	{ 0x2c8f, 0x0, 0x0 },
	{ 0x2c91, 0x0, 0x0 },
	{ 0x2c93, 0x0, 0x0 },
	{ 0x2c95, 0x0, 0x0 },
	{ 0x2c97, 0x0, 0x0 },
	{ 0x2c99, 0x0, 0x0 },
	{ 0x2c9b, 0x0, 0x0 },
	{ 0x2c9d, 0x0, 0x0 },
	{ 0x2c9f, 0x0, 0x0 },
	{ 0x2ca1, 0x0, 0x0 },
	{ 0x2ca3, 0x0, 0x0 },
	{ 0x2ca5, 0x0, 0x0 },
	{ 0x2ca7, 0x0, 0x0 },
	{ 0x2ca9, 0x0, 0x0 },
	{ 0x2cab, 0x0, 0x0 },
	{ 0x2cad, 0x0, 0x0 },
	{ 0x2caf, 0x0, 0x0 },
	{ 0x2cb1, 0x0, 0x0 },
	{ 0x2cb3, 0x0, 0x0 },
	{ 0x2cb5, 0x0, 0x0 },
	{ 0x2cb7, 0x0, 0x0 },
	{ 0x2cb9, 0x0, 0x0 },
	{ 0x2cbb, 0x0, 0x0 },
	{ 0x2cbd, 0x0, 0x0 },
	{ 0x2cbf, 0x0, 0x0 },
	{ 0x2cc1, 0x0, 0x0 },
	{ 0x2cc3, 0x0, 0x0 },
	{ 0x2cc5, 0x0, 0x0 },
	{ 0x2cc7, 0x0, 0x0 },
	{ 0x2cc9, 0x0, 0x0 },
	{ 0x2ccb, 0x0, 0x0 },
	{ 0x2ccd, 0x0, 0x0 },
	{ 0x2ccf, 0x0, 0x0 },
	{ 0x2cd1, 0x0, 0x0 },
	{ 0x2cd3, 0x0, 0x0 },
	{ 0x2cd5, 0x0, 0x0 },
	{ 0x2cd7, 0x0, 0x0 },
	{ 0x2cd9, 0x0, 0x0 },
	{ 0x2cdb, 0x0, 0x0 },
	{ 0x2cdd, 0x0, 0x0 },
	{ 0x2cdf, 0x0, 0x0 },
	{ 0x2ce1, 0x0, 0x0 },
	{ 0x2ce3, 0x0, 0x0 },
	{ 0x2cec, 0x0, 0x0 },
	{ 0x2cee, 0x0, 0x0 },
	{ 0x2cf3, 0x0, 0x0 },
	{ 0xa641, 0x0, 0x0 },
	{ 0xa643, 0x0, 0x0 },
	{ 0xa645, 0x0, 0x0 },
	{ 0xa647, 0x0, 0x0 },
	{ 0xa649, 0x0, 0x0 },
	{ 0xa64b, 0x0, 0x0 },
	{ 0xa64d, 0x0, 0x0 },
	{ 0xa64f, 0x0, 0x0 },
	{ 0xa651, 0x0, 0x0 },
	{ 0xa653, 0x0, 0x0 },
	{ 0xa655, 0x0, 0x0 },
	{ 0xa657, 0x0, 0x0 },
	{ 0xa659, 0x0, 0x0 },
	{ 0xa65b, 0x0, 0x0 },
	{ 0xa65d, 0x0, 0x0 },
	{ 0xa65f, 0x0, 0x0 },
	{ 0xa661, 0x0, 0x0 },
	{ 0xa663, 0x0, 0x0 },
	{ 0xa665, 0x0, 0x0 },
	{ 0xa667, 0x0, 0x0 },
	{ 0xa669, 0x0, 0x0 },
	{ 0xa66b, 0x0, 0x0 },
	{ 0xa66d, 0x0, 0x0 },
	{ 0xa681, 0x0, 0x0 },
	{ 0xa683, 0x0, 0x0 },
	{ 0xa685, 0x0, 0x0 },
	{ 0xa687, 0x0, 0x0 },
	{ 0xa689, 0x0, 0x0 },
	{ 0xa68b, 0x0, 0x0 },
	{ 0xa68d, 0x0, 0x0 },
	{ 0xa68f, 0x0, 0x0 },
	{ 0xa691, 0x0, 0x0 },
	{ 0xa693, 0x0, 0x0 },
	{ 0xa695, 0x0, 0x0 },
	{ 0xa697, 0x0, 0x0 },
	{ 0xa699, 0x0, 0x0 },
	{ 0xa69b, 0x0, 0x0 },
	{ 0xa723, 0x0, 0x0 },
	{ 0xa725, 0x0, 0x0 },
	{ 0xa727, 0x0, 0x0 },
	{ 0xa729, 0x0, 0x0 },
	{ 0xa72b, 0x0, 0x0 },
	{ 0xa72d, 0x0, 0x0 },
	{ 0xa72f, 0x0, 0x0 },
	{ 0xa733, 0x0, 0x0 },
	{ 0xa735, 0x0, 0x0 },
	{ 0xa737, 0x0, 0x0 },
	{ 0xa739, 0x0, 0x0 },
	{ 0xa73b, 0x0, 0x0 },
	{ 0xa73d, 0x0, 0x0 },
	{ 0xa73f, 0x0, 0x0 },
	{ 0xa741, 0x0, 0x0 },
	{ 0xa743, 0x0, 0x0 },
	{ 0xa745, 0x0, 0x0 },
	{ 0xa747, 0x0, 0x0 },
	{ 0xa749, 0x0, 0x0 },
	{ 0xa74b, 0x0, 0x0 },
	{ 0xa74d, 0x0, 0x0 },
	{ 0xa74f, 0x0, 0x0 },
	{ 0xa751, 0x0, 0x0 },
	{ 0xa753, 0x0, 0x0 },
	{ 0xa755, 0x0, 0x0 },
	{ 0xa757, 0x0, 0x0 },
	{ 0xa759, 0x0, 0x0 },
	{ 0xa75b, 0x0, 0x0 },
	{ 0xa75d, 0x0, 0x0 },
	{ 0xa75f, 0x0, 0x0 },
	{ 0xa761, 0x0, 0x0 },
	{ 0xa763, 0x0, 0x0 },
	{ 0xa765, 0x0, 0x0 },
	{ 0xa767, 0x0, 0x0 },
	{ 0xa769, 0x0, 0x0 },
	{ 0xa76b, 0x0, 0x0 },
	{ 0xa76d, 0x0, 0x0 },
	{ 0xa76f, 0x0, 0x0 },
	{ 0xa77a, 0x0, 0x0 },
	{ 0xa77c, 0x0, 0x0 },
	{ 0x1d79, 0x0, 0x0 },
	{ 0xa77f, 0x0, 0x0 },
	{ 0xa781, 0x0, 0x0 },
	{ 0xa783, 0x0, 0x0 },
	{ 0xa785, 0x0, 0x0 },
	{ 0xa787, 0x0, 0x0 },
	{ 0xa78c, 0x0, 0x0 },
	{ 0x265, 0x0, 0x0 },
	{ 0xa791, 0x0, 0x0 },
	{ 0xa793, 0x0, 0x0 },
	{ 0xa797, 0x0, 0x0 },
	{ 0xa799, 0x0, 0x0 },
	{ 0xa79b, 0x0, 0x0 },
	{ 0xa79d, 0x0, 0x0 },
	{ 0xa79f, 0x0, 0x0 },
	{ 0xa7a1, 0x0, 0x0 },
	{ 0xa7a3, 0x0, 0x0 },
	{ 0xa7a5, 0x0, 0x0 },
	{ 0xa7a7, 0x0, 0x0 },
	{ 0xa7a9, 0x0, 0x0 },
	{ 0x266, 0x0, 0x0 },
	{ 0x25c, 0x0, 0x0 },
	{ 0x261, 0x0, 0x0 },
	{ 0x26c, 0x0, 0x0 },
	{ 0x26a, 0x0, 0x0 },
	{ 0x29e, 0x0, 0x0 },
	{ 0x287, 0x0, 0x0 },
	{ 0x29d, 0x0, 0x0 },
	{ 0xab53, 0x0, 0x0 },
	{ 0xa7b5, 0x0, 0x0 },
	{ 0xa7b7, 0x0, 0x0 },
	{ 0x13a0, 0x0, 0x0 },
	{ 0x66, 0x66, 0x0 },
	{ 0x66, 0x69, 0x0 },
	{ 0x66, 0x6c, 0x0 },
	{ 0x66, 0x66, 0x69 },
	{ 0x66, 0x66, 0x6c },
	{ 0x73, 0x74, 0x0 },
	{ 0x73, 0x74, 0x0 },
	{ 0x574, 0x576, 0x0 },
	{ 0x574, 0x565, 0x0 },
	{ 0x574, 0x56b, 0x0 },
	{ 0x57e, 0x576, 0x0 },
	{ 0x574, 0x56d, 0x0 },
	{ 0xff41, 0x0, 0x0 },
	{ 0x10428, 0x0, 0x0 },
	{ 0x104d8, 0x0, 0x0 },
	{ 0x10cc0, 0x0, 0x0 },
	{ 0x118c0, 0x0, 0x0 },
	{ 0x1e922, 0x0, 0x0 }
};

/* Double-wide characters */

struct interval width_table[] = {
	{ 0x1100, 0x115f },
	{ 0x231a, 0x231b },
	{ 0x2329, 0x232a },
	{ 0x23e9, 0x23ec },
	{ 0x23f0, 0x23f0 },
	{ 0x23f3, 0x23f3 },
	{ 0x25fd, 0x25fe },
	{ 0x2614, 0x2615 },
	{ 0x2648, 0x2653 },
	{ 0x267f, 0x267f },
	{ 0x2693, 0x2693 },
	{ 0x26a1, 0x26a1 },
	{ 0x26aa, 0x26ab },
	{ 0x26bd, 0x26be },
	{ 0x26c4, 0x26c5 },
	{ 0x26ce, 0x26ce },
	{ 0x26d4, 0x26d4 },
	{ 0x26ea, 0x26ea },
	{ 0x26f2, 0x26f3 },
	{ 0x26f5, 0x26f5 },
	{ 0x26fa, 0x26fa },
	{ 0x26fd, 0x26fd },
	{ 0x2705, 0x2705 },
	{ 0x270a, 0x270b },
	{ 0x2728, 0x2728 },
	{ 0x274c, 0x274c },
	{ 0x274e, 0x274e },
	{ 0x2753, 0x2755 },
	{ 0x2757, 0x2757 },
	{ 0x2795, 0x2797 },
	{ 0x27b0, 0x27b0 },
	{ 0x27bf, 0x27bf },
	{ 0x2b1b, 0x2b1c },
	{ 0x2b50, 0x2b50 },
	{ 0x2b55, 0x2b55 },
	{ 0x2e80, 0x2e99 },
	{ 0x2e9b, 0x2ef3 },
	{ 0x2f00, 0x2fd5 },
	{ 0x2ff0, 0x2ffb },
	{ 0x3000, 0x303e },
	{ 0x3041, 0x3096 },
	{ 0x3099, 0x30ff },
	{ 0x3105, 0x312d },
	{ 0x3131, 0x318e },
	{ 0x3190, 0x31ba },
	{ 0x31c0, 0x31e3 },
	{ 0x31f0, 0x321e },
	{ 0x3220, 0x3247 },
	{ 0x3250, 0x32fe },
	{ 0x3300, 0x4dbf },
	{ 0x4e00, 0xa48c },
	{ 0xa490, 0xa4c6 },
	{ 0xa960, 0xa97c },
	{ 0xac00, 0xd7a3 },
	{ 0xf900, 0xfaff },
	{ 0xfe10, 0xfe19 },
	{ 0xfe30, 0xfe52 },
	{ 0xfe54, 0xfe66 },
	{ 0xfe68, 0xfe6b },
	{ 0xff01, 0xff60 },
	{ 0xffe0, 0xffe6 },
	{ 0x16fe0, 0x16fe0 },
	{ 0x17000, 0x187ec },
	{ 0x18800, 0x18af2 },
	{ 0x1b000, 0x1b001 },
	{ 0x1f004, 0x1f004 },
	{ 0x1f0cf, 0x1f0cf },
	{ 0x1f18e, 0x1f18e },
	{ 0x1f191, 0x1f19a },
	{ 0x1f200, 0x1f202 },
	{ 0x1f210, 0x1f23b },
	{ 0x1f240, 0x1f248 },
	{ 0x1f250, 0x1f251 },
	{ 0x1f300, 0x1f320 },
	{ 0x1f32d, 0x1f335 },
	{ 0x1f337, 0x1f37c },
	{ 0x1f37e, 0x1f393 },
	{ 0x1f3a0, 0x1f3ca },
	{ 0x1f3cf, 0x1f3d3 },
	{ 0x1f3e0, 0x1f3f0 },
	{ 0x1f3f4, 0x1f3f4 },
	{ 0x1f3f8, 0x1f43e },
	{ 0x1f440, 0x1f440 },
	{ 0x1f442, 0x1f4fc },
	{ 0x1f4ff, 0x1f53d },
	{ 0x1f54b, 0x1f54e },
	{ 0x1f550, 0x1f567 },
	{ 0x1f57a, 0x1f57a },
	{ 0x1f595, 0x1f596 },
	{ 0x1f5a4, 0x1f5a4 },
	{ 0x1f5fb, 0x1f64f },
	{ 0x1f680, 0x1f6c5 },
	{ 0x1f6cc, 0x1f6cc },
	{ 0x1f6d0, 0x1f6d2 },
	{ 0x1f6eb, 0x1f6ec },
	{ 0x1f6f4, 0x1f6f6 },
	{ 0x1f910, 0x1f91e },
	{ 0x1f920, 0x1f927 },
	{ 0x1f930, 0x1f930 },
	{ 0x1f933, 0x1f93e },
	{ 0x1f940, 0x1f94b },
	{ 0x1f950, 0x1f95e },
	{ 0x1f980, 0x1f991 },
	{ 0x1f9c0, 0x1f9c0 },
	{ 0x20000, 0x2fffd },
	{ 0x30000, 0x3fffd },
	{ 0x0, 0x0 }
};
