/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.text.NumberFormat;
import java.util.Collection;
import net.sourceforge.stripes.validation.NumberTypeConverterSupport;
import net.sourceforge.stripes.validation.ScopedLocalizableError;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortTypeConverter
extends NumberTypeConverterSupport
implements TypeConverter<Short> {
    @Override
    public Short convert(String input, Class<? extends Short> targetType, Collection<ValidationError> errors) {
        Number number = this.parse(input, errors);
        Short retval = null;
        if (errors.size() == 0) {
            long output = number.longValue();
            if (output < -32768L || output > 32767L) {
                errors.add(new ScopedLocalizableError("converter.short", "outOfRange", (short)Short.MIN_VALUE, (short)Short.MAX_VALUE));
            } else {
                retval = new Short((short)output);
            }
        }
        return retval;
    }

    @Override
    protected NumberFormat[] getNumberFormats() {
        return new NumberFormat[]{NumberFormat.getIntegerInstance(this.getLocale())};
    }
}

