/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskTrackerAction;

class LaunchTaskAction
extends TaskTrackerAction {
    private Task task;

    public LaunchTaskAction() {
        super(TaskTrackerAction.ActionType.LAUNCH_TASK);
    }

    public LaunchTaskAction(Task task) {
        super(TaskTrackerAction.ActionType.LAUNCH_TASK);
        this.task = task;
    }

    public Task getTask() {
        return this.task;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.task.isMapTask());
        this.task.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        boolean isMapTask = in.readBoolean();
        this.task = isMapTask ? new MapTask() : new ReduceTask();
        this.task.readFields(in);
    }
}

