
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQColor.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QColor>
#include <QRgba64>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QColor

//  Constructor QColor::QColor()


static void _init_ctor_QColor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QColor> ();
}

static void _call_ctor_QColor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QColor *> (new QColor ());
}


//  Constructor QColor::QColor(Qt::GlobalColor color)


static void _init_ctor_QColor_1853 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("color");
  decl->add_arg<const qt_gsi::Converter<Qt::GlobalColor>::target_type & > (argspec_0);
  decl->set_return_new<QColor> ();
}

static void _call_ctor_QColor_1853 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::GlobalColor>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::GlobalColor>::target_type & >() (args, heap);
  ret.write<QColor *> (new QColor (qt_gsi::QtToCppAdaptor<Qt::GlobalColor>(arg1).cref()));
}


//  Constructor QColor::QColor(int r, int g, int b, int a)


static void _init_ctor_QColor_2744 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("g");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("b");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "255");
  decl->add_arg<int > (argspec_3);
  decl->set_return_new<QColor> ();
}

static void _call_ctor_QColor_2744 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (255, heap);
  ret.write<QColor *> (new QColor (arg1, arg2, arg3, arg4));
}


//  Constructor QColor::QColor(unsigned int rgb)


static void _init_ctor_QColor_1772 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rgb");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return_new<QColor> ();
}

static void _call_ctor_QColor_1772 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = gsi::arg_reader<unsigned int >() (args, heap);
  ret.write<QColor *> (new QColor (arg1));
}


//  Constructor QColor::QColor(QRgba64 rgba64)


static void _init_ctor_QColor_1003 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rgba64");
  decl->add_arg<QRgba64 > (argspec_0);
  decl->set_return_new<QColor> ();
}

static void _call_ctor_QColor_1003 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QRgba64 arg1 = gsi::arg_reader<QRgba64 >() (args, heap);
  ret.write<QColor *> (new QColor (arg1));
}


//  Constructor QColor::QColor(const char *aname)


static void _init_ctor_QColor_1731 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("aname");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return_new<QColor> ();
}

static void _call_ctor_QColor_1731 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<QColor *> (new QColor (arg1));
}


//  Constructor QColor::QColor(QColor::Spec spec)


static void _init_ctor_QColor_1539 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spec");
  decl->add_arg<const qt_gsi::Converter<QColor::Spec>::target_type & > (argspec_0);
  decl->set_return_new<QColor> ();
}

static void _call_ctor_QColor_1539 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QColor::Spec>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QColor::Spec>::target_type & >() (args, heap);
  ret.write<QColor *> (new QColor (qt_gsi::QtToCppAdaptor<QColor::Spec>(arg1).cref()));
}


//  Constructor QColor::QColor(const QColor &color)


static void _init_ctor_QColor_1905 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("color");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return_new<QColor> ();
}

static void _call_ctor_QColor_1905 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QColor &arg1 = gsi::arg_reader<const QColor & >() (args, heap);
  ret.write<QColor *> (new QColor (arg1));
}


// int QColor::alpha()


static void _init_f_alpha_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_alpha_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColor *)cls)->alpha ());
}


// double QColor::alphaF()


static void _init_f_alphaF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_alphaF_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QColor *)cls)->alphaF ());
}


// int QColor::black()


static void _init_f_black_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_black_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColor *)cls)->black ());
}


// double QColor::blackF()


static void _init_f_blackF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_blackF_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QColor *)cls)->blackF ());
}


// int QColor::blue()


static void _init_f_blue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_blue_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColor *)cls)->blue ());
}


// double QColor::blueF()


static void _init_f_blueF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_blueF_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QColor *)cls)->blueF ());
}


// QColor QColor::convertTo(QColor::Spec colorSpec)


static void _init_f_convertTo_c1539 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("colorSpec");
  decl->add_arg<const qt_gsi::Converter<QColor::Spec>::target_type & > (argspec_0);
  decl->set_return<QColor > ();
}

static void _call_f_convertTo_c1539 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QColor::Spec>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QColor::Spec>::target_type & >() (args, heap);
  ret.write<QColor > ((QColor)((QColor *)cls)->convertTo (qt_gsi::QtToCppAdaptor<QColor::Spec>(arg1).cref()));
}


// int QColor::cyan()


static void _init_f_cyan_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_cyan_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColor *)cls)->cyan ());
}


// double QColor::cyanF()


static void _init_f_cyanF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_cyanF_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QColor *)cls)->cyanF ());
}


// QColor QColor::dark(int f)


static void _init_f_dark_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f", true, "200");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QColor > ();
}

static void _call_f_dark_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (200, heap);
  ret.write<QColor > ((QColor)((QColor *)cls)->dark (arg1));
}


// QColor QColor::darker(int f)


static void _init_f_darker_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f", true, "200");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QColor > ();
}

static void _call_f_darker_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (200, heap);
  ret.write<QColor > ((QColor)((QColor *)cls)->darker (arg1));
}


// void QColor::getCmyk(int *c, int *m, int *y, int *k, int *a)


static void _init_f_getCmyk_4333 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<int * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("m");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("k");
  decl->add_arg<int * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("a", true, "nullptr");
  decl->add_arg<int * > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_getCmyk_4333 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int *arg1 = gsi::arg_reader<int * >() (args, heap);
  int *arg2 = gsi::arg_reader<int * >() (args, heap);
  int *arg3 = gsi::arg_reader<int * >() (args, heap);
  int *arg4 = gsi::arg_reader<int * >() (args, heap);
  int *arg5 = args ? gsi::arg_reader<int * >() (args, heap) : gsi::arg_maker<int * >() (nullptr, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->getCmyk (arg1, arg2, arg3, arg4, arg5);
}


// void QColor::getCmykF(double *c, double *m, double *y, double *k, double *a)


static void _init_f_getCmykF_5853 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("m");
  decl->add_arg<double * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("k");
  decl->add_arg<double * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("a", true, "nullptr");
  decl->add_arg<double * > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_getCmykF_5853 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double *arg1 = gsi::arg_reader<double * >() (args, heap);
  double *arg2 = gsi::arg_reader<double * >() (args, heap);
  double *arg3 = gsi::arg_reader<double * >() (args, heap);
  double *arg4 = gsi::arg_reader<double * >() (args, heap);
  double *arg5 = args ? gsi::arg_reader<double * >() (args, heap) : gsi::arg_maker<double * >() (nullptr, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->getCmykF (arg1, arg2, arg3, arg4, arg5);
}


// void QColor::getHsl(int *h, int *s, int *l, int *a)


static void _init_f_getHsl_c3488 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<int * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("s");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("l");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "nullptr");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_getHsl_c3488 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int *arg1 = gsi::arg_reader<int * >() (args, heap);
  int *arg2 = gsi::arg_reader<int * >() (args, heap);
  int *arg3 = gsi::arg_reader<int * >() (args, heap);
  int *arg4 = args ? gsi::arg_reader<int * >() (args, heap) : gsi::arg_maker<int * >() (nullptr, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->getHsl (arg1, arg2, arg3, arg4);
}


// void QColor::getHslF(double *h, double *s, double *l, double *a)


static void _init_f_getHslF_c4704 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("s");
  decl->add_arg<double * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("l");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "nullptr");
  decl->add_arg<double * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_getHslF_c4704 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double *arg1 = gsi::arg_reader<double * >() (args, heap);
  double *arg2 = gsi::arg_reader<double * >() (args, heap);
  double *arg3 = gsi::arg_reader<double * >() (args, heap);
  double *arg4 = args ? gsi::arg_reader<double * >() (args, heap) : gsi::arg_maker<double * >() (nullptr, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->getHslF (arg1, arg2, arg3, arg4);
}


// void QColor::getHsv(int *h, int *s, int *v, int *a)


static void _init_f_getHsv_c3488 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<int * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("s");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("v");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "nullptr");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_getHsv_c3488 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int *arg1 = gsi::arg_reader<int * >() (args, heap);
  int *arg2 = gsi::arg_reader<int * >() (args, heap);
  int *arg3 = gsi::arg_reader<int * >() (args, heap);
  int *arg4 = args ? gsi::arg_reader<int * >() (args, heap) : gsi::arg_maker<int * >() (nullptr, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->getHsv (arg1, arg2, arg3, arg4);
}


// void QColor::getHsvF(double *h, double *s, double *v, double *a)


static void _init_f_getHsvF_c4704 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("s");
  decl->add_arg<double * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("v");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "nullptr");
  decl->add_arg<double * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_getHsvF_c4704 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double *arg1 = gsi::arg_reader<double * >() (args, heap);
  double *arg2 = gsi::arg_reader<double * >() (args, heap);
  double *arg3 = gsi::arg_reader<double * >() (args, heap);
  double *arg4 = args ? gsi::arg_reader<double * >() (args, heap) : gsi::arg_maker<double * >() (nullptr, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->getHsvF (arg1, arg2, arg3, arg4);
}


// void QColor::getRgb(int *r, int *g, int *b, int *a)


static void _init_f_getRgb_c3488 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<int * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("g");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("b");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "nullptr");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_getRgb_c3488 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int *arg1 = gsi::arg_reader<int * >() (args, heap);
  int *arg2 = gsi::arg_reader<int * >() (args, heap);
  int *arg3 = gsi::arg_reader<int * >() (args, heap);
  int *arg4 = args ? gsi::arg_reader<int * >() (args, heap) : gsi::arg_maker<int * >() (nullptr, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->getRgb (arg1, arg2, arg3, arg4);
}


// void QColor::getRgbF(double *r, double *g, double *b, double *a)


static void _init_f_getRgbF_c4704 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("g");
  decl->add_arg<double * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("b");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "nullptr");
  decl->add_arg<double * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_getRgbF_c4704 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double *arg1 = gsi::arg_reader<double * >() (args, heap);
  double *arg2 = gsi::arg_reader<double * >() (args, heap);
  double *arg3 = gsi::arg_reader<double * >() (args, heap);
  double *arg4 = args ? gsi::arg_reader<double * >() (args, heap) : gsi::arg_maker<double * >() (nullptr, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->getRgbF (arg1, arg2, arg3, arg4);
}


// int QColor::green()


static void _init_f_green_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_green_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColor *)cls)->green ());
}


// double QColor::greenF()


static void _init_f_greenF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_greenF_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QColor *)cls)->greenF ());
}


// int QColor::hslHue()


static void _init_f_hslHue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_hslHue_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColor *)cls)->hslHue ());
}


// double QColor::hslHueF()


static void _init_f_hslHueF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_hslHueF_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QColor *)cls)->hslHueF ());
}


// int QColor::hslSaturation()


static void _init_f_hslSaturation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_hslSaturation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColor *)cls)->hslSaturation ());
}


// double QColor::hslSaturationF()


static void _init_f_hslSaturationF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_hslSaturationF_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QColor *)cls)->hslSaturationF ());
}


// int QColor::hsvHue()


static void _init_f_hsvHue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_hsvHue_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColor *)cls)->hsvHue ());
}


// double QColor::hsvHueF()


static void _init_f_hsvHueF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_hsvHueF_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QColor *)cls)->hsvHueF ());
}


// int QColor::hsvSaturation()


static void _init_f_hsvSaturation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_hsvSaturation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColor *)cls)->hsvSaturation ());
}


// double QColor::hsvSaturationF()


static void _init_f_hsvSaturationF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_hsvSaturationF_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QColor *)cls)->hsvSaturationF ());
}


// int QColor::hue()


static void _init_f_hue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_hue_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColor *)cls)->hue ());
}


// double QColor::hueF()


static void _init_f_hueF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_hueF_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QColor *)cls)->hueF ());
}


// bool QColor::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QColor *)cls)->isValid ());
}


// QColor QColor::light(int f)


static void _init_f_light_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f", true, "150");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QColor > ();
}

static void _call_f_light_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (150, heap);
  ret.write<QColor > ((QColor)((QColor *)cls)->light (arg1));
}


// QColor QColor::lighter(int f)


static void _init_f_lighter_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f", true, "150");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QColor > ();
}

static void _call_f_lighter_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (150, heap);
  ret.write<QColor > ((QColor)((QColor *)cls)->lighter (arg1));
}


// int QColor::lightness()


static void _init_f_lightness_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_lightness_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColor *)cls)->lightness ());
}


// double QColor::lightnessF()


static void _init_f_lightnessF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_lightnessF_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QColor *)cls)->lightnessF ());
}


// int QColor::magenta()


static void _init_f_magenta_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_magenta_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColor *)cls)->magenta ());
}


// double QColor::magentaF()


static void _init_f_magentaF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_magentaF_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QColor *)cls)->magentaF ());
}


// QString QColor::name()


static void _init_f_name_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_name_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QColor *)cls)->name ());
}


// QString QColor::name(QColor::NameFormat format)


static void _init_f_name_c2146 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QColor::NameFormat>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_name_c2146 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QColor::NameFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QColor::NameFormat>::target_type & >() (args, heap);
  ret.write<QString > ((QString)((QColor *)cls)->name (qt_gsi::QtToCppAdaptor<QColor::NameFormat>(arg1).cref()));
}


// bool QColor::operator!=(const QColor &c)


static void _init_f_operator_excl__eq__c1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c1905 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QColor &arg1 = gsi::arg_reader<const QColor & >() (args, heap);
  ret.write<bool > ((bool)((QColor *)cls)->operator!= (arg1));
}


// QColor &QColor::operator=(const QColor &)


static void _init_f_operator_eq__1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<QColor & > ();
}

static void _call_f_operator_eq__1905 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QColor &arg1 = gsi::arg_reader<const QColor & >() (args, heap);
  ret.write<QColor & > ((QColor &)((QColor *)cls)->operator= (arg1));
}


// QColor &QColor::operator=(Qt::GlobalColor color)


static void _init_f_operator_eq__1853 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("color");
  decl->add_arg<const qt_gsi::Converter<Qt::GlobalColor>::target_type & > (argspec_0);
  decl->set_return<QColor & > ();
}

static void _call_f_operator_eq__1853 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::GlobalColor>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::GlobalColor>::target_type & >() (args, heap);
  ret.write<QColor & > ((QColor &)((QColor *)cls)->operator= (qt_gsi::QtToCppAdaptor<Qt::GlobalColor>(arg1).cref()));
}


// bool QColor::operator==(const QColor &c)


static void _init_f_operator_eq__eq__c1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c1905 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QColor &arg1 = gsi::arg_reader<const QColor & >() (args, heap);
  ret.write<bool > ((bool)((QColor *)cls)->operator== (arg1));
}


// int QColor::red()


static void _init_f_red_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_red_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColor *)cls)->red ());
}


// double QColor::redF()


static void _init_f_redF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_redF_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QColor *)cls)->redF ());
}


// unsigned int QColor::rgb()


static void _init_f_rgb_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_f_rgb_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<unsigned int > ((unsigned int)((QColor *)cls)->rgb ());
}


// unsigned int QColor::rgba()


static void _init_f_rgba_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_f_rgba_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<unsigned int > ((unsigned int)((QColor *)cls)->rgba ());
}


// QRgba64 QColor::rgba64()


static void _init_f_rgba64_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRgba64 > ();
}

static void _call_f_rgba64_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRgba64 > ((QRgba64)((QColor *)cls)->rgba64 ());
}


// int QColor::saturation()


static void _init_f_saturation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_saturation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColor *)cls)->saturation ());
}


// double QColor::saturationF()


static void _init_f_saturationF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_saturationF_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QColor *)cls)->saturationF ());
}


// void QColor::setAlpha(int alpha)


static void _init_f_setAlpha_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("alpha");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAlpha_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setAlpha (arg1);
}


// void QColor::setAlphaF(double alpha)


static void _init_f_setAlphaF_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("alpha");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAlphaF_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setAlphaF (arg1);
}


// void QColor::setBlue(int blue)


static void _init_f_setBlue_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("blue");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBlue_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setBlue (arg1);
}


// void QColor::setBlueF(double blue)


static void _init_f_setBlueF_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("blue");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBlueF_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setBlueF (arg1);
}


// void QColor::setCmyk(int c, int m, int y, int k, int a)


static void _init_f_setCmyk_3403 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("m");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("k");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("a", true, "255");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_setCmyk_3403 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  int arg5 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (255, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setCmyk (arg1, arg2, arg3, arg4, arg5);
}


// void QColor::setCmykF(double c, double m, double y, double k, double a)


static void _init_f_setCmykF_4923 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("m");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("k");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("a", true, "1.0");
  decl->add_arg<double > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_setCmykF_4923 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  double arg5 = args ? gsi::arg_reader<double >() (args, heap) : gsi::arg_maker<double >() (1.0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setCmykF (arg1, arg2, arg3, arg4, arg5);
}


// void QColor::setGreen(int green)


static void _init_f_setGreen_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("green");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGreen_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setGreen (arg1);
}


// void QColor::setGreenF(double green)


static void _init_f_setGreenF_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("green");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGreenF_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setGreenF (arg1);
}


// void QColor::setHsl(int h, int s, int l, int a)


static void _init_f_setHsl_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("s");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("l");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "255");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setHsl_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (255, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setHsl (arg1, arg2, arg3, arg4);
}


// void QColor::setHslF(double h, double s, double l, double a)


static void _init_f_setHslF_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("s");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("l");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "1.0");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setHslF_3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = args ? gsi::arg_reader<double >() (args, heap) : gsi::arg_maker<double >() (1.0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setHslF (arg1, arg2, arg3, arg4);
}


// void QColor::setHsv(int h, int s, int v, int a)


static void _init_f_setHsv_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("s");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("v");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "255");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setHsv_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (255, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setHsv (arg1, arg2, arg3, arg4);
}


// void QColor::setHsvF(double h, double s, double v, double a)


static void _init_f_setHsvF_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("s");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("v");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "1.0");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setHsvF_3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = args ? gsi::arg_reader<double >() (args, heap) : gsi::arg_maker<double >() (1.0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setHsvF (arg1, arg2, arg3, arg4);
}


// void QColor::setNamedColor(const QString &name)


static void _init_f_setNamedColor_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNamedColor_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setNamedColor (arg1);
}


// void QColor::setRed(int red)


static void _init_f_setRed_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("red");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRed_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setRed (arg1);
}


// void QColor::setRedF(double red)


static void _init_f_setRedF_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("red");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRedF_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setRedF (arg1);
}


// void QColor::setRgb(int r, int g, int b, int a)


static void _init_f_setRgb_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("g");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("b");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "255");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setRgb_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (255, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setRgb (arg1, arg2, arg3, arg4);
}


// void QColor::setRgb(unsigned int rgb)


static void _init_f_setRgb_1772 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rgb");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRgb_1772 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = gsi::arg_reader<unsigned int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setRgb (arg1);
}


// void QColor::setRgbF(double r, double g, double b, double a)


static void _init_f_setRgbF_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("g");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("b");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "1.0");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setRgbF_3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = args ? gsi::arg_reader<double >() (args, heap) : gsi::arg_maker<double >() (1.0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setRgbF (arg1, arg2, arg3, arg4);
}


// void QColor::setRgba(unsigned int rgba)


static void _init_f_setRgba_1772 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rgba");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRgba_1772 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = gsi::arg_reader<unsigned int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setRgba (arg1);
}


// void QColor::setRgba64(QRgba64 rgba)


static void _init_f_setRgba64_1003 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rgba");
  decl->add_arg<QRgba64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRgba64_1003 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QRgba64 arg1 = gsi::arg_reader<QRgba64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColor *)cls)->setRgba64 (arg1);
}


// QColor::Spec QColor::spec()


static void _init_f_spec_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QColor::Spec>::target_type > ();
}

static void _call_f_spec_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QColor::Spec>::target_type > ((qt_gsi::Converter<QColor::Spec>::target_type)qt_gsi::CppToQtAdaptor<QColor::Spec>(((QColor *)cls)->spec ()));
}


// QColor QColor::toCmyk()


static void _init_f_toCmyk_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QColor > ();
}

static void _call_f_toCmyk_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QColor > ((QColor)((QColor *)cls)->toCmyk ());
}


// QColor QColor::toHsl()


static void _init_f_toHsl_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QColor > ();
}

static void _call_f_toHsl_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QColor > ((QColor)((QColor *)cls)->toHsl ());
}


// QColor QColor::toHsv()


static void _init_f_toHsv_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QColor > ();
}

static void _call_f_toHsv_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QColor > ((QColor)((QColor *)cls)->toHsv ());
}


// QColor QColor::toRgb()


static void _init_f_toRgb_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QColor > ();
}

static void _call_f_toRgb_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QColor > ((QColor)((QColor *)cls)->toRgb ());
}


// int QColor::value()


static void _init_f_value_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_value_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColor *)cls)->value ());
}


// double QColor::valueF()


static void _init_f_valueF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_valueF_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QColor *)cls)->valueF ());
}


// int QColor::yellow()


static void _init_f_yellow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_yellow_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColor *)cls)->yellow ());
}


// double QColor::yellowF()


static void _init_f_yellowF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_yellowF_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QColor *)cls)->yellowF ());
}


// static QStringList QColor::colorNames()


static void _init_f_colorNames_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_colorNames_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)QColor::colorNames ());
}


// static QColor QColor::fromCmyk(int c, int m, int y, int k, int a)


static void _init_f_fromCmyk_3403 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("m");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("k");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("a", true, "255");
  decl->add_arg<int > (argspec_4);
  decl->set_return<QColor > ();
}

static void _call_f_fromCmyk_3403 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  int arg5 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (255, heap);
  ret.write<QColor > ((QColor)QColor::fromCmyk (arg1, arg2, arg3, arg4, arg5));
}


// static QColor QColor::fromCmykF(double c, double m, double y, double k, double a)


static void _init_f_fromCmykF_4923 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("m");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("k");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("a", true, "1.0");
  decl->add_arg<double > (argspec_4);
  decl->set_return<QColor > ();
}

static void _call_f_fromCmykF_4923 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  double arg5 = args ? gsi::arg_reader<double >() (args, heap) : gsi::arg_maker<double >() (1.0, heap);
  ret.write<QColor > ((QColor)QColor::fromCmykF (arg1, arg2, arg3, arg4, arg5));
}


// static QColor QColor::fromHsl(int h, int s, int l, int a)


static void _init_f_fromHsl_2744 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("s");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("l");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "255");
  decl->add_arg<int > (argspec_3);
  decl->set_return<QColor > ();
}

static void _call_f_fromHsl_2744 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (255, heap);
  ret.write<QColor > ((QColor)QColor::fromHsl (arg1, arg2, arg3, arg4));
}


// static QColor QColor::fromHslF(double h, double s, double l, double a)


static void _init_f_fromHslF_3960 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("s");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("l");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "1.0");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QColor > ();
}

static void _call_f_fromHslF_3960 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = args ? gsi::arg_reader<double >() (args, heap) : gsi::arg_maker<double >() (1.0, heap);
  ret.write<QColor > ((QColor)QColor::fromHslF (arg1, arg2, arg3, arg4));
}


// static QColor QColor::fromHsv(int h, int s, int v, int a)


static void _init_f_fromHsv_2744 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("s");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("v");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "255");
  decl->add_arg<int > (argspec_3);
  decl->set_return<QColor > ();
}

static void _call_f_fromHsv_2744 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (255, heap);
  ret.write<QColor > ((QColor)QColor::fromHsv (arg1, arg2, arg3, arg4));
}


// static QColor QColor::fromHsvF(double h, double s, double v, double a)


static void _init_f_fromHsvF_3960 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("s");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("v");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "1.0");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QColor > ();
}

static void _call_f_fromHsvF_3960 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = args ? gsi::arg_reader<double >() (args, heap) : gsi::arg_maker<double >() (1.0, heap);
  ret.write<QColor > ((QColor)QColor::fromHsvF (arg1, arg2, arg3, arg4));
}


// static QColor QColor::fromRgb(unsigned int rgb)


static void _init_f_fromRgb_1772 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rgb");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<QColor > ();
}

static void _call_f_fromRgb_1772 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = gsi::arg_reader<unsigned int >() (args, heap);
  ret.write<QColor > ((QColor)QColor::fromRgb (arg1));
}


// static QColor QColor::fromRgb(int r, int g, int b, int a)


static void _init_f_fromRgb_2744 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("g");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("b");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "255");
  decl->add_arg<int > (argspec_3);
  decl->set_return<QColor > ();
}

static void _call_f_fromRgb_2744 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (255, heap);
  ret.write<QColor > ((QColor)QColor::fromRgb (arg1, arg2, arg3, arg4));
}


// static QColor QColor::fromRgbF(double r, double g, double b, double a)


static void _init_f_fromRgbF_3960 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("g");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("b");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "1.0");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QColor > ();
}

static void _call_f_fromRgbF_3960 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = args ? gsi::arg_reader<double >() (args, heap) : gsi::arg_maker<double >() (1.0, heap);
  ret.write<QColor > ((QColor)QColor::fromRgbF (arg1, arg2, arg3, arg4));
}


// static QColor QColor::fromRgba(unsigned int rgba)


static void _init_f_fromRgba_1772 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rgba");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<QColor > ();
}

static void _call_f_fromRgba_1772 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = gsi::arg_reader<unsigned int >() (args, heap);
  ret.write<QColor > ((QColor)QColor::fromRgba (arg1));
}


// static QColor QColor::fromRgba64(unsigned short int r, unsigned short int g, unsigned short int b, unsigned short int a)


static void _init_f_fromRgba64_9580 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<unsigned short int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("g");
  decl->add_arg<unsigned short int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("b");
  decl->add_arg<unsigned short int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("a", true, "USHRT_MAX");
  decl->add_arg<unsigned short int > (argspec_3);
  decl->set_return<QColor > ();
}

static void _call_f_fromRgba64_9580 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned short int arg1 = gsi::arg_reader<unsigned short int >() (args, heap);
  unsigned short int arg2 = gsi::arg_reader<unsigned short int >() (args, heap);
  unsigned short int arg3 = gsi::arg_reader<unsigned short int >() (args, heap);
  unsigned short int arg4 = args ? gsi::arg_reader<unsigned short int >() (args, heap) : gsi::arg_maker<unsigned short int >() (USHRT_MAX, heap);
  ret.write<QColor > ((QColor)QColor::fromRgba64 (arg1, arg2, arg3, arg4));
}


// static QColor QColor::fromRgba64(QRgba64 rgba)


static void _init_f_fromRgba64_1003 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rgba");
  decl->add_arg<QRgba64 > (argspec_0);
  decl->set_return<QColor > ();
}

static void _call_f_fromRgba64_1003 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QRgba64 arg1 = gsi::arg_reader<QRgba64 >() (args, heap);
  ret.write<QColor > ((QColor)QColor::fromRgba64 (arg1));
}


// static bool QColor::isValidColor(const QString &name)


static void _init_f_isValidColor_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isValidColor_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)QColor::isValidColor (arg1));
}



namespace gsi
{

static gsi::Methods methods_QColor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QColor::QColor()\nThis method creates an object of class QColor.", &_init_ctor_QColor_0, &_call_ctor_QColor_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QColor::QColor(Qt::GlobalColor color)\nThis method creates an object of class QColor.", &_init_ctor_QColor_1853, &_call_ctor_QColor_1853);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QColor::QColor(int r, int g, int b, int a)\nThis method creates an object of class QColor.", &_init_ctor_QColor_2744, &_call_ctor_QColor_2744);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QColor::QColor(unsigned int rgb)\nThis method creates an object of class QColor.", &_init_ctor_QColor_1772, &_call_ctor_QColor_1772);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QColor::QColor(QRgba64 rgba64)\nThis method creates an object of class QColor.", &_init_ctor_QColor_1003, &_call_ctor_QColor_1003);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QColor::QColor(const char *aname)\nThis method creates an object of class QColor.", &_init_ctor_QColor_1731, &_call_ctor_QColor_1731);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QColor::QColor(QColor::Spec spec)\nThis method creates an object of class QColor.", &_init_ctor_QColor_1539, &_call_ctor_QColor_1539);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QColor::QColor(const QColor &color)\nThis method creates an object of class QColor.", &_init_ctor_QColor_1905, &_call_ctor_QColor_1905);
  methods += new qt_gsi::GenericMethod (":alpha", "@brief Method int QColor::alpha()\n", true, &_init_f_alpha_c0, &_call_f_alpha_c0);
  methods += new qt_gsi::GenericMethod (":alphaF", "@brief Method double QColor::alphaF()\n", true, &_init_f_alphaF_c0, &_call_f_alphaF_c0);
  methods += new qt_gsi::GenericMethod ("black", "@brief Method int QColor::black()\n", true, &_init_f_black_c0, &_call_f_black_c0);
  methods += new qt_gsi::GenericMethod ("blackF", "@brief Method double QColor::blackF()\n", true, &_init_f_blackF_c0, &_call_f_blackF_c0);
  methods += new qt_gsi::GenericMethod (":blue", "@brief Method int QColor::blue()\n", true, &_init_f_blue_c0, &_call_f_blue_c0);
  methods += new qt_gsi::GenericMethod (":blueF", "@brief Method double QColor::blueF()\n", true, &_init_f_blueF_c0, &_call_f_blueF_c0);
  methods += new qt_gsi::GenericMethod ("convertTo", "@brief Method QColor QColor::convertTo(QColor::Spec colorSpec)\n", true, &_init_f_convertTo_c1539, &_call_f_convertTo_c1539);
  methods += new qt_gsi::GenericMethod ("cyan", "@brief Method int QColor::cyan()\n", true, &_init_f_cyan_c0, &_call_f_cyan_c0);
  methods += new qt_gsi::GenericMethod ("cyanF", "@brief Method double QColor::cyanF()\n", true, &_init_f_cyanF_c0, &_call_f_cyanF_c0);
  methods += new qt_gsi::GenericMethod ("dark", "@brief Method QColor QColor::dark(int f)\n", true, &_init_f_dark_c767, &_call_f_dark_c767);
  methods += new qt_gsi::GenericMethod ("darker", "@brief Method QColor QColor::darker(int f)\n", true, &_init_f_darker_c767, &_call_f_darker_c767);
  methods += new qt_gsi::GenericMethod ("getCmyk", "@brief Method void QColor::getCmyk(int *c, int *m, int *y, int *k, int *a)\n", false, &_init_f_getCmyk_4333, &_call_f_getCmyk_4333);
  methods += new qt_gsi::GenericMethod ("getCmykF", "@brief Method void QColor::getCmykF(double *c, double *m, double *y, double *k, double *a)\n", false, &_init_f_getCmykF_5853, &_call_f_getCmykF_5853);
  methods += new qt_gsi::GenericMethod ("getHsl", "@brief Method void QColor::getHsl(int *h, int *s, int *l, int *a)\n", true, &_init_f_getHsl_c3488, &_call_f_getHsl_c3488);
  methods += new qt_gsi::GenericMethod ("getHslF", "@brief Method void QColor::getHslF(double *h, double *s, double *l, double *a)\n", true, &_init_f_getHslF_c4704, &_call_f_getHslF_c4704);
  methods += new qt_gsi::GenericMethod ("getHsv", "@brief Method void QColor::getHsv(int *h, int *s, int *v, int *a)\n", true, &_init_f_getHsv_c3488, &_call_f_getHsv_c3488);
  methods += new qt_gsi::GenericMethod ("getHsvF", "@brief Method void QColor::getHsvF(double *h, double *s, double *v, double *a)\n", true, &_init_f_getHsvF_c4704, &_call_f_getHsvF_c4704);
  methods += new qt_gsi::GenericMethod ("getRgb", "@brief Method void QColor::getRgb(int *r, int *g, int *b, int *a)\n", true, &_init_f_getRgb_c3488, &_call_f_getRgb_c3488);
  methods += new qt_gsi::GenericMethod ("getRgbF", "@brief Method void QColor::getRgbF(double *r, double *g, double *b, double *a)\n", true, &_init_f_getRgbF_c4704, &_call_f_getRgbF_c4704);
  methods += new qt_gsi::GenericMethod (":green", "@brief Method int QColor::green()\n", true, &_init_f_green_c0, &_call_f_green_c0);
  methods += new qt_gsi::GenericMethod (":greenF", "@brief Method double QColor::greenF()\n", true, &_init_f_greenF_c0, &_call_f_greenF_c0);
  methods += new qt_gsi::GenericMethod ("hslHue", "@brief Method int QColor::hslHue()\n", true, &_init_f_hslHue_c0, &_call_f_hslHue_c0);
  methods += new qt_gsi::GenericMethod ("hslHueF", "@brief Method double QColor::hslHueF()\n", true, &_init_f_hslHueF_c0, &_call_f_hslHueF_c0);
  methods += new qt_gsi::GenericMethod ("hslSaturation", "@brief Method int QColor::hslSaturation()\n", true, &_init_f_hslSaturation_c0, &_call_f_hslSaturation_c0);
  methods += new qt_gsi::GenericMethod ("hslSaturationF", "@brief Method double QColor::hslSaturationF()\n", true, &_init_f_hslSaturationF_c0, &_call_f_hslSaturationF_c0);
  methods += new qt_gsi::GenericMethod ("hsvHue", "@brief Method int QColor::hsvHue()\n", true, &_init_f_hsvHue_c0, &_call_f_hsvHue_c0);
  methods += new qt_gsi::GenericMethod ("hsvHueF", "@brief Method double QColor::hsvHueF()\n", true, &_init_f_hsvHueF_c0, &_call_f_hsvHueF_c0);
  methods += new qt_gsi::GenericMethod ("hsvSaturation", "@brief Method int QColor::hsvSaturation()\n", true, &_init_f_hsvSaturation_c0, &_call_f_hsvSaturation_c0);
  methods += new qt_gsi::GenericMethod ("hsvSaturationF", "@brief Method double QColor::hsvSaturationF()\n", true, &_init_f_hsvSaturationF_c0, &_call_f_hsvSaturationF_c0);
  methods += new qt_gsi::GenericMethod ("hue", "@brief Method int QColor::hue()\n", true, &_init_f_hue_c0, &_call_f_hue_c0);
  methods += new qt_gsi::GenericMethod ("hueF", "@brief Method double QColor::hueF()\n", true, &_init_f_hueF_c0, &_call_f_hueF_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QColor::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod ("light", "@brief Method QColor QColor::light(int f)\n", true, &_init_f_light_c767, &_call_f_light_c767);
  methods += new qt_gsi::GenericMethod ("lighter", "@brief Method QColor QColor::lighter(int f)\n", true, &_init_f_lighter_c767, &_call_f_lighter_c767);
  methods += new qt_gsi::GenericMethod ("lightness", "@brief Method int QColor::lightness()\n", true, &_init_f_lightness_c0, &_call_f_lightness_c0);
  methods += new qt_gsi::GenericMethod ("lightnessF", "@brief Method double QColor::lightnessF()\n", true, &_init_f_lightnessF_c0, &_call_f_lightnessF_c0);
  methods += new qt_gsi::GenericMethod ("magenta", "@brief Method int QColor::magenta()\n", true, &_init_f_magenta_c0, &_call_f_magenta_c0);
  methods += new qt_gsi::GenericMethod ("magentaF", "@brief Method double QColor::magentaF()\n", true, &_init_f_magentaF_c0, &_call_f_magentaF_c0);
  methods += new qt_gsi::GenericMethod ("name", "@brief Method QString QColor::name()\n", true, &_init_f_name_c0, &_call_f_name_c0);
  methods += new qt_gsi::GenericMethod ("name", "@brief Method QString QColor::name(QColor::NameFormat format)\n", true, &_init_f_name_c2146, &_call_f_name_c2146);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QColor::operator!=(const QColor &c)\n", true, &_init_f_operator_excl__eq__c1905, &_call_f_operator_excl__eq__c1905);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QColor &QColor::operator=(const QColor &)\n", false, &_init_f_operator_eq__1905, &_call_f_operator_eq__1905);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QColor &QColor::operator=(Qt::GlobalColor color)\n", false, &_init_f_operator_eq__1853, &_call_f_operator_eq__1853);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QColor::operator==(const QColor &c)\n", true, &_init_f_operator_eq__eq__c1905, &_call_f_operator_eq__eq__c1905);
  methods += new qt_gsi::GenericMethod (":red", "@brief Method int QColor::red()\n", true, &_init_f_red_c0, &_call_f_red_c0);
  methods += new qt_gsi::GenericMethod (":redF", "@brief Method double QColor::redF()\n", true, &_init_f_redF_c0, &_call_f_redF_c0);
  methods += new qt_gsi::GenericMethod (":rgb", "@brief Method unsigned int QColor::rgb()\n", true, &_init_f_rgb_c0, &_call_f_rgb_c0);
  methods += new qt_gsi::GenericMethod (":rgba", "@brief Method unsigned int QColor::rgba()\n", true, &_init_f_rgba_c0, &_call_f_rgba_c0);
  methods += new qt_gsi::GenericMethod (":rgba64", "@brief Method QRgba64 QColor::rgba64()\n", true, &_init_f_rgba64_c0, &_call_f_rgba64_c0);
  methods += new qt_gsi::GenericMethod ("saturation", "@brief Method int QColor::saturation()\n", true, &_init_f_saturation_c0, &_call_f_saturation_c0);
  methods += new qt_gsi::GenericMethod ("saturationF", "@brief Method double QColor::saturationF()\n", true, &_init_f_saturationF_c0, &_call_f_saturationF_c0);
  methods += new qt_gsi::GenericMethod ("setAlpha|alpha=", "@brief Method void QColor::setAlpha(int alpha)\n", false, &_init_f_setAlpha_767, &_call_f_setAlpha_767);
  methods += new qt_gsi::GenericMethod ("setAlphaF|alphaF=", "@brief Method void QColor::setAlphaF(double alpha)\n", false, &_init_f_setAlphaF_1071, &_call_f_setAlphaF_1071);
  methods += new qt_gsi::GenericMethod ("setBlue|blue=", "@brief Method void QColor::setBlue(int blue)\n", false, &_init_f_setBlue_767, &_call_f_setBlue_767);
  methods += new qt_gsi::GenericMethod ("setBlueF|blueF=", "@brief Method void QColor::setBlueF(double blue)\n", false, &_init_f_setBlueF_1071, &_call_f_setBlueF_1071);
  methods += new qt_gsi::GenericMethod ("setCmyk", "@brief Method void QColor::setCmyk(int c, int m, int y, int k, int a)\n", false, &_init_f_setCmyk_3403, &_call_f_setCmyk_3403);
  methods += new qt_gsi::GenericMethod ("setCmykF", "@brief Method void QColor::setCmykF(double c, double m, double y, double k, double a)\n", false, &_init_f_setCmykF_4923, &_call_f_setCmykF_4923);
  methods += new qt_gsi::GenericMethod ("setGreen|green=", "@brief Method void QColor::setGreen(int green)\n", false, &_init_f_setGreen_767, &_call_f_setGreen_767);
  methods += new qt_gsi::GenericMethod ("setGreenF|greenF=", "@brief Method void QColor::setGreenF(double green)\n", false, &_init_f_setGreenF_1071, &_call_f_setGreenF_1071);
  methods += new qt_gsi::GenericMethod ("setHsl", "@brief Method void QColor::setHsl(int h, int s, int l, int a)\n", false, &_init_f_setHsl_2744, &_call_f_setHsl_2744);
  methods += new qt_gsi::GenericMethod ("setHslF", "@brief Method void QColor::setHslF(double h, double s, double l, double a)\n", false, &_init_f_setHslF_3960, &_call_f_setHslF_3960);
  methods += new qt_gsi::GenericMethod ("setHsv", "@brief Method void QColor::setHsv(int h, int s, int v, int a)\n", false, &_init_f_setHsv_2744, &_call_f_setHsv_2744);
  methods += new qt_gsi::GenericMethod ("setHsvF", "@brief Method void QColor::setHsvF(double h, double s, double v, double a)\n", false, &_init_f_setHsvF_3960, &_call_f_setHsvF_3960);
  methods += new qt_gsi::GenericMethod ("setNamedColor", "@brief Method void QColor::setNamedColor(const QString &name)\n", false, &_init_f_setNamedColor_2025, &_call_f_setNamedColor_2025);
  methods += new qt_gsi::GenericMethod ("setRed|red=", "@brief Method void QColor::setRed(int red)\n", false, &_init_f_setRed_767, &_call_f_setRed_767);
  methods += new qt_gsi::GenericMethod ("setRedF|redF=", "@brief Method void QColor::setRedF(double red)\n", false, &_init_f_setRedF_1071, &_call_f_setRedF_1071);
  methods += new qt_gsi::GenericMethod ("setRgb", "@brief Method void QColor::setRgb(int r, int g, int b, int a)\n", false, &_init_f_setRgb_2744, &_call_f_setRgb_2744);
  methods += new qt_gsi::GenericMethod ("setRgb|rgb=", "@brief Method void QColor::setRgb(unsigned int rgb)\n", false, &_init_f_setRgb_1772, &_call_f_setRgb_1772);
  methods += new qt_gsi::GenericMethod ("setRgbF", "@brief Method void QColor::setRgbF(double r, double g, double b, double a)\n", false, &_init_f_setRgbF_3960, &_call_f_setRgbF_3960);
  methods += new qt_gsi::GenericMethod ("setRgba|rgba=", "@brief Method void QColor::setRgba(unsigned int rgba)\n", false, &_init_f_setRgba_1772, &_call_f_setRgba_1772);
  methods += new qt_gsi::GenericMethod ("setRgba64|rgba64=", "@brief Method void QColor::setRgba64(QRgba64 rgba)\n", false, &_init_f_setRgba64_1003, &_call_f_setRgba64_1003);
  methods += new qt_gsi::GenericMethod ("spec", "@brief Method QColor::Spec QColor::spec()\n", true, &_init_f_spec_c0, &_call_f_spec_c0);
  methods += new qt_gsi::GenericMethod ("toCmyk", "@brief Method QColor QColor::toCmyk()\n", true, &_init_f_toCmyk_c0, &_call_f_toCmyk_c0);
  methods += new qt_gsi::GenericMethod ("toHsl", "@brief Method QColor QColor::toHsl()\n", true, &_init_f_toHsl_c0, &_call_f_toHsl_c0);
  methods += new qt_gsi::GenericMethod ("toHsv", "@brief Method QColor QColor::toHsv()\n", true, &_init_f_toHsv_c0, &_call_f_toHsv_c0);
  methods += new qt_gsi::GenericMethod ("toRgb", "@brief Method QColor QColor::toRgb()\n", true, &_init_f_toRgb_c0, &_call_f_toRgb_c0);
  methods += new qt_gsi::GenericMethod ("value", "@brief Method int QColor::value()\n", true, &_init_f_value_c0, &_call_f_value_c0);
  methods += new qt_gsi::GenericMethod ("valueF", "@brief Method double QColor::valueF()\n", true, &_init_f_valueF_c0, &_call_f_valueF_c0);
  methods += new qt_gsi::GenericMethod ("yellow", "@brief Method int QColor::yellow()\n", true, &_init_f_yellow_c0, &_call_f_yellow_c0);
  methods += new qt_gsi::GenericMethod ("yellowF", "@brief Method double QColor::yellowF()\n", true, &_init_f_yellowF_c0, &_call_f_yellowF_c0);
  methods += new qt_gsi::GenericStaticMethod ("colorNames", "@brief Static method QStringList QColor::colorNames()\nThis method is static and can be called without an instance.", &_init_f_colorNames_0, &_call_f_colorNames_0);
  methods += new qt_gsi::GenericStaticMethod ("fromCmyk", "@brief Static method QColor QColor::fromCmyk(int c, int m, int y, int k, int a)\nThis method is static and can be called without an instance.", &_init_f_fromCmyk_3403, &_call_f_fromCmyk_3403);
  methods += new qt_gsi::GenericStaticMethod ("fromCmykF", "@brief Static method QColor QColor::fromCmykF(double c, double m, double y, double k, double a)\nThis method is static and can be called without an instance.", &_init_f_fromCmykF_4923, &_call_f_fromCmykF_4923);
  methods += new qt_gsi::GenericStaticMethod ("fromHsl", "@brief Static method QColor QColor::fromHsl(int h, int s, int l, int a)\nThis method is static and can be called without an instance.", &_init_f_fromHsl_2744, &_call_f_fromHsl_2744);
  methods += new qt_gsi::GenericStaticMethod ("fromHslF", "@brief Static method QColor QColor::fromHslF(double h, double s, double l, double a)\nThis method is static and can be called without an instance.", &_init_f_fromHslF_3960, &_call_f_fromHslF_3960);
  methods += new qt_gsi::GenericStaticMethod ("fromHsv", "@brief Static method QColor QColor::fromHsv(int h, int s, int v, int a)\nThis method is static and can be called without an instance.", &_init_f_fromHsv_2744, &_call_f_fromHsv_2744);
  methods += new qt_gsi::GenericStaticMethod ("fromHsvF", "@brief Static method QColor QColor::fromHsvF(double h, double s, double v, double a)\nThis method is static and can be called without an instance.", &_init_f_fromHsvF_3960, &_call_f_fromHsvF_3960);
  methods += new qt_gsi::GenericStaticMethod ("fromRgb", "@brief Static method QColor QColor::fromRgb(unsigned int rgb)\nThis method is static and can be called without an instance.", &_init_f_fromRgb_1772, &_call_f_fromRgb_1772);
  methods += new qt_gsi::GenericStaticMethod ("fromRgb", "@brief Static method QColor QColor::fromRgb(int r, int g, int b, int a)\nThis method is static and can be called without an instance.", &_init_f_fromRgb_2744, &_call_f_fromRgb_2744);
  methods += new qt_gsi::GenericStaticMethod ("fromRgbF", "@brief Static method QColor QColor::fromRgbF(double r, double g, double b, double a)\nThis method is static and can be called without an instance.", &_init_f_fromRgbF_3960, &_call_f_fromRgbF_3960);
  methods += new qt_gsi::GenericStaticMethod ("fromRgba", "@brief Static method QColor QColor::fromRgba(unsigned int rgba)\nThis method is static and can be called without an instance.", &_init_f_fromRgba_1772, &_call_f_fromRgba_1772);
  methods += new qt_gsi::GenericStaticMethod ("fromRgba64", "@brief Static method QColor QColor::fromRgba64(unsigned short int r, unsigned short int g, unsigned short int b, unsigned short int a)\nThis method is static and can be called without an instance.", &_init_f_fromRgba64_9580, &_call_f_fromRgba64_9580);
  methods += new qt_gsi::GenericStaticMethod ("fromRgba64", "@brief Static method QColor QColor::fromRgba64(QRgba64 rgba)\nThis method is static and can be called without an instance.", &_init_f_fromRgba64_1003, &_call_f_fromRgba64_1003);
  methods += new qt_gsi::GenericStaticMethod ("isValidColor?", "@brief Static method bool QColor::isValidColor(const QString &name)\nThis method is static and can be called without an instance.", &_init_f_isValidColor_2025, &_call_f_isValidColor_2025);
  return methods;
}

gsi::Class<QColor> decl_QColor ("QtGui", "QColor",
  methods_QColor (),
  "@qt\n@brief Binding of QColor");


GSI_QTGUI_PUBLIC gsi::Class<QColor> &qtdecl_QColor () { return decl_QColor; }

}


//  Implementation of the enum wrapper class for QColor::NameFormat
namespace qt_gsi
{

static gsi::Enum<QColor::NameFormat> decl_QColor_NameFormat_Enum ("QtGui", "QColor_NameFormat",
    gsi::enum_const ("HexRgb", QColor::HexRgb, "@brief Enum constant QColor::HexRgb") +
    gsi::enum_const ("HexArgb", QColor::HexArgb, "@brief Enum constant QColor::HexArgb"),
  "@qt\n@brief This class represents the QColor::NameFormat enum");

static gsi::QFlagsClass<QColor::NameFormat > decl_QColor_NameFormat_Enums ("QtGui", "QColor_QFlags_NameFormat",
  "@qt\n@brief This class represents the QFlags<QColor::NameFormat> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QColor> inject_QColor_NameFormat_Enum_in_parent (decl_QColor_NameFormat_Enum.defs ());
static gsi::ClassExt<QColor> decl_QColor_NameFormat_Enum_as_child (decl_QColor_NameFormat_Enum, "NameFormat");
static gsi::ClassExt<QColor> decl_QColor_NameFormat_Enums_as_child (decl_QColor_NameFormat_Enums, "QFlags_NameFormat");

}


//  Implementation of the enum wrapper class for QColor::Spec
namespace qt_gsi
{

static gsi::Enum<QColor::Spec> decl_QColor_Spec_Enum ("QtGui", "QColor_Spec",
    gsi::enum_const ("Invalid", QColor::Invalid, "@brief Enum constant QColor::Invalid") +
    gsi::enum_const ("Rgb", QColor::Rgb, "@brief Enum constant QColor::Rgb") +
    gsi::enum_const ("Hsv", QColor::Hsv, "@brief Enum constant QColor::Hsv") +
    gsi::enum_const ("Cmyk", QColor::Cmyk, "@brief Enum constant QColor::Cmyk") +
    gsi::enum_const ("Hsl", QColor::Hsl, "@brief Enum constant QColor::Hsl"),
  "@qt\n@brief This class represents the QColor::Spec enum");

static gsi::QFlagsClass<QColor::Spec > decl_QColor_Spec_Enums ("QtGui", "QColor_QFlags_Spec",
  "@qt\n@brief This class represents the QFlags<QColor::Spec> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QColor> inject_QColor_Spec_Enum_in_parent (decl_QColor_Spec_Enum.defs ());
static gsi::ClassExt<QColor> decl_QColor_Spec_Enum_as_child (decl_QColor_Spec_Enum, "Spec");
static gsi::ClassExt<QColor> decl_QColor_Spec_Enums_as_child (decl_QColor_Spec_Enums, "QFlags_Spec");

}

