; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve %s -o - | FileCheck %s

; This test was getting the offset of a store's pointer info incorrect, leading to the
; incorrect aliasing info an the store moving past a dependant load.

define arm_aapcs_vfpcc double @zero(double %a, double %b, double %c) {
; CHECK-LABEL: zero:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    .pad #8
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    vmov.f32 s16, s2
; CHECK-NEXT:    vmov.f32 s18, s0
; CHECK-NEXT:    vmov.f32 s17, s3
; CHECK-NEXT:    vmov.f32 s19, s1
; CHECK-NEXT:    bl sqrt
; CHECK-NEXT:    vmov r2, r3, d8
; CHECK-NEXT:    vmov r0, r1, d0
; CHECK-NEXT:    bl __aeabi_dadd
; CHECK-NEXT:    str r1, [sp, #4]
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    ldrb.w r0, [sp, #7]
; CHECK-NEXT:    eor r0, r0, #128
; CHECK-NEXT:    strb.w r0, [sp, #7]
; CHECK-NEXT:    vmov r0, r1, d9
; CHECK-NEXT:    mov r2, r0
; CHECK-NEXT:    mov r3, r1
; CHECK-NEXT:    bl __aeabi_dadd
; CHECK-NEXT:    mov r3, r1
; CHECK-NEXT:    ldr r1, [sp, #4]
; CHECK-NEXT:    mov r2, r0
; CHECK-NEXT:    mov r0, r4
; CHECK-NEXT:    bl __aeabi_ddiv
; CHECK-NEXT:    vmov d0, r0, r1
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    pop {r4, pc}
entry:
  %call = tail call nnan nsz arm_aapcs_vfpcc double @sqrt(double %a)
  %0 = fadd nnan nsz double %call, %b
  %sub3 = fneg nnan nsz double %0
  %mul4 = fmul nnan nsz double %a, 2.000000e+00
  %div = fdiv nnan nsz double %sub3, %mul4
  ret double %div
}

declare arm_aapcs_vfpcc double @sqrt(double)
