; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

define i32 @xor_domcondition(i32 %x, i32 %y) {
; CHECK-LABEL: @xor_domcondition(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_END:%.*]]
; CHECK:       cond.true:
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    ret i32 0
;
entry:
  %cmp = icmp eq i32 %x, %y
  br i1 %cmp, label %cond.true, label %cond.end

cond.true:
  %xor = xor i32 %x, %y
  br label %cond.end

cond.end:
  %cond = phi i32 [ %xor, %cond.true ], [ 0, %entry ]
  ret i32 %cond
}

define i32 @sub_domcondition(i32 %x, i32 %y) {
; CHECK-LABEL: @sub_domcondition(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_END:%.*]]
; CHECK:       cond.true:
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    ret i32 0
;
entry:
  %cmp = icmp eq i32 %x, %y
  br i1 %cmp, label %cond.true, label %cond.end

cond.true:
  %sub = sub i32 %x, %y
  br label %cond.end

cond.end:
  %cond = phi i32 [ %sub, %cond.true ], [ 0, %entry ]
  ret i32 %cond
}

define i32 @udiv_domcondition(i32 %x, i32 %y) {
; CHECK-LABEL: @udiv_domcondition(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_END:%.*]]
; CHECK:       cond.true:
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[COND]]
;
entry:
  %cmp = icmp eq i32 %x, %y
  br i1 %cmp, label %cond.true, label %cond.end

cond.true:
  %udiv = udiv i32 %x, %y
  br label %cond.end

cond.end:
  %cond = phi i32 [ %udiv, %cond.true ], [ 0, %entry ]
  ret i32 %cond
}

define i32 @sdiv_domcondition(i32 %x, i32 %y) {
; CHECK-LABEL: @sdiv_domcondition(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_END:%.*]]
; CHECK:       cond.true:
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[COND]]
;
entry:
  %cmp = icmp eq i32 %x, %y
  br i1 %cmp, label %cond.true, label %cond.end

cond.true:
  %sdiv = sdiv i32 %x, %y
  br label %cond.end

cond.end:
  %cond = phi i32 [ %sdiv, %cond.true ], [ 0, %entry ]
  ret i32 %cond
}

define i32 @urem_domcondition(i32 %x, i32 %y) {
; CHECK-LABEL: @urem_domcondition(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_END:%.*]]
; CHECK:       cond.true:
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    ret i32 0
;
entry:
  %cmp = icmp eq i32 %x, %y
  br i1 %cmp, label %cond.true, label %cond.end

cond.true:
  %urem = urem i32 %x, %y
  br label %cond.end

cond.end:
  %cond = phi i32 [ %urem, %cond.true ], [ 0, %entry ]
  ret i32 %cond
}

define i32 @srem_domcondition(i32 %x, i32 %y) {
; CHECK-LABEL: @srem_domcondition(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_END:%.*]]
; CHECK:       cond.true:
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    ret i32 0
;
entry:
  %cmp = icmp eq i32 %x, %y
  br i1 %cmp, label %cond.true, label %cond.end

cond.true:
  %srem = srem i32 %x, %y
  br label %cond.end

cond.end:
  %cond = phi i32 [ %srem, %cond.true ], [ 0, %entry ]
  ret i32 %cond
}

; TODO: %and can be one of %x, %y
define i32 @and_domcondition(i32 %x, i32 %y) {
; CHECK-LABEL: @and_domcondition(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_END:%.*]]
; CHECK:       cond.true:
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[COND:%.*]] = phi i32 [ [[Y]], [[COND_TRUE]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[COND]]
;
entry:
  %cmp = icmp eq i32 %x, %y
  br i1 %cmp, label %cond.true, label %cond.end

cond.true:
  %and = and i32 %x, %y
  br label %cond.end

cond.end:
  %cond = phi i32 [ %and, %cond.true ], [ 0, %entry ]
  ret i32 %cond
}

; TODO: %or can be one of %x, %y
define i32 @or_domcondition(i32 %x, i32 %y) {
; CHECK-LABEL: @or_domcondition(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_END:%.*]]
; CHECK:       cond.true:
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[COND:%.*]] = phi i32 [ [[Y]], [[COND_TRUE]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[COND]]
;
entry:
  %cmp = icmp eq i32 %x, %y
  br i1 %cmp, label %cond.true, label %cond.end

cond.true:
  %or = or i32 %x, %y
  br label %cond.end

cond.end:
  %cond = phi i32 [ %or, %cond.true ], [ 0, %entry ]
  ret i32 %cond
}

; negative test, dominate condtion is not eq
define i32 @xor_domcondition_negative(i32 %x, i32 %y) {
; CHECK-LABEL: @xor_domcondition_negative(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp uge i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_END:%.*]]
; CHECK:       cond.true:
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[X]], [[Y]]
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[COND:%.*]] = phi i32 [ [[XOR]], [[COND_TRUE]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[COND]]
;
entry:
  %cmp = icmp uge i32 %x, %y
  br i1 %cmp, label %cond.true, label %cond.end

cond.true:
  %xor = xor i32 %x, %y
  br label %cond.end

cond.end:
  %cond = phi i32 [ %xor, %cond.true ], [ 0, %entry ]
  ret i32 %cond
}
