<?php
/////////////////////////////////////////
// File Name : Validate_Attribute.php
// Creation Date : July 2007
// Description : After having chosen all the attributes in the table, the module gets and sets the value for each node.
//		   If there is no value for that attribute (even with heritage), "---" is set.
//
// Modifications : -
//
/////////////////////////////////////////////////////////////////////////

	unset( $new_tree );
	$tree = $_SESSION['tree'];
	
	// Information about the configuration
	if( isset( $_POST['configInfo'] ) ){
		$_SESSION['configInfo'] = array();
		$_SESSION['configInfo'] = $_POST['configInfo'];
	}
	$configInfo = $_SESSION['configInfo'];

	// Information about the hardware
	if( isset( $_POST['hardwareInfo'] ) ){
		$_SESSION['hardwareInfo'] = array();
		$_SESSION['hardwareInfo'] = $_POST['hardwareInfo'];
	}
	$hardwareInfo = $_SESSION['hardwareInfo'];

	// Information about the network
	if( isset( $_POST['networkInfo'] ) ){
		$_SESSION['networkInfo'] = array();
		$_SESSION['networkInfo'] = $_POST['networkInfo'];
	}
	$networkInfo = $_SESSION['networkInfo'];

	function getParentsConfig( $config_name, $node ){
		global $tree;
		$retour = "---";
		$id_parent = $node->id_parent;
		
		if( $id_parent <> $node->id && isset( $tree[ $id_parent ]->attributes[ "config" ][ $config_name ] ) ){
			$value = $tree[ $id_parent ]->attributes[ "config" ][ $config_name ];
			if( $value <> "" ){
				$retour = $value;
			}
		}
		return $retour;
	}
	
	function validate_attribute( $node_id ){
		global $tree, $configInfo, $hardwareInfo, $networkInfo;
		$useHeritage = $_SESSION['useHeritage'];
		$node = $tree[ $node_id ];
		$node->clearAttributes();
		if( $node->is_checked() ){
			foreach( $configInfo as $config ){
				$sql = "Select Value From attributesdef, attributes Where attributesdef.Name = '".$config."' AND attributes.Nodes_ID = '".$node->id."' AND attributesdef.ID = attributes.AttributesDef_ID";
				$query = pg_query( $sql );
				if( pg_num_rows( $query ) > 0 ){
					$row = pg_fetch_row( $query );
					$value = $row[0];
				} else {
					if( $useHeritage ){
						$value = getParentsConfig( $config, $node );
					} else {
						$value = "---";
					}
				}
				$node->attributes["config"][ $config ] = $value;
			}

			foreach( $hardwareInfo as $hardware ){
				if( !isset( $node->attributes["hardware"][ $hardware ] ) ){
					$sql = "Select HwValue From computershw Where HwKey = '".$hardware."' AND Nodes_ID = '".$node->id."'";
					$query = pg_query( $sql );
					if( $row = pg_fetch_row( $query ) ){
						$value = $row[0];
					} else {
						if( $useHeritage ){
							$value = getParentsConfig( $hardware, $node->id );
						} else {
							$value = "---";
						}
					}
					$node->attributes["hardware"][ $hardware ] = $value;
				}
			}

			foreach( $networkInfo as $network ){
				if( !isset( $node->attributes["network"][ $network ] ) ){
					$sql = "Select ".$network." From status Where id = '".$node->id."'";
					$query = pg_query( $sql );
					if( $row = pg_fetch_row( $query ) ){
						$value = $row[0];
					} else {
						if( $useHeritage ){
							$value = getParentsConfig( $network, $node->id );
						} else {
							$value = "---";
						}
					}
					$node->attributes[ "network" ][ $network ] = $value;
				}
			}
			$tree[ $node_id ] = $node;
			$childs = $node->returnChild( $tree );
			foreach( $childs as $child_id ){
				validate_attribute( $child_id );
			}
		}
	}

	validate_attribute( 0 );
	$_SESSION['tree'] = $tree;
?>