#!/usr/bin/env python

import string
from statlib import stats
import pprint
import sys

# Calculate statistics for gnuplot

tests = ["insert", "move", "nstree", "adjlst"]
#deep = [3,10]
deep = [10]

stats_data = {}

for t in tests:
    stats_data[t] = {}
    for d in deep:
        tag = "%s-d%s" % (t,d)
        stats_data[t][d] = {}
        samples = []
        f_path = "test-%s-n1000_d%s.out" % (t,d)
        print "processing %s" % f_path
        f = open(f_path,'r')
        for line in f.readlines():
            data = float(string.split(line.strip())[1]) * 1000
            samples.append(data)
        stats_data[t][d]["mean"] = stats.mean(samples)
        stats_data[t][d]["stdev"] = stats.stdev(samples)

pp = pprint.PrettyPrinter(indent=4)      
pp.pprint(stats_data)

def output(test_name):
    f = open("graph_stats_%s.out" % test_name, "w")
    keys = stats_data[test_name].keys()
    keys.sort()
    for k in keys:
        f.write("%s %f %f\n" % (k, stats_data[test_name][k]["mean"], stats_data[test_name][k]["stdev"]))
    f.close()

for t in tests:
    output(t)

