/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__COMMAND_HPP)
#include <Command.hpp>
#endif

namespace corelinux
{
   // Default constructor

   Command::Command( void )
      :
      AbstractCommand(),
      theReverseCommand( NULLPTR )
   {
      ;  // do nothing
   }

   // Copy constructor

   Command::Command( CommandCref aCommand )
      :
      AbstractCommand( aCommand ),
      theReverseCommand( aCommand.getReverseCommand() )
   {
      ;  // do nothing
   }

   // Initializing constructor

   Command::Command( AbstractCommandPtr aReverseCommand )
      :
      AbstractCommand(),
      theReverseCommand( aReverseCommand )
   {
      ;  // do nothing
   }

   // Destructor

   Command::~Command( void )
   {
      ;  // do nothing
   }

   // Assignment operator

   CommandRef Command::operator=( CommandCref )
   {
      return (*this);
   }

   // Equality operator

   bool Command::operator==( CommandCref aCommand ) const
   {
      return ( this == &aCommand );
   }

   // Get the reverse command

   AbstractCommandPtr   Command::getReverseCommand( void ) const
   {
      return theReverseCommand;
   }

   // Set the reverse command

   void  Command::setReverseCommand( AbstractCommandPtr aReverseCommand )
   {
      GUARD;
      theReverseCommand = aReverseCommand;
   }

   // Execute the reverse command

   void Command::executeReverse( void )
   {
      GUARD;
      if( theReverseCommand != NULLPTR )
      {
         theReverseCommand->execute();
      }
      else
      {
         ;  // do nothing
      }
   }
}


/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/03 03:58:36 $
   $Locker:  $
*/


