/***************************************************************************
                          clisten.h  -  description
                             -------------------
    begin                : Fri Mar 22 2002
    copyright            : (C) 2002-2003 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CLISTEN_H
#define CLISTEN_H

 /**
  *@author Mathias Küster
  *
  * Class for waiting for an incoming connection, involving callbacks
  * and CManager.
  */

#include <dclib/dcos.h>
#include <dclib/core/csocket.h>
#include <dclib/core/cmutex.h>
#include <dclib/core/ccallback.h>

class CListen : public CSocket {
public:
	/** */
	CListen();
	/** */
	virtual ~CListen();

	/** */
	int StartListen( int port, CString ip = CString(), bool manager = true );
	/** */
	void StopListen();

	/** callback function */
	virtual int DC_ListenCallBack( int ) { return -1; };

	/** */
	void SetCallBackFunction( _CCallback1<int> * callback );

	/** */
	int Callback();

private:
	/** */
	CMutex m_Mutex;
	/** */
	_CCallback1<int> * m_pListenCallback;
	/** */
	_CCallback0 * m_pCallback;
};

/** */
inline void CListen::SetCallBackFunction( _CCallback1<int> * callback )
{ m_Mutex.Lock(); delete m_pListenCallback; m_pListenCallback = callback; m_Mutex.UnLock(); }

#endif
