use strict;
use Digest::SHA3;

my $TAGS = join('|', qw(Len Msg MD));
my @vecs = ();
while (<DATA>) {
	next unless /^\s*($TAGS)\s*=\s*([\dA-F]+)/o;
	push(@vecs, $2);
}

my $numtests = scalar(@vecs) / 3;
print "1..$numtests\n";

for (1 .. $numtests) {
	my $sha3 = Digest::SHA3->new(512);
	my $Len = shift @vecs;
	my $Msg = pack("H*", shift @vecs);
	my $MD = shift @vecs;
	my $computed = $sha3->add_bits($Msg, $Len, 1)->hexdigest;
	print "not " unless $computed eq lc($MD);
	print "ok ", $_, "\n";
}

__DATA__
# Keccak(input|01)[r=576, c=1024] truncated to 512 bits, or SHA3-512 as in FIPS 202 draft

Len = 7
Msg = 4C
MD = E18E79FB35F92AFEEDF91A83D593BC8194F551F6AFDB21991F8F886E1B49337DC8208F4C4F5D77A79DC4BEA97B93C002CFB336D4B4D86F30DBA9C7862CCF6566

Len = 571
Msg = 18057027D18CD129DFB5584F87C48D8ECE475A366F33C62736932F55CD9ADE656B6D7F27EC182DC565B5FC6E3E125D4A0C5904A3666CD79F611562755C66D87EE6038B10C1E44F04
MD = DD90B9E95625099A9E1BAB4DD2C12A35F80BBEEC21FED2C56978F3436121ECAA32920F534655776C0323C5BB6579C8DD69B2B5164F380633DF407FB46085C4AE

Len = 2047
Msg = 1F42ADD25C0A80A4C82AAE3A0E302ABF9261DCA7E7884FD869D96ED4CE88AAAA25304D2D79E1FA5CC1FA2C95899229BC87431AD06DA524F2140E70BD0536E9685EE7808F598D8A9FE15D40A72AEFF431239292C5F64BDB7F620E5D160B329DEB58CF6D5C0665A3DED61AE4ADBCA94DC2B7B02CDF3992FDF79B3D93E546D5823C3A630923064ED24C3D974C4602A49DF75E49CF7BD51EDC7382214CBA850C4D3D11B40A70B1D926E3755EC79693620C242AB0F23EA206BA337A7EDC5421D63126CB6C7094F6BC1CF9943796BE2A0D9EB74FC726AA0C0D3B3D39039DEAD39A7169F8C3E2365DD349E358BF08C717D2E436D65172A76ED5E1F1E694A75C19280B15
MD = 2471F995EED05156F1036C345DD3764FBC5CB1DA6DE5D33627632B0EFC84A061AAF4A8775553A4602E49984C717C185A6F74FE4A0ED7FA5D96811ADCBD0953FA
