//  This software code is made available "AS IS" without warranties of any
//  kind.  You may copy, display, modify and redistribute the software
//  code either by itself or as incorporated into your code; provided that
//  you do not remove any proprietary notices.  Your use of this software
//  code is at your own risk and you waive any claim against Amazon
//  Digital Services, Inc. or its affiliates with respect to your use of
//  this software code. (c) 2006 Amazon Digital Services, Inc. or its
//  affiliates.

package net.noderunner.amazon.s3;

/**
 * A structure representing the owner of an object, used as a part of ListEntry.
 */
public class Owner {
	
	private String id;
	private String displayName;
	
    Owner() {
    }

	/**
	 * Constructs a new Owner.
	 */
	public Owner(String id, String displayName) {
		this.id = id;
		this.displayName = displayName;
	}

	/**
	 * Sets displayName.
	 */
	void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	/**
	 * Returns displayName.
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * Sets id.
	 */
	void setId(String id) {
		this.id = id;
	}

	/**
	 * Returns id.
	 */
	public String getId() {
		return id;
	}

	/**
	 * Returns a debug string.
	 */
	@Override
	public String toString()
	{
	    return "Owner id=" + id + " displayName=" + displayName;
	}
}
