/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc;

import java.io.Reader;

/**
 * This interfaces describes methods used for reading method invocations
 * and responses from a XML-RPC data stream.
 * <p>
 * The users of this interface, when returning a <code>ParamIterator</code>,
 * must be careful that its <code>next</code> only returns objects of expected
 * classes.
 * </p>
 * <p>
 * The <code>Object</code>s returned might consist of instances of these types:
 * <ul>
 * <li><code>java.lang.String</code></li>
 * <li><code>java.lang.Integer</code></li>
 * <li><code>java.lang.Boolean</code></li>
 * <li><code>java.lang.Double</code></li>
 * <li><code>java.util.Date</code></li>
 * <li><code>byte[]</code></li>
 * <li><code>net.noderunner.xmlrpc.ParamIterator</code></li>
 * <li><code>null</code> (Null value)</li>
 * </ul>
 * </p>
 *
 * @author Elias Ross
 * @version 1.0
 * @see XmlRpcWriter
 */

public interface XmlRpcReader 
{
	/**
	 * This is the first method to call after receiving a method call
	 * on the server.
	 *
	 * @return method name to invoke
	 * @throws XmlRpcException if the method name could not be parsed
	 */
	String readMethodName() 
		throws XmlRpcException;

	/**
	 * This returns an iterator used for reading the Xml-Rpc response data
	 * sent by the XML-RPC server.
	 *
	 * @return response parameters readable by an iterator
	 * @throws XmlRpcException if the method response could not be parsed
	 */
	ParamIterator readMethodResponse() 
		throws XmlRpcException;

	/**
	 * This returns an iterator used for reading the XML-RPC request data
	 * received by the XML-RPC server.
	 * It may be required that {@link #readMethodName} be 
	 * called before this method is invoked.
	 *
	 * @throws XmlRpcException if the method response could not be parsed
	 */
	ParamIterator readMethodRequest() 
		throws XmlRpcException;

	/**
	 * Sets the input stream (reader) to be used.  This allows the
	 * reader to be re-used without having to re-construct it.
	 */
	void setReader(Reader reader);

}
