/* $Id:$ */

/*
    libg3d - 3D object loading library

    Copyright (C) 2005-2009  Markus Dahms <mad@automagically.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef _IMP_ACF_DEF_ACF700
#define _IMP_ACF_DEF_ACF700

#include "imp_acf_def_proto.h"

static const AcfDef acf_def_acf700[] = {
	{ XCHR, "VIEW__PlatForm",                           1 },
	{ XINT, "VIEW__Filler",                             1 },
	{ XFLT, "VIEW__Filler",                             1 },
	{ XCHR, "VIEW_name",                              500 },
	{ XCHR, "VIEW_path",                              500 },
	{ XCHR, "VIEW_tailnum",                            40 },
	{ XCHR, "VIEW_author",                            500 },
	{ XCHR, "VIEW_descrip",                           500 },
	{ XFLT, "VIEW_Vmca_kts",                            1 },
	{ XFLT, "VIEW_Vso_kts",                             1 },
	{ XFLT, "VIEW_Vs_kts",                              1 },
	{ XFLT, "VIEW_Vyse_kts",                            1 },
	{ XFLT, "VIEW_Vfe_kts",                             1 },
	{ XFLT, "VIEW_Vle_kts",                             1 },
	{ XFLT, "VIEW_Vno_kts",                             1 },
	{ XFLT, "VIEW_Vne_kts",                             1 },
	{ XFLT, "VIEW_Mmo",                                 1 },
	{ XFLT, "VIEW_Gneg",                                1 },
	{ XFLT, "VIEW_Gpos",                                1 },
	{ XINT, "VIEW_has_navlites",                        1 },
	{ XFLT, "VIEW_peX",                                 1 },
	{ XFLT, "VIEW_peY",                                 1 },
	{ XFLT, "VIEW_peZ",                                 1 },
	{ XINT, "VIEW_has_lanlite1",                        1 },
	{ XFLT, "VIEW_lanlite1X",                           1 },
	{ XFLT, "VIEW_lanlite1Y",                           1 },
	{ XFLT, "VIEW_lanlite1Z",                           1 },
	{ XINT, "VIEW_has_lanlite2",                        1 },
	{ XFLT, "VIEW_lanlite2X",                           1 },
	{ XFLT, "VIEW_lanlite2Y",                           1 },
	{ XFLT, "VIEW_lanlite2Z",                           1 },
	{ XINT, "VIEW_has_lanlite3",                        1 },
	{ XFLT, "VIEW_lanlite3X",                           1 },
	{ XFLT, "VIEW_lanlite3Y",                           1 },
	{ XFLT, "VIEW_lanlite3Z",                           1 },
	{ XINT, "VIEW_has_fuserb1",                         1 },
	{ XFLT, "VIEW_fuserb1X",                            1 },
	{ XFLT, "VIEW_fuserb1Y",                            1 },
	{ XFLT, "VIEW_fuserb1Z",                            1 },
	{ XINT, "VIEW_has_fuserb2",                         1 },
	{ XFLT, "VIEW_fuserb2X",                            1 },
	{ XFLT, "VIEW_fuserb2Y",                            1 },
	{ XFLT, "VIEW_fuserb2Z",                            1 },
	{ XINT, "VIEW_has_taillite",                        1 },
	{ XFLT, "VIEW_tailliteX",                           1 },
	{ XFLT, "VIEW_tailliteY",                           1 },
	{ XFLT, "VIEW_tailliteZ",                           1 },
	{ XINT, "VIEW_has_refuel",                          1 },
	{ XFLT, "VIEW_refuel_X",                            1 },
	{ XFLT, "VIEW_refuel_Y",                            1 },
	{ XFLT, "VIEW_refuel_Z",                            1 },
	{ XFLT, "VIEW_yawstringx",                          1 },
	{ XFLT, "VIEW_yawstringy",                          1 },
	{ XFLT, "VIEW_HUD_cntrx",                           1 },
	{ XFLT, "VIEW_HUD_cntry",                           1 },
	{ XFLT, "VIEW_HUD_delx",                            1 },
	{ XFLT, "VIEW_HUD_dely",                            1 },
	{ XINT, "VIEW_lanlite_steers",                      1 },
	{ XFLT, "VIEW_lanlite_power",                       1 },
	{ XFLT, "VIEW_lanlite_width",                       1 },
	{ XFLT, "VIEW_lanlite_the",                         1 },
	{ XFLT, "VIEW_stall_warn_aoa",                      1 },
	{ XFLT, "VIEW_tow_hook_Y",                          1 },
	{ XFLT, "VIEW_tow_hook_Z",                          1 },
	{ XFLT, "VIEW_win_hook_Y",                          1 },
	{ XFLT, "VIEW_win_hook_Z",                          1 },
	{ XINT, "VIEW_HUD_type",                            1 },
	{ XFLT, "VIEW_cockpit_type",                        1 },
	{ XFLT, "VIEW_asi_kts",                             1 },
	{ XINT, "VIEW_warn1EQ",                             1 },
	{ XINT, "VIEW_warn2EQ",                             1 },
	{ XINT, "VIEW_is_glossy",                           1 },
	{ XINT, "VIEW_draw_geo_frnt_views",                 1 },
	{ XINT, "VIEW_draw_geo_side_views",                 1 },
	{ XINT, "VIEW_ins_type",                          200 },
	{ XFLT, "VIEW_ins_size",                          200 },
	{ XFLT, "VIEW_ins_x",                             200 },
	{ XFLT, "VIEW_ins_y",                             200 },
	{ XFLT, "VIEW_ins_delx",                          200 },
	{ XFLT, "VIEW_ins_dely",                          200 },
	{ XINT, "VIEW_cus_rnd_use",                        50 },
	{ XFLT, "VIEW_cus_rnd_lo_val",                     50 },
	{ XFLT, "VIEW_cus_rnd_hi_val",                     50 },
	{ XFLT, "VIEW_cus_rnd_lo_ang",                     50 },
	{ XFLT, "VIEW_cus_rnd_hi_ang",                     50 },
	{ XINT, "VIEW_cus_rnd_mirror",                     50 },
	{ XINT, "VIEW_cus_rnd_label",                      50 },
	{ XINT, "VIEW_cus_dig_use",                        50 },
	{ XFLT, "VIEW_cus_dig_offset",                     50 },
	{ XFLT, "VIEW_cus_dig_scale",                      50 },
	{ XINT, "VIEW_cus_dig_dig",                        50 },
	{ XINT, "VIEW_cus_dig_dec",                        50 },
	{ XINT, "ENGINE_num_engines",                       1 },
	{ XINT, "ENGINE_num_thrustpoints",                  1 },
	{ XFLT, "ENGINE_throt_max_FWD",                     1 },
	{ XFLT, "ENGINE_throt_max_REV",                     1 },
	{ XFLT, "ENGINE_idle_rat",                          2 },
	{ XINT, "ENGINE_props_linked",                      1 },
	{ XINT, "ENGINE_beta_prop_EQ",                      1 },
	{ XINT, "ENGINE_auto_feather_EQ",                   1 },
	{ XINT, "ENGINE_rev_thrust_EQ",                     1 },
	{ XINT, "ENGINE_drive_by_wire_EQ",                  1 },
	{ XFLT, "ENGINE_feathered_pitch",                   1 },
	{ XFLT, "ENGINE_reversed_pitch",                    1 },
	{ XFLT, "ENGINE_rotor_mi_rat",                      1 },
	{ XFLT, "ENGINE_tip_weight",                        1 },
	{ XFLT, "ENGINE_tip_mach_des_100",                  1 },
	{ XFLT, "ENGINE_tip_mach_des_50",                   1 },
	{ XFLT, "ENGINE_power_max",                         1 },
	{ XFLT, "ENGINE_crit_alt",                          1 },
	{ XFLT, "ENGINE_mp_max",                            1 },
	{ XFLT, "ENGINE_trq_max_eng",                       1 },
	{ XFLT, "ENGINE_RSC_idlespeed_ENGN",                1 },
	{ XFLT, "ENGINE_RSC_redline_ENGN",                  1 },
	{ XFLT, "ENGINE_RSC_idlespeed_PROP",                1 },
	{ XFLT, "ENGINE_RSC_redline_PROP",                  1 },
	{ XFLT, "ENGINE_RSC_mingreen_ENGN",                 1 },
	{ XFLT, "ENGINE_RSC_maxgreen_ENGN",                 1 },
	{ XFLT, "ENGINE_RSC_mingreen_PROP",                 1 },
	{ XFLT, "ENGINE_RSC_maxgreen_PROP",                 1 },
	{ XFLT, "ENGINE_turbo_tight",                       1 },
	{ XFLT, "ENGINE_spooltime_prop",                    1 },
	{ XFLT, "ENGINE_trans_loss",                        1 },
	{ XFLT, "ENGINE_thrust_max",                        1 },
	{ XFLT, "ENGINE_burner_inc",                        1 },
	{ XFLT, "ENGINE_max_mach_eff",                      1 },
	{ XFLT, "ENGINE_face_jet",                          1 },
	{ XFLT, "ENGINE_spooltime_jet",                     1 },
	{ XFLT, "ENGINE_lift_fan_rat",                      1 },
	{ XFLT, "ENGINE_rock_max_sl",                       1 },
	{ XFLT, "ENGINE_rock_max_opt",                      1 },
	{ XFLT, "ENGINE_rock_max_vac",                      1 },
	{ XFLT, "ENGINE_rock_h_opt",                        1 },
	{ XFLT, "ENGINE_face_rocket",                       1 },
	{ XINT, "PROP_engn_type",                           8 },
	{ XINT, "PROP_prop_type",                           8 },
	{ XFLT, "PROP_engn_mass",                           8 },
	{ XINT, "PROP_prop_clutch_EQ",                      8 },
	{ XFLT, "PROP_prop_gear_rat",                       8 },
	{ XFLT, "PROP_prop_dir",                            8 },
	{ XFLT, "PROP_num_blades",                          8 },
	{ XFLT, "PROP_SFC",                                 8 },
	{ XFLT, "PROP_vertcant",                            8 },
	{ XFLT, "PROP_sidecant",                            8 },
	{ XFLT, "PROP_min_pitch",                           8 },
	{ XFLT, "PROP_max_pitch",                           8 },
	{ XFLT, "PROP_des_rpm_prp",                         8 },
	{ XFLT, "PROP_des_kts_prp",                         8 },
	{ XFLT, "PROP_des_kts_acf",                         8 },
	{ XFLT, "PROP_prop_mass",                           8 },
	{ XFLT, "PROP_mi_prop_rpm",                         8 },
	{ XFLT, "PROP_mi_engn_rpm",                         8 },
	{ XFLT, "PROP_discarea",                            8 },
	{ XFLT, "PROP_ringarea",                           80 },
	{ XFLT, "PROP_bladesweep",                         80 },
	{ XFLT, "HYDRO_STICK_starter_rat",                  1 },
	{ XFLT, "HYDRO_STICK_battery_rat",                  1 },
	{ XINT, "HYDRO_STICK_ff_hydraulic",                 1 },
	{ XINT, "HYDRO_STICK_ff_stickshaker",               1 },
	{ XFLT, "HYDRO_STICK_manual_reversion_rat",         1 },
	{ XFLT, "HYDRO_STICK_max_press_diff",               1 },
	{ XINT, "PARTS_WingBodyGear_part_eq",              73 },
	{ XCHR, "PARTS_WingBodyGear_Rafl0",              2920 },
	{ XCHR, "PARTS_WingBodyGear_Rafl1",              2920 },
	{ XCHR, "PARTS_WingBodyGear_Tafl0",              2920 },
	{ XCHR, "PARTS_WingBodyGear_Tafl1",              2920 },
	{ XINT, "PARTS_WingBodyGear_els",                  73 },
	{ XFLT, "PARTS_WingBodyGear_Xarm",                 73 },
	{ XFLT, "PARTS_WingBodyGear_Yarm",                 73 },
	{ XFLT, "PARTS_WingBodyGear_Zarm",                 73 },
	{ XFLT, "PARTS_WingBodyGear_Croot",                73 },
	{ XFLT, "PARTS_WingBodyGear_Ctip",                 73 },
	{ XFLT, "PARTS_WingBodyGear_semilen_SEG",          73 },
	{ XFLT, "PARTS_WingBodyGear_semilen_JND",          73 },
	{ XFLT, "PARTS_WingBodyGear_element_len",          73 },
	{ XFLT, "PARTS_WingBodyGear_X_body_aero",          73 },
	{ XFLT, "PARTS_WingBodyGear_Y_body_aero",          73 },
	{ XFLT, "PARTS_WingBodyGear_Z_body_aero",          73 },
	{ XFLT, "PARTS_WingBodyGear_dihed1",               73 },
	{ XFLT, "PARTS_WingBodyGear_dihed2",               73 },
	{ XFLT, "PARTS_WingBodyGear_dihednow",             73 },
	{ XINT, "PARTS_WingBodyGear_vardihed",             73 },
	{ XINT, "PARTS_WingBodyGear_vardihedEQ",            1 },
	{ XFLT, "PARTS_WingBodyGear_sweep1",               73 },
	{ XFLT, "PARTS_WingBodyGear_sweep2",               73 },
	{ XFLT, "PARTS_WingBodyGear_sweepnow",             73 },
	{ XINT, "PARTS_WingBodyGear_varsweep",             73 },
	{ XINT, "PARTS_WingBodyGear_varsweepEQ",            1 },
	{ XFLT, "PARTS_WingBodyGear_e",                    73 },
	{ XFLT, "PARTS_WingBodyGear_AR",                   73 },
	{ XFLT, "PARTS_WingBodyGear_al_D_al0",             73 },
	{ XFLT, "PARTS_WingBodyGear_cl_D_cl0",             73 },
	{ XFLT, "PARTS_WingBodyGear_cm_D_cm0",             73 },
	{ XFLT, "PARTS_WingBodyGear_delta_fac",            73 },
	{ XFLT, "PARTS_WingBodyGear_spec_wash",            73 },
	{ XFLT, "PARTS_WingBodyGear_alpha_max",            73 },
	{ XFLT, "PARTS_WingBodyGear_slat_effect",          73 },
	{ XFLT, "PARTS_WingBodyGear_s",                   730 },
	{ XFLT, "PARTS_WingBodyGear_mac",                 730 },
	{ XFLT, "PARTS_WingBodyGear_incidence",           730 },
	{ XINT, "PARTS_WingBodyGear_ail1",                730 },
	{ XFLT, "PARTS_WingBodyGear_ail1_elR",             73 },
	{ XFLT, "PARTS_WingBodyGear_ail1_elT",             73 },
	{ XFLT, "PARTS_WingBodyGear_ail1_cratR",            1 },
	{ XFLT, "PARTS_WingBodyGear_ail1_cratT",            1 },
	{ XFLT, "PARTS_WingBodyGear_ail1_up",               1 },
	{ XFLT, "PARTS_WingBodyGear_ail1_dn",               1 },
	{ XINT, "PARTS_WingBodyGear_ail2",                730 },
	{ XFLT, "PARTS_WingBodyGear_ail2_elR",             73 },
	{ XFLT, "PARTS_WingBodyGear_ail2_elT",             73 },
	{ XFLT, "PARTS_WingBodyGear_ail2_cratR",            1 },
	{ XFLT, "PARTS_WingBodyGear_ail2_cratT",            1 },
	{ XFLT, "PARTS_WingBodyGear_ail2_up",               1 },
	{ XFLT, "PARTS_WingBodyGear_ail2_dn",               1 },
	{ XINT, "PARTS_WingBodyGear_elev",                730 },
	{ XFLT, "PARTS_WingBodyGear_elev_elR",             73 },
	{ XFLT, "PARTS_WingBodyGear_elev_elT",             73 },
	{ XFLT, "PARTS_WingBodyGear_elev_cratR",            1 },
	{ XFLT, "PARTS_WingBodyGear_elev_cratT",            1 },
	{ XFLT, "PARTS_WingBodyGear_elev_up",               1 },
	{ XFLT, "PARTS_WingBodyGear_elev_dn",               1 },
	{ XINT, "PARTS_WingBodyGear_rudd",                730 },
	{ XFLT, "PARTS_WingBodyGear_rudd_elR",             73 },
	{ XFLT, "PARTS_WingBodyGear_rudd_elT",             73 },
	{ XFLT, "PARTS_WingBodyGear_rudd_cratR",            1 },
	{ XFLT, "PARTS_WingBodyGear_rudd_cratT",            1 },
	{ XFLT, "PARTS_WingBodyGear_rudd_lr",               1 },
	{ XINT, "PARTS_WingBodyGear_splr",                730 },
	{ XFLT, "PARTS_WingBodyGear_splr_elR",             73 },
	{ XFLT, "PARTS_WingBodyGear_splr_elT",             73 },
	{ XFLT, "PARTS_WingBodyGear_splr_cratR",            1 },
	{ XFLT, "PARTS_WingBodyGear_splr_cratT",            1 },
	{ XFLT, "PARTS_WingBodyGear_splr_up",               1 },
	{ XINT, "PARTS_WingBodyGear_yawb",                730 },
	{ XFLT, "PARTS_WingBodyGear_yawb_elR",             73 },
	{ XFLT, "PARTS_WingBodyGear_yawb_elT",             73 },
	{ XFLT, "PARTS_WingBodyGear_yawb_cratR",            1 },
	{ XFLT, "PARTS_WingBodyGear_yawb_cratT",            1 },
	{ XFLT, "PARTS_WingBodyGear_yawb_ud",               1 },
	{ XINT, "PARTS_WingBodyGear_sbrk",                730 },
	{ XFLT, "PARTS_WingBodyGear_sbrk_elR",             73 },
	{ XFLT, "PARTS_WingBodyGear_sbrk_elT",             73 },
	{ XFLT, "PARTS_WingBodyGear_sbrk_cratR",            1 },
	{ XFLT, "PARTS_WingBodyGear_sbrk_cratT",            1 },
	{ XFLT, "PARTS_WingBodyGear_sbrk_up",               1 },
	{ XINT, "PARTS_WingBodyGear_sbrkEQ",                1 },
	{ XINT, "PARTS_WingBodyGear_flap",                730 },
	{ XFLT, "PARTS_WingBodyGear_flap_elR",             73 },
	{ XFLT, "PARTS_WingBodyGear_flap_elT",             73 },
	{ XFLT, "PARTS_WingBodyGear_flap_cratR",            1 },
	{ XFLT, "PARTS_WingBodyGear_flap_cratT",            1 },
	{ XFLT, "PARTS_WingBodyGear_flap_dn",               8 },
	{ XINT, "PARTS_WingBodyGear_flapEQ",                1 },
	{ XINT, "PARTS_WingBodyGear_slat",                730 },
	{ XFLT, "PARTS_WingBodyGear_slat_inc",              1 },
	{ XINT, "PARTS_WingBodyGear_slatEQ",                1 },
	{ XINT, "PARTS_WingBodyGear_inc_ail1",            730 },
	{ XINT, "PARTS_WingBodyGear_inc_ail2",            730 },
	{ XINT, "PARTS_WingBodyGear_inc_elev",            730 },
	{ XINT, "PARTS_WingBodyGear_inc_rudd",            730 },
	{ XINT, "PARTS_WingBodyGear_inc_vect",            730 },
	{ XINT, "PARTS_WingBodyGear_inc_trim",            730 },
	{ XINT, "PARTS_WingBodyGear_in_downwash",        53290 },
	{ XFLT, "PARTS_WingBodyGear_body_r",               73 },
	{ XFLT, "PARTS_WingBodyGear_body_X",             26280 },
	{ XFLT, "PARTS_WingBodyGear_body_Y",             26280 },
	{ XFLT, "PARTS_WingBodyGear_body_Z",             26280 },
	{ XINT, "PARTS_WingBodyGear_gear_type",            73 },
	{ XFLT, "PARTS_WingBodyGear_gear_latE",            73 },
	{ XFLT, "PARTS_WingBodyGear_gear_lonE",            73 },
	{ XFLT, "PARTS_WingBodyGear_gear_axiE",            73 },
	{ XFLT, "PARTS_WingBodyGear_gear_latR",            73 },
	{ XFLT, "PARTS_WingBodyGear_gear_lonR",            73 },
	{ XFLT, "PARTS_WingBodyGear_gear_axiR",            73 },
	{ XFLT, "PARTS_WingBodyGear_gear_latN",            73 },
	{ XFLT, "PARTS_WingBodyGear_gear_lonN",            73 },
	{ XFLT, "PARTS_WingBodyGear_gear_axiN",            73 },
	{ XFLT, "PARTS_WingBodyGear_gear_xnodef",          73 },
	{ XFLT, "PARTS_WingBodyGear_gear_ynodef",          73 },
	{ XFLT, "PARTS_WingBodyGear_gear_znodef",          73 },
	{ XFLT, "PARTS_WingBodyGear_gear_leglen",          73 },
	{ XFLT, "PARTS_WingBodyGear_gear_radius",          73 },
	{ XFLT, "PARTS_WingBodyGear_gear_width",           73 },
	{ XFLT, "PARTS_WingBodyGear_gearcon",              73 },
	{ XFLT, "PARTS_WingBodyGear_geardmp",              73 },
	{ XFLT, "PARTS_WingBodyGear_gear_deploy",          73 },
	{ XFLT, "PARTS_WingBodyGear_gearstatdef",          73 },
	{ XFLT, "PARTS_WingBodyGear_gear_def",             73 },
	{ XINT, "PARTS_WingBodyGear_gear_steers",          73 },
	{ XFLT, "PARTS_WingBodyGear_gear_cyctim",          73 },
	{ XFLT, "BODIES_fuse_cd",                           1 },
	{ XFLT, "CONTROL_hstb_trim_up",                     1 },
	{ XFLT, "CONTROL_hstb_trim_dn",                     1 },
	{ XINT, "CONTROL_flap_type",                        1 },
	{ XINT, "CONTROL_con_smooth",                       1 },
	{ XINT, "CONTROL_flap_detents",                     1 },
	{ XFLT, "CONTROL_flap_deftime",                     1 },
	{ XFLT, "CONTROL_flap_cl",                          1 },
	{ XFLT, "CONTROL_flap_cd",                          1 },
	{ XFLT, "CONTROL_flap_cm",                          1 },
	{ XFLT, "CONTROL_blown_flap_add_speed",             1 },
	{ XFLT, "CONTROL_blown_flap_throt_red",             1 },
	{ XFLT, "CONTROL_blown_flap_min_engag",             1 },
	{ XINT, "CONTROL_blow_all_controls",                1 },
	{ XINT, "LANDING_GEAR_gear_retract",                1 },
	{ XFLT, "LANDING_GEAR_nw_steerdeg1",                1 },
	{ XFLT, "LANDING_GEAR_nw_steerdeg2",                1 },
	{ XFLT, "LANDING_GEAR_nw_cutoff_speed",             1 },
	{ XFLT, "LANDING_GEAR_nosewheel_k",                 1 },
	{ XFLT, "LANDING_GEAR_gear_door_size",              1 },
	{ XFLT, "LANDING_GEAR_water_rud_longarm",           1 },
	{ XFLT, "LANDING_GEAR_water_rud_area",              1 },
	{ XFLT, "LANDING_GEAR_water_rud_maxdef",            1 },
	{ XFLT, "LANDING_GEAR_roll_co",                     1 },
	{ XFLT, "LANDING_GEAR_brake_co",                    1 },
	{ XINT, "LANDING_GEAR_gear_door_typ",              10 },
	{ XFLT, "LANDING_GEAR_gear_door_loc",              30 },
	{ XFLT, "LANDING_GEAR_",                            1 },
	{ XFLT, "LANDING_GEAR_gear_door_axi_rot",          10 },
	{ XFLT, "LANDING_GEAR_gear_door_ext_ang",          10 },
	{ XFLT, "LANDING_GEAR_gear_door_ret_ang",          10 },
	{ XFLT, "LANDING_GEAR_gear_door_ang_now",          10 },
	{ XFLT, "WEIGHT_BALANCE_cgY",                       1 },
	{ XFLT, "WEIGHT_BALANCE_cgZ",                       1 },
	{ XFLT, "WEIGHT_BALANCE_cgZ_fwd",                   1 },
	{ XFLT, "WEIGHT_BALANCE_cgZ_aft",                   1 },
	{ XFLT, "WEIGHT_BALANCE_m_empty",                   1 },
	{ XFLT, "WEIGHT_BALANCE_m_fuel_tot",                1 },
	{ XFLT, "WEIGHT_BALANCE_m_jettison",                1 },
	{ XFLT, "WEIGHT_BALANCE_m_max",                     1 },
	{ XFLT, "WEIGHT_BALANCE_m_displaced",               1 },
	{ XFLT, "WEIGHT_BALANCE_Jxx_unitmass",              1 },
	{ XFLT, "WEIGHT_BALANCE_Jyy_unitmass",              1 },
	{ XFLT, "WEIGHT_BALANCE_Jzz_unitmass",              1 },
	{ XINT, "WEIGHT_BALANCE_num_tanks",                 1 },
	{ XFLT, "WEIGHT_BALANCE_tank_rat",                  3 },
	{ XFLT, "WEIGHT_BALANCE_tank_X",                    3 },
	{ XFLT, "WEIGHT_BALANCE_tank_Y",                    3 },
	{ XFLT, "WEIGHT_BALANCE_tank_Z",                    3 },
	{ XINT, "WEIGHT_BALANCE_jett_is_slung",             1 },
	{ XINT, "WEIGHT_BALANCE_jett_is_water",             1 },
	{ XFLT, "WEIGHT_BALANCE_jett_len",                  1 },
	{ XFLT, "WEIGHT_BALANCE_jett_X",                    1 },
	{ XFLT, "WEIGHT_BALANCE_jett_Y",                    1 },
	{ XFLT, "WEIGHT_BALANCE_jett_Z",                    1 },
	{ XFLT, "SPECIAL_CONTROLS_flap_roll",               1 },
	{ XFLT, "SPECIAL_CONTROLS_flap_ptch",               1 },
	{ XFLT, "SPECIAL_CONTROLS_mass_shift",              1 },
	{ XFLT, "SPECIAL_CONTROLS_mass_shift_dx",           1 },
	{ XFLT, "SPECIAL_CONTROLS_mass_shift_dz",           1 },
	{ XFLT, "SPECIAL_CONTROLS_wing_tilt_ptch",          1 },
	{ XFLT, "SPECIAL_CONTROLS_wing_tilt_roll",          1 },
	{ XFLT, "SPECIAL_CONTROLS_tvec_ptch",               1 },
	{ XFLT, "SPECIAL_CONTROLS_tvec_roll",               1 },
	{ XFLT, "SPECIAL_CONTROLS_tvec_hdng",               1 },
	{ XFLT, "SPECIAL_CONTROLS_jato_Y",                  1 },
	{ XFLT, "SPECIAL_CONTROLS_jato_Z",                  1 },
	{ XFLT, "SPECIAL_CONTROLS_jato_theta",              1 },
	{ XFLT, "SPECIAL_CONTROLS_jato_thrust",             1 },
	{ XFLT, "SPECIAL_CONTROLS_jato_dur",                1 },
	{ XFLT, "SPECIAL_CONTROLS_jato_sfc",                1 },
	{ XFLT, "SPECIAL_CONTROLS_stab_roll",               1 },
	{ XFLT, "SPECIAL_CONTROLS_stab_hdng",               1 },
	{ XFLT, "SPECIAL_CONTROLS_elev_flaps",              1 },
	{ XFLT, "SPECIAL_CONTROLS_ail1_pitch",              1 },
	{ XFLT, "SPECIAL_CONTROLS_ail1_flaps",              1 },
	{ XFLT, "SPECIAL_CONTROLS_ail2_pitch",              1 },
	{ XFLT, "SPECIAL_CONTROLS_ail2_flaps",              1 },
	{ XFLT, "SPECIAL_CONTROLS_ail2_vmax",               1 },
	{ XFLT, "SPECIAL_CONTROLS_diff_thro_with_hdng",     1 },
	{ XINT, "SPECIAL_CONTROLS_phase_tvect_out_at_90",    1 },
	{ XINT, "SPECIAL_CONTROLS_phase_tvect_out_at_00",    1 },
	{ XINT, "SPECIAL_CONTROLS_autosbrkEQ",              1 },
	{ XINT, "SPECIAL_CONTROLS_autofbrkEQ",              1 },
	{ XINT, "SPECIAL_CONTROLS_autosweepEQ",             1 },
	{ XINT, "SPECIAL_CONTROLS_flaps_with_gearEQ",       1 },
	{ XINT, "SPECIAL_CONTROLS_autoslatEQ",              1 },
	{ XINT, "SPECIAL_CONTROLS_antiiceEQ",               1 },
	{ XINT, "SPECIAL_CONTROLS_arrestingEQ",             1 },
	{ XINT, "SPECIAL_CONTROLS_rev_on_touchdown",        1 },
	{ XINT, "SPECIAL_CONTROLS_gearhornEQ",              1 },
	{ XINT, "SPECIAL_CONTROLS_lorotorwarnEQ",           1 },
	{ XINT, "SPECIAL_CONTROLS_auto_trimEQ",             1 },
	{ XINT, "SPECIAL_CONTROLS_flaps_with_vecEQ",        1 },
	{ XFLT, "SPECIAL_CONTROLS_brake_area",              1 },
	{ XFLT, "SPECIAL_CONTROLS_brake_Y",                 1 },
	{ XFLT, "SPECIAL_CONTROLS_brake_Z",                 1 },
	{ XFLT, "SPECIAL_CONTROLS_chute_area",              1 },
	{ XFLT, "SPECIAL_CONTROLS_chute_Y",                 1 },
	{ XFLT, "SPECIAL_CONTROLS_chute_Z",                 1 },
	{ XINT, "VTOL_CONTROL_vectEQ",                      1 },
	{ XINT, "VTOL_CONTROL_auto_rpm_with_tvec",          1 },
	{ XINT, "VTOL_CONTROL_hide_prop_at_90_vect",        1 },
	{ XFLT, "VTOL_CONTROL_vect_rate",                   1 },
	{ XFLT, "VTOL_CONTROL_vect_min",                    1 },
	{ XFLT, "VTOL_CONTROL_vect_max",                    1 },
	{ XFLT, "VTOL_CONTROL_vectarmY",                    1 },
	{ XFLT, "VTOL_CONTROL_vectarmZ",                    1 },
	{ XFLT, "VTOL_CONTROL_cyclic_elev",                 1 },
	{ XFLT, "VTOL_CONTROL_cyclic_ailn",                 1 },
	{ XFLT, "VTOL_CONTROL_flap_arm",                    1 },
	{ XFLT, "VTOL_CONTROL_delta3",                      1 },
	{ XFLT, "VTOL_CONTROL_puffL",                       1 },
	{ XFLT, "VTOL_CONTROL_puffM",                       1 },
	{ XFLT, "VTOL_CONTROL_puffN",                       1 },
	{ XFLT, "VTOL_CONTROL_puffX",                       1 },
	{ XFLT, "VTOL_CONTROL_puffY",                       1 },
	{ XFLT, "VTOL_CONTROL_puffZ",                       1 },
	{ XFLT, "VTOL_CONTROL_stab_delinc_to_Vne",          1 },
	{ XFLT, "VTOL_CONTROL_tail_with_coll",              1 },
	{ XFLT, "VTOL_CONTROL_diff_coll_with_roll",         1 },
	{ XFLT, "VTOL_CONTROL_diff_coll_with_hdng",         1 },
	{ XFLT, "VTOL_CONTROL_diff_coll_with_ptch",         1 },
	{ XFLT, "VTOL_CONTROL_diff_cycl_with_hdng_lon",     1 },
	{ XFLT, "VTOL_CONTROL_diff_cycl_with_hdng_lat",     1 },
	{ XFLT, "VTOL_CONTROL_rotor_trim_max_fwd",          1 },
	{ XFLT, "VTOL_CONTROL_rotor_trim_max_aft",          1 },
	{ XFLT, "ART_STAB_AShiV",                           1 },
	{ XFLT, "ART_STAB_ASloV",                           1 },
	{ XFLT, "ART_STAB_ASmaxp_lo",                       1 },
	{ XFLT, "ART_STAB_ASp_lo_rate",                     1 },
	{ XFLT, "ART_STAB_ASmaxh_lo",                       1 },
	{ XFLT, "ART_STAB_ASh_lo_rate",                     1 },
	{ XFLT, "ART_STAB_ASmaxr_lo",                       1 },
	{ XFLT, "ART_STAB_ASr_lo_rate",                     1 },
	{ XFLT, "ART_STAB_ASmaxg_hi",                       1 },
	{ XFLT, "ART_STAB_ASg_hi_pos",                      1 },
	{ XFLT, "ART_STAB_ASg_hi_rate",                     1 },
	{ XFLT, "ART_STAB_ASmaxp_hi",                       1 },
	{ XFLT, "ART_STAB_ASp_hi_pos",                      1 },
	{ XFLT, "ART_STAB_ASp_hi_rate",                     1 },
	{ XFLT, "ART_STAB_ASmaxh_hi",                       1 },
	{ XFLT, "ART_STAB_ASh_hi_pos",                      1 },
	{ XFLT, "ART_STAB_ASh_hi_rate",                     1 },
	{ XFLT, "ART_STAB_ASmaxr_hi",                       1 },
	{ XFLT, "ART_STAB_ASr_hi_rate",                     1 },
	{ XCHR, "WEARONS_wpn_name",                      12000 },
	{ XFLT, "WEARONS_Xwpn_att",                        24 },
	{ XFLT, "WEARONS_Ywpn_att",                        24 },
	{ XFLT, "WEARONS_Zwpn_att",                        24 },
	{ XFLT, "AUTO_SETS_est_Vs_msc",                     1 },
	{ XFLT, "AUTO_SETS_size_x",                         1 },
	{ XFLT, "AUTO_SETS_size_z",                         1 },
	{ XFLT, "AUTO_SETS_tire_s_contact",                 1 },
	{ XFLT, "AUTO_SETS_m_displaced_y",                  1 },
	{ XFLT, "AUTO_SETS_h_eqlbm",                        1 },
	{ XFLT, "AUTO_SETS_the_eqlbm",                      1 },
	{ XINT, "AUTO_SETS_is_taildragger",                 1 },
	{ XINT, "AUTO_SETS_is_skid_gear",                   1 },
	{ XINT, "AUTO_SETS_is_hybrid_gear",                 1 },
	{ XINT, "AUTO_SETS_has_nav",                        6 },
	{ XINT, "AUTO_SETS_has_radar",                      1 },
	{ XINT, "AUTO_SETS_has_SC_fd",                      1 },
	{ XINT, "AUTO_SETS_has_DC_fd",                      1 },
	{ XINT, "AUTO_SETS_has_stallwarn",                  1 },
	{ XINT, "AUTO_SETS_has_clutchswitch",               1 },
	{ XINT, "AUTO_SETS_has_prerotate",                  1 },
	{ XINT, "AUTO_SETS_has_idlespeed",                  1 },
	{ XINT, "AUTO_SETS_has_litemap_tex",                1 },
	{ XINT, "AUTO_SETS_has_tailrotor",                  1 },
	{ XINT, "AUTO_SETS_has_collective",                 1 },
	{ XINT, "AUTO_SETS_collective_en",                  1 },
	{ XFLT, "SOUND_REF_snd_kias",                       1 },
	{ XFLT, "SOUND_REF_snd_rpm_prp",                    1 },
	{ XFLT, "SOUND_REF_snd_rpm_eng",                    1 },
	{ XFLT, "SOUND_REF_snd_n1",                         1 },
	{ XFLT, "VAR_INCIDENCE_inc2",                      73 },
	{ XFLT, "VAR_INCIDENCE_incnow",                    73 },
	{ XINT, "VAR_INCIDENCE_varinc",                    73 },
	{ XINT, "VAR_INCIDENCE_varincEQ",                   1 },
	{ XFLT, "owerflow_xflt_overflow",                 776 },
	{ XINT, "owerflow_xint_overflow",                1000 },
	{ XCHR, "owerflow_xchr_overflow",                1000 },
	{ XCHR, "end_of_data",                              1 },

	{ XEOF, NULL, 0 }
};

#endif /* _IMP_ACF_DEF_ACF700 */
