/*
 * @(#)VirtualWindowUIUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.uicapture.v1;

import java.awt.Robot;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the VirtualWindowUI class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/02/10 22:52:34 $
 * @since     Jan 6, 2002
 */
public class VirtualWindowUIUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = VirtualWindowUIUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public VirtualWindowUIUTest( String name )
    {
        super( name );
    }



    //-------------------------------------------------------------------------
    // Tests
    
    public void testInstantiation()
    {
        VirtualWindowUI vwui = createVWUI();
        assertTrue(
            "Default glass pane state is false.",
            !vwui.isGlassEnabled() );
    }
    
    
    public void testCoveredScreen()
    {
        VirtualWindowUI vwui = createVWUI();
        Rectangle r = vwui.getCoveredScreen();
        assertNotNull(
            "Covered screen should never be null.",
            r );
        assertEquals(
            "X is not 0",
            0,
            (int)r.getX() );
        assertEquals(
            "Y is not 0",
            0,
            (int)r.getY() );
    }
    
    
    public void testGlass1()
    {
        VirtualWindowUI vwui = createVWUI();
        assertTrue(
            "Default glass pane state is false.",
            !vwui.isGlassEnabled() );
        vwui.show();
        assertTrue(
            "Showing UI should set glass pane state to true.",
            vwui.isGlassEnabled() );
        vwui.hide();
        assertTrue(
            "Hiding UI should set glass pane state to false.",
            !vwui.isGlassEnabled() );
    }
    
    
    public void testGlass2()
    {
        VirtualWindowUI vwui = createVWUI();
        assertTrue(
            "Default glass pane state is false.",
            !vwui.isGlassEnabled() );
        vwui.hide();
        assertTrue(
            "Hiding UI should set glass pane state to false.",
            !vwui.isGlassEnabled() );
        vwui.show();
        assertTrue(
            "Showing UI should set glass pane state to true.",
            vwui.isGlassEnabled() );
        vwui.show();
        assertTrue(
            "Showing UI should set glass pane state to true.",
            vwui.isGlassEnabled() );
        vwui.hide();
        assertTrue(
            "Hiding UI should set glass pane state to false.",
            !vwui.isGlassEnabled() );
        vwui.hide();
        assertTrue(
            "Hiding UI should set glass pane state to false.",
            !vwui.isGlassEnabled() );
    }
    
    
    /*
    this test has never worked right.
    If a screen-saver is running, or the moon is full, then the test will
    fail.
    
    public void testDraw1()
            throws Exception
    {
        Robot r = new Robot();
        Color p1 = r.getPixelColor( 0, 0 );
        // set the new UI's background to a color that is opposite of
        // the current color.
        Color inverse = new Color( 255 - p1.getRed(), 255 - p1.getGreen(),
            255 - p1.getBlue() );
        BufferedImage img = new BufferedImage( 2, 2,
            BufferedImage.TYPE_3BYTE_BGR );
        Graphics2D g = img.createGraphics();
        g.setColor( inverse );
        g.drawLine( 0, 0, 1, 0 );
        
        VirtualWindowUI vwui = createVWUI();
        vwui.setBackground( img );
        
        vwui.show();
        
        Color p2 = r.getPixelColor( 0, 0 );
        assertEquals(
            "Displayed image was not the same.",
            inverse,
            p2 );
    }
    */
    
    


    //-------------------------------------------------------------------------
    // Helpers
    
    private Frame f;
    private VirtualWindowUI innervwui;
    
    protected VirtualWindowUI createVWUI()
    {
        if (this.f == null)
        {
            this.f = new Frame( "Test" );
            // f.show();
        }
        VirtualWindowUI vwui = new VirtualWindowUI( f );
        this.innervwui = vwui;
        return vwui;
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        if (this.f != null)
        {
            this.f.dispose();
            this.f = null;
        }
        if (this.innervwui != null)
        {
            try
            {
                this.innervwui.dispose();
            }
            catch (Exception e)
            {
                DOC.getLog().info( "VWUI threw an exception during disposal.", e );
            }
            this.innervwui = null;
        }
        
        super.tearDown();
    }
}

