
#include <glib.h>
#include "libindicate/listener.h"
#include "test-max-indicators-list.h"

static gboolean passed = TRUE;
static GMainLoop * mainloop = NULL;


static void
indicator_added (IndicateListener * listener, IndicateListenerServer * server, IndicateListenerIndicator * indicator, gpointer data)
{
	return indicate_listener_displayed(listener, server, indicator, TRUE);
}

static gboolean
failed_cb (gpointer data)
{
	g_debug("Done indicatating displayed");
	g_main_loop_quit(mainloop);
	return FALSE;
}

static void
server_removed (void)
{
	g_debug("Server went away, exiting.");
	g_main_loop_quit(mainloop);
	return;
}

int
main (int argc, char * argv)
{
	g_type_init();

	IndicateListener * listener = indicate_listener_ref_default();

	g_signal_connect(listener, INDICATE_LISTENER_SIGNAL_INDICATOR_ADDED, G_CALLBACK(indicator_added), NULL);
	g_signal_connect(listener, INDICATE_LISTENER_SIGNAL_SERVER_REMOVED, G_CALLBACK(server_removed), NULL);

	g_timeout_add_seconds(2, failed_cb, NULL);

	mainloop = g_main_loop_new(NULL, FALSE);
	g_main_loop_run(mainloop);

	return !passed;
}
