/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.SimpleTimeZone;
import sun.security.action.GetPropertyAction;
import sun.util.calendar.ZoneInfo;
import sun.util.calendar.ZoneInfoFile;

public abstract class TimeZone
implements Serializable,
Cloneable {
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final int ONE_DAY = 86400000;
    private static Hashtable cachedLocaleData = new Hashtable(3);
    static final long serialVersionUID = 3581463369166924961L;
    private String ID;
    private static TimeZone defaultZone = null;
    static final String GMT_ID = "GMT";
    private static final int GMT_ID_LENGTH = 3;

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public int getOffset(long l) {
        if (this.inDaylightTime(new Date(l))) {
            return this.getRawOffset() + this.getDSTSavings();
        }
        return this.getRawOffset();
    }

    int getOffsets(long l, int[] nArray) {
        int n = this.getRawOffset();
        int n2 = 0;
        if (this.inDaylightTime(new Date(l))) {
            n2 = this.getDSTSavings();
        }
        if (nArray != null) {
            nArray[0] = n;
            nArray[1] = n2;
        }
        return n + n2;
    }

    public abstract void setRawOffset(int var1);

    public abstract int getRawOffset();

    public String getID() {
        return this.ID;
    }

    public void setID(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.ID = string;
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault());
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean bl, int n) {
        return this.getDisplayName(bl, n, Locale.getDefault());
    }

    public String getDisplayName(boolean bl, int n, Locale locale) {
        SimpleTimeZone simpleTimeZone;
        SimpleDateFormat simpleDateFormat;
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal style: " + n);
        }
        SoftReference softReference = (SoftReference)cachedLocaleData.get(locale);
        if (softReference == null || (simpleDateFormat = (SimpleDateFormat)softReference.get()) == null) {
            simpleDateFormat = new SimpleDateFormat("", locale);
            cachedLocaleData.put(locale, new SoftReference(simpleDateFormat));
        }
        if (bl && this.useDaylightTime()) {
            int n2 = this.getDSTSavings();
            simpleTimeZone = new SimpleTimeZone(this.getRawOffset(), this.getID(), 0, 1, 0, 0, 1, 1, 0, 0, n2);
        } else {
            simpleTimeZone = new SimpleTimeZone(this.getRawOffset(), this.getID());
        }
        simpleDateFormat.applyPattern(n == 1 ? "zzzz" : "z");
        simpleDateFormat.setTimeZone(simpleTimeZone);
        return simpleDateFormat.format(new Date(864000000L));
    }

    public int getDSTSavings() {
        if (this.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }

    public abstract boolean useDaylightTime();

    public abstract boolean inDaylightTime(Date var1);

    public static synchronized TimeZone getTimeZone(String string) {
        return TimeZone.getTimeZone(string, true);
    }

    private static TimeZone getTimeZone(String string, boolean bl) {
        TimeZone timeZone = ZoneInfo.getTimeZone(string);
        if (timeZone == null && (timeZone = TimeZone.parseCustomTimeZone(string)) == null && bl) {
            timeZone = new ZoneInfo(GMT_ID, 0);
        }
        return timeZone;
    }

    public static synchronized String[] getAvailableIDs(int n) {
        return ZoneInfo.getAvailableIDs(n);
    }

    public static synchronized String[] getAvailableIDs() {
        return ZoneInfo.getAvailableIDs();
    }

    private static native String getSystemTimeZoneID(String var0, String var1);

    private static native String getSystemGMTOffsetID();

    public static synchronized TimeZone getDefault() {
        block8: {
            String string;
            block9: {
                String string2;
                if (defaultZone != null) break block8;
                string = (String)AccessController.doPrivileged(new GetPropertyAction("user.timezone"));
                if (string != null && !string.equals("")) break block9;
                String string3 = (String)AccessController.doPrivileged(new GetPropertyAction("user.country"));
                String string4 = (String)AccessController.doPrivileged(new GetPropertyAction("java.home"));
                try {
                    string = TimeZone.getSystemTimeZoneID(string4, string3);
                    if (string == null) {
                        string = GMT_ID;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    string = GMT_ID;
                }
                defaultZone = TimeZone.getTimeZone(string, false);
                if (defaultZone == null && (string2 = TimeZone.getSystemGMTOffsetID()) != null) {
                    string = string2;
                }
                string2 = string;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        System.setProperty("user.timezone", string2);
                        return null;
                    }
                });
                if (defaultZone != null) break block8;
            }
            defaultZone = TimeZone.getTimeZone(string, true);
        }
        return (TimeZone)defaultZone.clone();
    }

    public static synchronized void setDefault(TimeZone timeZone) {
        defaultZone = timeZone;
    }

    public boolean hasSameRules(TimeZone timeZone) {
        return timeZone != null && this.getRawOffset() == timeZone.getRawOffset() && this.useDaylightTime() == timeZone.useDaylightTime();
    }

    public Object clone() {
        try {
            TimeZone timeZone = (TimeZone)super.clone();
            timeZone.ID = this.ID;
            return timeZone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private static final TimeZone parseCustomTimeZone(String string) {
        char c;
        int n = string.length();
        if (n < 5 || string.indexOf(GMT_ID) != 0) {
            return null;
        }
        ZoneInfo zoneInfo = ZoneInfoFile.getZoneInfo(string);
        if (zoneInfo != null) {
            return zoneInfo;
        }
        int n2 = 3;
        boolean bl = false;
        if ((c = string.charAt(n2++)) == '-') {
            bl = true;
        } else if (c != '+') {
            return null;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n2 < n) {
            if ((c = string.charAt(n2++)) == ':') {
                if (n5 > 0) {
                    return null;
                }
                if (n6 > 2) {
                    return null;
                }
                n3 = n4;
                ++n5;
                n4 = 0;
                n6 = 0;
                continue;
            }
            if (c < '0' || c > '9') {
                return null;
            }
            n4 = n4 * 10 + (c - 48);
            ++n6;
        }
        if (n2 != n) {
            return null;
        }
        if (n5 == 0) {
            if (n6 <= 2) {
                n3 = n4;
                n4 = 0;
            } else {
                n3 = n4 / 100;
                n4 %= 100;
            }
        } else if (n6 != 2) {
            return null;
        }
        if (n3 > 23 || n4 > 59) {
            return null;
        }
        int n7 = n3 * 60 + n4;
        if (n7 == 0) {
            zoneInfo = ZoneInfoFile.getZoneInfo(GMT_ID);
            if (bl) {
                zoneInfo.setID("GMT-00:00");
            } else {
                zoneInfo.setID("GMT+00:00");
            }
        } else {
            zoneInfo = ZoneInfoFile.getCustomTimeZone(string, bl ? -n7 : n7);
        }
        return zoneInfo;
    }
}

