/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.dd;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Adamek
 */
public class EjbJarXmlWizardPanel1 implements WizardDescriptor.Panel { 

    // generated by apisupport wizard
    
    /**
     * The visual component that displays this panel. If you need to access the
     * component from this class, just use getComponent().
     */
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private final EjbJarXmlVisualPanel1 component = new EjbJarXmlVisualPanel1();
    private final InfoPanel infoPanel = new InfoPanel();
    private WizardDescriptor wizardDescriptor;
    private Project project;
    
    public EjbJarXmlWizardPanel1() {
        component.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                fireChangeEvent();
            }
        });
    }
    
    FileObject getSelectedLocation() {
        return component.getSelectedLocation();
    }
    
    Project getProject() {
        return project;
    }
    
    public Component getComponent() {
        FileObject selectedDDLocation = component.getSelectedLocation();
        if (selectedDDLocation != null) {
            if (selectedDDLocation.isFolder()) {
                return component;
            } else {
                infoPanel.setText(NbBundle.getMessage(EjbJarXmlWizardPanel1.class,"ERR_FileExists"));
                return infoPanel;
            }
        } else {
            infoPanel.setText(NbBundle.getMessage(EjbJarXmlWizardPanel1.class,"ERR_NoValidLocation"));
            return infoPanel;
        }
    }
    
    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }
    
    public boolean isValid() {
        if (component.getSelectedLocation() == null) {
            return false;
        }
        return true;
    }
    
    public final void addChangeListener(ChangeListener listener) {
        synchronized (listeners) {
            listeners.add(listener);
        }
    }
    
    public final void removeChangeListener(ChangeListener listener) {
        synchronized (listeners) {
            listeners.remove(listener);
        }
    }

    protected final void fireChangeEvent() {
        Iterator<ChangeListener> listenersIterator;
        synchronized (listeners) {
            listenersIterator = new HashSet<ChangeListener>(listeners).iterator();
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        while (listenersIterator.hasNext()) {
            listenersIterator.next().stateChanged(changeEvent);
        }
    }
    
    public void readSettings(Object settings) {
        wizardDescriptor = (WizardDescriptor) settings;
        if (project == null) {
            project = Templates.getProject(wizardDescriptor);
            component.setProject(project);
        }
        String displayName = NbBundle.getMessage(EjbJarXmlWizardPanel1.class, "LBL_DDWizardTitle"); //NOI18N
        wizardDescriptor.putProperty ("NewFileWizard_Title", displayName); // NOI18N
    }
    
    public void storeSettings(Object settings) {}

    private class InfoPanel extends JPanel{
        private JLabel infoText;

        public InfoPanel() {
            infoText = new JLabel();
            add(infoText);
        }

        public void setText(String text){
            infoText.setText(text);
//            revalidate();
        }
    }
}

