/* ----- decode/1277x7879, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_1277x7879_checksums[] = {
  "ef434ea80eacf64891b1b1669b5890e42744786121d3f9553adfd77f99964487",
  "65e3512604821bd72c2c8ebf3dddde91ce916265e81b1d9e24d6b96c0f9ed4a1",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_1277x7879_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_1277x7879_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_1277x7879_ITEMBYTES

static void *storage_decode_1277x7879_x;
static unsigned char *test_decode_1277x7879_x;
static void *storage_decode_1277x7879_s;
static unsigned char *test_decode_1277x7879_s;
static void *storage_decode_1277x7879_x2;
static unsigned char *test_decode_1277x7879_x2;
static void *storage_decode_1277x7879_s2;
static unsigned char *test_decode_1277x7879_s2;

#define precomputed_decode_1277x7879_NUM 4

static const int16_t precomputed_decode_1277x7879_x[precomputed_decode_1277x7879_NUM][crypto_decode_ITEMS] = {
  {-3183,-554,-1740,33,2706,957,-3539,-3758,1720,-3170,317,695,-3682,-3092,-645,786,3488,2118,1950,-799,-3563,2272,3750,-826,-1004,-3863,-3624,409,2872,-3815,3037,3242,-197,-3628,-2389,33,1590,-1093,1964,835,-1412,2077,-999,-2335,-3137,-1698,-349,3001,858,1976,-1363,-190,-2915,-2738,-2247,1710,1131,-3622,-3255,519,1468,-1503,-1561,-2055,3132,-2454,1158,1202,-835,2902,-358,137,2712,-1058,3092,2584,-1307,-1368,1801,-921,2282,-332,-2919,-3887,2790,-115,-3358,591,2778,2291,546,2294,-1834,554,933,-102,-2180,1003,-430,-248,-2499,-819,-2237,3560,-3123,-537,159,-1543,3637,3918,333,-2975,-3345,-1264,3316,3757,1928,-293,3897,1267,-1812,-1662,3103,949,-1443,-3577,-3780,3030,134,72,-1776,1056,2256,-3913,-2121,-1012,-751,1473,-2765,-3040,2708,2301,3619,-364,2993,-3291,553,-1329,3627,2870,602,1151,1353,-1555,-3272,136,-118,151,-1970,-563,2773,-691,-1067,-257,-199,-2906,1485,519,-1504,-295,2854,3627,489,2776,2556,-1350,804,-433,-1776,-2764,-2724,3867,1909,3014,3555,898,997,2281,1525,664,1073,-944,965,-274,312,-2573,-2055,-1261,126,502,426,2760,2765,-3936,-262,-3767,-1163,1250,2482,3928,1825,3097,-2052,660,3087,3119,2003,1432,-1781,164,343,-1315,-1226,-3714,2173,764,-221,-80,-3607,-697,-695,-1116,1929,2955,1511,2073,-1315,1007,1936,146,-1373,372,1132,2121,1859,-2409,-3385,-3169,1274,2762,2842,1874,3699,1240,-1961,-952,-2689,-1775,3137,978,-2620,-1487,3539,2691,-939,637,-1035,3183,1564,60,-1574,1563,404,-3737,1555,-3913,-701,139,2654,1448,-3505,3170,541,-2239,-2451,-1001,-3072,638,2219,1730,-1015,1783,-2139,3776,-1192,-3838,2294,-2187,-2396,3437,1420,2595,-3802,-169,-1411,2982,-3581,-699,-2966,-292,257,1701,1622,-1874,532,-2342,2329,867,-3908,-1265,-3650,-2991,-2278,2705,-3240,1175,-2958,-654,1669,-321,-852,516,2220,2657,-2926,717,-1858,1551,118,1104,-50,-477,-946,-3194,1177,-2232,3769,-3749,-954,3474,277,-1512,-328,3084,1635,1560,-51,1869,3075,-1862,3381,-673,231,2053,-3872,2676,1933,2358,-2317,-1940,877,2489,-2829,-2575,3807,918,-2321,-3770,2894,3777,-1065,-1604,1954,-893,-1900,3932,1497,-1010,-249,-2928,3621,2125,-2188,1555,-3147,141,-489,-2721,-2692,1935,1610,-435,-2451,-2564,1625,-860,-114,-1372,-1368,-1337,-1236,-12,2810,1005,-845,-1862,1925,795,3634,-869,-603,796,-1580,1057,3777,-27,647,-519,-1123,1791,-2250,-3623,-1383,-3748,3083,-633,-2059,-3321,2772,1159,3787,-3054,2333,3748,-2144,179,3272,2748,1507,-2064,1268,2787,373,-2220,1219,2395,3322,-3444,1704,-1782,-189,394,3556,2918,-3149,-2929,-3130,3883,-2677,-1907,350,781,1649,3172,-1444,-2044,-2079,-2669,2263,2712,-617,-1948,-3656,2850,-3110,-3263,-2748,1067,154,72,-3744,-2318,-1558,1100,-1598,-3566,480,2183,3469,-32,-1133,3546,3707,3695,3687,1782,507,3043,-3706,2870,-2703,3742,1077,1964,1746,-3152,-673,563,-2261,244,-1853,2265,2151,1002,616,3724,-1659,1913,1656,3580,-950,919,-2304,-2452,-1590,-2224,2545,348,-2958,-508,1601,2575,845,-3810,-330,1022,510,-3550,185,-3604,-1692,-1804,-944,-2749,173,-1282,3855,1872,-663,-82,-2058,3136,-3700,-3839,-2669,-2691,-3369,2596,2737,-354,-2098,-947,-852,-57,3837,-3223,-3062,-1975,-155,-1567,-2207,3868,1547,-106,3617,1623,2028,3823,582,-3140,1039,1710,2277,-1421,-1020,2814,3274,-3401,-1200,475,-218,690,3755,2878,-2526,-3045,-2705,2372,-3381,-31,2746,3804,-3000,-2239,925,-1181,-840,-3476,-498,3197,1467,3430,-3135,2578,-3766,-2214,-1769,-3475,-3229,652,580,2308,-1843,827,-3371,-1964,1832,899,2369,3270,-375,-1229,1931,-1932,172,1286,3055,-3884,-3408,1480,-60,-66,402,1211,-3226,3752,-419,-2620,2467,-3029,96,-2842,-195,259,17,3644,-1542,1987,2299,1123,1279,177,1619,2582,482,-601,1003,2570,-3829,-515,-373,178,2140,2668,-3441,-1175,1461,1957,-147,-1873,3700,-1241,292,616,-3215,3519,-2070,1990,1712,1633,-1899,2298,3589,-3052,2511,-1953,-5,-3217,-2443,756,1936,2563,1233,-2296,-2033,1129,942,2242,418,-448,-3124,2710,216,-2552,-1646,2444,-1100,-3378,-1676,2131,251,3839,-302,-584,2593,-3923,-1504,1019,-3137,2147,116,683,-2640,982,2679,-3333,-3506,1733,478,3234,-3136,1210,1991,-3588,-1902,-909,-2495,905,-187,2304,-73,3151,-3172,-3646,-1251,1584,3514,93,3490,-3725,1237,239,3715,-2925,3848,1650,1095,2677,2752,1925,2117,-2806,-816,-726,1017,-2066,-1628,-3010,-1212,-2476,-2505,2320,1761,-2523,436,-2247,-2896,-47,1577,3357,697,2268,295,1066,-1057,-1628,-317,-399,595,-91,2834,1918,3633,-1005,-290,1916,-2858,2906,-452,-2798,-2014,-1705,2087,-3664,1899,-1940,-2432,185,-3203,1553,2053,3006,1920,-2976,-2898,-589,-546,3260,-3247,-1563,-1987,-45,-3631,-1441,1229,2285,-285,2873,142,-1785,-1044,2206,1203,2763,-2800,2337,-1404,790,-2290,-3443,-217,-599,-1747,2243,-51,-211,-1698,2702,3506,-1310,2547,894,-464,2947,-1648,1998,-2632,625,1342,-2808,3271,-314,-1349,2898,-3084,-1416,2890,2237,-989,-280,-3763,3140,3355,2131,210,3341,618,1481,-2631,-1642,-319,-2111,2713,1231,-149,-3778,3432,-1545,2282,-299,-2941,-2371,-1302,1493,1183,916,3493,-1728,2117,3530,3533,-2271,1919,691,255,3714,-3126,-3011,3619,-1470,1129,3053,-72,3327,-1562,3747,1352,-293,2536,2805,-1562,1222,-3932,1541,2196,2072,354,-1937,-1023,2705,-3913,-1295,3894,-3303,-3074,-660,2258,-107,2599,2115,-844,-1802,-3462,1793,3264,-1635,-1579,-189,-3513,292,-413,114,-1502,914,-3539,-2326,-1835,3210,-1140,-1497,-408,586,3358,-2524,-1080,-1311,696,-2921,1151,-3911,-1111,1960,2051,2384,-40,-856,1616,-2900,659,-3324,-1219,2786,-3472,-3428,-1522,-722,-2210,-2058,-1632,3619,612,3456,-1719,-2762,3609,-3206,-2018,2997,1918,-2992,3563,2746,-3043,269,3114,-3518,-1129,2132,1003,-2778,-3144,3508,-852,3696,-2033,-3938,876,-3404,-1365,3292,1831,2874,3931,-494,-704,-3871,2200,-2582,-3839,872,779,-3577,1382,916,-2928,-2322,-3341,-3908,-1106,-1040,-2839,-2916,-461,3267,1904,2497,-1442,3689,-820,2725,-2025,3140,140,1420,-889,1279,1850,-3844,3729,1822,-1455,-2066,413,1581,-1210,2881,-2255,-1194,-3550,-3147,-3175,906,-663,-1471,3662,1395,1384,822,140,1753,-3686,1452,-2085,2269,3871,3605,266,277,3733,-2879,-2867,-3532,2162,2510,3154,-2239,2728,1897,-1751,-3198,-32,854,-3841,3520,3479,3004,-3563,-1273,1171,843,-2040,312,-642,1845,3396,-1313,-2963,3161,-887,-600,963,1329,-3259,-2753,-1747,3200,3494,-3488,2726,1501,-2856,2237,-1935,24,-387,1216,-1574,-1455,-3112,-1443,1122,-189,1633,-606,-357,-3419,221,2448,-1893,-3935,1967,-490,1549,-912,1470,-1777,-1984,-1333,2254,1879,3873,1311,-1680,3713,1387,-2254,3610,2546,1181,1729,3069,964,1177,129,-1847,3080,3320,-530,-519,2883,2587,-1103,2662,-2037,910,-1280,-2757,2489,770,-132,-2117,-2395,-1341,2930,2105,3766,-3644,514,3938,2207,-3150,2629,-3555,3126,-2689,-469,1964,3060,1245,-656,-1638,186,-3762,1092,2230,-3001,1004,2602,3765,58,1840,-3880,2382,545,-3775,-1659,234,-1191,-2094,1328,274,-669,-1507,368,1472,2036,2420,-762,-3574,-3624,2705,813,-179,2036,290,-3858,2287,786,-745,-3306,-665,-2699,2848,1027,-259,2983,-3227},
  {-2999,1576,-721,-2218,855,891,1993,-3902,-466,-1007,-2828,1142,-727,-1880,-475,1268,1698,-398,502,578,-3391,1398,-3535,-2656,55,2781,3119,3319,2214,3434,2353,-900,941,-3166,-1098,-3933,2439,768,-3269,-3907,-2173,2098,757,2510,3491,1585,-958,3508,3352,3280,-412,-3705,2755,2695,1979,-865,532,1013,2389,2880,3081,-732,-1323,1836,2262,-1325,2508,3460,-2565,-182,1286,486,-2792,-1639,3279,-2017,-3767,-2681,1020,-2291,3593,1126,-1350,1908,1490,-2995,-608,3496,3515,-2967,-3102,-901,-2903,925,-2954,249,850,-527,735,2784,618,2844,-348,2600,3696,-809,3636,3427,210,-291,-1652,-1233,-413,-2719,3739,167,3005,-2862,482,-37,156,726,-3735,-3903,-1949,2689,-3896,-1600,-1676,3640,3805,-3088,1018,1826,-1945,2870,-2507,3838,-3775,3658,451,2870,-1864,1022,1204,-1186,-2332,756,-1541,-905,909,-3488,1999,3079,-2045,2273,-3156,2669,-603,-3295,-2547,1842,-197,2025,-585,-101,1710,740,2485,-3421,-2917,-2673,1346,-3779,-2157,-671,-532,-1350,-3741,-3434,3839,-1872,3278,-506,-1066,-1223,2,-2051,2228,-1261,1747,3170,-2838,-2080,963,-2239,-2707,3379,-2473,-3185,1635,518,2471,2792,-1872,3764,3381,-3152,2621,2918,3665,-2937,2467,-3270,-3298,-1385,2992,1656,3845,1344,2667,-815,3096,-3312,-1484,-457,-899,-3389,-3905,-2686,1573,-3502,3079,438,-1199,-1643,3104,-1525,-2153,-2197,-2964,3442,-2670,2912,-2808,-2417,-891,-3503,2355,2577,-2921,-1060,-2584,-3168,-459,-2573,1263,-149,-1315,-673,1123,-707,-1445,-3234,-2641,-2450,-3924,1727,-1669,127,-531,360,-1561,3424,985,-1355,2057,760,3868,-1734,3465,2706,-3163,389,-2090,-622,2235,-1261,-2062,2349,3520,1516,133,3364,-1594,1366,-3475,392,-1323,908,-1092,-394,3282,-3712,303,3769,1423,-3929,1502,1475,472,2092,490,-2030,93,3066,-2518,-3275,2382,589,1119,-618,-1852,-3369,-2207,2277,2729,1034,2291,3415,-1110,-2870,-2204,-1440,-3450,2065,3923,-2571,2130,3217,-3337,1067,1,-3671,642,-1890,1326,-1833,-3782,469,-2698,1286,-2501,-2577,1219,1045,656,-2425,60,-1823,-3918,3164,-468,874,-611,3795,3207,-78,3528,3249,-2332,-2763,2743,-2254,-2824,-2032,1158,1704,-2091,-1418,-1127,-2526,3682,3236,-266,-1535,-1909,2551,-62,-3173,-2353,-2859,-3573,-1028,969,-2904,-1217,2624,1514,-763,-2545,-1921,-1567,-2663,-2320,-3915,-3622,-941,-1488,1276,1407,-75,-14,1763,-2944,1959,1746,-2518,-1532,369,-2249,3618,-3083,2648,-2026,938,-1625,-318,-3901,2311,-1402,-3087,-3455,-2889,355,719,746,2042,751,3151,3472,-2880,2622,-2695,2159,-3704,507,278,1730,2830,266,1752,3678,3013,-3067,2628,2039,435,3105,574,-2789,-89,-2508,2368,1855,-2819,-1106,933,-309,-615,-3366,-1519,-2406,-2133,-1416,-1148,1360,3493,-1093,2447,-1596,-881,2430,-2617,-2154,3899,-497,-2759,2105,-2898,292,89,2386,2322,-2096,2299,-1380,1325,-1487,1183,-3371,2766,-1227,223,-1621,-899,3877,3858,-3245,3744,-3660,-1461,-266,3899,-3120,-3105,3559,806,-2135,3264,-813,1757,2779,-928,1563,-933,-1534,-2379,589,508,-259,2304,696,1756,2748,-1847,-2353,-1188,-176,-1611,-596,-2884,-710,-3167,-3214,213,3931,2769,1130,3833,2811,-81,-1520,-3501,1935,-1247,-3889,-1226,2986,3527,395,-1029,213,3362,3634,2135,-2474,502,-1030,699,3478,-626,1765,2897,-2325,3423,717,-1645,3532,2825,-1696,-1582,3668,1995,150,-2308,2557,-1563,-1134,156,3838,-2129,2185,-545,1019,-1962,-1441,-2460,3422,-709,2519,-2983,1987,-495,-504,1492,-3619,-3218,-2539,-3281,-917,2788,2987,-2667,1618,2131,-2278,-2794,-3685,3479,-3264,-1501,824,-515,1754,-1707,-578,1115,-3224,1267,953,3222,-466,1741,473,-695,1774,1174,-1179,-1854,-2018,-2343,1600,-1405,-184,-3035,-3040,-3709,3138,-2949,-1377,3551,-1422,1905,-383,561,2403,-2679,-315,3841,3868,-3179,3194,3633,-3097,-2605,3736,2486,677,2902,-1530,3552,-3863,-3666,3591,393,-1735,-1490,-3571,-2325,341,3320,-3854,345,2185,820,1589,-3344,-2314,3659,-282,-608,2149,-2310,-2484,3439,462,3224,-3781,2032,3731,-3013,2066,196,377,777,1091,2272,-3268,-588,361,3859,-57,-3661,662,333,-570,-2493,-333,-1605,-458,452,719,3231,-3847,-3700,-228,568,1613,97,2920,-2863,2006,-1191,-3299,-935,633,-2084,184,-512,-2128,3422,2539,-1710,-754,-3493,200,-1346,-2265,1267,-3697,1774,513,3762,1527,-1797,-2196,2669,-2543,1906,3549,960,3310,2246,821,2395,1016,1823,-2012,3526,-3202,-2296,-173,410,-1278,-2022,-914,3297,1153,277,-3776,317,2889,-2150,1558,-3865,-3072,-2305,-374,1080,3551,922,-217,-2893,463,2488,-1792,3862,-744,-3377,1441,-2171,-281,2584,-1385,1958,2271,-1338,-2101,3255,-2043,3073,-1479,2749,-2356,1062,1862,-2254,-457,368,1907,-2796,2889,106,523,2777,-2806,3468,-3293,-3432,-2408,2666,-3284,2985,1903,-3252,1870,2531,1789,-1992,162,2750,-1337,217,2440,2650,1722,3308,-579,2634,494,2137,3243,-256,-2766,-2958,1065,1907,1097,2186,3769,1590,-1283,-2799,-3182,-419,-537,1565,-3726,-3915,-2044,3468,3583,587,1420,387,2241,-3732,-1738,-1362,3478,2656,-1692,3836,-120,735,822,-3236,-252,-192,-929,-3895,-3913,3461,472,-1540,-3762,1283,1336,1789,2377,-821,-3579,-1715,-3097,-938,2324,3404,2694,-480,-3064,-1490,-2407,-3747,-1537,-2220,-1011,2123,-391,-2480,-1498,218,2361,1570,-3280,2262,-542,-1949,2779,-2525,1386,-2051,-3745,-1149,-2750,3105,-3038,-2086,3755,-3649,-2010,3879,-505,-3106,1986,-1867,-3664,1395,1040,-3758,-629,1920,-875,-211,-3288,2825,-2798,2712,421,2238,-3059,1939,-191,-1489,1106,1060,745,3013,-104,-3120,1259,-3342,-3395,-2723,1138,3262,-2654,-2469,-1155,-562,2799,-2636,3841,517,318,-139,1110,-1274,-888,124,-875,-1559,-3291,1681,2288,-1388,3222,1258,-3284,-3919,-3806,1193,-1515,3656,2067,-2808,-645,-272,-1848,-2884,-366,3483,1748,-1202,403,-2557,-3087,805,-1326,-3322,3070,-3150,-1490,651,-1033,-1066,2140,-3469,3157,3047,1459,2507,2718,1514,1785,2977,447,-488,254,-3290,105,-1413,1994,-3196,-3318,123,-2003,693,-3234,3887,3820,1221,-2170,-3784,-3655,-963,-1155,-532,-794,-1850,2696,418,1132,2789,-2245,-3309,3572,2907,2446,2204,2736,-1654,651,-2918,-1743,294,809,-2449,2210,1503,1039,-133,2190,2801,1993,100,1465,-2505,-56,-1452,2520,-3903,2219,-2510,-2201,159,-3732,1760,-64,-258,692,534,-529,-199,2367,-601,-3304,-801,1801,727,-1419,-1921,-3573,1579,708,-385,3177,-128,-3051,-2246,397,-3346,444,725,-2859,3380,-3611,-2518,-2502,2459,1077,618,-1446,99,-1165,438,-2760,-1579,-3834,-3398,1137,-371,556,2065,2178,1075,-2643,-2614,-2212,-1982,1434,1228,-3882,-2896,3825,2492,-1008,-2680,1966,2946,2904,-848,-2719,-80,150,1647,-446,832,-1953,884,3005,-1060,-1153,1652,2277,-1498,2413,-486,-1118,2795,-2483,912,2884,-1049,-3807,-3508,1051,3839,2775,-3652,2127,907,318,508,617,-1584,-3579,-2795,801,-1278,-2197,-918,-2290,1155,-1620,208,3476,1848,1084,2444,-518,1125,3131,-791,3835,3792,3073,-2612,3094,-3597,-1045,-2827,1674,745,3136,-1222,3618,-902,1784,-3114,2891,1580,-3791,3855,-2722,942,-427,-3401,365,2388,-190,1165,3090,-2458,777,2680,3334,-1512,3305,3749,1442,-2900,1888,617,3399,-304,869,3249,1635,3397,1443,3790,3014,1650,-505,-2943,-2800,1786,3313,281,1526,-3357,3051,1751,-3506,3747,2106},
  {1603,1983,-1054,3054,-3083,-3016,1958,-2136,2578,1178,-2124,-3769,3350,613,-1919,-1456,3842,754,3853,-1837,-2503,-102,894,-2705,-898,2455,-999,-60,370,1229,2969,2150,-3904,3903,2944,-3615,-1008,-3635,-3507,-3752,2523,-2007,1591,-3718,-907,1981,-3326,340,-2381,-3709,-704,319,3858,2852,1764,-3261,-1165,-184,-3166,-3503,-3657,-463,733,3596,-3786,1640,879,-2679,890,-1265,3493,-1078,2228,1298,-715,2788,-901,3493,1737,-966,2011,-2442,3280,1885,-1037,-1476,-490,-2082,-2292,-3666,1074,880,2339,-3153,714,-3914,707,334,-1951,-1059,-471,-1825,-2253,2066,1464,-1435,-2713,-3677,3765,754,-1021,-3930,2033,-2233,3896,-1329,3549,-540,3441,-1232,-1685,716,2662,-1252,2756,-2197,3761,636,603,-3841,-3179,2760,-1050,477,-1512,-3131,-2436,-1916,-1312,3592,3406,-3097,3157,-3022,-3147,-2149,2245,279,1481,-1976,890,-2373,3572,-3856,-1052,-2892,-1823,1865,1143,3698,-1813,324,-1789,-1761,-3611,-3808,2324,2301,-3498,-2856,2727,-2435,-1701,-1607,1731,2126,1401,-323,-827,3786,-2919,-3488,-1973,2643,410,-3873,-564,3658,-1308,2495,-298,635,-884,1567,-158,1902,-821,2394,2133,1405,985,684,1362,1386,3725,-3260,-211,-3846,2142,2626,-1485,1167,-1699,-3937,490,2838,-407,1471,-1889,3687,-3529,-3600,2261,-2078,84,-3244,2257,1081,2835,1491,-3857,794,1904,2522,-2964,3152,1280,-3206,-2503,156,149,-1402,-1533,105,1454,1532,-1721,-2118,-1955,-3490,2491,2077,-3547,1824,2635,-3930,1736,-1878,442,1366,2589,-2179,3067,1708,3088,2877,-1424,1399,3825,-654,-2914,-2222,3571,-1486,3675,3735,-3123,3692,976,160,585,932,804,-679,-2674,-426,1329,2988,-3639,-3744,2807,-1704,2115,-1216,1582,2993,-200,1487,1080,325,-2960,721,-3891,188,-1057,-3076,683,3424,2969,-1967,1618,2991,-1207,-1939,441,2747,289,3670,-740,3522,1776,-1926,-2785,564,2568,885,2039,-3485,-3080,-3935,754,-3101,-3912,-1908,-2642,1540,1301,-2941,-3374,-832,3735,-3335,2525,690,2174,3788,-2036,1416,-2013,-937,-3152,-858,-2549,-3643,3129,-6,-1421,769,1860,-2739,1559,3789,-593,-3286,1630,3546,2134,-694,2356,-864,-3082,2151,2153,-2365,1267,-239,696,29,2765,1335,-3076,-2943,610,1523,196,-1188,802,-1679,-2512,409,3398,-90,741,-46,1051,-126,10,-2847,-1885,-3903,-2806,-828,-3548,776,2672,1088,-2044,348,-1076,-926,-842,-2823,410,-1383,-1516,-3925,-1794,-3359,3356,1400,-1454,-2438,-3508,-3747,2618,-590,1434,1640,-2639,-2284,-2717,2178,-2386,988,-1987,-898,1046,-439,1073,5,-1559,492,-1333,-2072,-993,-3610,1217,-3911,3727,3262,3463,1920,-2255,2624,2972,-1686,-3773,810,-143,-2595,1397,2894,-1812,1737,788,3310,-2360,-2072,-2663,-359,-2135,-342,1687,-1172,1719,454,-2667,-3666,3334,-1826,-501,-1296,-953,1233,-408,-641,1633,-3739,-1890,-3726,-647,3695,-1811,3711,3526,2353,544,2670,2696,3548,-3619,3541,3691,-2568,-3061,613,2252,3485,3730,1574,-2780,-3313,2736,-1190,289,-2998,3550,-2477,-1195,-94,1181,-1125,-1353,1794,-3368,-3581,-1652,387,3548,-1949,2451,-539,-1093,-3421,467,-265,-246,-1611,2039,1176,1283,-3041,-1077,-3167,-1671,406,2856,1863,1612,2449,3472,3227,818,-255,1960,3148,-812,-3386,-3169,1089,-2812,2488,2208,860,2410,2766,-1582,-3332,197,-1368,1836,3594,-3206,393,3398,1322,1407,3544,2679,-334,-957,-173,2179,607,-1220,3856,3901,-1367,-2433,-2693,1214,59,-1866,808,-2437,-62,-2670,-2757,-2568,-1415,-1407,2212,-1716,-1300,-2592,-2690,3096,-9,-2413,3566,1066,-2956,-2681,-3450,-201,2825,3626,3148,-345,-726,-65,-3283,-1392,-3869,1580,-604,-469,1608,983,-3529,594,1751,163,-997,-3033,3052,2375,-2827,-3433,-2495,582,-2614,1722,-2167,-3456,-2920,3293,1001,3752,2088,-2975,2055,1885,3472,-2300,1207,-3471,470,522,-2866,-1002,3611,-2365,237,-2341,-223,1500,-152,-787,-1302,-491,3009,2560,2683,2340,-1578,3114,2064,2988,3912,1241,3376,470,127,-1566,2108,3563,3688,-2672,1552,3429,-3264,-303,-307,1829,-3241,2077,-1912,-2002,-3047,-2586,3736,3057,-3429,2179,-3137,-554,2461,-247,3260,2885,1632,3083,1961,-3499,-668,-964,1609,3043,-1272,-1460,3156,2385,2563,1672,-1824,-3853,-2839,-118,339,-1463,2979,-525,2982,3181,53,893,-1752,2457,-3337,-3362,-1499,3413,1229,-3365,-3765,1174,530,-2857,-2681,3894,3458,-193,3656,3374,-552,1116,1430,-3166,3765,-2689,1505,794,-3831,-1948,1404,2998,1509,-3446,-303,-932,-368,2274,3795,3159,2035,-384,2394,-2716,3377,377,3890,1622,-1626,3273,-3548,740,-2388,3343,-1881,-3414,-826,455,1171,-860,-371,1230,1510,-1871,2845,2556,-1121,3046,804,41,2701,-1648,2060,3295,-1845,2841,865,1068,-182,973,-624,2608,2176,-3886,3838,-3386,623,-2414,-1624,1425,3694,-487,-113,473,3086,-28,2213,973,1797,2142,-2114,3642,-1035,-2271,2074,2802,481,-2887,3611,3281,-2262,3892,2195,1246,-2451,929,3569,-1786,1383,-3641,3307,38,917,1838,2126,-1511,-1386,3625,3373,-3210,3002,-3076,54,-736,-56,-3541,982,-2511,693,-951,146,3370,-1731,-1014,-250,3285,-1423,2637,3788,2186,-3310,-298,2311,2611,-1967,3323,346,571,1371,531,1179,2099,-3762,-299,-3286,-2713,-3334,-1648,360,-3183,-461,1128,3369,1326,-1092,-655,-2609,-502,3423,1154,373,2245,-3079,3904,3149,-884,-3246,-585,-664,-2250,-178,-3149,-2598,1616,1633,1981,-2268,-1293,-3122,-1915,459,2187,3611,3191,-1063,803,-3865,3569,-1058,-2114,3183,3014,-1339,-289,-871,3044,62,2084,-1562,-492,2626,-581,-482,-3224,-2135,-1838,2421,-3907,-1222,-3855,278,-734,340,387,1092,-1434,2406,2513,-1789,-1718,-2784,-705,-3787,-441,-772,3199,3634,-3592,-2747,2672,-3370,586,459,1347,-3118,2888,-526,-3684,1363,-757,-1679,-2973,-3459,3781,-3208,2270,-1353,-1579,3058,-3008,-2687,-854,-1770,-1453,-3170,-522,-1713,3358,3064,1753,2608,1832,3909,2278,-3702,1025,-2555,2478,-1520,1056,-2163,1066,-1129,-3570,2946,-3827,815,-3288,-1115,-402,-2568,2831,-916,2915,-3106,404,-439,-3119,1689,3327,711,-1367,1375,-2576,3669,-2305,-335,2543,3187,3922,-3546,-1131,941,3196,-2321,-105,-3435,202,-937,-386,276,1740,1112,3283,-2452,3905,462,-812,2703,3823,2179,-2474,-3272,-2685,605,-1264,-1570,-1186,-3182,3284,-3568,-2189,501,1163,1242,-1475,-3487,-1657,-920,-3453,378,-2322,3515,-478,2734,-1396,-1751,717,-417,995,3215,-1726,-3742,-1878,-347,-1941,2349,-285,1687,-1751,27,-2631,-2552,-2293,-1092,1085,36,3368,171,-1612,-798,2990,-2803,-1859,-3649,1605,1908,3610,976,-2173,-649,-1947,3142,2881,2388,3871,2227,1946,-1350,1896,1081,-2440,1239,671,1305,376,-1685,-1282,3494,3030,1539,3494,3729,-631,1344,744,2496,1200,2983,-123,504,939,3091,2895,276,-2459,1472,724,-2601,585,2716,-255,2710,455,2426,1441,2011,2338,-3900,1401,2575,2769,-2454,-229,-1895,-2753,-2167,2469,-2572,-3457,2961,982,-2962,-1209,1556,-2792,-1163,-2396,3612,-3061,308,2707,-2471,2401,1176,-1317,-1326,1122,3170,-2288,1123,3166,-779,-3642,-847,-1599,2031,3868,-552,3495,3331,-1804,-1080,1711,-76,2711,-3653,-443,633,-3822,-2409,-2578,-3083,-1946,-3450,1541,487,-3741,1243,-2888,-3031,1400,3494,1050,3759,-59,-3415,-1163,3022,969,2497,-2529,101,-1581,-1270,-601,-1057,3559,-741,1440,1428,-1762,-2047,-51,1842,3576,-1428,3769,-1436,3021,421,-2210},
  {2429,-2530,3067,627,-893,3514,-394,274,3624,-1910,1865,291,3595,-898,1453,-542,-235,-191,-1756,-3305,2467,-301,2465,-716,196,710,-1186,-1889,2551,-425,314,-960,-2683,-3304,-1818,2248,-1390,-737,1077,2320,-2782,-3071,3917,-549,3514,-511,430,-2715,3710,-3763,-1505,1020,-2766,2820,-3370,-653,1713,-1682,1296,1188,2920,-3904,503,-981,812,-2711,1953,-3034,-145,-721,-769,3519,1755,-3579,-992,2288,3051,-242,-170,-900,878,3671,-1101,-3525,696,-2998,1970,3104,-2278,-2702,2427,-3921,3917,117,-708,-3545,2165,-2458,-382,-3224,3283,2556,-3546,-1224,1643,-614,2941,-827,2666,-2433,1294,3649,-1831,3250,3717,1023,-2734,-1313,-2197,340,547,-3417,-2173,2322,-1853,54,3056,-959,3680,-3462,-1674,1683,3844,-875,2668,-3251,-623,-3541,750,-1346,-3925,-2115,-7,357,3062,-1446,3537,3098,-2030,2596,-276,-2494,2659,2338,3939,-1607,3544,2556,3774,-844,2456,2745,865,210,2943,-3249,-1716,-3603,-3930,-3048,-924,-3388,-2933,-839,3199,-3836,-1042,1483,-1703,-1745,2296,1985,-3169,3754,1994,2984,3655,-1141,-1175,385,833,-3822,-3695,-3388,2943,-3645,435,-1087,2174,-3772,-1821,336,3524,2906,1114,1563,-2353,2601,-503,756,1692,-2839,3909,-1747,-1910,-2367,-1615,1394,-2317,1412,29,-525,2949,-375,-2141,-1957,-3435,2829,-1537,3222,-1643,3141,-2236,3006,-2723,-2894,-2208,-2185,1601,-264,777,1011,1244,-2936,2066,2954,3781,192,-3452,-3426,-2435,-2759,3676,2800,1410,-2737,1002,1377,-2911,3012,1308,2820,3004,-2349,-834,-2017,-2805,-3504,-3313,2704,-3532,-2339,-927,-663,1892,2584,2249,465,608,1436,-1461,-2594,3929,-363,555,-3721,3862,-2191,942,-931,-3874,-808,-907,-775,1636,-3495,-2210,1262,-2513,2276,-3157,-2167,-1436,-3440,3736,-587,-1846,2470,-2701,-2913,3266,-1727,110,-1372,-3660,1480,-660,53,-915,-3817,-239,3111,591,-3731,751,1600,3551,-3913,3925,2125,-360,2668,3838,-2889,-1233,131,-953,-725,1247,2967,-3741,2623,1239,1963,-1942,2057,2030,1875,3327,-792,1349,-1171,-397,-3904,-1617,3562,-3048,2316,1586,65,968,3638,-3821,-3609,-2046,-2412,3838,779,-2536,-2965,-501,3836,-1738,-1938,2971,273,-2699,329,131,-1041,-824,-2358,-1243,213,1198,-2088,-931,3266,2826,62,2404,-1849,666,3007,1435,1632,-3706,1719,-2477,3235,-1917,-1086,-2428,-2877,-971,-2570,-2687,3853,418,-1797,-1922,-613,2049,-248,-794,798,-2698,252,1660,-2223,-1732,1866,-2579,1893,-1585,3770,2010,1279,3166,2241,1170,3777,644,-40,-3601,-2219,-197,-3927,-1174,572,-3421,-2484,-3741,-2139,1274,2148,759,-654,3191,-1213,-2910,1659,-1495,1939,-2861,-3661,1423,-441,319,2638,-2333,-1323,2650,-3733,217,-1165,-2476,1340,2294,3107,-3615,3472,-2965,2617,-2378,-3697,3647,3780,-1416,3002,3589,-2641,-1602,-329,1302,-321,3152,-3229,-2294,-3214,2658,2259,27,1188,-3410,-3922,-305,-1871,-2756,-3002,2499,-1962,1082,2825,-2328,-1106,-956,-2625,916,768,3854,-1368,-382,-2782,3003,3163,-1024,-3270,371,-3875,-1756,2761,2073,-2971,-2697,2699,-3179,1298,2543,80,-1470,1927,-1923,1285,760,-3324,1068,1951,2181,1335,763,3543,-649,2401,-525,-2762,3289,-2654,2564,119,-1796,-330,1250,-484,499,3839,3539,-3590,-3290,3919,-1308,1908,2509,-283,1747,2629,1144,3880,-3357,-3475,-2720,967,1349,-1011,1859,1931,3780,-86,3587,-425,-223,-1221,624,-3142,-354,-1636,-1724,1292,-1258,3070,-2240,1207,-3822,373,3083,2914,-3718,3345,-1261,-1153,3715,1063,-985,-1144,3372,1752,297,948,-2213,385,2592,-253,-644,2306,245,-1064,1459,644,-3464,-1448,3421,-777,-3634,-501,1905,2391,26,2376,3378,-2291,-2300,2998,-1878,-558,-3480,-1863,-1277,2406,1656,732,-2672,3225,3172,520,420,352,-1787,-3887,-2300,-1376,-425,-2259,3539,-388,2242,3524,3168,3713,-1973,-1982,-2515,-3754,3420,-2830,-3908,582,-104,-2395,-3768,2133,-2961,-846,3350,3053,866,-3760,-2336,2673,-1926,3822,2180,3136,-3081,-854,2877,-1332,-1696,3686,-3748,-995,2657,-2364,595,1034,-2899,279,2553,-3593,-565,-2998,1988,196,-1839,-1154,3582,-2134,-3699,-3938,-3386,-3915,-3230,-3266,-2024,-960,-2197,-3547,-2432,-2121,2906,-2154,-569,-2586,-374,1795,-1611,-971,-481,-2243,-1375,349,975,-3295,-466,-877,-3037,-2599,-261,2572,1225,-497,2880,1434,2432,-1989,-1946,1842,3733,2826,-2630,-3394,-2110,-1335,2928,1981,3910,3784,-3082,1908,-1937,-1253,-2424,3680,3098,-3277,-1279,-2705,-2342,-1472,-3831,-715,1090,-70,-3551,-3536,1636,-976,-2762,-1457,-3933,-851,1803,-3008,-2321,-2941,1063,-3705,2347,-3502,1649,-3515,-2950,-3681,3467,-1764,-222,1575,-3029,-1780,325,-303,-243,1116,717,-3244,2554,-220,2215,-1451,3023,2177,1024,-500,-3354,-477,2502,-269,-3102,722,-3474,-2433,-3423,3709,-3188,-852,-1693,3592,-2073,-3550,-493,974,-1703,-1686,-1086,2781,-2059,3914,-1605,2330,101,-2863,1866,1655,-722,-2123,3586,-3434,-3487,-1616,-3265,2380,1609,3873,3221,1575,3384,-2046,-750,-2361,-1978,2695,1746,298,3470,907,-1727,3368,-2502,-1881,-2326,-2018,475,710,-338,458,1720,1761,2631,3145,2911,3505,2039,-1105,-1369,-1989,-1004,-551,-3866,1165,-911,-2597,372,-3291,1112,3064,-2599,-507,3817,654,942,3271,2781,-3198,-1594,3237,550,-1654,2721,-1609,897,-1665,-3852,2157,3287,-3078,-457,447,-2846,2562,2904,2943,2720,-2627,-1119,3134,350,3686,2631,-1487,-3638,3005,2635,186,3891,-2765,-3685,706,3233,-1026,1302,-2067,-1404,-286,-710,-2269,-3729,3143,3650,466,3357,3178,-1760,1464,699,2905,2855,-1024,-3308,2251,2522,1935,967,2835,2685,-951,140,-2591,-1990,1151,-1300,158,463,2867,2044,-3619,3818,3531,827,1400,-2722,-2929,-1586,2863,3364,3463,-2899,3285,3176,-2293,1794,1883,-2243,-1117,1009,-2939,3102,2219,-990,-1787,1336,1175,-57,1239,1442,-3674,1858,2577,-1142,-2158,-266,2203,2597,-3179,2354,-929,-2706,-3337,1921,-3739,2467,2850,-3379,1000,64,3388,-3824,-3469,-856,95,1330,-1114,881,1959,-2141,850,2113,1155,-3013,2581,-2432,3071,-629,49,-744,606,-3906,134,-2518,-565,104,-3428,-441,-2719,1776,-3736,-838,-2594,-3495,-3744,-939,2747,2566,-1222,-96,-815,-3149,-39,-3143,2551,1165,275,-444,-3073,-1304,1515,-2244,1742,1485,3195,3781,-2645,-691,817,3788,-586,2755,-1714,1524,-1188,2355,2452,1196,2737,2140,460,3369,202,2955,3679,3560,3074,2080,588,-256,-3914,-479,-3243,3839,-120,-2157,416,-1449,3035,-1973,-1459,-66,3709,-1103,208,-2755,2841,1805,1438,92,-684,2396,-518,-2446,1060,1749,2513,1829,2581,-2919,896,1019,1892,-3595,-924,2521,2169,-1150,624,1666,-483,-2807,-3022,-2636,-3472,-2469,-1877,615,-3703,599,-1470,-3352,-3275,1973,-1494,-1425,-383,788,-807,3106,-37,-2065,-3469,-1320,-3252,-784,3884,3152,1725,2027,-106,1908,-2834,-2807,2575,871,1507,3708,91,1240,2621,3559,3596,-1542,-1874,125,2348,1157,-3766,3566,3270,-1325,-769,-368,-3495,-385,596,731,-3697,-1126,1361,2257,2530,-1280,-900,359,2056,1577,-2035,3190,104,1119,-1342,3798,1104,-3773,-1753,-3296,3342,-3283,2116,-3442,3381,1312,-1562,3120,3005,2122,-2569,-1979,-2639,-1927,2665,-621,1924,-733,189,1789,-289,1092,290,-2010,-1946,2696,3732,35,-3710,2425,-2824,-1963,-2134,-307,721,816,-2683,1785,-2844,-889,-93,3137,-775,-3174,2400,-68,-3379,-3268,177,-584,3265,-518,2309,958,-3587,757},
} ;

static const unsigned char precomputed_decode_1277x7879_s[precomputed_decode_1277x7879_NUM][crypto_decode_STRBYTES] = {
  {67,248,51,144,213,183,67,196,226,137,214,46,106,213,209,27,98,79,221,151,141,183,232,95,139,46,31,189,255,2,91,111,95,114,170,141,235,61,25,10,95,78,88,226,41,111,202,104,186,50,83,194,151,103,211,43,57,48,18,248,187,242,206,137,250,163,60,38,239,127,113,22,130,119,20,84,213,34,114,236,46,190,104,68,217,214,163,159,23,25,180,108,212,50,179,95,129,44,226,204,240,30,243,149,182,3,134,30,47,183,12,246,183,155,199,90,29,109,118,1,82,200,42,195,38,143,238,215,214,71,72,141,105,56,99,236,112,179,107,25,151,76,135,234,204,2,106,218,125,184,107,2,220,177,72,236,67,198,1,232,8,151,102,181,155,63,150,10,39,34,235,183,41,95,234,91,229,147,212,75,177,124,183,1,73,163,92,222,117,121,185,37,31,178,117,74,22,253,16,250,122,114,133,118,17,188,123,226,114,230,232,251,96,240,240,165,83,208,223,79,122,136,128,23,185,129,75,0,114,197,29,113,238,233,174,222,254,170,102,52,39,83,131,162,252,7,184,148,88,179,48,247,179,193,167,35,14,47,215,63,51,207,0,51,216,48,150,71,24,220,47,130,253,89,172,53,168,82,78,191,213,173,252,114,166,61,74,71,209,164,98,247,61,142,62,47,65,186,183,203,25,160,31,63,223,27,254,135,198,120,156,32,240,88,226,16,102,228,189,122,13,250,41,203,17,214,104,243,86,14,32,165,107,23,69,199,191,15,254,89,91,70,208,156,233,76,206,245,28,68,21,217,100,99,99,50,0,82,241,207,102,195,34,114,100,72,223,35,63,90,148,223,162,0,209,11,177,87,173,192,83,196,207,74,112,80,19,56,79,154,88,39,145,137,168,134,72,124,253,54,125,89,169,84,45,65,98,172,177,220,48,41,141,125,161,192,218,58,7,52,193,79,211,172,28,111,110,60,46,237,61,4,117,0,84,145,190,83,29,1,33,132,241,65,29,28,68,12,203,128,193,180,25,187,216,147,38,159,198,104,225,252,134,125,52,112,139,103,126,80,209,133,133,255,208,220,126,182,87,180,171,106,126,52,185,72,9,220,234,71,214,226,86,216,24,225,41,20,5,212,97,235,28,232,249,234,200,120,216,155,155,117,65,194,250,179,92,76,47,236,202,230,165,30,148,88,236,149,180,12,3,24,76,204,82,56,205,127,230,128,66,57,247,148,128,124,196,213,133,86,104,182,189,28,119,127,151,189,3,193,14,157,171,6,22,15,43,172,219,26,1,189,181,193,244,50,33,34,164,58,125,157,253,230,26,205,13,69,194,32,169,56,162,209,206,234,99,202,229,181,220,146,53,175,119,128,163,192,10,216,22,255,39,101,234,166,4,182,145,248,93,3,23,131,152,99,42,209,143,245,184,27,2,5,121,115,85,187,131,202,134,220,15,97,174,59,19,184,128,128,206,175,71,56,86,167,17,161,104,128,130,242,234,193,13,184,231,123,72,171,238,235,197,16,11,96,9,157,14,166,65,4,168,105,134,78,80,236,206,112,29,123,84,175,66,164,44,214,111,249,67,222,233,192,0,221,156,220,121,121,61,201,97,155,6,83,212,45,186,196,190,97,104,208,190,108,46,125,81,203,140,42,50,104,244,5,149,27,12,178,185,188,98,164,236,244,201,234,36,111,174,11,3,74,79,79,24,99,157,157,120,114,194,60,197,9,93,219,95,215,246,95,32,6,254,12,146,122,123,24,99,78,206,83,83,65,46,185,232,237,255,128,252,82,91,124,127,237,12,61,21,77,37,201,179,225,242,165,238,176,92,65,78,218,154,247,36,243,146,58,27,156,79,39,183,106,167,211,12,72,15,12,120,221,43,196,90,139,172,169,154,46,2,83,96,90,138,5,87,6,22,210,216,209,15,139,246,147,1,168,222,154,26,66,32,65,24,113,184,46,61,36,93,234,10,206,231,184,206,13,9,236,209,2,148,86,141,155,211,241,129,17,248,222,69,75,1,175,171,44,32,211,218,168,245,105,193,237,213,181,198,134,213,24,3,196,189,237,163,11,204,165,252,185,101,35,141,148,201,242,252,174,73,155,243,19,221,106,179,227,40,131,223,211,148,194,3,193,16,208,102,223,253,148,74,58,253,202,148,239,70,247,153,33,35,27,66,224,155,172,89,82,248,123,107,237,115,131,53,161,70,17,114,58,7,254,113,117,166,113,153,62,139,68,200,181,92,255,7,2,67,140,12,113,40,204,240,42,45,176,60,32,155,137,71,61,41,231,6,241,217,207,144,234,208,184,59,236,205,167,252,81,20,245,57,38,176,100,7,97,149,44,177,74,127,57,214,60,49,102,212,151,202,196,234,106,111,188,150,146,133,1,32,99,207,217,85,27,103,56,75,24,184,87,24,96,118,130,59,186,171,55,240,179,37,248,99,10,45,57,55,127,72,195,11,100,186,119,147,96,166,33,254,96,202,22,181,237,244,141,145,242,236,106,49,125,159,186,143,30,18,75,151,192,19,212,222,133,56,253,232,25,9,109,245,209,244,154,121,121,50,106,150,152,5,80,158,85,201,30,27,133,113,122,21,207,41,172,123,23,207,234,167,202,54,146,37,239,26,131,33,190,117,0,191,1,101,85,199,142,146,75,15,253,161,168,144,196,252,129,177,144,56,38,89,226,82,244,102,56,10,14,75,196,230,191,98,209,190,195,86,167,185,219,11,107,170,92,83,4,173,164,111,99,68,50,176,137,69,198,136,245,130,217,63,221,234,117,35,167,112,46,77,46,252,28,113,112,122,63,95,50,133,215,196,107,118,12,74,224,228,103,81,101,124,205,69,39,137,38,178,32,205,34,38,63,250,16,0,197,236,226,17,219,137,238,211,117,47,252,82,12,58,190,154,189,233,75,145,64,206,251,25,140,165,222,205,175,194,207,122,146,98,130,242,175,78,92,218,211,201,122,129,73,8,5,37,32,213,104,41,55,117,225,228,142,230,104,237,218,144,138,6,164,52,214,198,25,181,15,202,149,196,110,248,245,137,110,223,37,172,52,69,23,16,206,200,95,192,68,224,112,50,13,28,250,169,2,24,102,173,25,210,104,59,78,26,63,1,226,87,104,105,160,242,100,175,229,74,77,164,71,155,46,221,21,145,229,40,138,179,155,172,40,219,70,194,138,27,74,80,26,160,204,106,232,8,99,189,136,203,2,123,51,225,45,185,172,127,27,66,227,47,184,4,10,55,28,200,35,44,117,102,88,249,131,215,27,69,251,80,183,28,154,26,158,240,232,17,250,207,240,237,111,102,119,126,233,206,172,138,64,252,176,27,197,196,200,235,77,180,253,216,192,143,196,171,231,19,21,155,127,223,229,121,113,184,164,200,25,62,20,146,2,84,248,116,125,104,251,95,168,3,135,32,132,12,106,160,109,181,55,198,215,149,68,75,164,126,175,179,99,201,125,96,155,13,59,151,220,44,16,83,63,119,81,64,66,138,51,73,81,82,70,24,26,2,138,24,60,181,163,134,205,165,41,165,15,221,81,179,9,245,150,28,146,3,26,205,221,130,19,105,16,85,23,80,96,178,243,83,122,50,168,236,240,127,163,181,199,236,208,96,243,226,55,1,131,153,217,204,215,255,27,74,203,14,68,160,227,61,130,147,14,113,93,94,21,224,88,8,33,144,50,209,40,152,70,96,87,112,144,80,120,139,76,79,144,88,197,46,11,64,134,106,208,49,66,156,193,13,83,153,113,195,238,80,157,22,99,196,17,234,23,138,69,94,96,236,188,178,47,171,179,17,190,48,89,135,40,43,44,175,112,162,227,165,31,4,42,147,197,142,132,137,85,63,195,217,140,31,160,82,177,180,124,165,227,232,109,33,88,202,0,1,60,189,243,41,93,119,159,188,66,40,108,109,219,187,150,146,53,25,94,238,165,76,92,118,122,249,49,34,243,184,135,145,248,225,13,51,1,12,173,73,214,116,18,148,23,94,107,253,209,230,242,28,203,81,184,152,114,53,119,18,222,91,164,139,235,152,227,200,31,180,229,156,170,199,28,112,228,85,82,24,73,68,142,201,36,60,101,91,3,56,253,53,126,137,58,182,218,17,198,75,157,88,225,98,81,210,60,163,59,179,239,229,233,131,140,89,137,149,97,102,13,84,81,147,137,212,228,5,130,74,71,170,117,55,114,43,147,144,74,204,52,178,13,168,64,79,157,84,222,155,243,43,25,171,40,117,198,254,229,205,193,59,6,224,79,163,49,77,13,94,13,141,45,135,189,143,207,154,3,49,180,137,66,2,204,155,240,10,6,137,115,17,56,89,224,125,85,249,116,9,65,38,239,155,236,106,162,220,238,22,95,209,2,95,30,40,73,39,176,212,28,189,173,50,226,217,135,116,161,11,243,215,210,28,98,76,204,240,177,143,103,125,138,229,173,46,112,134,195,150,5,163,115,145,14,180,2,92,100,43,58,134,216,84,131,41,139,183,33,246,74,106,23,1,116,218,127,96,23,90,231,39,181,46,196,146,19,20,219,88,112,12,207,189,253,62,184,76,137,185,178,2,119,68,1,33,209,100,202,48,210,121,250,34,186,199,110,147,176,238,225,254,12,144,245,84,174,229,132,78,72,1},
  {185,12,97,244,76,193,239,137,189,140,6,224,25,151,41,15,152,204,156,30,211,164,233,64,90,247,136,177,100,129,237,116,243,1,195,195,223,253,126,219,185,209,111,101,18,59,134,90,32,2,173,47,12,171,172,168,223,106,109,231,93,170,97,85,51,92,192,162,217,179,40,18,95,136,64,46,146,62,111,52,171,12,62,253,5,147,144,234,178,248,215,64,12,201,93,131,1,71,87,86,134,140,20,51,233,106,129,175,245,163,109,92,34,186,196,193,83,150,119,46,78,232,200,84,2,224,96,52,84,54,197,109,192,42,185,162,255,0,31,88,21,172,130,118,30,14,232,121,212,203,133,75,152,210,66,220,191,115,164,121,67,9,178,18,140,120,66,157,194,95,28,56,5,81,82,235,218,79,85,183,39,159,208,214,125,146,5,11,209,13,89,194,98,131,162,116,106,209,216,171,101,236,87,83,244,29,93,186,223,121,154,148,17,135,215,15,80,194,29,67,58,174,224,124,77,168,106,43,37,164,59,159,217,83,124,19,5,84,28,117,98,99,138,172,137,255,212,118,194,121,243,35,160,182,114,71,116,186,14,177,38,164,197,203,137,8,125,48,140,221,29,229,223,62,228,187,41,6,138,54,95,0,96,87,172,207,216,13,69,255,140,239,217,14,248,210,125,178,1,196,206,60,170,102,86,192,184,72,203,249,100,35,64,147,11,59,181,217,129,120,81,87,61,143,188,86,199,249,236,56,8,144,92,119,21,213,30,150,97,106,188,217,184,71,172,104,167,69,37,243,120,48,92,196,110,70,217,22,123,116,142,243,234,176,250,220,61,75,183,72,111,104,237,173,192,72,118,128,231,28,95,235,54,185,21,19,228,72,151,38,186,221,71,250,185,129,87,18,37,234,32,162,40,113,251,232,183,111,108,1,138,160,191,147,169,24,208,236,51,246,253,142,181,237,148,92,205,93,140,102,53,120,26,62,164,17,152,33,176,117,40,110,165,168,127,88,109,13,252,225,74,66,217,233,57,134,116,243,171,173,68,225,76,70,66,189,73,198,18,174,105,243,223,37,108,149,235,149,60,203,69,174,135,8,203,87,182,234,211,62,171,83,168,209,69,252,239,229,34,211,79,28,230,105,46,132,123,129,11,177,89,235,43,95,129,71,201,147,65,0,246,215,211,24,48,122,13,150,137,180,85,157,20,191,83,156,171,194,91,240,40,227,185,220,93,46,42,149,81,117,92,237,237,177,142,187,33,43,179,178,0,235,155,209,43,91,232,239,175,164,80,106,52,240,28,29,106,221,35,79,246,102,121,134,210,37,88,192,46,92,95,185,58,34,45,194,115,217,147,111,94,8,82,36,44,253,183,175,246,32,255,202,214,7,47,216,140,174,84,211,205,29,59,184,69,109,211,169,165,229,171,255,225,236,240,18,224,202,139,181,37,232,109,187,99,189,77,170,55,33,80,132,161,160,240,15,58,148,228,101,71,125,233,113,68,100,106,142,215,133,126,162,131,210,222,236,83,118,18,12,117,197,121,10,77,61,29,158,155,124,158,133,19,240,237,8,78,59,35,220,200,113,198,55,208,10,187,201,128,225,134,146,68,123,201,170,51,229,104,168,234,244,192,19,37,188,252,231,12,79,55,119,93,119,164,41,213,21,16,18,26,255,1,20,35,171,210,205,100,233,233,215,183,233,108,154,127,119,7,187,117,23,48,178,74,146,105,206,102,128,14,138,97,233,144,130,173,252,44,241,3,173,87,47,255,250,145,117,106,117,237,133,164,207,47,191,114,230,89,157,92,163,231,70,249,255,33,204,100,235,36,10,124,24,174,67,124,170,159,219,87,129,7,105,18,126,54,132,163,246,86,26,227,112,219,174,27,240,221,41,172,61,206,176,214,64,134,89,155,72,117,140,3,229,40,245,230,231,231,114,11,214,140,24,53,51,202,195,125,227,48,135,164,63,185,43,13,251,208,217,142,253,160,198,57,252,18,151,28,137,246,85,114,168,20,124,251,207,59,185,110,244,56,98,25,206,128,230,190,244,34,113,60,27,163,179,178,215,1,118,244,206,255,104,226,132,47,76,104,25,109,16,140,109,65,224,240,201,124,251,207,240,241,50,205,49,109,71,38,214,99,113,232,61,127,52,146,160,175,176,170,176,34,155,166,19,100,222,160,133,97,218,96,51,124,207,183,191,247,9,51,193,60,214,137,234,88,121,68,132,12,46,52,171,84,201,212,233,27,106,217,253,101,35,163,16,99,233,68,222,103,91,206,35,64,55,12,91,212,55,180,246,147,221,169,114,25,153,62,254,216,11,220,174,120,142,191,245,224,22,94,191,190,106,255,91,56,232,63,226,103,121,102,169,124,202,73,165,40,50,206,234,199,241,88,196,9,43,42,162,78,208,153,209,19,241,202,52,83,90,4,166,61,103,221,172,210,123,108,14,55,109,225,228,88,180,228,40,138,154,38,213,150,176,104,103,201,69,130,13,134,166,208,102,213,88,65,72,131,141,231,91,167,202,153,239,227,215,15,55,243,239,167,128,69,67,35,191,244,10,100,9,187,228,127,229,11,81,2,78,134,71,254,100,109,71,32,104,20,213,128,183,137,246,55,162,90,164,227,222,25,59,3,55,199,143,251,58,167,161,149,58,45,141,141,209,172,45,83,155,180,178,122,179,113,50,176,138,7,253,41,57,59,114,180,154,116,217,104,119,213,221,178,146,3,146,237,164,83,57,182,187,1,55,174,193,80,60,170,69,215,158,50,7,248,212,238,187,17,185,53,174,180,40,169,213,6,229,132,100,174,254,87,212,79,32,84,62,94,12,29,75,188,9,166,203,190,76,184,116,195,13,100,46,91,12,111,20,72,31,117,201,71,26,93,81,193,228,20,145,47,121,78,211,128,207,249,85,24,244,186,215,188,58,54,69,0,176,71,221,155,66,219,100,211,62,219,245,30,179,103,168,226,186,79,183,235,182,152,44,28,51,10,38,30,22,35,70,87,172,103,148,135,184,109,137,191,246,127,82,64,166,82,78,237,207,95,175,116,32,84,217,218,161,207,78,189,225,132,206,178,193,145,16,141,249,134,34,179,49,46,184,38,167,62,223,67,152,29,7,37,198,218,119,101,201,59,210,205,148,228,182,65,111,254,34,52,229,110,40,118,46,171,50,80,250,1,158,5,121,183,111,40,128,60,129,139,4,111,45,5,33,216,33,226,46,127,104,71,34,3,51,112,6,192,142,132,40,209,111,129,227,191,102,213,141,39,128,153,30,143,228,225,201,81,178,185,137,5,194,45,43,216,251,77,197,20,36,28,184,78,65,239,132,232,145,0,132,94,254,62,236,107,202,192,92,208,65,70,249,51,50,144,87,239,228,107,245,70,39,198,251,173,21,100,215,122,117,78,198,40,200,200,0,203,216,92,232,174,1,66,202,185,51,219,118,195,216,156,22,21,43,247,138,170,139,81,213,251,155,117,205,165,89,211,134,7,247,157,189,207,161,38,143,1,19,255,131,139,164,115,67,159,90,18,213,187,158,127,174,115,97,234,143,177,160,141,183,204,103,136,33,55,51,92,36,236,141,69,192,172,61,164,28,203,164,177,10,88,184,200,210,164,83,72,38,53,192,225,8,27,49,155,209,21,166,224,46,99,6,115,216,204,173,120,175,148,112,190,185,193,86,119,36,3,158,217,134,235,163,251,237,87,1,137,226,98,237,137,181,188,162,120,48,174,87,241,242,147,160,113,208,243,224,241,240,143,54,26,57,122,26,174,85,114,158,59,61,112,44,6,251,166,223,180,26,108,84,209,103,27,241,97,221,41,235,144,211,189,33,119,235,159,38,84,153,34,104,191,57,92,8,37,100,236,162,37,23,249,205,72,196,21,98,253,57,233,116,190,170,136,147,36,170,255,116,56,196,177,153,164,253,197,6,189,226,95,255,132,141,152,227,195,126,140,229,57,15,3,178,157,5,255,182,149,79,91,85,176,59,84,161,51,193,105,84,117,160,181,199,199,193,241,152,125,34,21,225,104,51,118,134,142,101,143,191,246,208,74,131,79,250,143,79,81,68,210,63,69,168,19,241,113,160,213,166,142,155,233,33,252,223,179,150,95,253,197,172,153,251,38,21,220,222,127,178,82,63,13,92,75,143,235,85,149,222,93,1,220,225,105,230,135,179,200,203,57,129,156,231,43,99,33,118,93,226,227,39,114,74,25,115,58,192,35,7,209,12,65,182,254,3,129,85,73,148,252,149,97,11,180,57,139,15,202,157,222,218,203,41,142,135,5,155,231,140,70,105,110,52,200,220,248,192,29,72,22,92,146,79,170,94,183,47,142,9,146,30,108,120,163,97,125,90,113,96,242,252,123,9,156,76,217,93,215,4,30,124,10,84,214,157,176,47,12,25,73,42,6,185,37,7,213,174,18,228,194,59,154,172,28,126,155,22,184,233,94,17,110,246,97,38,171,135,133,87,191,9,15,91,149,133,178,115,56,46,44,139,135,175,241,55,15,176,236,127,246,153,160,151,200,111,37,195,170,234,0,123,212,30,16,172,142,89,138,94,240,67,32,243,60,168,201,167,251,194,183,94,74,243,145,47,197,54,196,208,2,29,181,240,180,18,218,148,223,235,241},
  {20,13,60,197,213,250,150,218,32,73,61,119,241,94,9,140,120,84,106,212,71,82,31,110,55,194,205,100,37,98,59,38,17,204,191,14,195,151,13,125,18,95,101,167,184,197,166,114,224,172,145,246,102,143,81,153,195,123,241,109,38,231,137,245,102,187,70,142,123,141,3,19,10,181,201,203,22,141,55,131,237,16,115,75,239,39,0,79,166,216,154,111,132,151,156,19,189,201,132,70,218,52,137,248,147,31,116,132,43,84,101,32,122,49,121,231,113,193,25,143,87,173,130,36,73,136,109,36,236,217,101,100,9,244,147,45,112,60,112,114,55,87,139,90,138,54,254,50,25,21,47,88,220,23,40,235,248,207,109,58,31,140,116,225,29,193,23,75,150,53,42,235,130,101,189,62,188,207,35,199,145,60,40,88,75,0,170,100,181,143,203,245,253,255,60,73,25,109,216,145,229,222,16,70,193,191,219,60,4,93,180,230,255,132,92,211,58,119,8,220,31,195,219,212,248,157,120,158,112,235,125,5,62,219,244,133,46,52,213,86,23,18,250,56,234,211,53,246,199,2,158,93,93,219,173,46,70,222,236,218,160,177,7,3,211,141,73,203,231,13,180,112,41,6,20,183,25,113,136,223,29,174,171,0,192,93,61,223,193,114,183,205,91,118,29,122,121,100,51,182,63,66,73,42,27,204,163,71,232,47,179,60,92,125,110,226,83,217,66,10,30,25,227,98,83,15,68,172,119,126,191,209,228,44,34,186,66,16,106,139,126,187,147,157,106,16,28,212,28,241,18,108,134,155,231,242,146,13,119,91,202,44,173,142,44,246,52,56,236,200,95,45,86,83,130,232,155,30,230,41,155,193,159,187,160,204,81,199,119,193,168,218,123,26,129,125,73,88,2,92,190,8,180,220,136,119,224,109,82,71,157,55,225,91,89,184,61,195,188,252,128,126,239,22,240,186,202,207,149,253,201,109,10,94,135,161,45,220,108,61,181,191,123,127,65,153,232,113,153,217,95,129,73,14,90,248,65,242,148,163,111,146,131,108,110,147,120,123,224,107,39,121,227,190,249,58,47,215,240,36,243,205,22,216,121,141,60,33,148,163,26,215,254,190,53,144,250,160,228,55,200,71,139,241,230,69,47,163,116,233,37,71,254,152,255,49,187,225,155,77,114,99,157,72,133,12,185,31,41,92,238,219,200,81,44,197,21,240,119,9,116,10,74,219,107,104,177,164,91,19,101,163,81,250,20,30,22,136,126,127,100,178,124,12,228,50,14,3,181,40,74,188,81,210,68,156,191,183,45,130,32,207,180,161,4,48,244,85,116,210,243,187,38,188,161,33,199,31,95,119,85,137,24,78,42,46,113,150,237,77,174,65,9,207,142,64,150,36,165,85,18,237,93,116,0,8,123,239,240,93,203,36,248,194,243,127,18,201,118,156,164,93,145,31,0,132,84,4,24,181,42,163,165,17,157,178,35,19,132,17,107,188,86,20,218,198,12,95,43,20,116,94,245,56,214,241,242,207,252,251,129,132,231,229,222,7,27,16,88,43,125,67,132,181,30,1,45,201,245,68,102,189,198,107,84,131,57,124,133,140,61,223,194,109,105,66,83,12,115,190,240,6,254,202,0,92,106,63,103,96,86,191,85,31,248,10,237,0,242,120,249,90,8,110,128,237,236,91,32,66,156,106,143,40,110,79,78,143,173,55,190,132,113,14,32,99,17,22,89,36,164,93,63,232,148,83,206,110,211,147,175,76,184,41,29,30,240,137,56,136,236,67,100,105,151,1,240,45,148,161,237,227,58,84,28,89,60,66,4,220,216,168,10,194,21,158,8,69,156,251,103,120,130,87,107,192,154,7,19,164,127,173,8,174,104,128,5,63,175,238,49,126,14,181,207,185,209,146,241,248,80,183,111,221,204,37,81,222,40,63,11,248,124,49,100,124,78,17,240,224,221,160,60,230,31,41,237,144,12,141,4,152,57,18,224,182,159,116,130,46,73,69,80,117,232,95,45,95,211,143,21,193,192,224,142,38,159,172,170,91,178,242,59,36,205,123,172,124,115,68,162,92,231,200,48,48,129,59,15,249,17,252,109,67,170,198,224,200,126,223,12,248,219,122,95,67,65,176,38,231,110,31,70,221,186,82,101,170,31,229,29,168,43,166,99,252,198,124,183,233,8,220,126,148,130,228,202,82,131,205,181,144,243,79,34,130,111,208,217,200,190,109,121,110,58,193,230,184,101,0,119,254,75,62,223,136,28,208,125,125,183,171,62,10,129,49,35,155,132,150,60,119,118,235,19,152,227,231,116,191,238,139,195,133,142,225,91,138,77,64,171,217,24,162,8,39,218,232,91,175,238,79,172,208,52,94,104,188,157,161,194,166,195,249,98,204,140,86,31,226,187,57,85,147,28,166,54,54,38,81,250,217,52,13,156,182,62,210,89,245,252,96,183,253,177,3,163,44,188,78,195,22,254,127,100,40,200,183,69,224,190,255,156,111,126,215,73,197,135,77,145,247,109,59,186,168,33,174,142,229,201,8,34,4,92,144,39,86,229,194,156,107,136,89,15,157,241,138,102,134,253,12,96,170,131,177,181,253,161,49,128,182,217,68,165,54,200,63,51,217,253,141,77,238,229,40,243,108,245,74,54,106,214,200,122,56,143,162,98,203,22,14,169,113,142,141,176,136,43,172,99,194,192,213,207,154,26,151,225,10,113,47,232,191,93,153,41,4,181,188,226,197,92,81,84,36,196,192,243,130,76,124,172,183,203,241,185,238,232,209,238,49,248,0,239,45,218,180,123,143,124,14,239,235,40,214,250,185,241,233,88,137,60,151,4,83,61,127,3,19,68,255,205,9,104,72,104,78,119,171,100,221,168,29,26,156,48,47,103,36,83,245,202,33,149,129,228,244,60,122,73,242,249,232,225,28,75,137,15,70,71,189,83,28,238,49,132,103,18,172,50,98,252,9,45,97,43,13,25,11,154,244,79,160,24,72,233,217,146,104,219,63,231,99,111,133,233,166,135,251,140,240,171,161,140,70,86,60,80,156,188,56,189,144,3,118,121,187,33,237,165,183,214,226,220,83,110,120,162,231,249,224,170,146,244,236,148,67,97,237,110,189,231,110,140,184,225,108,221,39,234,211,83,82,190,135,198,203,207,82,131,28,30,100,202,242,184,122,137,104,247,172,237,21,226,154,199,118,126,222,188,238,217,33,1,41,99,34,20,3,198,131,170,89,24,221,143,155,136,196,47,126,20,197,25,155,121,206,78,192,167,201,168,171,189,157,178,14,89,121,5,37,247,239,10,155,26,18,175,155,151,156,5,232,173,5,207,253,234,235,219,62,194,94,104,133,98,87,9,234,237,24,250,34,173,119,167,248,61,162,31,80,184,164,225,127,52,98,36,10,66,26,132,170,9,25,138,102,24,166,95,142,201,183,163,187,244,199,6,100,178,92,198,166,234,56,24,240,102,86,104,115,136,139,84,30,53,25,110,11,179,145,179,2,37,21,5,58,2,32,3,155,55,185,136,133,9,190,47,214,88,249,150,184,209,46,32,81,233,200,229,90,33,91,157,9,232,51,51,26,109,31,95,123,87,223,28,253,66,234,148,158,80,221,7,150,74,61,159,165,15,6,69,234,146,209,37,180,98,9,219,149,94,180,67,231,201,175,168,53,248,160,32,126,139,147,59,71,184,1,64,84,5,200,168,87,94,144,117,12,198,108,247,238,210,211,34,43,74,76,127,24,83,121,45,58,218,133,144,66,84,93,124,69,176,133,134,204,29,136,42,188,187,90,212,212,77,158,81,8,151,128,221,141,24,28,154,120,184,118,113,183,200,152,99,82,219,248,55,21,187,17,13,188,171,11,43,62,130,169,77,40,254,184,214,130,168,66,133,103,103,121,69,205,34,36,170,102,67,83,147,86,189,95,99,189,223,217,212,233,194,153,186,197,51,28,18,54,184,64,70,240,231,55,157,222,61,115,104,47,57,8,101,135,213,214,19,32,163,41,100,191,53,11,209,7,60,190,13,134,73,160,195,98,82,239,64,217,238,21,122,118,90,43,241,108,10,149,31,49,98,118,168,214,13,114,1,108,191,184,165,96,124,1,245,129,19,8,121,130,147,197,90,248,122,144,163,16,74,41,138,51,111,149,226,172,175,206,129,179,108,42,252,14,94,181,180,111,6,198,254,195,216,154,231,38,21,106,134,239,221,35,238,253,51,57,201,126,198,59,244,153,71,18,251,235,8,207,197,18,221,194,210,88,135,2,52,243,125,219,64,198,218,140,168,185,42,82,55,175,44,143,185,148,131,228,21,249,29,14,247,14,50,255,15,4,83,245,82,228,50,17,231,224,63,194,51,102,161,133,87,143,229,94,161,135,52,25,236,7,61,107,177,41,39,226,1,89,34,176,167,73,73,156,97,85,233,184,177,120,35,15,241,174,12,177,94,201,158,36,187,190,184,181,39,175,123,196,192,87,182,13,192,214,120,232,184,143,111,159,114,104,168,118,173,18,231,119,2,61,74,248,120,55,38,88,29,226,105,149,141,123,128,28,104,85,129,78,36,211,242,90,178,79,247,38,166,123,190,237,34,241,199,24,58,94,159,177,70,92,233,13,198,143,34,14,32},
  {39,126,184,12,113,19,204,142,198,12,214,162,85,183,179,123,244,167,93,65,0,121,101,148,6,252,79,128,240,144,82,54,133,92,182,219,3,255,253,142,65,95,226,173,217,61,137,56,177,70,91,58,166,156,147,16,139,110,228,119,0,80,188,176,35,181,131,228,80,240,208,173,22,94,8,174,37,147,18,107,103,250,232,208,150,51,234,211,16,190,220,66,152,191,229,106,23,37,178,3,15,247,6,106,121,212,248,61,123,40,237,86,143,82,22,171,3,186,15,119,76,211,217,191,21,22,207,95,142,118,19,239,47,124,159,208,86,230,248,207,238,73,212,138,68,211,95,33,102,177,146,199,41,191,138,123,20,248,2,54,191,172,247,225,64,15,223,109,166,30,24,74,178,181,243,125,19,230,58,206,87,77,29,229,186,102,172,128,8,228,151,35,69,63,108,115,18,242,178,43,107,253,18,12,175,140,6,74,13,129,19,85,152,166,233,5,167,48,231,87,90,129,92,149,184,79,8,175,241,245,144,56,78,251,19,167,57,230,97,232,70,46,236,169,176,203,93,195,174,174,36,227,68,78,67,151,169,47,85,177,144,172,25,67,47,30,147,80,87,168,87,93,88,230,100,79,152,143,252,69,53,189,132,10,4,71,69,69,81,181,30,108,92,111,235,118,184,79,195,54,130,12,172,7,163,27,44,140,100,94,161,11,66,173,132,127,247,251,166,182,186,162,98,19,7,254,120,61,136,40,228,95,151,90,92,90,12,114,152,88,180,233,28,164,193,228,203,18,175,116,88,220,11,67,237,213,196,3,17,118,26,3,252,172,102,156,227,85,157,30,71,203,16,154,42,125,140,34,164,120,38,31,16,54,238,156,131,66,148,30,109,93,107,37,147,217,31,59,96,130,169,7,113,179,199,161,244,205,23,150,83,229,145,214,144,140,178,224,203,99,26,239,200,42,189,215,107,107,189,23,241,185,196,210,90,202,242,127,102,95,15,239,254,103,14,226,237,1,228,214,151,7,198,182,80,112,24,160,57,199,206,135,223,221,150,144,80,175,131,49,41,252,18,52,55,30,243,31,102,131,102,42,87,11,231,12,157,119,0,48,191,63,239,114,72,13,190,173,254,170,245,199,145,69,130,158,21,5,236,247,254,54,72,39,208,239,110,121,150,194,187,136,244,119,220,16,235,159,119,71,139,69,184,20,108,2,29,50,158,39,116,150,54,69,69,142,31,153,221,247,206,235,254,115,132,43,129,18,231,186,104,253,40,163,206,183,232,27,246,202,105,214,184,24,168,205,66,87,252,148,86,211,94,227,58,238,240,236,224,176,217,178,93,104,145,0,9,183,36,252,44,122,55,18,108,78,109,153,250,223,205,62,98,217,53,181,167,17,56,124,182,66,179,85,106,27,106,70,165,61,214,4,64,130,143,151,165,220,212,166,215,77,244,47,156,242,212,72,188,40,170,7,143,7,118,83,255,15,241,78,95,67,210,112,126,136,51,175,179,0,37,222,169,183,234,151,15,242,212,22,156,173,117,231,41,135,2,190,63,241,21,116,113,241,230,30,82,178,169,46,120,55,27,219,124,30,183,31,209,228,236,235,48,45,134,39,25,151,76,180,233,182,55,107,64,220,226,243,68,143,206,127,203,45,42,29,167,213,202,227,78,17,181,136,156,11,179,110,196,138,89,23,179,212,22,156,122,246,196,243,128,2,23,178,162,101,242,157,148,154,48,57,201,116,12,79,247,105,118,64,35,4,28,2,112,53,65,162,108,15,107,8,167,153,203,248,215,147,20,51,233,201,113,160,78,54,18,54,110,101,172,134,115,57,3,82,120,96,127,16,36,123,152,36,243,112,173,203,141,182,23,230,229,242,211,37,73,184,52,108,35,159,57,96,244,211,137,73,171,180,72,70,62,6,30,178,27,195,143,152,208,121,243,183,177,130,99,113,148,249,29,253,12,174,247,92,94,196,78,13,88,206,220,121,27,93,217,159,6,99,143,248,120,1,20,161,163,78,183,227,67,48,97,195,196,199,58,57,146,118,7,227,133,159,8,91,200,151,105,124,227,213,43,99,0,198,182,227,13,215,57,6,48,67,193,113,107,82,169,35,138,55,199,210,248,109,216,179,219,190,128,154,66,226,127,142,57,50,91,75,228,120,148,84,203,31,75,248,22,153,204,79,31,144,15,49,219,242,223,113,175,204,109,2,152,131,77,255,23,8,74,76,172,76,99,114,93,196,241,231,64,148,4,241,209,119,96,41,203,120,80,120,99,248,199,100,92,34,105,76,125,203,60,241,205,129,217,7,148,182,154,39,185,199,110,131,230,223,17,203,250,128,130,119,64,172,79,168,4,127,6,186,32,126,164,191,81,115,10,221,116,191,111,163,186,226,18,68,170,179,213,42,237,189,182,4,194,194,10,176,188,213,158,58,189,153,208,209,151,114,155,177,72,245,135,245,188,248,206,62,140,88,210,15,140,186,15,65,75,154,236,122,126,47,65,136,185,156,4,35,55,136,0,100,10,98,198,5,164,197,208,242,113,76,15,26,9,123,64,109,234,159,101,148,63,67,28,42,160,236,62,113,253,230,115,214,179,9,14,142,27,157,183,56,172,136,68,162,124,143,147,14,221,232,206,239,10,40,52,208,145,158,155,191,147,0,148,76,9,233,99,224,48,207,100,38,23,111,35,69,92,42,233,58,215,210,188,102,247,206,156,253,166,44,133,76,94,104,236,207,90,92,97,247,25,12,66,218,115,241,163,204,52,82,112,253,135,236,102,85,174,231,10,129,200,162,236,86,137,151,153,37,211,8,156,76,235,18,141,187,148,109,40,127,146,28,111,98,43,218,23,37,53,54,193,100,173,72,36,77,50,209,38,94,184,64,148,248,37,232,47,160,131,130,27,96,6,73,252,243,42,68,135,245,112,163,254,152,213,24,219,171,3,181,210,156,75,115,211,228,119,120,128,223,222,102,173,61,4,235,157,138,146,184,38,230,179,252,97,106,155,120,119,30,201,73,249,194,201,192,173,5,251,131,240,183,227,181,33,82,26,152,76,234,136,36,251,99,45,184,177,154,198,93,167,192,163,196,141,207,207,157,122,179,172,25,142,151,123,246,28,26,21,23,120,8,196,119,43,208,184,145,108,121,79,60,181,98,151,124,140,75,213,91,11,234,106,5,91,20,135,18,164,210,102,67,153,104,131,130,99,224,165,46,170,110,61,59,60,95,212,154,51,182,12,30,122,73,69,209,157,201,217,66,114,82,22,32,39,164,114,14,91,85,71,38,32,180,119,128,6,208,172,255,125,71,187,251,67,180,116,115,225,38,231,165,232,104,51,51,33,53,26,62,180,159,220,155,197,250,16,113,242,193,243,137,69,76,2,229,146,87,71,171,78,80,154,62,20,142,149,249,232,24,200,186,58,135,222,9,216,17,60,215,143,23,199,173,229,76,179,242,68,26,203,85,151,19,232,132,79,60,15,67,86,254,114,47,147,41,130,240,206,167,180,98,60,224,128,156,231,244,234,3,70,105,1,173,32,70,150,151,212,146,48,128,230,55,83,153,179,254,22,214,119,180,150,50,8,49,212,42,27,77,76,122,56,222,132,56,110,33,209,1,135,84,217,32,96,53,212,113,240,178,9,121,34,202,96,144,101,227,126,139,242,3,245,31,106,112,115,194,219,30,5,64,27,79,130,13,1,97,4,41,126,87,135,50,185,160,21,39,65,174,76,167,166,68,147,57,253,67,208,78,224,123,203,20,17,159,214,97,239,80,160,191,129,33,115,18,6,12,237,230,38,125,177,170,244,38,50,146,15,173,136,95,127,97,174,197,221,114,198,186,166,43,244,7,159,4,81,128,103,237,112,180,240,128,211,157,97,141,254,233,74,224,172,177,247,115,239,203,197,85,122,94,152,106,153,11,252,36,136,123,114,236,80,90,9,29,95,79,186,63,66,212,203,238,172,156,84,152,219,142,124,63,97,226,252,47,148,70,35,172,18,160,184,229,162,195,206,62,28,233,197,65,93,10,144,247,199,243,174,202,196,152,90,53,55,115,154,43,192,13,190,204,173,101,221,81,14,254,64,158,59,232,140,14,182,172,195,148,237,210,56,229,65,178,45,80,177,34,104,66,222,194,151,231,92,232,191,50,182,227,60,226,113,40,240,136,117,239,198,90,243,23,139,90,186,128,190,59,95,105,202,159,84,128,58,13,112,39,147,7,194,99,66,35,74,25,107,164,35,20,34,29,147,98,255,77,101,48,178,18,145,139,251,134,30,101,112,51,222,134,149,49,183,254,252,217,76,36,209,94,7,129,49,48,230,228,14,52,197,41,174,89,137,15,123,112,105,99,1,250,129,220,170,141,137,100,89,36,230,17,152,107,255,90,30,17,11,244,18,65,132,118,106,180,20,27,70,184,118,57,220,227,39,123,132,215,51,14,27,235,131,22,3,36,70,192,81,48,192,206,250,172,249,9,245,211,25,91,188,132,148,136,63,226,64,186,38,15,222,214,20,127,82,179,177,133,148,164,83,239,113,219,31,15,79,159,151,240,235,96,99,43,114,131,180,130,255,172,41,100,180,203,86,198,17,128,35,242,215,176,54,122,172,246,196,105,188,238,28,181,78,204,181},
} ;

static void test_decode_1277x7879_impl(long long impl)
{
  unsigned char *x = test_decode_1277x7879_x;
  unsigned char *s = test_decode_1277x7879_s;
  unsigned char *x2 = test_decode_1277x7879_x2;
  unsigned char *s2 = test_decode_1277x7879_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_1277x7879_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_1277x7879(impl);
    printf("decode_1277x7879 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1277x7879_implementation(impl),ntruprime_dispatch_decode_1277x7879_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_1277x7879;
    printf("decode_1277x7879 selected implementation %s compiler %s\n",ntruprime_decode_1277x7879_implementation(),ntruprime_decode_1277x7879_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_1277x7879_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_1277x7879_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_1277x7879_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_1277x7879_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_1277x7879_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_1277x7879_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_1277x7879(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1277x7879")) return;
  storage_decode_1277x7879_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_1277x7879_x = aligned(storage_decode_1277x7879_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_1277x7879_s = callocplus(crypto_decode_STRBYTES);
  test_decode_1277x7879_s = aligned(storage_decode_1277x7879_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_1277x7879_x2 = callocplus(maxalloc);
  test_decode_1277x7879_x2 = aligned(storage_decode_1277x7879_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_1277x7879_s2 = callocplus(maxalloc);
  test_decode_1277x7879_s2 = aligned(storage_decode_1277x7879_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_1277x7879 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_1277x7879();++impl)
      forked(test_decode_1277x7879_impl,impl);
    ++test_decode_1277x7879_x;
    ++test_decode_1277x7879_s;
    ++test_decode_1277x7879_x2;
    ++test_decode_1277x7879_s2;
  }
  free(storage_decode_1277x7879_s2);
  free(storage_decode_1277x7879_x2);
  free(storage_decode_1277x7879_s);
  free(storage_decode_1277x7879_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

