/* ----- encode/761xint16, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_761xint16_checksums[] = {
  "49e6aca48717c2e93b56d9706189b6c5b21781086c569bf421628343fec2bc06",
  "fd2f7ecff81bea4ae8e08a3bf1b6d4e57d328c481f773c60d3f1a773c25dbfca",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_761xint16_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_761xint16_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_761xint16_ITEMBYTES

static void *storage_encode_761xint16_s;
static unsigned char *test_encode_761xint16_s;
static void *storage_encode_761xint16_x;
static unsigned char *test_encode_761xint16_x;
static void *storage_encode_761xint16_s2;
static unsigned char *test_encode_761xint16_s2;
static void *storage_encode_761xint16_x2;
static unsigned char *test_encode_761xint16_x2;

#define precomputed_encode_761xint16_NUM 4

static const unsigned char precomputed_encode_761xint16_s[precomputed_encode_761xint16_NUM][crypto_encode_STRBYTES] = {
  {141,131,73,65,97,98,63,147,220,42,18,92,152,205,18,2,192,106,61,229,118,30,176,239,24,209,32,9,179,216,35,138,157,2,237,203,80,178,244,27,126,46,60,151,59,20,61,178,33,116,91,138,122,242,149,184,10,246,245,57,120,207,0,17,123,214,63,58,79,84,159,57,147,12,47,71,104,109,80,62,69,69,35,70,228,193,168,25,56,97,72,194,182,214,151,19,40,193,78,25,55,34,5,110,245,74,38,247,88,166,96,33,219,126,85,255,11,135,6,203,127,8,232,159,194,255,0,216,203,57,73,184,141,10,222,124,104,66,26,210,184,206,32,224,89,187,188,232,101,167,123,187,36,78,249,63,199,153,246,6,172,87,23,199,5,178,132,99,39,64,206,179,116,52,212,106,55,130,11,224,162,211,175,243,235,160,179,143,175,66,155,20,89,105,91,69,147,106,225,47,11,229,166,50,184,250,219,232,105,248,235,228,120,38,154,33,253,64,219,247,220,229,58,97,11,15,240,42,79,7,177,71,204,2,27,127,226,234,169,82,158,228,136,192,200,63,137,92,101,116,43,255,212,34,93,135,20,173,106,251,61,9,115,101,85,153,32,36,221,164,120,106,108,189,178,150,236,219,136,107,25,197,228,45,142,66,46,67,71,245,205,52,167,236,231,112,4,143,234,138,101,64,225,11,132,175,129,62,234,40,31,64,191,28,19,107,144,117,68,19,191,237,186,235,254,54,151,249,164,75,38,133,95,62,68,21,115,145,174,129,47,218,161,251,33,200,218,219,89,72,92,201,183,207,99,163,177,85,129,84,124,104,98,55,93,63,251,142,11,54,167,186,212,133,133,17,214,183,217,196,127,24,77,58,246,87,194,148,235,15,117,0,196,36,62,118,17,100,204,63,128,182,226,33,98,162,222,243,27,184,161,221,250,183,252,22,253,167,46,251,109,231,37,170,222,113,158,97,182,128,39,119,5,7,227,139,165,26,180,235,115,95,105,97,241,202,0,168,78,99,114,2,139,105,202,230,193,225,35,77,224,72,193,147,6,81,79,161,211,93,77,183,25,31,2,42,228,211,83,79,178,130,214,148,113,235,69,223,248,69,20,163,167,164,237,212,178,247,77,236,63,235,131,18,68,242,68,140,249,6,243,46,106,240,39,70,13,144,251,128,32,226,234,238,99,225,74,224,165,93,74,95,99,63,241,172,35,192,145,103,53,66,72,89,5,194,172,17,228,36,176,151,32,14,49,166,236,1,247,157,138,140,116,175,251,226,39,171,116,67,141,30,64,135,230,90,0,125,243,159,195,75,133,227,90,198,235,168,145,239,185,139,221,77,29,5,91,191,228,55,92,200,250,246,236,163,236,120,144,245,172,61,188,14,106,23,166,142,166,96,218,47,87,71,242,230,224,144,153,36,74,36,205,71,19,178,120,0,149,20,145,190,142,68,240,89,112,162,250,88,45,135,79,104,18,57,217,88,169,237,191,190,238,120,246,155,163,27,75,172,107,41,111,97,75,109,75,15,1,215,199,237,28,63,22,200,9,94,14,155,236,248,84,234,48,22,58,201,137,10,15,114,185,52,55,233,213,21,37,91,198,94,181,4,119,27,18,212,104,195,219,37,18,152,52,45,201,154,204,55,183,165,110,168,80,140,90,57,245,65,44,25,93,101,47,190,54,133,177,132,69,206,190,188,39,138,17,82,148,10,153,119,251,82,150,179,248,102,215,144,1,176,107,253,104,208,240,7,189,140,11,63,175,167,199,237,180,103,123,107,112,47,41,97,169,107,193,205,78,39,249,162,62,217,254,80,168,141,144,84,44,144,3,218,162,194,195,28,23,52,53,151,188,84,29,166,250,8,215,216,158,86,238,86,245,139,159,174,117,72,158,99,72,168,115,191,79,153,164,54,96,215,115,7,159,51,117,236,9,24,122,247,248,34,37,47,128,225,134,124,45,64,212,57,17,119,53,188,75,99,127,149,178,159,184,134,146,94,161,39,11,191,38,24,118,223,161,187,72,106,80,77,25,87,244,94,204,215,71,187,251,199,66,120,65,230,94,194,251,111,244,57,237,209,137,225,201,223,149,131,161,77,64,248,233,120,106,47,73,104,79,114,89,249,83,223,203,170,124,16,154,158,122,86,243,250,61,6,51,38,30,98,84,68,15,110,156,168,73,140,233,12,253,253,102,97,27,215,76,51,119,19,42,103,195,245,175,132,73,41,128,248,164,78,215,11,105,57,197,1,9,232,226,55,34,249,225,191,253,149,200,1,145,91,130,105,181,200,216,19,183,140,189,170,50,237,237,201,141,24,181,111,244,1,30,207,151,6,57,196,105,55,175,148,248,205,156,217,23,81,77,206,98,202,94,0,25,169,196,192,152,173,96,199,227,107,103,204,112,88,248,187,142,23,243,217,167,232,184,81,83,35,81,46,126,165,80,203,62,28,35,186,153,163,45,155,134,149,35,248,49,122,180,128,11,51,98,62,130,124,187,196,150,74,98,59,2,223,19,117,92,32,44,75,206,253,101,139,239,75,7,141,207,188,47,139,215,128,211,174,203,231,206,36,145,247,24,142,182,162,132,164,33,155,118,51,209,146,72,224,236,109,2,69,45,251,229,49,179,94,129,116,127,80,147,34,118,19,90,64,161,164,252,53,85,44,13,250,185,199,164,90,89,66,197,24,178,215,37,116,135,93,194,3,145,88,143,204,199,13,211,181,236,56,114,175,21,90,204,60,117,153,156,199,37,81,83,4,229,8,194,120,190,191,41,28,44,59,168,237,161,191,106,10,3,174,247,49,203,229,77,156,164,182,42,80,109,205,123,231,110,206,94,13,127,243,61,222,41,217,114,149,148,240,131,214,160,21,122,191,119,20,237,215,255,155,55,205,161,88,105,166,150,213,229,8,196,191,243,128,183,90,168,20,79,42,16,143,239,78,130,193,245,60,114,103,106,0,154,234,242,120,216,164,52,224,229,52,150,133,185,19,200,27,154,193,226,100,17,19,120,175,202,217,112,72,248,111,226,222,70,247,23,249,173,57,4,222,245,113,5,80,130,232,157,151,178,152,76,142,219,246,4,192,73,88,59,140,237,54,240,181,47,128,208,5,51,162,5,105,172,237,124,231,9,184,41,123,255,252,106,76,243,108,86,129,117,180,15,53,215,99,198,156,128,28,172,106,147,33,224,21,78,58,77,178,167,242,228,158,213,32,95,141,246,181,182,154,60,63,160,252,149,27,167,81,46,135,143,33,64,246,135,100,248,204,206,145,143,240,58,185,170,201,149,224,43,121,26,203,156,213,168,0,219,6,173,108,69,83,185,93,97,42,253,79,97,217,25,13,64,73,135,140,39,186,182,178,213,110,129,35,73,22,140,180,168,176,206,98,169,181,123,228,112,169,226,105,186,199,183,42},
  {150,128,141,209,113,41,189,240,160,243,217,187,122,196,221,26,74,77,81,232,231,55,132,214,239,1,134,195,186,108,95,182,199,47,154,9,210,116,84,244,6,179,21,99,45,49,21,232,229,249,86,234,12,208,171,160,207,11,234,206,247,144,26,20,97,107,119,87,62,250,23,201,24,197,216,4,249,242,36,227,185,247,227,148,65,31,239,3,153,27,135,118,231,252,54,250,254,47,239,124,250,158,136,203,173,160,166,254,5,212,162,69,100,185,26,0,137,29,227,215,144,228,106,1,161,132,153,129,10,75,17,7,227,200,202,171,4,42,132,110,219,211,133,177,38,23,72,197,151,103,221,122,185,62,177,159,25,47,2,133,241,37,50,205,98,117,120,110,224,179,216,160,126,169,191,113,193,195,1,235,177,127,33,116,241,107,221,64,107,212,43,211,168,196,32,120,209,9,246,153,172,94,117,235,147,199,145,120,126,212,213,137,17,65,169,202,185,17,150,172,235,231,2,4,167,172,167,77,204,43,233,128,117,27,206,200,95,23,116,22,189,132,161,104,246,155,188,215,229,8,252,209,218,10,59,168,190,87,30,219,240,103,113,144,89,240,161,186,118,124,196,187,171,104,7,129,141,102,192,11,170,32,97,86,123,169,50,213,156,230,169,134,123,245,156,127,138,138,225,135,69,123,17,125,244,185,176,47,78,199,46,230,108,157,217,236,169,237,214,108,24,74,12,236,8,175,40,203,165,92,102,60,55,11,187,251,5,173,62,214,228,112,33,229,175,185,98,25,161,134,98,70,128,20,41,163,41,222,251,159,98,122,152,190,197,201,97,171,168,96,105,214,45,75,164,227,243,42,121,40,84,175,23,33,144,216,45,225,156,251,75,142,222,162,170,49,127,222,5,52,4,232,174,230,80,69,182,102,83,136,175,253,222,101,43,126,157,70,88,63,195,189,254,148,140,214,171,175,142,28,44,110,150,58,36,37,218,104,42,203,82,204,182,235,39,227,222,34,63,239,5,117,234,251,84,203,46,115,76,220,6,254,212,128,156,133,254,146,197,231,102,214,181,121,211,92,129,127,4,81,165,129,35,205,52,74,193,187,28,191,152,176,176,224,70,73,175,94,166,126,72,243,35,10,7,203,116,171,41,47,25,237,132,82,207,51,80,93,78,112,145,151,114,170,74,78,118,26,79,188,243,8,48,244,230,255,94,196,194,158,40,81,73,15,185,243,226,0,193,119,164,129,207,107,4,123,192,216,139,236,173,7,254,84,158,47,226,145,183,119,15,67,22,120,48,122,217,56,46,144,26,143,248,226,31,51,132,48,167,255,39,25,7,128,157,199,156,227,223,218,13,133,40,91,0,10,183,224,197,182,161,114,151,109,197,245,102,114,181,183,157,224,140,68,48,128,8,200,252,155,17,172,201,51,188,149,162,156,2,105,52,248,129,194,62,9,90,233,245,158,134,188,229,149,172,136,203,108,173,122,26,125,214,234,41,43,221,156,135,115,249,176,32,195,247,233,147,239,157,3,230,38,127,45,216,37,87,219,198,129,66,74,203,200,64,21,106,192,129,179,248,165,71,165,13,173,51,237,235,108,93,28,106,69,27,206,163,78,118,151,163,215,37,105,147,200,46,36,40,221,105,66,114,179,69,20,205,116,101,134,20,202,132,212,110,155,55,211,162,147,81,60,32,183,19,198,204,75,82,10,5,224,113,234,201,98,62,133,48,81,31,7,215,59,104,40,184,239,18,102,101,159,233,81,55,213,191,173,162,31,70,89,75,46,248,173,116,190,4,198,120,42,146,65,177,235,37,246,22,204,201,57,115,80,33,166,152,39,58,4,175,255,96,44,135,238,181,100,85,133,51,204,1,167,199,145,239,24,94,223,77,82,250,213,78,168,52,222,216,191,163,94,236,180,6,87,80,221,154,86,148,176,63,88,46,151,48,190,206,125,87,105,227,28,251,70,132,136,227,244,171,243,16,155,109,236,56,185,21,70,49,232,121,93,231,238,82,182,250,208,13,243,118,28,99,67,169,180,174,41,237,130,236,46,227,124,194,20,61,171,146,26,213,25,140,205,70,174,96,9,70,28,56,135,160,146,141,98,46,106,140,72,225,10,243,42,200,10,163,224,51,18,69,175,27,53,155,183,150,96,142,31,217,112,152,174,115,224,43,92,42,47,127,166,156,184,232,27,189,159,165,172,160,135,196,238,94,51,17,148,109,117,165,14,156,24,55,92,236,232,156,159,208,64,164,209,245,35,106,33,86,165,169,10,133,242,198,149,23,54,190,12,67,127,107,53,144,56,98,228,40,10,73,91,35,71,7,86,151,54,132,19,113,112,10,58,18,190,13,203,132,0,11,170,222,13,50,52,227,163,177,58,77,41,240,112,5,237,151,212,216,154,131,242,218,111,8,86,75,81,115,75,174,100,73,39,162,211,236,168,133,132,99,245,81,114,170,189,103,224,180,59,58,17,238,125,60,128,122,126,174,204,161,117,247,228,18,87,197,112,52,117,10,74,160,217,145,71,211,229,87,101,238,141,248,99,1,232,2,45,102,179,17,0,125,117,44,125,225,126,44,168,21,194,232,129,25,50,74,56,60,77,43,43,144,145,31,230,73,241,86,233,194,215,86,217,149,151,165,23,9,167,107,56,3,84,241,9,178,204,15,28,3,148,100,174,181,31,196,243,126,196,103,25,75,249,6,67,229,65,27,122,215,105,244,94,6,195,161,119,157,80,40,109,142,12,165,23,33,200,144,3,123,29,58,56,248,47,31,134,28,36,124,165,149,80,65,151,135,69,201,26,0,163,233,236,102,27,202,82,75,187,71,37,201,142,190,228,204,249,13,117,173,234,30,140,63,14,199,203,83,95,13,176,165,233,208,107,82,239,122,181,222,110,104,225,92,16,65,8,226,211,181,133,30,13,81,232,156,152,227,12,25,240,153,0,126,216,105,224,117,181,90,23,40,5,184,19,21,31,17,230,127,220,110,216,81,33,1,206,241,175,57,206,58,219,248,165,198,163,87,218,101,110,53,157,157,140,198,135,55,220,246,202,86,168,181,68,99,126,112,109,236,190,54,14,103,185,105,243,147,123,113,29,145,69,79,55,227,221,40,33,109,96,76,166,177,59,8,17,168,47,67,43,231,76,242,137,195,155,3,203,29,38,119,207,197,104,163,29,151,72,148,211,252,187,85,54,253,91,158,227,147,169,187,119,234,25,84,70,204,13,176,233,44,242,169,223,47,93,36,57,49,223,17,199,95,120,160,76,117,108,127,131,215,132,181,92,11,236,73,102,222,120,129,98,110,163,143,147,146,106,153,41,132,52,198,96,97,76,25,232,187,212,183,106,208,76,7,7,125,211,70,157,154,225,142,14,15,189,90,210,54,185,28,150,5,2,7,29,195,119},
  {171,197,159,25,35,27,164,69,71,183,53,83,86,239,207,66,221,245,216,183,74,179,42,103,146,145,100,40,166,240,62,134,53,250,23,49,187,217,183,230,192,168,193,209,223,245,158,161,20,117,26,225,137,62,132,27,10,248,183,95,224,144,99,246,179,24,229,51,210,241,95,234,135,83,225,207,14,157,36,11,1,231,201,5,11,186,25,168,146,47,168,211,52,203,246,209,99,71,35,175,115,91,149,199,167,130,203,42,21,43,66,42,101,172,76,248,154,255,184,250,68,68,158,137,56,99,79,219,250,199,164,43,85,21,57,166,2,37,7,77,69,131,226,13,137,65,97,199,129,107,221,104,129,8,153,231,151,22,96,132,19,241,17,89,40,106,240,222,116,180,131,249,139,169,27,186,137,19,15,214,139,4,217,203,1,115,167,106,199,120,171,200,246,181,47,235,122,246,165,57,130,142,64,153,45,115,76,45,118,183,165,236,232,147,38,14,22,32,135,87,79,47,215,167,125,180,67,114,33,89,106,23,238,43,176,147,155,237,88,114,1,28,59,243,202,25,36,101,63,143,250,103,165,64,120,245,24,237,102,60,224,30,246,169,61,248,78,24,214,175,104,218,91,140,110,18,163,252,30,200,227,160,26,241,167,152,65,167,202,184,160,215,102,154,17,138,98,233,217,113,196,186,69,55,20,238,4,35,100,146,254,199,171,43,124,33,114,0,171,63,35,72,79,181,189,184,23,20,55,8,148,27,186,207,117,182,74,101,20,127,58,34,237,196,184,85,222,7,24,87,40,83,9,246,188,150,118,126,150,226,22,122,228,165,80,17,68,163,34,84,48,24,214,20,77,211,232,201,218,16,222,173,164,78,108,224,226,188,110,232,150,234,25,205,78,157,166,253,244,54,100,93,91,82,178,174,27,228,235,3,73,38,82,5,218,103,202,21,222,98,15,58,196,150,250,160,195,232,130,166,42,106,148,247,21,226,241,43,136,49,126,109,227,31,144,126,97,59,109,92,7,222,209,93,6,52,221,204,235,46,82,223,54,72,112,161,58,30,109,245,119,4,179,124,2,16,99,242,5,153,241,107,3,95,1,248,213,243,6,102,58,192,228,8,150,171,59,234,13,0,4,26,152,196,168,50,170,164,118,156,65,209,66,166,176,86,182,123,85,210,117,129,195,65,79,24,102,183,55,193,191,233,116,16,207,135,151,70,69,28,143,228,36,43,208,63,45,139,229,183,141,222,50,108,254,227,197,14,179,50,253,103,45,212,29,50,248,97,172,136,239,88,179,83,236,58,138,64,42,138,111,166,53,85,234,215,242,127,20,40,33,108,209,14,174,160,223,92,66,207,182,104,128,129,225,54,219,245,38,115,181,126,177,216,16,164,18,21,224,29,149,233,116,55,247,138,183,35,41,106,177,85,216,118,63,120,70,172,42,210,128,85,155,128,125,128,167,176,243,57,193,128,83,92,225,55,235,27,221,174,246,162,252,16,24,156,233,9,47,232,174,14,31,213,124,102,121,170,197,4,71,83,241,10,149,15,77,165,10,79,104,197,177,160,125,22,28,69,78,136,157,245,35,205,143,21,177,144,242,155,91,20,143,40,198,96,242,152,123,148,229,202,67,168,230,155,165,150,26,66,91,197,15,157,173,178,185,98,174,5,76,82,239,208,34,48,220,8,177,48,33,101,24,166,92,209,97,112,81,226,41,100,44,19,176,192,249,36,96,85,214,244,230,180,146,224,73,238,175,178,131,138,16,121,163,223,19,185,14,36,115,19,98,173,254,191,235,107,32,113,174,190,175,66,154,38,150,108,222,242,79,152,207,59,19,215,12,151,235,68,84,228,198,48,0,98,60,207,115,155,15,78,60,252,127,69,77,192,221,114,218,9,72,79,15,208,63,165,126,173,226,195,162,189,255,190,142,109,61,222,74,123,75,119,95,90,27,20,33,6,18,16,104,194,21,203,167,57,192,70,230,181,223,63,62,87,135,58,32,98,241,188,74,93,2,102,153,206,20,137,26,251,1,77,53,30,68,168,179,189,61,227,205,65,1,212,59,86,216,107,117,155,190,130,180,194,109,137,165,143,185,169,80,104,67,145,76,248,242,136,70,100,9,53,162,51,205,86,221,136,52,1,191,95,164,0,208,175,19,48,82,151,120,148,184,40,238,116,246,245,74,131,195,209,90,73,213,98,220,174,178,252,12,72,20,142,5,87,30,86,122,254,5,149,121,87,41,161,25,85,127,108,205,137,161,122,76,0,184,85,188,185,223,134,149,104,35,177,210,146,177,70,156,136,113,243,50,96,47,42,184,107,137,140,252,65,182,167,122,196,60,178,121,81,182,116,167,164,58,222,131,191,25,65,232,70,27,98,131,68,168,87,130,58,244,211,139,95,204,101,180,142,17,249,82,142,120,189,138,34,170,241,248,106,170,200,95,49,79,33,227,53,6,39,214,25,77,240,20,123,203,109,88,170,139,16,64,172,12,236,29,4,15,188,245,8,222,184,97,181,140,222,164,104,20,50,252,127,99,29,210,128,174,130,27,218,227,147,123,169,51,12,146,207,49,151,242,207,17,171,127,226,176,19,33,255,223,167,0,29,137,31,73,123,247,123,140,150,118,43,6,45,99,174,114,38,215,210,26,124,25,42,33,97,194,27,181,67,66,175,137,131,186,29,97,42,210,142,15,127,12,216,151,113,93,142,227,202,185,209,27,95,254,212,188,226,1,132,86,88,248,73,45,168,105,253,178,41,16,90,209,1,27,127,160,99,250,42,159,241,135,79,234,63,218,64,142,159,161,62,196,174,185,86,170,234,197,11,205,105,100,127,82,178,180,124,175,44,55,203,137,166,236,232,69,233,97,66,164,48,138,24,127,188,15,254,241,35,56,216,160,255,208,125,53,199,40,36,25,247,119,218,132,118,201,243,39,115,100,158,139,140,87,36,131,59,255,232,38,78,179,8,249,249,179,233,10,106,28,162,58,74,192,197,120,239,120,38,186,206,45,86,229,27,166,4,78,57,127,51,203,233,69,192,106,240,60,112,33,255,14,235,178,172,103,86,97,214,66,240,238,157,20,21,139,29,152,79,146,101,22,204,241,153,93,173,155,203,165,124,114,133,97,170,114,184,75,189,140,101,141,135,50,62,214,216,108,185,15,177,100,174,110,167,59,44,251,141,178,150,162,118,159,64,210,70,222,47,182,195,151,5,112,212,48,52,243,242,226,153,40,97,69,67,56,157,144,10,200,59,195,106,215,197,22,242,123,82,86,103,191,152,199,152,169,202,234,47,124,50,184,34,121,136,0,249,198,236,110,239,190,46,190,43,54,123,99,146,156,117,160,47,117,183,36,76,179,23,2,15,244,212,13,43,13,26,233,4,231,92,10,21,75,172,50,148,251,219,47,6,84,72},
  {252,190,16,151,91,250,141,33,46,46,93,186,193,237,186,161,250,149,171,137,226,225,106,106,222,141,127,114,94,112,167,19,137,105,43,159,133,95,30,249,89,135,248,95,130,162,166,109,36,91,249,176,225,55,180,227,164,247,162,222,124,124,211,114,44,103,35,215,156,60,72,83,167,249,204,235,73,35,179,216,135,149,241,3,59,135,211,117,228,238,244,73,109,35,220,134,77,76,170,203,230,17,97,103,53,13,244,99,88,147,84,242,21,140,110,165,206,43,60,104,246,94,197,225,220,139,99,234,127,112,77,153,10,127,67,246,153,230,70,126,150,39,201,124,139,186,154,115,192,89,105,82,129,168,137,190,241,17,255,108,56,6,107,144,21,146,163,118,223,75,103,123,135,84,126,148,26,235,173,48,222,202,102,124,152,36,216,178,207,217,189,14,17,205,43,229,208,118,54,226,196,213,67,17,23,29,210,212,69,44,201,192,180,205,33,212,86,97,186,46,58,249,162,129,123,236,18,113,202,76,89,244,51,140,26,8,254,116,245,232,147,52,104,55,168,241,9,67,199,241,184,90,121,127,80,8,85,107,185,106,100,104,160,59,99,22,205,125,96,253,241,8,50,247,225,109,115,81,150,213,145,194,222,36,203,228,219,121,113,22,120,72,230,74,28,11,120,65,2,203,98,166,1,58,50,214,158,166,214,241,143,195,50,216,32,23,209,26,236,103,165,118,251,250,44,67,107,205,254,222,100,75,40,22,70,111,55,139,120,4,117,250,177,35,204,28,132,164,114,160,83,173,89,213,177,53,7,182,8,160,166,62,46,113,4,187,197,81,16,57,114,16,233,244,94,125,119,87,159,47,78,214,28,240,202,71,64,240,235,170,15,130,186,145,37,132,199,29,104,248,143,172,5,203,184,72,69,28,74,102,103,112,47,115,63,201,29,38,27,24,233,83,115,167,102,8,232,221,158,173,196,159,93,108,63,222,25,57,229,137,150,150,6,68,173,0,152,184,52,68,168,113,175,177,166,21,246,251,55,5,33,26,230,58,136,121,29,230,172,136,220,165,116,251,173,38,86,170,15,37,37,98,168,16,168,197,128,213,216,19,246,27,245,118,64,150,95,84,6,15,244,227,74,209,235,29,146,97,77,38,194,162,175,57,187,218,239,167,197,242,53,15,37,141,76,212,248,11,188,97,77,75,155,132,142,222,203,233,197,162,200,235,27,108,2,44,251,22,121,133,174,113,151,220,188,130,104,139,138,92,152,44,231,130,101,216,209,151,74,194,125,74,144,69,199,255,27,82,27,141,57,125,13,60,171,96,87,225,130,79,230,34,160,44,196,17,234,132,220,152,51,115,40,124,149,198,192,70,0,25,7,75,88,49,100,158,41,79,137,40,75,239,126,188,107,22,138,80,164,218,153,236,163,49,102,236,150,51,55,120,170,134,181,235,67,251,148,118,212,86,117,63,97,220,50,214,0,254,93,183,40,125,30,147,52,241,168,47,26,175,97,91,201,9,232,99,214,172,106,229,222,109,249,150,205,160,16,101,173,116,202,75,237,166,191,1,51,152,75,57,175,180,248,11,197,176,156,187,121,74,127,179,56,204,119,131,194,215,192,227,246,114,69,26,17,6,33,176,234,190,198,92,153,182,79,28,85,74,105,147,10,93,229,235,97,140,205,197,134,208,0,68,195,193,60,57,208,162,95,39,142,138,95,22,96,66,184,228,240,163,106,185,181,101,41,217,90,139,20,14,129,163,122,180,38,231,227,253,184,213,163,207,144,169,239,148,20,73,74,68,252,123,98,11,104,214,236,144,84,143,183,72,108,209,38,75,253,214,123,13,73,73,127,190,42,111,36,162,200,166,68,213,82,104,104,241,239,179,185,241,156,40,240,46,134,30,47,201,177,39,246,20,202,237,91,48,144,208,38,25,64,224,85,29,80,45,17,120,14,72,242,229,252,67,134,235,242,62,153,47,223,80,117,124,32,174,32,138,1,118,139,177,162,4,236,222,39,24,53,71,91,103,88,156,148,145,207,94,195,124,85,4,173,165,214,220,137,28,105,143,114,7,137,131,232,65,51,217,71,12,90,148,4,218,15,217,175,23,137,88,5,86,213,96,68,253,26,229,9,148,78,44,57,245,174,113,167,204,72,82,12,132,85,170,4,28,251,201,18,87,193,8,8,14,29,8,160,241,170,62,45,74,241,222,165,196,15,199,87,151,64,62,197,64,228,193,37,197,154,34,39,119,186,40,84,33,151,29,205,248,27,161,41,175,38,102,56,158,210,78,138,91,154,5,209,191,176,12,144,191,68,156,82,9,139,180,74,227,32,14,105,218,38,63,129,44,186,106,222,4,187,106,132,147,47,63,207,69,46,177,113,255,213,126,180,202,141,77,143,230,176,12,147,199,102,199,20,24,87,73,208,50,74,132,240,249,38,164,105,226,243,13,177,226,159,73,233,150,253,145,104,235,0,202,25,77,225,213,183,79,175,80,224,212,94,123,171,66,18,140,137,78,178,73,157,4,15,67,252,22,85,103,88,196,239,71,123,133,241,54,233,135,153,69,214,147,238,138,180,100,202,169,21,39,184,190,224,25,151,150,239,21,190,75,91,59,157,144,211,64,116,131,154,127,100,165,78,36,246,150,142,42,129,15,55,202,37,146,180,5,111,214,131,104,130,127,20,238,118,216,148,102,136,222,241,49,155,220,157,177,252,91,7,111,9,128,213,175,52,76,236,97,5,230,241,100,176,81,242,161,25,139,44,159,48,24,218,207,237,75,181,144,169,13,75,137,164,161,135,233,32,161,43,127,58,211,242,39,90,214,45,60,159,106,183,20,188,60,237,91,149,162,31,211,24,99,167,196,108,170,46,168,100,183,133,9,125,72,175,36,232,25,147,129,237,155,130,95,95,147,130,119,188,14,39,120,80,106,17,94,53,25,11,73,95,59,171,220,41,104,9,203,159,101,178,10,74,202,104,167,185,105,114,104,231,85,34,197,204,186,7,185,93,22,100,52,120,86,214,66,246,136,11,1,53,119,106,12,139,99,85,81,45,204,29,68,184,0,89,224,91,75,138,59,72,87,103,205,115,165,122,23,189,237,108,165,194,76,114,81,106,129,177,97,253,157,45,103,40,17,254,84,85,132,72,236,204,38,126,155,28,236,221,142,61,156,247,154,202,207,225,216,22,110,70,49,5,181,227,215,145,185,128,225,192,233,247,8,7,230,233,189,73,184,169,51,22,177,100,16,233,15,229,115,135,59,193,81,159,99,235,27,92,139,137,134,225,106,1,175,202,1,36,4,150,101,192,191,139,44,173,3,65,88,51,145,223,90,145,144,110,218,102,97,43,110,142,225,6,198,141,12,221,40,251,141,207,253,190,64,196,217,10,79,46,245,27,144,95,69,81,8},
} ;

static const uint16_t precomputed_encode_761xint16_x[precomputed_encode_761xint16_NUM][crypto_encode_ITEMS] = {
  {33677,16713,25185,37695,10972,23570,52632,530,27328,58685,7798,61360,53528,2336,55475,35363,669,52205,45648,7156,11902,38716,5179,45629,29729,35419,62074,47253,62986,14837,53112,4352,54907,14911,21583,14751,3219,18223,28008,15952,17733,17955,49636,6568,24888,49736,54966,5015,49448,6478,8759,28165,19189,63270,42584,8544,32475,65365,34571,51974,2175,40936,65474,55296,14795,47177,2701,31966,17000,53786,52920,57376,47961,59580,42853,47995,20004,16377,39367,1782,22444,50967,45573,25476,16423,46030,13428,27348,33335,57355,54178,62383,41195,36787,17071,5275,26969,17755,27283,12257,58635,12966,64184,59611,63593,58603,9848,8602,16637,63451,58844,24890,3851,10992,1871,18353,716,32539,60130,21161,58526,49288,16328,23689,29797,65323,8916,34653,44308,64362,2365,25971,39253,9248,42205,27256,48492,38578,56300,27528,50457,11748,17038,17198,62791,13517,60583,28903,36612,35562,16485,3041,44932,16001,10474,16415,7359,27411,30096,4932,60863,60346,14078,63895,19364,34086,15967,5444,37235,33198,55855,64417,51233,56282,18521,51548,53175,41827,21937,21633,26748,14178,16221,36603,13835,47783,34260,4485,47062,50393,6271,14925,22518,38082,4075,117,9412,30270,25617,16332,46720,8674,41570,62430,47131,56737,47098,5884,43005,64302,59245,43557,29150,24990,32950,30503,1797,35811,6821,60340,24435,24937,51953,43008,25422,626,27019,59082,57793,19747,18656,37825,20742,41295,24019,46925,7961,10754,54244,20307,33458,38102,60273,57157,17912,41748,42151,54509,63410,60493,60223,4739,62020,35908,1785,12019,61546,17959,36877,33019,57888,61162,57699,57418,23973,24394,16227,44273,49187,26513,16949,22856,49669,4524,9444,38832,3616,42545,492,40439,35978,44916,58107,43815,17268,7821,34624,23270,32000,40947,19395,58245,50778,43243,61329,35769,19933,1309,48987,14308,51292,63226,41964,30956,62864,15788,3772,5994,36518,24742,12250,18263,59122,37088,9369,9290,18381,45587,120,5269,48785,17550,23024,41584,22778,34605,26703,14610,22745,60841,48831,30958,39926,7075,44107,10603,24943,27979,3915,55041,60871,16156,51222,24073,39694,63724,59988,5680,51514,2697,29199,13497,59703,5589,23333,24262,1205,7031,54290,50024,9691,38930,11572,39625,14284,42423,43118,35920,14682,16885,6444,25949,48687,34102,33969,52805,48318,35367,21009,2708,30617,21243,45974,26360,37079,45057,64875,53352,2032,36029,16139,42927,60871,26548,27515,12144,24873,27561,52673,10062,41721,55614,20734,36264,21648,36908,55811,49826,7363,13335,38709,21692,42525,2298,55511,22174,22254,35829,44703,18549,25502,43080,49011,39247,13988,55136,1907,13215,60533,6153,63354,8952,12069,57728,31878,16429,14804,30481,48181,25419,38271,40882,34488,24210,10145,48907,6182,57206,48033,27208,19792,22297,24308,55244,47943,51195,30786,58945,49758,28667,14836,53741,57737,57289,33685,19873,63552,30953,12138,26697,29263,63833,57171,43723,4220,40602,22138,64243,1597,9779,25118,17492,28175,43164,35913,3305,65021,24934,55067,13132,4983,26410,62915,33967,10569,63616,20132,3031,14697,453,59401,14306,63778,49121,38397,456,23441,27010,51381,5080,36023,43709,60722,51693,6285,28597,500,53022,1687,50233,14185,38063,52728,55708,20759,52813,51810,94,43289,49348,44440,51040,27619,52327,22640,48120,6030,55795,59559,20920,9043,11857,42366,52048,7230,47651,41881,39725,38278,63523,31281,32948,13067,15970,31874,50363,19094,15202,57090,29971,8284,19244,64974,35685,19439,36103,48335,35631,32983,44755,59339,9422,63377,36376,41654,42116,39713,13174,37585,57416,28140,17666,64301,12773,24243,29825,20607,8851,4982,16474,42145,13820,11349,64013,51129,23204,16985,6341,55218,29733,23943,962,22673,52367,3527,46547,14572,44914,23061,15564,39285,51100,20773,1107,2277,30914,49086,7209,15148,60840,49057,2666,44547,12791,58827,40013,46756,20522,52589,59259,52846,3422,62335,56893,55593,38258,61588,54915,5536,49018,5239,55277,39935,52535,22689,42601,54678,2277,49092,33011,23223,5288,10831,36624,20207,49538,15605,26482,106,60058,30962,42200,57396,13541,34198,5049,7112,49562,25826,4881,44920,55754,18544,28664,57058,63302,63767,14765,56836,29173,20485,59522,38813,39090,36428,63195,49156,22601,35899,14061,46576,32815,1488,41523,26885,60844,59260,47113,31529,64767,19562,27891,33110,46197,13583,25559,40134,7296,27308,8595,5600,14926,45645,62119,40676,8405,36191,46582,39606,16188,64672,7061,20903,34606,8591,63040,25735,52472,37326,61583,47418,51626,57493,31019,51994,54684,168,1755,27821,21317,23993,10849,20477,55649,3353,18752,35975,47655,45750,28373,9089,5705,46220,45224,25294,46505,58491,43376,27106,51130,10935},
  {32918,53645,10609,61629,62368,48089,50298,6877,19786,59473,14311,54916,495,50054,27834,46687,12231,2458,29906,62548,45830,25365,12589,59413,63973,59990,53260,41131,3023,52970,37111,5146,27489,22391,64062,51479,50456,1240,62201,58148,63417,38115,8001,1007,7065,30343,64743,64054,12286,31983,40698,52104,41133,65190,54277,17826,47460,26,7561,55267,58512,362,33953,33177,19210,1809,51427,43978,10756,28292,54235,45445,5926,50504,26519,31453,16057,40881,12057,34050,9713,52530,30050,28280,46048,41176,43390,29119,50113,60161,32689,29729,27633,16605,54379,54059,50344,30752,2513,39414,24236,60277,51091,30865,54398,35285,16657,51881,4537,44182,59371,1026,44199,19879,11212,33001,7029,51406,5983,5748,33981,26785,39926,55228,2277,53756,2778,43067,22462,56094,26608,36977,61529,47777,31862,48068,26795,33031,26253,3008,8362,22113,43387,54578,59036,34473,62843,32668,35466,34785,31557,32017,47604,12208,51022,58926,40300,60633,60841,27862,18968,60428,44808,52008,23717,15462,2871,64443,44293,54846,28900,58657,47535,6498,34465,18018,5248,41769,56873,40955,31330,48792,51653,43873,24744,54889,19245,58276,10995,10361,44884,8471,55440,57645,64412,36427,41694,12714,56959,13317,59396,59054,17744,26294,34899,64943,26078,32299,18077,16216,48579,38142,54924,44971,7310,28204,14998,9508,26842,52010,52306,60342,58151,8926,61247,29957,64490,52052,29486,56396,65030,32980,34204,37630,59333,54886,31157,23763,32641,20740,33189,52515,18996,48065,48924,45208,57520,18758,24239,32422,62280,2595,51975,43892,12073,60697,21124,13263,23888,28750,38801,43634,20042,6774,48207,2291,62512,65510,50270,40642,20776,3913,62393,226,30657,33188,27599,31492,55488,60555,1965,21758,12190,37346,30647,17167,30742,31280,14553,36910,36634,58104,13087,12420,65447,6439,32775,51101,58268,56031,34061,23336,2560,57527,46789,29345,28055,62917,29286,47029,57501,17548,32816,51208,39932,44049,13257,38332,40098,26882,63540,49793,2366,59738,40693,48262,38373,34988,27851,31405,32026,60118,11049,40157,29575,45305,49952,59895,61331,925,9958,11647,9688,56151,33222,19010,51403,5440,49258,45953,42488,42311,44301,60723,27883,7261,17770,52763,20131,38774,55203,26917,51347,9262,56616,17001,45938,5189,29901,34405,51732,54404,39790,54071,37794,15441,46880,50707,19404,2642,57349,60017,25289,34110,20784,1823,15319,10344,61368,26130,40805,20969,54583,44479,8098,22854,11851,44536,48756,50692,10872,16786,60337,63013,52246,14793,20595,42529,10136,1082,65455,11360,61063,25781,34133,52275,42753,37319,6383,57182,21069,54778,43086,56884,49112,24227,46316,22278,56656,22170,45204,22591,38702,48688,32206,26967,7395,18171,34948,62691,62379,39696,60525,47416,17941,59441,23929,61159,46674,53498,62221,7286,17251,46249,10670,33517,12012,31971,5314,43837,6802,6613,52620,44614,2400,7238,34616,37536,25229,27182,18572,2785,10995,2760,57507,4659,44869,13595,47003,24726,8078,28889,44696,57459,23595,12074,42623,47260,7144,40893,44197,34720,61124,13150,37905,30061,3749,6300,23607,59628,40860,16592,53668,9205,8554,42326,2729,62085,38342,13847,3262,32579,13675,14480,58466,2600,23369,18211,22023,13975,4996,28785,14858,48658,51981,132,43531,3550,13362,41955,15025,10573,28912,60677,54423,39640,62083,28634,22024,20811,19315,25774,10057,54178,43244,33925,62819,29265,48554,57447,15284,4410,32238,32828,32378,52398,30113,58615,22290,28869,30004,18954,55712,18321,58835,25943,36334,25592,59393,11522,45926,17,30077,32044,32481,43052,49685,33256,12825,14410,19772,11051,37264,58911,61769,59734,55234,55638,38805,6053,42761,14443,21507,2545,52402,7183,37891,44644,8117,62404,50302,6503,63819,17158,16869,31259,27095,24308,49926,30625,20637,27944,3214,6053,51233,912,7547,14394,12280,34335,9244,42364,20629,38721,17799,6857,41728,60649,7014,21194,47947,9543,36553,58558,63948,29965,60077,35870,3647,52167,24403,45069,59813,27600,61266,46458,28382,57704,4188,2113,54242,34229,3358,59473,39068,3299,61465,153,55422,57449,46453,5978,1320,5048,7957,58897,56447,55406,8529,52737,45041,52793,56122,42488,41926,55895,28261,40245,35997,34758,56375,51958,43094,17589,32355,28016,48876,3638,47463,62313,31635,7537,17809,14159,56803,8488,24685,42572,15281,4360,12200,11075,19687,35314,39875,51971,9757,53111,26821,7587,18583,54164,48124,13909,23549,58270,43411,30651,6634,18004,3532,59824,61996,57257,23855,14628,57137,50961,30815,19616,27765,33663,34007,23733,60427,26185,30942,25217,41838,37775,27282,10649,13444,24774,19553,59417,54459,27319,19664,1799,54141,40262,57754,3726,48399,53850,47414,38428,517,7431,30659},
  {50603,6559,6947,17828,46919,21301,61270,17103,62941,47064,45898,26410,37266,10340,61606,34366,64053,12567,55739,59063,43200,53697,62943,41374,29972,57626,16009,7044,63498,24503,37088,63075,6323,13285,61906,59999,21383,53217,40206,2852,59137,1481,47627,43033,12178,54184,52020,53750,18275,44835,23411,51093,33447,10955,11029,10818,44133,63564,65434,64184,17476,35230,25400,56143,51194,11172,5461,42553,9474,19719,33605,3554,16777,51041,27521,26845,2177,59289,5783,33888,61715,22801,27176,57072,46196,63875,43403,47643,5001,54799,1163,52185,29441,27303,30919,51371,46582,60207,63098,14757,36482,39232,29485,11596,46966,60581,37864,3622,8214,22407,12111,42967,46205,29251,22817,5994,11246,37808,60827,29272,7169,62267,6602,25892,36671,26618,16549,62840,60696,15462,7904,43510,63549,6222,45014,55912,35931,4718,64675,51230,41187,61722,39079,42817,47306,55200,39526,35345,59746,29145,47812,14149,60948,8964,37476,51198,11179,8572,114,16299,18467,46415,47293,5143,2103,7060,53178,46709,25930,32532,8762,50413,21944,2014,22296,21288,62985,38588,32374,58006,31254,42468,4432,41796,21538,6192,5334,54093,51688,4314,44510,20132,57452,48354,59502,60054,52505,40270,64934,14068,23908,21083,44722,58395,1003,9801,1362,26586,5578,25310,14863,38596,41210,59587,42626,27178,63380,57877,11249,12680,28030,8163,32400,15201,23661,56839,24017,13318,52445,12011,57170,18486,41328,7738,62829,1143,31923,4098,62051,39173,27633,24323,63489,62421,26118,49210,2276,43926,59963,13,6660,50328,12968,42154,40054,53569,42562,22192,31670,53845,33141,16835,6223,46950,49463,59839,4212,34767,18071,7237,58511,11044,16336,35629,47077,56973,27698,58366,3781,12979,26621,54317,12829,25080,34988,22767,21427,15084,16522,35370,42607,21813,55274,32754,10260,27681,3793,41134,23775,53058,26806,33152,14049,62939,29478,32437,55473,42000,5394,7648,59797,14196,35575,9143,27177,21937,30424,30783,44102,53802,21888,32923,32893,45223,14835,32961,23635,14305,7147,44765,41718,4348,39960,2537,59439,3758,54559,26236,43641,1221,21319,2801,3989,42317,20234,50536,41137,5757,17692,34894,62877,52515,5519,37041,39922,5211,10383,24774,39154,38011,51941,43075,39910,38565,16922,50523,40207,45741,25273,1454,21068,53487,12322,2268,12465,25889,42520,53596,28769,57937,25641,4908,49328,9465,21856,62678,46310,57490,61001,45743,35459,30992,57251,47379,9230,4979,44386,49150,27627,28960,48814,17071,9882,27798,62174,38991,15311,55059,38668,17643,58452,12486,25088,53052,39795,19983,64572,17791,49229,29405,2522,20296,53263,42303,44414,50146,48546,48895,28046,56893,31562,30539,23135,5147,1569,4114,49768,51989,14759,18112,46566,16351,22334,14983,25120,48369,23882,26114,52889,35092,64282,19713,7733,43076,48563,58173,16845,54273,22075,27608,39797,33470,49844,35181,36773,43449,26704,37187,63564,35058,25670,13577,13218,22221,35037,308,24511,164,45008,12307,38738,38008,10424,29934,62966,33610,53699,18778,25301,44764,64690,18444,36372,22277,22046,65146,38149,22393,41257,21785,27775,35277,31393,76,21944,47548,34527,26773,45347,37586,18097,34972,62321,24626,10799,27576,35977,16892,42934,50298,45628,20857,29878,42151,56890,49027,16665,18152,25115,17539,22440,14978,54260,24459,26060,36532,63761,36434,48504,8842,61866,27384,51370,12639,8527,13795,9990,6614,61517,31508,28107,43608,4235,44096,60428,1053,48143,2293,47326,46433,56972,26788,12820,32764,7523,32978,33454,55835,37859,43387,3123,53138,38705,53234,43793,57983,5040,65313,42975,7424,8073,31561,31735,38540,11126,11526,44643,9842,53975,31770,10777,24865,7106,17333,44866,33673,7610,10849,36562,32527,55308,29079,36445,51939,53689,24347,54526,58044,33793,22614,18936,43053,64873,10674,23056,465,32539,25504,11002,61855,20359,16362,16602,40846,16033,44740,22201,60074,3013,27085,32612,45650,31924,11439,52023,42633,59628,59717,16993,12452,6282,48255,65039,9201,55352,65440,32208,50997,9256,63257,55927,30340,62409,29479,40548,35979,9303,15235,59647,20006,2227,63993,59827,27146,41500,19002,50624,61304,9848,52922,22061,7141,1190,14670,13183,59851,49221,61546,28732,65313,60174,44210,22119,54881,61506,40430,5396,7563,20376,26002,52246,39409,44381,52123,31909,34162,43617,47218,48459,25996,34701,15922,55510,47468,45327,44644,42862,11323,36347,38578,30370,16543,18130,12254,50102,1431,54384,13360,62195,39394,24872,17221,40248,2704,15304,27331,50647,61974,21115,26454,39103,39111,51881,12266,12924,8888,34937,63744,60614,61294,11966,11198,31542,37475,30108,12192,46965,19492,6067,3842,54516,11021,6669,1257,23783,5386,44107,37938,56315,1583,18516},
  {48892,38672,64091,8589,11822,47709,60865,41402,38394,35243,57826,27242,36318,29311,28766,5031,27017,40747,24453,63774,34649,24568,41602,28070,23332,45305,14305,58292,63396,56994,31868,29395,26412,55075,15516,21320,63911,60364,9033,55475,38279,1009,34619,30163,61156,18932,9069,34524,19533,52138,4582,26465,3381,25588,37720,62036,35861,42350,11214,26684,24310,57797,35804,60003,28799,39245,32522,63043,59033,32326,10134,31945,47755,29594,22976,21097,43137,48777,4593,27903,1592,36971,37397,30371,19423,31591,21639,38014,60186,12461,51934,31846,9368,45784,55759,3773,52497,58667,30416,57910,54724,4419,7447,54482,11333,49353,52660,54305,24918,11962,63802,33186,60539,28946,19658,62553,35891,2074,29950,59637,13459,14184,61864,17161,61895,23224,32633,2128,27477,27321,26724,15264,5731,32205,64864,2289,63282,28129,20851,54678,49809,9438,58571,31195,5745,18552,19174,2844,16760,51970,42594,14849,54834,42654,61910,50063,55346,5920,6865,26604,30373,64251,17196,52587,57086,19300,5672,28486,35639,1144,64117,9137,7372,42116,41074,44371,54617,13745,46599,40968,16038,28974,47876,20933,14608,4210,62697,32094,22391,12191,54862,61468,18378,61504,43755,33295,37306,33829,7623,63592,44175,51973,18616,7237,26186,28775,29487,51519,9757,6171,21481,42867,2150,56808,44446,40900,27741,56895,14617,35301,38550,17414,173,47256,17460,29096,45487,5542,64502,1335,6689,15078,31112,58909,34988,42460,64372,9901,43606,9487,25125,4264,50600,54656,5080,7158,30453,38464,21599,3846,58356,53578,7659,24978,9805,41666,14767,55995,42991,62149,3893,36133,54348,3064,25020,19277,33947,56974,59851,41669,60360,27675,11266,5883,34169,29102,56471,33468,35688,23690,11416,33511,55397,38865,49738,19069,17808,65479,21019,36123,32057,15373,24747,57687,20354,8934,11424,4548,34026,39132,29491,31784,50837,18112,6400,19207,12632,40548,20265,10377,61259,48254,5739,20618,55972,60569,12707,60518,13206,30775,34474,60341,64323,30356,22228,16245,56417,54834,65024,46941,32040,37662,61748,12200,44826,23393,2505,25576,44246,58730,28126,38649,41165,25872,29869,19402,42733,447,38963,14667,46255,3064,45253,48028,19065,45951,52280,33655,55234,58304,29430,6725,1553,45089,48874,23750,46745,7247,19029,37737,23818,60389,35937,50637,53382,17408,49603,14652,41680,10079,35470,5727,16992,58552,41968,47466,26037,55593,35674,3604,41857,46202,59174,64995,54712,53155,43408,38127,18708,17482,31740,2914,54888,37100,36692,18615,53612,19238,55037,3451,18761,48767,28458,41508,42696,54596,26706,61800,46063,61881,10396,12016,7814,51503,10161,5366,60874,12379,53392,6438,57408,7509,11600,30737,18446,58866,17404,60294,16114,12185,20703,31861,44576,35360,30209,45451,1186,57068,6183,18229,26459,40024,37268,24271,31939,1109,42413,56534,7305,36713,1906,33673,16872,55603,3143,37978,55812,55567,6063,22665,22021,24789,64836,58650,37897,11342,62777,29102,52391,21064,33804,43605,7172,51707,22290,2241,3592,2077,61856,16042,18989,57073,50341,50959,38743,15936,16581,49636,50469,8858,30503,10426,8532,7575,63693,41243,44841,26150,40504,20178,23434,1434,49105,3248,49040,40004,2386,46219,58186,3616,55913,16166,11393,27322,1246,27323,37764,16175,17871,45358,65393,32469,51892,19853,59023,3248,51091,51046,6164,18775,13008,33866,63984,42022,57961,3571,58033,18847,38633,37373,60264,51712,19737,54753,20407,20655,54496,31582,17067,35858,20105,18866,1181,17167,5884,26453,50264,18415,34171,14065,34793,17817,37846,35566,25780,43466,10005,48824,6624,38551,5615,19390,15195,37021,16595,33652,32666,42340,9294,38646,10894,3969,51767,37413,1460,54895,26755,32642,60948,55414,26260,56968,12785,56475,45469,23548,28423,32777,45013,19508,25068,58885,25841,20912,41458,35609,40748,6192,53210,19437,37045,3497,35147,41380,59783,41248,32555,54074,10226,54874,15405,27295,5303,15548,23533,41621,54047,25368,50343,43628,43054,46948,2437,18557,9391,6632,33171,39917,24450,37727,30594,3772,30759,27216,24081,6453,18699,15199,56491,26665,51977,26015,2738,51786,42856,27065,26738,21991,50466,47820,47367,5725,13412,22136,17110,35062,267,30517,3178,25483,20821,52269,17437,184,57433,19291,15242,22344,52583,42355,6010,60861,42348,19650,20850,33130,25009,40445,26413,4392,21758,33877,60488,9932,39806,60444,36573,39997,39671,53194,55521,28182,12614,46341,55267,47505,57728,59840,2295,58887,48617,47177,13225,45334,4196,4073,29669,15239,20929,25503,7147,35676,34441,27361,44801,458,1060,26006,49088,11403,941,22593,37171,23263,37009,55918,24934,28203,57742,50694,3213,10461,36347,64975,16574,55748,20234,62766,36891,17759,2129},
} ;

static void test_encode_761xint16_impl(long long impl)
{
  unsigned char *s = test_encode_761xint16_s;
  unsigned char *x = test_encode_761xint16_x;
  unsigned char *s2 = test_encode_761xint16_s2;
  unsigned char *x2 = test_encode_761xint16_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_761xint16_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_761xint16(impl);
    printf("encode_761xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_761xint16_implementation(impl),ntruprime_dispatch_encode_761xint16_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_761xint16;
    printf("encode_761xint16 selected implementation %s compiler %s\n",ntruprime_encode_761xint16_implementation(),ntruprime_encode_761xint16_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_761xint16_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_761xint16_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_761xint16_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_761xint16_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_761xint16_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_761xint16_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_761xint16(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"761xint16")) return;
  storage_encode_761xint16_s = callocplus(crypto_encode_STRBYTES);
  test_encode_761xint16_s = aligned(storage_encode_761xint16_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_761xint16_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_761xint16_x = aligned(storage_encode_761xint16_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_761xint16_s2 = callocplus(maxalloc);
  test_encode_761xint16_s2 = aligned(storage_encode_761xint16_s2,crypto_encode_STRBYTES);
  storage_encode_761xint16_x2 = callocplus(maxalloc);
  test_encode_761xint16_x2 = aligned(storage_encode_761xint16_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_761xint16 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_761xint16();++impl)
      forked(test_encode_761xint16_impl,impl);
    ++test_encode_761xint16_s;
    ++test_encode_761xint16_x;
    ++test_encode_761xint16_s2;
    ++test_encode_761xint16_x2;
  }
  free(storage_encode_761xint16_x2);
  free(storage_encode_761xint16_s2);
  free(storage_encode_761xint16_x);
  free(storage_encode_761xint16_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

