#include "osl/record/csaString.h"
#include "osl/record/csaRecord.h"
#include <cassert>
#include <sstream>

osl::record::csa::
CsaString::CsaString(const char *recordString) : rec(new Record())
{
  std::istringstream 
    iss(recordString);
  InputStream irs(iss);
  irs.load(&*rec);
}

osl::record::csa::
CsaString::~CsaString() 
{
}

osl::Record const& osl::record::csa::
CsaString::getRecord() const
{
  return *rec;
}

const osl::NumEffectState osl::record::csa::
CsaString::getInitialState() const
{
  return NumEffectState(rec->getInitialState());
}


// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
