/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.docking;
import java.util.Hashtable;
import java.awt.*;
import javax.swing.*;

/** A layout adapted to autohide panels.
 * <p> 
 * This layout is like a BorderLayout but corners are always empty
 * (for example, the TOP component starts with an x coordinate equal to the
 * width of the LEFT component).
 *
 * @author Lilian Chamontin, vlsolutions.
 * @version 1.0
 */
public class DockingBorderLayout implements LayoutManager2{
  Component topComp, leftComp, bottomComp, rightComp, centerComp;

  public DockingBorderLayout() {
  }


  public float getLayoutAlignmentX(Container target) {
    return 0.5F;
  }

  public float getLayoutAlignmentY(Container target) {
    return 0.5F;
  }

  public void invalidateLayout(Container target) {
  }

  public Dimension maximumLayoutSize(Container target) {
    return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
  }

  public void addLayoutComponent(Component comp, Object constraints) {
    addLayoutComponent((String)constraints, comp);
  }

  public void removeLayoutComponent(Component comp) {
  }

  public void addLayoutComponent(String name, Component comp) {
    if (name.equals(BorderLayout.NORTH)){
      topComp = comp;
    } else if (name.equals(BorderLayout.EAST)){
      rightComp = comp;
    } else if (name.equals(BorderLayout.SOUTH)){
      bottomComp = comp;
    } else if (name.equals(BorderLayout.WEST)){
      leftComp = comp;
    } else if (name.equals(BorderLayout.CENTER)){
      centerComp = comp;
    } else {
      throw new IllegalArgumentException("wrong constraint");
    }
  }

  public Dimension minimumLayoutSize(Container parent) {
    synchronized (parent.getTreeLock()) {
      Dimension dim = new Dimension(0, 0);

      if (leftComp != null && leftComp.isVisible()) {
        Dimension d = leftComp.getMinimumSize();
        dim.width += d.width;
        dim.height = Math.max(d.height, dim.height);
      }
      if (rightComp != null && rightComp.isVisible()) {
        Dimension d = rightComp.getMinimumSize();
        dim.width += d.width;
        dim.height = Math.max(d.height, dim.height);
      }
      if (centerComp != null && centerComp.isVisible()) {
        Dimension d = centerComp.getMinimumSize();
        dim.width += d.width;
        dim.height = Math.max(d.height, dim.height);
      }
      if (topComp != null && topComp.isVisible()) {
        Dimension d = topComp.getMinimumSize();
        dim.width = Math.max(d.width, dim.width);
        dim.height += d.height;
      }
      if (bottomComp != null && bottomComp.isVisible()) {
        Dimension d = bottomComp.getMinimumSize();
        dim.width = Math.max(d.width, dim.width);
        dim.height += d.height;
      }

      Insets insets = parent.getInsets();
      dim.width += insets.left + insets.right;
      dim.height += insets.top + insets.bottom;

      return dim;
    }
  }

  public Dimension preferredLayoutSize(Container parent) {
    synchronized (parent.getTreeLock()) {
      Dimension dim = new Dimension(0, 0);

      if (leftComp != null && leftComp.isVisible()) {
        Dimension d = leftComp.getPreferredSize();
        dim.width += d.width;
        dim.height = Math.max(d.height, dim.height);
      }
      if (rightComp != null && rightComp.isVisible()) {
        Dimension d = rightComp.getPreferredSize();
        dim.width += d.width;
        dim.height = Math.max(d.height, dim.height);
      }
      if (centerComp != null && centerComp.isVisible()) {
        Dimension d = centerComp.getPreferredSize();
        dim.width += d.width;
        dim.height = Math.max(d.height, dim.height);
      }
      if (topComp != null && topComp.isVisible()) {
        Dimension d = topComp.getPreferredSize();
        dim.width = Math.max(d.width, dim.width);
        dim.height += d.height;
      }
      if (bottomComp != null && bottomComp.isVisible()) {
        Dimension d = bottomComp.getPreferredSize();
        dim.width = Math.max(d.width, dim.width);
        dim.height += d.height;
      }

      Insets insets = parent.getInsets();
      dim.width += insets.left + insets.right;
      dim.height += insets.top + insets.bottom;

      return dim;
    }

  }

  private int getSideWidth(Component comp){
    if (comp == null) return 0;
    if (comp.isVisible()) return comp.getPreferredSize().width;
    return 0;
  }
  private int getSideHeight(Component comp){
    if (comp == null) return 0;
    if (comp.isVisible()) return comp.getPreferredSize().height;
    return 0;
  }

  /** overridden to adjust position (x(top) = width(left), y(left) = height(top)
   */
  public void layoutContainer(Container target) {
    synchronized (target.getTreeLock()) {
      Insets insets = target.getInsets();
      int top = insets.top;
      int bottom = target.getHeight() - insets.bottom;
      int left = insets.left;
      int right = target.getWidth() - insets.right;
      int lw = getSideWidth(leftComp);
      int rw = getSideWidth(rightComp);
      int th = getSideHeight(topComp);
      int bh = getSideHeight(bottomComp);

      if (topComp != null && topComp.isVisible()) {
        topComp.setSize(right - left - lw - rw, topComp.getHeight());
        Dimension d = topComp.getPreferredSize();
        topComp.setBounds(left + lw, top,
            right - left - lw - rw, d.height);
      }

      if (bottomComp != null && bottomComp.isVisible()) {
        bottomComp.setSize(right - left - lw - rw, bottomComp.getHeight());
        Dimension d = bottomComp.getPreferredSize();
        bottomComp.setBounds(left + lw, bottom - d.height,
            right - left - lw - rw , d.height);
      }

      if (rightComp != null && rightComp.isVisible()) {
        rightComp.setSize(rightComp.getWidth(), bottom - top - th - bh);
        Dimension d = rightComp.getPreferredSize();
        rightComp.setBounds(right - d.width,
            top + th, d.width, bottom - top - th - bh);
      }

      if (leftComp != null && leftComp.isVisible()) {
        leftComp.setSize(leftComp.getWidth(), bottom - top);
        Dimension d = leftComp.getPreferredSize();
        leftComp.setBounds(left,
            top + th, d.width, bottom - top - th - bh);
      }
      if (centerComp != null && centerComp.isVisible()) {
        centerComp.setBounds(left + lw, top + th,
            right - left-lw - rw,
            bottom - top - th - bh);
      }
    }
  }


}
