# Copyright 2013 Canonical Ltd.  This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

"""Console-based front-end to maas-test."""

from __future__ import (
    absolute_import,
    print_function,
    unicode_literals,
    )

__metaclass__ = type
__all__ = [
    "run_console",
    ]

import unittest
from maastest import utils


def run_console(testcase, output_stream):
    """Run the tests found on `testcase`, reporting to the console.

    :type testcase: `unittest.TestCase`
    :return: `unittest.TestResult`
    """
    loader = utils.CasesLoader()
    suite = loader.loadTestsFromTestCase(testcase)
    runner = unittest.TextTestRunner(
        verbosity=2, descriptions=False, failfast=True, stream=output_stream)
    return runner.run(suite)
