
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file PaletteColourTechniqueAttributes.h
    \\brief Definition of PaletteColourTechnique Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "PaletteColourTechniqueAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

PaletteColourTechniqueAttributes::PaletteColourTechniqueAttributes():
	palette_(ParameterManager::getString("contour_shade_palette_name"))
	,
	palette_policy_(MagTranslator<string, ListPolicy>().magics("contour_shade_palette_policy"))
	
{
}


PaletteColourTechniqueAttributes::~PaletteColourTechniqueAttributes()
{

}


void PaletteColourTechniqueAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "contour_shade_palette_name", palette_, params);
	
	setAttribute(prefix, "contour_shade_palette_policy", palette_policy_, params);
	
}

void PaletteColourTechniqueAttributes::copy(const PaletteColourTechniqueAttributes& other)
{
	palette_ = other.palette_;
	palette_policy_ = other.palette_policy_;
	
}


bool PaletteColourTechniqueAttributes::accept(const string& node)
{

	if ( magCompare(node, "")  )
		return true;
	
	return false;
}

void PaletteColourTechniqueAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void PaletteColourTechniqueAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " palette = " <<  palette_;
	out << " palette_policy = " <<  palette_policy_;
	
	out << "]" << "\n";
}

void PaletteColourTechniqueAttributes::toxml(ostream& out)  const
{
	out <<  "\"\"";
	out << ", \"contour_shade_palette_name\":";
	niceprint(out,palette_);
	out << ", \"contour_shade_palette_policy\":";
	niceprint(out, palette_policy_);
	
}

static MagicsParameter<string> contour_shade_palette_name("contour_shade_palette_name", "");
static MagicsParameter<string> contour_shade_palette_policy("contour_shade_palette_policy", "lastone");
